function renderSVG (jsonData1,width,height) 
{
	var jsonData = JSON.parse(jsonData1);
	var chartType = jsonData["chartType"];
	var multiAxis = jsonData["multiAxis"];
	var combineChartType  = jsonData["combineChartType"];
	var hasMonthOrWeekGroup=jsonData["hasMonthOrWeekGroup"];
	var overViewReport=jsonData["overViewReport"];
	var sparkline=jsonData["sparkline"];
	if(hasMonthOrWeekGroup!=null && hasMonthOrWeekGroup.equalsIgnoreCase("yes"))
	{
		chartType="line";
	}
	var isCombineChart  = jsonData["combineChart"];
	if(combineChartType != null && combineChartType == 'combinedChart')
	{
		return getCombineTimeLineChartSVG(jsonData,width,height);
	
	}
	else if((isCombineChart!=null && isCombineChart == 'yes') || multiAxis)
	{
		return getCombineChartSVG(jsonData,width,height);
	}
	else
	{
		if(sparkline != undefined && sparkline=='yes')
		{
			return getSparklineChart(jsonData,width,height);
		}
		else if(chartType ==null || chartType == '' || chartType == 'line' || chartType=='stack'  || chartType=='area' || chartType=='xrange') 
		{
			return getTimeLineChartSVG(jsonData,width,height);
		}
		else if(overViewReport != null && overViewReport == 'yes')
		{
			return getChartSVGOverview(jsonData,width,height);
		}
		else if(chartType != null && chartType == 'solidgauge')
		{
			return getHighChartsGuage(jsonData,width,height);
		}
		else
		{
			return getChartSVG(jsonData,width,height);
		}
	}
}
function getSparklineChart(jsonData,width,height)
{
	n = Highcharts.createElement('div', null, null, null, true);  // highcharts line 304
	var timezoneOffsetValue='';
	var chartOptions={
		chart: {
            type: 'column',
            margin: [0, 0, 0, 0],
            plotBorderWidth: 0,
				plotBorderColor : '#C0C0C0',
				ignoreHiddenSeries:false,
				spacing:[20, 5, 0, 5],
				plotShadow: false,
				shadow: false,
				zoomType:'x',
				width:80,
				height:20,
				backgroundColor: 'transparent',
				events: {
					click: function(event) {
						/*if(isFromVirtualDash)
							displayBigGraph(maxUrl);
						else
							sparklineOnclick(maxUrl);*/
					}
				}
        },
        title: {
            text: ''
        },
        credits: {
            enabled: false
        },
        exporting: {
			enabled: false
		},
        xAxis: {
            labels: {
                enabled: false
            },
            tickLength: 0,
            lineWidth: 0,
            maxPadding: 0,
            minPadding: 0
        },
        yAxis: {
            maxPadding: 0,
            minPadding: 0,
            gridLineWidth: 0,
            endOnTick: false,
            lineWidth: 0,
            title: {
                text: null
            },
            labels: {
                enabled: false
            }
        },
        legend: {
            enabled: false
        },
        tooltip: {
            enabled: false
        },
        plotOptions: {
            series: {
             enableMouseTracking: false,
					connectNulls : false,
					smoothed: true,
					lineWidth: 1.5,
					marker: {
						enabled: false
					},
					states: {
					hover: {
						enabled: true
					}
					},
					maxPointWidth:7,
				},
        },
        series: jsonData['DataSet']
	}
	chartOptions.chart.forExport=true;
	chartOptions.chart.renderTo=n;
	Highcharts.setOptions({
		global: {
			timezoneOffset: timezoneOffsetValue
		}
	});
	var chart = new Highcharts.Chart(chartOptions);
	var svg = chart.getSVG (); 
	svg = svg.replace(/(fill|stroke)="rgba\(([ 0-9]+,[ 0-9]+,[ 0-9]+),([ 0-9\.]+)\)"/g,'$1="rgb($2)" $1-opacity="$3"')
	svg = svg.replace("&apos;","'");
	chart.destroy ();
	Highcharts.discardElement (n);
   return svg;
}
function getTimeLineChartSVG(jsonData,width,height)
{
	var toolTipFmt = '';
	var setyaxismin = 'False';
	var timezoneOffsetValue='';
	var timeline_out_format = '';
	var ymax = jsonData['maxRange'];
	var commonmax= jsonData['commonmaxRange']
	timezoneOffsetValue = jsonData['timezoneOffsetValue']
	var fontFamilyVal='Arial';
	if(jsonData["isDoubleByteEnabledManager"] != undefined && jsonData["isDoubleByteEnabledManager"] == true)
	{
		fontFamilyVal='Code2000';
	}
	ymin = jsonData['minRange'];
	fontFamily = jsonData['fontName'];
	fontSize = jsonData['fontsize'];
	startTime = jsonData['lowerLimit'];
	yaxisTitle = jsonData['yLabel'];
	if(yaxisTitle == null || yaxisTitle == '')
		yaxisTitle = jsonData['yAxisLabel'];

	LegendPosition = jsonData['LegendPosition'];
	showLegend = jsonData['showlegendFont'];
	xLabel = jsonData['xLabel'];
	LegendFont = jsonData['LegendFont'];
	chartType = jsonData['chartType'];
	var line_width=jsonData['LineWidth'];
	var reportType=jsonData['reportType'];		
	var s_time_fout = jsonData['TimeFormatOut'];
	var s_showdisconnectedline = jsonData['showdisconnectedline'];
	var isCumulationReport = jsonData['isCapacityCumulationReport'];
	var showdisconnectedline=true;
	if(s_showdisconnectedline != null && s_showdisconnectedline =='No') 
		showdisconnectedline = false;
	yaxisTitle =(yaxisTitle == null || yaxisTitle == '')?'':yaxisTitle;
	YtitleEnable =(yaxisTitle == null || yaxisTitle == '')?false:true;
	commonmax =(commonmax == null || commonmax == 0)?null:commonmax;
	ymax =(ymax == null || ymax == 0)?null:ymax;
	if(yaxisTitle == '%' || yaxisTitle =='(%)')
	{
		if(ymax>90)
			commonmax =(commonmax == null || commonmax == 0)?100:commonmax;

	}
	spacing=[0, 0, 0, 0];
	if(commonmax == null || commonmax == 0)
		commonmax=ymax;
	ymin =(ymin == null )?0:ymin;
	if(ymin ==ymax )
		ymax = ymin+1;
	var mpad = null;
	if(setyaxismin!=null && setyaxismin =='True')
	{
		ymin=null;
		mpad=0;
	}
	if(chartType == 'timeline')
		chartType='line';
	fontFamily=fontFamilyVal;
	LegendFont=fontFamilyVal;
	var bgcolor='rgba(255, 255, 255, 0.85)';
	var seriesCounter = 0;
	var XaixLineWidth=1;
	var YaixLineWidth=0;
	var linecount=0;
	if(!(jsonData['DataSet'] == "" || jsonData['DataSet'] == 'null' || jsonData['DataSet'] == 'undefined' || jsonData['DataSet'] == undefined))
	{
		if(jsonData['DataSet'].length>10 && (LegendPosition == undefined || LegendPosition == 'undefined') ){
			LegendPosition = 'right';
		}
		seriesCounter=jsonData['DataSet'].length;
		if(jsonData['DataSet'].length==1)
		{
			bgcolor=jsonData['DataSet'][0]['color'];
		}
		linecount=jsonData['DataSet'].length;
	}
	yaxisTitle =(yaxisTitle == null || yaxisTitle == '')?jsonData['ylabel']:yaxisTitle;
	line_width =(line_width == null || line_width == '')?1:line_width;
	if(yaxisTitle!=null && yaxisTitle.length>0)
	{
		if(yaxisTitle.length>32){
			var strtt1 = yaxisTitle.substring(32);
			if(strtt1.length>3)
				yaxisTitle = yaxisTitle.substring(0,32)+"...";
		}
	}
	
	if(YtitleEnable==false)
	YtitleEnable =(yaxisTitle == null || yaxisTitle == '')?false:true;

	xLabel =(xLabel == null || xLabel == '')?'':xLabel;
	xtitleEnable =(xLabel == null || xLabel == '')?false:true;
	fontFamily =(fontFamily == null || fontFamily == '')?fontFamilyVal:fontFamily;
	fontSize =(fontSize == null || fontSize == '')?'10px':fontFamily+"px";
	startTime =(startTime == null || startTime == '')?null:startTime;
	LegendPosition =(LegendPosition == null || LegendPosition == '' || LegendPosition == 'top')?'center':LegendPosition;
	LegendFont =(LegendFont == null || LegendFont == '')?fontFamilyVal:LegendFont;
	s_time_fout =(s_time_fout == null || s_time_fout == '')?'HH:mm':s_time_fout;
	timeline_out_format = getTimeLineOutputFormat(s_time_fout);
	legendWidth = (LegendPosition == 'right')?400:400;
	needLegendFormat = (LegendPosition == 'right')?'true':'false';
	maxLegendHeight = (LegendPosition == 'right')?null:37;
	
	var marker_enabled =false;
	var isVMPeakSession = jsonData['isVMPeakSession'];
	if(isVMPeakSession)
	{
		if(timeline_out_format.lastIndexOf(',') > -1)
		{
			timeline_out_format = timeline_out_format.substring(0, timeline_out_format.lastIndexOf(','));
		}
		marker_enabled = true;
	}
	
	maxLegendHeight=45;
	if(((linecount*8)/37)>1)
		maxLegendHeight=37;
	if(linecount<2)
		legendWidth=190;
	valign = (LegendPosition == 'right')?'middle':'top';
	LegendPosition='center';
	if(legendWidth>190 && valign =='top')
		LegendPosition='right';
	var hasMonthOrWeekGroup=jsonData["hasMonthOrWeekGroup"];//..
	if(hasMonthOrWeekGroup != undefined && hasMonthOrWeekGroup!=null && hasMonthOrWeekGroup.equalsIgnoreCase("yes"))
	{
		LegendPosition="center";
	}
	var fillOpacityVal=null;
	if(jsonData['fillOpacityVal'] != undefined)
	{
		fillOpacityVal=parseFloat(jsonData['fillOpacityVal']);
	}

	var chartFor = jsonData['chartFor'];
	var yAxisLabelYval = jsonData['yAxisLabelYval'];
	var xType = 'datetime';
	var stacked = null;	
	var tooltipObj =null;
	over_line_width=line_width-2;
	if(over_line_width == 0)
		over_line_width = line_width
	var yVal = "";
	if(s_time_fout == "HH:mm")
	{
		yVal = 33;
	}
	else
	{
		yVal = 20;
		if(yAxisLabelYval!=null && yAxisLabelYval=='21')
			yVal = 21;
	}
	if(xtitleEnable)
	{
		if(s_time_fout == "HH:mm")
		{
			yVal = 20;
			if(yAxisLabelYval!=null)
				yVal = 28;
		}else
		if(s_time_fout.indexOf("HH:mm:ss")>-1)
		{
			yVal = 60;
			if(yAxisLabelYval!=null)
				yVal = 21;
		}
		else
		{
			if(isCumulationReport != null &&  isCumulationReport != '' && isCumulationReport!=undefined && isCumulationReport!='undefined')
				yVal = 20;
			else
			yVal = 48;
			if(yAxisLabelYval!=null && yAxisLabelYval=='21')
				yVal = 21;
			else if(s_time_fout == "dd-MMM")
				yVal = 20;
		}
	}
	if(xtitleEnable && YtitleEnable)
		spacing=[0, 0, 10, 10];
	if(xtitleEnable )
		spacing=[0, 0, 0, 10];
	if(YtitleEnable )
		spacing=[0, 0, 10, 0];

	var showLegends = false;
	var strShowLeg= jsonData['showLegends'];
	if(strShowLeg!=null && strShowLeg == 'true')
		showLegends= true;
	if(chartType!=null && chartType=='stack')
	{
		chartType = 'area',
		stacked ='normal';
	}
	if(chartType!=null && chartType=='scatter')
	{
		xType = null;
		line_width = null;
		marker_enabled = true;
		tooltipObj ={
					//headerFormat: '',
					pointFormat: yaxisTitle+':  {point.x}<br>'+xLabel+':  {point.y}'
				}
	}
	var yRange=-25;
	
	if (reportType=='TCR')
	{
		spacing=[35, 5, 0, 20];
		yRange=-35;
	}
	//
	var xRange=0;
	if(width>1000)
	{
		if (jsonData['DataSet']!='undefined' && jsonData['DataSet']!=undefined && jsonData['DataSet']!=null && jsonData['DataSet']!='')
		{
			if (jsonData['DataSet'].length==1)
			{
				xRange = 80;
			}
			else if (jsonData['DataSet'].length==2)
			{
				xRange = 280;
			}
			else if (jsonData['DataSet'].length>=3 && jsonData['DataSet'].length<=4)
			{
				xRange = 300;
			}
			else if (jsonData['DataSet'].length>=5 && jsonData['DataSet'].length<=8)
			{
				xRange = 110;
			}
			else if(jsonData['DataSet'].length>8)
			{
				xRange = -10;
			}
		}
	}
	else if(width<1000)
	{
		if (jsonData['DataSet']!='undefined' && jsonData['DataSet']!=undefined && jsonData['DataSet']!=null && jsonData['DataSet']!='')
		{
			if (jsonData['DataSet'].length==1)
			{
				xRange = 80;
			}
			else if (jsonData['DataSet'].length==2)
			{
				xRange = 110;
			}
			else if (jsonData['DataSet'].length>=3 && jsonData['DataSet'].length<=8)
			{
				xRange = 0;
			}
			else if(jsonData['DataSet'].length>8)
			{
				xRange = -10;
			}
		}
	}
	
	var spacing_top = jsonData['spacingTop'];
	var spacing_left = jsonData['spacingLeft'];
	var margin_top = jsonData['marginTop'];
	if (spacing_top==null || spacing_top==undefined || spacing_top=='')
	{
		spacing_top=20;
	}
	if (spacing_left==null || spacing_left==undefined || spacing_left=='')
	{
		spacing_left=5;
	}
	if (margin_top==null || margin_top==undefined || margin_top=='')
	{
		margin_top=20;
	}
	var xAxisRotationAngle=270;
	if(jsonData['overViewReport'] != undefined && jsonData['overViewReport']=='yes')
	{
		xAxisRotationAngle=-60;
	}	
	var forCumulationExcelGraph=false;
	var vertAlign='top';
	var legval=28;
	var itemWidth=null;
	var chartBottom=null;
	var cumationExcelGraph= jsonData['cumationExcelGraph'];
	var cumationGraphPrintPage= jsonData['forCumulationPrint'];
	if(cumationExcelGraph!=null && cumationExcelGraph == 'true')
		forCumulationExcelGraph=true;
	if(cumationGraphPrintPage!=null && cumationGraphPrintPage == 'yes'){
		itemWidth=290;
		maxLegendHeight=null;
		vertAlign='bottom';
		legval=56;
		chartBottom=150;
		legendWidth=870;
		var len=jsonData['DataSet'].length;
		if(len <= 20){
			var chartBottom=(((len/3)*15)+chartBottom);
			height+=chartBottom;
		}
		yRange=0;
	}
	if(forCumulationExcelGraph){
		itemWidth=300;
		maxLegendHeight=null;
		chartBottom=180;
		var chartBottomVal= jsonData['chartBottomVal'];
		if(chartBottomVal !='undefined' && chartBottomVal !=undefined && chartBottomVal!=null && chartBottomVal!='')
			chartBottom=chartBottomVal;
		legendWidth=900;
		vertAlign='bottom';
		legval=56;
		yRange=0;
	}
	var allowDecimalInterval=true;
	var decimalInterval=jsonData['decimalInterval'];
	if(decimalInterval != undefined && decimalInterval != "" && decimalInterval=='false')
	{
		allowDecimalInterval=false;//..
	}
	var chartTitle =jsonData['title'];
	chartTitle =(chartTitle == null || chartTitle == '')?'':chartTitle;
	var chartsubTitle =jsonData['chartsubTitle'];
	chartsubTitle =(chartsubTitle == null || chartsubTitle == '')?'':chartsubTitle;
	var titleYval=-10;
	var chartTop=null;
	if(showLegends){
		yRange=null;
		chartTop=40;
	}
	if(chartTitle != '' || chartsubTitle != ''){
		yRange=null;
		if(showLegends)
			chartTop=45;
	}

	if(legendWidth > width){
		legendWidth=width+50;
		LegendPosition='center';
	}

	var chartTitleAlign =jsonData['chartTitleAlign'];
	chartTitleAlign =(chartTitleAlign == null || chartTitleAlign == '')?'center':chartTitleAlign;
	var chartTitlePosition =jsonData['chartTitlePosition'];
	chartTitlePosition =(chartTitlePosition == null || chartTitlePosition == '')?'top':chartTitlePosition;
	n = Highcharts.createElement('div', null, null, null, true);  // highcharts line 304
    
	var lineColour="#dedede";
	var labelColour="#000000";

	if (jsonData['mailGraphLabelColor']!='undefined' && jsonData['mailGraphLabelColor']!=undefined && jsonData['mailGraphLabelColor']!=null && jsonData['mailGraphLabelColor']!='')
	{
		labelColour = jsonData['mailGraphLabelColor'];
	}
	if (jsonData['mailGraphLineColor']!='undefined' && jsonData['mailGraphLineColor']!=undefined && jsonData['mailGraphLineColor']!=null && jsonData['mailGraphLineColor']!='')
	{
		lineColour = jsonData['mailGraphLineColor'];
	}
    if(ymin == 0.0)
	   ymin = 0;
	
	if(chartType==null || chartType == undefined)
		chartType = 'line';

	var ylabelVal = null;
	if(jsonData['yAxisLabel'] != undefined)
		ylabelVal = jsonData['yAxisLabel'];
	var xRangeArry = null;
	if(jsonData['xRangeArry'] != undefined)
		xRangeArry = jsonData['xRangeArry'];
	var tickintevalVal=null;
	if(chartType!=null && chartType == 'xrange' && jsonData['tickIntervalValue'] != undefined && jsonData['tickIntervalValue'] != '')
		tickintevalVal=jsonData['tickIntervalValue'];
	var plotLineVal = jsonData['DataPlotLineValue'];
	var OutliersColor = jsonData['OutliersColor'];
	var SeriesColor = jsonData['SeriesColor'];
	if(SeriesColor ==  undefined ||  SeriesColor=="")
		SeriesColor = null;
	if(OutliersColor ==  undefined ||  OutliersColor=="")
		OutliersColor = null;
	if(plotLineVal ==  undefined ||  plotLineVal=="")
		plotLineVal = null;
	var chartOptions ={
		chart: {
			plotBorderWidth: 0,
			width:width,
			height:height,
			type : chartType,
			plotBackgroundColor: 'white',
			plotBorderColor : '#e2e2e2',
			backgroundColor:'#ffffff',
			plotShadow: false,
			marginTop:chartTop,
			marginBottom:chartBottom,
			shadow: false,
			padding:0,
			spacing:[20, 10, 5, 5],
			events: {
					load: function(event) {
						$('.highcharts-legend-item rect').attr('height', '8').attr('y', '6');
						$('.highcharts-legend-item rect').attr('width', '8').attr('x', '8');
					}
				}
		},
		yAxis: {
			min: ymin,
			minPadding :mpad,
			max : commonmax,
			gridLineWidth: YaixLineWidth,
			lineWidth: 1,
			border :0,
			startOnTick: false,
			categories:xRangeArry,
			//tickPixelInterval: 50,
			gridLineColor: '#dedede',
			lineColor: lineColour,
			minorGridLineColor: '#dedede',
			tickColor: '#dedede',
			allowDecimals:allowDecimalInterval,
			labels: {
				align: 'right',
				x: -10,
				y: 3,
				formatter: function() {
					var val = this.value;
					if(chartType != undefined && chartType != 'xrange'){
						var val = Highcharts.numberFormat (this.value,4, '.','');
						val = (parseFloat(val));
						
					}
					return val;
				},
				style: {
					color: labelColour,
					fontWeight:'normal',
					fontFamily: fontFamilyVal,
					fontSize: '11px',
					textDecoration: 'none',
					whiteSpace: 'normal'
				},
			},
			title: {
				text: yaxisTitle,
				enabled:YtitleEnable,
				style: {
					color: '#000000',
					fontWeight:'normal',
					fontFamily: fontFamilyVal,
					fontSize: '11px',
					textDecoration: 'none',
					whiteSpace: 'normal' 
				},
			},
			showLastLabel: true,
		},
		xAxis: {
			border :1,
			lineWidth: 1,
			//minPadding:0.02,
			//maxPadding:0.02,
			ordinal: false,
			showLastLabel: true,
			endOnTick: true,
			showFirstLabel: true,
			startOnTick: false,
			type : xType,
			gridLineWidth: XaixLineWidth,
			gridLineColor: '#dedede',
			lineColor: lineColour,
			minorGridLineColor: '#dedede',
			tickColor: '#dedede',
			tickInterval:tickintevalVal,
			tickWidth:0,
			labels: {
				rotation:xAxisRotationAngle,
				//x:5,
				//y:yVal,
				formatter: function() {
					if(xType == null){
						var val = Highcharts.numberFormat (this.value,4, '.','');
						val = (parseFloat(val));
						return  val;
					}else
					return  Highcharts.dateFormat(timeline_out_format, this.value);
				},
				style: {
					color: labelColour,
					fontWeight:'normal',
					fontFamily: fontFamilyVal,
					fontSize: '11px',
					textDecoration: 'none',
					whiteSpace: 'normal'
				},
				overflow: 'justify',
				useHTML: false,
			},
			title: {
				text: xLabel,
				enabled:xtitleEnable,
				style: {
					color: '#000000',
					fontWeight:'normal',
					fontFamily: fontFamilyVal,
					fontSize: '11px',
					textDecoration: 'none',
					whiteSpace: 'normal'
					},
				},
			dateTimeLabelFormats: {
				minute: timeline_out_format,
				hour: timeline_out_format,
				day:timeline_out_format,
				month:timeline_out_format,
				year:timeline_out_format
			}
		},
		plotOptions: {
			series: {
				turboThreshold:5000000,
				threshold: plotLineVal,
				negativeColor: SeriesColor,
				color: OutliersColor,
				connectNulls : showdisconnectedline,
				shadow:false,
				lineWidth : line_width,
				fillOpacity:fillOpacityVal,
				smoothed: true,
				marker: {
					enabled: marker_enabled,
				},
				stacking: stacked,
				states: {
					 hover: {
						enabled: true,
						lineWidth: line_width
					}
				},
			},
			line: {
				shadow: false,
				linewidth :10
			}
		},
		legend: {
			enabled: showLegends,
			verticalAlign: vertAlign, 
			width:legendWidth+20,
			align:LegendPosition, 
			y:yRange,
			x:xRange,
			itemMarginBottom: 4,
			itemDistance:5,
			layout: 'horizontal',
			borderWidth: 0,
			floating: true,
			maxHeight :maxLegendHeight,
			itemWidth:itemWidth,
			symbolWidth: 14,
			symbolHeight: 6,
			squareSymbol: false,
			symbolRadius: 6,
			itemStyle: {
				textAlign: 'Middle',
				color : '#000000',
				fontWeight:'Normal',
				fontFamily: fontFamilyVal,
				fontSize: '12px',
			},
			labelFormatter: function() {
				var retrunvar = this.name;
				if(retrunvar.length>legval && needLegendFormat == 'true')
				{
					c=0;
					strval=''
					while(c<retrunvar.length)
					{
						strval+=retrunvar.substring(c,c+legval)+'<br>';
						c=c+legval;
					}
					retrunvar= strval;
				}
				return retrunvar;
			},
			navigation: {
				arrowSize: 8,
				activeColor: '#858585',
				inactive:'#858585',
				style: {
				    fontWeight: 'bold',
				    color: '#858585',
				    fontSize: '9px'
				}
			},
		},
		rangeSelector: {
			enabled: false
		},
		global: {
			useUTC: true,
			timezoneOffset: timezoneOffsetValue
		},
		time:{
			useUTC: true,
			timezoneOffset: timezoneOffsetValue
		},
		navigator: {
			enabled: false
		},
		scrollbar: {
			enabled: false
		},
		labels :{
			style: {
			color: '#000000',
			fontWeight:'normal',
			fontFamily: fontFamilyVal,
			fontSize: '12px',
			}
		},
		credits: {
			enabled: false
		},
		title: {
			text: chartTitle,
			align: chartTitleAlign,
			verticalAlign:chartTitlePosition,
			offset: '',
			margin: 0,
			y:titleYval,
			style: {
				color: '#000000',
				fontFamily:'Roboto-Bold',
				fontSize: '13px',
				fontWeight:'normal',
				whiteSpace: 'nowrap' 
			}
		},
		subtitle: {
			text: chartsubTitle,
			style: {
				color: '#000000',
				fontFamily:'Roboto-Bold',
				fontSize: '12px',
				fontWeight:'normal',
				whiteSpace: 'nowrap' 
			}
		},
		series: jsonData['DataSet'],
		exporting: {
			enabled: false,
		 },
		tooltip:{
				enabled:false
			}
	}
				

	chartOptions.chart.forExport=true;
	chartOptions.chart.renderTo=n;
	Highcharts.seriesTypes.line.prototype.drawLegendSymbol =  Highcharts.seriesTypes.area.prototype.drawLegendSymbol;
	Highcharts.setOptions({
		global: {
			timezoneOffset: timezoneOffsetValue
		}
	});

   var chart = new Highcharts.Chart(chartOptions);
   var svg = chart.getSVG (); 
	svg = svg.replace(/(fill|stroke)="rgba\(([ 0-9]+,[ 0-9]+,[ 0-9]+),([ 0-9\.]+)\)"/g,'$1="rgb($2)" $1-opacity="$3"')

   chart.destroy ();
	Highcharts.discardElement (n);
   return svg;
}
function getTimeLineOutputFormat(s_time)
{
	var return_s_time_fout ='';
	if(s_time != 'null' && s_time !='')
	{
		s_time = s_time.toLowerCase();
		var symbol = ' ';
		var arrValue = new Array();
		if(s_time.indexOf("-") > -1)
		{
			symbol = '-';
		}else if(s_time.indexOf("/") > -1)
		{
			symbol = '/';
		}else if(s_time.indexOf(".") > -1)
		{
			symbol = '.';
		}
		var aValue = s_time.split(symbol);
		if (aValue !=null && aValue.length >0)
		{
			for (var v = 0; v < aValue.length; v++)
			{
				var value= aValue[v];
				var output = value;
				if(value.lastIndexOf(' ')>-1)
				{
					value = value.substring(0,value.lastIndexOf(' '));					
				}
				if(value!=null && value.indexOf("d")>-1)
				{
					if(value!=null && value == "d")
						output = '%e';
					else if(value!=null && value == "dd")
						output = '%d';
					else if(value!=null && value == "dd,")
						output = '%d,';

				}else if(value!=null && value.indexOf("m")>-1)
				{
					if(value!=null && value=="m")
						output = '%m';
					else if(value!=null && value=="mm")
						output = '%m';
					else if(value!=null && value=="mmm")
						output = '%b';
				}else if (value!=null && value.indexOf("y")>-1)
				{
					if(value!=null && value=="yy")
						output = '%y';
					else if(value!=null && value=="yyyy")
						output = '%Y';
				}
				if (!(value == 'hh:mm' || value == 'hh:mm:ss' ))
				{
					arrValue[v]=output;
				}

			}
		}
		if (arrValue !=null && arrValue.length >1)
		{
			for (var v = 0; v < arrValue.length; v++)
			{
				return_s_time_fout += arrValue[v]+symbol;
			}
			if(return_s_time_fout!=null && endsWith(return_s_time_fout,symbol))
				return_s_time_fout = return_s_time_fout.substring(0,return_s_time_fout.lastIndexOf(symbol));
			return_s_time_fout = return_s_time_fout+", %H:%M";
		}else
			return_s_time_fout='%H:%M';
	}
	return return_s_time_fout;
}
function endsWith(str, suffix) {
    return str.indexOf(suffix, str.length - suffix.length) !== -1;
}
function getChartSVG(jsonData,chartWidth,chartHeight)
{
	   n = Highcharts.createElement('div', null, null, null, true);  // highcharts line 304
		var toolTipFmt = '';
		var timezoneOffsetValue='';
		var chartType = 'bar';
	    var setStacking='normal'
		var setMinPointLength=0;
		var setendOnTick=true;
		var fontFamilyVal='Arial';
		if(jsonData["isDoubleByteEnabledManager"] != undefined && jsonData["isDoubleByteEnabledManager"] == true)
		{
			fontFamilyVal='Code2000';
		}
		var enable_Format=jsonData['enable_Format'];
		var enable_values=jsonData['enable_values'];
		var formatForPieChartVal=jsonData['formatForPieChart'];
		var formatForLegendOnlyPercentage=jsonData['formatForLegendOnlyPercentage'];
		var formatForPieChart="";
		var enableNameandValue=jsonData['enableNameandValueinTooltip'];
		if(enable_Format != null && enable_Format != 'undefined')
		{
			formatForPieChart='{point.name}';
		}
		/*else
		{
			formatForPieChart='{point.name}:{point.percentage:.1f} %';
		}*/
		if(enable_values != null && enable_values != 'undefined')
		{
			formatForPieChart='{point.y}';
		}
		/*else{
			if(formatForPieChart == "")
			formatForPieChart='{point.y}:{point.percentage:.1f} %';
		}*/
		if(formatForPieChartVal != "" && formatForPieChartVal != 'null' && formatForPieChartVal != 'undefined' && formatForPieChartVal != undefined)
            formatForPieChart='{point.name}'+formatForPieChartVal+'{point.percentage:.1f} %';
		if(formatForLegendOnlyPercentage == true || formatForLegendOnlyPercentage== 'true')
		      formatForPieChart='{point.percentage:.1f} %';
		if(enableNameandValue != null && enableNameandValue != 'undefined')
		{
			formatForPieChart='{point.name} {point.y} %';
		}
		if(enable_Format != null && enable_Format != 'undefined' && enable_Format == 'simulator')
		{
			formatForPieChart='{point.percentage:.2f} %';
		}
		if(enable_Format != null && enable_Format != 'undefined' && enable_Format == 'percent')
		{
			formatForPieChart='{point.y}%';
		}
		var insidePos= jsonData['inside'];
		fontFamily = jsonData['fontName'];
		fontSize = jsonData['fontsize'];
		yaxisTitle = jsonData['yAxisLabel'];
		LegendPosition = jsonData['LegendPosition'];
		showLegend = jsonData['showlegendFont'];
		xLabel = jsonData['xAxisLabel'];
		var xLabelText = jsonData['xAxisLabelText'];
		var isExecutiveReport = jsonData['isExecutiveReport'];
		LegendFont = jsonData['LegendFont'];
		chartType = jsonData['chartType'];
		if(chartType == 'linePlain')
			chartType = 'line';
		if(chartType == 'areaPlain')
			chartType = 'area';
		yaxisTitle =(yaxisTitle == null || yaxisTitle == '')?'':yaxisTitle;
		YtitleEnable =(yaxisTitle == null || yaxisTitle == '')?false:true;
		fontFamily=fontFamilyVal;
		LegendFont=fontFamilyVal;
		yaxisTitle =(yaxisTitle == null || yaxisTitle == '')?jsonData['yAxisLabel']:yaxisTitle;
		xLabel =(xLabel == null || xLabel == '')?'':xLabel;
		xLabelText =(xLabelText == null || xLabelText == '')?'':xLabelText;
		titleEnable =(xLabelText == null || xLabelText == '')?false:true;
		fontFamily =(fontFamily == null || fontFamily == '')?fontFamilyVal:fontFamily;
		fontSize =(fontSize == null || fontSize == '')?'10px':fontFamily+"px";
		LegendPosition =(LegendPosition == null || LegendPosition == '' || LegendPosition == 'top')?'center':LegendPosition;
		LegendFont =(LegendFont == null || LegendFont == '')?fontFamilyVal:LegendFont;
		legendWidth = (LegendPosition == 'right')?190:400;
		needLegendFormat = (LegendPosition == 'right')?'true':'false';
		maxLegendHeight = (LegendPosition == 'right')?null:50;
		valign=LegendPosition;
		var showLegends =jsonData['legend'];
		if(showLegends == "" || showLegends == 'null' || showLegends == 'undefined' || showLegends == undefined)
			showLegends=false;
		else if(showLegends == 'true')
			showLegends=true;
		else if(showLegends == 'false')
			showLegends=false;
		if(insidePos == "" || insidePos == 'null' || insidePos == 'undefined' || insidePos == undefined)
			insidePos=false;
		else if(insidePos == 'true')
			insidePos=true;
		var chartTitle =jsonData['title'];
		chartTitle =(chartTitle == null || chartTitle == '')?'':chartTitle;
		var subTitle =jsonData['subTitle'];
		subTitle =(subTitle == null || subTitle == '')?'':subTitle;
		var setGroupPadding=-0.065;
		var setPointPadding=0.1;// default value
		var data=jsonData['DataSet'];
		var rotateDegree=0;
		var dataLabelColor='#FFFFFF';
		var chartSubType=jsonData['chartSubType'];
		var drilDown=jsonData['drildown'];
		var setPointWidth=null;
		var setCursor=null;
		var isUptimeChart=jsonData['uptime'];
		var isReporterHome=jsonData['isReporterHome'];
		var isHomeDuration=jsonData['isHomeDuration'];
		var space =[10, 10, 10, 10];
		var yaixlinewidth=0;
		var xtickwidth=0;
		var ticklength=10;
		var xval=-10;
		var ymax=null;
		var ymin=0;
		var xmin=0;
		var yVal=2;
		var marginTop=20;
		var isHypervisorResoucesChart=jsonData['isHypervisorChart'];
		var showInLegend = false;
		var legendLocation='top'
		
		if(jsonData['LegendPosition']!= null && jsonData['LegendPosition']!= ''){
			 legendLocation = jsonData['LegendPosition'];
		}
		if(isUptimeChart!=null && isUptimeChart=='uptimechart'){
			if(jsonData['LegendPosition']!= null && jsonData['LegendPosition']!= ''){
				 legendLocation = jsonData['LegendPosition'];
			}
		}
		if(!(chartSubType!=null && chartSubType=='stacked'))
			setStacking=null;//..

		ymax = jsonData['ymax'];
		if(ymax == "" || ymax == 'null' || ymax == 'undefined' || ymax == undefined)
			ymax=null;
		
		ymin = jsonData['minRange'];
		if(ymin == "" || ymin == 'null' || ymin == 'undefined' || ymin == undefined)
			ymin=0;
		
		xmin = jsonData['minRangexaxis'];
		if(xmin == "" || xmin == 'null' || xmin == 'undefined' || xmin == undefined)
			xmin=0;


		if(yaxisTitle == '%' || yaxisTitle =='(%)')
			ymax = "100";

		if(!showLegends)
		{
			if(chartSubType!=null && chartSubType=='stacked'){
				if(chartType!=null &&(chartType=='column' || chartType=='waterfall'))
					if(chartTitle == null || chartTitle == '')
						space=[40, 10, 10, 10];
				if(isExecutiveReport!=null && isExecutiveReport)
					space=[20, 10, 10, 10];
			}
		}
		if(drilDown!=null && (drilDown=='sametab'||drilDown=='newtab'))
		{
			setCursor='pointer';
		}
		if(data!=null && data.length>=1)
		{
			var xx=data[0].data;
			if(xx.length==1)
			{
				setGroupPadding=0.2;
				setPointPadding=0.4;
			}
			else if(xx.length>1 && xx.length<=4)
			{
				setGroupPadding=0.2;
				setPointPadding=0.3;
			}
			if(chartType!=null &&(chartType=='column' || chartType=='waterfall'))
			{
				marginTop=null;
				 setPointWidth=27;
					
					if(xx.length>50)
				    {
					setPointWidth=3;
					}
					else if(xx.length>45)
				    {
					setPointWidth=5;
					}
					else if(xx.length>40)
				    {
					setPointWidth=8;
					}
					else if(xx.length>32)
				    {
					setPointWidth=10;
					}
					else if(xx.length>21)
				    {
					setPointWidth=12;
					}
					else if(xx.length>15)
				    {
					setPointWidth=17;
					}
					else if(xx.length>8)
				    {
					setPointWidth=20;
					}
					else if(xx.length<=8)
			        {
					   setGroupPadding=0.2;
					   setPointPadding=0.2;
			        }


					if(isHypervisorResoucesChart==true)
					{
					setPointWidth=12;
					if(yaxisTitle.indexOf('MB')>-1)
							setPointWidth=null;
					var isMonthlyChart=jsonData['isMonthlyChart'];
					if(isMonthlyChart==true)
							setPointWidth=null;
					}

					var isHistoryOfAlarm=jsonData['isHistoryOfAlarm'];
					if((xx.length<=30 &&xx.length>21) && isHistoryOfAlarm == true)
					{
						setPointWidth=15;
					}
			}

		}
		if(isHypervisorResoucesChart==true)
			xval=2;

		var isDataLabelEnable=jsonData['isDataLabelEnabled'];
		var isHomePage=jsonData['isHomePage'];
		var isCombinationLineChart=jsonData['isCombinationLineChart'];
		var setMarkerEnable=true;
		var isEndOnTick=jsonData['endOnTick'];
		var percentEnableTick=jsonData['percentEnableTick'];
		if(isDataLabelEnable==false)
		{
			 isDataLabelEnable=false;
		}
		else if(isDataLabelEnable == "" || isDataLabelEnable == 'null' || isDataLabelEnable == 'undefined' || isDataLabelEnable == undefined)
		{
			if(chartType!='line')
	             isDataLabelEnable=true;
		}
			
		if(chartType!=null && chartType=='pie')
		{
			strpointFormat='';
			dataLabelColor='#2a292a';
		}else
		{
			strpointFormat='<b>:{point.y}</b>';
		}
		if(chartType!=null && (chartType=='column' || chartType=='waterfall' ||chartType=='line' || chartType=='spline' || chartType=='combinedChart' || chartType=='area' || chartType=='areaspline' || chartType=='scatter'))
		{
			rotateDegree=-90;
			if(chartType=='waterfall')
				rotateDegree=-60;
			yVal=20;
			xval=2;
			if(chartSubType!=null && chartSubType=='stacked')
			{
				xtickwidth=1;
				ticklength=5;
			  strpointFormat= '{series.name}: <b>{point.y}</b><br/>';
				if (isHomePage != undefined && isHomePage==true)
				{
					setPointWidth=10;
				}
			}
			else
			{
			strpointFormat='<b>:{point.y}</b>';
			}
		}
		if(chartType!=null && chartType=='bar')
		{
			yaixlinewidth=1;
			if(chartSubType!=null && chartSubType=='stacked')
			{
				dataLabelColor='#FFFFFF';
				setendOnTick=false;
				if(isUptimeChart!=null && isUptimeChart=='uptimechart')
				{
					setPointWidth=21;
					showLegends=true;
				}
				else
				{
					setPointWidth=20;
				}
			}
			else
			{
				dataLabelColor='#2a292a';
				  setMinPointLength=10;
				  setPointWidth=21;
			}
		}
		if(jsonData['needZeroValue'] != undefined && jsonData['needZeroValue'] == 'yes')
		{
			setMinPointLength=3;
		}
		if(jsonData['pointPadding'] != undefined)
		{
			setPointPadding=jsonData['pointPadding'];
		}
		if(jsonData['groupPadding'] != undefined)
		{
			setGroupPadding=jsonData['groupPadding'];
		}
		var isHourWise=false;
		if(jsonData['isHourWise'] != undefined && jsonData['isHourWise'])
			isHourWise = jsonData['isHourWise'];
		if(chartType!=null && chartType=='line')
		{
			setStacking=null;
			strpointFormat= '{series.name}: <b>{point.y}</b><br/>';
	    }
		var fontweight="Normal";
		var fontsize="11px";
		var fontfamily=fontFamilyVal;
		if(chartType!=null && chartType=='pie')
		{
			marginTop=null;
			fontsize="11px"
			fontfamily=fontFamilyVal;
		}
		if(isCombinationLineChart==true)
		{
		setStacking=null;
        setMarkerEnable=false;
	    }
		if(yaxisTitle!=null && (yaxisTitle.indexOf('%')>-1 || yaxisTitle.indexOf('(%)')>-1))
		{
			if(ymax==null)
				setendOnTick=true;
		}
		if(isEndOnTick==false)
		{
			 setendOnTick=false;
		}
		var lablecolor='#2a292a';
		var connColor='#C0C0C0';
		var mychartwidth=chartWidth;
		var mychartheight=chartHeight;
		var isTopNReport=jsonData['isTopNReport'];
		var allowMarginTop=jsonData['allowMarginTop'];
		if(allowMarginTop != null && allowMarginTop !=undefined && allowMarginTop != 'undefined' && allowMarginTop == 'yes' )
		{
			marginTop=jsonData['marginTop'];
		}
		//prakash
		var rotateDegreeForColumn = jsonData['rotateDegreeForColumn'];
		if(rotateDegreeForColumn!=null && rotateDegreeForColumn!=undefined && rotateDegreeForColumn!='undefined' && rotateDegreeForColumn=='yes')
		{
			rotateDegree = 0;
		}
		var xValue = 3;
		var itemMarginTop = 0;
		var adjustSeriesValue = jsonData['adjustSeriesValue'];
		if(adjustSeriesValue!=null && adjustSeriesValue!=undefined && adjustSeriesValue!='undefined' && adjustSeriesValue == 'True')
		{
			xValue = 0;
			itemMarginTop = 2;
		}
		//

		if(chartType!=null && chartType=='bar')
		{
			if(chartSubType==null || chartSubType!='stacked')
				setendOnTick=true;
		}
		if(chartType!=null && (chartType=='line'))
		{
			marginTop=null;
			setendOnTick=false;
		}

		if(percentEnableTick==true)
		{
			 setendOnTick=false;
		}
			
		var jsonXval=jsonData['xval'];
		if(jsonXval != "" && jsonXval != 'null' && jsonXval != 'undefined' && jsonXval != undefined )
		{
			xval=jsonXval;
		}
		var jsonYval=jsonData['yVal'];
		if(jsonYval != "" && jsonYval != 'null' && jsonYval != 'undefined' && jsonYval != undefined )
		{
			yVal=jsonYval;
		}
		var marginTopVal=jsonData['disablemarginTop'];
		if(marginTopVal != "" && marginTopVal != 'null' && marginTopVal != 'undefined' && marginTopVal != undefined && marginTopVal=="true")
		{
			marginTop=null;
		}
		var jsonXval=jsonData['xval'];
		if(jsonXval != "" && jsonXval != 'null' && jsonXval != 'undefined' && jsonXval != undefined )
		{
			xval=jsonXval;
		}
		var pieSize='80%';
		var pieSizeVal=jsonData['pieSize'];
		if(pieSizeVal != "" && pieSizeVal != 'null' && pieSizeVal != 'undefined' && pieSizeVal != undefined )
		{
			pieSize=pieSizeVal;
		}
		var centerlegendPostion=jsonData['centerlegendPostion'];

		var boldYaxisLabel=jsonData['boldYaxisLabel'];
		if(boldYaxisLabel != "" && boldYaxisLabel != 'null' && boldYaxisLabel != 'undefined' && boldYaxisLabel != undefined && boldYaxisLabel=="true" )
		{
			yaxisTitle="<b>"+yaxisTitle+"</b>";
		}
		var tooltipEnable=true
		var enableToolTip=jsonData['enableToolTip'];
		if(enableToolTip != "" && enableToolTip != 'null' && enableToolTip != 'undefined' && enableToolTip != undefined && enableToolTip=="false" )
		{
			tooltipEnable=false;
		}
		var pointRadius=4;
		var pointRadiusVal=jsonData['pointRadius'];
		if(pointRadiusVal != "" && pointRadiusVal != 'null' && pointRadiusVal != 'undefined' && pointRadiusVal != undefined && pointRadiusVal=="false" )
		{
			pointRadius=pointRadiusVal;
		}
		var tooltipPercent=false;
		var enableTooltpPercent=jsonData['enableTooltpPercent'];
		if(enableTooltpPercent != "" && enableTooltpPercent != 'null' && enableTooltpPercent != 'undefined' && enableTooltpPercent != undefined && enableTooltpPercent=="true" )
		{
			tooltipPercent=true;
		}
		if(isUptimeChart!=null && isUptimeChart=='uptimechart')
		{
			showLegends=true;
		}
		var legYval=-10;
		if(chartType!=null && chartType=='pie' && LegendPosition!=null && LegendPosition=='bottom' )
		{
			legYval=10;
		}
		if(jsonData['isVsxUptime']!= null && jsonData['isVsxUptime']!= ''){
			if(jsonData['isVsxUptime'])
			{
				legYval = -33;
			}
		}
		var fromTopEventReport=false;
		var isTopEventReprt=jsonData['fromTopEventReport'];
		if(isTopEventReprt != undefined && isTopEventReprt != "" && isTopEventReprt != 'null' && isTopEventReprt != 'undefined' &&  isTopEventReprt=="yes" )
		{
			fromTopEventReport=true;
		}
		var pieInnerSize='';
		var piechartTitleVAlign=null;
		var piechartTitleY=10;
		var isDoNut = false;
		var isDoNutTitleNeeded = false;
		var isDoNutTitleNeededFlag=jsonData['isDoNutTitleNeeded'];
		if(isDoNutTitleNeededFlag!=null && isDoNutTitleNeededFlag=='true')
			isDoNutTitleNeeded = true;
		var forVCCapacityPlanning=jsonData['forVCCapacityPlanning'];
		if(forVCCapacityPlanning != "" && forVCCapacityPlanning != 'null' && forVCCapacityPlanning != 'undefined' && forVCCapacityPlanning != undefined && forVCCapacityPlanning == 'Yes'){
			setPointWidth=70;
			rotateDegree=0;
			dataLabelColor='#000000';
		}
		//for enable Stacking in Slow Logon Performance report
		var enableGroupingVal=jsonData['enableGrouping'];
		var enableGrouping=true;
		if(enableGroupingVal != "" && enableGroupingVal != 'null' && enableGroupingVal != 'undefined' && enableGroupingVal != undefined && enableGroupingVal == 'true'){
			enableGrouping=false;
		}
		var isDonutWithTitleAlone = false;
		var isDonutWithTitleAloneFlag=jsonData['isDonutWithTitleAlone'];
		if(isDonutWithTitleAloneFlag!=null && isDonutWithTitleAloneFlag=='true')
			isDonutWithTitleAlone = true;

		if(chartType!=null && chartType=='donut')
		{
			chartType='pie';
			isDoNut = true;
			pieSize=jsonData['pieSize'];
			pieInnerSize=jsonData['innerSize'];

			if(pieSize == "" || pieSize == 'null' || pieSize == 'undefined' || pieSize == undefined)
				pieSize='150%';

			if(pieInnerSize == "" || pieInnerSize == 'null' || pieInnerSize == 'undefined' || pieInnerSize == undefined)
				pieInnerSize='100%';

			showLegends =jsonData['showlegend'];
			if(showLegends == "" || showLegends == 'null' || showLegends == 'undefined' || showLegends == undefined)
				showLegends=false;
			marginTop =jsonData['marginTop'];
			if(marginTop == "" || marginTop == 'null' || marginTop == 'undefined' || marginTop == undefined)
				marginTop='10';

			isDataLabelEnable=false;
			var isDataLabelEnableForDonut=jsonData['isDataLabelEnableForDonut'];
			if(isDataLabelEnableForDonut != "" && isDataLabelEnableForDonut != 'null' && isDataLabelEnableForDonut != 'undefined' && isDataLabelEnableForDonut != undefined && isDataLabelEnableForDonut == 'true'){
				isDataLabelEnable=true;
				dataLabelColor='#2a292a';
			}
			mychartheight = jsonData['chartHeight'];
			if(mychartheight == "" || mychartheight == 'null' || mychartheight == 'undefined' || mychartheight == undefined)
				mychartheight=chartHeight;
			mychartwidth = jsonData['chartWidth'];
			if(mychartwidth == "" || mychartwidth == 'null' || mychartwidth == 'undefined' || mychartwidth == undefined)
				mychartwidth=chartWidth;
			piechartTitleVAlign='middle';
			piechartTitleY=0;
		}
		var piechartTitleYY = 5;
		var spacingArry = [0,0,10,0];
		var adjustMarginTop =jsonData['adjustMarginTop'];
		if(adjustMarginTop != undefined && adjustMarginTop != 'null' && adjustMarginTop != 'undefined'){
			if(adjustMarginTop == "yes")
				marginTop=0;
			spacingArry = [0,0,0,0];
		}
		var allowDecimalInterval=true;
		var decimalInterval=jsonData['decimalInterval'];
		if(decimalInterval != undefined && decimalInterval != "" && decimalInterval=='false')
		{
			allowDecimalInterval=false;//..
		}
		var configToReportModule=jsonData['configToReportModule'];
		if(configToReportModule != undefined && configToReportModule != "" && configToReportModule=='True')
		{
			allowDecimalInterval=false;
		}
		var isSystemCapacity=jsonData['isSystemCapacity'];
		var markerEnable = true;
		yaixlinewidth=1;
		var ygridLineWidth=1;
		var xgridLineWidth=0;
		if(isSystemCapacity == true)
		{	
			markerEnable = false;
			yaixlinewidth=1;
			ygridLineWidth=0;
			xgridLineWidth=1;
			xval = 5;
			chartType = 'line';
		}
		var needXtraSpaceforGraph=jsonData['needXtraSpaceforGraph'];
		if(needXtraSpaceforGraph != undefined && needXtraSpaceforGraph != "" && needXtraSpaceforGraph == 'true')
		{
			spacingArry=[10,10,10,20]
		}
		var changeAxisGridLine=jsonData['changeAxisGridLine'];
		if(changeAxisGridLine != undefined && changeAxisGridLine == true){
			ygridLineWidth=0;
			xgridLineWidth=1;
		}
		var showDonutTitleinTop=jsonData['showDonutTitleinTop'];
		if(showDonutTitleinTop != undefined && showDonutTitleinTop != "" && showDonutTitleinTop=='true'){
			piechartTitleVAlign=null;
			piechartTitleYY=15;
		}
		if(isDonutWithTitleAlone)
			piechartTitleYY+=8;
		var disablelineChartMarker=jsonData['disablelineChartMarker'];
		if(disablelineChartMarker!=undefined && disablelineChartMarker!=null && disablelineChartMarker =='true'){
			markerEnable=false;
		}
		var isCitrixCapacityReport=jsonData['isCitrixCapacityReport'];
		if(isCitrixCapacityReport != undefined && isCitrixCapacityReport != "" && isCitrixCapacityReport != 'null' && isCitrixCapacityReport != 'undefined' &&  (isCitrixCapacityReport=="true" || isCitrixCapacityReport==true )){
			setendOnTick=true;
			ymax=null;
		}
		var showLastLabelVal=setendOnTick;
		if(isHomeDuration != undefined && isHomeDuration!=null && isHomeDuration==true && chartType!=null && (chartType == 'line' || chartType == 'spline'))
			showLastLabelVal=true;
		//prakash
		var showLastLabelForLogon = jsonData['showLastLabelForLogon'];
		if(showLastLabelForLogon == true)
		{
			showLastLabelVal = true;
		}
		var forLogonSimulatorLegend = jsonData['forLogonSimulatorLegend'];
		if(forLogonSimulatorLegend == true)
		{ 
			legYval = -35;
		}
		//
		var titlestyle ={
					text: chartTitle,
		            align: 'center',
			     margin:0,
		            verticalAlign: piechartTitleVAlign,
		            y: piechartTitleY,
					style: {
						color : '#000000',
						fontFamily:'Roboto-Bold',
						fontSize: '16px',
						whiteSpace: 'nowrap' 
					}
			};

		var subtitlestyle ={
			style: {
				color:  '#000000',
				fontFamily:'Roboto-Bold',
				fontSize: '13px',
				fontWeight:'normal',
				whiteSpace: 'nowrap' 
			}
		};
		if(isDoNutTitleNeeded){
			subtitlestyle ={
				text: subTitle,
				align: 'center',
				verticalAlign: piechartTitleVAlign,
				//y: piechartTitleY + 10,
				y:15,
				style: {
					color : '#000000',
					fontFamily:'Roboto-Bold',
					fontSize: '16px',
					whiteSpace: 'nowrap' 
				}
			};
		}

		var piechartBorder=0;
		if(isDoNut)
		{
			piechartBorder=1;
			var text = '';
//			var piechartTitleYY = '';
			if(isDoNutTitleNeeded){
				text = chartTitle;
			//	piechartTitleYY = 5;
			}
			else
				piechartTitleYY = piechartTitleY;

			// Change identifier: DonutTitleFontSizeAndVerticalPosition
			// Added two parameters for 'Title Font size' and 'Title vertical position adjuster'

			// Change #DonutTitleFontSizeAndVerticalPosition starts
			var titleFontSize = jsonData['titleFontSizeInPx'] != null ? jsonData['titleFontSizeInPx'] : 16;
			if(!Number.isInteger(titleFontSize))
			{
				titleFontSize = 16;
			}

			var titleVrtclPosAdjstr = jsonData['titleVrtclPosAdjstr'] != null ? jsonData['titleVrtclPosAdjstr'] : 0;
			if(!Number.isInteger(titleVrtclPosAdjstr))
			{
				titleVrtclPosAdjstr = 0;
			}
			// Change #DonutTitleFontSizeAndVerticalPosition ends

			titlestyle= {
						text: text,
						align: 'center',
						verticalAlign: piechartTitleVAlign,
						//y: piechartTitleYY,            // commented as part of the change #DonutTitleFontSizeAndVerticalPosition
						y: piechartTitleYY + parseInt(titleVrtclPosAdjstr), // added as part of the change #DonutTitleFontSizeAndVerticalPosition
						useHTML:false,
						floating: true,
						offset: '',
						margin: 0,
						style: {
							color : '#000000',
							fontFamily:'Roboto-Bold',
							//fontSize: '16px',           // commented as part of the change #DonutTitleFontSizeAndVerticalPosition
							fontSize: titleFontSize + 'px',    // added as part of the change #DonutTitleFontSizeAndVerticalPosition
							whiteSpace: 'nowrap' 
						}
				   }
				}
		 if(ymin == 0.0)
		   ymin = 0;
		var chartOptions = {
			chart:{
				placeValuesInside:0,
				align:'center',
				plotBorderWidth: 0,
				height:chartHeight,
				width:mychartwidth,
				marginTop:marginTop,
				plotBackgroundColor: 'white',
				plotBorderColor : '#e2e2e2',
				backgroundColor:'#ffffff',
				plotShadow: false,
				shadow: false,
				padding:0,
				spacing:spacingArry,
				ignoreHiddenSeries:false,
				type : chartType,
				events: {
					load: function(event) {
						$('.highcharts-legend-item rect').attr('height', '8').attr('y', '6');
						$('.highcharts-legend-item rect').attr('width', '8').attr('x', '8');
					}
				}			
			},
			title:titlestyle ,
			yAxis: {
					min:ymin,
					max:ymax,
					border :0,
					tickWidth:0,
					tickmarkPlacement: 'on',
					tickLength: 5,
					lineWidth:yaixlinewidth,
					gridLineWidth:ygridLineWidth,
					reversedStacks: false,
					gridLineColor: '#e2e2e2',
					lineColor: '#e2e2e2',
					endOnTick:setendOnTick,
					showFirstLabel: true,
					startOnTick: true,
					showLastLabel: showLastLabelVal,
					allowDecimals:allowDecimalInterval,
					labels: {
						 style: {
								color: '#000000',
								fontWeight:'normal',
								fontFamily: fontFamilyVal,
								fontSize: '11px',
								whiteSpace: 'nowrap' 
							},
							formatter: function() {
								var val = Highcharts.numberFormat (this.value,4, '.','');
								val = (parseFloat(val));
								return val;
							}
						},
					title: {
						text: yaxisTitle,
						enabled: YtitleEnable,
						margin:20,
						style: {
							color: '#000000',
							fontWeight:'normal',
							fontFamily: fontFamilyVal,
							fontSize: '11px',
							textDecoration: 'none',
							whiteSpace: 'nowrap' 
							},
						},
						tickPositioner: function(min,max){
						var act = min,
						ticks = [];
						this.tickAmount=1;
						var flag=false;
						var interval=this.tickInterval;
						var second=0;
						if(min==max)
						{
							if(max>1)
								max=max+1;
							else if(max==0){
								max=max+1;
								second=0
								flag=true;
							}
							else
							{
								max=max+0.1;
							}
						}
						var cc=1
						while(act <= max){
							if(cc==2 && flag)
								ticks.push(second);
							else
								ticks.push(act);
							act+= interval;
							cc++;
						}
						if(!flag)
							ticks.push(act);
					  return ticks;  
					},
				},
				xAxis: {
					min: xmin,
					tickmarkPlacement: 'on',
					tickWidth:xtickwidth,
					tickLength: ticklength,
					categories: xLabel,
					gridLineWidth: xgridLineWidth,
					gridLineColor: '#e2e2e2',
					lineColor: '#e2e2e2',
					lineWidth:1,
					//tickPixelInterval:50,
					border :1,
					minPadding:0.02,
					maxPadding:0.02,
					ordinal: false,
					endOnTick: true,
					showFirstLabel: true,
					startOnTick: true,
					labels: {
						rotation:rotateDegree,
						x:xval,
						y:yVal,
						overflow: 'justify',
						useHTML: false,
						 style: {
								color: '#000000',
								fontWeight:'normal',
								fontFamily: fontFamilyVal,
								fontSize: '11px',
								whiteSpace: 'nowrap' 
							},
							formatter: function() {
								var val=this.value;
								//if(fromTopEventReport){
									var val2=val.toString();
									if(val!=null && val.length>20)
									{
										var val2=val.substring(20);
										if(val2.length<=3)
											val = val;
										else if(val2.length <= 20)
											val=val.substring(0,20)+'<br>'+val2;
										else if(val2.length > 20)
											val=val.substring(0,20)+'<br>'+val2.substring(0,20)+'...';
											//val=val.substring(0,32)+'<br>'+val2.substring(0,32)+'<br>'+val2.substring(32)+'...';
									}
									//..
									if(isHourWise && val != null && val.trim().indexOf(" ") != -1)
									{
										val = val.substring(val.lastIndexOf(" ")+1);

									}
									//..
								//}
								return val;
							}
						},
					title: {
						enabled: titleEnable,
						text:xLabelText,
						margin:20,
						style: {
							color: '#000000',
							fontWeight:'normal',
							fontFamily: fontFamilyVal,
							fontSize: '11px',
							whiteSpace: 'nowrap' 
							},
						},
				},
			plotOptions: {
					 pie: {
						shadow: false,
						borderWidth: 0, // border color control
						size: pieSize,
						allowPointSelect: true,
						cursor: setCursor,
						showInLegend: showLegends,
						innerSize:pieInnerSize,
						dataLabels: {
							format:formatForPieChart,
							crop: false,
							overflow: 'none',
							connectorColor: connColor,
							softConnector: false,
							distance:15
						},
					 },
					bar:{
						shadow: false,
						cursor: setCursor,
						borderWidth: 0,
						depth: 0,
						pointWidth:setPointWidth,
						dataLabels:{
							enabled: true,
							crop: false,
							overflow: 'none',
							style: {
								fontWeight:'normal',
								textShadow: false,
								textOutline: false 
							}
						},
					 },
					column:{
						shadow: false,
						cursor: setCursor,
						borderWidth: 0,
						grouping:enableGrouping,
						depth: 0,
						pointWidth:setPointWidth,
					 },
					waterfall:{
						shadow: false,
						cursor: setCursor,
						borderWidth: 0,
						depth: 0,
						grouping:enableGrouping,
						pointWidth:setPointWidth
					},
					line:{
						shadow: false,
						cursor: setCursor,
						marker: {
							   enabled:setMarkerEnable,
								fillColor: '#FFFFFF',
								lineWidth: 0.5,
								lineColor: null ,
								symbol:'circle'
                                },
					 },
					series: {
							shadow: false,
							stacking: setStacking, 
							turboThreshold:5000000,
							borderWidth: piechartBorder,
							depth: 0,
							groupPadding:setGroupPadding,
							pointPadding:setPointPadding,
							dataLabels: {
								enabled: isDataLabelEnable,
								crop: false,
								overflow: 'none',
								inside:insidePos,
								rotation:rotateDegree,
								overflow:'none',
								//x:3,
								x:xValue,
								formatter: function() {
									var val = Highcharts.numberFormat (this.y,4, '.','');
									val = (parseFloat(val));
									return val;
								},
								color:dataLabelColor,
								style: {
									color : dataLabelColor,
									fontFamily: fontFamilyVal,
									fontSize: fontsize,
									fontWeight:'normal',
									textShadow: false,
									textOutline: false 
								}
							},
							states: {
								hover: {
									enabled: false
								}
							},
							minPointLength:setMinPointLength,
							 marker: {
								enabled: markerEnable,
								symbol: 'circle',
								radius: pointRadius
							}
						},
				},
			legend: {
					verticalAlign: legendLocation,
					y: legYval,
					itemDistance:5,
					symbolWidth: 14,
					symbolHeight: 6,
					squareSymbol: false,
					symbolRadius: 6,
					enabled: showLegends,
					align:'center',
					maxHeight :maxLegendHeight,
					itemMarginTop:itemMarginTop,
					itemMarginBottom: 4,
					itemStyle: {
					   textAlign: 'top',
						fontWeight: 'Normal',
						fontFamily:fontFamilyVal,
						fontSize: '10px',
					}, 
					labelFormatter: function() {
						var retrunvar = this.name;
						if(retrunvar.length>28 && needLegendFormat == 'true')
						{
							c=0;
							strval=''
							while(c<retrunvar.length)
							{
								strval+=retrunvar.substring(c,c+28)+'<br>';
								c=c+28;
							}
							retrunvar= strval;
						}
						return retrunvar;
					},
				},
						rangeSelector: {
			enabled: false
		},
		global: {
			useUTC: true,
			timezoneOffset: timezoneOffsetValue
		},
		time:{
			useUTC: true,
			timezoneOffset: timezoneOffsetValue
		},
		navigator: {
			enabled: false
		},
		scrollbar: {
			enabled: false
		},
		labels :{
			style: {
			color: '#000000',
			fontWeight:'normal',
			fontFamily: fontFamilyVal,
			fontSize: '11px',
			whiteSpace: 'nowrap' 
			}
		},
		credits: {
			enabled: false
		},
		subtitle:subtitlestyle,
		series: jsonData['DataSet'],
		exporting: {
			enabled: false,
			filename: 'custom-file-name',
		 },
		tooltip:{
				enabled:false
			}
		}
		var isVMSessionUsage=jsonData['isVMSessionUsage'];	
		if(isVMSessionUsage != 'undefined' && isVMSessionUsage)
		{			
			chartOptions.chart.backgroundColor = '#f2f2f2';
			chartOptions.chart.plotBackgroundColor = '#f2f2f2';
		}
	chartOptions.chart.forExport=true;
	chartOptions.chart.renderTo=n;
	Highcharts.seriesTypes.line.prototype.drawLegendSymbol =  Highcharts.seriesTypes.area.prototype.drawLegendSymbol;
	
	Highcharts.setOptions({
		global: {
			timezoneOffset: timezoneOffsetValue
		}
	});
	var chart = new Highcharts.Chart(chartOptions);
	var svg = chart.getSVG (); 
	svg = svg.replace(/(fill|stroke)="rgba\(([ 0-9]+,[ 0-9]+,[ 0-9]+),([ 0-9\.]+)\)"/g,'$1="rgb($2)" $1-opacity="$3"')
	svg = svg.replace("&apos;","'");

   chart.destroy ();
	Highcharts.discardElement (n);
   return svg;
}
function getCombineTimeLineChartSVG(jsonData,width,height)
{
	var toolTipFmt = '';
	var titleYval=-10;
	var setyaxismin = 'False';
	var timezoneOffsetValue='';
	var timeline_out_format = '';
	var ymax = jsonData['maxRange'];
	var commonmax= jsonData['commonmaxRange'];
	timezoneOffsetValue = jsonData['timezoneOffsetValue'];
	var fontFamilyVal='Arial';
	if(jsonData["isDoubleByteEnabledManager"] != undefined && jsonData["isDoubleByteEnabledManager"] == true)
	{
		fontFamilyVal='Code2000';
	}
	ymin = jsonData['minRange'];
	fontFamily = jsonData['fontName'];
	fontSize = jsonData['fontsize'];
	startTime = jsonData['lowerLimit'];
	yaxisTitle = jsonData['yLabel'];
	LegendPosition = jsonData['LegendPosition'];
	showLegend = jsonData['showlegendFont'];
	xLabel = jsonData['xLabel'];
	LegendFont = jsonData['LegendFont'];
	chartType = jsonData['chartType'];
	var line_width=jsonData['LineWidth'];
	var reportType=jsonData['reportType'];		
	var s_time_fout = jsonData['TimeFormatOut'];
	var s_showdisconnectedline = jsonData['showdisconnectedline'];
	var showdisconnectedline=true;
	if(s_showdisconnectedline != null && s_showdisconnectedline =='No') 
		showdisconnectedline = false;
	yaxisTitle =(yaxisTitle == null || yaxisTitle == '')?'':yaxisTitle;
	YtitleEnable =(yaxisTitle == null || yaxisTitle == '')?false:true;
	commonmax =(commonmax == null || commonmax == 0)?null:commonmax;
	ymax =(ymax == null || ymax == 0)?null:ymax;
	if(yaxisTitle == '%' || yaxisTitle =='(%)')
	{
		if(ymax>90)
			commonmax =(commonmax == null || commonmax == 0)?100:commonmax;

	}
	spacing=[0, 0, 0, 0];
	if(commonmax == null || commonmax == 0)
		commonmax=ymax;
	ymin =(ymin == null )?0:ymin;
	if(ymin ==ymax )
		ymax = ymin+1;
	var mpad = null;
	if(setyaxismin!=null && setyaxismin =='True')
	{
		ymin=null;
		mpad=0;
	}
	if(chartType == 'timeline')
		chartType='line';
	fontFamily=fontFamilyVal;
	LegendFont=fontFamilyVal;
	var bgcolor='rgba(255, 255, 255, 0.85)';
	var seriesCounter = 0;
	var XaixLineWidth=1;
	var YaixLineWidth=0;
	var linecount=0;
	if(!(jsonData['DataSet'] == "" || jsonData['DataSet'] == 'null' || jsonData['DataSet'] == 'undefined' || jsonData['DataSet'] == undefined))
	{
		if(jsonData['DataSet'].length>10 && (LegendPosition == undefined || LegendPosition == 'undefined'))
		{
			LegendPosition = 'right';
		}
		seriesCounter=jsonData['DataSet'].length;
		if(jsonData['DataSet'].length==1)
		{
			bgcolor=jsonData['DataSet'][0]['color'];
		}
		linecount=jsonData['DataSet'].length;
	}
	yaxisTitle =(yaxisTitle == null || yaxisTitle == '')?jsonData['ylabel']:yaxisTitle;
	line_width =(line_width == null || line_width == '')?1:line_width;
	if(yaxisTitle!=null && yaxisTitle.length>0)
	{
		if(yaxisTitle.length>32){
			var strtt1 = yaxisTitle.substring(32);
			if(strtt1.length>3)
				yaxisTitle = yaxisTitle.substring(0,32)+"...";
		}
	}
	
	if(YtitleEnable==false)
	YtitleEnable =(yaxisTitle == null || yaxisTitle == '')?false:true;

	xLabel =(xLabel == null || xLabel == '')?'':xLabel;
	xtitleEnable =(xLabel == null || xLabel == '')?false:true;
	fontFamily =(fontFamily == null || fontFamily == '')?fontFamilyVal:fontFamily;
	fontSize =(fontSize == null || fontSize == '')?'10px':fontFamily+"px";
	startTime =(startTime == null || startTime == '')?null:startTime;
	LegendPosition =(LegendPosition == null || LegendPosition == '' || LegendPosition == 'top')?'center':LegendPosition;
	LegendFont =(LegendFont == null || LegendFont == '')?fontFamilyVal:LegendFont;
	s_time_fout =(s_time_fout == null || s_time_fout == '')?'HH:mm':s_time_fout;
	timeline_out_format = getTimeLineOutputFormat(s_time_fout);
	legendWidth = (LegendPosition == 'right')?400:400;
	needLegendFormat = (LegendPosition == 'right')?'true':'false';
	maxLegendHeight = (LegendPosition == 'right')?null:37;
	var yAxisLabel1 = jsonData['yAxisLabel1'];
	var yAxisLabel2 = jsonData['yAxisLabel2'];
	yAxisLabel1 =(yAxisLabel1 == null || yAxisLabel1 == '')?'':yAxisLabel1;
	yAxisLabel2 =(yAxisLabel2 == null || yAxisLabel2 == '')?'':yAxisLabel2;
	var YtitleEnable1 =(yAxisLabel1 == null || yAxisLabel1 == '')?false:true;
	var YtitleEnable2 =(yAxisLabel2 == null || yAxisLabel2 == '')?false:true;	
	var isVMPeakSession = jsonData['isVMPeakSession'];
	if(isVMPeakSession)
	{
		if(timeline_out_format.lastIndexOf(',') > -1)
		{
			timeline_out_format = timeline_out_format.substring(0, timeline_out_format.lastIndexOf(','));
		}
	}
	
	if(((linecount*8)/37)>1)
		maxLegendHeight=37;
	maxLegendHeight=45;
	if(linecount<2)
		legendWidth=190;
	valign = (LegendPosition == 'right')?'middle':'top';
		LegendPosition='center';
	if(legendWidth>190 && valign =='top')
		LegendPosition='right';
	if(width > 400){
		legendWidth=width-100;
	}
	var chartFor = jsonData['chartFor'];
	var yAxisLabelYval = jsonData['yAxisLabelYval'];
	var xType = 'datetime';
	var stacked = null;
	var marker_enabled =false;
	var tooltipObj =null;
	over_line_width=line_width-2;
	if(over_line_width == 0)
		over_line_width = line_width
	var yVal = "";
	if(s_time_fout == "HH:mm")
	{
		yVal = 33;
	}
	else
	{
		yVal = 51;
		if(yAxisLabelYval!=null && yAxisLabelYval=='21')
			yVal = 21;
	}
	if(xtitleEnable)
	{
		if(s_time_fout == "HH:mm")
		{
			yVal = 20;
			if(yAxisLabelYval!=null)
				yVal = 28;
		}else
		if(s_time_fout.indexOf("HH:mm:ss")>-1)
		{
			yVal = 60;
			if(yAxisLabelYval!=null)
				yVal = 21;
		}
		else
		{
			yVal = 48;
			if(yAxisLabelYval!=null && yAxisLabelYval=='21')
				yVal = 21;
		}
	}
	if(xtitleEnable && YtitleEnable)
		spacing=[0, 0, 10, 10];
	if(xtitleEnable )
		spacing=[0, 0, 0, 10];
	if(YtitleEnable )
		spacing=[0, 0, 10, 0];

	var showLegends = false;
	var strShowLeg= jsonData['showLegends'];
	if(strShowLeg!=null && strShowLeg == 'true')
		showLegends= true;
	if(chartType!=null && chartType=='stack')
	{
		chartType = 'area',
		stacked ='normal';
	}
	if(chartType!=null && chartType=='scatter')
	{
		xType = null;
		line_width = null;
		marker_enabled = true;
		tooltipObj ={
					pointFormat: yaxisTitle+':  {point.x}<br>'+xLabel+':  {point.y}'
				}
	}
	var yRange=-25;
	
	if (reportType=='TCR')
	{
		spacing=[35, 5, 0, 20];
		yRange=-35;
	}
	var xRange=25;
	
	var spacing_top = jsonData['spacingTop'];
	var spacing_left = jsonData['spacingLeft'];
	var margin_top = jsonData['marginTop'];
	if (spacing_top==null || spacing_top==undefined || spacing_top=='')
	{
		spacing_top=20;
	}
	if (spacing_left==null || spacing_left==undefined || spacing_left=='')
	{
		spacing_left=5;
	}
	if (margin_top==null || margin_top==undefined || margin_top=='')
	{
		margin_top=20;
	}
	var allowDecimalInterval=true;
	var decimalInterval=jsonData['decimalInterval'];
	if(decimalInterval != undefined && decimalInterval != "" && decimalInterval=='false')
	{
		allowDecimalInterval=false;//..
	}
	var chartTitle =jsonData['title'];
	chartTitle =(chartTitle == null || chartTitle == '')?'':chartTitle;
	if(showLegends)
		margin_top=40;
	if(chartTitle != '' && showLegends)
		margin_top=40;
	//
	var chartTileAlign =jsonData['chartTileAlign'];
	chartTileAlign =(chartTileAlign == null || chartTileAlign == '')?'center':chartTileAlign;
	var chartTitlePosition =jsonData['chartTitlePosition'];
	chartTitlePosition =(chartTitlePosition == null || chartTitlePosition == '')?'top':chartTitlePosition;
   n = Highcharts.createElement('div', null, null, null, true);  // highcharts line 304
    if(ymin == 0.0)
	   ymin = 0;   
   var chartOptions ={
		chart: {
			plotBorderWidth: 0,
			width:width,
			height:height,
			type : chartType,
			plotBackgroundColor: 'white',
			plotBorderColor : '#e2e2e2',
			backgroundColor:'#ffffff',
			plotShadow: false,
			shadow: false,
			padding:0,
			marginTop:margin_top,
			spacing:[20, 10, 5, 5],
			events: {
					load: function(event) {
						$('.highcharts-legend-item rect').attr('height', '8').attr('y', '8');
						$('.highcharts-legend-item rect').attr('width', '8').attr('x', '8');
					}
				}
		},
		yAxis: [{
					min: ymin,
					minPadding :mpad,
					max : commonmax,
					gridLineWidth: YaixLineWidth,
					gridLineColor: '#e2e2e2',
					lineColor: '#e2e2e2',
					lineWidth: 1,
					allowDecimals:allowDecimalInterval,
					labels: {
						 style: {
							fontFamily: fontFamilyVal,
							fontSize: '10px',
							color : '#000000',
							fontWeight: 'normal',
							whiteSpace: 'nowrap' 
							}
						},
					title: {
						text: yAxisLabel1,
						enabled: YtitleEnable1,
						style: {
							color: '#000000',
							fontWeight:'normal',
							fontFamily: fontFamilyVal,
							fontSize: '11px',
							textDecoration: 'none',
							whiteSpace: 'nowrap' 
							},
						}
				},
			    {
					min: ymin,
					minPadding :mpad,
					max : commonmax,
					gridLineWidth: YaixLineWidth,
					gridLineColor: '#e2e2e2',
					lineColor: '#e2e2e2',
					lineWidth: 1,
					allowDecimals:allowDecimalInterval,
					labels: {
						 style: {
							fontFamily: fontFamilyVal,
							fontSize: '10px',
							color : '#000000',
							fontWeight: 'normal',
							whiteSpace: 'nowrap' 
							}
						},
					title: {
						text: yAxisLabel2,
						enabled: YtitleEnable2,
						rotation:270,
						style: {
							color: '#000000',
							fontWeight:'normal',
							fontFamily: fontFamilyVal,
							fontSize: '11px',
							textDecoration: 'none',
							whiteSpace: 'nowrap' 
							},
						},
					opposite: true,
				}],
		xAxis: {
			border :1,
			lineWidth: 1,
			minPadding:0.02,
			maxPadding:0.02,
			ordinal: false,
			showLastLabel: true,
			endOnTick: true,
			showFirstLabel: true,
			startOnTick: false,
			type : xType,
			gridLineWidth: XaixLineWidth,
			gridLineColor: '#dedede',
			lineColor: '#dedede',
			minorGridLineColor: '#dedede',
			tickColor: '#dedede',
			tickWidth:0,
			labels: {
				rotation:270,
				//x:4,
				//y:yVal,
				formatter: function() {
					if(xType == null){
						var val = Highcharts.numberFormat (this.value,4, '.','');
						val = (parseFloat(val));
						return  val;
					}
					else
					return  Highcharts.dateFormat(timeline_out_format, this.value);
				},
				style: {
					fontWeight:'normal',
					fontFamily: fontFamilyVal,
					fontSize: '12px',
					whiteSpace: 'nowrap' 
				},
				overflow: 'justify',
				useHTML: false,
			},
			title: {
				text: xLabel,
				enabled:xtitleEnable,
				style: {
					color: '#000000',
					fontWeight:'normal',
					fontFamily: fontFamilyVal,
					fontSize: '11px',
					textDecoration: 'none',
					whiteSpace: 'nowrap' 
					},
				},
			dateTimeLabelFormats: {
				minute: timeline_out_format,
				hour: timeline_out_format,
				day:timeline_out_format,
				month:timeline_out_format,
				year:timeline_out_format
			}
		},
		plotOptions: {
			series: {
				connectNulls : showdisconnectedline,
				shadow:false,
				lineWidth : line_width,
				smoothed: true,
				marker: {
					enabled: marker_enabled,
				},
				stacking: stacked,
				states: {
					 hover: {
						enabled: true,
						lineWidth: line_width
					}
				},
			},
			line: {
				shadow: false,
				linewidth :10
			}
		},
		legend: {
			enabled: showLegends,
			verticalAlign: 'top', 
			width:legendWidth+20,
			align:LegendPosition, 
			y:yRange,
			x:xRange,
			itemMarginBottom: 4,
			itemDistance:5,
			layout: 'horizontal',
			borderWidth: 0,
			floating: true,
			maxHeight :maxLegendHeight,
			symbolWidth: 14,
			symbolHeight: 6,
			squareSymbol: false,
			symbolRadius: 6,
			itemStyle: {
				textAlign: 'Middle',
				color : '#000000',
				fontWeight:'Normal',
				fontFamily: fontFamilyVal,
				fontSize: '10px',
				whiteSpace: 'nowrap' 
			},
			labelFormatter: function() {
				var retrunvar = this.name;
				if(retrunvar.length>28 && needLegendFormat == 'true')
				{
					c=0;
					strval=''
					while(c<retrunvar.length)
					{
						strval+=retrunvar.substring(c,c+28)+'<br>';
						c=c+28;
					}
					retrunvar= strval;
				}
				return retrunvar;
			},
			navigation: {
				arrowSize: 8,
				activeColor: '#858585',
				inactive:'#858585',
				style: {
				    fontWeight: 'bold',
				    color: '#858585',
				    fontSize: '9px'
				}
			},
		},
		rangeSelector: {
			enabled: false
		},
		global: {
			useUTC: true,
			timezoneOffset: timezoneOffsetValue
		},
		time:{
			useUTC: true,
			timezoneOffset: timezoneOffsetValue
		},
		navigator: {
			enabled: false
		},
		scrollbar: {
			enabled: false
		},
		labels :{
			style: {
			color: '#000000',
			fontWeight:'normal',
			fontFamily: fontFamilyVal,
			fontSize: '10px',
			whiteSpace: 'nowrap' 
			}
		},
		credits: {
			enabled: false
		},
		title: {
			text: chartTitle,
			align: chartTileAlign,
			verticalAlign: chartTitlePosition,
			offset: '',
			margin: 0,
			style: {
				color : '#000000',
				fontFamily:fontFamilyVal,
				fontSize: '12px',
				whiteSpace: 'nowrap' 
			},
			y:titleYval,
		},
		subtitle: {
			style: {
				color:  '#000000',
				fontWeight:'bold',
				fontFamily:fontFamilyVal,
				fontSize: '11px',
				whiteSpace: 'nowrap' 
			}
		},
		series: jsonData['DataSet'],
		exporting: {
			enabled: false,
		 },
		tooltip:{
				enabled:false
			}
	}
				
	if(jsonData['addMultiAxis'] != undefined && jsonData['addMultiAxis'] != '' && jsonData['addMultiAxis'] =='true'){
		var yAxisLabel = jsonData['yAxisLabel3'];
				chartOptions.yAxis[2]=  {
					min: ymin,
					minPadding :mpad,
					gridLineWidth: YaixLineWidth,
					gridLineColor: '#e5e5e5',
					lineColor: '#e5e5e5',
					lineWidth: 1,
					labels: {
						 style: {
							fontFamily: fontFamily,
							fontSize: '10px',
							color : '#636363',
							fontWeight: 'Regular',
							}
						},
					title: {
						text: yAxisLabel,
						enabled: YtitleEnable2,
						rotation:270,
						x:0,
						style: {
							color : '#636363',
							fontWeight: 'bold',
							fontSize: '11px',
							},
						},
					opposite: true,
				}
			}
		if(isVMPeakSession)
		{
			chartOptions.xAxis.tickInterval = 86400000;
			chartOptions.chart.type = 'line';
		}

	chartOptions.chart.forExport=true;
	chartOptions.chart.renderTo=n;
	Highcharts.seriesTypes.line.prototype.drawLegendSymbol =  Highcharts.seriesTypes.area.prototype.drawLegendSymbol;

	Highcharts.setOptions({
		global: {
			timezoneOffset: timezoneOffsetValue
		}
	});

   var chart = new Highcharts.Chart(chartOptions);
   var svg = chart.getSVG (); 
	svg = svg.replace(/(fill|stroke)="rgba\(([ 0-9]+,[ 0-9]+,[ 0-9]+),([ 0-9\.]+)\)"/g,'$1="rgb($2)" $1-opacity="$3"')

   chart.destroy ();
	Highcharts.discardElement (n);
   return svg;
}

function getCombineChartSVG(jsonData,chartWidth,chartHeight)
{
	   n = Highcharts.createElement('div', null, null, null, true);  // highcharts line 304
		var toolTipFmt = '';
		var timezoneOffsetValue='';
		var chartType = 'bar';
	    var setStacking='normal';
		var setMinPointLength=0;
		var setendOnTick=true;
		var fontFamilyVal='Arial';
		if(jsonData["isDoubleByteEnabledManager"] != undefined && jsonData["isDoubleByteEnabledManager"] == true)
		{
			fontFamilyVal='Code2000';
		}
		var enable_Format=jsonData['enable_Format'];
		var enable_values=jsonData['enable_values'];
		var formatForPieChartVal=jsonData['formatForPieChart'];
		var formatForLegendOnlyPercentage=jsonData['formatForLegendOnlyPercentage'];
		var formatForPieChart="";
		if(enable_Format != null && enable_Format != 'undefined')
		{
			enable_Format="";
			formatForPieChart='{point.name}';
		}else{
			formatForPieChart='{point.name}:{point.percentage:.1f} %';
		}

		if(enable_values != null && enable_values != 'undefined')
		{
			enable_Format="";
			formatForPieChart='{point.y}';
		}else{
			if(formatForPieChart == "")
				formatForPieChart='{point.y}:{point.percentage:.1f} %';
		}
		if(formatForPieChartVal != "" && formatForPieChartVal != 'null' && formatForPieChartVal != 'undefined' && formatForPieChartVal != undefined)
            formatForPieChart='{point.name}'+formatForPieChartVal+'{point.percentage:.1f} %';
		if(formatForLegendOnlyPercentage == true || formatForLegendOnlyPercentage== 'true')
		      formatForPieChart='{point.percentage:.1f} %';

		var insidePos= jsonData['inside'];
		fontFamily = jsonData['fontName'];
		fontSize = jsonData['fontsize'];
		yaxisTitle = jsonData['yAxisLabel'];
		LegendPosition = jsonData['LegendPosition'];
		showLegend = jsonData['showlegendFont'];
		xLabel = jsonData['xAxisLabel'];
		var xLabelText = jsonData['xAxisLabelText'];
		var isExecutiveReport = jsonData['isExecutiveReport'];
		LegendFont = jsonData['LegendFont'];
		chartType = jsonData['chartType'];
		if(chartType == 'linePlain')
			chartType = 'line';
		yaxisTitle =(yaxisTitle == null || yaxisTitle == '')?'':yaxisTitle;
		YtitleEnable =(yaxisTitle == null || yaxisTitle == '')?false:true;
		fontFamily=fontFamilyVal;
		LegendFont=fontFamilyVal;
		yaxisTitle =(yaxisTitle == null || yaxisTitle == '')?jsonData['yAxisLabel']:yaxisTitle;
		xLabel =(xLabel == null || xLabel == '')?'':xLabel;
		xLabelText =(xLabelText == null || xLabelText == '')?'':xLabelText;
		titleEnable =(xLabelText == null || xLabelText == '')?false:true;
		fontFamily =(fontFamily == null || fontFamily == '')?fontFamilyVal:fontFamily;
		fontSize =(fontSize == null || fontSize == '')?'10px':fontFamily+"px";
		LegendPosition =(LegendPosition == null || LegendPosition == '' || LegendPosition == 'top')?'center':LegendPosition;
		LegendFont =(LegendFont == null || LegendFont == '')?fontFamilyVal:LegendFont;
		legendWidth = (LegendPosition == 'right')?190:400;
		needLegendFormat = (LegendPosition == 'right')?'true':'false';
		maxLegendHeight = (LegendPosition == 'right')?null:50;
		valign=LegendPosition;
		var showLegends =jsonData['legend'];
		if(showLegends == "" || showLegends == 'null' || showLegends == 'undefined' || showLegends == undefined)
			showLegends=false;
		else if(showLegends == 'true')
			showLegends=true;
		else if(showLegends == 'false')
			showLegends=false;
		if(insidePos == "" || insidePos == 'null' || insidePos == 'undefined' || insidePos == undefined)
			insidePos=false;
		else if(insidePos == 'true')
			insidePos=true;
		var chartTitle =jsonData['title'];
		chartTitle =(chartTitle == null || chartTitle == '')?'':chartTitle;
		var setGroupPadding=-0.065;
		var setPointPadding=0.1;// default value
		var data=jsonData['DataSet'];
		var rotateDegree=0;
		var dataLabelColor='#FFFFFF';
		var chartSubType=jsonData['chartSubType'];
		var drilDown=jsonData['drildown'];
		var setPointWidth=null;
		var setCursor=null;
		var isUptimeChart=jsonData['uptime'];
		var isReporterHome=jsonData['isReporterHome'];
		var space =[10, 10, 10, 10];
		var yaixlinewidth=0;
		var xtickwidth=0;
		var ticklength=10;
		var xval=-10;
		var ymax=null;
		var yVal=2;
		var isHypervisorResoucesChart=jsonData['isHypervisorChart'];
		var showInLegend = false;
		var legendLocation='top';
		var yAxisLabel1 = jsonData['yAxisLabel1'];
		var yAxisLabel2 = jsonData['yAxisLabel2'];
		yAxisLabel1 =(yAxisLabel1 == null || yAxisLabel1 == '')?'':yAxisLabel1;
		yAxisLabel2 =(yAxisLabel2 == null || yAxisLabel2 == '')?'':yAxisLabel2;
		var YtitleEnable1 =(yAxisLabel1 == null || yAxisLabel1 == '')?false:true;
		var YtitleEnable2 =(yAxisLabel2 == null || yAxisLabel2 == '')?false:true;
		
		if(jsonData['LegendPosition']!= null && jsonData['LegendPosition']!= ''){
			 legendLocation = jsonData['LegendPosition'];
		}
		if(isUptimeChart!=null && isUptimeChart=='uptimechart'){
			if(jsonData['LegendPosition']!= null && jsonData['LegendPosition']!= ''){
				 legendLocation = jsonData['LegendPosition'];
			}
		}

		ymax = jsonData['ymax'];
		if(ymax == "" || ymax == 'null' || ymax == 'undefined' || ymax == undefined)
			ymax=null;
		if(yaxisTitle == '%' || yaxisTitle =='(%)')
			ymax = "100";

		if(!(chartSubType!=null && chartSubType=='stacked'))
			setStacking=null;//..
		if(!showLegends)
		{
			if(chartSubType!=null && chartSubType=='stacked'){
				if(chartType!=null &&chartType=='column')
					if(chartTitle == null || chartTitle == '')
						space=[40, 10, 10, 10];
				if(isExecutiveReport!=null && isExecutiveReport)
					space=[20, 10, 10, 10];
			}
		}
		if(drilDown!=null && (drilDown=='sametab'||drilDown=='newtab'))
		{
			setCursor='pointer';
		}
		if(data!=null && data.length>=1)
		{
			var xx=data[0].data;
			if(xx.length==1)
			{
				setGroupPadding=0.2;
				setPointPadding=0.4;
			}
			else if(xx.length>1 && xx.length<=4)
			{
				setGroupPadding=0.2;
				setPointPadding=0.3;
			}
				 if(chartType!=null && (chartType=='column' || chartType=='combinedChart'))
			{
				//setPointWidth=27;
				setPointWidth=20;//..
					if(xx.length>45)
				    {
					setPointWidth=5;
					}
					else if(xx.length>40)
				    {
					setPointWidth=8;
					}
					else if(xx.length>32)
				    {
					setPointWidth=10;
					}
					else if(xx.length>21)
				    {
					setPointWidth=12;
					}
					else if(xx.length>15)
				    {
					setPointWidth=17;
					}
					else if(xx.length>8)
				    {
					setPointWidth=20;
					}
					else if(xx.length<=8)
			        {
					   setGroupPadding=0.2;
					   setPointPadding=0.2;
			        }


					if(isHypervisorResoucesChart==true)
					{
					setPointWidth=12;
					if(yaxisTitle.indexOf('MB')>-1)
							setPointWidth=null;
					var isMonthlyChart=jsonData['isMonthlyChart'];
					if(isMonthlyChart==true)
							setPointWidth=null;
					}
			}

		}
		var yAxisLabel2Color='#000000';
		if(jsonData.yAxisLabel2Color != undefined)
			yAxisLabel2Color = jsonData['yAxisLabel2Color'];
		if(isHypervisorResoucesChart==true)
			xval=2;

		var isDataLabelEnable=jsonData['isDataLabelEnabled'];
		var isCombinationLineChart=jsonData['isCombinationLineChart'];
		var setMarkerEnable=true;
		var isEndOnTick=jsonData['endOnTick'];
		var percentEnableTick=jsonData['percentEnableTick'];
		if(isDataLabelEnable==false)
		{
			 isDataLabelEnable=false;
		}
		else if(isDataLabelEnable == "" || isDataLabelEnable == 'null' || isDataLabelEnable == 'undefined' || isDataLabelEnable == undefined)
		{
             isDataLabelEnable=true;
		}
			
		if(chartType!=null && chartType=='pie')
		{
			strpointFormat='';
			dataLabelColor='#2a292a';
		}
		else
		{
			strpointFormat='<b>:{point.y}</b>';
		}
		if(chartType!=null && chartType=='combinedChart')
		{
			rotateDegree=270;
			xval=5;
			yVal=15;
		}
		if(jsonData['rotationAngle'] != undefined)//..
		{
			rotateDegree=jsonData['rotationAngle'];
			rotateDegree=parseFloat(rotateDegree);
		}
		if(chartType!=null && (chartType=='column' ||chartType=='line'))
		{
			rotateDegree=-90;
			yVal=20;
			if(chartSubType!=null && chartSubType=='stacked')
			{
				xtickwidth=1;
				ticklength=5;
				xval=2;
			  strpointFormat= '{series.name}: <b>{point.y}</b><br/>';
			}
			else
			{
			strpointFormat='<b>:{point.y}</b>';
			}
		}
		if(chartType!=null && chartType=='bar')
		{
			yaixlinewidth=1;
			if(chartSubType!=null && chartSubType=='stacked')
			{
				dataLabelColor='#FFFFFF';
				setendOnTick=false;
				if(isUptimeChart!=null && isUptimeChart=='uptimechart')
				{
					setPointWidth=21;
					showLegends=true;
				}
				else
				{
					setPointWidth=20;
				}
			}
			else
			{
				dataLabelColor='#2a292a';
				  setMinPointLength=10;
				  setPointWidth=21;
			}
		}
		if(jsonData['needZeroValue'] != undefined && jsonData['needZeroValue'] == 'yes')
		{
			setMinPointLength=3;
		}
		if(jsonData['pointPadding'] != undefined)
		{
			setPointPadding=jsonData['pointPadding'];
		}
		if(jsonData['groupPadding'] != undefined)
		{
			setGroupPadding=jsonData['groupPadding'];
		}
		var isHourWise=false;
		if(jsonData['isHourWise'] != undefined && jsonData['isHourWise'])
			isHourWise = jsonData['isHourWise'];
		if(chartType!=null && chartType=='line')
		{
			setStacking=null;
			strpointFormat= '{series.name}: <b>{point.y}</b><br/>';
	    }
		var fontweight="Normal";
		var fontsize="11px";
		var fontfamily=fontFamilyVal;
		if(chartType!=null && chartType=='pie')
		{
			fontsize="11px"
			fontfamily=fontFamilyVal;
		}
		if(isCombinationLineChart==true)
		{
			setStacking=null;
			setMarkerEnable=false;
	    }
		if(chartType!=null && chartType=='combinedChart')
		{
			setMarkerEnable=false;
	    }
		if(yaxisTitle!=null && (yaxisTitle.indexOf('%')>-1 || yaxisTitle.indexOf('(%)')>-1))
		{
			if(ymax==null)
				setendOnTick=true;
		}
		if(isEndOnTick==false)
		{
			 setendOnTick=false;
		}
		var lablecolor='#2a292a';
		var connColor='#C0C0C0';
		var mychartwidth=chartWidth;
		var mychartheight=chartHeight;
		var marginTop=20;
		var isTopNReport=jsonData['isTopNReport'];

		if(chartType!=null && chartType=='bar')
		{
			if(chartSubType==null || chartSubType!='stacked')
				setendOnTick=true;
		}
		if(chartType!=null && (chartType=='line'))
		{
			setendOnTick=false;
		}

		if(percentEnableTick==true)
		{
			 setendOnTick=false;
		}
			
		var jsonXval=jsonData['xval'];
		if(jsonXval != "" && jsonXval != 'null' && jsonXval != 'undefined' && jsonXval != undefined )
		{
			xval=jsonXval;
		}
		var jsonYval=jsonData['yVal'];
		if(jsonYval != "" && jsonYval != 'null' && jsonYval != 'undefined' && jsonYval != undefined )
		{
			yVal=jsonYval;
		}
		var marginTopVal=jsonData['disablemarginTop'];
		if(marginTopVal != "" && marginTopVal != 'null' && marginTopVal != 'undefined' && marginTopVal != undefined && marginTopVal=="true")
		{
			marginTop=null;
		}
		var jsonXval=jsonData['xval'];
		if(jsonXval != "" && jsonXval != 'null' && jsonXval != 'undefined' && jsonXval != undefined )
		{
			xval=jsonXval;
		}
		var pieSize='80%';
		var pieSizeVal=jsonData['pieSize'];
		if(pieSizeVal != "" && pieSizeVal != 'null' && pieSizeVal != 'undefined' && pieSizeVal != undefined )
		{
			pieSize=pieSizeVal;
		}
		var centerlegendPostion=jsonData['centerlegendPostion'];

		var boldYaxisLabel=jsonData['boldYaxisLabel'];
		if(boldYaxisLabel != "" && boldYaxisLabel != 'null' && boldYaxisLabel != 'undefined' && boldYaxisLabel != undefined && boldYaxisLabel=="true" )
		{
			yaxisTitle="<b>"+yaxisTitle+"</b>";
		}
		var tooltipEnable=true
		var enableToolTip=jsonData['enableToolTip'];
		if(enableToolTip != "" && enableToolTip != 'null' && enableToolTip != 'undefined' && enableToolTip != undefined && enableToolTip=="false" )
		{
			tooltipEnable=false;
		}
		var pointRadius=4;
		var pointRadiusVal=jsonData['pointRadius'];
		if(pointRadiusVal != "" && pointRadiusVal != 'null' && pointRadiusVal != 'undefined' && pointRadiusVal != undefined && pointRadiusVal=="false" )
		{
			pointRadius=pointRadiusVal;
		}
		var tooltipPercent=false;
		var enableTooltpPercent=jsonData['enableTooltpPercent'];
		if(enableTooltpPercent != "" && enableTooltpPercent != 'null' && enableTooltpPercent != 'undefined' && enableTooltpPercent != undefined && enableTooltpPercent=="true" )
		{
			tooltipPercent=true;
		}
		if(isUptimeChart!=null && isUptimeChart=='uptimechart')
		{
			showLegends=true;
		}
		var legYRange=-10;
		if(showLegends){
			marginTop=40;
			legYRange=-60;
		}
		var pieInnerSize='';
		var piechartTitleVAlign=null;
		var piechartTitleY=10;
		var isDoNut = false;
		if(chartType!=null && chartType=='donut')
		{
			chartType='pie';
			isDoNut = true;
			pieSize=jsonData['pieSize'];
			pieInnerSize=jsonData['innerSize'];

			if(pieSize == "" || pieSize == 'null' || pieSize == 'undefined' || pieSize == undefined)
				pieSize='150%';

			if(pieInnerSize == "" || pieInnerSize == 'null' || pieInnerSize == 'undefined' || pieInnerSize == undefined)
				pieInnerSize='100%';

			showLegends =jsonData['showlegend'];
			if(showLegends == "" || showLegends == 'null' || showLegends == 'undefined' || showLegends == undefined)
				showLegends=false;
			marginTop =jsonData['marginTop'];
			if(marginTop == "" || marginTop == 'null' || marginTop == 'undefined' || marginTop == undefined)
				marginTop='10';

			isDataLabelEnable=false;
			mychartheight = jsonData['chartHeight'];
			if(mychartheight == "" || mychartheight == 'null' || mychartheight == 'undefined' || mychartheight == undefined)
				mychartheight=chartHeight;
			mychartwidth = jsonData['chartWidth'];
			if(mychartwidth == "" || mychartwidth == 'null' || mychartwidth == 'undefined' || mychartwidth == undefined)
				mychartwidth=chartWidth;
			piechartTitleVAlign='middle';
			piechartTitleY=0;
		}
		var allowDecimalInterval=true;
		var decimalInterval=jsonData['decimalInterval'];
		if(decimalInterval != undefined && decimalInterval != "" && decimalInterval=='false')
		{
			allowDecimalInterval=false;//..
		}
		var titlestyle ={
				text: chartTitle,
		            align: 'center',
		            verticalAlign: piechartTitleVAlign,
		            y: piechartTitleY
			};
		if(isDoNut)
		{
			titlestyle= {
					   text: chartTitle,
						align: 'center',
						verticalAlign: piechartTitleVAlign,
						y: piechartTitleY,
					   useHTML:false,
						floating: true,
						offset: '',
						margin: 0,
						style: {
							color : '#000000',
							fontFamily:'Roboto-Bold',
							fontSize: '16px',
							whiteSpace: 'nowrap' 
						}
				   }
				}
		var chartOptions = {
			chart:{
				placeValuesInside:0,
				align:'center',
				plotBorderWidth: 0,
				height:mychartheight,
				width:mychartwidth,
				plotBackgroundColor: 'white',
				plotBorderColor : '#e2e2e2',
				backgroundColor:'#ffffff',
				plotShadow: false,
				shadow: false,
				padding:0,
				marginTop:marginTop,
				ignoreHiddenSeries:false,
				type : chartType,
				events: {
					load: function(event) {
						$('.highcharts-legend-item rect').attr('height', '8').attr('y', '8');
						$('.highcharts-legend-item rect').attr('width', '8').attr('x', '8');
					}
				}
			},
			title:titlestyle ,
			yAxis: [{
					min: 0,
					max:ymax,
					tickWidth:0,
					tickmarkPlacement: 'on',
					tickLength: 5,
					lineWidth:yaixlinewidth,
					gridLineColor: '#e2e2e2',
					lineColor: '#e2e2e2',
					endOnTick:setendOnTick,
					reversedStacks: false,
					lineWidth:1,
					allowDecimals:allowDecimalInterval,			
					labels: {
						 style: {
								color : '#000000',
								fontWeight: 'Normal',
								fontFamily: fontFamilyVal,
								fontSize: '10px',
								whiteSpace: 'nowrap' 
							},
							formatter: function() {
									var val = Highcharts.numberFormat (this.value,4, '.','');
									val = (parseFloat(val));
									return val;
							}
						},
					title: {
						text: yAxisLabel1,
						enabled: YtitleEnable1,
						style: {
							color: '#000000',
							fontWeight:'normal',
							fontFamily: fontFamilyVal,
							fontSize: '11px',
							textDecoration: 'none',
							whiteSpace: 'nowrap' 
							},
						},
				},
				{
					min: 0,
					max:ymax,
					tickWidth:0,
					tickmarkPlacement: 'on',
					tickLength: 5,
					lineWidth:yaixlinewidth,
					gridLineColor: '#e2e2e2',
					lineColor: '#e2e2e2',
					endOnTick:setendOnTick,
					reversedStacks: false,
					lineWidth:1,
					allowDecimals:allowDecimalInterval,
					labels: {
						 style: {
								color : '#000000',
								fontWeight: 'Normal',
								fontFamily: fontFamilyVal,
								fontSize: '10px',
								whiteSpace: 'nowrap' 
								},
							formatter: function() {
									var val = Highcharts.numberFormat (this.value,4, '.','');
									val = (parseFloat(val));
									return val;
							}
						},
					title: {
						text: yAxisLabel2,
						enabled: YtitleEnable2,
						//rotation:270,
						margin:20,
						style: {
							color: yAxisLabel2Color,
							fontWeight:'normal',
							fontFamily: fontFamilyVal,
							fontSize: '11px',
							textDecoration: 'none',
							whiteSpace: 'nowrap' 
							},
						},
					opposite:true,
				}],
				xAxis: {
					min: 0,
					tickmarkPlacement: 'on',
					tickWidth:xtickwidth,
					tickLength: ticklength,
					categories: xLabel,
					gridLineWidth: 0,
					gridLineColor: '#e2e2e2',
					lineColor: '#e2e2e2',
					lineWidth:1,
					//tickPixelInterval:50,
					border :1,
					minPadding:0.02,
					maxPadding:0.02,
					ordinal: false,
					endOnTick: true,
					showFirstLabel: true,
					startOnTick: true,
					labels: {
						rotation:rotateDegree,
						//x:xval,
						//y:yVal,
						overflow: 'justify',
						useHTML: false,
						 style: {
								fontWeight: 'Normal',
								fontFamily: fontFamilyVal,
								fontSize: '10px',
								whiteSpace: 'nowrap' 
							},
							formatter: function() {
								var val=this.value;
								var val2=val.toString();
								if(val!=null && val.length>32)
								{
									var val2=val.substring(32);
									if(val2.length>3)
										val=val.substring(0,32)+'...';
								}
								//..
								if(isHourWise && val != null && val.trim().indexOf(" ") != -1)
								{
									val = val.substring(val.lastIndexOf(" ")+1);

								}
								//..
								return val;
							}
						},
					title: {
						enabled: titleEnable,
						text:xLabelText,
						style: {
							color: '#000000',
							fontWeight:'normal',
							fontFamily: fontFamilyVal,
							fontSize: '11px',
							textDecoration: 'none',
							whiteSpace: 'nowrap' 
							},
						},
				},
			plotOptions: {
					 pie: {
						shadow: false,
						borderWidth: 0, // border color control
						size: pieSize,
						allowPointSelect: true,
						cursor: setCursor,
						showInLegend: showLegends,
						innerSize:pieInnerSize,
						dataLabels: {
							format:formatForPieChart,
							crop: false,
							overflow: 'none',
							connectorColor: connColor,
							softConnector: false,
							distance:15
						},
					 },
					bar:{
						shadow: false,
						cursor: setCursor,
						borderWidth: 0,
						depth: 0,
						pointWidth:setPointWidth,
						dataLabels:{
							enabled: true,
							crop: false,
							overflow: 'none',
							style: {
									fontWeight:'normal',
									textShadow: false,
									textOutline: false 
								}							
						},
					 },
					column:{
						shadow: false,
						cursor: setCursor,
						borderWidth: 0,
						depth: 0,
						pointWidth:setPointWidth,
					 },
					line:{
						shadow: false,
						cursor: setCursor,
						marker: {
								enabled:setMarkerEnable,
								fillColor: '#FFFFFF',
								lineWidth: 0.5,
								lineColor: null ,
								symbol:'circle'
                                },
					 },
					series: {
							shadow: false,
							stacking: setStacking, 
							borderWidth: 0,
							depth: 0,
							groupPadding:setGroupPadding,
							pointPadding:setPointPadding,
							maxPointWidth:20,//..
							dataLabels: {
								enabled: isDataLabelEnable,
								crop: false,
								overflow: 'none',
								inside:insidePos,
								rotation:rotateDegree,
								overflow:'none',
								x:3,
								formatter: function() {
									var val = Highcharts.numberFormat (this.y,4, '.','');
									val = (parseFloat(val));
									return val;
								},
								color:dataLabelColor,
								style: {
									color : dataLabelColor,
									fontFamily: fontfamily,
									fontSize: fontsize,
									fontWeight:'normal',
									textShadow: false,
									textOutline: false 
								}
							},
							states: {
								hover: {
									enabled: false
								}
							},
							minPointLength:setMinPointLength,
							 marker: {
								enabled: setMarkerEnable,
								symbol: 'circle',
								radius: pointRadius
							}
						},
				},
			legend: {
					verticalAlign: legendLocation,
					y: legYRange,
					itemDistance:5,
					symbolWidth: 14,
					symbolHeight: 6,
					squareSymbol: false,
					symbolRadius: 6,
					enabled: showLegends,
					align:'center',
					maxHeight :maxLegendHeight,
					itemMarginBottom: 4,
					itemStyle: {
					   textAlign: 'top',
						fontFamily:fontFamilyVal,
					}, 
					labelFormatter: function() {
						var retrunvar = this.name;
						if(retrunvar.length>28 && needLegendFormat == 'true')
						{
							c=0;
							strval=''
							while(c<retrunvar.length)
							{
								strval+=retrunvar.substring(c,c+28)+'<br>';
								c=c+28;
							}
						retrunvar= strval;
						}
						return retrunvar;
					},
				},
						rangeSelector: {
			enabled: false
		},
		global: {
			useUTC: true,
			timezoneOffset: timezoneOffsetValue
		},
		time:{
			useUTC: true,
			timezoneOffset: timezoneOffsetValue
		},
		navigator: {
			enabled: false
		},
		scrollbar: {
			enabled: false
		},
		labels :{
			style: {
			color: '#000000',
			fontWeight:'normal',
			fontFamily: fontFamilyVal,
			fontSize: '10px',
			whiteSpace: 'nowrap' 
			}
		},
		credits: {
			enabled: false
		},
		subtitle: {
			style: {
				color:  '#000000',
				fontWeight:'bold',
				fontFamily:fontFamilyVal,
				fontSize: '11px',
				whiteSpace: 'nowrap' 
			}
		},
		series: jsonData['DataSet'],
		exporting: {
			enabled: false,
		},
		tooltip:{
				enabled:false
			}
		}
			
	chartOptions.chart.forExport=true;
	chartOptions.chart.renderTo=n;
	Highcharts.seriesTypes.line.prototype.drawLegendSymbol =  Highcharts.seriesTypes.area.prototype.drawLegendSymbol;


	Highcharts.setOptions({
		global: {
			timezoneOffset: timezoneOffsetValue
		}
	});
   var chart = new Highcharts.Chart(chartOptions);
	(function (H) {
		var each = H.each;
		H.wrap(H.seriesTypes.column.prototype, 'drawPoints', function(proceed) {
			var series = this;
			if(series.data.length > 0 ){
				var width = series.barW > series.options.maxPointWidth ? series.options.maxPointWidth : series.barW;
				each(this.data, function(point) {
					point.shapeArgs.x += (point.shapeArgs.width - width) / 2;
					point.shapeArgs.width = width;
				});
			}
			proceed.call(this);
		})
	}(Highcharts));
   var svg = chart.getSVG (); 
	svg = svg.replace(/(fill|stroke)="rgba\(([ 0-9]+,[ 0-9]+,[ 0-9]+),([ 0-9\.]+)\)"/g,'$1="rgb($2)" $1-opacity="$3"')

   chart.destroy ();
	Highcharts.discardElement (n);
   return svg;
}
function getChartSVGOverview(jsonData,chartWidth,chartHeight)
{
	   n = Highcharts.createElement('div', null, null, null, true);  // highcharts line 304
		var toolTipFmt = '';
		var timezoneOffsetValue='';
		var chartType = 'bar';
	    var setStacking='normal'
		var setMinPointLength=0;
		var setendOnTick=true;
		var fontFamilyVal='Arial';
		if(jsonData["isDoubleByteEnabledManager"] != undefined && jsonData["isDoubleByteEnabledManager"] == true)
		{
			fontFamilyVal='Code2000';
		}
		var enable_Format=jsonData['enable_Format'];
		var enable_values=jsonData['enable_values'];
		var formatForPieChartVal=jsonData['formatForPieChart'];
		var formatForLegendOnlyPercentage=jsonData['formatForLegendOnlyPercentage'];
		var formatForPieChart="";
		var enableNameandValue=jsonData['enableNameandValueinTooltip'];
		if(enable_Format != null && enable_Format != 'undefined')
		{
			formatForPieChart='{point.name}';
		}
		/*else
		{
			formatForPieChart='{point.name}:{point.percentage:.1f} %';
		}*/
		if(enable_values != null && enable_values != 'undefined')
		{
			formatForPieChart='{point.y}';
		}
		/*else{
			if(formatForPieChart == "")
			formatForPieChart='{point.y}:{point.percentage:.1f} %';
		}*/
		if(formatForPieChartVal != "" && formatForPieChartVal != 'null' && formatForPieChartVal != 'undefined' && formatForPieChartVal != undefined)
            formatForPieChart='{point.name}'+formatForPieChartVal+'{point.percentage:.1f} %';
		if(formatForLegendOnlyPercentage == true || formatForLegendOnlyPercentage== 'true')
		      formatForPieChart='{point.percentage:.1f} %';
		if(enableNameandValue != null && enableNameandValue != 'undefined')
		{
			formatForPieChart='{point.name} {point.y} %';
		}
		if(enable_Format != null && enable_Format != 'undefined' && enable_Format == 'simulator')
		{
			formatForPieChart='{point.percentage:.2f} %';
		}
		if(enable_Format != null && enable_Format != 'undefined' && enable_Format == 'percent')
		{
			formatForPieChart='{point.y}%';
		}
		var insidePos= jsonData['inside'];
		fontFamily = jsonData['fontName'];
		fontSize = jsonData['fontsize'];
		yaxisTitle = jsonData['yAxisLabel'];
		LegendPosition = jsonData['LegendPosition'];
		showLegend = jsonData['showlegendFont'];
		xLabel = jsonData['xAxisLabel'];
		var xLabelText = jsonData['xAxisLabelText'];
		var isExecutiveReport = jsonData['isExecutiveReport'];
		LegendFont = jsonData['LegendFont'];
		chartType = jsonData['chartType'];
		if(chartType == 'linePlain')
			chartType = 'line';
		if(chartType == 'areaPlain')
			chartType = 'area';
		yaxisTitle =(yaxisTitle == null || yaxisTitle == '')?'':yaxisTitle;
		YtitleEnable =(yaxisTitle == null || yaxisTitle == '')?false:true;
		fontFamily=fontFamilyVal;
		LegendFont=fontFamilyVal;
		yaxisTitle =(yaxisTitle == null || yaxisTitle == '')?jsonData['yAxisLabel']:yaxisTitle;
		xLabel =(xLabel == null || xLabel == '')?'':xLabel;
		xLabelText =(xLabelText == null || xLabelText == '')?'':xLabelText;
		titleEnable =(xLabelText == null || xLabelText == '')?false:true;
		fontFamily =(fontFamily == null || fontFamily == '')?fontFamilyVal:fontFamily;
		fontSize =(fontSize == null || fontSize == '')?'10px':fontFamily+"px";
		LegendPosition =(LegendPosition == null || LegendPosition == '' || LegendPosition == 'top')?'center':LegendPosition;
		LegendFont =(LegendFont == null || LegendFont == '')?fontFamilyVal:LegendFont;
		legendWidth = (LegendPosition == 'right')?190:400;
		needLegendFormat = (LegendPosition == 'right')?'true':'false';
		maxLegendHeight = (LegendPosition == 'right')?null:50;
		valign=LegendPosition;
		var showLegends =jsonData['legend'];
		if(showLegends == "" || showLegends == 'null' || showLegends == 'undefined' || showLegends == undefined)
			showLegends=false;
		else if(showLegends == 'true')
			showLegends=true;
		else if(showLegends == 'false')
			showLegends=false;
		if(insidePos == "" || insidePos == 'null' || insidePos == 'undefined' || insidePos == undefined)
			insidePos=false;
		else if(insidePos == 'true')
			insidePos=true;
		var chartTitle =jsonData['title'];
		/*if(jsonData['titleUi'] != undefined)
			chartTitle =jsonData['titleUi'];*/
		chartTitle =(chartTitle == null || chartTitle == '')?'':chartTitle;
		var subTitle =jsonData['subTitle'];
		subTitle =(subTitle == null || subTitle == '')?'':subTitle;
		var setGroupPadding=-0.065;
		var setPointPadding=0.1;// default value
		var data=jsonData['DataSet'];
		var rotateDegree=0;
		var dataLabelColor='#FFFFFF';
		var chartSubType=jsonData['chartSubType'];
		var drilDown=jsonData['drildown'];
		var setPointWidth=null;
		var setCursor=null;
		var isUptimeChart=jsonData['uptime'];
		var isReporterHome=jsonData['isReporterHome'];
		var space =[10, 10, 10, 10];
		var yaixlinewidth=0;
		var xtickwidth=0;
		var ticklength=10;
		var xval=-10;
		var ymax=null;
		var ymin=0;
		var xmin=0;
		var yVal=2;
		var marginTop=20;
		var isHypervisorResoucesChart=jsonData['isHypervisorChart'];
		var showInLegend = false;
		var legendLocation='top'
		
		if(jsonData['LegendPosition']!= null && jsonData['LegendPosition']!= ''){
			 legendLocation = jsonData['LegendPosition'];
		}
		if(isUptimeChart!=null && isUptimeChart=='uptimechart'){
			if(jsonData['LegendPosition']!= null && jsonData['LegendPosition']!= ''){
				 legendLocation = jsonData['LegendPosition'];
			}
		}
		if(!(chartSubType!=null && chartSubType=='stacked'))
			setStacking=null;//..

		ymax = jsonData['ymax'];
		if(ymax == "" || ymax == 'null' || ymax == 'undefined' || ymax == undefined)
			ymax=null;
		
		ymin = jsonData['minRange'];
		if(ymin == "" || ymin == 'null' || ymin == 'undefined' || ymin == undefined)
			ymin=0;
		
		xmin = jsonData['minRangexaxis'];
		if(xmin == "" || xmin == 'null' || xmin == 'undefined' || xmin == undefined)
			xmin=0;


		if(yaxisTitle == '%' || yaxisTitle =='(%)')
			ymax = "100";

		if(!showLegends)
		{
			if(chartSubType!=null && chartSubType=='stacked'){
				if(chartType!=null &&chartType=='column')
					if(chartTitle == null || chartTitle == '')
						space=[40, 10, 10, 10];
				if(isExecutiveReport!=null && isExecutiveReport)
					space=[20, 10, 10, 10];
			}
		}
		if(drilDown!=null && (drilDown=='sametab'||drilDown=='newtab'))
		{
			setCursor='pointer';
		}
		var setMarkerEnable=false;
		if(data!=null && data.length>=1)
		{
			var xx=data[0].data;
			if(xx.length==1)
			{
				setGroupPadding=0.2;
				setPointPadding=0.4;
			}
			else if(xx.length>1 && xx.length<=4)
			{
				setGroupPadding=0.2;
				setPointPadding=0.3;
			}
			if(chartType!=null &&chartType=='column')
			{
				marginTop=null;
				 setPointWidth=27;
					
					if(xx.length>50)
				    {
					setPointWidth=3;
					}
					else if(xx.length>45)
				    {
					setPointWidth=5;
					}
					else if(xx.length>40)
				    {
					setPointWidth=8;
					}
					else if(xx.length>32)
				    {
					setPointWidth=10;
					}
					else if(xx.length>21)
				    {
					setPointWidth=12;
					}
					else if(xx.length>15)
				    {
					setPointWidth=17;
					}
					else if(xx.length>8)
				    {
					setPointWidth=20;
					}
					else if(xx.length<=8)
			        {
					   setGroupPadding=0.2;
					   setPointPadding=0.2;
			        }
			}
			if(xLabel.length == 1)
			{
				setMarkerEnable=true;
			}

		}
		if(isHypervisorResoucesChart==true)
			xval=2;

		var isDataLabelEnable=jsonData['isDataLabelEnabled'];
		var isEndOnTick=jsonData['endOnTick'];
		var percentEnableTick=jsonData['percentEnableTick'];
		if(isDataLabelEnable==false)
		{
			 isDataLabelEnable=false;
		}
		else if(isDataLabelEnable == "" || isDataLabelEnable == 'null' || isDataLabelEnable == 'undefined' || isDataLabelEnable == undefined)
		{
             isDataLabelEnable=true;
		}
			
		if(chartType!=null && chartType=='pie')
		{
			strpointFormat='';
			dataLabelColor='#2a292a';
		}else
		{
			strpointFormat='<b>:{point.y}</b>';
		}
		if(chartType!=null && (chartType=='column' ||chartType=='line' || chartType=='combinedChart' || chartType=='area' || chartType=='scatter'))
		{
			rotateDegree=-60;
			yVal=20;
			xval=2;
			if(chartSubType!=null && chartSubType=='stacked')
			{
				xtickwidth=1;
				ticklength=5;
			  strpointFormat= '{series.name}: <b>{point.y}</b><br/>';
			}
			else
			{
			strpointFormat='<b>:{point.y}</b>';
			}
		}
		if(chartType!=null && chartType=='bar')
		{
			yaixlinewidth=1;
			if(chartSubType!=null && chartSubType=='stacked')
			{
				dataLabelColor='#FFFFFF';
				setendOnTick=false;
				if(isUptimeChart!=null && isUptimeChart=='uptimechart')
				{
					setPointWidth=21;
					showLegends=true;
				}
				else
				{
					setPointWidth=20;
				}
			}
			else
			{
				dataLabelColor='#2a292a';
				  setMinPointLength=10;
				  setPointWidth=21;
			}
		}
		if(chartType!=null && chartType=='line')
		{
			setStacking=null;
			strpointFormat= '{series.name}: <b>{point.y}</b><br/>';
	    }
		var fontweight="Normal";
		var fontsize="11px";
		var fontfamily=fontFamilyVal;
		if(chartType!=null && chartType=='pie')
		{
			marginTop=null;
			fontsize="11px"
			fontfamily=fontFamilyVal;
		}
		/*if(yaxisTitle!=null && (yaxisTitle.indexOf('%')>-1 || yaxisTitle.indexOf('(%)')>-1))
		{
			if(ymax==null)
				setendOnTick=true;
		}*/
		if(isEndOnTick==false)
		{
			 setendOnTick=false;
		}
		var lablecolor='#2a292a';
		var connColor='#C0C0C0';
		var mychartwidth=chartWidth;
		var mychartheight=chartHeight;
		var isTopNReport=jsonData['isTopNReport'];
		var allowMarginTop=jsonData['allowMarginTop'];
		if(allowMarginTop != null && allowMarginTop !=undefined && allowMarginTop != 'undefined' && allowMarginTop == 'yes' )
		{
			marginTop=jsonData['marginTop'];
		}

		if(chartType!=null && chartType=='bar')
		{
			if(chartSubType==null || chartSubType!='stacked')
				setendOnTick=true;
		}
		if(chartType!=null && (chartType=='line'))
		{
			marginTop=null;
			setendOnTick=false;
		}

		if(percentEnableTick==true)
		{
			 setendOnTick=false;
		}
			
		var jsonXval=jsonData['xval'];
		if(jsonXval != "" && jsonXval != 'null' && jsonXval != 'undefined' && jsonXval != undefined )
		{
			xval=jsonXval;
		}
		var jsonYval=jsonData['yVal'];
		if(jsonYval != "" && jsonYval != 'null' && jsonYval != 'undefined' && jsonYval != undefined )
		{
			yVal=jsonYval;
		}
		var marginTopVal=jsonData['disablemarginTop'];
		if(marginTopVal != "" && marginTopVal != 'null' && marginTopVal != 'undefined' && marginTopVal != undefined && marginTopVal=="true")
		{
			marginTop=null;
		}
		var jsonXval=jsonData['xval'];
		if(jsonXval != "" && jsonXval != 'null' && jsonXval != 'undefined' && jsonXval != undefined )
		{
			xval=jsonXval;
		}
		var pieSize='80%';
		var pieSizeVal=jsonData['pieSize'];
		if(pieSizeVal != "" && pieSizeVal != 'null' && pieSizeVal != 'undefined' && pieSizeVal != undefined )
		{
			pieSize=pieSizeVal;
		}
		var centerlegendPostion=jsonData['centerlegendPostion'];

		var boldYaxisLabel=jsonData['boldYaxisLabel'];
		if(boldYaxisLabel != "" && boldYaxisLabel != 'null' && boldYaxisLabel != 'undefined' && boldYaxisLabel != undefined && boldYaxisLabel=="true" )
		{
			yaxisTitle="<b>"+yaxisTitle+"</b>";
		}
		var tooltipEnable=true
		var enableToolTip=jsonData['enableToolTip'];
		if(enableToolTip != "" && enableToolTip != 'null' && enableToolTip != 'undefined' && enableToolTip != undefined && enableToolTip=="false" )
		{
			tooltipEnable=false;
		}
		var pointRadius=4;
		var pointRadiusVal=jsonData['pointRadius'];
		if(pointRadiusVal != "" && pointRadiusVal != 'null' && pointRadiusVal != 'undefined' && pointRadiusVal != undefined && pointRadiusVal=="false" )
		{
			pointRadius=pointRadiusVal;
		}
		var tooltipPercent=false;
		var enableTooltpPercent=jsonData['enableTooltpPercent'];
		if(enableTooltpPercent != "" && enableTooltpPercent != 'null' && enableTooltpPercent != 'undefined' && enableTooltpPercent != undefined && enableTooltpPercent=="true" )
		{
			tooltipPercent=true;
		}
		if(isUptimeChart!=null && isUptimeChart=='uptimechart')
		{
			showLegends=true;
		}
		var legYval=-10;
		if(chartType!=null && chartType=='pie' && LegendPosition!=null && LegendPosition=='bottom' )
		{
			legYval=10;
		}
		var pieInnerSize='';
		var piechartTitleVAlign=null;
		var piechartTitleY=10;
		var isDoNut = false;
		var isDoNutTitleNeeded = false;
		var isDoNutTitleNeededFlag=jsonData['isDoNutTitleNeeded'];
		if(isDoNutTitleNeededFlag!=null && isDoNutTitleNeededFlag=='true')
			isDoNutTitleNeeded = true;
		
		//for enable Stacking in Slow Logon Performance report
		var enableGroupingVal=jsonData['enableGrouping'];
		var enableGrouping=true;
		if(enableGroupingVal != "" && enableGroupingVal != 'null' && enableGroupingVal != 'undefined' && enableGroupingVal != undefined && enableGroupingVal == 'true'){
			enableGrouping=false;
		}
		var subTitleAlign='left';
		var piechartBorder = 0;
		if(chartType!=null && chartType=='donut')
		{
			piechartBorder = 1;
			chartType='pie';
			isDoNut = true;
			pieSize=jsonData['pieSize'];
			pieInnerSize=jsonData['innerSize'];

			if(pieSize == "" || pieSize == 'null' || pieSize == 'undefined' || pieSize == undefined)
				pieSize='150%';

			if(pieInnerSize == "" || pieInnerSize == 'null' || pieInnerSize == 'undefined' || pieInnerSize == undefined)
				pieInnerSize='100%';

			showLegends =jsonData['showlegend'];
			if(showLegends == "" || showLegends == 'null' || showLegends == 'undefined' || showLegends == undefined)
				showLegends=false;
			marginTop =jsonData['marginTop'];
			if(marginTop == "" || marginTop == 'null' || marginTop == 'undefined' || marginTop == undefined)
				marginTop='10';

			isDataLabelEnable=false;
			var isDataLabelEnableForDonut=jsonData['isDataLabelEnableForDonut'];
			if(isDataLabelEnableForDonut != "" && isDataLabelEnableForDonut != 'null' && isDataLabelEnableForDonut != 'undefined' && isDataLabelEnableForDonut != undefined && isDataLabelEnableForDonut == 'true'){
				isDataLabelEnable=true;
				dataLabelColor='#2a292a';
			}
			mychartheight = jsonData['chartHeight'];
			if(mychartheight == "" || mychartheight == 'null' || mychartheight == 'undefined' || mychartheight == undefined)
				mychartheight=chartHeight;
			mychartwidth = jsonData['chartWidth'];
			if(mychartwidth == "" || mychartwidth == 'null' || mychartwidth == 'undefined' || mychartwidth == undefined)
				mychartwidth=chartWidth;
			piechartTitleVAlign='middle';
			//piechartTitleY=0;
			subTitleAlign="center";
		}
		var allowDecimalInterval=true;
		var decimalInterval=jsonData['decimalInterval'];
		if(decimalInterval != undefined && decimalInterval != "" && decimalInterval=='false')
		{
			allowDecimalInterval=false;//..
		}
		var titlestyle ={
					//text:'<div style="margin-top:-10px">'+chartTitle+'</div>',
					text: chartTitle,
		          //  align: 'center',
		            align: subTitleAlign,
		            verticalAlign: piechartTitleVAlign,
		            y: piechartTitleY,
					style: {
						color : '#000000',
						fontFamily:'Roboto-Bold',
						fontSize: '16px',
						whiteSpace: 'nowrap' 
					}
			};
		var subtitlestyle ={
			style: {
				color:  '#000000',
				fontFamily:'Roboto-Bold',
				fontSize: '13px',
				fontWeight:'normal',
				whiteSpace: 'nowrap' 
			}
		};
		if(isDoNutTitleNeeded){
			subtitlestyle ={
				text: subTitle,
				useHTML:false,
				align: 'center',
				verticalAlign: piechartTitleVAlign,
				//y: piechartTitleY + 20,
				y: 15,
				style: {
					color : '#000000',
					fontFamily:'Roboto-Bold',
					fontSize: '16px',
					whiteSpace: 'nowrap' 
				}
			};
		}
		if(isDoNut)
		{
			var text = '';
			var piechartTitleYY = '';
			if(isDoNutTitleNeeded){
				text = chartTitle;
				piechartTitleYY = 5;
			}
			else
				piechartTitleYY = piechartTitleY;
			titlestyle= {
						//text:'<div style="margin-top:-10px">'+chartTitle+'</div>',
						text: text,
						align: 'center',
						verticalAlign: piechartTitleVAlign,
						y: piechartTitleYY,
						useHTML:false,
						floating: true,
						offset: '',
						margin: 0,
						style: {
							color : '#000000',
							fontFamily:'Roboto-Bold',
							fontSize: '16px',
							whiteSpace: 'nowrap' 
						}
				   }
		}
		var chartOptions = {
			chart:{
				placeValuesInside:0,
				align:'center',
				plotBorderWidth: 0,
				height:chartHeight,
				width:mychartwidth,
				//marginTop:marginTop,
				plotBackgroundColor: 'white',
				plotBorderColor : '#e2e2e2',
				backgroundColor:'#ffffff',
				plotShadow: false,
				shadow: false,
				padding:0,
				ignoreHiddenSeries:false,
				type : chartType,
				events: {
					load: function(event) {
						$('.highcharts-legend-item rect').attr('height', '8').attr('y', '8');
						$('.highcharts-legend-item rect').attr('width', '8').attr('x', '8');
					}
				}			
			},
			title:titlestyle ,
			yAxis: {
					//min:ymin,
					//max:ymax,
					border :0,
					tickWidth:0,
					tickmarkPlacement: 'on',
					tickLength: 5,
					lineWidth:yaixlinewidth,
					reversedStacks: false,
					gridLineColor: '#e1e1e1',
					lineColor: '#e1e1e1',
					endOnTick:setendOnTick,
					showFirstLabel: true,
					startOnTick: true,
					showLastLabel: setendOnTick,
					allowDecimals:allowDecimalInterval,
					labels: {
						 style: {
								color: '#000000',
								fontWeight:'normal',
								fontFamily: fontFamilyVal,
								fontSize: '11px',
								whiteSpace: 'nowrap' 
							},
							formatter: function() {
								var val = Highcharts.numberFormat (this.value,4, '.','');
								val = (parseFloat(val));
								return val;
							}
						},
					title: {
						text: yaxisTitle,
						enabled: YtitleEnable,
						style: {
							color: '#000000',
							fontWeight:'normal',
							fontFamily: fontFamilyVal,
							fontSize: '11px',
							textDecoration: 'none',
							whiteSpace: 'nowrap' 
							},
						},
						tickPositioner: function(min,max){
						var act = min,
						ticks = [];
						this.tickAmount=1;
						var flag=false;
						var interval=this.tickInterval;
						var second=0;
						if(min==max)
						{
							if(max>1)
								max=max+1;
							else if(max==0){
								max=max+1;
								second=0
								flag=true;
							}
							else
							{
								max=max+0.1;
							}
						}
						var cc=1
						while(act <= max){
							if(cc==2 && flag)
								ticks.push(second);
							else
								ticks.push(act);
							act+= interval;
							cc++;
						}
						if(!flag)
							ticks.push(act);
					  return ticks;  
					},
				},
				xAxis: {
					min: xmin,
					tickmarkPlacement: 'on',
					tickWidth:xtickwidth,
					tickLength: ticklength,
					categories: xLabel,
					gridLineWidth: 0,
					gridLineColor: '#e1e1e1',
					lineColor: '#e1e1e1',
					lineWidth:1,
					//tickPixelInterval:50,
					border :1,
					//minPadding:0.02,
					//maxPadding:0.02,
					ordinal: false,
					endOnTick: true,
					showFirstLabel: true,
					startOnTick: true,
					labels: {
						rotation:rotateDegree,
						//x:xval,
						//y:yVal,
						overflow: 'justify',
						useHTML: false,
						 style: {
								color: '#000000',
								fontWeight:'normal',
								fontFamily: fontFamilyVal,
								fontSize: '11px',
								whiteSpace: 'nowrap' 
							},
							/*formatter: function() {
								var val=this.value;
								var val2=val.toString();
								if(val!=null && val.length>32)
								{
									var val2=val.substring(32);
									if(val2.length>3)
										val=val.substring(0,32)+'...'
								}
								return val;
							}*/
						},
					title: {
						enabled: titleEnable,
						text:xLabelText,
						style: {
							color: '#000000',
							fontWeight:'normal',
							fontFamily: fontFamilyVal,
							fontSize: '11px',
							whiteSpace: 'nowrap' 
							},
						},
				},
			plotOptions: {
					 pie: {
						shadow: false,
						borderWidth: 0, // border color control
						size: pieSize,
						allowPointSelect: true,
						cursor: setCursor,
						showInLegend: showLegends,
						innerSize:pieInnerSize,
						dataLabels: {
							format:formatForPieChart,
							crop: false,
							overflow: 'none',
							connectorColor: connColor,
							softConnector: false,
							distance:15
						},
					 },
					bar:{
						shadow: false,
						cursor: setCursor,
						borderWidth: 0,
						depth: 0,
						//pointWidth:setPointWidth,
						dataLabels:{
							enabled: true,
							crop: false,
							overflow: 'none',
							style: {
									fontWeight:'normal',
									textShadow: false,
									textOutline: false 
								}
						},
					 },
					column:{
						shadow: false,
						cursor: setCursor,
						borderWidth: 0,
						grouping:enableGrouping,
						depth: 0,
						//pointWidth:setPointWidth,
					 },
					line:{
						shadow: false,
						cursor: setCursor,
						marker: {
							   enabled:setMarkerEnable,
								fillColor: '#FFFFFF',
								lineWidth: 0.5,
								lineColor: null ,
								symbol:'circle'
                                },
					 },
					series: {
							shadow: false,
							stacking: setStacking, 
							borderWidth: piechartBorder,
							depth: 0,
							groupPadding:setGroupPadding,
							pointPadding:setPointPadding,
							maxPointWidth:20,//..
							dataLabels: {
								enabled: isDataLabelEnable,
								crop: false,
								overflow: 'none',
								inside:insidePos,
								rotation:rotateDegree,
								overflow:'none',
								x:3,
								formatter: function() {
									var val = Highcharts.numberFormat (this.y,4, '.','');
									val = (parseFloat(val));
									return val;
								},
								color:dataLabelColor,
								style: {
									color : dataLabelColor,
									fontFamily: fontFamilyVal,
									fontSize: fontsize,
									fontWeight:'normal',
									textShadow: false,
									textOutline: false 
								}
							},
							states: {
								hover: {
									enabled: false
								}
							},
							minPointLength:setMinPointLength,
							 marker: {
								enabled: setMarkerEnable,
								symbol: 'circle',
								radius: pointRadius
							}
						},
				},
			legend: {
					verticalAlign: legendLocation,
					y: legYval,
					itemDistance:5,
					symbolWidth: 14,
					symbolHeight: 6,
					squareSymbol: false,
					symbolRadius: 6,
					enabled: showLegends,
					align:'center',
					maxHeight :maxLegendHeight,
					itemMarginBottom: 4,
					itemStyle: {
					   textAlign: 'top',
						fontWeight: 'Normal',
						fontFamily:fontFamilyVal,
						fontSize: '10px',
					}, 
					labelFormatter: function() {
						var retrunvar = this.name;
						if(retrunvar.length>28 && needLegendFormat == 'true')
						{
							c=0;
							strval=''
							while(c<retrunvar.length)
							{
								strval+=retrunvar.substring(c,c+28)+'<br>';
								c=c+28;
							}
						retrunvar= strval;
						}
						return retrunvar;
					},
				},
						rangeSelector: {
			enabled: false
		},
		global: {
			useUTC: true,
			timezoneOffset: timezoneOffsetValue
		},
		time:{
			useUTC: true,
			timezoneOffset: timezoneOffsetValue
		},
		navigator: {
			enabled: false
		},
		scrollbar: {
			enabled: false
		},
		labels :{
			style: {
			color: '#000000',
			fontWeight:'normal',
			fontFamily: fontFamilyVal,
			fontSize: '11px',
			whiteSpace: 'nowrap' 
			}
		},
		credits: {
			enabled: false
		},
		subtitle:subtitlestyle,
		series: jsonData['DataSet'],
		exporting: {
			enabled: false,
		 },
		tooltip:{
				enabled:false
			}
		}
			
	chartOptions.chart.forExport=true;
	chartOptions.chart.renderTo=n;
	Highcharts.seriesTypes.line.prototype.drawLegendSymbol =  Highcharts.seriesTypes.area.prototype.drawLegendSymbol;

	Highcharts.setOptions({
		global: {
			timezoneOffset: timezoneOffsetValue
		}
	});

   var chart = new Highcharts.Chart(chartOptions);

	(function (H) {
		var each = H.each;
        H.wrap(H.seriesTypes.column.prototype, 'drawPoints', function(proceed) {
            var series = this;
            if(series.data.length > 0 ){
                var width = series.barW > series.options.maxPointWidth ? series.options.maxPointWidth : series.barW;
                each(this.data, function(point) {
                    point.shapeArgs.x += (point.shapeArgs.width - width) / 2;
                    point.shapeArgs.width = width;
                });
            }
            proceed.call(this);
        })
    }(Highcharts));


   var svg = chart.getSVG (); 
	svg = svg.replace(/(fill|stroke)="rgba\(([ 0-9]+,[ 0-9]+,[ 0-9]+),([ 0-9\.]+)\)"/g,'$1="rgb($2)" $1-opacity="$3"')

   chart.destroy ();
	Highcharts.discardElement (n);
   return svg;
}
function getHighChartsGuage(jsonData,chartWidth,chartHeight)
{
	n = Highcharts.createElement('div', null, null, null, true);
	if(jsonData!=undefined )
	{
		var chartType = jsonData['chartType'];
		var title = (jsonData['title']==undefined )?'':jsonData['title']; 
		var gaugeUnit = (jsonData['unit']==undefined )?'':'('+jsonData['unit']+')'; 
		var gaugeTitle = title+' '+gaugeUnit;
		var fontColor = (jsonData['fontColor']==undefined )?'':jsonData['guageData']['fontColor'];
		var fontFamily = (jsonData['fontName']==undefined )?'Arial':jsonData['fontName'];
		var strSkinclr = (jsonData['strSkinclr']==undefined  )?'':jsonData['strSkinclr'];
		var isRoundBorder = (jsonData['isRoundBorder']==undefined )?false:jsonData['isRoundBorder'];
		var startAngle = (jsonData['startAngle']==undefined )?-90:jsonData['startAngle'];
		var endAngle = (jsonData['endAngle']==undefined )?90:jsonData['endAngle'];
		var dataObj = jsonData['DataSet'];

		if(fontColor==null || fontColor=="" || fontColor=="null" || fontColor=="undefined")
		{
			fontColor='black';
		}
		if(fontFamily==null || fontFamily=="" || fontFamily=="null" || fontFamily=="undefined")
		{
			fontFamily='Arial';
		}
		var margTop=0;
		var mouseHand="default";
		var maxDialVal = 0;
		if(jsonData['maxValueForDial']!=undefined )
		{
			maxDialVal = parseInt(jsonData['maxValueForDial']);
		}
		else
		{
			maxValueForDial = 500;
		}
		var gaugeOptions = {
			chart: {
				type: chartType,
				height:chartHeight,
				width:chartWidth,
				backgroundColor:'transparent',
				plotBackgroundColor : 'transparent',
				marginTop: margTop,
				spacing:[10, 10, 10, 10]
			},
			title:{
				enabled : false,
				text:''
			},
			exporting: 
			{
				enabled: false
			},
			credits:
			{
				enabled: false
			},
			tooltip: 
			{
				enabled: false
			},
			pane: {
				startAngle: startAngle,
				endAngle: endAngle,
				outerRadius: '112%',
				innerRadius: '88%',
				background: 
				{
					backgroundColor: Highcharts.Color(Highcharts.getOptions().colors[0]).setOpacity(0.0).get(),
					borderWidth: 0
				}
			},
			yAxis: 
			{
				min: 0,
				max: maxDialVal,
				lineWidth: 0,
				tickPositions: []
			},
			plotOptions: 
			{
				solidgauge: 
				{
					dataLabels: 
					{
						enabled: true,
						y: -10,
						borderWidth: 0,
						style: 
						{
							//color : fontColor,
							//fontFamily: fontFamily,
							//fontSize: '18px',
							textOutline: false,
							textShadow: false
						}
					},
					rounded:isRoundBorder
				}
			},
			series: jsonData['DataSet']
		};
	}
	gaugeOptions.chart.forExport=true;
	gaugeOptions.chart.renderTo=n;
	var chart = new Highcharts.Chart(gaugeOptions);

	var svg = chart.getSVG (); 
	svg = svg.replace(/(fill|stroke)="rgba\(([ 0-9]+,[ 0-9]+,[ 0-9]+),([ 0-9\.]+)\)"/g,'$1="rgb($2)" $1-opacity="$3"')

   chart.destroy ();
	Highcharts.discardElement (n);
   return svg;
}