Ext.define('ErReportBuilderDrillDown.controller.ErReportBuilderDrillDownController', {
	extend: 'ErReportBuilderDrillDown.controller.BuilderController',	 
	refs: [
		{selector:'main', ref:'main'},
		{selector:'buildersettings', ref:'buildersettings'},
		{selector:'templateformalias', ref:'templateformalias'},
		{selector:'templateformitemsalias', ref:'templateformitemsalias'},
		{selector:'newUtilities', ref:'newUtilities'},
		{selector:'gridster', ref:'gridster'},
		{selector:'#widgetLayoutPane', ref:'widgetLayoutPane'},
	],
	method:appConstants.method,
	init: function () {
		this.control({
			'templateformalias': {
				'render': this.invokeSettings,
				'afterrender': this.onAjaxSuccess
			},
			'templateformalias combo[id=er_option]': {
				'select': this.ajaxQueryMaker
			},
			'templateformalias combo[id=er_site]': {
				'select': this.ajaxQueryMaker
			},
			'templateformalias combo[id=er_compType]': {
				'select': this.ajaxQueryMaker
			},
			'egcomponenttype multiselectfield[id=er_mutiSelComp]': {
				'change': this.ajaxQueryMaker
			},
			'templateformalias combo[id=er_test]': {
				'select': this.ajaxQueryMaker
			},
			'templateformalias combo[id=er_measure]': {
				'select': this.ajaxQueryMaker
			},
			'templateformalias multiselectfield[id=er_measure]': {
				'change': this.ajaxQueryMaker
			},
			'templateformalias button[id=submit]': {
				'click': this.beforeSubmit
			},
			'templateformalias button[id=saveReport]': {
				'click': this.goTo
			},
			'newUtilities > #printTool > button':
			{
				'click':this.printReport
			},
			'newUtilities > #diagnosisTool > button': {
				'click': this.showDD
			},
			'newUtilities > #dataTool > button':{
				'click':this.dataGridReport
			},	
			'newUtilities > #saveTool > button': {
				'click': this.saveFile
			},
			'newUtilities > #mailTool > button':{
				'click':this.sendMail
			},		
			'newUtilities > #csvTool > button':{
				'click':this.printCsvReport
			},				
			'buildersettings combo[name="reportGeneration"]':{
				'select': this.reportGenChange
			},
			/*'main button[id="panelinsidetoggle"]': {
                'click': this.toggleForm
            },*/
			'egcomponent button[id="expandSelectorComponent"]':
			{
				//'click': this.expandMe
			},
		});
	},
	showDD: function () {
		var w =window.open(dd_Url,"DDWindow","width=1012,height=603,left=0,top=105,scrollbars=1,scrollbars=yes,resizable");

		w.focus();
	},
	saveFile: function () {
		//qryString = "/final/reporter/ErHtmlToSavePdf.jsp?printBy=drillDown&savereport=save&isBuilderTimeline=yes&compName="+compName+"&graphIndex="+graphIndex+"&widgetIdInfo="+widgetIdInfo;
		qryString = "/final/reporter/ErHtmlToSavePdf.jsp?dataDrill=yes&drillSes=yes&savereport=save&isBuilderTimeline=yes&compName="+compName+"&graphIndex="+graphIndex+"&widgetIdInfo="+widgetIdInfo;
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		appConstants.erUtils.savePDF(qryString);		
	},
	expandMe:function(btn){	
		
		var idName="";
		var lblId="";
		var id=btn.getItemId();
		if(id=="expandSelectorComponent")
		{
			idName="er_component";
			lblId="compmultipane";
		}
		 if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		appConstants.erUtils.expandMultiComboButton(Ext.getCmp(idName),Ext.getCmp(lblId).text,btn);
	},
	toggleForm:function(obj)
	{
		//Ext.getCmp('panelinsidetoggle').show();
		var ornt = Ext.getCmp('templateFormItms');
		if (ornt.isHidden())
		{
			ornt.show();
			Ext.getCmp('selectionDetails').hide();
		}
		else
		{
			ornt.hide();
			Ext.getCmp('selectionDetails').show();
		}
	},
	reportGenChange:function(){
		Ext.getCmp('resultcontainer').hide();
		this.enableDisableTools(true);
		var reportGenType=Ext.getCmp('reportGeneration').getValue();
		if(reportGenType== 'background'){
			Ext.getCmp('bgReportName').setValue("");
			Ext.getCmp('bgReportName').show();
		}
		else{
			Ext.getCmp('bgReportName').hide();
		}
	},
	sendMail:function(){
		drillDownParams = '&isBuilderTimeline=yes&dataDrill=yes&DrillDown=yes&compName='+compName+'&graphIndex='+graphIndex+'&widgetIdInfo='+widgetIdInfo;
		var windowMail = Ext.widget('sendmail');
		windowMail.show();
	},
	goTo: function (btn) {
		appConstants.formButtonId = btn.getId();
		var from_schedule = appConstants.fromScheduleModify;
		if ((from_schedule != null && from_schedule == "Yes"))
		{
			 this.saveSchedule();
		}
		else
		{
			//document.location = '/final/servlet/com.eg.ErFavoriteC?' + queryString + '&call=json&cmd=client&FavoriteId='+favorite_id+ "&shareUsers=" + er_favorite + "&publicUsers=" + er_favorite+"&fromFavoriteModify=yes";
			this.saveFavorite();
		}
	},
	saveSchedule :function(btn)
	{
		var qryString=this.getQueryString(true);
		qryString = "/final/reporter/ErSaveSchedule.jsp?"+qryString+'&dataDrill=yes&pdfPrint=yes&pdfprint=yes&recordInfo='+appConstants.recordInfo;
		
		var favorite_id ="";
		if (appConstants.formButtonId=='saveReport')
		{
			qryString+='&showSchWindow=no';
			var urlNw=qryString.substr(0,qryString.indexOf("?"));
			var queryString=qryString.substr(qryString.indexOf("?")+1,qryString.length-1);
			var formSave = Ext.create('Ext.form.Panel');
			formSave.submit({
				url:urlNw,
				params:queryString,
				standardSubmit: true,
				method: 'POST'
			});
		}
		else
			parent.scheduleWindowFn(qryString);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
	},
	saveFavorite :function(btn)
	{
		var qryString=this.getQueryString(true);
		qryString = "/final/reporter/ErSaveFavorite.jsp?"+qryString+'&dataDrill=yes&pdfPrint=yes&pdfprint=yes&recordInfo='+appConstants.recordInfo+'&deleteTemplate=no';
		
		var favorite_id =appConstants.FavoriteId;
		if (appConstants.formButtonId=='saveReport')			
			document.location=qryString+'&showWindow=no'+"&FavoriteId="+favorite_id;
		else
			parent.favouriteWindowFn(qryString);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
		
		//parent.printWindowFn(qryString); //this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
	},
	printReport :function()
	{
		var qryString=this.getQueryString(false);
		console.log("qryString::::::::::   "+qryString);
		qryString = '/final/reporter/ErPrintReportBuilder.jsp?'+qryString+'&dataDrill=yes&printBy=drillDown&pdfPrint=yes&pdfprint=yes&compName='+compName+'&graphIndex='+graphIndex+'&widgetIdInfo='+widgetIdInfo+'&titleDisp='+appConstants.tempName;
		parent.printWindowFn(qryString); //this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
	},
	dataGridReport :function()
	{
		var qryString=this.getQueryString(false);
		console.log("qryString::::::::::   "+qryString);
		qryString = "/final/reporter/ErPrintReportBuilder.jsp?"+qryString+'&dataDrill=yes&pdfPrint=yes&compName='+compName+'&pdfprint=yes&graphIndex='+graphIndex+'&widgetIdInfo='+widgetIdInfo+'';
		parent.printWindowFn(qryString); //this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
	},
	printCsvReport :function()
	{
		var qryString=this.getQueryString(false);
		console.log("qryString::::::::::   "+qryString);
		window.location = "/final/reporter/ErPrintReportBuilder.jsp?"+qryString+'&dataDrill=yes&compName='+compName+'&pdfPrint=yes&pdfprint=yes&graphIndex='+graphIndex+'&widgetIdInfo='+widgetIdInfo+'&option=csv';
		
	},
	beforeSubmit:function(obj)
	{ 
		var comp=Ext.getCmp('resultcontainer');
		comp.removeAll();			
		comp.show();
		if (appConstants.isCustomLayout=='yes')
		{
			//Ext.getCmp('pbarcont').show(); 
			var i=0.01; 
			var me=this;
			//Ext.getCmp('pbar').updateProgress(i, Math.round(100 * i) + '% completed...');   
			var task = new Ext.util.DelayedTask(function(arguments){
				{
					me.ajaxQueryMaker(obj);
				} 
			}); 
			task.delay(20);
		}
		else
		{
			this.ajaxQueryMaker(obj);
		}
	},
	getQueryString:function(needComponent)
	{
		var params='method=submit';
		params+='&er_option='+Ext.getCmp('er_option').getValue();
		var obj=Ext.getCmp('er_site');
		if (!obj.isHidden())
		{
			params+='&er_site='+obj.getValue();
			
			if (Ext.getCmp('er_option').getValue()=='Zone')
			{
				params+='&er_site='+Ext.getCmp('er_subZone').getValue();
			}			
		}
		//params+='&er_compType='+Ext.getCmp('er_compType').getValue();
		params+='&er_compType='+Ext.getCmp(appConstants.erCompType).getValue();
		if (Ext.getCmp('showLegend') != 'undefined' && Ext.getCmp('showLegend') != undefined)
		{
			params+='&showLegendsEnable='+Ext.getCmp('showLegend').getValue();
		}
		var arr=new Array();
		arr=Ext.getCmp('er_component').getValue();
		for (var key in arr )
		{
			params+='&er_component='+arr[key];
		}	
		params+='&er_test='+Ext.getCmp('er_test').getValue();
		if(appConstants.isMultiMeasureSupport=='yes')
		{
			var arr=new Array();
			arr=Ext.getCmp('er_measure').getValue();
			for (var key in arr )
			{
				params+='&er_measure='+arr[key];
			}
		}
		else
		{
			params+='&er_measure='+Ext.getCmp('er_measure').getValue();
		}
		arr=Ext.getCmp('er_info').getValue();
		for (var key in arr )
		{
			params+='&er_info='+arr[key];
		}
		
		params+='&er_timeline='+Ext.getCmp('er_timeline').getValue();
		params+='&er_stdate='+Ext.getCmp('er_stdate').dataArray;
		params+='&startdate='+Ext.getCmp('er_stdate').dataArray;
		params+='&er_enddate='+Ext.getCmp('er_enddate').dataArray;
		params+='&enddate='+Ext.getCmp('er_enddate').dataArray;
		params+='&er_sthr='+Ext.getCmp('er_sthr').getValue();
		params+='&starthr='+Ext.getCmp('er_sthr').getValue();
		params+='&er_endhr='+Ext.getCmp('er_endhr').getValue();
		params+='&endhr='+Ext.getCmp('er_endhr').getValue();
		params+='&timefrom='+Ext.getCmp('timefrom').getValue();
		params+='&timeto='+Ext.getCmp('timeto').getValue();
		params+='&minfrom='+Ext.getCmp('minfrom').getValue();
		params+="&startmin="+mgr_stmin+"&endmin="+mgr_enmin+"&er_secs=00";
		params+="&er_stmin="+mgr_stmin+"&er_endmin="+mgr_enmin;
		params+='&minto='+Ext.getCmp('minto').getValue();
		params+='&er_reportgenration='+Ext.getCmp('reportGeneration').getValue();
		params+='&er_excwe='+Ext.getCmp('er_excwe').getValue();
		params+='&sorted_col='+Ext.getCmp('groupBy_list').getValue();//.. for sorted measure
		params+='&aggregate_server='+Ext.getCmp('aggregate_server').getValue();
		params+='&er_showBy='+Ext.getCmp('er_showBy').getValue();
		params+='&timeline_showBy='+Ext.getCmp('timeline_showBy').getValue();//...
		params+='&bar_showBy='+Ext.getCmp('bar_showBy').getValue();//...
		params +="&serverAggregate="+appConstants.serverAggregate;
		//params+='&dynamicRangesInfo='Ext.encode(this.getDynamicRangesInfo());
		params+='&dynamicRangesInfo='+this.getDynamicRangesInfo();
		params+='&fromReportBuilder='+appConstants.fromReportBuilder;
		
		if (appConstants.isCustomLayout=='yes')
		{
			params+='&er_top='+Ext.getCmp('er_top').getValue();
		}
		else
		{
			params+='&chartInfo='+appConstants.chartInfo;
			params+='&er_top='+Ext.getCmp('er_top').getValue();
		}
		params+='&isCustomLayout='+appConstants.isCustomLayout; 
		if(!Ext.isEmpty(appConstants.builderJson))
		{
			if(!Ext.isEmpty(appConstants.builderJson.hiddenFields))
			{
				for(var key in appConstants.builderJson.hiddenFields)
				{
					var val=appConstants.builderJson.hiddenFields[key];
					params+='&'+key+"="+val;
				}
			}
		}
		params+='&tempDesc='+appConstants.tempDesc;
		//
		var webAppArray=new Array();
		webAppArray = (Ext.getCmp("er_webAppCombo").getValue()).split(",");
		for(var k=0;webAppArray.length>k;k++)
		{
			params+="&er_webAppCombo="+webAppArray[k];
		}
		if(wildcardSearch && appConstants.clientVersionn != undefined && appConstants.clientVersionn != 'undefined')
			params+='&clientVersionn='+appConstants.clientVersionn;
		//
		return params;
	},
	enableDisableTools:function(flag)
	{	
	
		if(drillDownchartType != undefined && Ext.getCmp('showLegend') != undefined &&(drillDownchartType == "timeline" || drillDownchartType == "area"))
		{
			Ext.getCmp('showLegend').show();
			this.getNewUtilities().loadIcon(true, true, true, true, true, false, false, true, false, false);
					
			Ext.getCmp("csvTool").setDisabled(flag);
			Ext.getCmp("dataTool").setDisabled(flag);
			if(isDDEnabled != undefined && isDDEnabled == 'yes')
				Ext.getCmp("diagnosisTool").setDisabled(flag);
			else
				Ext.getCmp("diagnosisTool").setDisabled(true);
		}
		else
		{
			this.getNewUtilities().loadIcon(true, true, true, false, false, false, false, false, false, false);
		}
		
		Ext.getCmp("saveTool").setDisabled(flag);
		Ext.getCmp("printTool").setDisabled(flag);		
		// temp set as true
		Ext.getCmp("mailTool").setDisabled(flag);		
		
		
	},
	validateMainForm :function(){
		var isValid = true;
		if(isSettingsEnabled)
		{
			isValid=this.validateSettings();			
		}
		return isValid;
	},
	ajaxQueryMaker:function(obj)
	{
		var me=this;
		if(appConstants.isSubmit != undefined && appConstants.isSubmit == 'true')
			return;
		if(!isSettingsEnabled)
		{
			this.invokeSettings();
		}
		if(this.validateMainForm())
		{
			var oid=obj.getId(); 
			var url='/final/reporter/ErReportBuilderDrillDownController.jsp';
			
			var params;
			if(oid=='er_option')
			{
				this.method='optionchange';
				params='method='+this.method+'&er_option='+Ext.getCmp('er_option').getValue();
			}
			else if(oid=='er_site')
			{
				this.method='sitechange';
				//params='method='+this.method+'&er_option='+appConstants.builderJson.selectedFields.selectedAnalysisByCombo+'&er_site='+Ext.getCmp('er_site').getValue()+'&er_subZone='+Ext.getCmp('er_subZone').getValue();
				params='method='+this.method+'&er_option='+Ext.getCmp('er_option').getValue()+'&er_site='+Ext.getCmp('er_site').getValue()+'&er_subZone='+Ext.getCmp('er_subZone').getValue();
			}
			else if(oid=='er_mutiSelComp' || oid=='er_compType')
			{
				this.method='comptypechange';
				params='method='+this.method;
				params+='&er_option='+Ext.getCmp('er_option').getValue();
				var obj=Ext.getCmp('er_site');
				if (!obj.isHidden())
				{
					params+='&er_site='+obj.getValue();
				}
				params+='&er_compType='+Ext.getCmp(appConstants.erCompType).getValue();
			}
			else if(oid=='er_test')
			{
				this.method='testchange';
				
				params='method='+this.method;
				params+='&er_compType='+Ext.getCmp(appConstants.erCompType).getValue();
				var arr=new Array();
				arr=Ext.getCmp('er_component').getValue();
				for (var key in arr )
				{
					params+='&er_component='+arr[key];
				}
				params+='&er_test='+Ext.getCmp('er_test').getValue();
				
				/*var compArray=new Array();
				compArray=Ext.getCmp('er_component').getValue();
				for (var key in compArray )
				{
					params+='&er_component='+compArray[key];
				}*/
			}
			else if(oid=='er_measure')
			{
				this.method='measurechange';
				
				params='method='+this.method;
				params+='&er_compType='+Ext.getCmp(appConstants.erCompType).getValue();
				params+='&er_test='+Ext.getCmp('er_test').getValue();
				var arr=new Array();
				arr=Ext.getCmp('er_component').getValue();
				for (var key in arr )
				{
					params+='&er_component='+arr[key];
				}
				if(appConstants.isMultiMeasureSupport=='yes')
				{
					arr=new Array();
					arr=Ext.getCmp('er_measure').getValue();
					for (var key in arr )
					{
						params+='&er_measure='+arr[key];
					}
				}
				else
				{
					params+='&er_measure='+Ext.getCmp('er_measure').getValue();
				}
				if (appConstants.isCustomLayout!='yes')
				{
					appConstants.isCustomLayout='no';
				}
				params+='&isCustomLayout='+appConstants.isCustomLayout;
			}
			else if(oid=='submit')
			{
				
				var reportgen=Ext.getCmp('reportGeneration').getValue();
				this.method='submit';
				
				params='method='+this.method;
				params+='&popupWindow='+appConstants.popupWindow;
				params+='&clickValue='+appConstants.clickValue;
				params+='&er_option='+Ext.getCmp('er_option').getValue();
				var obj=Ext.getCmp('er_site');
				if (!obj.isHidden())
				{
					params+='&er_site='+obj.getValue();
					
					if (Ext.getCmp('er_option').getValue()=='Zone')
					{
						params+='&er_site='+Ext.getCmp('er_subZone').getValue();
					}			
				}
				params+='&er_compType='+Ext.getCmp(appConstants.erCompType).getValue();
				if (Ext.getCmp('showLegend') != 'undefined' && Ext.getCmp('showLegend') != undefined)
				{
					params+='&showLegendsEnable='+Ext.getCmp('showLegend').getValue();
				}
				var arr=new Array();
				arr=Ext.getCmp('er_component').getValue();
				for (var key in arr )
				{
					params+='&er_component='+arr[key];
				}
				
				params+='&er_test='+Ext.getCmp('er_test').getValue();
				if(appConstants.isMultiMeasureSupport=='yes')
				{
					var arr=new Array();
					arr=Ext.getCmp('er_measure').getValue();
					for (var key in arr )
					{
						params+='&er_measure='+arr[key];
					}
				}
				else
				{
					params+='&er_measure='+Ext.getCmp('er_measure').getValue();
				}
				arr=Ext.getCmp('er_info').getValue();
				for (var key in arr )
				{
					params+='&er_info='+arr[key];
				}			
				
				//params+='&er_function='+Ext.getCmp('er_function').getValue();
				params+='&er_timeline='+Ext.getCmp('er_timeline').getValue();
				params+='&er_stdate='+Ext.getCmp('er_stdate').dataArray;
				params+='&startdate='+Ext.getCmp('er_stdate').dataArray;
				
				
				params+='&er_enddate='+Ext.getCmp('er_enddate').dataArray;
				params+='&enddate='+Ext.getCmp('er_enddate').dataArray;
				
				params+='&er_sthr='+Ext.getCmp('er_sthr').getValue();
				params+='&starthr='+Ext.getCmp('er_sthr').getValue();
				
				params+='&er_endhr='+Ext.getCmp('er_endhr').getValue();
				params+='&endhr='+Ext.getCmp('er_endhr').getValue();

				params+="&startmin="+mgr_stmin+"&endmin="+mgr_enmin+"&er_secs=00";
				params+="&er_stmin="+mgr_stmin+"&er_endmin="+mgr_enmin;

				params+='&timefrom='+Ext.getCmp('timefrom').getValue();
				params+='&timeto='+Ext.getCmp('timeto').getValue();
				params+='&minfrom='+Ext.getCmp('minfrom').getValue();
				params+='&minto='+Ext.getCmp('minto').getValue();
				params+='&er_reportgenration='+Ext.getCmp('reportGeneration').getValue();
				params+='&er_excwe='+Ext.getCmp('er_excwe').getValue();
				params+='&sorted_col='+Ext.getCmp('groupBy_list').getValue();//..for sorted measure
				params+='&aggregate_server='+Ext.getCmp('aggregate_server').getValue();
				params+='&er_showBy='+Ext.getCmp('er_showBy').getValue();
				params+='&timeline_showBy='+Ext.getCmp('timeline_showBy').getValue();//...
				params+='&bar_showBy='+Ext.getCmp('bar_showBy').getValue();//...
				//params+='&dynamicRangesInfo='Ext.encode(this.getDynamicRangesInfo());
				params+='&dynamicRangesInfo='+this.getDynamicRangesInfo();
				params+='&templateName='+appConstants.templateName;//...
				params+='&user_dispName='+appConstants.tempName;
				params+='&fromReportBuilder='+appConstants.fromReportBuilder;
				params +="&serverAggregate="+appConstants.serverAggregate;
				
				if (appConstants.isCustomLayout=='yes')
				{
					params+='&er_top='+Ext.getCmp('er_top').getValue();
				}
				else
				{
					params+='&chartInfo='+appConstants.chartInfo;
					params+='&er_top='+Ext.getCmp('er_top').getValue();
				}
				params+='&recordInfo='+appConstants.recordInfo;
				//
				var webAppArray=new Array();
				webAppArray = (Ext.getCmp("er_webAppCombo").getValue()).split(",");
				for(var k=0;webAppArray.length>k;k++)
				{
					params+="&er_webAppCombo="+webAppArray[k];
				}
				if(wildcardSearch && appConstants.clientVersionn != undefined && appConstants.clientVersionn != 'undefined')
					params+='&clientVersionn='+appConstants.clientVersionn;
				//
			}
			else
			{
				this.method=null;
				return;
			}
			params+='&isCustomLayout='+appConstants.isCustomLayout; 
			if(!Ext.isEmpty(appConstants.builderJson))
			{
				if(!Ext.isEmpty(appConstants.builderJson.hiddenFields))
				{
					for(var key in appConstants.builderJson.hiddenFields)
					{
						var val=appConstants.builderJson.hiddenFields[key];
						params+='&'+key+"="+val;
					}
				}
			}
			
			if(Ext.isEmpty(initLdgMask))
			{
				initLdgMask = new Ext.LoadMask(Ext.getBody(),{msg : "Loading ..."});
			}
			if (reportgen!=null && reportgen == 'background' ) 
			{			
				url='/final/servlet/com.eg.ErStartBackGroundReportC';				
				
				var backgroundresultsObj=Ext.getCmp('backgroundresults');
				var comp=Ext.getCmp('resultcontainer');
				comp.hide(); 
				var bg_reportname=Ext.getCmp('bgReportName').getValue();
				params+='&tempDesc='+appConstants.tempDesc;
				initLdgMask.show();
				Ext.Ajax.request({
					url : url,
					params : params+"&bg_reportname="+bg_reportname,
					scope : this,
					method : 'POST',
					success: function(response){
						var jsonText = response.responseText;
						var jsonData=Ext.decode(jsonText);
						jsonData=jsonData.combo;
						var backgroundReportStatus=jsonData.backgroundReportStatus;
						if(!Ext.isEmpty(backgroundReportStatus) && backgroundReportStatus!= 'undefined')
						{
							if(backgroundReportStatus== 'success'){
								var bgroundResponseTxt=jsonData.bgroundResponseTxt;
								var bgroundReportsURL=jsonData.bgroundReportsURL;
								var backgroundAnchor=jsonData.backgroundAnchor;
								backgroundresultsObj.update('<center><div style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:480px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconSuccess"></div><div style="margin-top:20px"><b>'+bgroundResponseTxt+'</b><br/><a class="backgroundMsgLink" href='+bgroundReportsURL+'>'+backgroundAnchor+'</a></div></div></center>');
							}
							else if(backgroundReportStatus== 'duplicate'){
								var bgroundResponseTxt=jsonData.bgroundResponseTxt;
								var bgroundReportsURL=jsonData.bgroundReportsURL;
								var backgroundAnchor=jsonData.backgroundAnchor;
								backgroundresultsObj.update('<center><div style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:480px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconExists"></div><div style="margin-top:20px"><b>'+bgroundResponseTxt+'</b><br/><a class="backgroundMsgLink" href='+bgroundReportsURL+'>'+backgroundAnchor+'</a></div></div></center>');
							}
						}
						else
						{
							backgroundresultsObj.update('<span>ErroR In BackGround Generation</span>');
						}
						me.enableDisableTools(true);
						initLdgMask.hide();
					}
				});
				
			}
			else
			{
				
				var comp=Ext.getCmp('resultcontainer');
				comp.removeAll(); 
				
				initLdgMask.show();
				if (appConstants.isCustomLayout=='yes' && oid=='submit')
				{

					var comptype=Ext.getCmp(appConstants.erCompType).getValue();
					
					appConstants.widgetList=appConstants.selectedCompTypeWidgets[comptype];
					if(Ext.isEmpty(appConstants.widgetList))
						appConstants.widgetList=appConstants.selectedCompTypeWidgets["all"];

					var beingWatched={}; 
					beingWatched.widgetCount=appConstants.widgetList.length;
					//alert("===beingWatched.widgetCount===>"+beingWatched.widgetCount);
					//beingWatched.ajaxCount=0;
					//alert("==widgetIdInfo===>>>>>>>>"+widgetIdInfo);
					var me=this;
					var pbar = Ext.getCmp('pbar');
					var i=0; 
					var widgetXPos=0;
					var fullMargin = false;

					var task = new Ext.util.DelayedTask(function(arguments){
						{
							//alert("====appConstants.widgetList==>>"+arguments);
							var eachWidget=arguments;
							if(eachWidget.indexOf("$") != -1)
							{
								var xPos=parseInt(eachWidget.substring(eachWidget.indexOf("$")+1));
								eachWidget=eachWidget.substring(0,eachWidget.indexOf("$"));
								widgetXPos = widgetXPos + xPos;
								if(widgetXPos==12)
								{
									//alert("==reached end=next=>>"+eachWidget+"<<<<<==xposi==>>"+widgetXPos);
									widgetXPos=0;
									fullMargin = true;
								}
								else
									fullMargin = false;
							}
							if(widgetIdInfo == eachWidget+'_detail')
								me.callAjax(url,params+'&widget='+eachWidget,false,false,fullMargin);
							beingWatched.ajaxCount++;
						
						
						} 
					}); 
					
					var initialTask = new Ext.util.DelayedTask(function(arguments){
						{
							var eachWidget=arguments;							
							//alert("===sdfsd=====eee>>>"+eachWidget);
							if(eachWidget.indexOf("$") != -1)
							{
								var xPos=parseInt(eachWidget.substring(eachWidget.indexOf("$")+1));
								eachWidget=eachWidget.substring(0,eachWidget.indexOf("$"));
								//alert("===widgetXPos==dsfd>>>>22>>>>>>"+widgetXPos);
								widgetXPos = widgetXPos + xPos;
								if(widgetXPos==12)
								{
									//alert("==reached end==>intisl>"+eachWidget+"<<<<<==xposi==>>"+widgetXPos);
									widgetXPos=0;
									fullMargin=true;
								}
								else
									fullMargin = false;
							}
							if(widgetIdInfo == eachWidget+'_detail')
								me.callAjax(url,params+'&widget='+eachWidget,false,false,fullMargin);
							beingWatched.ajaxCount++;
						
						
						} 
					}); 

			
				Object.defineProperty(beingWatched, 'ajaxCount', {
					get: function() 
					{
						//alert("==inside get===>>>");
						return this.value; 
					},
					set: function(newValue) 
					{
						this.value = newValue; 
						i=this.value/beingWatched.widgetCount;
						if(pbar != undefined)
							pbar.updateProgress(i, Math.round(100 * i) + '% completed...'); 

						if (0==this.value) 
						{
							initialTask.delay(0, null, null, [appConstants.widgetList[beingWatched.ajaxCount]]);
							
						}
						else if(beingWatched.widgetCount != this.value)
						{
							task.delay(0, null, null, [appConstants.widgetList[beingWatched.ajaxCount]]);
							//task.delay(500, null, null, [appConstants.widgetList[beingWatched.ajaxCount]]);
						}
						else
						{
							initLdgMask.hide();
							if (comp.items.items.length<=0)
							{
								// temp command for Gridster
								//comp.add(me.getNoMeasure());
								me.enableDisableTools(true);
							}else
							{
								//me.enableDisableTools(false);
							}
							comp.doComponentLayout();
							comp.doLayout();
						//	me.getMessageBox('Status','all widgets completed for selected '+comptype);
							if(Ext.getCmp('pbarcont') != undefined)
								Ext.getCmp("pbarcont").hide();
							if(pbar != undefined)
								pbar.hide();
						}
					 }
				
				});
				if (appConstants.widgetList.length>0)
				{
					beingWatched.ajaxCount=0;			
				}





					/*Object.observe(beingWatched, function(){
						i=beingWatched.ajaxCount/beingWatched.widgetCount;
						pbar.updateProgress(i, Math.round(100 * i) + '% completed...'); 
									
						if (0==beingWatched.ajaxCount) 
						{
							me.callAjax(url,params+'&widget='+appConstants.widgetList[0],false);
							beingWatched.ajaxCount++;
						}
						else if (beingWatched.widgetCount!=beingWatched.ajaxCount) 
						{				
							task.delay(500, null, null, [appConstants.widgetList[beingWatched.ajaxCount]]);
						}
						else
						{
							initLdgMask.hide();
							if (comp.items.items.length<=0)
							{
								comp.add(me.getNoMeasure());
								me.enableDisableTools(true);
							}else
							{						
								me.enableDisableTools(false);
							}
							comp.doComponentLayout();
							comp.doLayout();
							Ext.getCmp("pbarcont").hide();
							pbar.hide();
						}
					});
					if (appConstants.widgetList.length>0)
					{
						beingWatched.ajaxCount=0;			
					}*/
				}
				else
				{
					//alert("==callAjax from normal==>>"+oid);
					//this.callAjax(url,params,true,true);					
					this.callAjax(url,params,true,false);					
				}
			}
		}
	},
	ajaxQueryMaker11:function()
	{
		if(appConstants.fromFavouriteModify=="Yes" || appConstants.fromScheduleModify=="Yes")
			return;
		var oid=''; 
		if(appConstants.isSubmit!=null && appConstants.isSubmit=='true'){
			oid='submit';
		}
		var url='/final/reporter/ErReportBuilderDrillDownController.jsp';
		var params;
		if(appConstants.isSubmit!=null && appConstants.isSubmit=='true')
		{
			this.method='submit';		
			params='method='+this.method;
			params+='&er_option='+Ext.getCmp('er_option').getValue();
			params+='&serverAggregate='+appConstants.serverAggregate;
			if(fromOverviewReport)
			{
				params+='&fromOverviewReport='+fromOverviewReport;
				params+='&dateInMillisecs='+appConstants.dateInMillisecs;
			}
			var obj=Ext.getCmp('er_site');
			if (!obj.isHidden())
			{
				params+='&er_site='+obj.getValue();
				
				if (Ext.getCmp('er_option').getValue()=='Zone')
				{
					params+='&er_site='+Ext.getCmp('er_subZone').getValue();
				}			
			}
			params+='&er_compType='+Ext.getCmp(appConstants.erCompType).getValue();
			if (Ext.getCmp('showLegend') != 'undefined' && Ext.getCmp('showLegend') != undefined)
			{
				params+='&showLegendsEnable='+Ext.getCmp('showLegend').getValue();
			}
			var arr=new Array();
			arr=Ext.getCmp('er_component').getValue();
			for (var key in arr )
			{
				params+='&er_component='+arr[key];
			}
			
			params+='&er_test='+Ext.getCmp('er_test').getValue();
			if(appConstants.isMultiMeasureSupport=='yes')
			{
				var arr=new Array();
				arr=Ext.getCmp('er_measure').getValue();
				for (var key in arr )
				{
					params+='&er_measure='+arr[key];
				}
			}
			else
			{
				params+='&er_measure='+Ext.getCmp('er_measure').getValue();
			}
			arr=Ext.getCmp('er_info').getValue();
			for (var key in arr )
			{
				params+='&er_info='+arr[key];
			}		
			
			//params+='&er_function='+Ext.getCmp('er_function').getValue();
			params+='&er_timeline='+Ext.getCmp('er_timeline').getValue();
			params+='&er_stdate='+Ext.getCmp('er_stdate').dataArray;
			params+='&startdate='+Ext.getCmp('er_stdate').dataArray;
			
			
			params+='&er_enddate='+Ext.getCmp('er_enddate').dataArray;
			params+='&enddate='+Ext.getCmp('er_enddate').dataArray;
			
			params+='&er_sthr='+Ext.getCmp('er_sthr').getValue();
			params+='&starthr='+Ext.getCmp('er_sthr').getValue();
			
			params+='&er_endhr='+Ext.getCmp('er_endhr').getValue();
			params+='&endhr='+Ext.getCmp('er_endhr').getValue();

			params+="&startmin="+mgr_stmin+"&endmin="+mgr_enmin+"&er_secs=00";
			params+="&er_stmin="+mgr_stmin+"&er_endmin="+mgr_enmin;
			params+='&timefrom='+Ext.getCmp('timefrom').getValue();
			params+='&timeto='+Ext.getCmp('timeto').getValue();
			params+='&minfrom='+Ext.getCmp('minfrom').getValue();
			params+='&minto='+Ext.getCmp('minto').getValue();
			params+='&er_reportgenration='+Ext.getCmp('reportGeneration').getValue();
			params+='&er_excwe='+Ext.getCmp('er_excwe').getValue();
			params+='&aggregate_server='+Ext.getCmp('aggregate_server').getValue();
			params+='&er_showBy='+Ext.getCmp('er_showBy').getValue();
			params+='&timeline_showBy='+Ext.getCmp('timeline_showBy').getValue();
			params+='&bar_showBy='+Ext.getCmp('bar_showBy').getValue();
			//params+='&dynamicRangesInfo='Ext.encode(this.getDynamicRangesInfo());
			params+='&dynamicRangesInfo='+this.getDynamicRangesInfo();
			params+='&sorted_col='+Ext.getCmp('groupBy_list').getValue();
			params+='&templateName='+appConstants.templateName;//...
			params+='&user_dispName='+appConstants.tempName;
			params+='&fromReportBuilder='+appConstants.fromReportBuilder;
			if(wildcardSearch && appConstants.clientVersionn != undefined && appConstants.clientVersionn != 'undefined')
				params+='&clientVersionn='+appConstants.clientVersionn;
			params+='&popupWindow='+appConstants.popupWindow;
			params+='&clickValue='+appConstants.clickValue;
			//
			params+='&userID='+ appConstants.userId;
			//
			//alert("====timelineshowby======>>>>>>"+Ext.getCmp('timeline_showBy').getValue());
			////console.log(appConstants);
			if (appConstants.isCustomLayout=='yes')
			{
				params+='&er_top='+Ext.getCmp('er_top').getValue();
			}
			else
			{
				params+='&chartInfo='+appConstants.chartInfo;
				params+='&er_top='+Ext.getCmp('er_top').getValue();
			}	
			params+='&recordInfo='+appConstants.recordInfo;
			//
			var webAppArray=new Array();
			webAppArray = (Ext.getCmp("er_webAppCombo").getValue()).split(",");
			for(var k=0;webAppArray.length>k;k++)
			{
				params+="&er_webAppCombo="+webAppArray[k];
			}
			//
		}
		else
		{
			this.method=null;
			return;
		}
		params+='&isCustomLayout='+appConstants.isCustomLayout; 
		if(!Ext.isEmpty(appConstants.builderJson))
		{
			if(!Ext.isEmpty(appConstants.builderJson.hiddenFields))
			{
				for(var key in appConstants.builderJson.hiddenFields)
				{
					var val=appConstants.builderJson.hiddenFields[key];
					params+='&'+key+"="+val;
				}
			}
		}
		var comp=Ext.getCmp('resultcontainer');
		comp.removeAll(); 
		if(Ext.isEmpty(initLdgMask))
		{
			initLdgMask = new Ext.LoadMask(Ext.getBody(),{msg : "Loading ..."});
		}
		initLdgMask.show();
		if (appConstants.isCustomLayout=='yes' && oid=='submit')
		{
			/*if(Ext.getCmp('pbarcont') != undefined)
				Ext.getCmp('pbarcont').show();*/
			//var comptype=appConstants.er_compType;		
			//var comptype=Ext.getCmp('er_compType').getValue();
			//alert("====="+appConstants.erCompType);
			var comptype=Ext.getCmp(appConstants.erCompType).getValue();		
			console.log("====comptype=====>>>refresh..>>>>>>"+comptype);
			console.log("===selecttypecomp===>>>refresh..>>>"+JSON.stringify(appConstants.selectedCompTypeWidgets));
			appConstants.widgetList=appConstants.selectedCompTypeWidgets[comptype];
			if(Ext.isEmpty(appConstants.widgetList))
				appConstants.widgetList=appConstants.selectedCompTypeWidgets["all"];
			var beingWatched={}; 
			beingWatched.widgetCount=appConstants.widgetList.length;
			var me=this;
			var pbar = Ext.getCmp('pbar');
			var i=0; 
			var widgetXPos=0;
			var fullMargin = false;

			var task = new Ext.util.DelayedTask(function(arguments){
				{
					var eachWidget=arguments;							
					if(eachWidget.indexOf("$") != -1)
					{
						var xPos=parseInt(eachWidget.substring(eachWidget.indexOf("$")+1));
						eachWidget=eachWidget.substring(0,eachWidget.indexOf("$"));
						widgetXPos = widgetXPos + xPos;
						if(widgetXPos==12)
						{
							//alert("==reached end=next=>>"+eachWidget+"<<<<<==xposi==>>"+widgetXPos);
							widgetXPos=0;
							fullMargin = true;
						}
						else
							fullMargin = false;
					}
					if(widgetIdInfo == eachWidget+'_detail')
						me.callAjax(url,params+'&widget='+eachWidget,false,false,fullMargin);
					beingWatched.ajaxCount++;
				
				} 
			}); 
			
			var initialTask = new Ext.util.DelayedTask(function(arguments){
				{
					var eachWidget=arguments;							
					//alert("===sdfsd=====eee>>>"+eachWidget);
					if(eachWidget.indexOf("$") != -1)
					{
						var xPos=parseInt(eachWidget.substring(eachWidget.indexOf("$")+1));
						eachWidget=eachWidget.substring(0,eachWidget.indexOf("$"));
						//alert("===widgetXPos==dsfd>>>>22>>>>>>"+widgetXPos);
						widgetXPos = widgetXPos + xPos;
						if(widgetXPos==12)
						{
							//alert("==reached end==>intisl>"+eachWidget+"<<<<<==xposi==>>"+widgetXPos);
							widgetXPos=0;
							fullMargin=true;
						}
						else
							fullMargin = false;
					}
					if(widgetIdInfo == eachWidget+'_detail')
						me.callAjax(url,params+'&widget='+eachWidget,false,true,fullMargin);
					beingWatched.ajaxCount++;
				
				} 
			}); 

			
			Object.defineProperty(beingWatched, 'ajaxCount', {
				get: function() 
				{
					//alert("==inside get===>>>");
					return this.value; 
				},
				set: function(newValue) 
				{
					this.value = newValue; 
					i=this.value/beingWatched.widgetCount;
					if(pbar != undefined)
						pbar.updateProgress(i, Math.round(100 * i) + '% completed...'); 

					if (0==this.value) 
					{
						initialTask.delay(0, null, null, [appConstants.widgetList[beingWatched.ajaxCount]]);
						
					}
					else if(beingWatched.widgetCount != this.value)
					{
						task.delay(0, null, null, [appConstants.widgetList[beingWatched.ajaxCount]]);
						//task.delay(500, null, null, [appConstants.widgetList[beingWatched.ajaxCount]]);
					}
					else
					{
						initLdgMask.hide();
						if (comp.items.items.length<=0)
						{
							
							// temp command for Gridster
							//comp.add(me.getNoMeasure());
							me.enableDisableTools(true);
						}else
						{
							me.enableDisableTools(false);
						}
						comp.doComponentLayout();
						comp.doLayout();
					//	me.getMessageBox('Status','all widgets completed for selected '+comptype);
						if(Ext.getCmp('pbarcont') != undefined)
							Ext.getCmp("pbarcont").hide();
						if(pbar != undefined)
							pbar.hide();
					}
				 }
			
			});
			if (appConstants.widgetList.length>0)
			{
				beingWatched.ajaxCount=0;			
			}
			/*Object.observe(beingWatched, function(){ 
				
				i=beingWatched.ajaxCount/beingWatched.widgetCount;
				if(pbar != undefined)
					pbar.updateProgress(i, Math.round(100 * i) + '% completed...'); 			
				
				if (0==beingWatched.ajaxCount) 
				{
					me.callAjax(url,params+'&widget='+appConstants.widgetList[0],false);
					beingWatched.ajaxCount++;
				}
				else if (beingWatched.widgetCount!=beingWatched.ajaxCount) 
				{				
					task.delay(500, null, null, [appConstants.widgetList[beingWatched.ajaxCount]]);
				}
				else
				{
					initLdgMask.hide();
					if (comp.items.items.length<=0)
					{
						comp.add(me.getNoMeasure());
						me.enableDisableTools(true);
					}else
					{
						me.enableDisableTools(false);
					}
					comp.doComponentLayout();
					comp.doLayout();
				//	me.getMessageBox('Status','all widgets completed for selected '+comptype);
					if(Ext.getCmp('pbarcont') != undefined)
						Ext.getCmp("pbarcont").hide();
					if(pbar != undefined)
						pbar.hide();
				}
			});
			if (appConstants.widgetList.length>0)
			{
				beingWatched.ajaxCount=0;			
			}*/
		}
		else
		{
			comp.removeAll(); //...
			this.callAjax(url,params,true,true);
		}
	},
	sleep:function(milliseconds) {
	  var start = new Date().getTime();
	  for (var i = 0; i < 1e7; i++) {
		if ((new Date().getTime() - start) > milliseconds){
		  break;
		}
	  }
	},
	onAjaxSuccess:function(widgetCountStatus)
	{
	/*	if(appConstants.isMultiCompType=='true')
		{
			//alert("====this.method=========>>>success>>>>>>"+appConstants.isMultiCompType);
			Ext.getCmp('er_compType').hide();
			Ext.getCmp('compTypeMultiPane').show();
			Ext.getCmp('er_mutiSelComp').show();
		}
		else
		{
			Ext.getCmp('compTypeMultiPane').hide();
			Ext.getCmp('er_mutiSelComp').hide();
			Ext.getCmp('er_compType').show();
		}*/
		if(Ext.isEmpty(initLdgMask))
		{
			initLdgMask = new Ext.LoadMask(Ext.getBody(),{msg : "Loading ..."});
		}		
		if (appConstants.isCustomLayout=='yes')
		{
			if (appConstants.builderJson.hasOwnProperty("selectedFields"))
			{
				if (appConstants.builderJson.selectedFields.hasOwnProperty("selectedCompTypeWidgets"))
				{
					appConstants.selectedCompTypeWidgets=appConstants.builderJson.selectedFields.selectedCompTypeWidgets;// contains all widgets configured for selected component type
				}
			}
		}	
		
		if (this.method=='init'|| (appConstants.isSubmit!=null && appConstants.isSubmit=='true'))
		{
			//alert("==drill down ======>>>");
			//this.getMain().setTitle(appConstants.templateTitle);
			var templateNameDisp=appConstants.tempName;
			if(templateNameDisp != undefined && templateNameDisp.indexOf('.') != -1)
				templateNameDisp=templateNameDisp.substring(templateNameDisp.indexOf('.')+1);
			this.getMain().setTitle(templateNameDisp);
			this.loadComboField('er_option','analysisByCombo',null,'selectedAnalysisByCombo',appConstants.builderJson,false,null,false);
			this.loadComboField('er_site','siteCombo','labelSiteCombo','selectedSiteCombo',appConstants.builderJson,false,null,true);
			this.loadComboField('er_subZone','subZoneCombo','labelSubZoneCombo','selectedSubZoneCombo',appConstants.builderJson,false,null,false);
			//this.loadComboField('er_mutiSelComp','componentTypeCombo',null,'selectedComponentTypeCombo',appConstants.builderJson,true,'compTypeMultiPane',false);
			this.loadComboField('er_component','componentCombo',null,'selectedComponentCombo',appConstants.builderJson,true,'compmultipane',false);
			this.loadComboField('er_test','testCombo',null,'selectedTestCombo',appConstants.builderJson,false,null,false);
			if (appConstants.isMultiMeasureSupport=='yes')
				this.loadComboField('er_measure','measureCombo',null,'selectedMeasureCombo',appConstants.builderJson,true,'measmultipane',false);
			else
				this.loadComboField('er_measure','measureCombo',null,'selectedMeasureCombo',appConstants.builderJson,false,null,false);
			if(appConstants.isMultiCompType=='true')
				this.loadComboField(appConstants.erCompType,'componentTypeCombo',null,'selectedComponentTypeCombo',appConstants.builderJson,true,'compTypeMultiPane',false);
			else
				this.loadComboField(appConstants.erCompType,'componentTypeCombo',null,'selectedComponentTypeCombo',appConstants.builderJson,false,null,false);
			this.loadComboField('er_info','infoCombo',null,'selectedInfoCombo',appConstants.builderJson,true,'infomultipane',false);
			this.loadComboField('er_timeline','timelineCombo',null,'selectedTimelineCombo',appConstants.builderJson,false,null,false);
			//this.loadComboField('er_function','functionCombo',null,'selectedFunctionCombo',appConstants.builderJson,false,null,false);
			if(appConstants.builderJson.isHeaderFooterUpdate!=undefined&&appConstants.builderJson.isHeaderFooterUpdate=='yes')
			{
				return;
			}
			if(appConstants.builderJson.selectedFields.enableAggreagation=="true")
			{
				Ext.getCmp("aggregate_server").show();
				this.loadComboField('aggregate_server','aggregateServerCombo',null,'selectedAggregateValue',appConstants.builderJson,false,null,false);
			}
			else
				Ext.getCmp("aggregate_server").hide();
			//alert("====table only======="+appConstants.builderJson.selectedFields.enableSortedBy);
			if(appConstants.builderJson.selectedFields.enableSortedBy==true)
			{
				this.loadComboField('groupBy_list','groupByCombo',null,'selectTableCol',appConstants.builderJson,false,null,false);//.. for getting sort by value
				Ext.getCmp("groupBy_list").show();
			}
			else
				Ext.getCmp("groupBy_list").hide();		

			this.loadComboField('er_excwe','excludeWeekendsCombo',null,'selectedExcludeWeekendsCombo',appConstants.builderJson,false,null,false);
			this.loadComboField('er_showBy','showByCombo',null,'selectedShowByCombo',appConstants.builderJson,false,null,false);
			//..			
			if(appConstants.builderJson.selectedFields.selectedtimeShowByCombo != undefined)
			{
				this.loadComboField('timeline_showBy','timelineShowByCombo',null,'selectedtimeShowByCombo',appConstants.builderJson,false,null,false);
				Ext.getCmp("timeline_showBy").show();
			}
			else
				Ext.getCmp("timeline_showBy").hide();		
			if(appConstants.builderJson.selectedFields.selectedbarShowByCombo != undefined)
			{
				this.loadComboField('bar_showBy','barShowByCombo',null,'selectedbarShowByCombo',appConstants.builderJson,false,null,false);
				Ext.getCmp("bar_showBy").show();
			}
			else
				Ext.getCmp("bar_showBy").hide();		
			//
			if(appConstants.builderJson.combo.webAppCombo != undefined){
				//Ext.getCmp('customTextField').show();
				this.loadComboField('er_webAppCombo','webAppCombo',null,'selectedWebAppCombo',appConstants.builderJson.combo.webAppCombo,true,null,false);
				webAppCombo = appConstants.builderJson.combo.webAppCombo;
				Ext.getCmp("er_webAppCombo").setValue(appConstants.builderJson.selectedFields.selectedWebAppCombo);
			}
				//
			//..
			
			this.loadComboField('er_top','topCombo',null,'selectedTopCombo',appConstants.builderJson,false,null,false);
			this.loadComboField('reportGeneration','reportGenerationCombo',null,'selectedReportGenerationCombo',appConstants.builderJson,false,null,false);
			
			////////// create random scroll combo for Range setting start
			if(appConstants.builderJson.combo.dynamicRangeField!=undefined && appConstants.builderJson.combo.dynamicRangeField.length>0)
			{
				Ext.getCmp('rangeSettingsItemsId').collapse();
				Ext.getCmp('rangeSettingsItemsId').expand();
				Ext.getCmp('rangeSettingsSplitter').show();
				Ext.getCmp('rangeSettingsItemsId').show();
				var rangeComp=Ext.getCmp('rangeSettingsItemsId');
				//appConstants.builderJson.combo.dynamicRangeField.length
				for(var i=0;i<appConstants.builderJson.combo.dynamicRangeField.length;i++)
				{
					rangeComp.add({
						xtype:'fieldcontainer',
						id:appConstants.builderJson.combo.dynamicRangeField[i],
						layout:{
							type: 'column',
							align:'stretch'
							},
						flex:1,
						defaults:{
							labelSeparator : '',
							labelAlign: 'top',
							margin:'0 5 5 0',
							columnWidth:0.5,
						},
						items:[
							{
								xtype:'scrollcombo',
								store: new Ext.data.Store({
									fields: ['displayField', 'valueField'],
									data: appConstants.builderJson.combo.dynamicRangeValue
									}),
								displayField: 'displayField',
								value:'None',
								valueField: 'valueField',
								fieldLabel: appConstants.builderJson.combo.dynamicRangeField[i],
								id: 'dynamicRangeCombo_'+i,
								name: 'dynamicRangeCombo_'+i,
								txtFieldId:'disp_MeasureName'+i,
								listeners:
								{
									select:function( field, value, eOpts )
									{
										if(this.getValue()!='None')
											Ext.getCmp(this.txtFieldId).show();
										else
										{
											Ext.getCmp(this.txtFieldId).hide();
											Ext.getCmp(this.txtFieldId).setValue('');
										}
									}
								}
							},
							{
								xtype: 'textfield',
								fieldLabel: 'Range value',
								cls: 'textbox',
								maskRe: /[0-9 .]/,
								width:200,
								id: 'disp_MeasureName'+i,
								name:'disp_MeasureName'+i,
								hidden:true,
							},
						]
					});
				}
			}
			//////// end
			var component = Ext.ComponentManager.get('er_stdate'); 
			component.setValue(appConstants.builderJson.selectedFields.selectedStartDateDisp);
			component.dataArray =  appConstants.builderJson.selectedFields.selectedStartDateVal;
			component = Ext.ComponentManager.get('er_enddate'); 
			component.setValue(appConstants.builderJson.selectedFields.selectedEndDateDisp);
			component.dataArray =  appConstants.builderJson.selectedFields.selectedEndDateVal;
			component = Ext.ComponentManager.get('er_sthr'); 
			component.setValue(appConstants.builderJson.selectedFields.selectedStartHour);
			component = Ext.ComponentManager.get('er_endhr'); 
			component.setValue(appConstants.builderJson.selectedFields.selectedEndHour);
			Ext.ComponentManager.get('timefrom').setValue(appConstants.builderJson.selectedFields.selectedTimefrom); 
			Ext.ComponentManager.get('timeto').setValue(appConstants.builderJson.selectedFields.selectedTimeto); 
			Ext.ComponentManager.get('minfrom').setValue(appConstants.builderJson.selectedFields.selectedMinfrom); 
			Ext.ComponentManager.get('minto').setValue(appConstants.builderJson.selectedFields.selectedMinto);
			mgr_stmin=appConstants.builderJson.selectedFields.selectedStartMin;
			mgr_enmin=appConstants.builderJson.selectedFields.selectedEndMin;

		//	alert("mgr_stmin "+mgr_stmin+"  mgr_enmin "+mgr_enmin);

			if (Ext.isEmpty(appConstants.erUtils))
				appConstants.erUtils = Ext.widget("erutils");
			if(!hideBackButton){
				Ext.getCmp('templateform').add(
				{
					xtype: 'hidden',
					id: 'ID',
					name: 'ID',
					value: appConstants.builderJson.combo['ID']
				});
			}
		} 
		else if(this.method=='optionchange')
		{
			this.loadComboField('er_site','siteCombo','labelSiteCombo','selectedSiteCombo',appConstants.builderJson,false,null,true);
			this.loadComboField('er_subZone','subZoneCombo','labelSubZoneCombo','selectedSubZoneCombo',appConstants.builderJson,false,null,false);
			if(appConstants.isMultiCompType=='true')
				this.loadComboField(appConstants.erCompType,'componentTypeCombo',null,'selectedComponentTypeCombo',appConstants.builderJson,true,'compTypeMultiPane',false);
			else
				this.loadComboField(appConstants.erCompType,'componentTypeCombo',null,'selectedComponentTypeCombo',appConstants.builderJson,false,null,false);
			this.loadComboField('er_component','componentCombo',null,'selectedComponentCombo',appConstants.builderJson,true,'compmultipane',false);
			this.loadComboField('er_test','testCombo',null,'selectedTestCombo',appConstants.builderJson,false,null,false);
			if (appConstants.isMultiMeasureSupport=='yes')
				this.loadComboField('er_measure','measureCombo',null,'selectedMeasureCombo',appConstants.builderJson,true,'measmultipane',false);
			else
				this.loadComboField('er_measure','measureCombo',null,'selectedMeasureCombo',appConstants.builderJson,false,null,false);
			this.loadComboField('er_info','infoCombo',null,'selectedInfoCombo',appConstants.builderJson,true,'infomultipane',false);
		}
		else if(this.method=='comptypechange')
		{
			this.loadComboField('er_component','componentCombo',null,'selectedComponentCombo',appConstants.builderJson,true,'compmultipane',false);
			this.loadComboField('er_test','testCombo',null,'selectedTestCombo',appConstants.builderJson,false,null,false);
			if (appConstants.isMultiMeasureSupport=='yes')
				this.loadComboField('er_measure','measureCombo',null,'selectedMeasureCombo',appConstants.builderJson,true,'measmultipane',false);
			else
				this.loadComboField('er_measure','measureCombo',null,'selectedMeasureCombo',appConstants.builderJson,false,null,false);
			this.loadComboField('er_info','infoCombo',null,'selectedInfoCombo',appConstants.builderJson,true,'infomultipane',false); 
			this.loadComboField('groupBy_list','groupByCombo',null,'',appConstants.builderJson,true,null,false);//.. for getting sort by value
		}
		else if(this.method=='testchange')
		{
			if (appConstants.isMultiMeasureSupport=='yes')
				this.loadComboField('er_measure','measureCombo',null,'selectedMeasureCombo',appConstants.builderJson,true,'measmultipane',false);
			else
				this.loadComboField('er_measure','measureCombo',null,'selectedMeasureCombo',appConstants.builderJson,false,null,false);
					this.loadComboField('er_info','infoCombo',null,'selectedInfoCombo',appConstants.builderJson,true,'infomultipane',false); 	
		}
		else if(this.method=='measurechange')
		{
			this.loadComboField('er_info','infoCombo',null,'selectedInfoCombo',appConstants.builderJson,true,'infomultipane',false); 	
		}
		else if(this.method=='sitechange')
		{
			if(appConstants.isMultiCompType=='true')
				this.loadComboField(appConstants.erCompType,'componentTypeCombo',null,'selectedComponentTypeCombo',appConstants.builderJson,true,'compTypeMultiPane',false);
			else
				this.loadComboField(appConstants.erCompType,'componentTypeCombo',null,'selectedComponentTypeCombo',appConstants.builderJson,false,null,false);
			this.loadComboField('er_component','componentCombo',null,'selectedComponentCombo',appConstants.builderJson,true,'compmultipane',false);
			this.loadComboField('er_test','testCombo',null,'selectedTestCombo',appConstants.builderJson,false,null,false);
			if (appConstants.isMultiMeasureSupport=='yes')
				this.loadComboField('er_measure','measureCombo',null,'selectedMeasureCombo',appConstants.builderJson,true,'measmultipane',false);
			else
				this.loadComboField('er_measure','measureCombo',null,'selectedMeasureCombo',appConstants.builderJson,false,null,false);
			this.loadComboField('er_info','infoCombo',null,'selectedInfoCombo',appConstants.builderJson,true,'infomultipane',false);
		}
		else if(this.method=='submit')
		{
			
			if (appConstants.isCustomLayout=='yes')
			{
				this.executeWidgetLayout(widgetCountStatus);
			}
			else
			{
				this.executeSingleLayout(widgetCountStatus);
			}
			this.hideComboField();
		}
		else
		{
			//alert("===========mismatch method=======>>>");
		}
		//..
		if(appConstants.isSubmit!=null && appConstants.isSubmit=='true')
		{	
			this.ajaxQueryMaker11();
			appConstants.isSubmit='false';
		}
		//..
		initLdgMask.hide();
	},
	executeWidgetLayout:function(widgetCountStatus)
	{
		var isEnableEditor=false;
		if(neeedEditableHeader=='yes')
			isEnableEditor=true;
		var me=this;
		var comp=Ext.getCmp('resultcontainer');
		if (appConstants.builderJson.data.hasOwnProperty('widgetCollection'))
		{
			if(widgetCountStatus == true)
			{
				Ext.getCmp('templateFormItms').show();
				//Ext.getCmp('panelinsidetoggle').show();
				//Ext.getCmp('panelinsidetoggle').setDisabled(false);
			}
			
			var widgetCollection= appConstants.builderJson.data.widgetCollection;
			if (!Ext.isEmpty(widgetCollection))
			{	
				for (var widget in widgetCollection)
				{
					
					var widgetObject=widgetCollection[widget];
					if(widgetObject.widgetId+'_detail'==widgetIdInfo) 
					{
						drillDownchartType=widgetObject.chartType;
						var testCollection=widgetObject.testCollection;
						for (var test in testCollection)
						{
							var testObject=testCollection[test]; 
							var measureCollection=testObject.measureCollection;
							for (var measure in measureCollection)
							{
								var measureObject=measureCollection[measure];
							var widgetArray=new Array();
							var chartCollection=[];
							var chartType='';
							
							if(measureObject.hasOwnProperty('timelineChartCollection'))
									{
								chartType='timeline';
								
								chartCollection = measureObject.timelineChartCollection;
								}	
							if(measureObject.hasOwnProperty('heatMapChartCollection'))
							{
								chartType='heatMap';								
								chartCollection = measureObject.heatMapChartCollection;
							}				
							else if (measureObject.hasOwnProperty('barChartCollection'))
							{					
							
								chartType='bar';
								if (Ext.isEmpty(appConstants.erUtils))
										{
									appConstants.erUtils = Ext.widget("erutils");
										}								
								chartCollection = measureObject.barChartCollection;
							
							}
							else if (measureObject.hasOwnProperty('stackedBarChartCollection'))
							{
								chartType='stackedbar';
								if (Ext.isEmpty(appConstants.erUtils))
								{  
									appConstants.erUtils = Ext.widget("erutils");
								}		
								chartCollection = measureObject.stackedBarChartCollection;
								
							}	
							else if (measureObject.hasOwnProperty('distributedPieChartCollection'))
							{
								chartType='distpie';
								if (Ext.isEmpty(appConstants.erUtils))
								{
									appConstants.erUtils = Ext.widget("erutils");
								}
								chartCollection = measureObject.distributedPieChartCollection;
							}
							else if (measureObject.hasOwnProperty('distributionChartCollection'))
							{
								chartType='pie';
								if (Ext.isEmpty(appConstants.erUtils))
								{
									appConstants.erUtils = Ext.widget("erutils");
								}
								chartCollection = measureObject.distributionChartCollection;
							}
							else if (measureObject.hasOwnProperty('gridCollection'))
							{				
								chartType='table';
								if (Ext.isEmpty(appConstants.erUtils))
								{
									appConstants.erUtils = Ext.widget("erutils");
								}
								chartCollection = measureObject.gridCollection;
							}
							var setAutoScroll=false;
							if(chartType != undefined && chartType=='bar')
							{
								//setAutoScroll=true;
							}
							if(chartCollection!=undefined && chartCollection.length>0)
							{
								var mainDivWidth=document.getElementById("main").offsetWidth;
								var mainDivHeight=document.getElementById("main").offsetHeight;
								var chartCollectionTemp=chartCollection[graphIndex];
								if(chartCollectionTemp.DataSet != undefined && chartCollectionTemp.DataSet.length==0)
									setAutoScroll=false;
								widgetArray.push(this.loadWidgetData(widgetObject.widgetId+'_panel',chartCollectionTemp,widgetIdInfo,chartType,700,280));
								var bodyPadding='20 20 0 10';
								var sharePointContent = chartCollectionTemp['isSharePointContentReport'];
								if(sharePointContent!=undefined || sharePointContent!='undefined' && sharePointContent =='true') {
									bodyPadding = '10 10 0 20';
								}
								var lblId=  appConstants.templateName+"$~$"+widgetObject.widgetId+"$~$"+"footerDescription";
								var lblIdHeader=  appConstants.templateName+"$~$"+widgetObject.widgetId+"$~$"+"headerDescription";
								comp.add({
									xtype:'panel',
									id:widgetObject.widgetId+'_panel',
									closeAction:'destroy',
									//cls:'datapanel',
									ui:'newGraphPanel',
									//title: '<div style="float:left" class="font_normal12">'+widgetObject.widgetHeader+'</div><div id ="iconRename" style="float:left;margin-left:20px" class="'+iconRename+'"></div>',
									title: '<table cellpadding="0" cellspacing="0" border="0"><tr><td class="newFont_bold14" style="padding:4px 0px 0px 0px">'+widgetObject.widgetHeader+'</td><td id ="iconRename" style="float:left;margin-left:20px;" class="'+iconRename+'"></td></tr></table>',
									margin:'0 0 10 0',
									height:320,
									scroll:false,
									bodyPadding:bodyPadding,
									layout:'fit',
									align:'stretch',
									autoScroll:setAutoScroll,//...
									overflowX:'hidden',
									overflowY:'auto',
									columnWidth:1.0,
									header:{
										/*height:28,
										padding:'0 0 0 5',
										margin:0,
										cls:'reportWidgetHeader',*/
									},
									tools:[],
									dockedItems:[{
										xtype:'toolbar',
										dock:'bottom',
										align:'stretch',
										overCls:'reporterTemplateWidgetToolbarOver',
										layout:'fit',
										hidden:!isEnableEditor,
										cls:'reporterTemplateWidgetToolbar',
										height:42,
										hidden:true,
										items:[{
											xtype:'container',
											layout: {
												type: 'hbox',
												align: 'middle'
											},
												//align:'stretch',
											items:[
											{
												xtype: 'button',
												width:16,
												height:16,
												padding:0,
												margin:'8 4 8 10',
												id: 'widgetDescriptor'+widgetObject.widgetId,
												cls:'iconDescription',
												listeners: {
													afterrender: function () {
														Ext.create('Ext.tip.ToolTip', {
															target: this.id,
															anchor: 'top',
															cls: 'yellowTip',
															trackMouse: true,
															html:'Widget Descriptor'
														});
													}
												}	
											},
											{
												xtype: 'label',
												//forId: 'myFieldId',
												text:widgetObject.widgetFooter,
												margin: '5 10 0 5',
												flex:1,
												cls:'handSymbol',
												listeners: {
												afterrender:function(obj){
													obj.el.on('click',this.onEdit,this);
													},				
												},
												onEdit: function(event, element,obj)
												{ 
													var me = this;
				
													if(!me.editor) {
														me.editor = Ext.create('Ext.Editor', {
																								//width: 300,
															updateEl: true,
															completeOnEnter: true,
															cancelOnEsc: true,
																								floating: false,
																								//shadow: false,
																								alignment: 'tl',
															autoSize: {
																									width: 'boundEl', // Width from the field
																									height: '21' // Height from the boundEl
															},
															hideEl: false,
																								offsets: [0,-2],
															field: {
																xtype: 'textfield',
																									cls: 'textbox',
															},
															listeners: {
																complete: {
																	fn: function(self, value, startValue, opts) {												
																		var url='/final/reporter/ErReportBuilderDrillDownController.jsp';
																		var controller=appConstants.appObj.getController(appConstants.appController);
																		var params='&widgetHeaderFooterInfo='+value;
																		params+='&method=setWidgetHeaderFooter';
																											params+='&isCustomLayout='+appConstants.isCustomLayout;
																		params+='&templateName='+appConstants.templateName;
																		params+='&idDescription='+lblId;
																		controller.callAjax(url,params,false,true);
																	},
																	scope: me,
																}
															}
														});
													}
													me.editor.startEdit(element);
												}
											}]
										}]
									}],
									listeners:
									{
										boxready:function(obj)
										{
											if (!Ext.isEmpty(obj.header))
											{
												var el =Ext.get(obj.header.id+'_hd-textEl');
												if(isEnableEditor)
												{
													Ext.get(obj.header.id).on('click', function(e,target){
														var edtrText=el.dom.innerText; 
														var editor = new Ext.Editor({
															width: 150,
															alignment: 'tl',
															floating: false,
															shadow: false,
															updateEl: true,
															completeOnEnter: true,
															cancelOnEsc: true,
															field: {
																xtype: 'textfield',
																	cls: 'textbox',
																	maxLength:32,
																	enforceMaxLength: true
																},
																listeners: {
																																		
																	'complete': function (edtr, value, startValue, eOpts) {
																		el.dom.innerHTML=value;
																		el.dom.innerHTML='<div style="float:left" class="font_normal12">'+value+'</div><div id ="iconRename" style="float:left;margin-left:20px" class="iconRename"></div>';
																		var url='/final/reporter/ErReportBuilderDrillDownController.jsp';
																		var controller=appConstants.appObj.getController(appConstants.appController);
																		var params='&widgetHeaderFooterInfo='+value;
																		params+='&method=setWidgetHeaderFooter';
																		params+='&templateName='+appConstants.templateName;
																		params+='&isCustomLayout='+appConstants.isCustomLayout;
																		params+='&fromReportBuilder='+appConstants.fromReportBuilder;
																		params+='&idDescription='+lblIdHeader;
																		controller.callAjax(url,params,false,true);
																	}
																}
															});
															editor.startEdit(el,edtrText);													
													}, obj, {delegate: '#'+obj.header.id+'_hd-textEl'});
												}										
											}
										}
									}, 
									items:widgetArray
								});
							}
							else
							{
								comp.add(this.getNoMeasure());
							}
						}
				} 
				}
			}
			if(widgetCountStatus == true)
			{
				//Ext.getCmp('selectionDetails').setSelectionDetailsData(appConstants.builderJson.selectionDetails);
			}			
		}
		else
		{
			comp.add(this.getNoMeasure());
		}
	}
	else
	{
		comp.add(this.getNoMeasure());
	}
	comp.doLayout();
	comp.doComponentLayout();
	},	
	executeSingleLayout:function(widgetCountStatus)
	{
		var comp=Ext.getCmp('resultcontainer');
		if (!Ext.isEmpty(appConstants.builderJson.data) && appConstants.builderJson.data.hasOwnProperty('measureCollection'))
		{
			comp.removeAll();
			var measureCollection= appConstants.builderJson.data.measureCollection;
			var headerDescription= appConstants.builderJson.data.headerDescription;
			var widgetHeader= appConstants.builderJson.data.widgetHeader;
			if (!Ext.isEmpty(measureCollection))
			{
				var colStatus="testWise";
				if(widgetCountStatus)
					this.enableDisableTools(false);//..
				for (var measure in measureCollection)
				{
					var measureObject=measureCollection[measure];
					var widgetIdInfo = 'widget';
					var drillDownUrlFlag=true , csvInfoUrlFlag=true,gridInfoUrlFlag=true;
					var chartCollection;
					var chartType='';
					var chartTypeCollection='';
					if(measureObject.hasOwnProperty('timelineChartCollection'))
					{
						chartType='timeline';
						chartTypeCollection='timelineChartCollection';
						chartCollection = measureObject.timelineChartCollection;
					}
					else if(measureObject.hasOwnProperty('heatMapChartCollection'))
					{
						chartType='heatMap';
						chartTypeCollection='heatMapChartCollection';
						chartCollection = measureObject.heatMapChartCollection;
					}
					else if (measureObject.hasOwnProperty('barChartCollection'))
					{
						chartType='bar';
						chartTypeCollection='barChartCollection';
						if (Ext.isEmpty(appConstants.erUtils))
						{
							appConstants.erUtils = Ext.widget("erutils");
						}
						chartCollection = measureObject.barChartCollection;
					}
					else if (measureObject.hasOwnProperty('stackedBarChartCollection'))
					{
						chartType='stackedbar';
						chartTypeCollection='stackedBarChartCollection';
						if (Ext.isEmpty(appConstants.erUtils))
						{
							appConstants.erUtils = Ext.widget("erutils");
						}
						chartCollection = measureObject.stackedBarChartCollection;
					}
					else if (measureObject.hasOwnProperty('distributedPieChartCollection'))
					{
						chartType='distpie';
						chartTypeCollection='distributedPieChartCollection';
						if (Ext.isEmpty(appConstants.erUtils))
						{
							appConstants.erUtils = Ext.widget("erutils");
						}
						chartCollection = measureObject.distributedPieChartCollection;
					}
					else if (measureObject.hasOwnProperty('distributionChartCollection'))
					{
						chartType='pie';
						chartTypeCollection='distributionChartCollection';
						if (Ext.isEmpty(appConstants.erUtils))
						{
							appConstants.erUtils = Ext.widget("erutils");
						}
						chartCollection = measureObject.distributionChartCollection;
					}
					else if (measureObject.hasOwnProperty('gridCollection'))
					{
						chartType='table';
						chartTypeCollection='gridCollection';
						if (Ext.isEmpty(appConstants.erUtils))
						{
							appConstants.erUtils = Ext.widget("erutils");
						}
						chartCollection = measureObject.gridCollection;
					}
					//this.enableDisableTools(false);
					if(chartCollection instanceof Array)
					{
						var chartCollectionVal = chartCollection[graphIndex];
						var mainDivWidth=document.getElementById("main").offsetWidth;
						var mainDivHeight=document.getElementById("main").offsetHeight;
						var calculatedBaseDimensionY=mainDivHeight*0.1500;
						var calculatedBaseDimensionX=((mainDivWidth)/12);
						calculatedBaseDimensionX=Ext.util.Format.round(calculatedBaseDimensionX, 0);
						calculatedBaseDimensionX=calculatedBaseDimensionX*12;
						var panelHeight=4*calculatedBaseDimensionY;
						panelHeight=Ext.util.Format.round(panelHeight, 0);
						var bodyPadding='5 20 0 10';
						if(chartType=='table')
						{
							bodyPadding='10';
						}
						var widgetArray=new Array();
						widgetArray.push(this.loadWidgetData(widgetIdInfo+graphIndex+'_panel',chartCollectionVal,widgetIdInfo,chartType,calculatedBaseDimensionX,panelHeight));
						var lblId = appConstants.templateName+"$~$widget$~$"+"footerDescription";
						//var lblIdHeader =appConstants.templateName+"$~$widget$~$"+"headerDescription";
						if(chartCollectionVal.title == "" || chartCollectionVal.title == " " || chartCollectionVal.title == "title")
						{
							chartCollectionVal.title=widgetHeader;
						}
						comp.add({
					xtype:'panel',
							id:widgetIdInfo+graphIndex+'_panel',
							closeAction:'destroy',
							ui:'newGraphPanel',
							title: '<div style="float:left" class="font_normal12">'+chartCollectionVal.title+'</div><div id ="iconRename" style="float:left;margin-left:20px" class="iconRename"></div>',
							margin:'0 0 10 0',
							height:370,
							scroll:false,
							bodyPadding:bodyPadding,
							layout:'fit',
							align:'stretch',
							autoScroll:true,
							overflowX:'hidden',
							overflowY:'auto',
							chartCollectionVal:chartCollectionVal,	
							graphIndex:graphIndex,
							columnWidth:1.0,
							chartType:chartType,
							chartTypeCollection:chartTypeCollection,
//							header:{
//								height:28,
//								padding:'0 0 0 5',
//								margin:'-2 0 0 0',
//								cls:'reportWidgetHeader',
//							},
							dockedItems:[{
								xtype:'toolbar',
								dock:'bottom',
								align:'stretch',
								layout:'fit',
								overCls:'reporterTemplateWidgetToolbarOver',
								cls:'reporterTemplateWidgetToolbar',
								height:42,
								items:[{
									xtype:'container',
									layout: {
										type: 'hbox',
										align: 'middle'
									},
									//align:'stretch',
									items:[
										{
											xtype: 'button',
											width:16,
											height:16,
											padding:0,
											margin:'8 4 8 10',
											id: 'widgetDescriptor'+widgetIdInfo+graphIndex,
											cls:'iconDescription',
											listeners: {
												afterrender: function () {
													Ext.create('Ext.tip.ToolTip', {
														target: this.id,
														anchor: 'top',
														cls: 'yellowTip',
														trackMouse: true,
														html:'Widget Descriptor'
													});
												}
											}
										},
										{
											xtype: 'label',
											id:lblId+graphIndex,
											text:appConstants.builderJson.data.widgetFooter,
											margin: '5 10 5 5',
											flex:1,
											cls:'handSymbol',
											listeners:{
												afterrender:function(obj){
													obj.el.on('click',this.onEdit,this);
													},				
											},
											onEdit: function(event, element,obj)
											{ 
												var me = this;
												if(!me.editor) {
													me.editor = Ext.create('Ext.Editor', {
														//width: 300,
														updateEl: true,
														completeOnEnter: true,
														cancelOnEsc: true,
														floating: false,
														//shadow: false,
														alignment: 'tl',
														autoSize: {
															width: 'boundEl', // Width from the field
															height: '21' // Height from the boundEl
														},
														hideEl: false,
														offsets: [0,-2],
														field: {
															xtype: 'textfield',
															cls: 'textbox',
														},
														listeners: {
															complete: {
																fn: function(self, value, startValue, opts) {
																	var url='/final/reporter/ErReportBuilderDrillDownController.jsp';
																	var controller=appConstants.appObj.getController(appConstants.appController);
																	var params='&widgetHeaderFooterInfo='+value;
																	params+='&isCustomLayout='+appConstants.isCustomLayout;
																	params+='&method=graphHeaderFooter';
																	params+='&templateName='+appConstants.templateName;
																	params+='&chartType='+thisPanel.chartType;
																	params+='&chartTypeCollection='+thisPanel.chartTypeCollection;
																	params+='&idDescription=footer$~$'+thisPanel.graphIndex;
																	controller.callAjax(url,params,false,true);
																},
																scope: me,
															}
														}
													});
												}
												me.editor.startEdit(element);
											}
										},
									]
								}]
							}
							],
							listeners:{
								boxready:function(obj)
								{
									if (!Ext.isEmpty(obj.header))
									{
										var el =Ext.get(obj.header.id+'_hd-textEl');
										Ext.get(obj.header.id).on('click', function(e,target){
											var edtrText=el.dom.innerText; 
											var editor = new Ext.Editor({
												width: 150,
												alignment: 'tl',
												floating: false,
												shadow: false,
												updateEl: true,
												completeOnEnter: true,
												cancelOnEsc: true,
												field: {
													xtype: 'textfield',
													cls: 'textbox',
													maxLength:32,
													enforceMaxLength: true
												},
												listeners: {
													'complete': function (edtr, value, startValue, eOpts) {
														el.dom.innerHTML=value;
														el.dom.innerHTML='<div style="float:left" class="font_normal12">'+value+'</div><div id ="iconRename" style="float:left;margin-left:20px" class="iconRename"></div>';
														var url='/final/reporter/ErReportBuilderDrillDownController.jsp';
														var controller=appConstants.appObj.getController(appConstants.appController);
														//controller.method='setWidgetDescription';
														var thisPanel=obj;
														var params='&widgetHeaderFooterInfo='+value;
														params+='&isCustomLayout='+appConstants.isCustomLayout;
														params+='&method=graphHeaderFooter';
														params+='&templateName='+appConstants.templateName;
														params+='&fromReportBuilder='+appConstants.fromReportBuilder;
														params+='&idDescription=header$~$'+thisPanel.graphIndex;
														params+='&chartType='+thisPanel.chartType;
														params+='&chartTypeCollection='+thisPanel.chartTypeCollection;
														controller.callAjax(url,params,false,true);	
													}
												}
											});
											editor.startEdit(el,edtrText);										
										}, obj, {delegate: '#'+obj.header.id+'_hd-textEl'});
									}								
								}
							},
							items:widgetArray
						});
					}
					else
					{
						colStatus='componentWise'
						//for(var compName in chartCollection)
						//{
							chartCollectionComp=chartCollection[compName];
							var compChartArray = new Array();
							if(chartCollectionComp instanceof Array)
							{
								var panelColWidth=1.0;
								//for(var k in chartCollectionComp)
								//{
									var chartCollectionCompVal = chartCollectionComp[graphIndex];
									var mainDivWidth=document.getElementById("main").offsetWidth;
									var mainDivHeight=document.getElementById("main").offsetHeight;
									var calculatedBaseDimensionY=mainDivHeight*0.1500;
									var calculatedBaseDimensionX=((mainDivWidth)/12);
									calculatedBaseDimensionX=Ext.util.Format.round(calculatedBaseDimensionX, 0);
									calculatedBaseDimensionX=calculatedBaseDimensionX*12;
									var panelHeight=4*calculatedBaseDimensionY;
									panelHeight=Ext.util.Format.round(panelHeight, 0);
									var bodyPadding='5 20 0 10';
									var widgetArray=new Array();
									widgetArray.push(this.loadWidgetData(widgetIdInfo+compName+graphIndex+'_panel',chartCollectionCompVal,widgetIdInfo,chartType,calculatedBaseDimensionX,panelHeight));
									var lblId = appConstants.templateName+"$~$widget$~$"+"footerDescription";
									//var lblIdHeader =appConstants.templateName+"$~$widget$~$"+"headerDescription";
									compChartArray.push({
										xtype:'panel',
										id:widgetIdInfo+compName+graphIndex+'_panel',
										closeAction:'destroy',
										ui:'newGraphPanel',
										title: '<div style="float:left" class="font_normal12">'+chartCollectionCompVal.title+'</div><div id ="iconRename" style="float:left;margin-left:20px" class="iconRename"></div>',
										margin:'0 5 10 5',
										height:350,
										scroll:false,
										bodyPadding:bodyPadding,
										layout:'fit',
										align:'stretch',
										autoScroll:true,
										overflowX:'hidden',
										overflowY:'auto',				
										columnWidth:panelColWidth,
										chartCollectionVal:chartCollectionCompVal,	
										graphIndex:graphIndex,
										compName:compName,
										chartType:chartType,
										chartTypeCollection:chartTypeCollection,
//										header:{
//											height:28,
//											padding:'0 0 0 5',
//											margin:0,
//											cls:'reportWidgetHeader',
//										},
										dockedItems:[{
											xtype:'toolbar',
											dock:'bottom',
											align:'stretch',
											layout:'fit',
											overCls:'reporterTemplateWidgetToolbarOver',
											cls:'reporterTemplateWidgetToolbar',
											height:42,
											items:[{
												xtype:'container',
												layout: {
													type: 'hbox',
													align: 'middle'
												},
												//align:'stretch',
												items:[
													{
														xtype: 'button',
														width:16,
														height:16,
														padding:0,
														margin:'8 4 8 10',
														id: 'widgetDescriptor'+widgetIdInfo+compName+graphIndex,
														cls:'iconDescription',
														listeners: {
															afterrender: function () {
																Ext.create('Ext.tip.ToolTip', {
																	target: this.id,
																	anchor: 'top',
																	cls: 'yellowTip',
																	trackMouse: true,
																	html:'Widget Descriptor'
																});
															}
														}
													},
													{
														xtype: 'label',
														//forId: 'myFieldId',
														id:lblId+compName+graphIndex,
														text:appConstants.builderJson.data.widgetFooter,
														margin: '5 10 5 5',
														flex:1,
														cls:'handSymbol',
														listeners:{
															afterrender:function(obj)
															{
																obj.el.on('click',this.onEdit,this);
																},				
														},
														onEdit: function(event, element,obj)
														{ 
															var me = this;
															if(!me.editor) {
																me.editor = Ext.create('Ext.Editor', {
																	//width: 300,
																	updateEl: true,
																	completeOnEnter: true,
																	cancelOnEsc: true,
																	floating: false,
																	//shadow: false,
																	alignment: 'tl',
																	autoSize: {
																		width: 'boundEl', // Width from the field
																		height: '21' // Height from the boundEl
																	},
																	hideEl: false,
																	offsets: [0,-2],
																	field: {
																		xtype: 'textfield',
																		cls: 'textbox',
																	},
																	listeners: {
																		complete: {
																			fn: function(self, value, startValue, opts) {
																				var url='/final/reporter/ErReportBuilderDrillDownController.jsp';
																				var controller=appConstants.appObj.getController(appConstants.appController);
																				var params='&widgetHeaderFooterInfo='+value;
																				params+='&isCustomLayout='+appConstants.isCustomLayout;
																				params+='&method=graphHeaderFooter';
																				params+='&templateName='+appConstants.templateName;
																				params+='&compName='+thisPanel.compName;
																				params+='&idDescription=footer$~$'+thisPanel.graphIndex;
																				params+='&chartType='+thisPanel.chartType;
																				params+='&chartTypeCollection='+thisPanel.chartTypeCollection;
																				controller.callAjax(url,params,false,true);
																			},
																			scope: me,
																		}
																	}
																});
															}
															me.editor.startEdit(element);
														}
													},
												]
											}]
										}
										],
										listeners:{
											boxready:function(obj)
											{
												if (!Ext.isEmpty(obj.header))
												{
													var el =Ext.get(obj.header.id+'_hd-textEl');
													Ext.get(obj.header.id).on('click', function(e,target){
														var edtrText=el.dom.innerText; 
														var editor = new Ext.Editor({
															width: 150,
															alignment: 'tl',
															floating: false,
															shadow: false,
															updateEl: true,
															completeOnEnter: true,
															cancelOnEsc: true,
															field: {
																xtype: 'textfield',
																cls: 'textbox',
																maxLength:32,
																enforceMaxLength: true
															},
															listeners: {
																'complete': function (edtr, value, startValue, eOpts) {
																	el.dom.innerHTML=value;
																	el.dom.innerHTML='<div style="float:left" class="font_normal12">'+value+'</div><div id ="iconRename" style="float:left;margin-left:20px" class="iconRename"></div>';
																	var url='/final/reporter/ErReportBuilderDrillDownController.jsp';
																	var controller=appConstants.appObj.getController(appConstants.appController);
																	//controller.method='setWidgetDescription';
																	var thisPanel=obj;
																	var params='&widgetHeaderFooterInfo='+value;
																	params+='&isCustomLayout='+appConstants.isCustomLayout;
																	params+='&method=graphHeaderFooter';
																	params+='&templateName='+appConstants.templateName;
																	params+='&fromReportBuilder='+appConstants.fromReportBuilder;
																	params+='&compName='+thisPanel.compName;
																	params+='&idDescription=header$~$'+thisPanel.graphIndex;
																	params+='&chartType='+thisPanel.chartType;
																	params+='&chartTypeCollection='+thisPanel.chartTypeCollection;
																	controller.callAjax(url,params,false,true);	
																}
															}
														});
														editor.startEdit(el,edtrText);										
													}, obj, {delegate: '#'+obj.header.id+'_hd-textEl'});
												}								
											}
										},
										items:widgetArray
									});
								//}
							}
							var columns=1;
							if (compChartArray.length>1)
							{
								columns=2;
							}
							comp.add({
								xtype:'panel',
								id:compName+'basepanel',
								closeAction:'destroy',
								ui:'groupPanel',
								bodyPadding:'10 5 0 5',
								title:compName,
								columns:columns,
								margin: '0 0 10 0',
					sortable: true,
					autoScroll:true,
					layout: {
						type: 'table',
						columns: columns,
						tableAttrs: {
							style: {
								width: '100%',
											//height:'100%',
								tableLayout: 'fixed'
							}
						}
					},
								items:compChartArray
							});
						//}
					}
				}
				comp.doLayout();											
				//Ext.getCmp('selectionDetails').setSelectionDetailsData(appConstants.builderJson.selectionDetails);//..
			}
			else
			{
				comp.add(this.getNoMeasure());
				this.enableDisableTools(true);
			}
		}
		else
		{
			comp.add(this.getNoMeasure());
			//this.enableDisableTools(true);
		}
	},
	getDynamicRangesInfo:function()
	{
		var rangeSettingArray = new Array();
		var rangeSettingsItemsId= Ext.getCmp('rangeSettingsItemsId');
		if(!rangeSettingsItemsId.isHidden() && rangeSettingsItemsId.items!=undefined)
		{
			for(var i=0;i<rangeSettingsItemsId.items.length;i++)
			{
				//disp_MeasureName'+idynamicRangeCombo_
				var addedStr=Ext.getCmp('dynamicRangeCombo_'+i).fieldLabel+'~'
				addedStr+=Ext.getCmp('dynamicRangeCombo_'+i).getValue()+'*';
				if(Ext.getCmp('dynamicRangeCombo_'+i).getValue()=='None')
					addedStr+='0';
				else
					addedStr+=Ext.getCmp('disp_MeasureName'+i).getValue();
				rangeSettingArray.push(addedStr);
			}
		}
			console.log(rangeSettingArray)			
			return rangeSettingArray;
	}
});