Ext.define('ErReportBuilderDrillDown.view.CustomTextField', {
	extend: 'Ext.form.FieldContainer',
	alias: 'widget.customTextField',
	fieldLabel:'WebApp',
	layout: 'column',
	id:'customTextField',
	width:200,
	hidden:true,
	items:[
		{
			xtype: 'textfield',
			cls: 'textbox',
			columnWidth:.80,
			value:'',
			margin:'0 5 0 0',
			//maskRe: /[A-Za-z0-9 .,\]/,
			readOnly:true,
			id: 'er_webAppCombo',
			name:'er_webAppCombo'
		},
		{
			xtype: 'button',
			iconCls: 'iconMultiselectExpand',
			tooltip: '<b>WebApp</b>',
			columnWidth:.20,
			style:
			{
				 background: 'none',
				 border: '0px'
			},
			handler:function(obj)
			{
				var ddTxtValue=Ext.getCmp('er_webAppCombo').getValue();
				Ext.create('Ext.window.Window',{
					title:'WebApp',
					width:240,
					id:'WebAppSubWindow',
					border:false,
					frame:false,
					modal: true,
					ghost: false,
					height:250,
					padding:'0 10 5 10',
					buttonAlign:'center',
					listeners:
					{
						
						afterrender: function () {
							Ext.EventManager.onWindowResize(function () {
								var me = this;
								me.center();
							}, this);
						}
					},
					items:[
					{
						xtype: 'container',
						width: 220,
						margin: 0,
						items: [
						{
							xype: 'container',
							cls:'multisearchlist',
							items: [
							{
								xtype: 'customtrigger', 
								emptyText: 'Search WebApp',
								id: 'WebAppSearch',
								listeners:
								{
									change:function(obj)
									{
										obj.toggleTriggger();
										if (Ext.isEmpty(appConstants.erUtils))
											appConstants.erUtils = Ext.widget("erutils");
										appConstants.erUtils.filterComboStore(obj,Ext.getCmp('componentsClone'),appConstants.publicJsonData.combo.webAppCombo);
									}
								}
							}],
						}]
					},
					{
						xtype: 'multiselect',
						width:'100%',
						height:190,
						layout: 'fit',
						border : 0,
						autoScroll:true,
						//maxSelections:1,
						scroll:false,
						selModel:
						{
							mode:'SIMPLE'
						},
						labelAlign:'left',
						baseCls: 'egmultiselect',
						multiSelect: false,
						id: 'componentsClone',
						name: 'componentsClone',
						store: new Ext.data.Store({
							fields: ['displayField', 'valueField'],
							data: []
						}),
						value: [],
						displayField: 'displayField',
						valueField: 'valueField',
						queryMode: 'local',
						listeners:
						{
							afterrender: function ()
							{
								this.getStore().loadRawData(webAppCombo);
								this.setValue(ddTxtValue);
							}
						}
					}
				],
				buttons:[
					{
						text:'Select',
						id: 'expand',
						cls:'quickMenuWhiteButton',
						name: 'expand',
						handler: function()
						{
							var selectedVal = Ext.getCmp('componentsClone').getValue();
							if(selectedVal.length==0)
							{
								 Ext.MessageBox.show({
									title: 'Alert',
									msg: 'Please Choose WebApp',
									buttons: Ext.MessageBox.OK,
									icon: Ext.MessageBox.WARNING
								});
								return;
							}
							else if(selectedVal.length>1 && selectedVal.indexOf('All')>-1)
							{
								 Ext.MessageBox.show({
									title: 'Alert',
									msg: 'All Web App and Individual selection cannot be selected simultaneously!',
									buttons: Ext.MessageBox.OK,
									icon: Ext.MessageBox.WARNING
								});
								return;
							}
							else( Ext.getCmp('componentsClone').getValue() != '')
							{
								var comboVal= Ext.getCmp('componentsClone').getValue();
								Ext.getCmp('er_webAppCombo').setValue(comboVal);
								var param = 'isCustomLayout='+appConstants.isCustomLayout+'&method=getWebApp';
								for(var i = 0;i<selectedVal.length;i++)
								{
									param += '&er_webAppCombo='+selectedVal[i];
								}
								Ext.Ajax.request({
									url:'/final/reporter/ReportBuilderController.jsp',
									params:param,
									async:true, 
									scope:this,
									success : function(response){
										if(response.responseText.length>0)
										{
											var responseStr = Ext.decode(response.responseText);
											var er_infoComb=Ext.getCmp('er_info');
											er_infoComb.getStore().loadRawData(responseStr.combo);
											er_infoComb.setValue(responseStr.selectedFields.selectedCustomInfo);
											this.up('window').destroy();
										}
									},
									failure:function(err){
										Ext.MessageBox.alert('Error occured in ErReportBuilder.jsp page');
									}
								});
							}
						}
					}
				]
			}).show();
			}
		}
	]
});

