Ext.define('ErRumHealthReportApp.controller.ErRumHealthReportController',{
	extend:'Ext.app.Controller',
	views:['Main'],
	refs:[
		{selector: 'main',ref:'main'},
		{selector: 'newUtilities',ref:'newUtilities'},
		{selector: 'usertimeline',ref:'usertimeline'},
		{selector: 'nomeasurepanel', ref:'nomeasurepanel'},
		{selector: 'rumHealthReportForm',ref:'rumHealthReportForm'},
		{selector: 'rumHealthReportUrlsView',ref:'rumHealthReportUrlsView'},
		{selector: 'rumHealthReportSettings',ref:'rumHealthReportSettings'},
		{selector: 'backGroundPanel',ref: 'backGroundPanel'}
	],
init:function(){
		this.control({
			'newUtilities':{
				'afterrender':this.loadTools
			},
			'newUtilities > #printTool > button':{
				'click':this.printReport
			},
			'newUtilities > #saveTool > button':{
					'click': this.saveReportAsPDF
			},
			'newUtilities > #mailTool > button':{
					'click':this.sendMail
			},
			'newUtilities > #favoriteTool > button':{
					'click':this.saveFavorite
			},
			'newUtilities > #scheduleTool > button':{
					'click':this.saveSchedule
			},
			'main':{
				'afterrender':this.afterMainRender,
				'boxready':this.refreshReportData
			},
			'rumHealthReportSettings':{
				'afterrender':this.afterSettingsRender
			},
			'rumHealthReportForm combo[name="er_Serv"]':{
				'select': this.zoneOnChange
			},
			'rumHealthReportForm button[id="submit"]':{
				'click': this.showResult
			},
			'rumHealthReportForm button[itemId="save"]': {
					"click": this.goTo
			},
			'rumHealthReportForm combo[name="reportGeneration"]':{
				'select': this.reportGenChange
			},
			'rumHealthReportForm button[id="panelinsidetoggle"]': {
				'click': this.toggleForm
			},
			'rumHealthReportSettings combo[name="reportGeneration"]':{
				'select': this.reportGenChange
			},
			/*'rumHealthReportSettings combo[id="excludeWeekendsCombo"]':
			{
				'select': this.changeExcludeWeekEnd
			},*/
			'rumHealthReportSettings button[id="moreOptionCloseId"]':{
				'click': this.validateAndCloseSettings
			},
			'rumHealthReportSettings button[id="submitViaSetting"]':{
				'click': this.closeAndSubmitSettings
			}
		});
	},
	showConfigDropdown:function()
	{
		isSettingsEnabled = true;
	    var tpl = new Ext.XTemplate('<div style="float:left;margin:0px 0px 0px 0px" >More Options</div><div style="text-align:right;float:right;"><div class="iconCloseNew" id="closeSettings"></div></div>');
		Ext.create('Ext.container.Container',{
		width:630,
		//padding:5,
		id:'configMod',
		//cls:'configMode_popup',
		ui:'settingsWindowContainer',
		items:[
			{
				xtype:'container',
				cls:'configMode_popupArrow',
				style:{'top':'-14px','left':'445px'}
			},
			{
				xtype:'container',
				cls:'containerHeader',
				html:tpl.apply(),
				style:{'top':'0px','margin':'0px'}
			},
			{
				xtype : 'rumHealthReportSettings',
				parent:this
			}
		],
		renderTo:'rumHealthReport'
		});

	},
	saveSchedule:function(btn){
		var isValid = this.validateMainForm(false);
		if( isValid && Ext.getCmp('er_timeline').getValue() == 'Any'){
				Ext.MessageBox.show({
				title: 'RUM Reports',
				msg: 'Chosen timeline not allowed',
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
				isValid=false;
		}
		if(isValid){
			var s_qryString;
			this.updateQStringActivity();

			s_qryString="/final/reporter/ErSaveSchedule.jsp?"+appConstants.queryStringActivity;

			var target=s_qryString+"&com.eg.CSRF_NONCE="+csrfToken;
			if (btn.getItemId()=='save')
				document.location=target+'&showSchWindow=no';
			else
				parent.scheduleWindowFn(target);
		}		
	},
	saveReportAsPDF: function() {
		var hiddenshowTechData=Ext.getCmp("HiddenshowTechData").getValue();
		var hiddenshowTierData=Ext.getCmp("HiddenshowTierData").getValue();
		var s_qryString = "../reporter/ErHtmlToSavePdf.jsp?&pdf=yes&isRumHealthReport=yes&HiddenshowTechData="+hiddenshowTechData+"&HiddenshowTierData="+hiddenshowTierData;
		if (Ext.isEmpty(appConstants.erUtils))
 			appConstants.erUtils = Ext.widget("erutils");

		 appConstants.erUtils.savePDF(s_qryString);
	},
	/* changeExcludeWeekEnd: function ( obj )
	{
		var excludeMsgs =appConstants.excludeWeekendLbl;
		var weenendOn=Ext.getCmp("excludeWeekendsCombo").getValue();
		if(weenendOn =='Yes')
			Ext.getCmp('excludeWeekendLbl').update(excludeMsgs);
		else
			Ext.getCmp('excludeWeekendLbl').update('');
	},*/
	goTo: function (btn) {
 		var hiddenFields =  appConstants.publicjsonDataActivity.hiddenfields;		
		var from_schedule = hiddenFields["fromScheduleModify"];
		if ((from_schedule != null && from_schedule == "Yes")) {
			 this.saveSchedule(btn);
		}else{
			this.saveFavorite(btn);
		}
    },
	bookletQuery: function(obj)
	{
		this.updateQStringActivity();
		var qStringForBooklet = appConstants.queryStringActivity;
		qStringForBooklet += '&printGraph=yes';
		return qStringForBooklet;
	},
	bookletScheduleQuery: function(obj)
	{
		var bookletquery=appConstants.queryStringActivity;
		return bookletquery;
	},
	bookletPreview:function()
	{
		this.printReport();
	}, 
	afterMainRender:function(){
		var thisController = this;		
		this.fillFormFields(appConstants.publicjsonDataActivity);
		if(!hideBackButton){
			Ext.getCmp('rumHealthReportForm').add(
			{
				xtype: 'hidden',
				id: 'ID',
				name: 'ID',
				value: appConstants.publicjsonDataActivity['ID']
			});
		}
		var hiddenFields = appConstants.publicjsonDataActivity.hiddenfields;
        var from_schedule = hiddenFields["fromScheduleModify"];
        var from_favourite = hiddenFields["fromFavoriteModify"];
		if((from_schedule != null && from_schedule == 'Yes') || (from_schedule != null && from_schedule == 'Yes'))
		{
			Ext.getCmp("save");
		}
	},
	sendMail: function()
	{
		var hiddenshowTechData=Ext.getCmp("HiddenshowTechData").getValue();
		var hiddenshowTierData=Ext.getCmp("HiddenshowTierData").getValue();
		drillDownParams="&isRumHealthReport=yes&HiddenshowTechData="+hiddenshowTechData+"&HiddenshowTierData="+hiddenshowTierData;
		Ext.widget('sendmail').show();
	},
	afterSettingsRender:function()
	{
		Ext.getCmp('moreOptionCloseId').show();
		var hiddenFields = appConstants.publicjsonDataActivity.hiddenfields;
		var favorite_id = hiddenFields["favorite_id"];
		if(!Ext.isEmpty(favorite_id)){
			Ext.getCmp('reportGeneration').setDisabled(true);
		}
		var thisController  =this;		
		this.fillSettingFieldsForActivity(appConstants.publicjsonDataActivity);
		Ext.EventManager.onWindowResize(function(){
			Ext.get('configMod').setStyle('left', '');
		});
		Ext.get('closeSettings').on('click',function(){
			  thisController.validateAndCloseSettings();
		});
	},
	validateAndCloseSettings:function()
	{
		  var isSettingsOk = this.validateSettings();
			if(isSettingsOk)
			{
 				Ext.get('configMod').animate({duration: 500,to: {y: -500}});
				return true;
			}
			return false;
	},
	printReport:function(){
		var mainForm =Ext.getCmp('rumHealthReportForm').getForm();
		var selected_comp=mainForm.findField('er_comp').getValue();
		var hiddenshowTechData=Ext.getCmp("HiddenshowTechData").getValue();
		var hiddenshowTierData=Ext.getCmp("HiddenshowTierData").getValue();
		var Qstring=appConstants.queryStringActivity;
		var s_qryString = "/final/reporter/ErRumHealthReportPrint.jsp?&fromPrint=yes"+Qstring+"&er_view=PRINT&pdfPrint=yes&selected_comp="+selected_comp+"&showTechData="+hiddenshowTechData+"&showTierData="+hiddenshowTierData;
		parent.printWindowFn(s_qryString);
	},
	fillSettingFieldsForActivity:function(jsonData){
		var comboRawData;
		var selectedComboOption;
		var comboObject;
		var isSubmitted="false";
		var thinclientuserSettingsForm = this.getRumHealthReportSettings().getForm();
		var screenLabels=jsonData.screenLabels;
		comboRawData=jsonData.excludeWeekCombo;
		selectedComboOption=jsonData.excludeWeek;
		comboObject=thinclientuserSettingsForm.findField('excludeWeekendsCombo');		
		comboObject.setFieldLabel(screenLabels['reporter.common.Exclude weekends']);
		comboObject.getStore().loadRawData(comboRawData);
		appConstants.excludeWeekendLbl=jsonData.screenLabels['MappedExcludeDays']
		var exludeWeekEndVal=selectedComboOption;
		if ( !Ext.isEmpty(selectedComboOption) ){
			comboObject.setValue(selectedComboOption);
		}
		else{
			exludeWeekEndVal=comboRawData[0].valueField;
			comboObject.setValue(comboRawData[0].valueField);
		}
		if(exludeWeekEndVal=="Yes" || exludeWeekEndVal=="yes")
		{
			var excludeDaysObj=Ext.getCmp('excludeWeekendLbl');
			excludeDaysObj.show();
			excludeDaysObj.update(jsonData.screenLabels['MappedExcludeDays']);
		}

		Ext.getCmp('timeperiodLbl').setText(screenLabels['reporter.common.Time period']);
		thinclientuserSettingsForm.findField('timefrom').setValue(jsonData.selectedTimeFrom);
		thinclientuserSettingsForm.findField('minfrom').setValue(jsonData.selectedMinsFrom);
		thinclientuserSettingsForm.findField('timeto').setValue(jsonData.selectedTimeTo);
		thinclientuserSettingsForm.findField('minto').setValue(jsonData.selectedMinsTo);

		var reportGenCombo=jsonData.reportGenerationCombo;
		var selreportGeneration=jsonData.reportGeneration;
		var reportGen=thinclientuserSettingsForm.findField('reportGeneration');
		reportGen.setFieldLabel(screenLabels['reporter.common.Report Generation']);
		reportGen.getStore().loadRawData(reportGenCombo);
		reportGen.setValue(selreportGeneration);

		thinclientuserSettingsForm.findField('upperminor').setValue(jsonData.defaultValues.apdexValue.minorValue);
		thinclientuserSettingsForm.findField('uppermajor').setValue(jsonData.defaultValues.apdexValue.majorValue);
		thinclientuserSettingsForm.findField('upperCritical').setValue(jsonData.defaultValues.apdexValue.criticalValue);
		
		thinclientuserSettingsForm.findField('pageloadupperminor').setValue(jsonData.defaultValues.AvgPageLoad.minorValue);
		thinclientuserSettingsForm.findField('pageloaduppermajor').setValue(jsonData.defaultValues.AvgPageLoad.majorValue);
		thinclientuserSettingsForm.findField('pageloadupperCritical').setValue(jsonData.defaultValues.AvgPageLoad.criticalValue);
	
		thinclientuserSettingsForm.findField('jserrorupperminor').setValue(jsonData.defaultValues.JSErrors.minorValue);
		thinclientuserSettingsForm.findField('jserroruppermajor').setValue(jsonData.defaultValues.JSErrors.majorValue);
		thinclientuserSettingsForm.findField('jserrorupperCritical').setValue(jsonData.defaultValues.JSErrors.criticalValue);
		
		thinclientuserSettingsForm.findField('browsrTimeupperminor').setValue(jsonData.defaultValues.BrowserTime.minorValue);
		thinclientuserSettingsForm.findField('browsrTimeuppermajor').setValue(jsonData.defaultValues.BrowserTime.majorValue);
		thinclientuserSettingsForm.findField('browsrTimeupperCritical').setValue(jsonData.defaultValues.BrowserTime.criticalValue);

		thinclientuserSettingsForm.findField('nwConnupperminor').setValue(jsonData.defaultValues.networkConn.minorValue);
		thinclientuserSettingsForm.findField('nwConnuppermajor').setValue(jsonData.defaultValues.networkConn.majorValue);
		thinclientuserSettingsForm.findField('nwConnupperCritical').setValue(jsonData.defaultValues.networkConn.criticalValue);
		
		thinclientuserSettingsForm.findField('contentupperminor').setValue(jsonData.defaultValues.ContendDownload.minorValue);
		thinclientuserSettingsForm.findField('contentuppermajor').setValue(jsonData.defaultValues.ContendDownload.majorValue);
		thinclientuserSettingsForm.findField('contentupperCritical').setValue(jsonData.defaultValues.ContendDownload.criticalValue);
		
		thinclientuserSettingsForm.findField('serverupperminor').setValue(jsonData.defaultValues.ServerTime.minorValue);
		thinclientuserSettingsForm.findField('serveruppermajor').setValue(jsonData.defaultValues.ServerTime.majorValue);
		thinclientuserSettingsForm.findField('serverupperCritical').setValue(jsonData.defaultValues.ServerTime.criticalValue);

		thinclientuserSettingsForm.findField('trafficupperminor').setValue(jsonData.defaultValues.traffic.minorValue);
		thinclientuserSettingsForm.findField('trafficuppermajor').setValue(jsonData.defaultValues.traffic.majorValue);
		thinclientuserSettingsForm.findField('trafficCritical').setValue(jsonData.defaultValues.traffic.criticalValue);
/*	
		thinclientuserSettingsForm.findField('satisfiedUserminor').setValue(jsonData.defaultValues.Satisfied.minorValue);
		thinclientuserSettingsForm.findField('satisfiedUsermajor').setValue(jsonData.defaultValues.Satisfied.majorValue);
		thinclientuserSettingsForm.findField('satisfiedUserCritical').setValue(jsonData.defaultValues.Satisfied.criticalValue);
		
		thinclientuserSettingsForm.findField('tolertaedusrminor').setValue(jsonData.defaultValues.Tolerated.minorValue);
		thinclientuserSettingsForm.findField('tolertaedusrmajor').setValue(jsonData.defaultValues.Tolerated.majorValue);
		thinclientuserSettingsForm.findField('tolertaedusrCritical').setValue(jsonData.defaultValues.Tolerated.criticalValue);
		
		thinclientuserSettingsForm.findField('frustratedUsrminor').setValue(jsonData.defaultValues.Frustrated.minorValue);
		thinclientuserSettingsForm.findField('frustratedUsrmajor').setValue(jsonData.defaultValues.Frustrated.majorValue);
		thinclientuserSettingsForm.findField('frustratedUsrCritical').setValue(jsonData.defaultValues.Frustrated.criticalValue);
*/
	},
	saveFavorite:function(btn){
		var isValid = this.validateMainForm(false);
		var favorite_id ="";
		/* if(isValid && Ext.getCmp('er_timeline').getValue() == 'Any'){
				Ext.MessageBox.show({
				title: 'RUM Reports',
				msg: 'Chosen timeline not allowed',
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
			isValid=false;
		} */
		if(isValid){
			var s_qryString;
				var hiddenFields = appConstants.publicjsonDataActivity.hiddenfields;
				favorite_id = hiddenFields["favorite_id"];
				this.updateQStringActivity();
					s_qryString="/final/reporter/ErSaveFavorite.jsp?"+appConstants.queryStringActivity;
			var target=s_qryString+"&er_RmDispName="+appConstants.er_RmDispName+"&com.eg.CSRF_NONCE="+csrfToken;//+"&FavoriteId="+favorite_id;
			if (btn.getItemId()=='save')
				document.location=target+'&showWindow=no'+"&FavoriteId="+favorite_id;
			else
 				parent.favouriteWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
		}
		
	},
	refreshReportData:function(){
		var jsonData;
		jsonData=appConstants.publicjsonDataActivity;	
 		if(appConstants.isSubmit!=null && appConstants.isSubmit=="true")
		{
			this.fillFormFields(jsonData);
			this.showResult();
		}
	},
	zoneOnChange:function(){
		initLdgMask.show();
		Ext.getCmp('resultPanel').hide();
		Ext.getCmp("HiddenshowTechData").setValue(false);
		Ext.getCmp("HiddenshowTierData").setValue(true);
		var mainForm =Ext.getCmp('rumHealthReportForm').getForm();
		var urlForAjax="/final/reporter/ErRumHealthReportJSON.jsp";		
		var QString="";		
		this.updateQStringActivity();
		QString=appConstants.queryStringActivity;
		var me=this;
		Ext.Ajax.request(
		{
			url : urlForAjax,
			params : QString,
			scope:this,
			method : 'POST',
			success: function(response){
				var jsonText = response.responseText;
				if(!Ext.isEmpty(jsonText))
				{
					var jsonData=Ext.decode(jsonText);
					me.fillFormFields(jsonData);
					me.fillSettingFieldsForActivity(jsonData);
				}
			}
		});
		initLdgMask.hide();
		appConstants.isLoad=true;
	},
	closeAndSubmitSettings : function()
	{
		if(this.validateAndCloseSettings())
		{
			this.showResult();
		}
	},
	validateSettings :function(){
		var isSettingsOk = true;
		var reportgen=Ext.getCmp('reportGeneration').getValue();
		if ( reportgen!=null && reportgen == 'background' ) {
			var reportName = Ext.getCmp('bgReportName').getValue();
			if(!validateTextBoxWithSpecialChars(reportName,'Attachment',true))
			isSettingsOk = false;
		}
		if(Ext.getCmp('ApdexFieldId')!=undefined)
		{
			var upperminor = Ext.getCmp('upperminor').getValue();
			var uppermajor = Ext.getCmp('uppermajor').getValue();
			var upperCritical = Ext.getCmp('upperCritical').getValue();
			if(!(uppermajor < upperCritical && upperminor < upperCritical && upperminor < uppermajor))
			{
				Ext.MessageBox.show({
					title: 'RUM Report',
					msg: 'Invalid Apdex Thresholds',
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
				});
				return false;
			}
		}
		if(Ext.getCmp('avgPageLoadTime')!=undefined)
		{
			var upperminor = Ext.getCmp('pageloadupperminor').getValue();
			var uppermajor = Ext.getCmp('pageloaduppermajor').getValue();
			var upperCritical = Ext.getCmp('pageloadupperCritical').getValue();
			if(!(uppermajor < upperCritical && upperminor < upperCritical && upperminor < uppermajor))
			{

				Ext.MessageBox.show({
					title: 'RUM Report',
					msg: 'Invalid Page Load Time Thresholds',
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
				});
				return false;
			}
		}
		if(Ext.getCmp('jserrors')!=undefined)
		{
			var upperminor = Ext.getCmp('jserrorupperminor').getValue();
			var uppermajor = Ext.getCmp('jserroruppermajor').getValue();
			var upperCritical = Ext.getCmp('jserrorupperCritical').getValue();
			if(!(uppermajor < upperCritical && upperminor < upperCritical && upperminor < uppermajor))
			{

				Ext.MessageBox.show({
					title: 'RUM Report',
					msg: 'Invalid JS Errors Thresholds',
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
				});
				return false;
			}
		}
		if(Ext.getCmp('browserTime')!=undefined)
		{
			var upperminor = Ext.getCmp('browsrTimeupperminor').getValue();
			var uppermajor = Ext.getCmp('browsrTimeuppermajor').getValue();
			var upperCritical = Ext.getCmp('browsrTimeupperCritical').getValue();
			if(!(uppermajor < upperCritical && upperminor < upperCritical && upperminor < uppermajor))
			{

				Ext.MessageBox.show({
					title: 'RUM Report',
					msg: 'Invalid Browser Time Thresholds',
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
				});
				return false;
			}
		}
		if(Ext.getCmp('networkConn')!=undefined)
		{
			var upperminor = Ext.getCmp('nwConnupperminor').getValue();
			var uppermajor = Ext.getCmp('nwConnuppermajor').getValue();
			var upperCritical = Ext.getCmp('nwConnupperCritical').getValue();
			if(!(uppermajor < upperCritical && upperminor < upperCritical && upperminor < uppermajor))
			{

				Ext.MessageBox.show({
					title: 'RUM Report',
					msg: 'Invalid Nework Connection Time Thresholds',
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
				});
				return false;
			}
		}
		if(Ext.getCmp('contentDownload')!=undefined)
		{
			var upperminor = Ext.getCmp('contentupperminor').getValue();
			var uppermajor = Ext.getCmp('contentuppermajor').getValue();
			var upperCritical = Ext.getCmp('contentupperCritical').getValue();
			if(!(uppermajor < upperCritical && upperminor < upperCritical && upperminor < uppermajor))
			{
				Ext.MessageBox.show({
					title: 'RUM Report',
					msg: 'Invalid Content Download Time Thresholds',
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
				});
				return false;
			}
		}
		if(Ext.getCmp('serverTime')!=undefined)
		{
			var upperminor = Ext.getCmp('serverupperminor').getValue();
			var uppermajor = Ext.getCmp('serveruppermajor').getValue();
			var upperCritical = Ext.getCmp('serverupperCritical').getValue();
			if(!(uppermajor < upperCritical && upperminor < upperCritical && upperminor < uppermajor))
			{
				Ext.MessageBox.show({
					title: 'RUM Report',
					msg: 'Invalid Server Time Thresholds',
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
				});
				return false;
			}
		}
		if(Ext.getCmp('traffic')!=undefined)
		{
			var upperminor = Ext.getCmp('trafficupperminor').getValue();
			var uppermajor = Ext.getCmp('trafficuppermajor').getValue();
			var upperCritical = Ext.getCmp('trafficCritical').getValue();
			if(!(uppermajor < upperCritical && upperminor < upperCritical && upperminor < uppermajor))
			{
				Ext.MessageBox.show({
					title: 'RUM Report',
					msg: 'Invalid Traffic Thresholds',
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
				});
				return false;
			}
		}
		return isSettingsOk;
	},
	toggleForm:function(obj)
	{
		Ext.getCmp('panelinsidetoggle').show();
		var ornt = Ext.getCmp('rumHealthReportForm');
		if (ornt.isHidden())
		{
			ornt.show();
			Ext.getCmp('selectiondetails').hide();
		}
		else
		{
			ornt.hide();
			Ext.getCmp('selectiondetails').show();
		}
	},
	showResult:function()
	{
		var isValid = this.validateMainForm(true);
		if(isValid)
			this.submitReport();
	},
	submitReport : function(){
		var me=this;
		this.updateQStringActivity();
		var url;
		var backgroundUrl;
		var Qstring;
		initLdgMask.show();
		if(!isSettingsEnabled)
			this.showConfigDropdown();
		Qstring=appConstants.queryStringActivity;
		backgroundUrl="../servlet/com.eg.ErStartBackGroundReportC?responseType=json&call=json";		
		url="../servlet/com.eg.ErRumHealthServletC"			
 		Qstring+= '&er_RmDispName='+appConstants.er_RmDispName+'&isSubmit=true&call=json';	
		var reportGeneration;
		if(isSettingsEnabled){
			var thinclientuserSettingsForm = this.getRumHealthReportSettings().getForm();
			reportGeneration=thinclientuserSettingsForm.findField('reportGeneration').getValue();
		}
		else
			reportGeneration=appConstants.publicjsonDataActivity.reportGeneration;
		var resultPanelObj=Ext.getCmp('resultPanel');
		resultPanelObj.removeAll();
		if(reportGeneration == 'undefined' ||reportGeneration == undefined)
			reportGeneration =	'foreground';
		if(reportGeneration == 'foreground')
		{
 			Ext.Ajax.request(
			{
				url : url,
				params : Qstring,
				method :'POST',
				scope:this,
				timout:320000,
				success: function(response){
					var jsonText = response.responseText;
					var jsonData=Ext.decode(jsonText);		
					if(jsonData['NoDataFound'] == false)
					{
						this.getNomeasurepanel().hide();
						appConstants.publicjsonDataActivity=jsonData;
						resultdata=appConstants.publicjsonDataActivity['RUMResults'];
						resultdata1=appConstants.publicjsonDataActivity;
						resultPanelObj.removeAll();
						resultPanelObj.add(
							{
								xtype:'rumhealthreportsummaryview',
								data:resultdata['Summary_View'],
							},
							{
								xtype:'rumhealthreportkpiview',
								data:resultdata1,
							}
						);
						Ext.getCmp("bookletTool").setDisabled(false);
						Ext.getCmp("saveTool").setDisabled(false);
						Ext.getCmp("printTool").setDisabled(false);
						Ext.getCmp("mailTool").setDisabled(false);
						Ext.getCmp('selectiondetails').setSelectionDetailsData(jsonData.selectionDetails);
						initLdgMask.hide();
						resultPanelObj.show();
					}
					else
					{
						this.disableTools();
						resultPanelObj.hide();
						initLdgMask.hide();
						this.getNomeasurepanel().show();
					}
				}
			});
		}
		else if(reportGeneration == 'background'){
			resultPanelObj.hide();
			var me=this;
 			var htmlStr = '';
			var bg_reportname=Ext.getCmp('bgReportName').getValue();
			bg_reportname=checkFileName(bg_reportname);
			Ext.Ajax.request({
				url :backgroundUrl,
 				params : Qstring+"&bg_reportname="+bg_reportname,
				success: function(response){
					var jsonText = response.responseText;
					var jsonData=Ext.decode(jsonText);
					var backgroundReportStatus=jsonData.backgroundReportStatus;
					if(backgroundReportStatus!= 'undefined')
					{
						if(backgroundReportStatus== 'success'){
							var bgroundResponseTxt=jsonData.bgroundResponseTxt;
							var bgroundReportsURL=jsonData.bgroundReportsURL;
							var backgroundAnchor=jsonData.backgroundAnchor;
							htmlStr = '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconSuccess"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+bgroundResponseTxt+'.</br>'+'<a class="backgroundMsgLink" href='+ bgroundReportsURL +'>'+ backgroundAnchor + '</a></div></td></tr></table></td></tr></table>';
							
							//htmlStr = '<div text-align:left;display:block;width:480px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconSuccess"></div><div style="margin-top:20px"><b>'+bgroundResponseTxt+'</b><br/><a class="backgroundMsgLink" href='+bgroundReportsURL+'>'+backgroundAnchor+'</a></div></div>';
						}
						else if(backgroundReportStatus== 'duplicate'){
							var bgroundResponseTxt=jsonData.bgroundResponseTxt;
							var bgroundReportsURL=jsonData.bgroundReportsURL;
							var backgroundAnchor=jsonData.backgroundAnchor;
						
							htmlStr = '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconExclamation"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+bgroundResponseTxt+'.</br>'+'<a class="backgroundMsgLink" href='+ bgroundReportsURL +'>'+ backgroundAnchor + '</a></div></td></tr></table></td></tr></table>';

							//htmlStr = '<div text-align:left;display:block;width:480px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconExists"></div><div style="margin-top:20px"><b>'+bgroundResponseTxt+'</b><br/><a class="backgroundMsgLink" href='+bgroundReportsURL+'>'+backgroundAnchor+'</a></div></div>';
						}
					}
					else
					{
							htmlStr = '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconExclamation"></div></td><td>Error In BackGround Generation</td></tr></table></td></tr></table>';					
					}
  					me.getBackGroundPanel().update(htmlStr);
 					me.getBackGroundPanel().show();
					initLdgMask.hide();
				}
			});
		}
	},
	reportGenChange:function(){
		Ext.getCmp('resultPanel').hide();
		this.disableTools();
		var reportGenType=Ext.getCmp('reportGeneration').getValue();
		if(reportGenType== 'background'){
			Ext.getCmp('bgReportName').setValue("");
			Ext.getCmp('bgReportName').show();
			Ext.getCmp('moreOptionCloseId').hide();
			Ext.getCmp('submitViaSetting').show();
		}
		else{
			Ext.getCmp('bgReportName').hide();
			Ext.getCmp('moreOptionCloseId').show();
			Ext.getCmp('submitViaSetting').hide();
		}
	},
	disableTools: function(){
		Ext.getCmp("bookletTool").setDisabled(true);
		Ext.getCmp("saveTool").setDisabled(true);
		Ext.getCmp("printTool").setDisabled(true);
		Ext.getCmp("mailTool").setDisabled(true);
	},
	updateQStringActivity:function(){
		var FormParams="";
		var hiddenfieldQString='';
		var apdexRangeValue='';
		var timelineParams;
		var timePeriodParams;
		var thresholdsParams;
		var mainForm =Ext.getCmp('rumHealthReportForm').getForm();
		var thinclientuserSettingsForm=null;		
		var serverArray=new Array();
		var select_farmVal=Ext.getCmp('er_Serv').getValue();				
		FormParams="&er_Serv="+select_farmVal;		
		var selected_comp=mainForm.findField('er_comp').getValue();
		FormParams+="&er_server="+selected_comp;
		if(selected_comp.indexOf(":")>-1)
			selected_comp=selected_comp.substring(0,selected_comp.indexOf(":"));
		FormParams+="&er_comp="+selected_comp;
		FormParams+="&ReportFrom=RUM_Report";

		var timelineParams = "&er_timeline=" + mainForm.findField('er_timeline').getValue() + "&startdate=" + mainForm.findField('er_stdate').dataArray + "&enddate=" + mainForm.findField('er_enddate').dataArray + "&starthr=" + mainForm.findField('er_sthr').dataArray + "&endhr=" + mainForm.findField('er_endhr').dataArray+"&startmin="+mgr_stmin+"&endmin="+mgr_enmin+"&er_secs=00";
		if(appConstants.publicjsonDataActivity.hasOwnProperty('hiddenfields'))
		{
			var hiddenFields = appConstants.publicjsonDataActivity.hiddenfields;
			for (var hiddenField in hiddenFields){
				hiddenfieldQString+="&"+hiddenField+"="+hiddenFields[hiddenField];
			}
		}
		var threshVals = appConstants.publicjsonDataActivity.defaultValues;
		var er_excwe=this.getSettingsFieldValue('excludeWeekendsCombo',isSettingsEnabled,appConstants.publicjsonDataActivity.excludeWeek);
		var timefrom=this.getSettingsFieldValue('timefrom',isSettingsEnabled,appConstants.publicjsonDataActivity.selectedTimeFrom);
		var minfrom=this.getSettingsFieldValue('minfrom',isSettingsEnabled,appConstants.publicjsonDataActivity.selectedMinsFrom);
		var timeto=this.getSettingsFieldValue('timeto',isSettingsEnabled,appConstants.publicjsonDataActivity.selectedTimeTo);
		var minto=this.getSettingsFieldValue('minto',isSettingsEnabled,appConstants.publicjsonDataActivity.selectedMinsTo);
		
		var pageloadminorVal=this.getSettingsFieldValue('pageloadupperminor',isSettingsEnabled,threshVals.AvgPageLoad.minorValue);
		var pageloadmajorVal=this.getSettingsFieldValue('pageloaduppermajor',isSettingsEnabled,threshVals.AvgPageLoad.majorValue);
		var pageloadCriticalVal=this.getSettingsFieldValue('pageloadupperCritical',isSettingsEnabled,threshVals.AvgPageLoad.criticalValue);
		
		var apdexminorVal=this.getSettingsFieldValue('upperminor',isSettingsEnabled,threshVals.apdexValue.minorValue);
		var apdexmajorVal=this.getSettingsFieldValue('uppermajor',isSettingsEnabled,threshVals.apdexValue.majorValue);
		var apdexCriticalVal=this.getSettingsFieldValue('upperCritical',isSettingsEnabled,threshVals.apdexValue.criticalValue);
		
		var jserrorminorVal=this.getSettingsFieldValue('jserrorupperminor',isSettingsEnabled,threshVals.JSErrors.minorValue);
		var jserrormajorVal=this.getSettingsFieldValue('jserroruppermajor',isSettingsEnabled,threshVals.JSErrors.majorValue);
		var jserrorCriticalVal=this.getSettingsFieldValue('jserrorupperCritical',isSettingsEnabled,threshVals.JSErrors.criticalValue);
		
		var browserTimeminorVal=this.getSettingsFieldValue('browsrTimeupperminor',isSettingsEnabled,threshVals.BrowserTime.minorValue);
		var browserTimemajorVal=this.getSettingsFieldValue('browsrTimeuppermajor',isSettingsEnabled,threshVals.BrowserTime.majorValue);
		var browserTimeCriticalVal=this.getSettingsFieldValue('browsrTimeupperCritical',isSettingsEnabled,threshVals.BrowserTime.criticalValue);
		
		var networkminorVal=this.getSettingsFieldValue('nwConnupperminor',isSettingsEnabled,threshVals.networkConn.minorValue);
		var networkmajorVal=this.getSettingsFieldValue('nwConnuppermajor',isSettingsEnabled,threshVals.networkConn.majorValue);
		var networkCriticalVal=this.getSettingsFieldValue('nwConnupperCritical',isSettingsEnabled,threshVals.networkConn.criticalValue);
		
		var serverminorVal=this.getSettingsFieldValue('serverupperminor',isSettingsEnabled,threshVals.ServerTime.minorValue);
		var servermajorVal=this.getSettingsFieldValue('serveruppermajor',isSettingsEnabled,threshVals.ServerTime.majorValue);
		var serverCriticalVal=this.getSettingsFieldValue('serverupperCritical',isSettingsEnabled,threshVals.ServerTime.criticalValue);
		
		var contentminorVal=this.getSettingsFieldValue('contentupperminor',isSettingsEnabled,threshVals.ContendDownload.minorValue);
		var contentmajorVal=this.getSettingsFieldValue('contentuppermajor',isSettingsEnabled,threshVals.ContendDownload.majorValue);
		var contentCriticalVal=this.getSettingsFieldValue('contentupperCritical',isSettingsEnabled,threshVals.ContendDownload.criticalValue);
	
		var trafficminorVal=this.getSettingsFieldValue('trafficupperminor',isSettingsEnabled,threshVals.traffic.minorValue);
		var trafficmajorVal=this.getSettingsFieldValue('trafficuppermajor',isSettingsEnabled,threshVals.traffic.majorValue);
		var trafficCriticalVal=this.getSettingsFieldValue('trafficCritical',isSettingsEnabled,threshVals.traffic.criticalValue);

		thresholdsParams="&er_excwe="+er_excwe+"&timefrom="+timefrom+"&minfrom="+minfrom+"&timeto="+timeto+"&minto="+minto+"&pageloadminorVal="+pageloadminorVal+"&pageloadmajorVal="+pageloadmajorVal+"&pageloadCriticalVal="+pageloadCriticalVal+"&apdexminorVal="+apdexminorVal+"&apdexmajorVal="+apdexmajorVal+"&apdexCriticalVal="+apdexCriticalVal+"&jserrorminorVal="+jserrorminorVal+"&jserrormajorVal="+jserrormajorVal+"&jserrorCriticalVal="+jserrorCriticalVal+"&browserTimeminorVal="+browserTimeminorVal+"&browserTimemajorVal="+browserTimemajorVal+"&browserTimeCriticalVal="+browserTimeCriticalVal+"&networkminorVal="+networkminorVal+"&networkmajorVal="+networkmajorVal+"&networkCriticalVal="+networkCriticalVal+"&serverminorVal="+serverminorVal+"&servermajorVal="+servermajorVal+"&serverCriticalVal="+serverCriticalVal+"&contentminorVal="+contentminorVal+"&contentmajorVal="+contentmajorVal+"&contentCriticalVal="+contentCriticalVal+"&trafficminorVal="+trafficminorVal+"&trafficmajorVal="+trafficmajorVal+"&trafficCriticalVal="+trafficCriticalVal;
		
		var HiddenshowTechData=Ext.getCmp("HiddenshowTechData").getValue();
		var HiddenshowTierData=Ext.getCmp("HiddenshowTierData").getValue();
		var deviceParams="&HiddenshowTechData="+HiddenshowTechData+"&HiddenshowTierData="+HiddenshowTierData;
		appConstants.queryStringActivity=FormParams+timelineParams+hiddenfieldQString+thresholdsParams+deviceParams;
	},
	getSettingsFieldValue:function(formId,isEnabled,jsn){
		var value ='';
		if(isEnabled)
			value = Ext.getCmp(formId).getValue();
		else
			value = jsn;
		return value;
	},
	loadTools : function(){
		this.getNewUtilities().loadIcon(true, true, true, false, false, true, true, false, false, false,true);
		Ext.getCmp("favoriteTool").setDisabled(false);
		Ext.getCmp("scheduleTool").setDisabled(false);
	},
	validateMainForm:function(flag){
		var isSettingsOk = true;
		var mainForm =Ext.getCmp('rumHealthReportForm').getForm();
		var thinclientuserSettingsForm =null;
		
		if(isSettingsEnabled)
			thinclientuserSettingsForm = mainForm;
			
			var zone=mainForm.findField('er_Serv')
				if(zone.getValue() == '-1'){
				Ext.MessageBox.show({
				title: 'RUM Report',
				msg: zone.getStore().getAt(0).get('displayField'),
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
				return false ;
			}
			var server=Ext.getCmp('er_comp');
			if( server.getValue() == '-1'){
				Ext.MessageBox.show({
				title: 'RUM Report',
				msg: server.getStore().getAt(0).get('displayField'),
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
				return false;
			}
		var tmpStDate = Ext.getCmp('er_stdate').getValue();
		tmpStDate.setHours(Ext.getCmp('er_sthr').getValue());
		var tmpEnDate = Ext.getCmp('er_enddate').getValue();
		tmpEnDate.setHours(Ext.getCmp('er_endhr').getValue());

		var result = checkDateTime(tmpStDate, tmpEnDate);
		if (!result) 
		{
			return;
		}
		var diffDays = Math.abs((tmpStDate.getTime() - tmpEnDate.getTime()) / (24 * 60 * 60 * 1000));
		if(diffDays < 1)
		{
			Ext.MessageBox.show({
				title: 'RUM Report',
			//	msg: 'minimum time period for this report is one day',
				msg: 'Please choose a timeline more than one day',
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
				return false;
		}


		return isSettingsOk;
	},
	fillFormFields:function(jsonData)
	{
		appConstants.publicjsonDataActivity=jsonData;
		var rep_type="";
		var comboRawData;
		var selectedComboOption;
		var comboObject;
		var isSubmitted="false";
		var compSel="er_server";
		var serverSel="er_Serv";
		if(appConstants.isSubmit=="true")
			isSubmitted=appConstants.isSubmit;
		var mainForm =Ext.getCmp('rumHealthReportForm').getForm();;
		var screenLabels=jsonData.screenLabels;
		comboRawData=jsonData.zoneCombo;
		if(!Ext.isEmpty(comboRawData))
		{
			selectedComboOption=jsonData.selectedZone;
			comboObject=mainForm.findField(serverSel);			
			comboObject.setFieldLabel(screenLabels['reporter.consolidated.Zone']);	
			comboObject.getStore().clearFilter(true); 
			comboObject.getStore().loadRawData(comboRawData);
			if ( !Ext.isEmpty(selectedComboOption) )
				comboObject.setValue(selectedComboOption);			
		}
		comboRawData=jsonData.serverCombo;
		if(!Ext.isEmpty(comboRawData))
		{
			selectedComboOption=jsonData.selectedServer;
			comboObject=Ext.getCmp("er_comp");			
			comboObject.setFieldLabel(screenLabels['reporter.common.Component']);		
			comboObject.getStore().loadRawData(comboRawData);
			if ( !Ext.isEmpty(selectedComboOption) )
				comboObject.setValue(selectedComboOption);			
			else
				comboObject.setValue(comboRawData[0].valueField);	
		}
		var timelineRawData=jsonData.timelineCombo;
		var selectedTimeline=jsonData.selectedTimeline;
		var timelineObj=mainForm.findField('er_timeline');
		timelineObj.setFieldLabel(screenLabels['reporter.common.Timeline']);
		timelineObj.getStore().loadRawData(timelineRawData);
		if ( !Ext.isEmpty(timelineRawData) )
		{
			if ( !Ext.isEmpty(selectedTimeline) )
			{
				timelineObj.setValue(selectedTimeline);
			}
			else
			{
				timelineObj.setValue(timelineRawData[0].valueField);
			}
		}
		var start_hour = jsonData.startHour;
		var end_hour = jsonData.endHour;
		var start_date = jsonData.startDate;
		var end_date = jsonData.endDate;
		var startDateObj = mainForm.findField('er_stdate');
		startDateObj.setValue(jsonData.startDateForDisplay);
		startDateObj.dataArray = start_date;
		var startHrObj = mainForm.findField('er_sthr');
		startHrObj.setValue(jsonData.startHourForDisplay);
		startHrObj.dataArray = start_hour;
		var endDateObj = mainForm.findField('er_enddate');
		endDateObj.setValue(jsonData.endDateForDisplay);
		endDateObj.dataArray = end_date;
		var endHrObj = mainForm.findField('er_endhr');
		endHrObj.setValue(jsonData.endHourForDisplay);
		endHrObj.dataArray = end_hour;
		stmin = jsonData.startMinForDisplay;
		enmin = jsonData.endMinForDisplay;
		mgr_stmin = jsonData.startmin;
		mgr_enmin = jsonData.endmin;
		updatingAppSettings(); 
	}
});