Ext.define("ErRumHealthReportApp.view.rumHealthReportTrafficView",{
	extend: 'Ext.panel.Panel',
	alias:'widget.rumhealthreporttrafficview',
	cls:'borderTop_N',
	flex:1,
	layout:{
		type:'hbox',
		align:'stretch',
		pack:'center'
	},
	defaults:{
		padding:'5 20 20 10',
	},
	listeners:{
		'afterrender':function(){
			var me=this;		
			var chartHeight=180;
			var height=0;
			if(this.data.traffic_Table != undefined && this.data.traffic_Table != 'undefined'){
				height=Object.keys(this.data.traffic_Table).length;
			}
			if(height > 5 ){
				chartHeight=chartHeight+((height-5)*22);
			}
			var gridFirst = Ext.create('Ext.grid.Panel', {
				margin:'0 20 0 0',
				border:true,
				ui:'newGridPanel',
				store: Ext.create('Ext.data.Store', {
						fields:[{name:'page_groups'},{name:'page_views'},{name:'avg_time'}],
						sorters: { property: 'page_views', direction : 'DESC' },
						id:'trafficViewStoreID',
						data:this.data.traffic_Table,						
					}),
				columns: [
					{ text: 'Page groups',  dataIndex: 'page_groups',flex: 1,
							renderer : function(value, metadata) {
								metadata.tdAttr = 'data-qtip="' + value + '"';
								return value;
							}
					},
					{ text: 'Traffic Rate/Min', dataIndex: 'page_views', align:'center', flex:1,
						renderer : function(value, metadata) {
							metadata.tdAttr = 'data-qtip="' + value + '"';
							value = me.getDecimalAlignFormat(value);
							return value;
						}
					},
					{ text: 'AVG PAGE LOAD TIME (ms)', dataIndex: 'avg_time', align:'center', flex:1,
						renderer : function(value, metadata) {
							metadata.tdAttr = 'data-qtip="' + value + '" data-qclass=yellowTip ';
							value = me.getDecimalAlignFormat(value);
							return value;
						}
					}
					
				],

			});
			var graphData=this.data.traffic_Chart;
			me.add(
//				{
//					xtype:'container',
//					width:180,
//					html:'<table height="100%" align="left" valign="middle"><tr><td style="padding:20px" class="newFont_bold15">How much? (traffic)</td></tr></table>',
//					cls:'borderRight_N'
//				},
				{
					xtype:'container',
					flex:1,
					layout:{
						type:'column',
						align:'stretch',
						pack:'start'
					},
					defaults:{
						flex:.5,
					},
					items:[
						{
							xtype:'container',
							columnWidth:.5,
							items:
							[
								gridFirst,
							],
						},{
							xtype:'container',
							columnWidth:.5,
							height:chartHeight,
							width:420,
							id:'barChartId',
							
							listeners:{
								'afterrender':function(c){
									var lineChart_1 = {};
									
									if(graphData != null){
										lineChart_1 = jQuery.extend(true, {}, getHighChartsBarInstance('barChartId',chartHeight,400), lineChart_1);
										lineChart_1.setData(graphData,appConstants.currentDateFormat,'');
										lineChart_1.drawChart();
									}
								}
							},
						}
					]
				}
			)
		}
	},
	getDecimalAlignFormat:function(value,isAnchor)
	{
		//if(!isNaN(value) && !isNaN(parseFloat(value))||value == '-')
		var anchorCls = '';
		if(isAnchor)
			anchorCls = 'class="anchorLinkDefault"';
		if(!isNaN(value) && !isNaN(parseFloat(value)))
		{
			value = value.toString();
			if(value!=null && value.indexOf(".")>-1)
			{
				strDecimal = value.substring(value.indexOf("."));
				str = value.substring(0,value.indexOf("."));
				value='<span class="decimal-align"><span '+anchorCls+'>'+str+'</span></span><span class="decimal-align2"><span '+anchorCls+'>'+strDecimal+'</span></span>';
			}
			else
			{
				value='<span class="decimal-align"><span '+anchorCls+'>'+value+'</span></span>';
			}
		}
		else if(value!=undefined && value=='-')
		{
			value = '<div style="text-align:center;">'+value+'</div>'
		}
		return value;
	}
});