Ext.define("ErRumHealthReportApp.view.rumHealthReportUrlsView",{
	extend: 'Ext.panel.Panel',
	alias:'widget.rumhealthreporturlsview',
	id:'rumhealthreporturlsview',
	//cls:'borderTop_N',
	title:' ',
	flex:1,
	layout:{
		type:'vbox',
		align:'stretch',
		pack:'center'
	},
	defaults:{
		padding:'5 20 10 20',
	},
	header:{
		titlePosition:1,
		items:[{
			xtype:'container',
			html:'<div class="newFont_bold14">Which URLs were slow?</div>',
		},{
			xtype:'container',
			width:380,
			id:'url_Title',
			layout:{
				type:'hbox',
				pack:'start',
				align:'center'
			},
			
		}]
	},
	items:[
		{
			xtype:'container',
			flex:1,
			layout:{
				type:'column',
				align:'stretch',
				pack:'center'
			},
			items:[
				{
					xtype:'container',
					columnWidth:1,
					id:'tab_view',
					hidden:true,
					margin:'0 0 10 0',
					layout:{
						type:'column',
						align:'stretch',
						pack:'start'
					},
					defaults:{
						flex:.5,
					},
					items:[
					]
				},{
					xtype:'container',
					columnWidth:1,
					id:'tab_view2',
					hidden:true,
					margin:'0 0 10 0',
					layout:{
						type:'column',
						align:'stretch',
						pack:'start'
					},
					defaults:{
						flex:.5,
					},
					items:[
					]
				}
			]
		}
	],
	listeners:{
		'afterrender':function(){
			var me=this;
			var tierTitle='';
			var techTitle='';
			if(this.size != undefined && this.size !='undefined'){
				tierTitle='Top Slow URLs by Tier'
				techTitle='Top Slow URLs by Technology'
			}
			else if(this.size2 != undefined && this.size2 !='undefined'){
				tierTitle='Top URLs by Page Load Time';
				techTitle='Top URLs by Technology'
			}
			Ext.getCmp('tab_view').add(
				{
					xtype:'container',
					html:tierTitle,
					padding:'0 0 5 0',
					cls:'newFont_normal12',
					columnWidth:1,
				}
			)
			Ext.getCmp('tab_view2').add(
				{
					xtype:'container',
					padding:'0 0 5 0',
					cls:'newFont_normal12',
					html:techTitle,
					columnWidth:1,
				}
			)
			var datas=this.data1;
			var HiddenshowTechData=Ext.getCmp("HiddenshowTechData").getValue();
			var HiddenshowTierData=Ext.getCmp("HiddenshowTierData").getValue();
			var tyui = Ext.getCmp('url_Title');
			if(!Ext.isEmpty('tyui')){
				Ext.getCmp('url_Title').add(
					//{
					//	xtype:'container',
					//	html:'<table height="100%" align="left" valign="middle"><tr><td style="padding:20px" class="newFont_bold15">Which URLs were slow?</td></tr></table>',
					//},
					{
						xtype: 'checkbox',
						boxLabel: 'Tier',
						name: 'showData1',
						margin:'0 0 0 10',
						id:'showTechData1',
						checked: HiddenshowTierData,
						inputValue: false,
						cls: "checkbt",
						listeners:{
							'afterrender':function(checkbox, isChecked){
								
								if(HiddenshowTierData){
									Ext.getCmp("tab_view").show();
									Ext.getCmp("HiddenshowTierData").setValue(true);
								}
								else{
									Ext.getCmp("tab_view").hide();
									Ext.getCmp("HiddenshowTierData").setValue(false);
								}
							},
							'change':function(checkbox, isChecked) {
								if(isChecked){
										Ext.getCmp("tab_view").show();
										Ext.getCmp("HiddenshowTierData").setValue(true);
								}
								else
								{
									
									if(!Ext.getCmp("showTechData").checked)
									{
										this.setValue(true);
										Ext.getCmp("HiddenshowTierData").setValue(true);
											Ext.MessageBox.show({
											title: 'RUM Report',
											msg: 'Cannot Uncheck Both Views.At least one view must be chosen',
											buttons: Ext.MessageBox.OK,
											icon: Ext.MessageBox.WARNING
											});
										return false; 
									}
									Ext.getCmp("tab_view").hide();
									Ext.getCmp("HiddenshowTierData").setValue(false);
								}
							}
						}
					},
					{
						xtype: 'checkbox',
						boxLabel: 'Technology',
						name: 'showData',
						margin:'0 0 0 20',
						id:'showTechData',
						checked: HiddenshowTechData,
						inputValue: false,
						cls: "checkbt",
						listeners:{
							'afterrender':function(){
								if(HiddenshowTechData){
									
									Ext.getCmp("tab_view2").show();
									Ext.getCmp("HiddenshowTechData").setValue(true);
								}
							},
							'change':function(checkbox, isChecked) {
								if(isChecked){
									if(!Ext.getCmp("tab_view").hasCls('newLineBottom'))
										Ext.getCmp("tab_view").addCls('newLineBottom');
									Ext.getCmp("tab_view2").show();
									Ext.getCmp("HiddenshowTechData").setValue(true);
								}
								else
								{
									if(!Ext.getCmp("showTechData1").checked)
									{
										this.setValue(true);
										Ext.getCmp("HiddenshowTechData").setValue(true);
										Ext.MessageBox.show({
											title: 'RUM Report',
											msg: 'Cannot Uncheck Both Views.At least one view must be chosen',
											buttons: Ext.MessageBox.OK,
											icon: Ext.MessageBox.WARNING
											});
										return false; 
									}
									Ext.getCmp("tab_view").removeCls ('newLineBottom');
									Ext.getCmp("tab_view2").hide();
									Ext.getCmp("HiddenshowTechData").setValue(false);
								}
							}
						}
					}
				);
			}
			
			if(this.size != undefined && this.size !='undefined')
			{
				var colWidth=.5;
				if(this.size == 1)
					colWidth=1;
				if(this.data.Avg_Page_Rendering_Time != undefined && this.data.Avg_Page_Rendering_Time != 'undefined'){
					var gridFirst = Ext.create('Ext.grid.Panel', {
						margin:'0 20 0 0',
						//border:false,
						border:true,
						ui:'newGridPanel headerTextWrap',
						forceFit:true,
						scroll:true,
						autoScroll:true,
						flex:1,
						store: Ext.create('Ext.data.Store', {
							fields:[{name:'page_groups'},{name:'Val'},{name:'avg_time'},{name:'page_views'}],
							sorters: { property: 'Val', direction : 'DESC' },
							id:'responseTimestoreID',
							data:this.data.Avg_Page_Rendering_Time,
						}),
						columns: [
							{
								text:'Page groups',
								dataIndex:'page_groups',
								flex:1,
								width:200,
								renderer : function(value, metadata) {
									metadata.tdAttr = 'data-qtip="' + value + '"';
									return value;
								}
							},
							{ text: 'AVG BROWSER TIME (ms)', dataIndex: 'Val', align:'center',width:105,
							   renderer:function(value,metaData)
								{
									metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+value+'"';
									value = me.getDecimalAlignFormat(value);
									return value;
								}
							},
							{ text: 'AVG PAGE LOAD TIME (ms)', dataIndex: 'avg_time', align:'center',width:110 ,
							   renderer:function(value,metaData)
								{
									metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+value+'"';
									value = me.getDecimalAlignFormat(value);
									return value;
								}
							},
							{ text: 'PAGE VIEWS', dataIndex: 'page_views', align:'center', width:70,
							   renderer:function(value,metaData)
								{
									metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+value+'"';
									value = me.getDecimalAlignFormat(value);
									return value;
								}
							}
						]
					});
				}
				if(this.data.Avg_Network_Time != undefined && this.data.Avg_Network_Time != 'undefined'){
					var gridSecond = Ext.create('Ext.grid.Panel', {
						margin:'0 20 0 0',
						//border:false,
						border:true,
						ui:'newGridPanel headerTextWrap',
						forceFit:true,
						scroll:true,
						autoScroll:true,
						//flex:1,
						store: Ext.create('Ext.data.Store', {
							fields:[{name:'page_groups'},{name:'Val'},{name:'avg_time'},{name:'page_views'}],
							sorters: { property: 'Val', direction : 'DESC' },
							id:'responseTimestoreID',
							data:this.data.Avg_Network_Time,
						}),
						columns: [
							{
								text: 'Page groups',
								dataIndex: 'page_groups',
								flex:1,
								width:200,
								renderer : function(value, metadata) {
									metadata.tdAttr = 'data-qtip="' + value + '"';
									return value;
								}
							},
							{ text: 'AVG NETWORK TIME (ms)', dataIndex: 'Val', align:'center',width:105,
							   renderer:function(value,metaData)
								{
									metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+value+'"';
									value = me.getDecimalAlignFormat(value);
									return value;
								}
							},
							{ text: 'AVG PAGE LOAD TIME (ms)', dataIndex: 'avg_time', align:'center',width:110 ,
							   renderer:function(value,metaData)
								{
									metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+value+'"';
									value = me.getDecimalAlignFormat(value);
									return value;
								}
							},
							{ text: 'PAGE VIEWS', dataIndex: 'page_views', align:'center',width:70,
							   renderer:function(value,metaData)
								{
									metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+value+'"';
									value = me.getDecimalAlignFormat(value);
									return value;
								}
							}
						]
					});
				}
				if(this.data.Avg_Dom_Ready_Time != undefined && this.data.Avg_Dom_Ready_Time != 'undefined'){
					var gridThird = Ext.create('Ext.grid.Panel', {
						margin:'0 20 0 0',
						//border:false,
						border:true,
						ui:'newGridPanel headerTextWrap',
						forceFit:true,
						scroll:true,
						autoScroll:true,
						//flex:1,
						store: Ext.create('Ext.data.Store', {
							fields:[{name:'page_groups'},{name:'Val'},{name:'avg_time'},{name:'page_views'}],
							sorters: { property: 'Val', direction : 'DESC' },
							id:'responseTimestoreID',
							data:this.data.Avg_Dom_Ready_Time,
						}),
						columns: [
							{
								text: 'Page groups',
								dataIndex: 'page_groups',
								flex:1,
								width:120,
								renderer : function(value, metadata) {
									metadata.tdAttr = 'data-qtip="' + value + '"';
									return value;
								}
							},
							{ text: 'AVG CONTENT DOWNLOAD TIME (ms)', dataIndex: 'Val', align:'center',width:140,
							   renderer:function(value,metaData)
								{
									metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+value+'"';
									value = me.getDecimalAlignFormat(value);
									return value;
								}
							},
							{ text: 'AVG PAGE LOAD TIME (ms)', dataIndex: 'avg_time', align:'center',width:105,
							   renderer:function(value,metaData)
								{
									metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+value+'"';
									value = me.getDecimalAlignFormat(value);
									return value;
								}
							},
							{ text: 'PAGE VIEWS', dataIndex: 'page_views', align:'center',width:60,
							   renderer:function(value,metaData)
								{
									metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+value+'"';
									value = me.getDecimalAlignFormat(value);
									return value;
								}
							}
						]
					});
				}
				if(this.data.Avg_Response_Avail_Time != undefined && this.data.Avg_Response_Avail_Time != 'undefined'){
					var gridFourth = Ext.create('Ext.grid.Panel', {
						margin:'0 20 0 0',
						//border:false,
						border:true,
						ui:'newGridPanel headerTextWrap',
						forceFit:true,
						scroll:true,
						autoScroll:true,
						//flex:1,
						store: Ext.create('Ext.data.Store', {
							fields:[{name:'page_groups'},{name:'Val'},{name:'avg_time'},{name:'page_views'}],
							sorters: { property: 'Val', direction : 'DESC' },
							id:'responseTimestoreID',
							data:this.data.Avg_Response_Avail_Time,
						}),
						columns: [
							{
								text: 'Page groups',
								dataIndex: 'page_groups',
								flex:1,
								width:200,
								renderer : function(value, metadata) {
									metadata.tdAttr = 'data-qtip="' + value + '"';
									return value;
								}
							},
							{ text: 'AVG SERVER TIME (ms)', dataIndex: 'Val', align:'center',width:105 ,
							  renderer:function(value,metaData)
								{
									metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+value+'"';
									value = me.getDecimalAlignFormat(value);
									return value;
								}
							},
							{ text: 'AVG PAGE LOAD TIME (ms)', dataIndex: 'avg_time', align:'center',width:110,
							  renderer:function(value,metaData)
								{
									metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+value+'"';
									value = me.getDecimalAlignFormat(value);
									return value;
								}
							},
							{ text: 'PAGE VIEWS', dataIndex: 'page_views', align:'center',width:70 ,
								renderer:function(value,metaData)
								{
									metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+value+'"';
									value = me.getDecimalAlignFormat(value);
									return value;
								}
							}
						]
					});
			}
			if(this.data.Avg_Page_Rendering_Time != undefined && this.data.Avg_Page_Rendering_Time != 'undefined'){
				Ext.getCmp('tab_view').add({
						xtype:'container',
						id:'tier_1',
						columnWidth:colWidth,
						items:[
							gridFirst,
						{
							xtype:'container',
							border:true,
							margin:'10 20 10 0',
							width:'auto',
							padding:0,
							html:'<div class="notes"><div class="paperPin"> </div> <div style="float:right" class="notesText">Investigate <i class="notesTextBold">Browser Time</i>&nbsp;&nbsp;for these URLs</i></div></div>'
						}]
					})
				}
						var cnt=0;
			if(this.data.Avg_Network_Time != undefined && this.data.Avg_Network_Time != 'undefined'){
					Ext.getCmp('tab_view').add({
						xtype:'container',
						columnWidth:colWidth,
						id:'tier_2',
						items:[
							gridSecond,
						{
							xtype:'container',
							border:true,
							margin:'10 20 10 0',
							width:'auto',
							padding:0,
								html:'<div class="notes"><div class="paperPin"> </div> <div style="float:right" class="notesText">Investigate <i class="notesTextBold">Network Time</i>&nbsp;&nbsp;for these URLs</i></div></div>'
						}]
					})
				}
				if(this.data.Avg_Dom_Ready_Time != undefined && this.data.Avg_Dom_Ready_Time != 'undefined'){

						Ext.getCmp('tab_view').add({
						xtype:'container',
						id:'tier_3',
						columnWidth:colWidth,
						items:[
							gridThird,
						{
							xtype:'container',
							border:true,
							margin:'10 20 10 0',
							width:'auto',
							padding:0,
								html:'<div class="notes"><div class="paperPin"> </div> <div style="float:right" class="notesText">Investigate <i class="notesTextBold">Content Download Time</i>&nbsp;&nbsp;for these URLs</i></div></div>'
						}]
					})
				}
				if(this.data.Avg_Response_Avail_Time != undefined && this.data.Avg_Response_Avail_Time != 'undefined'){

					Ext.getCmp('tab_view').add({
						xtype:'container',
						id:'tier_4',
						columnWidth:colWidth,
						items:[
							gridFourth,
						{
							xtype:'container',
							border:true,
							margin:'10 20 10 0',
							width:'auto',
							padding:0,
								html:'<div class="notes"><div class="paperPin"> </div> <div style="float:right" class="notesText">Investigate <i class="notesTextBold">Server Time</i>&nbsp;&nbsp;for these URLs</i></div></div>'
						}]
					})
				}
			}else if(this.size2 != undefined && this.size2 !='undefined'){
					var gridFirst = Ext.create('Ext.grid.Panel', {
						margin:'0 20 0 0',
						//border:false,
						border:true,
						style: {
							borderColor: 'transparent',
							borderWidth :'1px',
							borderStyle: 'solid'
						},
						ui:'newGridPanel',
						store: Ext.create('Ext.data.Store', {
							fields:[{name:'page_groups'},{name:'avg_time'},{name:'browser_time'},{name:'content_time'},{name:'network_time'},{name:'server_time'}],
							sorters: { property: 'avg_time', direction : 'DESC' },
							data:this.data2,
						}),
						columns: [
							{ text: 'Page groups',  dataIndex: 'page_groups',flex: 1,
								renderer : function(value, metadata) {
									metadata.tdAttr = 'data-qtip="' + value + '"';
									return value;
								}
							},
							{ text: 'AVG PAGE LOAD TIME (ms)', dataIndex: 'avg_time', align:'center',
							   renderer:function(value,metaData)
								{
									metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+value+'"';
									value = me.getDecimalAlignFormat(value);
									return value;
								}
							},
							{ text: 'AVG BROWSER TIME (ms)', dataIndex: 'browser_time', align:'center',
							   renderer:function(value,metaData)
								{
									metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+value+'"';
									value = me.getDecimalAlignFormat(value);
									return value;
								}
							},
							{ text: 'AVG CONTENTT DOWNLOAD TIME (ms)', dataIndex: 'content_time', align:'center',
							   renderer:function(value,metaData)
								{
									metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+value+'"';
									value = me.getDecimalAlignFormat(value);
									return value;
								}
							},
							{ text: 'AVG NETWORK TIME (ms)', dataIndex: 'network_time', align:'center',
							   renderer:function(value,metaData)
								{
									metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+value+'"';
									value = me.getDecimalAlignFormat(value);
									return value;
								}
							},
							{ text: 'AVG SERVER TIME (ms)', dataIndex: 'server_time', align:'center',
							   renderer:function(value,metaData)
								{
									metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+value+'"';
									value = me.getDecimalAlignFormat(value);
									return value;
								}
							}
						]
					});
				
					Ext.getCmp('tab_view').add({
						xtype:'container',
						columnWidth:1,
						id:'tier_top',
						items:[
							gridFirst,
							{
								xtype:'container',
								border:true,
								margin:'10 20 10 0',
								width:'auto',
								padding:0,
									html:'<div class="notes"><div class="paperPin"> </div> <div style="float:right" class="notesText">These are the top URLs by page load time</div></div>'
							}]
					})
			}
			if(this.size1 != undefined && this.size1 !='undefined'){

				var colWidth=.5;
				if(this.size1 == 1)
					colWidth=1;
				var data=this.data1;
				if(data.Desktop != undefined && data.Desktop != 'undefined')
				{
					var height1=null;
					if(data.Mobile != undefined && data.Mobile != 'undefined'){
						if(Object.keys(data.Mobile).length > Object.keys(data.Desktop).length)
							height1=(Object.keys(data.Mobile).length * 23)+23+Object.keys(data.Desktop).length;
					}else if(data.Tablet != undefined && data.Tablet != 'undefined'){
						if(Object.keys(data.Tablet).length > Object.keys(data.Desktop).length)
							height1=(Object.keys(data.Tablet).length * 23)+23+Object.keys(data.Desktop).length;
					}
					var gridFirst = Ext.create('Ext.grid.Panel', {
						margin:'0 20 0 0',
						//border:false,
						border:true,
						ui:'newGridPanel',
						height:height1,
						store: Ext.create('Ext.data.Store', {
							fields:[{name:'GROUPNAME'},{name:'avg_loadTime'},{name:'PageView'}],
							sorters: { property: 'avg_loadTime', direction : 'DESC' },
							id:'responseTimestoreID',
							data:data.Desktop,
						}),
						columns: [
							{ text: 'Page groups from desktop',  dataIndex: 'GROUPNAME',flex: 1,
								renderer : function(value, metadata) {
									metadata.tdAttr = 'data-qtip="' + value + '"';
									return value;
								}
							},
							{ text: 'AVG PAGE LOAD TIME (ms)', dataIndex: 'avg_loadTime', align:'center',
							   renderer:function(value,metaData)
								{
									metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+value+'"';
									value = me.getDecimalAlignFormat(value);
									return value;
								}
							},
							{ text: 'PAGE VIEWS', dataIndex: 'PageView', align:'center',
							   renderer:function(value,metaData)
								{
									metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+value+'"';
									value = me.getDecimalAlignFormat(value);
									return value;
								}
							}
						]
					});
				}
				if(data.Mobile != undefined && data.Mobile != 'undefined')
				{
					var height1=null;
					if(data.Desktop != undefined && data.Desktop != 'undefined'){
						height1=null;
					}else if((data.Tablet != undefined && data.Tablet != 'undefined') && (data.Desktop == undefined || data.Desktop == 'undefined')) 
					{
						if(Object.keys(data.Tablet).length > Object.keys(data.Mobile).length)
							height1=(Object.keys(data.Tablet).length * 23)+23+Object.keys(data.Mobile).length;
					}
					var gridSecond = Ext.create('Ext.grid.Panel', {
						margin:'0 20 0 0',
						//border:false,
						border:true,
						ui:'newGridPanel',
						height:height1,
						store: Ext.create('Ext.data.Store', {
							fields:[{name:'GROUPNAME'},{name:'avg_loadTime'},{name:'PageView'}],
							sorters: { property: 'avg_loadTime', direction : 'DESC' },
							id:'responseTimestoreID',
							data:data.Mobile,
						}),
						columns: [
							{ text: 'Page groups from mobile',  dataIndex: 'GROUPNAME',flex: 1, 
								renderer : function(value, metadata) {
									metadata.tdAttr = 'data-qtip="' + value + '"';
									return value;
								}
							},
							{ text: 'AVG PAGE LOAD TIME (ms)', dataIndex: 'avg_loadTime', align:'center' , flex:1,
							   renderer:function(value,metaData)
								{
									metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+value+'"';
									value = me.getDecimalAlignFormat(value);
									return value;
								}
							},
							{ text: 'PAGE VIEWS', dataIndex: 'PageView', align:'center',
							   renderer:function(value,metaData)
								{
									metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+value+'"';
									value = me.getDecimalAlignFormat(value);
									return value;
								}
							}
						]
					});
				}
				if(data.Tablet != undefined && data.Tablet != 'undefined')
				{
					var height1=null;
					if((data.Desktop != undefined && data.Desktop != 'undefined') && (data.Mobile != undefined && data.Mobile != 'undefined'))
					{
						height1=null;
					}else if((data.Desktop == undefined || data.Desktop == 'undefined') && (data.Mobile != undefined && data.Mobile != 'undefined'))
					{
						if(Object.keys(data.Mobile).length > Object.keys(data.Tablet).length)
							height1=(Object.keys(data.Mobile).length * 23)+23+Object.keys(data.Tablet).length;
					}
					else if((data.Desktop != undefined && data.Desktop != 'undefined') && (data.Mobile == undefined || data.Mobile == 'undefined'))
					{
						if(Object.keys(data.Desktop).length > Object.keys(data.Tablet).length)
							height1=(Object.keys(data.Desktop).length * 23)+23+Object.keys(data.Tablet).length;
					}
					var gridThird = Ext.create('Ext.grid.Panel', {
						margin:'0 20 0 0',
						//border:false,
						border:true,
						ui:'newGridPanel',
						height:height1,
						store: Ext.create('Ext.data.Store', {
							fields:[{name:'GROUPNAME'},{name:'avg_loadTime'},{name:'PageView'}],
							sorters: { property: 'avg_loadTime', direction : 'DESC' },
							id:'responseTimestoreID',
							data:data.Tablet,
						}),
						columns: [
							{ text: 'Page groups from tablet',  dataIndex: 'GROUPNAME',flex: 1, 
								renderer : function(value, metadata) {
									metadata.tdAttr = 'data-qtip="' + value + '"';
									return value;
								}
							},
							{ text: 'AVG PAGE LOAD TIME (ms)', dataIndex: 'avg_loadTime', align:'center', flex:1 ,
							   renderer:function(value,metaData)
								{
									metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+value+'"';
									value = me.getDecimalAlignFormat(value);
									return value;
								}
							},
							{ text: 'PAGE VIEWS', dataIndex: 'PageView', align:'center',
							   renderer:function(value,metaData)
								{
									metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+value+'"';
									value = me.getDecimalAlignFormat(value);
									return value;
								}
							}
						]
					});
				}
				if(data.Desktop != undefined  && data.Desktop != 'undefined')
				{
					var note='';
					if(this.size != undefined && this.size !='undefined'){
							note='Top Slow <i class="notesTextBold">Desktop</i> URLs by Page Load Time'
					}
					else if(this.size2 != undefined && this.size2 !='undefined'){
							note='Top <i class="notesTextBold">Desktop</i> URLs by Page Load Time'
					}
					Ext.getCmp('tab_view2').add({
						xtype:'container',
						id:'tech_1',
						columnWidth:colWidth,
						items:[
								gridFirst,
							{
								xtype:'container',
								border:true,
								margin:'10 20 10 0',
								width:'auto',
								padding:0,
								//html:'<div class="notes"><div class="paperPin"> </div> <div style="float:right" class="newFont_normal13">Investigate  <i class="newFont_bold13">Desktop</i></div></div>'
									html:'<div class="notes"><div class="paperPin"> </div> <div style="float:right" class="notesText">'+note+'</div></div>'
							}
						]
					})
				}
				if(data.Mobile != undefined && data.Mobile != 'undefined')
				{
					var note='';
					if(this.size != undefined && this.size !='undefined'){
							note='Top Slow <i class="notesTextBold">Mobile</i> URLs by Page Load Time'
					}
					else if(this.size2 != undefined && this.size2 !='undefined'){
							note='Top <i class="notesTextBold">Mobile</i> URLs by Page Load Time'
					}
					Ext.getCmp('tab_view2').add({
						xtype:'container',
						id:'tech_2',
						columnWidth:colWidth,
						items:[
							gridSecond,
						
						{
							xtype:'container',
							border:true,
							margin:'10 20 10 0',
							width:'auto',
							padding:0,
								html:'<div class="notes"><div class="paperPin"> </div> <div style="float:right" class="notesText">'+note+'</div></div>'
						}]
					})
				}
				if(data.Tablet != undefined && data.Tablet != 'undefined')
				{
					var note='';
					if(this.size != undefined && this.size !='undefined'){
							note='Top Slow <i class="notesTextBold">Tablet</i> URLs by Page Load Time'
					}
					else if(this.size2 != undefined && this.size2 !='undefined'){
							note='Top <i class="notesTextBold">Tablet</i> URLs by Page Load Time'
					}
						Ext.getCmp('tab_view2').add({
						xtype:'container',
						id:'tech_3',
						columnWidth:colWidth,
						
						items:[
							gridThird,
						{
							xtype:'container',
							border:true,
							margin:'10 20 10 0',
							width:'auto',
							padding:0,
								html:'<div class="notes"><div class="paperPin"> </div> <div style="float:right" class="notesText">'+note+'</div></div>'
						}]
					})
				}
			}
		}
	},
	getDecimalAlignFormat:function(value,isAnchor)
	{
		//if(!isNaN(value) && !isNaN(parseFloat(value))||value == '-')
		var anchorCls = '';
		if(isAnchor)
			anchorCls = 'class="anchorLinkDefault"';
		if(!isNaN(value) && !isNaN(parseFloat(value)))
		{
			value = value.toString();
			if(value!=null && value.indexOf(".")>-1)
			{
				strDecimal = value.substring(value.indexOf("."));
				str = value.substring(0,value.indexOf("."));
				value='<span class="decimal-align"><span '+anchorCls+'>'+str+'</span></span><span class="decimal-align2"><span '+anchorCls+'>'+strDecimal+'</span></span>';
			}
			else
			{
				value='<span class="decimal-align"><span '+anchorCls+'>'+value+'</span></span>';
			}
		}
		else if(value!=undefined && value=='-')
		{
			value = '<div style="text-align:center;">'+value+'</div>'
		}
		return value;
	}
});