Ext.define('RSR.controller.RSRController', {
    extend: 'Ext.app.Controller',
	gridColStateParam:'ASC',//deafult 1 for ascending
 	gridColIndexParam:-1,//added for updating sort by option
    views: ['Main'],
    refs: [{
            selector: 'main',
            ref: 'main'
        }, {
            selector: 'newUtilities',
            ref: 'newUtilities'
        }, {
            selector: 'emptypanel',
            ref: 'emptypanel'
        },
		{selector:'nomeasurepanel', ref:'nomeasurepanel'},
		{selector: 'backGroundPanel',ref: 'backGroundPanel'}
    ],
    init: function () {
        this.control({
            'main': {
                'boxready': this.defaultLoading
            },
            'newUtilities': {
                'afterrender': this.loadTools
            },
            'RSRconfig': {
                'afterrender': this.afterSettingsrender
            },
            'newUtilities #saveTool button': {
                'click': this.saveReportAsPDF
            },
		'newUtilities > #csvTool > button': {
			'click': this.callCSV
		},
            'newUtilities > #printTool > button': {
                'click': this.printFile
            },
            'newUtilities > #mailTool > button': {
                'click': this.sendMail
            },
            'newUtilities > #favoriteTool > button': {
                'click': this.saveFavorite
            },
            'newUtilities > #scheduleTool > button': {
                'click': this.sendToschedule
            },
            'RSRdetails combo[name="er_option"]': {
                'select': this.analyzeByOnChange
            },
            'RSRdetails combo[name="er_service"]': {
                'select': this.serviceOnChange
            },
			'RSRdetails combo[name="er_segment"]': {
                'select': this.segmentOnChange
            },
			 'RSRdetails combo[name="er_zone"]': {
                'select': this.zoneOnChange
            },
			'RSRdetails combo[name="er_comptype"]': {
                'select': this.comptypeOnChange
            },
			'RSRdetails combo[id="er_criteria"]': {
                'select': this.criteriaOnChange
            },
			'RSRdetails combo[id="er_criteriaInfo"]': {
                'select': this.criteriaOnChange
            },
           	'RSRdetails combo[name="subZone"]': {
                'select': this.componentOnChange
            },
            'mainform button[name="submit"]': {
                'click': this.showResult
            },
			 'mainform button[name="save"]': {
                'click': this.goTo
            },
			'RSRconfig combo[name="reportGeneration"]': {
                'select': this.reportGenChange
            },
			'RSRconfig button[id="moreOptionCloseId"]': {
				'click': this.validateAndCloseSettings
			},
			'RSRconfig button[id="submitViaSetting"]': {
				'click': this.closeSettingAndSubmit
			},
            'egcomponent button[id="expandSelector"]': {
                'click': this.expandMe
            },
			'wysereportgrid textfield[name="livesearch"]':
			{
					keyup:this.searchSchedules
			},
			'egcomponent trigger[id="compSearch"]':
			{
				'change': this.filterMultiselect
			},
			'mainform button[id="panelinsidetoggle"]': {
				'click': this.toggleForm
			}
        });
    },
	showConfigDropdown:function(){
		var tpl = new Ext.XTemplate('<div style="float:left;margin:0px 0px 0px 0px" >'+settings+'</div><div style="text-align:right;float:right;"><div class="iconCloseNew" id="closeSettings"></div></div>');
		Ext.create('Ext.container.Container',{
		width:565,
		//padding:5,
 		id:'configMod',
		//cls:'configMode_popup',
		ui:'settingsWindowContainer',
 		items:[
			{
				xtype:'container',
				cls:'configMode_popupArrow',
				style:{'top':'-14px','left':'355px'}
			},
			{
				xtype:'container',
				cls:'containerHeader',
				html:tpl.apply(),
				style:{'top':'0px','margin':'0px'}
			},
			{
				xtype : 'RSRconfig',
				parent:this
			}
		],
		renderTo:'main-body'
		});
		var thisController = this;
       // this.getMain().showConfigDropdown();
		this.disableTools();
		this.setDynamicByCriteria(Ext.getCmp('er_criteria'));
		 Ext.get('closeSettings').on('click', function () {
          	   thisController.validateAndCloseSettings();
        });
	},
	
	validateAndCloseSettings:function()
	{
	    var isSettingsOk = true;
		var reportgenVal = Ext.getCmp('reportGeneration').getValue();
		if ( reportgenVal == 'background' )
		{
			var reportName = Ext.getCmp('bgReportName').getValue();
			var ret = validateTextBoxWithSpecialChars(reportName,'Attachment',true);
			if ( !ret )
			{
				Ext.getCmp('bgReportName').focus();
				 return false;
			}
		}
		var timePeriodFromHrs = Ext.getCmp('timefrom').getValue();
		var timePeriodFromMins = Ext.getCmp('minfrom').getValue();
		var timePeriodToHrs = Ext.getCmp('timeto').getValue();
		var timePeriodToMins = Ext.getCmp('minto').getValue();
		if (!checkTimePeriod(timePeriodFromHrs, timePeriodFromMins, timePeriodToHrs, timePeriodToMins)) {
			return false;
		}
		var getButtonObj = Ext.getCmp('submit');
		getButtonObj.setDisabled(true);
		if (isSettingsOk) {
			getButtonObj.setDisabled(false);
			Ext.get('configMod').animate({
				duration: 500,
				to: {
					y: -500
				}
			});
		}
		return true;
	},
	closeSettingAndSubmit:function()
	{
		if(this.validateAndCloseSettings())
		{
			this.showResult();
		}
	},
	afterSettingsrender : function() {
		Ext.getCmp('moreOptionCloseId').show();
		var hiddenFields =  appConstants.publicJsonData["hiddenFields"];
		var favorite_id = hiddenFields["favorite_id"];
				if(!Ext.isEmpty(favorite_id)){
			Ext.getCmp('reportGeneration').setDisabled(true);
		}
		var jsonData = appConstants.publicJsonData;
		var timeFrom = jsonData.timeZone.hrsFrom;
        var minsFrom = jsonData.timeZone.minsFrom;
        var timeTo = jsonData.timeZone.hrsTo;
        var minsTo = jsonData.timeZone.minsTo;

        var obj = Ext.getCmp('timefrom');
        obj.setValue(timeFrom);

        obj = Ext.getCmp('minfrom');
        obj.setValue(minsFrom);

        obj = Ext.getCmp('timeto');
        obj.setValue(timeTo);

        obj = Ext.getCmp('minto');
        obj.setValue(minsTo);
		if(jsonData.hasOwnProperty('reportGenerationCombo'))
		{
			var rawData = jsonData.reportGenerationCombo;
			obj = Ext.getCmp('reportGeneration');
			obj.setFieldLabel(jsonData.displayFields['reportGenerationComboLabel']);
			obj.getStore().loadRawData(rawData);
			 if(jsonData.selectedFields.hasOwnProperty('reportGenerationComboSelected'))
			 {
					selection=jsonData.selectedFields.reportGenerationComboSelected;
					obj.setValue(selection);
			 }
			 else
			 {
					 obj.setValue(rawData[1].valueField);
			 }
		}
	},
	filterMultiselect: function (obj) {
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		obj.toggleTriggger();
		appConstants.erUtils.filterComboStore(obj,Ext.getCmp('er_component'),appConstants.rawDataForComponents);
    },
	goTo: function (btn) {
		appConstants.formButtonId = btn.getId();
		var hiddenFields =  appConstants.publicJsonData["hiddenFields"];
		var from_favorite = hiddenFields["fromFavoriteModify"];
		if ((from_favorite != null && from_favorite == "Yes")) {
			this.saveFavorite();
		}else{
			//document.location = '/final/servlet/com.eg.ErFavoriteC?' + queryString + '&call=json&cmd=client&FavoriteId='+favorite_id+ "&shareUsers=" + er_favorite + "&publicUsers=" + er_favorite+"&fromFavoriteModify=yes";
			this.sendToschedule();
		}
    },

	loadTools: function () {
        this.getNewUtilities().loadIcon(true, true, true, false, true, true,
            true, false, false, false,true);

		// Ext.getCmp("upbutton").hide();
        Ext.getCmp("favoriteTool").setDisabled(false);
        Ext.getCmp("scheduleTool").setDisabled(false);
    },
	reportGenChange: function () {
        Ext.getCmp('resultPanel').hide();
        this.disableTools();
        var reportGenType = Ext.getCmp('reportGeneration').getValue();
        if (reportGenType == 'background' || reportGenType == 'background-csv') {
            Ext.getCmp('bgReportName').setValue("");
            Ext.getCmp('bgReportName').show();
			Ext.getCmp('submitViaSetting').show();
			Ext.getCmp('moreOptionCloseId').hide();
        } else {
            Ext.getCmp('bgReportName').hide();
			Ext.getCmp('submitViaSetting').hide();
			Ext.getCmp('moreOptionCloseId').show();
        }
    },
	showResult: function () {

		Ext.getCmp('panelinsidetoggle').setDisabled(false);

		var startdate = Ext.getCmp('er_stdate').getValue();
        var starthr = Ext.getCmp('er_sthr').getValue();
        startdate.setHours(starthr);
        var enddate = Ext.getCmp('er_enddate').getValue();
        var endhr = Ext.getCmp('er_endhr').getValue();
        enddate.setHours(endhr);
        var result = checkDateTime(startdate, enddate);
		if (!result) {
            return;
        }
        var isSettingsOk = this.validateRSRForm();
		if (isSettingsOk)
		{
			isSettingsOk = this.validateSettings();
		}
        if(isSettingsOk)
		{
 			this.RSRFormSubmit();
		}
		else
		{
			return;
		}

    },
	validateRSRForm: function () {
		var analyzeByObj=Ext.getCmp('er_option');
		var segmentObj=Ext.getCmp('er_segment');
		var serviceObj=Ext.getCmp('er_service');
		var zoneObj=Ext.getCmp('er_zone');
		var subZoneObj=Ext.getCmp('er_includezones');
		var componentTypeObj=Ext.getCmp('er_comptype');
		var componentObj=Ext.getCmp('er_component');
		var criterionObj=Ext.getCmp('er_criteria');
		var criterionInfoObj=Ext.getCmp('er_criteriaInfo');
		var vmObj=Ext.getCmp('er_criteriaOnly');

		var analyzeByCombo_jsonProperty='analyzeByCombo';
		var segmentCombo_jsonProperty='segmentCombo';
		var serviceCombo_jsonProperty='serviceCombo';
		var zoneCombo_jsonProperty='zoneCombo';
		var subZoneCombo_jsonProperty='subZoneCombo';
		var componentTypeCombo_jsonProperty='componentTypeCombo';
		var componentCombo_jsonProperty='componentCombo';
		var criterionCombo_jsonProperty='criterionCombo';
		var criterionInfoCombo_jsonProperty='criterionInfoCombo';
		var vmCombo_jsonProperty='vmCombo';

		 if(this.validateRSRField(analyzeByObj.getValue(),analyzeByObj,analyzeByCombo_jsonProperty))
		  {
			if(this.validateRSRField(segmentObj.getValue(),segmentObj,segmentCombo_jsonProperty))
			  {
			  	   if (this.validateRSRField(serviceObj.getValue(),serviceObj,serviceCombo_jsonProperty))
				   {
					   if (this.validateRSRField(zoneObj.getValue(),zoneObj,zoneCombo_jsonProperty))
					   {
						   if (this.validateRSRField(subZoneObj.getValue(),subZoneObj,subZoneCombo_jsonProperty))
						   {
								if (this.validateRSRField(componentTypeObj.getValue(),componentTypeObj,componentTypeCombo_jsonProperty))
							    {
									if (this.validateRSRField(componentObj.getValue(),componentObj,componentCombo_jsonProperty))
									{
										if (this.validateRSRField(criterionObj.getValue(),criterionObj,criterionCombo_jsonProperty))
										{
											if (this.validateRSRField(criterionInfoObj.getValue(),criterionInfoObj,criterionInfoCombo_jsonProperty))
											{
												if (this.validateRSRField(vmObj.getValue(),vmObj,vmCombo_jsonProperty))
												{
													return true;
												}
											}
										}
									}
							    }
						   }
					   }
				   }
			  }
		  }
	},
	validateRSRField:function(objValue,obj,jsonProperty)
	{

		if(appConstants.publicJsonData.hasOwnProperty(jsonProperty))
		{
		   if(objValue=='-1'||objValue=='Not Applicable'||objValue=='')
			{
				Ext.MessageBox.show({
							title: appConstants.publicJsonData.displayFields.reportTitle,
							msg: 'Please choose a '+obj.fieldLabel,//obj.getStore().getAt(0).get('displayField'),
							buttons: Ext.MessageBox.OK,
							icon: Ext.MessageBox.WARNING
						});
						return false;
			} 			else
			{

				return true;
			}
		}
		else
		{
			 return true;
		}
	},
	RSRFormSubmit:function()
	{
		var analyzeByValue=Ext.getCmp('er_option').getValue();
		var segmentValue=Ext.getCmp('er_segment').getValue();
		var serviceValue=Ext.getCmp('er_service').getValue();
		var zoneValue=Ext.getCmp('er_zone').getValue();
		var subZoneValue=Ext.getCmp('er_includezones').getValue();
		var componentTypeValue=Ext.getCmp('er_comptype').getValue();
		var criterionValue=Ext.getCmp('er_criteria').getValue();
		var criterionInfoValue=Ext.getCmp('er_criteriaInfo').getValue();
		var vmValue=Ext.getCmp('er_criteriaOnly').getValue();
		var reportGeneration = appConstants.publicJsonData.selectedFields.reportGeneration;
		if (isSettingsEnabled)
		{
			Ext.get('configMod').animate({duration: 500,to: {y: -500}});
			reportGeneration = Ext.getCmp('reportGeneration').getValue();
		}
		var er_comp_Array=new Array();
		var comQuery="";
		var hiddenfieldQString="";
		er_comp_Array = Ext.getCmp('er_component').getValue();
        for (var k = 0; er_comp_Array.length > k; k++) {
            comQuery += "&er_component=" + er_comp_Array[k];
        }
 		var dynaParam="&er_option="+analyzeByValue+"&er_comptype="+componentTypeValue+comQuery+"&er_criteria="+criterionValue+"&er_criteriaInfo="+criterionInfoValue+"&er_criteriaOnly="+vmValue;

		if(appConstants.publicJsonData.hasOwnProperty('segmentCombo'))
		 dynaParam+="&er_site="+segmentValue;
 		else if(appConstants.publicJsonData.hasOwnProperty('serviceCombo'))
		 dynaParam+="&er_site="+serviceValue;
 		else if(appConstants.publicJsonData.hasOwnProperty('zoneCombo'))
		 dynaParam+="&er_site="+zoneValue+"&er_includezones="+subZoneValue;
 		else
		 dynaParam=dynaParam;

		  //alert(dynaParam);
		this.updateFormQueryString(dynaParam);

		 if (appConstants.publicJsonData.hasOwnProperty('hiddenFields')) {
            var hiddenFields = appConstants.publicJsonData.hiddenFields;
            for (var hiddenField in hiddenFields) {
				if(hiddenField == 'er_rtype' || hiddenField == 'er_trgttype'||hiddenField == 'eruserid')
				{
					continue;
				}
                hiddenfieldQString += "&" + hiddenField + "=" + hiddenFields[hiddenField];
            }
        }

         	var finalParams = appConstants.queryString + hiddenfieldQString;
			if (reportGeneration == 'foreground')
			{
				finalParams+="&isSubmit=true";
				urlforAjax='../servlet/com.eg.ErVMRightSizingReportC?beta=json';
			}
			else if (reportGeneration == 'background') {
				finalParams+="&throughSchedule=true";
				urlforAjax='../servlet/com.eg.ErStartBackGroundReportC';
				var bg_reportname = Ext.getCmp('bgReportName').getValue();
					bg_reportname=checkFileName(bg_reportname);
				finalParams += "&bg_reportname=" + bg_reportname;
			}
			else if (reportGeneration == 'background-csv') 
			{
				urlforAjax = "../servlet/com.eg.ErStartBackGroundReportC?isSubmit=true&SaveFormat=CSV";
				var bg_reportname = Ext.getCmp('bgReportName').getValue();
				bg_reportname=checkFileName(bg_reportname);
				finalParams += "&bg_reportname=" + bg_reportname;
			}
			appConstants.initLdgMask.show();

			Ext.Ajax.request({
					url:urlforAjax,
					params: finalParams, //'../servlet/com.eg.ErVMRightSizingReportC?isSubmit=true',
					scope: this,
					success: function (response) {
						var jsonText = response.responseText;
						var jsonData = Ext.decode(jsonText);
						appConstants.publicJsonData = jsonData;
						this.loadReportData(jsonData);
 					 	//this.showRSRGrid(appConstants.publicJsonData);
 					 }
				});
	},
	showRSRGrid:function(jData)
	{
		var thisController=this;
		var resultpanelobj = Ext.getCmp("resultPanel");
		resultpanelobj.removeAll();
 		var gridColumn = jData.grid.gridColumn;

		if(jData.grid.hasOwnProperty('gridData'))
		{
			Ext.getCmp("saveTool").setDisabled(false);
			Ext.getCmp("bookletTool").setDisabled(false);
			Ext.getCmp("printTool").setDisabled(false);
			Ext.getCmp("mailTool").setDisabled(false);
			Ext.getCmp("csvTool").setDisabled(false);
			var activePage=1;

			if(jData.haveSummary)
			{
				//prakash for donutLegend
				var legendSizingDonut = '<table cellspacing="0" cellpadding="0" align="left" style="width:200px">';
				var legendUtilDonut = '<table cellspacing="0" cellpadding="0" align="left">';
				var jsonData = jData.sizingDonutObj.DataSet;
				if(jsonData!=null && jsonData!=undefined && jsonData!='undefined')
				{
					for(var key in jsonData)
					{
						var dataForLegend = jsonData[key].data;
						for (var keyTemp in dataForLegend)
						{
							var dataColor = dataForLegend[keyTemp].color;
							var dataValue = dataForLegend[keyTemp].name;
							var hrefUrl = dataForLegend[keyTemp].url;
							var legendVal = dataForLegend[keyTemp].legendValue;
							if(hrefUrl!=undefined && hrefUrl.length>0)
							{
								dataValue = '<table><tr><td style="padding:2px 5px;"><div style="background-color:'+dataColor+';" class="legendCircle"></div></td><td style="width:70px!important;padding:4px 0px 4px 0px"><a href="javascript:void(0);" onclick="window.location.href=\''+hrefUrl+'\'">'+dataValue.substring(0,dataValue.lastIndexOf("-"))+'</a></td><td><a href="javascript:void(0);" onclick="window.location.href=\''+hrefUrl+'\'">'+ dataValue.substring(dataValue.lastIndexOf('-')+1,dataValue.length)+'</a></td></tr></table>';
							}
							else
							{
								dataValue = '<table><tr><td style="padding:2px 5px;"><div style="background-color:'+dataColor+';" class="legendCircle"></div></td><td style="width:70px!important;padding:4px 0px 4px 0px">'+dataValue.substring(0,dataValue.lastIndexOf("-"))+'</td><td>'+dataValue.substring(dataValue.lastIndexOf('-')+1,dataValue.length)+'</td></tr></table>';
							}
							legendSizingDonut=legendSizingDonut+'<tr><td>'+dataValue+'</td></tr>';
						}
					}
				}
				legendSizingDonut = legendSizingDonut+'</table>';
				
				jsonData = jData.utilDonutObj.DataSet;
				if(jsonData!=null && jsonData!=undefined && jsonData!='undefined')
				{
					for(var key in jsonData)
					{
						var dataForLegend = jsonData[key].data;
						for (var keyTemp in dataForLegend)
						{
							var dataColor = dataForLegend[keyTemp].color;
							var dataValue = dataForLegend[keyTemp].name;
							var hrefUrl = dataForLegend[keyTemp].url;
							var legendVal = dataForLegend[keyTemp].legendValue;
							var valueTemp = dataValue.substring(dataValue.indexOf('-')+1,dataValue.length);
							if(hrefUrl!=undefined && hrefUrl.length>0)
							{
								dataValue = '<table><tr><td style="padding:2px 5px;"><div style="background-color:'+dataColor+';" class="legendCircle"></div></td><td style="width:70px!important;padding:4px 0px 4px 0px"><a href="javascript:void(0);" onclick="window.location.href=\''+hrefUrl+'\'">'+dataValue.substring(0,dataValue.lastIndexOf("-"))+'</a></td><td><a href="javascript:void(0);" onclick="window.location.href=\''+hrefUrl+'\'">'+ dataValue.substring(dataValue.lastIndexOf('-')+1,dataValue.length)+'</a></td></tr></table>';
							}
							else
							{
								dataValue = '<table><tr><td style="padding:2px 5px;"><div style="background-color:'+dataColor+';" class="legendCircle"></div></td><td style="width:70px!important;padding:4px 0px 4px 0px">'+dataValue.substring(0,dataValue.lastIndexOf("-"))+'</td><td>'+dataValue.substring(dataValue.lastIndexOf('-')+1,dataValue.length)+'</td></tr></table>';
							}
							legendUtilDonut=legendUtilDonut+'<tr><td>'+dataValue+'</td></tr>';
						}
					}
				}
				legendUtilDonut = legendUtilDonut+'</table>';
				//
				var barHtml = '<div id="barChartId"></div>';

				var title = vmsByCPULabel;
				var er_criteriaInfo = Ext.getCmp('er_criteriaInfo').getValue();
				if(er_criteriaInfo!=null && er_criteriaInfo== "Memory Usage")
				{
					title = vmsByConfigMemoryLabel;
				}

				var sizingDonut='<table align="center" valign="middle" height="100%"><tr><td><div id="sizingDonutId" style="width:200px !important"></div></td><td>'+legendSizingDonut+'</td></tr></table>';
				var utilDonut='<table align="center" valign="middle" height="100%"><tr><td><div id="utilDonutId" style="width:200px !important"></div></td><td>'+legendUtilDonut+'</td></tr></table>';
				var donutColWidth = 0.5;
				var barColWidth = 1.0;
				var xAxisLabel = jData.barChartObj.xAxisLabel;
				var donutHeight = 200;
				var donutPadding = '0';
				var barMargin = '0 10 0 10';

				/*if(xAxisLabel!=undefined && xAxisLabel.length < 4)
				{
					donutColWidth = 0.33;
					barColWidth = 0.33;
					donutHeight = 355;
					donutPadding = '30 0 0 0';
					barMargin = '0';
				}*/
				resultpanelobj.add(
				{
					xtype:'container',
					margin:'0 0 0 10',
					columnWidth:donutColWidth,
					//border:true,
					cls:'graphSeperatorLineSquare',
					style:{
						'border-right-style':'none'
					},
					//ui:'newGraphPanel',
					height:donutHeight,
					html:sizingDonut,
				},
				{
					xtype:'container',
					margin:'0 10 0 0',
					cls:'graphSeperatorLineSquare',
					//ui:'newGraphPanel',
					columnWidth:donutColWidth,
					height:donutHeight,
					html:utilDonut,
				},
				{
					xtype:'panel',
					ui:'newGraphPanel noShadow',
					padding:'10 0 10 0',
					margin:barMargin,
					//title:'Sizing groups by Vcpus',
					title:title,
					columnWidth:barColWidth,
					height:355,
					html:barHtml,
				});
			}
			resultpanelobj.setTitle(jData.grid.gridTitle.gridTitle);
			var er_criteria = Ext.getCmp('er_criteria').getValue();
			var er_criteriaOnly = Ext.getCmp('er_criteriaOnly').getValue();
			htmlValue='';
			if(er_criteria!=null && er_criteria == 'Summary')
			{
				htmlValue = '<div style="margin:5px 5px 2px 5px;display:inline-block">';
				if(er_criteriaOnly==undefined || er_criteriaOnly=='no')
				{
					htmlValue+='<div style="background-color:'+appConstants.publicJsonData.grid.vmState.normalColor+';float:left;padding:6px;"></div><div style="float:left;padding:0px 20px 0px 5px">'+appConstants.publicJsonData.grid.vmState.normalValue+'</div>';
				}
				htmlValue+= '<div style="background-color:'+appConstants.publicJsonData.grid.vmState.criticalColor+';float:left;padding:6px;margin-left;50px;"></div><div style="float:left;padding:0px 20px 0px 5px">'+appConstants.publicJsonData.grid.vmState.criticalValue+'</div><div style="background-color:'+appConstants.publicJsonData.grid.vmState.criticalColor_over+';float:left;padding:6px;margin-left;50px;"></div><div style="float:left;">&nbsp;'+appConstants.publicJsonData.grid.vmState.criticalValue_over+'</div>';
				htmlValue+= '</div>';
			}
			else if(er_criteria == 'Undersized VMs')
			{
				if(er_criteriaOnly!=null && er_criteriaOnly=='yes')
				{
					htmlValue = '<div style="margin:5px;"><div style="background-color:'+appConstants.publicJsonData.grid.vmState.criticalColor+';float:left;padding:6px;"></div><div style="float:left;padding:0px 20px 0px 5px">'+appConstants.publicJsonData.grid.vmState.criticalValue+'</div>';
				}
				else
				{
					htmlValue = '<div style="margin:5px;"><div style="background-color:'+appConstants.publicJsonData.grid.vmState.normalColor+';float:left;padding:6px;"></div><div style="float:left;padding:0px 20px 0px 5px">'+appConstants.publicJsonData.grid.vmState.normalValue+'</div><div style="background-color:'+appConstants.publicJsonData.grid.vmState.criticalColor+';float:left;padding:6px;margin-left;50px;"></div><div style="float:left;padding:0px 20px 0px 5px">'+appConstants.publicJsonData.grid.vmState.criticalValue+'</div>';
				}
				
			}
			else if(er_criteria == 'both')
			{
				htmlValue+= '<div style="background-color:'+appConstants.publicJsonData.grid.vmState.criticalColor+';float:left;padding:6px;margin-left;50px;"></div><div style="float:left;padding:0px 20px 0px 5px">'+appConstants.publicJsonData.grid.vmState.criticalValue+'</div><div style="background-color:'+appConstants.publicJsonData.grid.vmState.criticalColor_over+';float:left;padding:6px;margin-left;50px;"></div><div style="float:left;">&nbsp;'+appConstants.publicJsonData.grid.vmState.criticalValue_over+'</div>';
			}
			else
			{
				if(er_criteriaOnly!=null && er_criteriaOnly=='yes')
				{
					htmlValue = '<div style="margin:5px;"><div style="background-color:'+appConstants.publicJsonData.grid.vmState.criticalColor_over+';float:left;padding:6px;"></div><div style="float:left;padding:0px 20px 0px 5px">'+appConstants.publicJsonData.grid.vmState.criticalValue_over+'</div>';
				}
				else
				{
					htmlValue = '<div style="margin:5px;"><div style="background-color:'+appConstants.publicJsonData.grid.vmState.normalColor+';float:left;padding:6px;"></div><div style="float:left;padding:0px 20px 0px 5px">'+appConstants.publicJsonData.grid.vmState.normalValue+'</div><div style="background-color:'+appConstants.publicJsonData.grid.vmState.criticalColor_over+';float:left;padding:6px;margin-left;50px;"></div><div style="float:left;padding:0px 20px 0px 5px">'+appConstants.publicJsonData.grid.vmState.criticalValue_over+'</div>';
				}
			}
			resultpanelobj.add({
				xtype: 'RSRreportgrid',
				dataArray :jData.grid.gridData,
 				pageLimit : gridPageSize,
				//title :'<span class="font_bold">'+jData.grid.gridTitle.gridTitle+'</span>',
				listeners:
				{
					sortchange:function(ct, column, e, t, eOpts ){
						thisController.gridColIndexParam=column.getIndex();
						thisController.gridColStateParam=column.sortState;
						this.getStore().loadPage(activePage);
				   }
				},
				dockedItems:[{
							xtype:'pagingtoolbar',
							cls:'pagingtoolbar',
							dock: 'bottom',
							displayInfo: true,
							cls:'pagingtoolbar',
							id:'rsrpaging',
							name:'rsrpaging',
							store: this.store,
							displayInfo: true,
							displayMsg: 'Displaying topics {0} - {1} of {2}',
							emptyMsg: "No topics to display",
										listeners: {
								change : function(thisd, params)
								{   
									activePage = params.currentPage;
								}
							}
						}]
 			});
			if(er_criteria!=null && (er_criteria == 'Oversized VMs' || er_criteria == 'Undersized VMs'))
			{
				Ext.getCmp('htmlValueId').hide();
			} 
			Ext.getCmp('selectionDetails').setSelectionDetailsData(jData.selectionDetails);
 			resultpanelobj.show();
			if(jData.sizingDonutObj!=undefined)
			{
				var sizingDonutGraph=jData.sizingDonutObj;
				var sizingDonutObj = {};
				sizingDonutObj = jQuery.extend(true, {}, getHighChartsBarInstance('sizingDonutId',140,200), sizingDonutObj);
				sizingDonutObj.setData(sizingDonutGraph,'','','donut');
				sizingDonutObj.drawChart();
			} 
			if(jData.utilDonutObj!=undefined)
			{
				var utilDonutGraph=jData.utilDonutObj;
				var utilDonutObj = {};
				utilDonutObj = jQuery.extend(true, {}, getHighChartsBarInstance('utilDonutId',140,200), utilDonutObj);
				utilDonutObj.setData(utilDonutGraph,'','','donut');
				utilDonutObj.drawChart();
			} 
			if(jData.barChartObj!=undefined)
			{
				var barChartObj_temp = jData.barChartObj;
				var barChartObj = {};
				barChartObj = jQuery.extend(true, {}, getHighChartsBarInstance('barChartId',jData.barChartObj.chartHeight,jData.barChartObj.chartWidth), barChartObj);
				barChartObj.setData(barChartObj_temp,'<%=currentDateFormat%>','');
				barChartObj.drawChart();
			} 
		}
		else if(jData.grid.hasOwnProperty('noVMsFound'))
		{
			Ext.getCmp("saveTool").setDisabled(true);
			Ext.getCmp("bookletTool").setDisabled(true);
			Ext.getCmp("printTool").setDisabled(true);
			Ext.getCmp("mailTool").setDisabled(true);
			Ext.getCmp("csvTool").setDisabled(true);
			//Ext.getCmp("upbutton").setDisabled(false);
			resultpanelobj.removeAll();
			 resultpanelobj.add({
						xtype: 'panel',
						ui:'newGraphPanel',
						margin:10,
						border:true,
						frame:false,
						height: 200,
						width: '100%',
					html: '<table width="100%" height="100%"><tr><td align="center" valign="middle"><div class="iconExclamation" ></div><div class="commonErrorMsgText">'+jData.grid.noVMsFound.noVMs+'</div></td></tr></table>'
					});
 		resultpanelobj.show();


		}
		else// if(jData.grid.hasOwnProperty('noMeasuresFound'))
		{
			Ext.getCmp("bookletTool").setDisabled(true);
			Ext.getCmp("saveTool").setDisabled(true);
			Ext.getCmp("printTool").setDisabled(true);
			Ext.getCmp("mailTool").setDisabled(true);
			Ext.getCmp("csvTool").setDisabled(true);
			//Ext.getCmp("upbutton").setDisabled(false);
			resultpanelobj.hide();
			this.getNomeasurepanel().doLayout();
			this.getNomeasurepanel().show();

		}
 		resultpanelobj.show();
		//this.loadReportData(jData);;

	},

	saveReportAsPDF: function () {
			 
		var dynaParam="";
		 if(appConstants.publicJsonData.hasOwnProperty('segmentCombo'))
			  dynaParam+='&er_site='+Ext.getCmp('er_segment').getValue();
		 if(appConstants.publicJsonData.hasOwnProperty('serviceCombo'))
			  dynaParam+='&er_site='+Ext.getCmp('er_service').getValue();
		 if(appConstants.publicJsonData.hasOwnProperty('zoneCombo'))
			  dynaParam+='&er_site='+Ext.getCmp('er_zone').getValue()+'&er_includezones='+Ext.getCmp('er_includezones').getValue();

			var comQuery = '';
			var er_comp_Array = new Array();  
			er_comp_Array = Ext.getCmp('er_component').getValue();
			for (var k = 0; er_comp_Array.length > k; k++) {
				comQuery += '&er_component=' + er_comp_Array[k];
			}
			 dynaParam+=comQuery+'&er_option='+Ext.getCmp('er_option').getValue()+'&er_comptype='+Ext.getCmp('er_comptype').getValue()+'&er_criteria='+Ext.getCmp('er_criteria').getValue()+'&er_criteriaInfo='+Ext.getCmp('er_criteriaInfo').getValue()+'&er_criteriaOnly='+Ext.getCmp('er_criteriaOnly').getValue();
		this.updateFormQueryString(dynaParam);
			
		var saveQString = appConstants.publicJsonData.urlFields.saveUrl+"?"+appConstants.queryString;
		//var finalparam="/final/reporter/ErHtmlToSavePdf.jsp?"+appConstants.queryString;
       if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
	  saveQString=this.getGridColSortParam(saveQString);
        appConstants.erUtils.savePDF(saveQString);
    },
	bookletQuery: function(obj)
	{
		var dynaParam="";
		if(appConstants.publicJsonData.hasOwnProperty('segmentCombo'))
			dynaParam+='&er_site='+Ext.getCmp('er_segment').getValue();
		if(appConstants.publicJsonData.hasOwnProperty('serviceCombo'))
			dynaParam+='&er_site='+Ext.getCmp('er_service').getValue();
		if(appConstants.publicJsonData.hasOwnProperty('zoneCombo'))
		  dynaParam+='&er_site='+Ext.getCmp('er_zone').getValue()+'&er_includezones='+Ext.getCmp('er_includezones').getValue();
		
		var comQuery = '';
		var er_comp_Array = new Array();  
		er_comp_Array = Ext.getCmp('er_component').getValue();
		for (var k = 0; er_comp_Array.length > k; k++) {
			comQuery += '&er_component=' + er_comp_Array[k];
		}
		dynaParam+=comQuery+'&er_option='+Ext.getCmp('er_option').getValue()+'&er_comptype='+Ext.getCmp('er_comptype').getValue()+'&er_criteria='+Ext.getCmp('er_criteria').getValue()+'&er_criteriaInfo='+Ext.getCmp('er_criteriaInfo').getValue()+'&er_criteriaOnly='+Ext.getCmp('er_criteriaOnly').getValue();
		this.updateFormQueryString(dynaParam);
		var saveQString = appConstants.publicJsonData.urlFields.saveUrl+"?"+appConstants.queryString;
		saveQString=this.getGridColSortParam(saveQString);
		saveQString = saveQString.replace('/final/reporter/ErHtmlToSavePdf.jsp?','');
		return saveQString;
	},
	bookletScheduleQuery: function(obj)
	{
		var bookletquery="";
		if(appConstants.queryString!=undefined && appConstants.queryString!='undefined')
			bookletquery+=appConstants.queryString;
		 if (appConstants.publicJsonData.hasOwnProperty('hiddenFields')) {
            var hiddenFields = appConstants.publicJsonData.hiddenFields;
            for (var hiddenField in hiddenFields) {
				if(hiddenField == 'er_rtype' || hiddenField == 'er_trgttype'||hiddenField == 'eruserid')
				{
					continue;
				}
                bookletquery += "&" + hiddenField + "=" + hiddenFields[hiddenField];
            }
        }
		return bookletquery;
	},
	bookletPreview:function()
	{
		this.printFile();
    },
	printFile: function () {
		var saveQString='';
		if(appConstants.queryString!=undefined && appConstants.queryString!='undefined')
			saveQString =appConstants.publicJsonData.urlFields.printUrl+appConstants.queryString+'&pdfprint=yes';
		else
			saveQString =appConstants.publicJsonData.urlFields.printUrl+'&pdfprint=yes';
		saveQString=this.getGridColSortParam(saveQString);
		 parent.printWindowFn(saveQString); //this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp

    },
	callCSV: function () {
	document.location = '/final/servlet/egurkha.reporter.SaveInCSVFormat';
    },
	sendMail: function () {
	var windowMail = Ext.widget('sendmail');
	windowMail.show();
    },
	expandMe: function (btn) {
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		appConstants.erUtils.expandMultiComboButton(Ext.getCmp('er_component'),Ext.getCmp('componentLabel').text,btn);
	},
getGridColSortParam:function(query)
	{
		var qindex=query.indexOf('er_sortby');
		if (qindex > -1)
		{
			var delVar;
			var qsub=query.substring(qindex+10,qindex+12);

			if (qsub=='-1')
			{
				delVar='er_sortby='+qsub;
			}
			else
			{
				delVar='er_sortby='+parseInt(qsub);
			}
			query=query.replace(delVar,'er_sortby='+this.gridColIndexParam);
		}
		else
		{
			query+='&er_sortby='+this.gridColIndexParam;
		}

		if (this.gridColStateParam=='ASC')
			this.gridColStateParam='1';
		else
			this.gridColStateParam='0';
		return query+'&orderBy='+this.gridColStateParam;
	},
	 saveFavorite: function () {
		var isValid = this.validateRSRForm();
            /* if (isValid && Ext.getCmp('er_timeline').getValue() == 'Any') {
                Ext.MessageBox.show({
                        title: appConstants.publicJsonData.displayFields.reportTitle,
                        msg: 'Chosen timeline not allowed',
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.WARNING
                    });
                isValid = false;
            } */
		if(!isValid)
			return;

		var dynaParam="";
		 if(appConstants.publicJsonData.hasOwnProperty('segmentCombo'))
			  dynaParam+='&er_site='+Ext.getCmp('er_segment').getValue();
			 if(appConstants.publicJsonData.hasOwnProperty('serviceCombo'))
				  dynaParam+='&er_site='+Ext.getCmp('er_service').getValue();
			 if(appConstants.publicJsonData.hasOwnProperty('zoneCombo'))
				  dynaParam+='&er_site='+Ext.getCmp('er_zone').getValue()+'&er_includezones='+Ext.getCmp('er_includezones').getValue();

			var comQuery = '';
			var er_comp_Array = new Array();  
			er_comp_Array = Ext.getCmp('er_component').getValue();
			for (var k = 0; er_comp_Array.length > k; k++) {
				comQuery += '&er_component=' + er_comp_Array[k];
			}
			 dynaParam+=comQuery+'&er_option='+Ext.getCmp('er_option').getValue()+'&er_comptype='+Ext.getCmp('er_comptype').getValue()+'&er_criteria='+Ext.getCmp('er_criteria').getValue()+'&er_criteriaInfo='+Ext.getCmp('er_criteriaInfo').getValue()+'&er_criteriaOnly='+Ext.getCmp('er_criteriaOnly').getValue();

		this.updateFormQueryString(dynaParam);
        var finalParams;
        var hiddenfieldQString = "";
        var er_comp_Array = new Array();
        var comQuery = "";
        var start_date = appConstants.publicJsonData.timeZone.startDate;
        var end_date = appConstants.publicJsonData.timeZone.endDate;

        if (appConstants.publicJsonData.hasOwnProperty('hiddenFields')) {
            var hiddenFields = appConstants.publicJsonData.hiddenFields;
            for (var hiddenField in hiddenFields) {
				if(hiddenField == 'er_rtype' || hiddenField == 'er_trgttype'||hiddenField == 'eruserid')
				{
					continue;
				}
                hiddenfieldQString += "&" + hiddenField + "=" + hiddenFields[hiddenField];
            }
        }

       /*  er_comp_Array = Ext.getCmp('er_component').getValue();
        for (var k = 0; er_comp_Array.length > k; k++) {
            comQuery += "&er_component=" + er_comp_Array[0];
        }  	*/

		var hiddenFields =  appConstants.publicJsonData["hiddenFields"];
		var favorite_id = hiddenFields["favorite_id"];
        finalParams = "../servlet/com.eg.ErFavoriteC?"+appConstants.queryString +  hiddenfieldQString;
        var target =  finalParams + "&isSubmit=true&cmd=client"+"&er_RmDispName="+appConstants.er_RmDispName+"&com.eg.CSRF_NONCE="+csrfToken;//&FavoriteId="+favorite_id;
		if (appConstants.formButtonId=='save')
		{
			//document.location=target+'&showWindow=no'+'&FavoriteId='+favorite_id;
			target+='&showSchWindow=no'+'&FavoriteId='+favorite_id;
			var urlNw=target.substr(0,target.indexOf("?"));
			var queryString=target.substr(target.indexOf("?")+1,target.length-1);
			var formSave = Ext.create('Ext.form.Panel');
			formSave.submit({
				url:urlNw,
				params:queryString,
				standardSubmit: true,
				method: 'POST'
			});
		}
		else
 			parent.favouriteWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
	},


	sendToschedule: function () {
		var isValid = this.validateRSRForm();
            if (isValid && Ext.getCmp('er_timeline').getValue() == 'Any') {
                Ext.MessageBox.show({
                        title: appConstants.publicJsonData.displayFields.reportTitle,
                        msg: 'Chosen timeline not allowed',
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.WARNING
                    });
                isValid = false;
            }
		if(!isValid)
			return;

 			var dynaParam="";
		 if(appConstants.publicJsonData.hasOwnProperty('segmentCombo'))
			  dynaParam+='&er_site='+Ext.getCmp('er_segment').getValue();
			 if(appConstants.publicJsonData.hasOwnProperty('serviceCombo'))
				  dynaParam+='&er_site='+Ext.getCmp('er_service').getValue();
			 if(appConstants.publicJsonData.hasOwnProperty('zoneCombo'))
				  dynaParam+='&er_site='+Ext.getCmp('er_zone').getValue()+'&er_includezones='+Ext.getCmp('er_includezones').getValue();

			
			var comQuery = '';
			var er_comp_Array = new Array();  
			er_comp_Array = Ext.getCmp('er_component').getValue();
			for (var k = 0; er_comp_Array.length > k; k++) {
				comQuery += '&er_component=' + er_comp_Array[k];
			}
			dynaParam+=comQuery+'&er_option='+Ext.getCmp('er_option').getValue()+'&er_comptype='+Ext.getCmp('er_comptype').getValue()+'&er_criteria='+Ext.getCmp('er_criteria').getValue()+'&er_criteriaInfo='+Ext.getCmp('er_criteriaInfo').getValue()+'&er_criteriaOnly='+Ext.getCmp('er_criteriaOnly').getValue();
		this.updateFormQueryString(dynaParam);
        var finalParams;
        var hiddenfieldQString = "";
      
       
        var start_date = appConstants.publicJsonData.timeZone.startDate;
        var end_date = appConstants.publicJsonData.timeZone.endDate;

        if (appConstants.publicJsonData.hasOwnProperty('hiddenFields')) {
            var hiddenFields = appConstants.publicJsonData.hiddenFields;
            for (var hiddenField in hiddenFields) {
				if(hiddenField == 'er_rtype' || hiddenField == 'er_trgttype'||hiddenField == 'eruserid')
				{
					continue;
				}
                hiddenfieldQString += "&" + hiddenField + "=" + hiddenFields[hiddenField];
            }
        }  
        finalParams = "/final/reporter/ErSaveSchedule.jsp?"+appConstants.queryString +  hiddenfieldQString;

		var target=finalParams+"&com.eg.CSRF_NONCE="+csrfToken;
		if (appConstants.formButtonId=='save')
		{
			//document.location=target+'&showSchWindow=no';
						target+='&showSchWindow=no';
			var urlNw=target.substr(0,target.indexOf("?"));
			var queryString=target.substr(target.indexOf("?")+1,target.length-1);
			var formSave = Ext.create('Ext.form.Panel');
			formSave.submit({
				url:urlNw,
				params:queryString,
				standardSubmit: true,
				method: 'POST'
			});
		}
		else
			parent.scheduleWindowFn(target);

		//Ext.widget('scheduleWindow').show();
		//Ext.select('#schWin').set({src :target});
    },
	 updateFormQueryString: function (dynaParam) {

		var startDateConverted = Ext.Date.dateFormat(Ext.getCmp('er_stdate').getValue(), mgrDateFormat);
		var endDateConverted = Ext.Date.dateFormat(Ext.getCmp('er_enddate').getValue(), mgrDateFormat);

		var jsonData = appConstants.publicJsonData;
		var timeFrom = jsonData.timeZone.hrsFrom;
        var minsFrom = jsonData.timeZone.minsFrom;
        var timeTo = jsonData.timeZone.hrsTo;
        var minsTo = jsonData.timeZone.minsTo;
		var criterionValue=Ext.getCmp('er_criteria').getValue();
		var er_criteriaInfo = Ext.getCmp('er_criteriaInfo').getValue(); 
		var reportGeneration = appConstants.publicJsonData.selectedFields.reportGeneration;
		var dynamicRangeValue=''
		//prakash
		var dynamicValue_under = jsonData.dynamicFields.max;
		var dynamicValue_over = jsonData.dynamicFields.min;
		var dynamicRangeValues = jsonData.dynamicFields.max;
		if(criterionValue!=null && criterionValue == 'Oversized VMs' && er_criteriaInfo == 'Memory Usage')
		{
			dynamicRangeValues = jsonData.dynamicFields.min;
		}
		/*var dynamicRangeValues = '';
		if(criterionValue!=null && criterionValue == 'Oversized VMs' && er_criteriaInfo == 'Memory Usage')
		{
			dynamicRangeValues = jsonData.dynamicFields.min;
		}
		else if(criterionValue == 'Undersized VMs')
		{
			dynamicRangeValues = jsonData.dynamicFields.max;
		}
		else
		{
			var dynamicValue_under = jsonData.dynamicFields.max;
			var dynamicValue_over = jsonData.dynamicFields.min;
		}*/ 

		if(isSettingsEnabled)
		{
			dynamicValue_under = Ext.getCmp('dynamicRangeId_under').getValue();
			dynamicValue_over = Ext.getCmp('dynamicRangeId_over').getValue();
			dynamicRangeValues = Ext.getCmp('dynamicRangeId').getValue();
		}	//..//
		if(!Ext.isEmpty(Ext.getCmp('dynamicRangeId') || !Ext.isEmpty(Ext.getCmp('dynamicRangeId_under'))))
		{
			if(criterionValue=='Summary' || criterionValue=='both')
			{
				dynamicRangeValue='&dynamicRangeValue_under='+dynamicValue_under;
				dynamicRangeValue+='&dynamicRangeValue_over='+dynamicValue_over;
			}
			else if(criterionValue=='Undersized VMs' || criterionValue=='Oversized VMs')
			{
				dynamicRangeValue='&dynamicRangeValue='+dynamicRangeValues;
			}
		}
		var dynamicBufferRangeValue=''
		if(!Ext.isEmpty(Ext.getCmp('dynamicBufferRangeId')))
		{
			dynamicBufferRangeValue='&dynamicBufferRangeValue='+Ext.getCmp('dynamicBufferRangeId').getValue();
		}
		if (isSettingsEnabled)
		{
			timeFrom = Ext.getCmp('timefrom').getValue();
			minsFrom = Ext.getCmp('minfrom').getValue();
			timeTo = Ext.getCmp('timeto').getValue();
			minsTo = Ext.getCmp('minto').getValue();
			reportGeneration = Ext.getCmp('reportGeneration').getValue();
		}
		var timperiodParams = "&timefrom=" + timeFrom + "&minfrom=" + minsFrom + "&timeto=" + timeTo + "&minto=" + minsTo;
        var timelineParams = "&er_timeline=" + Ext.getCmp('er_timeline').getValue() + "&startdate=" + startDateConverted + "&enddate=" + endDateConverted + "&starthr=" + Ext.getCmp('er_sthr').dataArray + "&endhr=" + Ext.getCmp('er_endhr').dataArray+"&startmin="+mgr_stmin+"&endmin="+mgr_enmin;

	    var configParams = "";
        var detailedParams = "&er_reportgenration="+reportGeneration ;

		var reportType = appConstants.publicJsonData['hiddenFields']['er_rtype'];
		var subType = appConstants.publicJsonData['hiddenFields']['er_trgttype'];

		var reportParams = "&er_trgttype="+subType+"&er_rtype="+reportType;

		//var weekendvalue = Ext.getCmp('excludeWeek').getValue();
		//configParams += "&er_excwe=" + weekendvalue;

		var eruserid="&eruserid="+appConstants.publicJsonData['hiddenFields']['eruserid'];
 		var hiddenFields = appConstants.publicJsonData['hiddenFields'];
		var from_schedule = hiddenFields["fromScheduleModify"];
		var fromFavoriteModify = hiddenFields["fromFavoriteModify"];
		var favorite_id = hiddenFields["favorite_id"];
		appConstants.queryString = "&fromScheduleModify="+from_schedule+"&fromFavoriteModify="+fromFavoriteModify;
		if(favorite_id!=undefined)
		{
			appConstants.queryString +="&id="+favorite_id;
		}
		appConstants.queryString +="&er_RmDispName="+appConstants.er_RmDispName;

		 appConstants.queryString +=reportParams+timelineParams+timperiodParams+ eruserid+	detailedParams+dynamicRangeValue+dynamicBufferRangeValue+dynaParam;
	},
	toggleForm:function(obj)
	{
		Ext.getCmp('panelinsidetoggle').show();
		var ornt = Ext.getCmp('mainform');
		if (ornt.isHidden())
		{
			ornt.show();
			Ext.getCmp('selectionDetails').hide();
		}
		else
		{
			ornt.hide();
			Ext.getCmp('selectionDetails').show();
		}
	},
	 disableTools: function () {
        Ext.getCmp("bookletTool").setDisabled(true);
        Ext.getCmp("saveTool").setDisabled(true);
        Ext.getCmp("printTool").setDisabled(true);
        Ext.getCmp("mailTool").setDisabled(true);
        Ext.getCmp("csvTool").setDisabled(true);
    },

	ser_seg_zone_ajaxService:function()
	{
		Ext.Ajax.request({
			url: '/final/reporter/ErVMRightSizingReportJSON.jsp',
			params: appConstants.queryString,
			scope: this,
			success: function (response) {
			var jsonText = response.responseText;
			var jsonData = Ext.decode(jsonText);
			appConstants.publicJsonData = jsonData;

			var componentTypeObj=Ext.getCmp('er_comptype');
			var componentObj=Ext.getCmp('er_component');
			var rawData;
				if(appConstants.publicJsonData.hasOwnProperty('componentTypeCombo'))
				{

					 rawData= appConstants.publicJsonData.componentTypeCombo;
					 componentTypeObj.getStore().clearFilter(true); 
					 componentTypeObj.getStore().loadRawData(rawData);
					 if(appConstants.publicJsonData.selectedFields.hasOwnProperty('componentTypeComboSelected'))
					 {
							selection=appConstants.publicJsonData.selectedFields.componentTypeComboSelected;
							componentTypeObj.setValue(selection);
					 }else
						 componentTypeObj.setValue(rawData[0].valueField);

					 rawData= appConstants.publicJsonData.componentCombo;
					 componentObj.getStore().clearFilter(true);
					 componentObj.getStore().loadRawData(rawData);
					 appConstants.rawDataForComponents = rawData;
					 componentObj.setValue(rawData[0].valueField);
				}
			}
		});
	},
	criteriaOnChange:function(obj)
	{
		this.setDynamicByCriteria(obj)
	},
	setDynamicByCriteria:function(obj)
	{
		var er_criteria = Ext.getCmp('er_criteria')
		var er_criteriaOnly = Ext.getCmp('er_criteriaOnly');
		er_criteriaOnly.hide();
		if(obj.id=='er_criteriaInfo')
		{
			var er_criteriaInfo = obj.getValue();
			if(er_criteriaInfo=='GPU Usage')
			{
				er_criteriaOnly.show();
				var rawData = appConstants.publicJsonData.criteriaGpuCombo;
				er_criteria.setFieldLabel(appConstants.publicJsonData.displayFields['criterionComboLabel']);
				er_criteria.getStore().loadRawData(rawData);
				if(appConstants.publicJsonData.selectedFields.hasOwnProperty('criterionGpuComboSelected'))
				{
					selection=appConstants.publicJsonData.selectedFields.criterionComboSelected;
					er_criteria.setValue(selection);
				}
				else
				{
					er_criteria.setValue(rawData[0].valueField);
				}
			}
			else
			{
				var rawData = appConstants.publicJsonData.criterionCombo;
				er_criteria.setFieldLabel(appConstants.publicJsonData.displayFields['criterionComboLabel']);
				er_criteria.getStore().loadRawData(rawData);
				 if(appConstants.publicJsonData.selectedFields.hasOwnProperty('criterionComboSelected'))
				 {
					selection=appConstants.publicJsonData.selectedFields.criterionComboSelected;
					er_criteria.setValue(selection);
				 }
				 else
				 {
					 er_criteria.setValue(rawData[0].valueField);
				 }
			}
		}
		var er_criteriaTemp = er_criteria.getValue();
		var er_criteriaInfoTemp = obj.getValue();   
		if(er_criteriaTemp == 'Summary' && er_criteriaInfoTemp!='GPU Usage')
		{
			er_criteriaOnly.setValue('no');
		}
		else if((er_criteriaTemp == 'Oversized VMs' || er_criteriaTemp == 'Undersized VMs' || er_criteriaTemp == 'both') && er_criteriaInfoTemp!='GPU Usage')
		{
			er_criteriaOnly.setValue('yes');
		}
		
		var criteriaType = er_criteria.getValue();
		if(!Ext.isEmpty(Ext.getCmp('dynamicRangeId')))
		{
			var criteriaInfoType = Ext.getCmp('er_criteriaInfo').getValue();
			Ext.getCmp("spliter_id").show();
			Ext.getCmp("dynamicRangeId").hide();
			Ext.getCmp('dynamicBufferRangeId').hide();
			Ext.getCmp("dynamicRangeId_under").hide();
			Ext.getCmp("dynamicRangeId_over").hide();
			if(criteriaType=='Undersized VMs' && criteriaInfoType=='CPU Usage')
			{
				Ext.getCmp("dynamicRangeId").setFieldLabel(vmsUndersizedVCPULabel);
				Ext.getCmp("dynamicRangeId").setValue(UndersizedMax);
				Ext.getCmp('dynamicRangeId').show();
			}
			else if(criteriaType=='Oversized VMs'&& criteriaInfoType=='Memory Usage')
			{
				Ext.getCmp("dynamicRangeId").setFieldLabel(vmsOversizedMemoryLabel);
				Ext.getCmp("dynamicRangeId").setValue(UndersizedMin);
				Ext.getCmp('dynamicRangeId').show();
			}
			else if(criteriaType=='Undersized VMs' && criteriaInfoType=='Memory Usage')
			{
				Ext.getCmp("dynamicRangeId").setFieldLabel(vmsUndersizedMemoryLabel);
				Ext.getCmp("dynamicRangeId").setValue(UndersizedMax);
				Ext.getCmp('dynamicRangeId').show();
			}
			else if (criteriaType=='Oversized VMs' && criteriaInfoType=='GPU Usage')
			{
				Ext.getCmp("dynamicRangeId").setFieldLabel(vmsOversizedGPULabel);
				Ext.getCmp("dynamicRangeId").setValue(GpuUndersizedAvg);
				Ext.getCmp('dynamicRangeId').show();
			}
			else if (criteriaType=='Undersized VMs' && criteriaInfoType=='GPU Usage')
			{
				Ext.getCmp("dynamicRangeId").setFieldLabel(vmsUndersizedGPULabel);
				Ext.getCmp("dynamicRangeId").setValue(GpuOversizedAvg);
				Ext.getCmp("dynamicBufferRangeId").setValue(GpuBufferMaxVal);
				Ext.getCmp('dynamicBufferRangeId').show();
				Ext.getCmp('dynamicRangeId').show();
			}
			else if((criteriaType=='Summary'||criteriaType=='both') && criteriaInfoType=='CPU Usage')
			{
				 Ext.getCmp("dynamicRangeId_under").setFieldLabel(vmsUndersizedVCPULabel);
				 Ext.getCmp("dynamicRangeId_under").setValue(UndersizedMax);
				 Ext.getCmp("dynamicRangeId_under").show();
			}
			else if((criteriaType=='Summary'||criteriaType=='both') && criteriaInfoType=='Memory Usage')
			{
				Ext.getCmp("dynamicRangeId_over").setFieldLabel(vmsOversizedMemoryLabel);
				Ext.getCmp("dynamicRangeId_over").setValue(UndersizedMin);
				Ext.getCmp("dynamicRangeId_over").show();
				Ext.getCmp("dynamicRangeId_under").setFieldLabel(vmsUndersizedMemoryLabel);
				Ext.getCmp("dynamicRangeId_under").setValue(UndersizedMax);
				Ext.getCmp("dynamicRangeId_under").show();
			}
			else if((criteriaType=='Summary'||criteriaType=='both') && criteriaInfoType=='GPU Usage')
			{
				Ext.getCmp("dynamicRangeId_over").setFieldLabel(vmsOversizedGPULabel);
				Ext.getCmp("dynamicRangeId_over").setValue(GpuUndersizedAvg);
				Ext.getCmp("dynamicRangeId_over").show();
				Ext.getCmp("dynamicRangeId_under").setFieldLabel(vmsUndersizedGPULabel);
				Ext.getCmp("dynamicRangeId_under").setValue(GpuOversizedAvg);
				Ext.getCmp("dynamicRangeId_under").show();
				Ext.getCmp("dynamicBufferRangeId").setValue(GpuBufferMaxVal);
				Ext.getCmp('dynamicBufferRangeId').show();

			}
			else
			{
				Ext.getCmp("spliter_id").hide();
			}
		}
		
	},
	 comptypeOnChange:function () {
 	    Ext.getCmp('resultPanel').hide();
        this.disableTools();
		var dynaParam;
		var er_comptype=Ext.getCmp('er_comptype').getValue();
		var er_option=Ext.getCmp('er_option').getValue();
		if(er_option=='Zone')
		{
			var zoneValue=Ext.getCmp('er_zone').getValue();
			dynaParam='&er_option='+Ext.getCmp('er_option').getValue()+"&er_site="+zoneValue+"&er_comptype="+er_comptype;
		}
		else if(er_option=='Segment')
		{
			var segmentValue=Ext.getCmp('er_segment').getValue();
			dynaParam='&er_option='+Ext.getCmp('er_option').getValue()+"&er_site="+segmentValue+"&er_comptype="+er_comptype;
		}
		else if(er_option=='Service')
		{
			var serviceValue=Ext.getCmp('er_service').getValue();
			dynaParam='&er_option='+Ext.getCmp('er_option').getValue()+"&er_site="+serviceValue+"&er_comptype="+er_comptype;
		}
		else
		{
			dynaParam='&er_option='+Ext.getCmp('er_option').getValue()+"&er_comptype="+er_comptype;
		}
		this.updateFormQueryString(dynaParam);
		this.ser_seg_zone_ajaxService();

	},
	 zoneOnChange:function () {
 	    Ext.getCmp('resultPanel').hide();
        this.disableTools();
		var zoneValue=Ext.getCmp('er_zone').getValue();
		var dynaParam='&er_option='+Ext.getCmp('er_option').getValue()+"&er_site="+zoneValue;
		this.updateFormQueryString(dynaParam);
		this.ser_seg_zone_ajaxService();

	},
	segmentOnChange:function () {
 	    Ext.getCmp('resultPanel').hide();
        this.disableTools();
		var segmentValue=Ext.getCmp('er_segment').getValue();
		var dynaParam='&er_option='+Ext.getCmp('er_option').getValue()+"&er_site="+segmentValue;
		this.updateFormQueryString(dynaParam);
		this.ser_seg_zone_ajaxService();

	},
	serviceOnChange:function () {
 	    Ext.getCmp('resultPanel').hide();
        this.disableTools();
		var serviceValue=Ext.getCmp('er_service').getValue();
		var dynaParam='&er_option='+Ext.getCmp('er_option').getValue()+"&er_site="+serviceValue;
		this.updateFormQueryString(dynaParam);
		this.ser_seg_zone_ajaxService();

	},
	analyzeByOnChange:function () {
 	    Ext.getCmp('resultPanel').hide();
        this.disableTools();
		var analyzeByValue=Ext.getCmp('er_option').getValue();
		var dynaParam='&er_option='+analyzeByValue;
		this.updateFormQueryString(dynaParam);
		Ext.Ajax.request({
						url: '/final/reporter/ErVMRightSizingReportJSON.jsp',
						params: appConstants.queryString,
						scope: this,
						success: function (response) {
						var jsonText = response.responseText;
						var jsonData = Ext.decode(jsonText);
						appConstants.publicJsonData = jsonData;
						var analyzByObj=Ext.getCmp('er_option');
						var segmentObj=Ext.getCmp('er_segment');
						var serviceObj=Ext.getCmp('er_service');
						var zoneObj=Ext.getCmp('er_zone');
						var subZoneObj=Ext.getCmp('er_includezones');
						var componentTypeObj=Ext.getCmp('er_comptype');
						var componentObj=Ext.getCmp('er_component');
						var rawData;
						if(analyzeByValue=='Component')
						{
							 segmentObj.hide();
							 serviceObj.hide();
							 zoneObj.hide();
							 subZoneObj.hide();
							 rawData= appConstants.publicJsonData.componentTypeCombo;
							 componentTypeObj.getStore().clearFilter(true); 
							 componentTypeObj.getStore().loadRawData(rawData);
							 componentTypeObj.setValue(rawData[0].valueField);

							rawData= appConstants.publicJsonData.componentCombo;
							componentObj.getStore().clearFilter(true); 
							componentObj.getStore().loadRawData(rawData);
							appConstants.rawDataForComponents = rawData;
							componentObj.setValue(rawData[0].valueField);
						}
						else if(analyzeByValue=='Service' && appConstants.publicJsonData.hasOwnProperty('serviceCombo'))
						{
							 segmentObj.hide();
							 zoneObj.hide();
							 subZoneObj.hide();

							 rawData= appConstants.publicJsonData.serviceCombo;
							 serviceObj.getStore().clearFilter(true);
							 serviceObj.getStore().loadRawData(rawData);
							 serviceObj.setValue(rawData[0].valueField);

							 rawData= appConstants.publicJsonData.componentTypeCombo;
							  componentTypeObj.getStore().clearFilter(true);
							 componentTypeObj.getStore().loadRawData(rawData);
							 componentTypeObj.setValue(rawData[0].valueField);

							 rawData= appConstants.publicJsonData.componentCombo;
							 componentObj.getStore().clearFilter(true);
							 componentObj.getStore().loadRawData(rawData);
								 appConstants.rawDataForComponents = rawData;
							 componentObj.setValue(rawData[0].valueField);

							 serviceObj.show();
						}
						else if(analyzeByValue=='Segment' && appConstants.publicJsonData.hasOwnProperty('segmentCombo'))
						{
							 serviceObj.hide();
							 zoneObj.hide();
							 subZoneObj.hide();

							 rawData= appConstants.publicJsonData.segmentCombo;
							 segmentObj.getStore().clearFilter(true);
							 segmentObj.getStore().loadRawData(rawData);
							 segmentObj.setValue(rawData[0].valueField);

							 rawData= appConstants.publicJsonData.componentTypeCombo;
							 componentTypeObj.getStore().clearFilter(true); 
							 componentTypeObj.getStore().loadRawData(rawData);
							 componentTypeObj.setValue(rawData[0].valueField);

							 rawData= appConstants.publicJsonData.componentCombo;
							 componentObj.getStore().clearFilter(true);
							 componentObj.getStore().loadRawData(rawData);
							 componentObj.setValue(rawData[0].valueField);

							 segmentObj.show();
						}
						else if(analyzeByValue=='Zone' && appConstants.publicJsonData.hasOwnProperty('zoneCombo'))
						{
							 serviceObj.hide();
							 segmentObj.hide();

							 rawData= appConstants.publicJsonData.zoneCombo;
							 zoneObj.getStore().clearFilter(true);
							 zoneObj.getStore().loadRawData(rawData);
							 zoneObj.setValue(rawData[0].valueField);

							 rawData= appConstants.publicJsonData.subZoneCombo;
							 subZoneObj.getStore().loadRawData(rawData);
							 subZoneObj.setValue(rawData[0].valueField);

							 rawData= appConstants.publicJsonData.componentTypeCombo;
							 componentTypeObj.getStore().clearFilter(true);
							 componentTypeObj.getStore().loadRawData(rawData);
							 componentTypeObj.setValue(rawData[0].valueField);

							 rawData= appConstants.publicJsonData.componentCombo;
							 componentObj.getStore().clearFilter(true);
							 componentObj.getStore().loadRawData(rawData);
							 componentObj.setValue(rawData[0].valueField);

							 zoneObj.show();
							 subZoneObj.show();
						}
						else
						{
							  // alert('No records found in JSON for current selection');
						}
  					}
				});
		/*if(analyzeByValue=='Component')
		{
			var	rawData=appConstants.publicJsonData['notApplicableCombo'];
			Ext.getCmp('analysisBy').getStore().loadRawData(rawData);
			Ext.getCmp('analysisBy').setValue(rawData[0].valueField);
			Ext.getCmp('multipanel').hide();
			Ext.getCmp('zone').hide();
			Ext.getCmp('subZone').hide();
		}
		}
			*/


	},

	showLoadingIcon: function () {
			appConstants.initLdgMask.show();
		},
    defaultLoading: function () {
		/*Ext.Ajax.disableCaching=false;
		Ext.Ajax.on('beforerequest', function(conn, response, opts) {
			Ext.get(document.body).mask('Loading...');
		});
		Ext.Ajax.on('requestcomplete', function(conn, response, opts) {
			Ext.get(document.body).unmask();
		});
		Ext.Ajax.on('requestexception', function(conn, response, opts) {
			Ext.get(document.body).unmask();
			if (response.timedout) {
					alert('ajax timeout exception occured...');
			}
			else
			{
				alert('server-side failure with status code ' + response.status);
			}
		});*/
        var thisController = this;
       // this.getMain().showConfigDropdown();
		this.disableTools();

		if (appConstants.er_RmDispName!= null && appConstants.er_RmDispName!= 'null' && appConstants.er_RmDispName!= 'undefined')
			this.getMain().setTitle(appConstants.er_RmDispName);
		else
        this.getMain().setTitle(appConstants.publicJsonData.displayFields.reportTitle);
        this.loadField(appConstants.publicJsonData);
		var hiddenFields = appConstants.publicJsonData.hiddenFields;
		var from_schedule = hiddenFields["fromScheduleModify"];
		var fromFavoriteModify = hiddenFields["fromFavoriteModify"];
		if ((from_schedule != null && from_schedule == "Yes") || (fromFavoriteModify != null && fromFavoriteModify == "Yes")) {
			Ext.getCmp("submit").hide();
			Ext.getCmp("save").show();
			Ext.getCmp("favoriteTool").setDisabled(true);
			Ext.getCmp("scheduleTool").setDisabled(true);
		}else{
			Ext.getCmp("submit").show();
			Ext.getCmp("save").hide();
		}
		if(!hideBackButton){
			Ext.getCmp('mainform').add(
				{
					xtype: 'hidden',
					id: 'ID',
					name: 'ID',
					value: appConstants.publicJsonData['ID']
				}
			);
		}
    },
		refreshReportData:function(){
		if(appConstants.isSubmit!=null && appConstants.isSubmit=="true")
		{
			this.loadReportData(appConstants.publicJsonData);
		}
		else
		{
			if(appConstants.isForceSubmit=='true')
			{
				appConstants.isForceSubmit='false';
				this.showResult();
			}
		}
	},
	loadReportData:function(jsonData){
		var resultPanelObj = Ext.getCmp('resultPanel');
  		var reportGeneration=appConstants.publicJsonData.selectedFields.reportGeneration;
		this.getNomeasurepanel().hide();
		this.getBackGroundPanel().hide();

		if(reportGeneration == 'background' || reportGeneration == 'background-csv'){
			var backgroundReportStatus = jsonData.displayFields.backgroundReportStatus;
 			resultPanelObj.hide();
 			 this.getBackGroundPanel().show();
			var htmlStr = '';
			if (backgroundReportStatus != 'undefined' && backgroundReportStatus == 'success') {
				var bgroundResponseTxt = jsonData.displayFields.bgroundResponseTxt;
				var bgroundReportsURL = jsonData.urlFields.bgroundReportsURL;
				var backgroundAnchor = jsonData.displayFields.backgroundAnchor;
				var sub = backgroundAnchor.substring(0, backgroundAnchor.length );
				//htmlStr = '<center><div style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:420px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconSuccess"></div><div style="margin-top:20px"><b>' + bgroundResponseTxt + '</br><a href="' + bgroundReportsURL + '">' + sub + '</a></div></div></center>';
				htmlStr = '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconSuccess"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+ bgroundResponseTxt +'.</br>'+'<a class="backgroundMsgLink" href='+ bgroundReportsURL +'>'+ sub + '</a></div></td></tr></table></td></tr></table>';
			} else if (backgroundReportStatus != 'undefined' && backgroundReportStatus == 'duplicate') {
				var bgroundResponseTxt = jsonData.displayFields.bgroundResponseTxt;
				var bgroundReportsURL = jsonData.urlFields.bgroundReportsURL;
				var backgroundAnchor = jsonData.displayFields.backgroundAnchor;
				var sub = backgroundAnchor.substring(0, backgroundAnchor.length );
				//htmlStr = '<center><div style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:420px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconExists"></div><div style="margin-top:20px"><b>' + bgroundResponseTxt + '</br><a href="' + bgroundReportsURL + '">' + sub + '</a></div></div></center>';
				htmlStr = '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconExclamation"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+ bgroundResponseTxt +'.</br>'+'<a class="backgroundMsgLink" href='+ bgroundReportsURL +'>'+ sub + '</a></div></td></tr></table></td></tr></table>';
			}
			 this.getBackGroundPanel().update(htmlStr);
 			 this.getBackGroundPanel().show();
		}
		else{
			 this.getBackGroundPanel().hide();
			 this.showRSRGrid(appConstants.publicJsonData);
		}
		appConstants.initLdgMask.hide();
	},
	validateSaveSettings :function(){
		var isSettingsOk = true;
  		   var MaxDaysInMonth = appConstants.publicJsonData['hiddenFields']['getMaxDaysInMonth'];
        var er_usertimeline = appConstants.publicJsonData['hiddenFields']['userTimeline'];
		var er_timeline=Ext.getCmp('er_timeline').getValue();
		var stDate = Ext.getCmp('er_stdate').getValue();
		var enDate = Ext.getCmp('er_enddate').getValue();
		var startHour = Ext.getCmp('er_sthr').getValue();
		var endHour = Ext.getCmp('er_endhr').getValue();
 		stDate.setHours(startHour);
 		enDate.setHours(endHour);

		if(!checkDateTime(stDate,enDate)){
			isSettingsOk = false;
		}
		if(er_usertimeline!=null && er_usertimeline != '-1'){
			var usertimelineValid = isUserTimelineLimitExceeded(er_usertimeline, MaxDaysInMonth,  stDate, enDate);
			if ( !usertimelineValid ){
				Ext.MessageBox.show({
				title: 'Operation Reports Settings',
				msg:  _invalidUserTime,
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
				isSettingsOk = false;
			}
		}
		return isSettingsOk;
	},	
	validateSettings: function () {
		var isSettingsOk = true;
        var MaxDaysInMonth = appConstants.publicJsonData['hiddenFields']['getMaxDaysInMonth'];
        var er_usertimeline = appConstants.publicJsonData['hiddenFields']['userTimeline'];

        //var reportgen = Ext.getCmp('reportGeneration').getValue();
        var er_timeline = Ext.getCmp('er_timeline').getValue();
        var stDate = Ext.getCmp('er_stdate').getValue();
        var enDate = Ext.getCmp('er_enddate').getValue();
        var startHour = Ext.getCmp('er_sthr').getValue();
        var endHour = Ext.getCmp('er_endhr').getValue();
        stDate.setHours(startHour);
        enDate.setHours(endHour);


        if (!checkDateTime(stDate, enDate)) {
            isSettingsOk = false;
        }
        if (er_usertimeline != null && er_usertimeline != '-1') {
            var usertimelineValid = isUserTimelineLimitExceeded(er_usertimeline, MaxDaysInMonth, stDate, enDate);
            if (!usertimelineValid) {
                Ext.MessageBox.show({
                    title: 'Resource Usage Settings',
                    msg: _invalidUserTime,
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.WARNING
                });
                isSettingsOk = false;
            }
        }

		var reportgenVal = appConstants.publicJsonData.selectedFields.reportGeneration;
		if (isSettingsEnabled)
		{
			reportgenVal = Ext.getCmp('reportGeneration').getValue();
		}
		if (reportgenVal != null && reportgenVal == 'foreground') {
            var limitforbg = appConstants.publicJsonData['hiddenFields']['limitforbg'];
            if (!Ext.isEmpty(limitforbg)) {
                if (!checkTimeLineForBgLimit(limitforbg, MaxDaysInMonth, stDate, enDate)) {
                    Ext.MessageBox.confirm('Confirm', appConstants.forGrdReportConfirmMsg, this.showConfirmResult, this);
                    isSettingsOk = false;
                }
            }
        } else {
            var reportName = Ext.getCmp('bgReportName').getValue();
            if (!validateTextBoxWithSpecialChars(reportName,'Attachment',true)){
				Ext.getCmp('bgReportName').focus();
                isSettingsOk = false;
			return isSettingsOk;
			}
        }
        return isSettingsOk;

    },
    showConfirmResult: function (btn) {
        if (btn == "yes") {
            var getButtonObj = Ext.getCmp('submit');
            getButtonObj.setDisabled(false);
			if(isSettingsEnabled)
			{
				Ext.get('configMod').animate({
					duration: 500,
					to: {
						y: -500
					}
				});
			}
			this.RSRFormSubmit();
        } else {
			if (!isSettingsEnabled)
			{
				this.showConfigDropdown();
			}
            var reportGenType = Ext.getCmp('reportGeneration');
            var bgreportNameObj = Ext.getCmp('bgReportName');
            reportGenType.setValue('background');
            bgreportNameObj.setValue("");
            bgreportNameObj.show();
            validateTextBoxWithSpecialChars(Ext.getCmp('bgReportName').getValue(),'Attachment',true);
            bgreportNameObj.focus(false, 1000);
			validateTextBoxWithSpecialChars(bgreportNameObj.getValue(),'Attachment',true);
        }
    },
	loadComponentCombo: function (jsonData) {
        var obj = Ext.getCmp('er_component');
        var rawData = jsonData.componentArray;
        var selection = jsonData.er_component;
        obj.getStore().loadRawData(rawData);
		appConstants.rawDataForComponents = rawData;
        obj.setValue(rawData[0].valueField);
		obj = Ext.getCmp('er_componentType');
		rawData = jsonData.componentTypeArray;
		selection = jsonData.er_componentType;
		obj.getStore().clearFilter(true);
		obj.getStore().loadRawData(rawData);
		if (!Ext.isEmpty(selection))
		{
			obj.setValue(selection);
		}
		else
		{
			obj.setValue(rawData[0].valueField);
		}
    },

    loadField: function (jsonData) {
         var isSubmitted = "false";
        if (jsonData.hasOwnProperty('isSubmit'))
            var isSubmitted = jsonData.isSubmit;
		  Ext.getCmp('er_mode').hide();

	     var rawData;
		 var obj;
		 var selection;
		 //load analyze by combo
		 if(jsonData.hasOwnProperty('analyzeByCombo'))
		 {		// alert('analyzeByCombo');
				rawData = jsonData.analyzeByCombo;
				obj = Ext.getCmp('er_option');
				obj.setFieldLabel(jsonData.displayFields['analyzeByComboLabel']);
				obj.getStore().loadRawData(rawData);
				 if(jsonData.selectedFields.hasOwnProperty('analyzeByComboSelected'))
				 {
						selection=jsonData.selectedFields.analyzeByComboSelected;
				 	    obj.setValue(selection);
				 }
				 else
				 {
						 obj.setValue(rawData[0].valueField);
				 }

		 }

		 //load segmentCombo
		 if(jsonData.hasOwnProperty('segmentCombo'))
		 {		//alert('segmentCombo');
				rawData = jsonData.segmentCombo;
				obj = Ext.getCmp('er_segment');
				obj.setFieldLabel(jsonData.displayFields['segmentComboLabel']);
				obj.getStore().clearFilter(true); 
				obj.getStore().loadRawData(rawData);
				 if(jsonData.selectedFields.hasOwnProperty('segmentComboSelected'))
				 {
						selection=jsonData.selectedFields.segmentComboSelected;
				 	    obj.setValue(selection);
				 }
				 else
				 {
						 obj.setValue(rawData[0].valueField);
				 }
				 obj.show();
		 }
		  //load serviceCombo
		 if(jsonData.hasOwnProperty('serviceCombo'))
		 {		   // alert('serviceCombo');
				rawData = jsonData.serviceCombo;
				obj = Ext.getCmp('er_service');
				obj.setFieldLabel(jsonData.displayFields['serviceComboLabel']);
				obj.getStore().clearFilter(true);
				obj.getStore().loadRawData(rawData);
				 if(jsonData.selectedFields.hasOwnProperty('serviceComboSelected'))
				 {
						selection=jsonData.selectedFields.serviceComboSelected;
				 	    obj.setValue(selection);
				 }
				 else
				 {
						 obj.setValue(rawData[0].valueField);
				 }
		 }

		  //load zoneCombo
		 if(jsonData.hasOwnProperty('zoneCombo'))
		 {		  //alert('zoneCombo');
				rawData = jsonData.zoneCombo;
				obj = Ext.getCmp('er_zone');
				obj.setFieldLabel(jsonData.displayFields['zoneComboLabel']);
				obj.getStore().clearFilter(true);
				obj.getStore().loadRawData(rawData);
				 if(jsonData.selectedFields.hasOwnProperty('zoneComboSelected'))
				 {
						selection=jsonData.selectedFields.zoneComboSelected;
				 	    obj.setValue(selection);
				 }
				 else
				 {
						 obj.setValue(rawData[0].valueField);
				 }
				 obj.show();
		 }
		   //load subZoneCombo
		 if(jsonData.hasOwnProperty('subZoneCombo'))
		 {			//alert('subZoneCombo');
				rawData = jsonData.subZoneCombo;
				obj = Ext.getCmp('er_includezones');
				obj.setFieldLabel(jsonData.displayFields['subZoneComboLabel']);
				obj.getStore().loadRawData(rawData);
				 if(jsonData.selectedFields.hasOwnProperty('subZoneComboSelected'))
				 {
						selection=jsonData.selectedFields.subZoneComboSelected;
				 	    obj.setValue(selection);
				 }
				 else
				 {
						 obj.setValue(rawData[0].valueField);
				 }
				 obj.show();
		 }

		   //load componentTypeCombo
		 if(jsonData.hasOwnProperty('componentTypeCombo'))
		 {			 // alert('componentTypeCombo');
				rawData = jsonData.componentTypeCombo;
				obj = Ext.getCmp('er_comptype');
				obj.setFieldLabel(jsonData.displayFields['componentTypeComboLabel']);
				obj.getStore().clearFilter(true);
				obj.getStore().loadRawData(rawData);
				 if(jsonData.selectedFields.hasOwnProperty('componentTypeComboSelected'))
				 {
						selection=jsonData.selectedFields.componentTypeComboSelected;
				 	    obj.setValue(selection);
				 }
				 else
				 {
						 obj.setValue(rawData[0].valueField);
				 }

		 }

		   //load componentCombo
		 if(jsonData.hasOwnProperty('componentCombo'))
		 {			   //alert('componentCombo');
				rawData = jsonData.componentCombo;
				obj = Ext.getCmp('er_component');
				appConstants.rawDataForComponents = rawData;
				//obj.setFieldLabel(jsonData.displayFields['componentComboLabel']);
				obj.getStore().loadRawData(rawData);
				 if(jsonData.selectedFields.hasOwnProperty('componentComboSelected'))
				 {
						selection=jsonData.selectedFields.componentComboSelected;
						//alert(selection);
				 	    obj.setValue(selection);
				 }
				 else
				 {
						 obj.setValue(rawData[0].valueField);
				 }
		 }
		 
		 // set default data in dynamic field
		 if(jsonData.hasOwnProperty('dynamicFields'))
		 {
			UndersizedMin = jsonData.dynamicFields['min'];
			UndersizedMax = jsonData.dynamicFields['max'];
			GpuUndersizedAvg = jsonData.dynamicFields['GpuUndersizedAvg'];
			GpuOversizedAvg = jsonData.dynamicFields['GpuOversizedAvg'];
			GpuBufferMaxVal = jsonData.dynamicFields['GpuBufferMaxVal'];
		 }
		   //load criterionCombo
		 if(jsonData.hasOwnProperty('criterionCombo'))
		 {   //alert('criterionCombo');
			rawData = jsonData.criterionCombo;
			obj = Ext.getCmp('er_criteria');
			obj.setFieldLabel(jsonData.displayFields['criterionComboLabel']);
			obj.getStore().loadRawData(rawData);
			if(jsonData.selectedFields.hasOwnProperty('criterionComboSelected'))
			 {
					selection=jsonData.selectedFields.criterionComboSelected;
					obj.setValue(selection);
					this.setDynamicByCriteria(obj);
			 }
			 else
			 {
					 obj.setValue(rawData[0].valueField);
					 this.setDynamicByCriteria(obj);
			 }
		 }

		 //load criterionInfoCombo
		 if(jsonData.hasOwnProperty('criterionInfoCombo'))
		 {
				rawData = jsonData.criterionInfoCombo;
				obj = Ext.getCmp('er_criteriaInfo');
				obj.setFieldLabel(jsonData.displayFields['criterionInfoComboLabel']);
				obj.getStore().loadRawData(rawData);
				 if(jsonData.selectedFields.hasOwnProperty('criterionInfoComboSelected'))
				 {
						selection=jsonData.selectedFields.criterionInfoComboSelected;
				 	    obj.setValue(selection);
						this.setDynamicByCriteria(obj);
				 }
				 else
				 {
						 obj.setValue(rawData[0].valueField);
						 this.setDynamicByCriteria(obj);
				 }
		 }
		 
		if(jsonData.hasOwnProperty('criteriaGpuCombo') && obj.getValue()=='GPU Usage')
		{
			rawData = jsonData.criteriaGpuCombo;
			var er_criteriaInfo = jsonData.criteriaGpuCombo;
			obj = Ext.getCmp('er_criteria');
			obj.setFieldLabel(jsonData.displayFields['criterionComboLabel']);
			obj.getStore().loadRawData(rawData);
			if(jsonData.selectedFields.hasOwnProperty('criterionGpuComboSelected'))
			{
				selection=jsonData.selectedFields.criterionComboSelected;
				obj.setValue(selection);
				this.setDynamicByCriteria(obj);
			}
			else
		    {
			    obj.setValue(rawData[0].valueField);
			    this.setDynamicByCriteria(obj);
		    }
		}
		   //load vmCombo
		 if(jsonData.hasOwnProperty('vmCombo'))
		 {
				rawData = jsonData.vmCombo;
				obj = Ext.getCmp('er_criteriaOnly');
				obj.setFieldLabel(jsonData.displayFields['vmComboLabel']);
				obj.getStore().loadRawData(rawData);
				 if(jsonData.selectedFields.hasOwnProperty('vmComboSelected'))
				 {
						selection=jsonData.selectedFields.vmComboSelected;
				 	    obj.setValue(selection);
				 }
				 else
				 {
						 obj.setValue(rawData[0].valueField);
				 }
		 }

		   if(jsonData.hasOwnProperty('grid'))
		   {	 //alert('has grid'+Ext.getCmp('resultPanel'));
		   		//Ext.getCmp('resultPanel').show();
				this.showRSRGrid(jsonData);
 		   }
		   else
		   {	 // alert('not have grid');
		   		 	Ext.getCmp('resultPanel').hide();
 		   }


		rawData = jsonData.timeZone.timelineCombo;
        var selectedTimeline = jsonData.timeZone.selectedTimeline;
        obj = Ext.getCmp('er_timeline');

        obj.getStore().loadRawData(rawData);
		if (!Ext.isEmpty(rawData)) {
            if (!Ext.isEmpty(selectedTimeline)) {
                obj.setValue(selectedTimeline);
            } else {
                obj.setValue(rawData[0].valueField);
            }
        }






		/*obj = Ext.getCmp('er_mode');
        obj.setFieldLabel(screenLabels['reporter.common.Graph']);
        obj.setValue(jsonData.selectedGraphMode);*/

		var start_hour = jsonData.timeZone.startHour;
        var end_hour = jsonData.timeZone.endHour;
        var start_date = jsonData.timeZone.startDate;
        var end_date = jsonData.timeZone.endDate;
        var startDateObj = Ext.getCmp('er_stdate');
        startDateObj.setValue(jsonData.timeZone.startDateForDisplay);
		startDateObj.dataArray = start_date;
        var startHrObj = Ext.getCmp('er_sthr');
        startHrObj.setValue(jsonData.timeZone.startHourForDisplay);
		startHrObj.dataArray = start_hour;
        var endDateObj = Ext.getCmp('er_enddate');
        endDateObj.setValue(jsonData.timeZone.endDateForDisplay);
		endDateObj.dataArray = end_date;
        var endHrObj = Ext.getCmp('er_endhr');
        endHrObj.setValue(jsonData.timeZone.endHourForDisplay);
		endHrObj.dataArray = end_hour;

		stmin =jsonData.timeZone.startMinForDisplay;
		enmin =jsonData.timeZone.endMinForDisplay;
		mgr_stmin = jsonData.timeZone.startmin;
		mgr_enmin = jsonData.timeZone.endmin;




		  updatingAppSettings();
		if(appConstants.isForceSubmit=='true')
		{
			appConstants.isForceSubmit='false';
			this.showResult();
		}
    }
});