
Ext.define('RSR.view.RSRReportGrid',{
		extend:'utilities.CustomGrid',
 		alias:'widget.RSRreportgrid',
		id:'rsrgrid',
		ui:'newGridPanel',
		margin:'10 10 10 10',
		border:true,
		frame:false,
		autoScroll: true,//vengat
		//scroll: false,
		dataArray : null,
		pageLimit: null,
		layout:
		{
			type:'fit'
		},
		//needtoFixColumn:true,
		popUpData:'noToolTip',
 		viewConfig: {
			emptyText: 'No records'
		},
		initComponent:function(){
			var colArray=new Array();
			var fieldsToStore = new Array();
			var mainColumnArray = new Array();
			var mainColumn;
 			var gridColumn = appConstants.publicJsonData.grid.gridColumn;
			if(appConstants.publicJsonData.grid.gridColumn.length>7)
				this.forceFit=false;
			else
				this.forceFit=true;
			for (var key in gridColumn)
			{
				if (gridColumn[key] instanceof Object)
				{
					var subColJsonObj=gridColumn[key];
					for(var genericColName in subColJsonObj)
					{
						var subColumnJson=subColJsonObj[genericColName];
						var subColumnArray = new Array();
						for (var k in subColumnJson)
						{
							mainColumn = subColumnJson[k];
							fieldsToStore.push(genericColName+mainColumn);
							subColumnArray.push({
								header: mainColumn,
								sortable: true,
								width:70,
								align:'center',
								dataIndex: genericColName+mainColumn,
								doSort: function(state) 
								{
									var ds = this.up('grid').store;
									var field = this.getSortParam();
									ds.sort({
										property: field,
										direction: state,
										sorterFn: function(v1, v2)
										{
											v1 = v1.get(field);
											v2 = v2.get(field);
											
											v1 = Ext.isNumber(v1) ? v1 : parseFloat(String(v1), 10);
											v1= isNaN(v1) ? 0 : v1;

											v2 = Ext.isNumber(v2) ? v2 : parseFloat(String(v2), 10);
											v2= isNaN(v2) ? 0 : v2;
											// transform v1 and v2 here
											return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
										}
									}); 
								},
								renderer :function(value, metaData, record, row, col, store, gridView)
								{
									if(value.indexOf('#')>-1)
									{
									   var valueStr = value;
									   valueStr=valueStr.substring(0,valueStr.indexOf('#'));
									   metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+valueStr.trim()+'"';
									   if (value.indexOf('yes')>-1) 
									   {
											return '<div style="padding:3px;padding:3px;height:18px;color:#FEFEFE;background:'+appConstants.publicJsonData.grid.vmState.normalColor+';">' + valueStr + '</div>';
										}
										else if (value.indexOf('yes')>-1)
										{
											return '<div style="padding:3px;height:18px;color:#FEFEFE;background:'+appConstants.publicJsonData.grid.vmState.criticalColor+';">' + valueStr + '</div>';
										}
										else
										{
											valueStr = Ext.getCmp('rsrgrid').getDecimalAlignFormat(valueStr);
											return valueStr;
										}
									   
									}
									metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+value.trim()+'"';
									value = Ext.getCmp('rsrgrid').getDecimalAlignFormat(value);
									return value;
								}
								});
						}
						mainColumnArray.push({
							header: genericColName,
							sortable: true,
							columns:subColumnArray,
							doSort: function(state) 
							{
								var ds = this.up('grid').store;
								var field = this.getSortParam();
								ds.sort({
									property: field,
									direction: state,
									sorterFn: function(v1, v2)
									{
										v1 = v1.get(field);
										v2 = v2.get(field);
										
										v1 = Ext.isNumber(v1) ? v1 : parseFloat(String(v1), 10);
										v1= isNaN(v1) ? 0 : v1;

										v2 = Ext.isNumber(v2) ? v2 : parseFloat(String(v2), 10);
										v2= isNaN(v2) ? 0 : v2;
										// transform v1 and v2 here
										return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
									}
								}); 
							}
						});
					
					}
				}
				else
				{
					var align='center';
					if (key==0 || key==1 || key==gridColumn.length-1 || key==gridColumn.length)
					{
						align='left';
					}
 					mainColumn = gridColumn[key];
 					fieldsToStore.push(mainColumn);
					mainColumnArray.push({
						header: mainColumn,
						sortable: true,
						align:align,
						dataIndex: mainColumn,
						doSort: function(state) {
							var ds = this.up('grid').store;
							var field = this.getSortParam();
							ds.sort({
								property: field,
								direction: state,
								sorterFn: function(v1, v2)
								{
									v1 = v1.get(field);
									v2 = v2.get(field);
									if(!isNaN(v1) && !isNaN(v2))
									{
									v1 = Ext.isNumber(v1) ? v1 : parseFloat(String(v1), 10);
									v1= isNaN(v1) ? 0 : v1;

									v2 = Ext.isNumber(v2) ? v2 : parseFloat(String(v2), 10);
									v2= isNaN(v2) ? 0 : v2;
									}
									else
									{
										v1 = v1.toLowerCase();
										v2 = v2.toLowerCase();
									}
									// transform v1 and v2 here
									return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
								}
							}); 
						},
						renderer :function(value, metaData, record, row, col, store, gridView)
						{
							var dataIndex = gridView.headerCt.getGridColumns()[col].dataIndex;
							if(dataIndex!=null && dataIndex == 'Remarks')
 							{
								if(value!='-' && value.indexOf('.')>-1)
								{
									value = value.substring(value.indexOf('.')+1);
								}
							}
							var toolName='';
							if(dataIndex == 'Is VM Right-sized?')
							{
								var recordData = record.data.Remarks;
								if(recordData.indexOf('.')>-1)
								{
									toolName = ' - '+recordData.substring(0,recordData.indexOf('.'));
								}
							}
							metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+value.trim()+toolName+'"';
							metaData.tdCls="iconColumn";
							if(value.indexOf(' - ')>-1)
							{
								value = value.substring(0,value.indexOf(' - '));
							}
							if (dataIndex=='Is VM Oversized?' || dataIndex.indexOf('Oversized')>-1 || dataIndex=='Is VM Right-sized?')
							{ 
								if (value.toLowerCase()=='no'||(value.toLowerCase()=='yes'&&dataIndex=='Is VM Right-sized?')) {
									return '<div style="padding:3px;height:18px;color:#FEFEFE;background:'+appConstants.publicJsonData.grid.vmState.normalColor+';">' + value + '</div>';
								} else if (value.toLowerCase()=='yes' || value.toLowerCase()=='oversized') {
									return '<div style="padding:3px;height:18px;color:#FEFEFE;background:'+appConstants.publicJsonData.grid.vmState.criticalColor_over+';">' + value + '</div>';
								} else if (value.toLowerCase()=='undersized') {
									return '<div style="padding:3px;height:18px;color:#FEFEFE;background:'+appConstants.publicJsonData.grid.vmState.criticalColor+';">' + value + '</div>';
								}
								else{
									value = Ext.getCmp('rsrgrid').getDecimalAlignFormat(value);
									return value;
								}
							}
							else if(dataIndex=='Is VM Undersized?' || dataIndex.indexOf('Undersized')>-1 || dataIndex=='Is VM Right-sized?')
							{
								if (value.toLowerCase()=='no' ||(value.toLowerCase()=='yes'&&dataIndex=='Is VM Right-sized?')) {
									return '<div style="padding:3px;height:18px;color:#FEFEFE;background:'+appConstants.publicJsonData.grid.vmState.normalColor+';">' + value + '</div>';
								} else if (value.toLowerCase()=='yes' || value.toLowerCase()=='undersized')  {
									return '<div style="padding:3px;height:18px;color:#FEFEFE;background:'+appConstants.publicJsonData.grid.vmState.criticalColor+';">' + value + '</div>';
								} else if (value.toLowerCase()=='oversized')  {
									return '<div style="padding:3px;height:18px;color:#FEFEFE;background:'+appConstants.publicJsonData.grid.vmState.criticalColor_over+';">' + value + '</div>';
								} 
								else{
									value = Ext.getCmp('rsrgrid').getDecimalAlignFormat(value);
									return value;
								}
							}
							value = Ext.getCmp('rsrgrid').getDecimalAlignFormat(value);
							return value;
						}
 					});
					if(mainColumn == 'Remarks')
					{
						mainColumnArray[mainColumnArray.length-1].minWidth=220;
						mainColumnArray[mainColumnArray.length-1].flex=2.5;
					}
					else
					{
						if(mainColumn == 'vCPUs' )
						{
							mainColumnArray[mainColumnArray.length-1].maxWidth=70;
						}
						else if(mainColumn == 'VM' )
						{
							mainColumnArray[mainColumnArray.length-1].minWidth=130;
							mainColumnArray[mainColumnArray.length-1].flex=1.5;
						}
						else if(mainColumn.indexOf('Avg Ready time')==0 || mainColumn == 'Host')
						{
							mainColumnArray[mainColumnArray.length-1].minWidth=120;
							mainColumnArray[mainColumnArray.length-1].flex=1;
						}
						else
						{
							mainColumnArray[mainColumnArray.length-1].maxWidth=135;
						}

						
					}
				}
				
			}

			this.store = Ext.create('Ext.data.Store', {
				 fields:fieldsToStore,
				proxy : {
					type : 'pagingmemory',
					reader : {
						type : 'json'
					}
				},
				pageSize:gridPageSize,
				autoLoad : true,
				data : this.dataArray,
				//remoteSort: true,
				id: 'RSRstore'
			});
			
			this.columns = mainColumnArray;
			
			this.dockedItems=[{
				xtype:'pagingtoolbar',
				cls:'newPagination',
				dock: 'bottom',
				displayInfo: true,
				id:'rsrpaging',
				name:'rsrpaging',
				pageSize:gridPageSize,
				store: this.store,
				displayInfo: true,
				displayMsg: 'Displaying topics {0} - {1} of {2}',
				emptyMsg: "No topics to display"
			},{
				xtype:'container',
				dock:'bottom',
				cls:'bgWithBorder',
				padding:4,
				id:'htmlValueId',
				//html: '<div style="margin:5px;"><div style="background-color:'+appConstants.publicJsonData.grid.vmState.normalColor+';float:left;padding:6px;"></div><div style="float:left;">&nbsp;'+appConstants.publicJsonData.grid.vmState.normalValue+'&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</div><div style="background-color:'+appConstants.publicJsonData.grid.vmState.criticalColor+';float:left;padding:6px;margin-left;50px;"></div><div style="float:left;">&nbsp;'+appConstants.publicJsonData.grid.vmState.criticalValue+'</div></div><div style="background-color:'+appConstants.publicJsonData.grid.vmState.criticalColor_over+';float:left;padding:6px;margin-left;50px;"></div><div style="float:left;">&nbsp;'+appConstants.publicJsonData.grid.vmState.criticalValue_over+'</div></div>'
				html:htmlValue,
			}
		],
		this.callParent();
	}
});
