
Ext.define('wysereport.controller.WyseController',{
	extend:'Ext.app.Controller',
	views:['Main'],
	refs:[
		{selector:'main',ref:'main'},
		{selector:'utilitiestool',ref:'utilitiestool'},
		{selector:'nomeasurepanel', ref:'nomeasurepanel'},
		{selector: 'backGroundPanel',ref: 'backGroundPanel'}
	],
	init:function(){
		this.control({
			'utilitiestool':{
				'afterrender':this.loadTools
			},
			'main':{
				'boxready':this.afterMainRender
			},
			'wysereportform':{
				'afterrender':this.fillMainFormFields
			},
			'wysereportsettings':{
				'afterrender':this.fillSettingsFields
			},
			'utilitiestool > #printTool > button':
			{
				'click':this.printFile
			},
			'utilitiestool > #saveTool > button':{
					'click': this.saveReportAsPDF
			},
			'utilitiestool > #mailTool > button':{
					'click':this.sendMail
			},
			'utilitiestool > #csvTool > button':{
					'click':this.saveCsv
			},
			'utilitiestool > #favoriteTool > button':{
					'click':this.saveFavorite
			},
			'utilitiestool > #scheduleTool > button':{
					'click':this.saveSchedule
			},
			'wysereportform combo[name="er_comptype"]':{
				'select': this.componentTypeOnChange
			},
			'wysereportform combo[name="select_group"]':{
				'select': this.analysisByOnChange
			},
			'wysereportform combo[name="select_groupName"]':{
				'select': this.hideToolPanel
			},
			'wysereportform combo[name="includeSubZone"]':{
				'select': this.hideToolPanel
			},
			'egcomponent button[id="expandSelector"]':{
				'click': this.expandMe
			},
			'wysereportsettings combo[name="er_excwe"]':{
				'select': this.weekendOnChange
			},
			'mainform button[name="save"]':{
				'click': this.goTo
			},
			'wysereportsettings combo[name="reportGeneration"]':{
				'select': this.reportGenChange
			},
			'mainform button[name="submit"]':{
				'click': this.showResult
			},
			'egcomponent trigger[id="compSearch"]':{
				'keyup':this.filterMultiselect
			},
			'mainform button[id="panelinsidetoggle"]': {
				'click': this.toggleForm
			},
		});
	},
	filterMultiselect: function (obj) {
		if (Ext.isEmpty(appConstants.erUtils))
		{
		appConstants.erUtils = Ext.widget("erutils");
		}
		appConstants.erUtils.filterComboStore(obj,Ext.getCmp('er_component'),appConstants.publicJsonData.combo.componentCombo);
 	},
	toggleForm:function(obj)
	{
		Ext.getCmp('panelinsidetoggle').show();
		var ornt = Ext.getCmp('mainform');
		if (ornt.isHidden())
		{
			ornt.show();
			Ext.getCmp('selectionDetails').hide();
		}
		else
		{
			ornt.hide();
			Ext.getCmp('selectionDetails').show();
		}
	},
	goTo: function (btn) {
		formButtonId = btn.getId();
		var hiddenFields =  appConstants.publicJsonData["hiddenFields"];
		var from_favorite = appConstants.publicJsonData["fromFavoriteModify"];
		if ((from_favorite != null && from_favorite == "Yes")) {
			this.saveFavorite(btn);
		}else{
			//document.location = '/final/servlet/com.eg.ErFavoriteC?' + queryString + '&call=json&cmd=client&FavoriteId='+favorite_id+ "&shareUsers=" + er_favorite + "&publicUsers=" + er_favorite+"&fromFavoriteModify=yes";
			this.saveSchedule(btn);
		}
    },
	hideToolPanel:function()
	{
	    Ext.getCmp('resultPanel').hide();
 		this.disableTools();
	},
	componentTypeOnChange:function(){
		this.hideToolPanel();
		var er_comptype="er_comptype="+Ext.getCmp('er_comptype').getValue();
		var select_group="&select_group=Component";
		queryString=er_comptype+select_group;
		var url='/final/reporter/ErWyseReport_Json.jsp';
		this.updateAjaxFormData(url,false);
	},
	analysisByOnChange:function(){
		this.hideToolPanel();
		var er_comptype="er_comptype="+Ext.getCmp('er_comptype').getValue();
		var select_group="&select_group="+Ext.getCmp('select_group').getValue();
		queryString=er_comptype+select_group;
		var hiddenFields = appConstants.publicJsonData.hiddenFields;
		var from_schedule = hiddenFields["fromScheduleModify"];
		var fromFavoriteModify = hiddenFields["fromFavoriteModify"];
		var favorite_id = hiddenFields["favorite_id"];
		queryString += "&fromScheduleModify="+from_schedule+"&fromFavoriteModify="+fromFavoriteModify+"&id="+favorite_id;
		var url='/final/reporter/ErWyseReport_Json.jsp';
		this.updateAjaxFormData(url,false);
	},
	 updateFormQueryString: function () {
		 var selectGroupValue=Ext.getCmp('select_group').getValue();
		 var er_comptype="er_comptype="+Ext.getCmp('er_comptype').getValue();
		 var select_group="&select_group="+selectGroupValue;
		 var select_groupName;
		 if(selectGroupValue=='Component')
		 {
				var er_comp_Array = new Array();
				var comQuery = "";
			     er_comp_Array = Ext.getCmp('er_component').getValue();
 				for (var k = 0; er_comp_Array.length > k; k++) {
					comQuery+= "&select_groupName=" + er_comp_Array[k];
				}
				select_groupName=comQuery;
		 }
		 else if(selectGroupValue=='Zone')
		 {
			   select_groupName="&select_groupName="+Ext.getCmp('select_groupName').getValue()+"&includeSubZone="+Ext.getCmp('includeSubZone').getValue();
		 }
		 else
		 {
			  select_groupName="&select_groupName="+Ext.getCmp('select_groupName').getValue();
		 }

		 var mainFormParams= er_comptype+select_group+select_groupName;


		var startDateConverted = Ext.Date.dateFormat(Ext.getCmp('er_stdate').getValue(), mgrDateFormat);
		var endDateConverted = Ext.Date.dateFormat(Ext.getCmp('er_enddate').getValue(), mgrDateFormat);

		//var timperiodParams = "&timefrom=" + Ext.getCmp('timefrom').getValue() + "&minfrom=" + Ext.getCmp('minfrom').getValue() + "&timeto=" + Ext.getCmp('timeto').getValue() + "&minto=" + Ext.getCmp('minto').getValue();
        var timelineParams = "&er_timeline=" + Ext.getCmp('er_timeline').getValue() + "&startdate=" + startDateConverted + "&enddate=" + endDateConverted + "&starthr=" + Ext.getCmp('er_sthr').dataArray + "&endhr=" + Ext.getCmp('er_endhr').dataArray+"&startmin="+mgr_stmin+"&endmin="+mgr_enmin;
 		//var timelineParams = "&er_timeline=" + Ext.getCmp('er_timeline').getValue() + "&startdate=" + Ext.getCmp('er_stdate').dataArray + "&enddate=" + Ext.getCmp('er_enddate').dataArray + "&starthr=" + Ext.getCmp('er_sthr').dataArray + "&endhr=" + Ext.getCmp('er_endhr').dataArray + "&startmin=" + mgr_stmin + "&endmin=" + mgr_enmin;
		//alert(timelineParams);
		var timperiodParams="&timefrom="+Ext.getCmp('timefrom').getValue()+"&minfrom="+Ext.getCmp('minfrom').getValue()+"&timeto="+Ext.getCmp('timeto').getValue()+"&minto="+Ext.getCmp('minto').getValue();


		var configParams="&er_excwe="+Ext.getCmp('er_excwe').getValue()+"&er_sortby=-1&er_reportgenration="+Ext.getCmp('reportGeneration').getValue();


		var hiddenfieldQString='';
		 if (appConstants.publicJsonData.hasOwnProperty('hiddenFields')) {
            var hiddenFields = appConstants.publicJsonData.hiddenFields;
            for (var hiddenField in hiddenFields) {
                hiddenfieldQString += "&" + hiddenField + "=" + hiddenFields[hiddenField];
            }
        }

		 queryString=mainFormParams+timelineParams+timperiodParams+configParams+hiddenfieldQString;
 		 queryString +="&er_RmDispName="+appConstants.er_RmDispName;

	},
	loadData:function()
	{
		this.loadComboField('componentTypeCombo','er_comptype','componentTypeComboLabel','componentTypeComboSelected',appConstants.publicJsonData);
		this.loadComboField('analysisByCombo','select_group','analysisByComboLabel','analysisByComboSelected',appConstants.publicJsonData);
		this.loadComboField('componentCombo','er_component','seg_ser_zone_compComboLabel','componentComboSelected',appConstants.publicJsonData);
		this.loadComboField('seg_ser_zoneCombo','select_groupName','seg_ser_zone_compComboLabel','seg_ser_zoneComboSelected',appConstants.publicJsonData);
		this.loadComboField('subZoneCombo','includeSubZone','subZoneComboLabel','subZoneComboSelected',appConstants.publicJsonData);

	},
	fillMainFormFields:function(){
	var hiddenFields = appConstants.publicJsonData.hiddenFields;
	var from_schedule = hiddenFields["fromScheduleModify"];
	var fromFavoriteModify = hiddenFields["fromFavoriteModify"];
	if ((from_schedule != null && from_schedule == "Yes") || (fromFavoriteModify != null && fromFavoriteModify == "Yes")) {
		Ext.getCmp("submit").hide();
		Ext.getCmp("save").show();
		Ext.getCmp("favoriteTool").setDisabled(true);
		Ext.getCmp("scheduleTool").setDisabled(true);
	}else{
		Ext.getCmp("submit").show();
		Ext.getCmp("save").hide();
	}
		this.loadData();
		//comboProperty,comoboObject,comboLabelProperty,comboSelectedProperty,globalJsonData

		Ext.getCmp('er_mode').hide();
		this.loadComboField('timelineCombo','er_timeline','reporter.common.Timeline','timelineSelected',appConstants.publicJsonData);

		var start_hour=appConstants.publicJsonData.timeZone.startHour;
		var end_hour=appConstants.publicJsonData.timeZone.endHour;
		var start_date=appConstants.publicJsonData.timeZone.startDate;
		var end_date=appConstants.publicJsonData.timeZone.endDate;

		var startDateObj=Ext.getCmp('er_stdate');
	        startDateObj.setValue(appConstants.publicJsonData.timeZone.startDateForDisplay);
	        startDateObj.dataArray = start_date;
	        var startHrObj = Ext.getCmp('er_sthr');
	        startHrObj.setValue(appConstants.publicJsonData.timeZone.startHourForDisplay);
	        startHrObj.dataArray = start_hour;
	        var endDateObj = Ext.getCmp('er_enddate');
	        endDateObj.setValue(appConstants.publicJsonData.timeZone.endDateForDisplay);
	        endDateObj.dataArray = end_date;
	        var endHrObj = Ext.getCmp('er_endhr');
	        endHrObj.setValue(appConstants.publicJsonData.timeZone.endHourForDisplay);
	        endHrObj.dataArray = end_hour;

	        stmin = appConstants.publicJsonData.timeZone.startMinForDisplay;
	        enmin = appConstants.publicJsonData.timeZone.endMinForDisplay;
	        mgr_stmin = appConstants.publicJsonData.timeZone.startmin;
	        mgr_enmin = appConstants.publicJsonData.timeZone.endmin;

			updatingAppSettings();
	},
	fillSettingsFields:function()
	{

		this.loadComboField('excludeWeekendsCombo','er_excwe','reporter.common.Exclude weekends','excludeWeekendsComboSelected',appConstants.publicJsonData);
		this.loadComboField('reportGenerationCombo','reportGeneration','reportGenerationComboLabel','reportGenerationComboSelected',appConstants.publicJsonData);

		Ext.getCmp('timeperiodLbl').setText(appConstants.publicJsonData.displayFields['reporter.common.Time period']);
		Ext.getCmp('timefrom').setValue(appConstants.publicJsonData.timeZone.hrsFrom);
		Ext.getCmp('minfrom').setValue(appConstants.publicJsonData.timeZone.minsFrom);
		Ext.getCmp('timeto').setValue(appConstants.publicJsonData.timeZone.hrsTo);
		Ext.getCmp('minto').setValue(appConstants.publicJsonData.timeZone.minsTo);

	},
	updateAjaxFormData:function(url,isFormSubmitted)
    {
 		Ext.Ajax.request(
				{
					url : url,
 					params : queryString,
					scope:this,
					async: true,
					success: function(response){
						var jsonText = response.responseText;
						var jsonData=Ext.decode(jsonText);
						appConstants.publicJsonData=jsonData;
						if(isFormSubmitted)
						{
							 this.loadReportData();
						}
						else
						{
							this.loadData();
							//this.fillSettingsFields();
						}
					}
				});
   },
	loadComboField:function(comboProperty,comoboObject,comboLabelProperty,comboSelectedProperty,parentJsonProperty){

		 var obj = Ext.getCmp(comoboObject);
 		 if(parentJsonProperty.combo.hasOwnProperty(comboProperty))
		 {
				var rawData = parentJsonProperty.combo[comboProperty];
				obj.getStore().loadRawData(rawData);
				 if(parentJsonProperty.selectedFields.hasOwnProperty(comboSelectedProperty))
				 {
						var selection=parentJsonProperty.selectedFields[comboSelectedProperty];
						obj.setValue(selection);
				 }
				 else
				 {
						 obj.setValue(rawData[0].valueField);
				 }

				 if(parentJsonProperty.displayFields.hasOwnProperty(comboLabelProperty))
				 {
					if(comoboObject=='er_component')
					{
						var componentLabelObj=Ext.getCmp('componentLabel');
						var multiSelectComboObj=Ext.getCmp('multiSelectCombo');
						componentLabelObj.setText(parentJsonProperty.displayFields[comboLabelProperty]);
						multiSelectComboObj.show();
					}
					else
					{
						obj.setFieldLabel(parentJsonProperty.displayFields[comboLabelProperty]);
						obj.show();
					}
				 }
		 }
		 else
		 {
		 		if(comoboObject=='er_component')
				{
					var multiSelectComboObj=Ext.getCmp('multiSelectCombo');
					multiSelectComboObj.hide();
				}
				else
				{
					obj.hide();;
				}
		 }
	},
	saveReportAsPDF:function(){
		var saveQString=appConstants.publicJsonData.urlFields.pdfURL;
		var s_qryString = "../reporter/ErHtmlToSavePdf.jsp?er_comptype="+Ext.getCmp('er_comptype').getValue()+"&"+saveQString;
		var erUtils =  Ext.widget('erutils');
		erUtils.savePDF(s_qryString);
	},
	printFile:function(){
		var s_qryString = appConstants.publicJsonData.urlFields.printURL+"&pdfPrint=yes";
		parent.printWindowFn(s_qryString); //this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
	},
	sendMail:function(){
		var windowMail = Ext.widget('sendmail');
		windowMail.show();
	},
	saveCsv:function(){
		window.location='../servlet/egurkha.reporter.SaveInCSVFormat';
	},
	saveSchedule:function(obj){
		var isValid = this.validateWyseForm();
		if( isValid && Ext.getCmp('er_timeline').getValue() == 'Any'){
				Ext.MessageBox.show({
				title:appConstants.publicJsonData.displayFields.reportTitle ,
				msg: 'Chosen timeline not allowed',
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
				isValid=false;
		}

		if(isValid){
		this.updateFormQueryString();
		var target="/final/reporter/ErSaveSchedule.jsp?"+queryString+"&option=data";
		if (obj.getId()=='save')
			document.location=target+'&showSchWindow=no';
		else
			parent.scheduleWindowFn(target); //this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
		}
	},
	saveFavorite:function(obj){
		var isValid = this.validateWyseForm();
		if(isValid && Ext.getCmp('er_timeline').getValue() == 'Any'){
				Ext.MessageBox.show({
				title: appConstants.publicJsonData.displayFields.reportTitle,
				msg: 'Chosen timeline not allowed',
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
			isValid=false;
		}
		if(isValid){
		this.updateFormQueryString();
		var hiddenFields =  appConstants.publicJsonData["hiddenFields"];
		var favorite_id = hiddenFields["favorite_id"];
		var target="../servlet/com.eg.ErFavoriteC?"+queryString+"&er_view=GRAPH&cmd=client"+"&er_RmDispName="+appConstants.er_RmDispName;//&FavoriteId="+favorite_id;
		if (obj.getId()=='save')
			document.location=target+'&showWindow=no'+'&FavoriteId='+favorite_id;
		else
			parent.favouriteWindowFn(target); //this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
		}
	},
	showResult:function()
	{
Ext.getCmp('resultPanel').hide();
		if(this.validateWyseForm())
			this.submitReport();
	},
	validateWyseForm: function () {
		var componentTypeObj=Ext.getCmp('er_comptype');
		var analysisByObj=Ext.getCmp('select_group');
		var seg_ser_zoneObj=Ext.getCmp('select_groupName');
		var componentObj=Ext.getCmp('er_component');

		var componentTypeCombo_jsonProperty='componentTypeCombo';
		var analysisByCombo_jsonProperty='analysisByCombo';
		var seg_ser_zoneCombo_jsonProperty='seg_ser_zoneCombo';
		var componentCombo_jsonProperty='componentCombo';

		 if(this.validateWyseField(componentTypeObj.getValue(),componentTypeObj,componentTypeCombo_jsonProperty))
		  {
			if(this.validateWyseField(analysisByObj.getValue(),analysisByObj,analysisByCombo_jsonProperty))
			  {
			  	   if (this.validateWyseField(seg_ser_zoneObj.getValue(),seg_ser_zoneObj,seg_ser_zoneCombo_jsonProperty))
				   {
					   if (this.validateWyseField(componentObj.getValue(),componentObj,componentCombo_jsonProperty))
					   {
							return true;
					   }
				   }
			  }
		  }
	},
	validateWyseField:function(objValue,obj,jsonProperty)
	{

		if(appConstants.publicJsonData.combo.hasOwnProperty(jsonProperty))
		{
		   if(objValue=='-1'||objValue=='Not Applicable'||objValue=='')
			{
				Ext.MessageBox.show({
							title: appConstants.publicJsonData.displayFields.reportTitle,
							msg: obj.getStore().getAt(0).get('displayField'),
							buttons: Ext.MessageBox.OK,
							icon: Ext.MessageBox.WARNING
						});
						return false;
			}else
			{

				return true;
			}
		}
		else
		{
			 return true;
		}
	},


	submitReport:function(){
		this.updateFormQueryString();

		//this.getEmptypanel().hide();
		this.getNomeasurepanel().hide();
		this.getBackGroundPanel().hide();

		var reportGeneration=Ext.getCmp('reportGeneration').getValue();
		if (reportGeneration == 'foreground') {
			urlforAjax='../servlet/com.eg.ErWyseReportC';
			queryString=queryString+"&option=data&isSubmit=true&responseType=json";
		} else {
			urlforAjax='../servlet/com.eg.ErStartBackGroundReportC';
            var bg_reportname = Ext.getCmp('bgReportName').getValue();
				bg_reportname=checkFileName(bg_reportname);
            queryString=queryString+"&throughSchedule=true&bg_reportname="+bg_reportname+"&isSubmit=true&responseType=json";
		}
		this.updateAjaxFormData(urlforAjax,true);
	},
	reportGenChange:function(){
		this.hideToolPanel();
		var reportGenType=Ext.getCmp('reportGeneration').getValue();
		if(reportGenType== 'background'){
			Ext.getCmp('bgReportName').setValue("");
			Ext.getCmp('bgReportName').show();
		}
		else{
			Ext.getCmp('bgReportName').hide();
		}
	},

	weekendOnChange:function(){
		var weekendvalue=Ext.getCmp('er_excwe').getValue();;
		var excludeDaysObj=Ext.getCmp('excludeDays');
		if(weekendvalue == 'Yes'){
			excludeDaysObj.show();
			excludeDaysObj.update(appConstants.publicJsonData.displayFields['reporter.common.ExcludeDays']);
		}
		else
		{
			excludeDaysObj.hide();
		}
	},

	loadTools : function(){
		this.getUtilitiestool().loadIcon(true, true, true, false, true, true, true, false, false, false);
		Ext.getCmp("favoriteTool").setDisabled(false);
		Ext.getCmp("scheduleTool").setDisabled(false);
	},
	disableTools: function(){
		Ext.getCmp("saveTool").setDisabled(true);
		Ext.getCmp("printTool").setDisabled(true);
		Ext.getCmp("mailTool").setDisabled(true);
 		Ext.getCmp("csvTool").setDisabled(true);
	},

	afterMainRender:function(){
		var thisController = this;
		Ext.EventManager.onWindowResize(function(){
			Ext.get('configMod').setStyle('left', '');
		});

		Ext.get('closeSettings').on('click',function(){
			var isSettingsOk = thisController.validateSettings();
			var getButtonObj = Ext.getCmp('submit');
			getButtonObj.setDisabled(true);
			if(isSettingsOk)
			{
				getButtonObj.setDisabled(false);
				Ext.get('configMod').animate({duration: 500,to: {y: -500}});
			}
		});
		if (appConstants.er_RmDispName!= null && appConstants.er_RmDispName!= 'null' && appConstants.er_RmDispName!= 'undefined')
			this.getMain().setTitle(appConstants.er_RmDispName);
		else
			this.getMain().setTitle(appConstants.publicJsonData.displayFields.reportTitle);
		this.refreshReportData();
	},
	validateSettings :function(){
		var isSettingsOk = true;
		var MaxDaysInMonth = appConstants.publicJsonData['hiddenFields']['getMaxDaysInMonth'];
		var er_usertimeline = appConstants.publicJsonData['hiddenFields']['userTimeline'];
		var reportgen = Ext.getCmp('reportGeneration').getValue();
		var timePeriodFromHrs = Ext.getCmp('timefrom').getValue();
		var timePeriodFromMins = Ext.getCmp('minfrom').getValue();
		var timePeriodToHrs = Ext.getCmp('timeto').getValue();
		var timePeriodToMins = Ext.getCmp('minto').getValue();
		var er_timeline = Ext.getCmp('er_timeline').getValue();
		var stDate = Ext.getCmp('er_stdate').getValue();
		var enDate = Ext.getCmp('er_enddate').getValue();
		var startHour = Ext.getCmp('er_sthr').getValue();
		var endHour = Ext.getCmp('er_endhr').getValue();
		stDate.setHours(startHour);
		enDate.setHours(endHour);
		if (!checkTimePeriod(timePeriodFromHrs, timePeriodFromMins, timePeriodToHrs, timePeriodToMins)) {
			isSettingsOk = false;
		}

		if (!checkDateTime(stDate, enDate)) {
			isSettingsOk = false;
		}
		if (er_usertimeline != null && er_usertimeline != '-1') {
			var usertimelineValid = isUserTimelineLimitExceeded(er_usertimeline, MaxDaysInMonth, stDate, enDate);
			if (!usertimelineValid) {
				Ext.MessageBox.show({
					title: appConstants.publicJsonData.displayFields.reportTitle,
					msg: _invalidUserTime,
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
				});
				isSettingsOk = false;
			}
		}
		if (reportgen != null && reportgen == 'foreground') {
			var limitforbg = appConstants.publicJsonData['hiddenFields']['limitforbg'];
			if (!Ext.isEmpty(limitforbg)) {
				if (!checkTimeLineForBgLimit(limitforbg, MaxDaysInMonth, stDate, enDate)) {
					Ext.MessageBox.confirm('Confirm', appConstants.forGrdReportConfirmMsg, this.showConfirmResult, this);
					isSettingsOk = false;
				}
			}
		} else {
			var reportName = Ext.getCmp('bgReportName').getValue();
			if (!validateTextBoxWithSpecialChars(reportName,'Attachment',true))
				isSettingsOk = false;
		}
		return isSettingsOk;
	},
	refreshReportData:function(){
		if(appConstants.isSubmit!=null && appConstants.isSubmit=="true")
		{
			initLdgMask.show();
			this.loadReportData();
		}
		else
		{
			if(appConstants.isForceSubmit=='true')
			{
				appConstants.isForceSubmit='false';
				this.showResult();
			}
			else
			{
			   this.hideToolPanel();
			}
		}
	},
	loadReportData:function(){
		var resultPanelObj=Ext.getCmp('resultPanel');
		var selectionDetailsObj=Ext.getCmp('selectionDetails');
 		var reportGeneration=Ext.getCmp('reportGeneration').getValue();
 		var htmlStr = '';
		if(reportGeneration == 'foreground'){
			 this.showWyseGrid();
		}
		else
		{
			resultPanelObj.hide();
			var backgroundReportStatus=appConstants.publicJsonData.displayFields.backgroundReportStatus;
			if(backgroundReportStatus!= 'undefined' && backgroundReportStatus== 'success')
			{
				var bgroundResponseTxt=appConstants.publicJsonData.displayFields.bgroundResponseTxt;
				var bgroundReportsURL=appConstants.publicJsonData.urlFields.bgroundReportsURL;
				var backgroundAnchor=appConstants.publicJsonData.displayFields.backgroundAnchor;
				var sub = backgroundAnchor.slice(0, -3);

				htmlStr = '<center><div style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:480px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconSuccess"></div><div style="margin-top:20px"><b>'+bgroundResponseTxt+'</b></br><a class="backgroundMsgLink" href="'+bgroundReportsURL+'">'+sub+'</a></div></div></center>';
				//backgroundresultsObj.update('<span>'+bgroundResponseTxt+'</br><a href="'+bgroundReportsURL+'">'+backgroundAnchor+'</a></span>');
			}
			else if(backgroundReportStatus!= 'undefined' && backgroundReportStatus== 'duplicate')
			{
				var bgroundResponseTxt=appConstants.publicJsonData.displayFields.bgroundResponseTxt;
				var bgroundReportsURL=appConstants.publicJsonData.urlFields.bgroundReportsURL;
				var backgroundAnchor=appConstants.publicJsonData.displayFields.backgroundAnchor;
				var sub = backgroundAnchor.slice(0, -3);
				htmlStr = '<center><div style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:480px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconExists"></div><div style="margin-top:20px"><b>'+bgroundResponseTxt+'</b></br><a class="backgroundMsgLink" href="'+bgroundReportsURL+'">'+sub+'</a></div></div></center>';

			}
			else
			{
				htmlStr = '<center><div style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:480px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconExclamation"></div><div style="margin-top:20px"><b>Error In BackGround Generation</div></div></center>';
			}
			this.getBackGroundPanel().update('<div>'+htmlStr+'</div>');
 			this.getBackGroundPanel().show();
		}
	},
	showWyseGrid:function()
	{
		var resultpanelobj = Ext.getCmp("resultPanel");
		resultpanelobj.removeAll();


		var gridData = appConstants.publicJsonData.grid['gridData'];

		if(!Ext.isEmpty(gridData))
		{
			Ext.getCmp("saveTool").setDisabled(false);
			Ext.getCmp("printTool").setDisabled(false);
			Ext.getCmp("mailTool").setDisabled(false);
 			Ext.getCmp("csvTool").setDisabled(false);

			resultpanelobj.add({
				xtype: 'wysereportgrid',
				dataArray :gridData,
				pageLimit : 10,
				title :  '<span class="font_bold">'+appConstants.publicJsonData.grid.gridTitle+'</span>'
 			});
			Ext.getCmp('selectionDetails').setSelectionDetailsData(appConstants.publicJsonData.selectionDetails);
			resultpanelobj.show();
		}
		else
		{
			this.disableTools();
			resultpanelobj.hide();
 			this.getNomeasurepanel().show();
		}
	},
	expandMe:function(btn){
		if (Ext.isEmpty(appConstants.erUtils))
		{
		appConstants.erUtils = Ext.widget("erutils");
		}
		appConstants.erUtils.expandMultiComboButton(Ext.getCmp('er_component'),Ext.getCmp('componentLabel').text,btn);
	}
});

