
Ext.define('wysereport.view.WyseReportGrid',{
		extend:'utilities.CustomGrid',
		requires:['Ext.ux.grid.FiltersFeature','Ext.ux.data.PagingMemoryProxy', 'utilities.CustomGrid'],
		alias:'widget.wysereportgrid',
		id:'wysegrid',
		cls:'newGridPanel',
		border:true,
		autoScroll: false,
		scroll: false,
		screenLabels:null,
		dataArray : null,
		pageLimit: 2,
		//height:Ext.getCmp().getViewSize().height ,
		flex:1,
		//layout:'fit',
		margin:'5 10 10 10',
		viewConfig: {
			emptyText: 'No records'
		},
		initComponent:function(){
			var filters = {
			ftype: 'filters',
			// encode and local configuration options defined previously for easier reuse
			encode: false, // json encode the filter query
			local: true,   // defaults to false (remote filtering)
			filters: [ // Filters are most naturally placed in the column definition, but can also be // added here.
				{
					dataIndex:'systemname',
					type : 'string'
				},
				{
					dataIndex:'user',
					type : 'string'

				},
				{
					dataIndex:'description',
					type : 'string'

				},
				{
					dataIndex:'serialnumber',
					type : 'string'

				},
				{
					dataIndex:'ipaddress',
					type : 'string'

				},
				{
					dataIndex:'macs',
					type : 'string'

				},
				{
					dataIndex:'lastaccesstime',
					type : 'string'

				}
			]
			 };
			this.features= [filters];


			/*this.selModel  = new Ext.selection.CheckboxModel(
				{
					checkOnly: true,
					width:45,
					injectCheckbox: 'first'
				});	 */

			this.store = Ext.create('Ext.data.Store', {
				 fields: ['systemname','user','description','serialnumber','ipaddress','macs','lastaccesstime'],
				proxy : {
					type : 'pagingmemory',
					reader : {
						type : 'json'
					}
				},
				pageSize:this.pageLimit,
				autoLoad : true,
				data : this.dataArray,
				//remoteSort: true,
				id: 'wysestore'
			});

			this.columns = [
							{
								dataIndex:'systemname',
								header:'System name',//this.screenLabels["reporter.common.FAVORITE NAME"],
								sortable :true,
								flex:1.5,
								renderer :function(value, metaData, record, row, col, store, gridView)
								{
									return value;
								}
							},
							{
								dataIndex:'user',
								header:'User',//this.screenLabels["reporter.common.REPORT TYPE"],
								flex:1.5 ,
								sortable :true,
								renderer :function(value, metaData, record, row, col, store, gridView)
								{
										return value;
								}
							},
							{
								dataIndex:'description',
								header:'Description',//this.screenLabels["reporter.common.CREATION TIME"],
								flex:2,
								sortable :false,
								align:'center',
								renderer :function(value, metaData, record, row, col, store, gridView)
								{
									return value;
								}
							},
							{
								dataIndex:'serialnumber',
								header:'Serial number',//this.screenLabels["reporter.common.CREATION TIME"],
								flex:2,
								sortable :false,
								align:'center',
								renderer :function(value, metaData, record, row, col, store, gridView)
								{
									return value;
								}
							},
							{
								dataIndex:'ipaddress',
								header:'Ip Address',//this.screenLabels["reporter.common.CREATION TIME"],
								flex:1.2,
								sortable :false,
								align:'center',
								renderer :function(value, metaData, record, row, col, store, gridView)
								{
									return value;
								}
							},
							{
								dataIndex:'macs',
								header:'Macs',//this.screenLabels["reporter.common.CREATION TIME"],
								flex:2,
								sortable :false,
								align:'center',
								renderer :function(value, metaData, record, row, col, store, gridView)
								{
									return value;
								}
							},
							{
								dataIndex:'lastaccesstime',
								header:'Last Access Time',//this.screenLabels["reporter.common.CREATION TIME"],
								flex:2,
								sortable :false,
								align:'center',
								renderer :function(value, metaData, record, row, col, store, gridView)
								{
									return value;
								}
							}
						];

			var meGrid = this;

			this.dockedItems=[{
				xtype:'pagingtoolbar',
				cls:'newPagination',
				dock: 'bottom',
				displayInfo: true,
				id:'wysepaging',
				name:'wysepaging',
				pageSize:this.pageLimit,
				store: this.store,
				displayInfo: true,
				displayMsg: 'Displaying topics {0} - {1} of {2}',
				emptyMsg: "No topics to display"
			}/*,{
				xtype:'toolbar',
				//width:900,
				cls:'toolbar',
				items:[
				{
					xtype:'textfield',
					fieldLabel:"Search",//this.screenLabels["reporter.common.Search Favorites"],
					//labelAlign:'left',
					id :'livesearch',
					name: 'livesearch',
					labelWidth:100,
					padding:'5',
					width:320,
					dock:'top',
					enableKeyEvents: true
				}
				]
			} */
		]
			this.callParent();
	}
});
