Ext.define('EventHistoryView.controller.Main',{
	extend:'Ext.app.Controller',
	views:['Main'],
	refs:[
		{selector:'main',ref:'main'},
		{selector:'resultpanel', ref:'resultpanel'}
	],
	//requires: ['EventHistoryView.view.AlarmDetailsGrid'],

	init:function(){
		this.control({
			
			'utilitiestool':{
				'afterrender':this.loadTools
			},
			'main':{
				'boxready':this.afterMainRender
				//'beforerender':this.showLoadIcon
			}
		});
	},
	showLoadIcon:function(){
		initLdgMask.show();
	},
	
	
	loadReportData:function(jsonData){
		
		var resultPanelObj=Ext.getCmp('resultPanel');
		var selectionDetailsObj=Ext.getCmp('details');  	
		var gridData = jsonData['alarmGridValues'];
		var eventperpage=parseInt(jsonData.eventsPerPage);
		resultPanelObj.removeAll();
		resultPanelObj.getHeader().hide();
		var NO_ALRAM_TEXT="No alarms found!";
		if(gridData==''||gridData==null){
			resultPanelObj.add(
			{
				xtype: 'container',
				id:'noAletrsID',
				width: '100%',
				html: '<table width="100%" height="100%" style="height:500px;"><tr><td align="center" valign="middle"><div class="iconNoalarms" ></div><div class="commonErrorMsgText">'+NO_ALRAM_TEXT+'</div></td></tr></table>'
			});
		}
		else
		{
			resultPanelObj.add(
			{
				xtype:'alarmdetailsgrid',
				pageLimit:eventperpage,screenLabels:jsonData.gridColumnNames,dataArray:gridData}
			);
		}
 		resultPanelObj.show();
		Ext.getCmp('selectionDetails').setSelectionDetailsData(jsonData.selectionDetails);
		initLdgMask.hide();
	},
	
	afterMainRender:function()
	{
		this.getMain().setTitle(publicjsonData.reportTitle);
		if(!hideBackButton){
		Ext.getCmp('aHistory').add(
			{
				xtype: 'hidden',
				id: 'ID',
				name: 'ID',
				value: publicjsonData['ID']
			}
		);
		}	
		this.loadReportData(publicjsonData);
	}
});	