Ext.define('EventHistoryView.view.AlarmDetailsGrid',{
		extend:'utilities.CustomGrid',
		requires:['Ext.ux.grid.FiltersFeature','Ext.ux.data.PagingMemoryProxy'],
		alias:'widget.alarmdetailsgrid',
		id:'alarmDetailsGrid',
		ui:'newGridPanel',
		border:true,
		screenLabels:null,
		dataArray : null,
		pageLimit: null,
		margin:'0 10 10 10',  // margin top changed to 0 for search field top alignment - 7.1 review
		initComponent:function(){
			var filters = {
			ftype: 'filters',
			// encode and local configuration options defined previously for easier reuse
			encode: false, // json encode the filter query
			local: true,   // defaults to false (remote filtering)
			filters: [ // Filters are most naturally placed in the column definition, but can also be // added here.
				{
					dataIndex:'startTime',
					 type: 'number'
				},
				{
					dataIndex:'service',
					 type: 'string'
					
				},
				{
					dataIndex:'test',
					 type: 'string'
					
				},
				{
					dataIndex:'measureOrDesc',
					 type: 'string'
					
				},
				{
					dataIndex:'duration',
					 type: 'string'
					
				}
			]
			 };
			this.features= [filters];
			this.store = Ext.create('Ext.data.Store', {
				fields:['severity','test', 'measure', 'service', 'starttime','endtime', 'duration', 'durationInSec', 'measureOrDesc'],
				proxy : {
					type : 'pagingmemory',
					reader : {
						type : 'json'
					}
				},
				pageSize:this.pageLimit,
				autoLoad : true,
				data : this.dataArray,
				remoteSort: true,
				id: 'tmpStore'
			});
			this.columns = [
				{
					dataIndex:'severity',
					header:'',
					width:35,
					align:'left',
					sortable:false,
					hideable:false,
					menuDisabled:true,
					renderer: function(val, metaData, record, row, col, store, gridView)
					{
						metaData.tdCls="iconColumn";
						var val = '<div class="state_'+val+'" ></div>';
						return val;
					}
				},
				{
					header : !Ext.isEmpty(this.screenLabels["test"])?this.screenLabels["test"]:"Test",
					dataIndex:'test',
					align:'left',
					flex:1.5
				},
				{
					header :this.screenLabels["measureOrDesc"],
					dataIndex:'measureOrDesc',
					align:'left',
					flex:2
				},
				{
					header : !Ext.isEmpty(this.screenLabels["measure"])?this.screenLabels["measure"]:"Measure",
					dataIndex:'measure',
					align:'left',
					flex:1,
					hidden:true // bug id 15586
				},
				{
					header : !Ext.isEmpty(this.screenLabels["service"])?this.screenLabels["service"]:"Service(s)",
					dataIndex:'service',
					align:'left',
					flex:1
				},
				{
					header : !Ext.isEmpty(this.screenLabels["starttime"])?this.screenLabels["starttime"]:"Start Time",
					dataIndex:'starttime',
					align:'left',
					flex:1.5,
					doSort: function(state)
					{
						var ds = this.up('grid').store;
						var field = this.getSortParam();
						ds.sort({
							property: field,
							direction: state,
							sorterFn: function(v1, v2){
								v1 = v1.get(field);
								v2 = v2.get(field);
								if(v1.indexOf('.')>-1 && v1.indexOf(' ')>-1)
								{
									var tmp = v1.substring(0, v1.lastIndexOf(' '));

									var dateobj=new Date(Ext.Date.parse(tmp, mgrDateFormat));
									var formDate = Ext.Date.dateFormat(dateobj, getExtjsDateFormat('MMM-dd-yyyy'));
									v1 = formDate + v1.substring(v1.lastIndexOf(' '), v1.length);
								}
								if(v2.indexOf('.')>-1 && v2.indexOf(' ')>-1)
								{
									var tmp = v2.substring(0, v2.lastIndexOf(' '));

									var dateobj=new Date(Ext.Date.parse(tmp, mgrDateFormat));
									var formDate = Ext.Date.dateFormat(dateobj, getExtjsDateFormat('MMM-dd-yyyy'));
									v2 = formDate + v2.substring(v2.lastIndexOf(' '), v2.length);
								}																
								if(!isNaN(new Date(v1)) && !isNaN(new Date(v2)))
								{
									v2=new Date(v2).getTime(); 
									v1=new Date(v1).getTime(); 
								}
								return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
							}
						});
					}
				},
				{
					header : !Ext.isEmpty(this.screenLabels["starttime"])?this.screenLabels["endtime"]:"End Time",
					dataIndex:'endtime',
					align:'left',
					flex:1.5,
					doSort: function(state)
					{
						var ds = this.up('grid').store;
						var field = this.getSortParam();
						ds.sort({
							property: field,
							direction: state,
							sorterFn: function(v1, v2){
								v1 = v1.get(field);
								v2 = v2.get(field);
								if(v1.indexOf('.')>-1 && v1.indexOf(' ')>-1)
								{
									var tmp = v1.substring(0, v1.lastIndexOf(' '));

									var dateobj=new Date(Ext.Date.parse(tmp, mgrDateFormat));
									var formDate = Ext.Date.dateFormat(dateobj, getExtjsDateFormat('MMM-dd-yyyy'));
									v1 = formDate + v1.substring(v1.lastIndexOf(' '), v1.length);
								}
								if(v2.indexOf('.')>-1 && v2.indexOf(' ')>-1)
								{
									var tmp = v2.substring(0, v2.lastIndexOf(' '));

									var dateobj=new Date(Ext.Date.parse(tmp, mgrDateFormat));
									var formDate = Ext.Date.dateFormat(dateobj, getExtjsDateFormat('MMM-dd-yyyy'));
									v2 = formDate + v2.substring(v2.lastIndexOf(' '), v2.length);
								}																
								if(!isNaN(new Date(v1)) && !isNaN(new Date(v2)))
								{
									v2=new Date(v2).getTime(); 
									v1=new Date(v1).getTime(); 
								}
								return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
							}
						});
					}
				},
				{
					header : !Ext.isEmpty(this.screenLabels["duration"])?this.screenLabels["duration"]:"Duration",
					dataIndex:'duration',
					align:'left',
					width:100,
					doSort: function(state)
					{
						var ds = this.up('grid').store;
						var field = this.getSortParam();
						field = 'durationInSec';
						ds.sort({
							property: field,
							direction: state,
							sorterFn: function(v1, v2)
							{
								v1 = v1.get(field);
								v2 = v2.get(field);
								v1 = Ext.isNumber(v1) ? v1 : parseFloat(String(v1), 10);
								v1= isNaN(v1) ? 0 : v1;

								v2 = Ext.isNumber(v2) ? v2 : parseFloat(String(v2), 10);
								v2= isNaN(v2) ? 0 : v2;
								return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
							}
						});
					}
 				}
			];
			this.dockedItems=[{
				xtype:'pagingtoolbar',
				cls:'newPagination',
				dock: 'bottom',
				displayInfo: true,
				pageSize:this.pageLimit,
				store: this.store,
				displayInfo: true,
				displayMsg: 'Displaying topics {0} - {1} of {2}',
				emptyMsg: "No topics to display"
			},{
				xtype:'toolbar',
				items:[
				'->',
				{
					xtype:'customtrigger',
					labelSeparator : '',
					cls: 'whitedropdown_search',
					name: 'livesearch',
					width:240,
					padding:'0 0 15 0',
					enableKeyEvents: true
				}]
			}
		]
			this.callParent();
		}
});