Ext.define('executive.controller.Executive', {
	extend : 'Ext.app.Controller',
	views : ['Main'],
	refs : [{
				selector : 'main',
				ref : 'main'
			}, {
				selector : 'executiveForm',
				ref : 'executiveForm'
			}, {
				selector : 'executiveGraph',
				ref : 'executiveGraph'
			}, {
				selector : 'eventsoverview',
				ref : 'eventsoverview'
			}, {
				selector : 'columnchart',
				ref : 'columnchart'
			}, {
				selector : 'topevents',
				ref : 'topevents'
			}, {
				selector : 'eventsSummary',
				ref : 'eventsSummary'
			},
			{
				selector : 'newUtilities',
				ref : 'newUtilities'
			}, {
				selector : 'print',
				ref : 'print'
			}, {
				selector : 'data',
				ref : 'data'
			}, {
				selector : 'sendmail',
				ref : 'sendmail'
			}, {
				selector : 'executiveDetail',
				ref : 'executiveDetail'
			},{
				selector : 'nomeasurepanel',
				ref : 'nomeasurepanel'
			},{
				selector : 'backGroundPanel',
				ref : 'backGroundPanel'
			}],
	init : function() {

		this.control({
					'main':{
						'beforerender':this.showLoadingIcon
					},
					'main':{
						'afterrender':this.loadForm,
						'boxready':this.loadDefaultData
					},
					'newUtilities' : {
						'afterrender' : this.hideTools
					},
					'newUtilities > #saveTool > button' : {
						'click' : this.saveFileTool
					},
					'newUtilities > #mailTool > button' : {
						'click' : this.sendMail
					},
					'executiveForm button[name=submit]' : {
						'click' : this.submitForm
					},
					'executiveForm button[name=save]' : {
						'click' : this.addTo
					},
					//'executiveForm textfield[id=filter]' : {
						//'change' : this.filterStore
					//},
					'timeline combo[name="er_mode"]': {
                       'select': this.changeEr_mode
                     			},
					'newUtilities > #favoriteTool > button' : {
						'click' : this.addTo
					},
					'newUtilities > #scheduleTool > button' : {
						'click' : this.addTo
					},
					'newUtilities > #printTool > button' : {
						'click' : this.printFile
					},
					'newUtilities > #dataTool > button' : {
						'click' : this.dataFile
					 },
					'executiveForm button[id="panelinsidetoggle"]': {
						'click': this.toggleForm
					},			
					'executiveForm combo[id="reportGeneration"]':
					{
						'select': this.changeReportGenerationType
					}
					
				});
	},
	changeReportGenerationType: function()
	{
		var reportGenerationVal = Ext.getCmp('reportGeneration').getValue();
		if ( reportGenerationVal == 'background' )
		{
			Ext.getCmp('bgReportName').show();
		}
		else
		{
			Ext.getCmp('bgReportName').hide();
		}
	},
	 toggleForm:function(obj){
			Ext.getCmp('panelinsidetoggle').show();
			var ornt = Ext.getCmp('mainForm');
			if (ornt.isHidden())
			{
				ornt.show();
				Ext.getCmp('selectionDetails').hide();
			}
			else
			{
				ornt.hide();
				Ext.getCmp('selectionDetails').show();
			}
	},
	 changeEr_mode: function (combo) {
		var hiddenFields = Ext.getCmp("main").hiddenFields;
		var favorite_id = hiddenFields ["favorite_id"];
		var from_schModify = hiddenFields ["fromScheduleModify"];

		if (!(favorite_id == 'undefined' || favorite_id == undefined || favorite_id == 'emty') || !(from_schModify == null || from_schModify == 'null'))
		{
			return;
		}
		this.submitForm();
     },
	loadForm: function(thisObj){
		
		var me=thisObj;

		if(!Ext.isEmpty(appConstants.defaultJSON))
		{
			var screenLabelMap = appConstants.defaultJSON.screenLabels;
			if (appConstants.er_RmDispName!= null && appConstants.er_RmDispName!= 'null' && appConstants.er_RmDispName!= 'undefined'){
				this.getMain().setTitle(appConstants.er_RmDispName);
			}
			var mainform=this.getExecutiveForm().getForm();
			this.setValueWithOptionInList(mainform, 'reporttype', appConstants.defaultJSON.reporttypecombo, appConstants.defaultJSON.reporttypecombo_value,screenLabelMap['reportTypeComboLabel']);
            this.setValueWithOptionInList(mainform, 'er_timeline', appConstants.defaultJSON['timelineCombo'], appConstants.defaultJSON['timelineComboArray_value'], screenLabelMap['reporter.common.Timeline']);
            this.setValueWithOptionInList(mainform, 'reportGeneration', appConstants.defaultJSON['reportGenCombo'], appConstants.defaultJSON['reportGenCombo_value'], screenLabelMap['reporter.consolidated.Report Generation']);
			isTrend=true;
			
			var start_hour = appConstants.defaultJSON.selectedStartHour;
			var end_hour = appConstants.defaultJSON.selectedEndHour;
			var start_date = appConstants.defaultJSON.startDate;
			var end_date = appConstants.defaultJSON.endDate;
			var startDateObj = Ext.getCmp('er_stdate');
			startDateObj.setValue(appConstants.defaultJSON.startDateForDisplay);
			startDateObj.dataArray = start_date;
			var endDateObj = Ext.getCmp('er_enddate');
			endDateObj.setValue(appConstants.defaultJSON.endDateForDisplay);
			endDateObj.dataArray = end_date;
			var startHrObj = Ext.getCmp('er_sthr');
			startHrObj.setValue(appConstants.defaultJSON.startHourForDisplay);
			startHrObj.dataArray = start_hour;
			var endHrObj = Ext.getCmp('er_endhr');
			endHrObj.setValue(appConstants.defaultJSON.endHourForDisplay);
			endHrObj.dataArray = end_hour;
			stmin = appConstants.defaultJSON.startMinForDisplay;
			enmin = appConstants.defaultJSON.endMinForDisplay;
			mgr_stmin = appConstants.defaultJSON.startmin;
			mgr_enmin = appConstants.defaultJSON.endmin;
			me.hiddenFields = appConstants.defaultJSON.requestURL;
 		}
	},
	loadDefaultData: function(thisObj){
			
		var me=thisObj;

		if(!Ext.isEmpty(appConstants.defaultJSON))
		{
			var from_schedule = me.hiddenFields["fromScheduleModify"];
			var fromFavoriteModify = me.hiddenFields["fromFavoriteModify"];
			if ((from_schedule != null&&from_schedule == "Yes") || (fromFavoriteModify != null&&fromFavoriteModify == "Yes")) {
				Ext.getCmp("submit").hide();
				Ext.getCmp("save").show();
				Ext.getCmp("favoriteTool").setDisabled(true);
				Ext.getCmp("scheduleTool").setDisabled(true);
			}else{
				Ext.getCmp("submit").show();
				Ext.getCmp("save").hide();
			}
				if(appConstants.isSubmit!=null && appConstants.isSubmit=='true' && from_schedule==null )//&& fromFavoriteModify == null
				{
					this.submitForm();
				}else{
					if(appConstants.isForceSubmit=='true') {
						appConstants.isForceSubmit='false';
						this.submitForm();
					} 
				}
		}
		if(!hideBackButton)	{
			Ext.getCmp('mainForm').add(
				{
					xtype: 'hidden',
					id: 'ID',
					name: 'ID',
					value: appConstants.defaultJSON['ID']
				}
			);
		}
	},
	setValueWithOptionInList : function(form, fieldName, list, value,label){
		var obj =form.findField(fieldName);
		if(!Ext.isEmpty(label)){
			obj.setFieldLabel(label);
		}
		obj.getStore().clearFilter(true); 
		obj.getStore().loadRawData(list);
		obj.suspendEvents(false);
		if(Ext.isEmpty(value)){
			obj.setValue(list[0].valueField);
		}
		else
			obj.setValue(value);
		form.findField(fieldName).resumeEvents();
	},
	showLoadingIcon : function()
	{
		initLdgMask.show();
	},
	hideTools : function() {
		// by karthikeyan 
		this.getNewUtilities().loadIcon(true, true, true, true, false, true,
				true, false, false, false,true);
//
        Ext.getCmp("favoriteTool").setDisabled(false);
        Ext.getCmp("scheduleTool").setDisabled(false);
	},
	sendToFavorite : function() {

		document.location = '/final/reporter/ErSaveFavorite.jsp';
	},
	submitForm : function() {

		Ext.getCmp('panelinsidetoggle').setDisabled(false);
		var thisForm = Ext.getCmp("main").getForm();
		var hiddenFields = Ext.getCmp("main").hiddenFields;
		var reportType = thisForm.findField("reporttype").getValue();
		var er_trgttype = hiddenFields["er_trgttype"];
		if (reportType != null && reportType == '-1')
		{
				Ext.Msg.show({
                        title : 'Alert',
                        msg : 'Please select the '+er_trgttype,
                        buttons : Ext.Msg.OK
                        
                    });
				return;
		
		
		}
		if (Ext.getCmp('reportGeneration').getValue() == 'background') {
            var reportName = Ext.getCmp('bgReportName').getValue();
            var ret = validateTextBoxWithSpecialChars(reportName,'Attachment',true);
            if (!ret) {
                return;
            }
        }
        var timeline = thisForm.findField("er_timeline").getValue();
        var strthour = thisForm.findField("er_sthr").dataArray;
        var endhr = thisForm.findField("er_endhr").dataArray;
        var mode = thisForm.findField("er_mode").getValue();
        var reportgen = thisForm.findField("reportGeneration").getValue();
        var strtdt = thisForm.findField("er_stdate").dataArray;
        var enddt = thisForm.findField("er_enddate").dataArray;
		var startDate = hiddenFields["startdate"];
		var endDate = hiddenFields["enddate"];
		var eruserid = hiddenFields["eruserid"];
		//var startmin = hiddenFields["startmin"];
		mgr_stmin = appConstants.defaultJSON.startmin;
		mgr_enmin = appConstants.defaultJSON.endmin;
		var servletName = hiddenFields["servletName"];
		var savereport = hiddenFields["savereport"];
		var schedule_id = hiddenFields["schedule_id"];
		var limitforbg = hiddenFields["limitforbg"];
		// var isSubmit = thisForm.findField("isSubmit").getValue();
		var inidate =hiddenFields["inidate"];
		var fromSchedule = hiddenFields["fromSchedule"];
		var forwardto = hiddenFields["forwardto"];
		// var font = thisForm.findField("font").getValue();
		var er_trgttype = hiddenFields["er_trgttype"];
		//var reporttype = hiddenFields["reporttype"];
		var reportType = thisForm.findField("reporttype").getValue();
		var er_ViewName = hiddenFields["er_ViewName"];
		var er_view = hiddenFields["er_view"];
		var er_trenddata = hiddenFields["er_trenddata"];
		var er_search =hiddenFields["er_search"];
		var er_selection = hiddenFields["er_selection"];
		var er_specificComp = hiddenFields["er_specificComp"];//for getting specific component by ezhil
		var er_rtype = hiddenFields["er_rtype"];
		var er_bgreportfrom = hiddenFields["er_bgreportfrom"];
		//var endmin = hiddenFields["endmin"];
		var currTime = hiddenFields["currTime"];
		var bgenabled = hiddenFields["bgenabled"];
		var er_usertimeline = hiddenFields["er_usertimeline"];
		var getMaxDaysInMonth = hiddenFields["getMaxDaysInMonth"];
        var sdate = thisForm.findField("er_stdate").parseDate(strtdt);
        var eDate = thisForm.findField("er_enddate").parseDate(enddt);
		var formated_sdate = Ext.Date.dateFormat(sdate, clientDateFormat);
		var formated_edate = Ext.Date.dateFormat(eDate, clientDateFormat);
		var enddtmillisec = new Date(formated_edate).getTime();
		var strtdtmillisec = new Date(formated_sdate).getTime();
		var starttime = formatDate(new Date(getDateFromFormat(formated_sdate,appConstants.currdtFormat)),"MM/dd/yyyy");
        var endtime = formatDate(new Date(getDateFromFormat(formated_edate,appConstants.currdtFormat)),"MM/dd/yyyy");		
        var bool = checktime(starttime, endtime, strthour, endhr);
        
        if(!bool)
        {
        	Ext.Msg.show({
                        title : 'Alert',
                        msg : appConstants.sdatealert,
                        buttons : Ext.Msg.OK,
                        icon : Ext.Msg.WARNING
                    });

            return;
        }
		schedule_id = null;
		fromSchedule = null;
		var er_trgttype = hiddenFields["er_trgttype"];
		if (reportgen != null && reportgen == 'background') 
		{
			forwardto = "ErExecutiveReports";
		}
		appConstants.paramValue = "er_usertimeline=" + er_usertimeline + "&bgenabled="+bgenabled

				+ "&currTime=" + currTime + "&enddate=" + enddt
				+ "&endhr=" + endhr

				+ "&endmin=" + mgr_enmin + "&er_bgreportfrom=" + er_bgreportfrom
				+ "&er_reportgenration=" + reportgen

				+ "&er_rtype=" + er_rtype + "&er_search=" + er_search
				+ "&er_selection=" + encodeURI(reportType)
				+ "&er_specificComp=" + er_specificComp

				+ "&er_timeline=" + timeline + "&er_trenddata=" + er_trenddata
				+ "&er_view=" + er_view

				+ "&er_ViewName=" + er_ViewName + "&er_trgttype="
				+ encodeURI(er_trgttype)

				+ "&forwardto=" + forwardto + "&fromSchedule=" + fromSchedule
				+ "&inidate=" + inidate

				+ "&isSubmit=true" + "&er_mode=" + mode + "&schedule_id="
				+ schedule_id

				+ "&savereport=" + savereport + "&servletName=" + servletName
				+ "&startdate=" + strtdt

				+ "&starthr="+strthour +  "&startmin="+mgr_stmin +  "&eruserid=" + eruserid;
				    appConstants.paramValue +="&er_RmDispName="+appConstants.er_RmDispName+'&treeCompType='+appConstants.rm_treeCompType;

		var url = "";
		var loadMask = null;
		var me = this;
		if (bgenabled == 'Yes' || bgenabled == 'yes') {
			var bgtime = "";
			var getimeline = "";
			if (timeline != null && (timeline == 'Any' || timeline == 'any')) {

				bgtime = getTimeVal(limitforbg, thisForm,getMaxDaysInMonth);
                getimeline = getTimeVal(timeline, thisForm, getMaxDaysInMonth);

			} else {
				bgtime = getTimeVal(limitforbg, thisForm,getMaxDaysInMonth);
				getimeline = getTimeVal(timeline, thisForm,getMaxDaysInMonth);
			}
			
			var bgprocess = false;
			if ((appConstants.isSubmit == null || appConstants.isSubmit == 'null') && getimeline >bgtime && reportgen == 'foreground') {
					Ext.Msg.confirm('Confirm','Foreground report generation will take some time. Do you want to proceed?',function(btn){
					if(btn=="no")
					{
						thisForm.findField("reportGeneration")
								.setValue('background');
						reportgen = 'background';
						Ext.getCmp('bgReportName').show();
						validateTextBoxWithSpecialChars(Ext.getCmp('bgReportName').getValue(),'Attachment',true);
					} else {
						me.showResult();
					}
					},this);
			} else {
			me.showResult();
			}
		} else {
			me.showResult();
		}
	},
	showResult :function() {
			var thisForm = Ext.getCmp("main").getForm();
			var reportgen = thisForm.findField("reportGeneration").getValue();
			var hiddenFields = Ext.getCmp("main").hiddenFields;
			var er_usertimeline = hiddenFields["er_usertimeline"];
			var getMaxDaysInMonth = hiddenFields["getMaxDaysInMonth"];
			var eruserid = hiddenFields["eruserid"];
			var limitforbg = hiddenFields["limitforbg"];
			//by karthikeyan - for zone tree ->>report 
			if (appConstants.selectedZone != 'undefined' && appConstants.selectedZone != 'null')
			{
				 appConstants.paramValue +="&select_farm="+appConstants.selectedZone;
			}


			//
			if(appConstants.er_dataFrom!=undefined)
				appConstants.paramValue += '&er_dataFrom='+appConstants.er_dataFrom;
			if(appConstants.selectedChild!=undefined)
				appConstants.paramValue+="&selectedChild="+appConstants.selectedChild

			//
			if (reportgen != null && reportgen == 'background') 
			{
                var reportName = thisForm.findField("bgReportName").getValue();
				var errorMsg = validateTextBoxWithSpecialChars(reportName,'Attachment',true);
				if (errorMsg != true) {
					return;
				}
				var timeVal = true;
                timeVal = getTimeForcurrentuser(thisForm, thisForm, er_usertimeline, getMaxDaysInMonth);
//by karthikeyan
          var reportType = thisForm.findField("reporttype").getValue();
		  //
				if (timeVal) {
					var strreportName = "";
					if (reportType != null && reportType == 'Application')
						strreportName = "Executive_Component";
					else if (reportType != null && reportType == 'CompType')
						strreportName = "Executive_Component_Type";
					else if (reportType != null && reportType == 'Segment')
						strreportName = "Executive_Segment";
					else if (reportType != null && reportType == 'Service')
						strreportName = "Executive_Service";
					else if (reportType != null && reportType == 'Zone')
						strreportName = "Executive_Zone";
					else
						strreportName = "All Report Types";

					url = '/final/servlet/com.eg.ErStartBackGroundReportC';
					reportName=checkFileName(reportName);
					appConstants.paramValue += "&from=background&bg_reportname="
							+ reportName + "&userID=" + eruserid
							+ "&getMaxDaysInMonth=" + getMaxDaysInMonth;
							
					loadMask = new Ext.LoadMask(Ext.getBody(), {
							msg : "Background Report Generation is in Progress..."
					});
						loadMask.show();
				} else {
					return;
				}
			} else {
				loadMask = new Ext.LoadMask(Ext.getBody(), {
							msg : "Loading ..."
						});
				loadMask.show();
				var timeVal = true;

                timeVal = getTimeForcurrentuser(thisForm, thisForm, er_usertimeline, getMaxDaysInMonth);

				if (timeVal) {
					url = '/final/servlet/ErMacroController';
					appConstants.paramValue += "&from=client";
				} else {
					return;
				}
			}
			
			Ext.Ajax.request({
				url : url,
				params : appConstants.paramValue,
				scope : this,
				method : 'POST',
				success : function(response) {

					loadMask.hide();
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);
					if (reportgen != null && reportgen == 'background') {
						if (!Ext.isEmpty(jsonData)) {
							var jsnObj = jsonData.backgroundreport;
							var backgroundStatus = jsnObj['status'];
							if(backgroundStatus!=null && backgroundStatus=='success')
							{
								var htm = '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconSuccess"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+jsnObj.backgroundString+'.</br>'+'<a class="backgroundMsgLink" href='+ jsnObj.linkforBackGround +'>'+jsnObj.displayMsg+'</a></div></td></tr></table></td></tr></table>';
							}
							else if (backgroundStatus == 'duplicate')
							{
								var htm = '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconExclamation"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+jsnObj.backgroundString+'.</br>'+'<a class="backgroundMsgLink" href='+ jsnObj.linkforBackGround +'>'+jsnObj.displayMsg+'</a></div></td></tr></table></td></tr></table>';
							} 
 							this.getNomeasurepanel().hide(); 
							this.getBackGroundPanel().doLayout();
							this.getBackGroundPanel().update(htm);
							this.getBackGroundPanel().show();
							Ext.getCmp("executiveDetailPanel").hide();
						}

					} else {
						if (!Ext.isEmpty(jsonData)) {
							var errMsg = jsonData.errMsg;
							
							if (!Ext.isEmpty( errMsg.errorMsg)){
								var htm = '<div class="x-table" style="align:center"><div class="x-grid-cell-inner" style="align:center"><br/>'
										+ errMsg.errorMsg + '</div></div>'
								

								var obj = Ext.getCmp("executiveDetailPanel");
 								this.getNomeasurepanel().doLayout();
								this.getNomeasurepanel().show();
								this.getBackGroundPanel().hide();
								this.getEventsoverview().removeAll();
								Ext.getCmp("executiveDetailPanel").hide();
								this.getColumnchart().removeAll();

								this.getTopevents().removeAll();
								
								this.getEventsSummary().removeAll();
								Ext.getCmp('panelinsidetoggle').setDisabled(true);
								Ext.getCmp("saveTool").setDisabled(true);
								Ext.getCmp("bookletTool").setDisabled(true);
								Ext.getCmp("printTool").setDisabled(true);
								Ext.getCmp("mailTool").setDisabled(true);
								Ext.getCmp("dataTool").setDisabled(true);
							} else {
								Ext.getCmp('panelinsidetoggle').setDisabled(false);
								this.getBackGroundPanel().hide();
								this.getNomeasurepanel().hide();
 								Ext.getCmp("executiveDetailPanel").show();
								this.getEventsoverview().loadPieChart(jsonData);

								this.getColumnchart().loadColumnChart(jsonData);

								this.getTopevents().loadTopEventsTable(jsonData,'controller');
								
								this.getEventsSummary().loadEventsSummaryTable(jsonData, 'controller');

								Ext.getCmp("bookletTool").setDisabled(false);
								Ext.getCmp("saveTool").setDisabled(false);
								Ext.getCmp("printTool").setDisabled(false);
								Ext.getCmp("mailTool").setDisabled(false);
								Ext.getCmp("dataTool").setDisabled(false);
								Ext.getCmp('selectionDetails').setSelectionDetailsData(jsonData.selectionDetails);
						}
					}
				} 
			} 
		});
	},
	saveFileTool : function() {
		var thisForm = Ext.getCmp("main").getForm();
		var hiddenFields = Ext.getCmp("main").hiddenFields;

		var rType = hiddenFields["er_rtype"];
		var trgt =  hiddenFields["er_trgttype"];
		var selection = thisForm.findField("reporttype").getValue();

        var timeline = thisForm.findField("er_timeline").getValue();

        var starthr = thisForm.findField("er_sthr").dataArray;
        var endhr = thisForm.findField("er_endhr").dataArray;
		mgr_stmin = appConstants.defaultJSON.startmin;
		mgr_enmin = appConstants.defaultJSON.endmin;
        var mode = thisForm.findField("er_mode").getValue();
		var eruserid = hiddenFields["eruserid"];


		var strtdt = thisForm.findField("er_stdate").dataArray;
        var enddt = thisForm.findField("er_enddate").dataArray;
		var sdate = thisForm.findField("er_stdate").parseDate(strtdt);
        var enDate = thisForm.findField("er_enddate").parseDate(enddt);
		var stdate = Ext.Date.dateFormat(sdate, clientDateFormat);
		var edate = Ext.Date.dateFormat(enDate, clientDateFormat);
		var s_qryString;
       s_qryString = "/final/reporter/ErHtmlToSavePdf.jsp?er_rtype=Macro&er_rType=" + rType + "&er_trgttype=" + trgt + "&er_selection=" + encodeURI(selection) + "&er_timeline=" + timeline + "&startdate=" + strtdt + "&enddate=" + enddt + "&er_mode=" + mode + "&er_sthr="+starthr +  "&er_endhr="+ endhr +  "&is_PDF=yes&er_view=PRINT&er_userid=" +eruserid+  "&startmin="+mgr_stmin +"&endmin=" + mgr_enmin;

		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		appConstants.erUtils.savePDF(s_qryString);

	},
	bookletQuery: function(obj)
	{
		var thisForm = Ext.getCmp("main").getForm();
		var hiddenFields = Ext.getCmp("main").hiddenFields;
		var rType = hiddenFields["er_rtype"];
		var trgt =  hiddenFields["er_trgttype"];
		//var selection =  hiddenFields["er_selection"];
		var selection = thisForm.findField("reporttype").getValue();
        var timeline = thisForm.findField("er_timeline").getValue();
        var starthr = thisForm.findField("er_sthr").dataArray;
        var endhr = thisForm.findField("er_endhr").dataArray;
		mgr_stmin = appConstants.defaultJSON.startmin;
		mgr_enmin = appConstants.defaultJSON.endmin;
        var mode = thisForm.findField("er_mode").getValue();
		var eruserid = hiddenFields["eruserid"];
		var strtdt = thisForm.findField("er_stdate").dataArray;
        var enddt = thisForm.findField("er_enddate").dataArray;
		var sdate = thisForm.findField("er_stdate").parseDate(strtdt);
        var enDate = thisForm.findField("er_enddate").parseDate(enddt);
		var stdate = Ext.Date.dateFormat(sdate, clientDateFormat);
		var edate = Ext.Date.dateFormat(enDate, clientDateFormat);
		var s_qryString;
       s_qryString = "er_rtype=Macro&er_rType=" + rType + "&er_trgttype=" + trgt + "&er_selection=" + encodeURI(selection) + "&er_timeline=" + timeline + "&startdate=" + strtdt + "&enddate=" + enddt + "&er_mode=" + mode + "&er_sthr="+starthr +  "&er_endhr="+ endhr +  "&is_PDF=yes&er_view=PRINT&er_userid=" +eruserid+  "&startmin="+mgr_stmin +"&endmin=" + mgr_enmin;
		return s_qryString;
	},
	bookletScheduleQuery: function(obj)
	{
		var bookletquery="";
		var thisForm = Ext.getCmp("main").getForm();

		var reportType = thisForm.findField("reporttype").getValue();
        var timeline = thisForm.findField("er_timeline").getValue();
        var strthour = thisForm.findField("er_sthr").dataArray;
        var endhr = thisForm.findField("er_endhr").dataArray;
        var mode = thisForm.findField("er_mode").getValue();
        var reportgen = thisForm.findField("reportGeneration").getValue();
        var strtdt = thisForm.findField("er_stdate").dataArray;
        var enddt = thisForm.findField("er_enddate").dataArray;
		var hiddenFields = Ext.getCmp("main").hiddenFields;
		var startDate = hiddenFields["startdate"];
		var endDate = hiddenFields["enddate"];
		var eruserid = hiddenFields["eruserid"];
		var mgr_stmin = appConstants.defaultJSON.startmin;
		var mgr_enmin = appConstants.defaultJSON.endmin;
		var servletName = hiddenFields["servletName"];
		var savereport = hiddenFields["savereport"];
		var schedule_id = hiddenFields["schedule_id"];
		var favorite_id = hiddenFields["favorite_id"];
		var limitforbg = hiddenFields["limitforbg"];
		var inidate =hiddenFields["inidate"];
		var fromSchedule = hiddenFields["fromSchedule"];
		var forwardto = hiddenFields["forwardto"];
		var er_trgttype = hiddenFields["er_trgttype"];
		var er_ViewName = hiddenFields["er_ViewName"];
		var er_view = hiddenFields["er_view"];
		var er_trenddata = hiddenFields["er_trenddata"];
		var er_search =hiddenFields["er_search"];
		var er_selection = hiddenFields["er_selection"];
		var er_specificComp = hiddenFields["er_specificComp"];
		var er_rtype = hiddenFields["er_rtype"];
		var er_bgreportfrom = hiddenFields["er_bgreportfrom"];
		var currTime = hiddenFields["currTime"];
		var bgenabled = hiddenFields["bgenabled"];
		var er_usertimeline = hiddenFields["er_usertimeline"];
		var getMaxDaysInMonth = hiddenFields["getMaxDaysInMonth"];
		var er_favorite = hiddenFields["er_favorite"];
		var from_schedule = hiddenFields["fromScheduleModify"];
		var fromFavoriteModify = hiddenFields["fromFavoriteModify"];
		var er_trgttype =  hiddenFields["er_trgttype"];


		bookletquery+= "er_usertimeline=" + er_usertimeline + "&bgenabled="+ bgenabled+ "&currTime=" + currTime + "&enddate=" + enddt + "&endhr="+ endhr+ "&endmin=" + mgr_enmin + "&er_bgreportfrom=" + er_bgreportfrom+ "&er_reportgenration=" + reportgen+ "&er_rtype=" + er_rtype + "&er_search=" + er_search+ "&er_selection=" + encodeURI(reportType)	+ "&er_specificComp=" + er_specificComp	+ "&er_timeline=" + timeline + "&er_trenddata=" + er_trenddata+ "&er_view=" + er_view+ "&er_ViewName=" + er_ViewName + "&er_trgttype="+ encodeURI(er_trgttype)+ "&forwardto=" + forwardto + "&fromSchedule=" + fromSchedule+ "&inidate=" + inidate+ "&isSubmit=true" + "&er_mode=" + mode + "&limitforbg="+ encodeURI(limitforbg) + "&schedule_id=" + schedule_id + "&FavoriteId=" + favorite_id+ "&id=" + favorite_id+ "&savereport=" + savereport + "&servletName=" + servletName + "&shareUsers=" + er_favorite + "&publicUsers=" + er_favorite+ "&startdate=" + strtdt+ "&starthr="+ strthour+  "&startmin="+mgr_stmin + "&eruserid=" + eruserid + "&from=client&fromFavoriteModify=yes";
		return bookletquery;
	},
	bookletPreview:function()
	{
		this.printFile();
	},
	printFile : function() {
        // var s_form = Ext.getCmp("settingsForm").getForm();
			var thisForm = Ext.getCmp("main").getForm();
			

			var hiddenFields = Ext.getCmp("main").hiddenFields;

			//var reportType = hiddenFields["reporttype"];
			var reportType = thisForm.findField("reporttype").getValue();
			var er_rtype = hiddenFields["er_rtype"];
			var er_trgttype = hiddenFields["er_trgttype"];
			var er_selection = reportType;
			var timeline = thisForm.findField("er_timeline").getValue();
			var strtdt = thisForm.findField("er_stdate").dataArray;
			var enddt = thisForm.findField("er_enddate").dataArray;
			var strthour = thisForm.findField("er_sthr").dataArray;
			var endhr = thisForm.findField("er_endhr").dataArray;
			var mode = thisForm.findField("er_mode").getValue();
			mgr_stmin = appConstants.defaultJSON.startmin;
			mgr_enmin = appConstants.defaultJSON.endmin;
			var sdate = thisForm.findField("er_stdate").parseDate(strtdt);
			var eDate = thisForm.findField("er_enddate").parseDate(enddt);
			var formated_sdate = Ext.Date.dateFormat(sdate, clientDateFormat);
			var formated_edate = Ext.Date.dateFormat(eDate, clientDateFormat);
			var eruserid = hiddenFields["eruserid"];
			
		
		var s_qryString = "../servlet/com.eg.ErControllerServlet?er_rtype=Macro&er_rType="
				+ er_rtype
				+ "&er_trgttype="
				+ er_trgttype
				+ "&er_selection="
				+ encodeURI(er_selection)
				+ "&er_timeline="
				+ timeline
				+ "&startdate="
				+ strtdt
				+ "&enddate="
				+ enddt
				+ "&er_mode="
				+ mode + "&er_sthr=" + strthour + "&er_endhr=" + endhr+"&er_view=PRINT&pdfPrint=yes&er_userid="+eruserid+  "&startmin="+mgr_stmin +"&endmin=" + mgr_enmin;

				
			parent.printWindowFn(s_qryString); //this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp

	},
	sendMail : function() {
		Ext.widget('sendmail').show();
	},
	addTo : function(btn, e, val) {

// by karthikeyan
/* if (Ext.getCmp('er_timeline').getValue() == 'Any')
		{
				Ext.MessageBox.show({
					title : 'Executive Reports',
					msg : 'Chosen timeline not allowed',
					buttons : Ext.Msg.OK,
					icon: Ext.MessageBox.WARNING
				});
				return;
		} */
//
		var btnID = btn.getId();
		var formButtonId=btnID;
		//var s_form = Ext.getCmp("settingsForm").getForm();
		var thisForm = Ext.getCmp("main").getForm();

		var reportType = thisForm.findField("reporttype").getValue();
		var timeline = thisForm.findField("er_timeline").getValue();
		var strthour = thisForm.findField("er_sthr").dataArray;
		var endhr = thisForm.findField("er_endhr").dataArray;
		var mode = thisForm.findField("er_mode").getValue();
		var reportgen = thisForm.findField("reportGeneration").getValue();
		var strtdt = thisForm.findField("er_stdate").dataArray;
		var enddt = thisForm.findField("er_enddate").dataArray;


		var hiddenFields = Ext.getCmp("main").hiddenFields;


		var startDate = hiddenFields["startdate"];
		var endDate = hiddenFields["enddate"];
		var eruserid = hiddenFields["eruserid"];
		//var startmin = hiddenFields["startmin"];
		mgr_stmin = appConstants.defaultJSON.startmin;
		mgr_enmin = appConstants.defaultJSON.endmin;
		var servletName = hiddenFields["servletName"];
		var savereport = hiddenFields["savereport"];
		var schedule_id = hiddenFields["schedule_id"];
		var favorite_id = hiddenFields["favorite_id"];
		var limitforbg = hiddenFields["limitforbg"];
		// var isSubmit = thisForm.findField("isSubmit").getValue();
		var inidate =hiddenFields["inidate"];
		var fromSchedule = hiddenFields["fromSchedule"];
		var forwardto = hiddenFields["forwardto"];
		// var font = thisForm.findField("font").getValue();
		var er_trgttype = hiddenFields["er_trgttype"];
		var reportType = thisForm.findField("reporttype").getValue();
		var er_ViewName = hiddenFields["er_ViewName"];
		var er_view = hiddenFields["er_view"];
		var er_trenddata = hiddenFields["er_trenddata"];
		var er_search =hiddenFields["er_search"];
		var er_selection = hiddenFields["er_selection"];
		var er_specificComp = hiddenFields["er_specificComp"];//for getting specific component type by ezhil
		var er_rtype = hiddenFields["er_rtype"];
		var er_bgreportfrom = hiddenFields["er_bgreportfrom"];
		//var endmin = hiddenFields["endmin"];
		var currTime = hiddenFields["currTime"];
		var bgenabled = hiddenFields["bgenabled"];
		var er_usertimeline = hiddenFields["er_usertimeline"];
		var getMaxDaysInMonth = hiddenFields["getMaxDaysInMonth"];
		var er_favorite = hiddenFields["er_favorite"];
		var from_schedule = hiddenFields["fromScheduleModify"];
		var fromFavoriteModify = hiddenFields["fromFavoriteModify"];
        if (from_schedule != null && from_schedule == "Yes") {
			btnID = 'scheduleImg';
		}else if (fromFavoriteModify != null && fromFavoriteModify == "Yes")
		{
			btnID = 'favoriteImg';
		}else{
		schedule_id = null;
			favorite_id = null;
		fromSchedule = null;
		}
		var er_trgttype =  hiddenFields["er_trgttype"];

		var paramValue = null;
		paramValue = "er_usertimeline=" + er_usertimeline + "&bgenabled="
				+ bgenabled

				+ "&currTime=" + currTime + "&enddate=" + enddt + "&endhr="
				+ endhr

				+ "&endmin=" + mgr_enmin + "&er_bgreportfrom=" + er_bgreportfrom
				+ "&er_reportgenration=" + reportgen

				+ "&er_rtype=" + er_rtype + "&er_search=" + er_search
				+ "&er_selection=" + encodeURI(reportType)
				+ "&er_specificComp=" + er_specificComp

				+ "&er_timeline=" + timeline + "&er_trenddata=" + er_trenddata
				+ "&er_view=" + er_view

				+ "&er_ViewName=" + er_ViewName + "&er_trgttype="
				+ encodeURI(er_trgttype)

				+ "&forwardto=" + forwardto + "&fromSchedule=" + fromSchedule
				+ "&inidate=" + inidate

				+ "&isSubmit=true" + "&er_mode=" + mode + "&limitforbg="
				+ encodeURI(limitforbg) + "&schedule_id=" + schedule_id + "&FavoriteId=" + favorite_id+ "&id=" + favorite_id

				+ "&savereport=" + savereport + "&servletName=" + servletName + "&shareUsers=" + er_favorite + "&publicUsers=" + er_favorite
				+ "&startdate=" + strtdt

				+ "&starthr="+ strthour+  "&startmin="+mgr_stmin + "&eruserid=" + eruserid + "&from=client&fromFavoriteModify=yes";

	if (favorite_id == null)
	{
		paramValue += "&newFavorite=yes";
	}
		var target;

		if (btnID != null && btnID == 'scheduleImg') 
		{
			target = "/final/reporter/ErSaveSchedule.jsp?" + paramValue + "&com.eg.CSRF_NONCE="+csrfToken;
		
			if (formButtonId=='save')
			{
				//document.location=url+'&showSchWindow=no';
				target+='&showSchWindow=no';
				var urlNw=target.substr(0,target.indexOf("?"));
				var queryString=target.substr(target.indexOf("?")+1,target.length-1);
				var formSave = Ext.create('Ext.form.Panel');
				formSave.submit({
							url:urlNw,
							params:queryString,
							standardSubmit: true,
							method: 'POST'
				});
			}
			else
			{
				parent.scheduleWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
			}
		} 
		else 
		{
			
			target = "../servlet/com.eg.ErFavoriteC?" + paramValue + "&er_view=GRAPH&cmd=client"+"&er_RmDispName="+appConstants.er_RmDispName+"&com.eg.CSRF_NONCE="+csrfToken;
			
			if (formButtonId=='save')
			{
				//document.location=url+'&showWindow=no'+'&FavoriteId='+favorite_id;
				target+='&showWindow=no'+'&FavoriteId='+favorite_id;
				var urlNw=target.substr(0,target.indexOf("?"));
				var queryString=target.substr(target.indexOf("?")+1,target.length-1);
				var formSave = Ext.create('Ext.form.Panel');
				formSave.submit({
							url:urlNw,
							params:queryString,
							standardSubmit: true,
							method: 'POST'
				});
			}
			else
			{
				parent.favouriteWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp 
			}
		}
	},
	dataFile : function() {
			var thisForm = Ext.getCmp("main").getForm();
			var hiddenFields = Ext.getCmp("main").hiddenFields;
			var reportType = thisForm.findField("reporttype").getValue();
			var er_rtype = hiddenFields["er_rtype"];
			var er_trgttype = hiddenFields["er_trgttype"];
			var er_selection = reportType;
			var timeline = thisForm.findField("er_timeline").getValue();
			var strtdt = thisForm.findField("er_stdate").dataArray;
			var enddt = thisForm.findField("er_enddate").dataArray;
				
			var strthour = thisForm.findField("er_sthr").dataArray;
			var endhr = thisForm.findField("er_endhr").dataArray;
			mgr_stmin = appConstants.defaultJSON.startmin;
			mgr_enmin = appConstants.defaultJSON.endmin;

			var mode = thisForm.findField("er_mode").getValue();

			var sdate = thisForm.findField("er_stdate").parseDate(strtdt);
			var eDate = thisForm.findField("er_enddate").parseDate(enddt);

			var formated_sdate = Ext.Date.dateFormat(sdate, clientDateFormat);
			var formated_edate = Ext.Date.dateFormat(eDate, clientDateFormat);
			var s_qryString = "../servlet/com.eg.ErControllerServlet?er_rtype=Macro&er_rType="
				+ er_rtype
				+ "&er_trgttype="
				+ er_trgttype
				+ "&er_selection="
				+ encodeURI(er_selection)
				+ "&er_timeline="
				+ timeline
				+ "&startdate="
				+ strtdt
				+ "&enddate="
				+ enddt
				+ "&er_mode="
				+ mode + "&er_sthr=" + strthour + "&er_endhr=" + endhr+"&er_view=DATA"+  "&startmin="+mgr_stmin +"&endmin=" + mgr_enmin;;
	//by karthikeyan
	s_qryString+= '&er_RmDispName='+appConstants.er_RmDispName;
				//
			parent.dataWindowFn(s_qryString);
	}
});