Ext.define('executive.view.Data',{
	extend:'Ext.window.Window',
	alias:'widget.data',
	modal:true,
	ghost:false,
	closable:true,
	//collapsible : true,
	//maximizable : true,
	
	closeAction:'destroy',
	title:'EXECUTIVE REPORT',
	//maximizable:true,
	
	width:1000,
	height:500,
	autoScroll:true,
	layout:{
		 type:'fit',
		 align:'stretch'	
	},
	defaults:{
//			margin:5
		 },
		
	items:[{
			    xtype : "component",
				id:"printContentDiv",
			    autoEl:{
				    tag:'iframe',
					frameborder:'0',
					height:'100%',
				    src :''
			    }
			  }
		 ],
		 onRender:function()
		 {
		 	var s_form = Ext.getCmp("settingsForm").getForm();
			var thisForm = Ext.getCmp("main").getForm();
			
			var hiddenFields = Ext.getCmp("main").hiddenFields;


			var reportType = hiddenFields["reporttype"];
			var er_rtype = hiddenFields["er_rtype"];
			var er_trgttype = hiddenFields["er_trgttype"];
			var er_selection = hiddenFields["er_selection"];
			var timeline = s_form.findField("er_timeline").getValue();
			var strtdt = s_form.findField("er_stdate").dataArray;
			var enddt = s_form.findField("er_enddate").dataArray;
			
			var strthour = s_form.findField("er_sthr").dataArray;
			var endhr = s_form.findField("er_endhr").dataArray;

			var mode = s_form.findField("er_mode").getValue();

			var sdate = s_form.findField("er_stdate").parseDate(strtdt);
			var eDate = s_form.findField("er_enddate").parseDate(enddt);

			var formated_sdate = Ext.Date.dateFormat(sdate, clientDateFormat);
			var formated_edate = Ext.Date.dateFormat(eDate, clientDateFormat);
			
			var s_qryString = "../servlet/com.eg.ErControllerServlet?er_rtype=Macro&er_rType="
				+ er_rtype
				+ "&er_trgttype="
				+ er_trgttype
				+ "&er_selection="
				+ encodeURI(er_selection)
				+ "&er_timeline="
				+ timeline
				+ "&startdate="
				+ formated_sdate
				+ "&enddate="
				+ formated_edate
				+ "&er_mode="
				+ mode + "&er_sthr=" + strthour + "&er_endhr=" + endhr+"&er_view=DATA";
	    	var printContentDiv = Ext.select('#printContentDiv');
	    	
			
			printContentDiv.set( { src :  s_qryString });
	    	this.callParent();
		 },
		loadData : function ()
		{
			
			var s_form = Ext.getCmp("settingsForm").getForm();	
			var thisForm = Ext.getCmp("main").getForm();	
			
			var rType = thisForm.findField("er_rtype").getValue();
			var trgt = thisForm.findField("er_trgttype").getValue();
			var er_selection = thisForm.findField("er_selection").getValue();
			var timeline = s_form.findField("er_timeline").getValue();
			var startDate = thisForm.findField("startdate").dataArray;
			var endDate = thisForm.findField("enddate").dataArray;
			var mode = s_form.findField("graphmodecombo").getValue();
			var strthour = s_form.findField("strthourcombo").dataArray;
			var endhr = s_form.findField("endHourCombo").dataArray;
			
			var url="/final/servlet/com.eg.ErControllerServlet";
			var param = "er_rtype=Macro&er_rType="+rType+"&er_trgttype="+trgt+"&er_selection="+encodeURI(er_selection)+"&er_timeline="+timeline+"&startdate="+startDate+"&enddate="+endDate+"&er_mode="+mode+"&er_sthr="+strthour+"&er_endhr="+endhr+"&er_view=DATA";
			
			
			Ext.Ajax.request({
				url:url,
				params:param,
				scope:this,
				success: function(response){
					
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);
					var dataObj = jsonData.dataJSON;
					
					var screenLabels = dataObj.screenLabels;
					
					var compLabel = '<b>'+dataObj.labeldisplay+'</b>';
					var dateLabel= '<b>'+dataObj.screenLabels["reporter.executive.Start Date"]+ "</b> "+ dataObj.sdate
								+' <b>'+dataObj.screenLabels["reporter.executive.End Date "] + "</b>" + dataObj.edate;
			
					var comp = Ext.getCmp("componentfield");
					var dateField = Ext.getCmp("datefield");
					comp.update(compLabel);
					dateField.update(dateLabel);
					
					
					
					var piechartObj = dataObj.piechartData;
					var barchartObj = dataObj.barchartData;
					var piecharthtml = '<div class="x-table">' 
										+'<table cellspacing="0" cellpadding="0" border="0" class="x-grid-table x-grid-table-resizer">'
											+'<thead>'
												+'<tr class="x-grid-row">'
													+'<th class=" x-grid-cell x-grid-cell-first" align="center">'
														+'<div class="x-grid-cell-inner">'+dataObj.screenLabels["reporter.executive.good"]+'</div>'
													+'</th>'
													+'<th class=" x-grid-cell">'
														+'<div class="x-grid-cell-inner">'+dataObj.screenLabels["reporter.executive.high"]+'</div>'
													+'</th>' 
													+'<th class=" x-grid-cell" >' 
														+'<div class="x-grid-cell-inner">'+dataObj.screenLabels["reporter.executive.medium"]+'</div>' 
													+'</th>' 
													+'<th class=" x-grid-cell" >' 
														+'<div class="x-grid-cell-inner">'+dataObj.screenLabels["reporter.executive.low"]+'</div>' 
													+'</th>' 
													+'<th class=" x-grid-cell" >' 
														+'<div class="x-grid-cell-inner">'+dataObj.screenLabels["reporter.executive.unknown"]+'</div>' 
													+'</th>' 
												+'</tr>' 
											+'</thead>' 
										+'<tbody>' 
											+'<tr class="x-grid-row">';
							
											
							for(var ctr =0;ctr<piechartObj.length;ctr++)
							{
								
								piecharthtml += '<td class=" x-grid-cell x-grid-cell-first">' 
													+'<div class="x-grid-cell-inner" >'+piechartObj[ctr]+'</div>' 
												+'</td>';
							}
							piecharthtml += '</tr>'  
											+'</tbody>'
											+'</table>'
											+'</div>';

											
						var barchartHtml = '<div class="x-table">' 
											+'<table cellspacing="0" cellpadding="0" border="0" class="x-grid-table x-grid-table-resizer">'
												+'<thead>'
													+'<tr class="x-grid-row">'
														+'<th class=" x-grid-cell x-grid-cell-first" align="center">'
															+'<div class="x-grid-cell-inner">MMM dd</div>'
														+'</th>'
														+'<th class=" x-grid-cell x-grid-cell-first" align="center">'
															+'<div class="x-grid-cell-inner">Normal</div>'
														+'</th>'
														+'<th class=" x-grid-cell">'
															+'<div class="x-grid-cell-inner">Critical</div>'
														+'</th>' 
														+'<th class=" x-grid-cell" >' 
															+'<div class="x-grid-cell-inner">Major</div>' 
														+'</th>' 
														+'<th class=" x-grid-cell" >' 
															+'<div class="x-grid-cell-inner">Minor</div>' 
														+'</th>' 
														+'<th class=" x-grid-cell" >' 
															+'<div class="x-grid-cell-inner">Unknown</div>' 
														+'</th>' 
													+'</tr>' 
												+'</thead>' 
											+'<tbody>' 
												+'<tr class="x-grid-row">' ;
										for(var itr =0; itr<barchartObj.length;itr= itr+5)
										{
											
											var innerData = barchartObj[itr];
											barchartHtml += '<tr class="x-grid-row">'
													 			+'<td class=" x-grid-cell x-grid-cell-first">' 
																	+'<div class="x-grid-cell-inner" >'+innerData[0]+'</div>' 
																+'</td>'
																+'<td class=" x-grid-cell x-grid-cell-first">' 
																	+'<div class="x-grid-cell-inner" >'+innerData[1]+'</div>' 
																+'</td>'
																+'<td class=" x-grid-cell x-grid-cell-first">' 
																	+'<div class="x-grid-cell-inner" >'+innerData[2]+'</div>' 
																+'</td>'
																+'<td class=" x-grid-cell x-grid-cell-first">' 
																	+'<div class="x-grid-cell-inner" >'+innerData[3]+'</div>' 
																+'</td>'
																+'<td class=" x-grid-cell x-grid-cell-first">' 
																	+'<div class="x-grid-cell-inner" >'+innerData[4]+'</div>' 
																+'</td>'
																+'<td class=" x-grid-cell x-grid-cell-first">' 
																	+'<div class="x-grid-cell-inner" >'+innerData[5]+'</div>' 
																+'</td>'
															+'</tr>' ;
										}
					
								barchartHtml+='</tbody>'
											  +'</table>'
											  +'</div>';
						
						
						var overviewpanel = Ext.getCmp("overview");
						var distributionPanel = Ext.getCmp("distributionpanel");
						overviewpanel.update(piecharthtml);
						distributionPanel.update(barchartHtml);
						
						
						
					
				}
				
			});
			
			
		}
	

});