Ext.define('executive.view.EventSummaryGrid', {
			extend : 'utilities.CustomGrid',
			alias : 'widget.eventsSummaryGrid',
			border : true,
			frame:false,
			header:false,
			ui:'newGridPanel',
			height:200,
			autoScroll:true,
			scroll:true,
			margin:'0 10 10 10',
			padding:0,
			flex:1,
 			screenLabels:null,
			dataArray : null,
			emptyText : '<img src="/final/reporter/images/nomeasureforgraph.png"/>',
			initComponent : function() {
 				this.store = Ext.create('Ext.data.Store', {
							fields : ['Layer', 'critical', 'major', 'minor',
									'Total', 'href', 'compname', 'comptype'],
							proxy : {
								type : 'memory',
								reader : {
									type : 'json'
								}
							},
							autoLoad : true,
							data : this.dataArray
						});

				var thisForm = Ext.getCmp("main").getForm();

				var trgt = Ext.getCmp("main").hiddenFields["er_trgttype"];

				if (trgt != null && trgt != 'undefined') {
					if (trgt == 'Service' || trgt == 'Segment' || trgt == 'CompType' || trgt == 'Zone') {
						var isEmpty=false;
						this.columns = [{
							header : !Ext.isEmpty(this.screenLabels["reporter.common.reportType"])?this.screenLabels["reporter.common.reportType"]:"Component Name",
							dataIndex : 'compname',
							align:'left',
							flex:1,
							menuDisabled : false,
							hidden:false,
							renderer : function(value, metaData, record,
									rowIndex) {
								metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+value.trim()+'"';
								if(Ext.isEmpty(value))
								{
									isEmpty=true;
								}
								return '<a href="' + record.get('href') + '&er_trgttype=Application" class="anchorLinkDefault">'
										+ value + '</a>';
							}
						}, {
							header : !Ext.isEmpty(this.screenLabels['reporter.common.CompType'])?this.screenLabels['reporter.common.CompType']:"Component Type",
							dataIndex : 'comptype',
							//width:100,
							flex:1,
							align:'left',
							menuDisabled : false,
							renderer : function(value, metaData, record,
									rowIndex) {
								metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+value.trim()+'"';
								if(Ext.isEmpty(value))
								{
									isEmpty=true;

								}
								if (trgt == 'Segment')
									return '<a href="' + record.get('href')
											+ '&er_trgttype=CompType" class="anchorLinkDefault">' + value + '</a>';
								else
									return value;
							}
						}, {
							header : !Ext.isEmpty(this.screenLabels["reporter.common.high"])?this.screenLabels["reporter.common.high"]:"Component Type",
							dataIndex : 'critical',
							//flex:1,
							width:70,
							align:'center',
 							menuDisabled : false,
							renderer : function(value, metaData, record, rowIndex) 
							{
								metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+value.trim()+'"';
								value = this.getDecimalAlignFormat(value);
								return value;
							}

						}, {
							header : !Ext.isEmpty(this.screenLabels["reporter.common.medium"])?this.screenLabels["reporter.common.medium"]:"Component Type",
							dataIndex : 'major',
							//flex:1,
							width:60,
							align:'center',
							menuDisabled : false,
							renderer : function(value, metaData, record, rowIndex) 
							{
								metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+value.trim()+'"';
								value = this.getDecimalAlignFormat(value);
								return value;
							}
						}, {
							header : !Ext.isEmpty(this.screenLabels["reporter.common.low"])?this.screenLabels["reporter.common.low"]:"Component Type",
							dataIndex : 'minor',
							//flex:1,
							width:60,
							align:'center',
							menuDisabled : false,
							renderer : function(value, metaData, record, rowIndex) 
							{
								metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+value.trim()+'"';
								value = this.getDecimalAlignFormat(value);
								return value;
							}
						}, {
							header : !Ext.isEmpty(this.screenLabels["reporter.common.Total"])?this.screenLabels["reporter.common.Total"]:"Component Type",
							dataIndex : 'Total',
							//flex:1,
							width:60,
							align:'center',
							menuDisabled : false,
							renderer : function(value, metaData, record, rowIndex) 
							{
								metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+value.trim()+'"';
								value = this.getDecimalAlignFormat(value);
								return value;
							}
						}];

						if(isEmpty)
							this.hide();

					} else {
						var isEmpty=false;
						this.columns = [{
							header : !Ext.isEmpty(this.screenLabels["reporter.common.reportType"])?this.screenLabels["reporter.common.reportType"]:"Layer",
							dataIndex : 'Layer',
							align:'left',
							flex:2,
							menuDisabled : false,
							renderer : function(value, metaData, record,
									rowIndex) {
								metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+value.trim()+'"';
								if(Ext.isEmpty(value))
								{
									isEmpty=true;
								}
								return '<a href="' + record.get('href') + '" class="anchorLinkDefault">' 
									+ value + '</a>';

							}
						},{
							header : !Ext.isEmpty(this.screenLabels["reporter.common.high"])?this.screenLabels["reporter.common.high"]:"critical",
							dataIndex : 'critical',
							flex:1,
							align:'center',
							menuDisabled : false,
							renderer : function(value, metaData, record, rowIndex) 
							{
								metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+value.trim()+'"';
								value = this.getDecimalAlignFormat(value);
								return value;
							}
						},{
							header : !Ext.isEmpty(this.screenLabels["reporter.common.medium"])?this.screenLabels["reporter.common.medium"]:"major",
							dataIndex : 'major',
							flex:1,
							align:'center',
							menuDisabled : false,
							renderer : function(value, metaData, record, rowIndex) 
							{
								metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+value.trim()+'"';
								value = this.getDecimalAlignFormat(value);
								return value;
							}
						},{
							header : !Ext.isEmpty(this.screenLabels["reporter.common.low"])?this.screenLabels["reporter.common.low"]:"minor",
							dataIndex : 'minor',
							flex:1,
							align:'center',
							menuDisabled : false,
							renderer : function(value, metaData, record, rowIndex) 
							{
								metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+value.trim()+'"';
								value = this.getDecimalAlignFormat(value);
								return value;
							}
						}, {
							header : !Ext.isEmpty(this.screenLabels["reporter.common.Total"])?this.screenLabels["reporter.common.Total"]:'Total',
							dataIndex : 'Total',
							flex:1,
							align:'center',
							menuDisabled : false,
							renderer : function(value, metaData, record, rowIndex) 
							{
								metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+value.trim()+'"';
								value = this.getDecimalAlignFormat(value);
								return value;
							}
						}];
						if(isEmpty)
							this.hide();
					}
				}
				this.callParent();
			}
		});
