Ext.define('executive.view.Print',{
	extend:'Ext.window.Window',
	alias:'widget.print',
	modal:true,
	ghost:false,
	closeAction:'destroy',
	title:'INFRASTRUCTURE OVERVIEW',
	width:'95%',
	height:'95%',
	autoScroll:true,
	layout:{
		 type:'fit',
		 align:'stretch'	
	},
	defaults:{
			//margin:5
		 },
	items:[
			{
			    xtype : "component",
				id:"printContentDiv",
			    autoEl:{
				    tag:'iframe',
					frameborder:'0',
					height:'100%',
				    src :''
			    }
			  }
		 ],
	   	onRender : function()
	    {
		    var s_form = Ext.getCmp("settingsForm").getForm();
			var thisForm = Ext.getCmp("main").getForm();
			

			var hiddenFields = Ext.getCmp("main").hiddenFields;

			var reportType = hiddenFields["reporttype"];
			var er_rtype = hiddenFields["er_rtype"];
			var er_trgttype = hiddenFields["er_trgttype"];
			var er_selection = hiddenFields["er_selection"];
			var timeline = s_form.findField("er_timeline").getValue();
			var strtdt = s_form.findField("er_stdate").getValue();
			var enddt = s_form.findField("er_enddate").getValue();
			var strthour = s_form.findField("er_sthr").getValue();
			var endhr = s_form.findField("er_endhr").getValue();
			var mode = s_form.findField("er_mode").getValue();
			var sdate = s_form.findField("er_stdate").parseDate(strtdt);
			var eDate = s_form.findField("er_enddate").parseDate(enddt);
			var formated_sdate = Ext.Date.dateFormat(sdate, clientDateFormat);
			var formated_edate = Ext.Date.dateFormat(eDate, clientDateFormat);
			
			var s_qryString = "../servlet/com.eg.ErControllerServlet?er_rtype=Macro&er_rType="
				+ er_rtype
				+ "&er_trgttype="
				+ er_trgttype
				+ "&er_selection="
				+ encodeURI(er_selection)
				+ "&er_timeline="
				+ timeline
				+ "&startdate="
				+ formated_sdate
				+ "&enddate="
				+ formated_edate
				+ "&er_mode="
				+ mode + "&er_sthr=" + strthour + "&er_endhr=" + endhr+"&er_view=PRINT&pdfPrint=yes";;
	    	var printContentDiv = Ext.select('#printContentDiv');
			
			

			printContentDiv.set( { src :  s_qryString });
	    	this.callParent();
	    },
		loadData : function (jsonData)
		{

			var printJSON = jsonData.printJSON;
			
			Ext.getCmp("probDistribution").setSrc(printJSON.pieChartImg);
			Ext.getCmp("problemdurationanalysis").setSrc(printJSON.barchartImg);
			
			var topeventsObj = Ext.create('widget.topevents');
			var eventSummaryObj = Ext.create('widget.eventsSummary');
			
			var serviceDataTableObj = Ext.getCmp("serviceDataTable");
			topeventsObj.loadTopEventsTable(jsonData,'print');
			
			var componentDataTableObj = Ext.getCmp("componentDataTable");
			eventSummaryObj.loadEventsSummaryTable(jsonData,'print');
			
			
			
			/*var topeventsobj = Ext.getCmp("topevents");
			var serviceDataTableObj = Ext.getCmp("serviceDataTable");
			serviceDataTableObj.add(topeventsobj);
			var eventSummaryObj = Ext.getCmp("eventsummarytable");
			var componentDataTableObj = Ext.getCmp("componentDataTable");
			componentDataTableObj.add(eventSummaryObj);
			*/

		}
	

});