Ext.define('executive.view.TopeventsGrid', {
			extend : 'utilities.CustomGrid',
			alias : 'widget.topeventsGrid',
			border : true,
			ui:'newGridPanel',
			height:200,
			margin:'0 10 10 10',
			header:false,
			frame:false,
			padding:0,
			autoScroll:false,
			scroll:true,
			flex:1,
 			screenLabels:null,
			sortableColumns:false,
			dataArray : null,
			emptyText : '<table width="100%"><tr><td align="center" valign="middle"><div class="iconExclamation" style="margin:12% auto 0% auto"></div>No Measures Available</td></tr></table>',
			initComponent : function() {

			this.store = Ext.create('Ext.data.Store', {
						fields : ['state', 'layer', 'duration', 'from','to', 'href'],
						proxy : {
							type : 'memory',
							reader : {
								type : 'json'
							}
						},
						autoLoad : false,
						data : this.dataArray
					});

			if(this.dataArray==undefined)
				this.emptyText = '<img src="/final/reporter/images/nomeasureforgraph.png"/><br/>No Measures Available';
				this.columns = [{
							//header : !Ext.isEmpty(this.screenLabels["reporter.common.State"])?this.screenLabels["reporter.common.State"]:'state',
							header:'&nbsp;',
							dataIndex : 'state',
							align:'left',
							//flex:0.5,
							width:36,
							menuDisabled : false,
							renderer : function(value, metaData, record, rowIndex) 
							{
								metaData.tdCls="iconColumn";
								metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+value.trim()+'"';
								var value = '<div class="state_'+value+'"></div>';
								return value;
							}
						}, {
							header : !Ext.isEmpty(this.screenLabels["reporter.common.reporttype"])?this.screenLabels["reporter.common.reporttype"]:'layer',
							dataIndex : 'layer',
							align:'left',
							menuDisabled : false,
							flex:1,
							minWidth:150,
							renderer : function(value, metaData, record, rowIndex) {
								metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+value.trim()+'"';
								
								return '<a href="' + record.get('href') +'" class="anchorLinkDefault">'
										+ value + '</a>';
							}
						}, {
							header : !Ext.isEmpty(this.screenLabels["reporter.common.Duration"])?this.screenLabels["reporter.common.Duration"]:'duration',
							dataIndex : 'duration',
							menuDisabled : false,
							align:'left',
							width:100,
							renderer : function(value, metaData, record, rowIndex) 
							{
								metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+value.trim()+'"';
								return value;
							}
						}, {
							header : !Ext.isEmpty(this.screenLabels["reporter.common.From"])?this.screenLabels["reporter.common.From"]:'from',
							dataIndex : 'from',
							width:150,
							align:'left',
							menuDisabled : false,
							renderer : function(value, metaData, record, rowIndex) 
							{
								metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+value.trim()+'"';
								return value;
							}
						}, {
							header : !Ext.isEmpty(this.screenLabels["reporter.common.To"])?this.screenLabels["reporter.common.To"]:'to',
							dataIndex : 'to',
							align:'left',
							width:150,
							menuDisabled : false,
							renderer : function(value, metaData, record, rowIndex) 
							{
								metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+value.trim()+'"';
								return value;
							}
						}];
				this.callParent();
			}
		});
