Ext.Loader.setConfig({
	enabled: true,
	garbageCollect: true,
	preserveScripts: false,
	disableCaching: true
});

Ext.Loader.setPath('utilities','../scripts/utilities');
Ext.Loader.setPath('Ext.ux','../scripts/ux');
Ext.Ajax.timeout=ajaxTimeout;
Ext.Ajax.disableCaching=false;
registerAjaxExceptionEvent();

Ext.application({
	name:'ExternalMonitorApp',
	requires:['ExternalMonitorApp.view.Main'],
	controllers:['ExternalMonitorApp.controller.ExternalMonitorController'],
	appFolder:['../reporter/scripts/ExternalMonitorApp'],
	launch:function(){
		appConstants.appObj=this;
		appConstants.LoadingMask=new Ext.LoadMask(Ext.getBody(),{msg:"Loading..."});
		appConstants.appController='ExternalMonitorController';
		var url='/final/reporter/ErExternalMonitorReportJSON.jsp';
		appConstants.defaultParams='method=init';
		Ext.Ajax.request({
			url:url,
			scope:this,
			params:appConstants.queryStr,
			method:'POST',
			success: function(response)
			{
				var jsonText=response.responseText;
				var jsonData=Ext.decode(jsonText);
				appConstants.defaultLoadData=jsonData;
				Ext.create('Ext.container.Viewport',
				{
					layout:'fit',
					items:[
						{
							xtype:'main'
						}
					]
				});
				if(appConstants.isSubmit=='true')
				{
					appConstants.appObj.getController(appConstants.appController).submitReport(appConstants.queryStr);
					appConstants.isSubmit='false';					
				}
			}
		});
	}
	
});