Ext.define('ExternalMonitorApp.controller.ExternalMonitorController',{
	extend:'Ext.app.Controller',
	views:['Main'],
	refs:[
		{
			selector:'main',
			ref:'main'
		},
		{
			selector:'newUtilities',
			ref:'newUtilities'
		},
		{
			selector:'mainform',
			ref:'mainform'
		},
		{
			selector:'externalMonitorForm',
			ref:'externalMonitorForm'
		},
		{
			selector:'externalMonitorAppSettings',
			ref:'externalMonitorAppSettings'
		},
		{
			selector: 'resultpanel',
			ref: 'resultpanel'
		},
		{
			selector: 'nomeasurepanel',
			ref: 'nomeasurepanel'
		},
		{
			selector: 'backGroundPanel',
			ref: 'backGroundPanel'
		},
		{
			selector: 'customtrigger',
			ref:'customtrigger'
		}
	],
	init: function()
	{
		this.control({
			'newUtilities':
			{
				'afterrender':this.loadTools
			},
			'main':
			{
				'afterrender':this.afterMainRender
			},
			'mainform button[name="submit"]':
			{
				'click':this.submitReport
			},
			'mainform button[name="save"]':
			{
				'click':this.modifyScheduleFavorite	
			},
			'newUtilities > #saveTool > button':
			{
				'click':this.saveReportAsPDF
			},
			'newUtilities > #printTool > button':
			{
				'click':this.printReport
			},
			'newUtilities > #mailTool > button':
			{
				'click':this.sendMail
			},
			'newUtilities > #csvTool > button':
			{
				'click':this.saveCsv
			},
			'newUtilities > #favoriteTool > button':
			{
				'click':this.saveFavorite
			},
			'newUtilities > #scheduleTool > button':
			{
				'click':this.saveSchedule
			},
			'mainform button[id="expandSelector"]':
			{
				'click':this.expandMe
			},
			'externalMonitorForm combo[id="er_type"]':
			{
				'select':this.onSelectReportFor
			},
			'externalMonitorForm combo[id="er_option"]':
			{
				'select':this.onSelectAnalysisBy
			},
			'externalMonitorForm combo[id="er_site"]':
			{
				'select':this.onSelectSiteBy
			},
			'externalMonitorForm combo[id="er_compType"]':
			{
				'select':this.onSelectComponentType
			},
			'mainform trigger[id="compSearch"]':
			{
				'change':this.compMultiSelect
			},
			'mainform multiselectfield[id=er_Component]':
			{
				'change':this.onSelectComponent
			},
			'externalMonitorAppSettings':
			{
				'afterrender':this.closeSetting
			},
			'externalMonitorAppSettings combo[name="reportGeneration"]':
			{
				'select':this.reportGenChange
			},
			'externalMonitorAppSettings button[id="moreOptionCloseId"]':
			{
				'click':this.validateAndCloseSettings
			},
			'externalMonitorAppSettings button[id="submitViaSetting"]':
			{
				'click':this.closeSettingAndSubmit
			},
			/*'externalMonitorAppSettings combo[id="er_excwe"]':
			{
				'select':this.excludeWeekendsChange
			},*/
			'mainform button[id="panelinsidetoggle"]':
			{
				'click':this.toggleForm
			}
		});
	},
	loadTools:function()
	{
		this.getNewUtilities().loadIcon(true,true,true,false,true,true,true,false,false,false,true);
		Ext.getCmp('favoriteTool').setDisabled(false);
		Ext.getCmp('scheduleTool').setDisabled(false);
	},
	afterMainRender:function(){
		this.getMain().setTitle(appConstants.defaultLoadData.reportTitle);
		var jData=appConstants.defaultLoadData;
		this.setReportForData(jData);
		this.setErOptionData(jData);
		var analysisBy=Ext.getCmp('er_option');
		var er_site=Ext.getCmp('er_site');
		var er_subZone=Ext.getCmp('er_subZone');
		if(analysisBy != undefined && analysisBy.getValue() != undefined && analysisBy.getValue() != 'Component' && analysisBy.getValue() != '-1')
		{
			this.setSiteOptionData(jData);
			er_site.show();
			er_subZone.show();
		}
		else
		{
			er_site.hide();
			er_subZone.hide();
		}
		this.setComponentTypeData(jData);
		this.setExternalAgentData(jData);
		this.setApplciationData(jData);
		this.setComponentData(jData);
		var er_timeline=Ext.getCmp('er_timeline');
		er_timeline.getStore().loadRawData(jData['timelineCombo']);
		er_timeline.setValue(jData['selectedTimeline']);
		var startDateObj=Ext.getCmp('er_stdate');
		startDateObj.setValue(jData.startDateForDisplay);
		startDateObj.dataArray=jData.startDate;
		var startHrObj=Ext.getCmp('er_sthr');
		startHrObj.setValue(jData.startHourForDisplay);
		startHrObj.dataArray=jData.startHour;
		var endDateObj=Ext.getCmp('er_enddate');
		endDateObj.setValue(jData.endDateForDisplay);
		endDateObj.dataArray = jData.endDate;
		var endHrObj = Ext.getCmp('er_endhr');
		endHrObj.setValue(jData.endHourForDisplay);
		endHrObj.dataArray = jData.endHour;
		mgr_stmin=appConstants.defaultLoadData.startmin;
		mgr_enmin=appConstants.defaultLoadData.endmin;
		Ext.getCmp('externalMonitorForm').add({
			xtype:'hidden',
			id:'ID',
			name:'ID',
			value:jData['ID']
		});
		if(appConstants.isDrillDown != undefined && appConstants.isDrillDown=='true')
		{
			var ornt=Ext.getCmp('mainform');		
			ornt.hide();
			Ext.getCmp('panelinsidetoggle').hide();
			Ext.getCmp('selectionDetails').hide();			
		}
	},
	expandMe:function(btn){
		if(Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils=Ext.widget('erutils');
		}
		appConstants.erUtils.expandMultiComboButton(Ext.getCmp('er_Component'),Ext.getCmp('compLbl').text,btn);
	},
	setSiteOptionData:function(jData)
	{
		var siteBy=Ext.getCmp('er_site');
		var er_subZone=Ext.getCmp('er_subZone');
		if(jData.subZoneCombo != undefined)
		{
			var analysisBy=Ext.getCmp('er_option');
			siteBy.setFieldLabel(analysisBy.getValue());
			siteBy.getStore().loadRawData(jData['siteCombo']);
			siteBy.setValue(jData.selectedField['selectedSiteCombo']);
			var er_subZone=Ext.getCmp('er_subZone');
			er_subZone.getStore().loadRawData(jData['subZoneCombo']);
			er_subZone.setValue(jData.selectedField['selectedSubZone']);
			siteBy.show();
			er_subZone.show();
		}
		else
		{
			siteBy.hide();
			er_subZone.hide();
		}
	},
	setReportForData:function(jData){
		var reportFor=Ext.getCmp('er_type');
		reportFor.getStore().loadRawData(jData['reportForCombo']);
		if(jData.selectedField != undefined && jData.selectedField['selectedReportFor'] != undefined)
		{
			reportFor.setValue(jData.selectedField['selectedReportFor']);
		}
		else
		{
			var reporForData=jData['reportForCombo'];
			if(reporForData !=undefined && reporForData.length > 0)
			{
				reportFor.setValue(reporForData[0].valueField);
			}
		}
	},
	setErOptionData:function(jData){
		var analysisBy=Ext.getCmp('er_option');
		analysisBy.getStore().loadRawData(jData['analysisBy']);
		if(jData.selectedField != undefined && jData.selectedField['selectedAnalysisBy'] != undefined)
		{
			analysisBy.setValue(jData.selectedField['selectedAnalysisBy']);
		}
		else
		{
			var analysisByData=jData['analysisBy'];
			if(analysisByData !=undefined && analysisByData.length > 0)
			{
				analysisBy.setValue(analysisByData[0].valueField);
			}
		}
	},
	setComponentTypeData:function(jData)
	{
		var er_componentType=Ext.getCmp('er_compType');
		er_componentType.getStore().loadRawData(jData['compTypeCombo']);
		if(jData.selectedField != undefined && jData.selectedField['selectedComponentTypes'] != undefined)
		{
			er_componentType.setValue(jData.selectedField['selectedComponentTypes']);
		}
		else
		{
			var compTypeCombo=jData['compTypeCombo'];
			if(compTypeCombo != undefined && compTypeCombo.length > 0)
			{
				er_componentType.setValue(compTypeCombo[0].valueField);
			}
		}		
	},
	setExternalAgentData:function(jData)
	{
		var er_externalAgent=Ext.getCmp('er_externalAgent');
		er_externalAgent.getStore().loadRawData(jData['externalAgentCombo']);
		if(jData.selectedField != undefined && jData.selectedField['selectedExternalAgent'] != undefined)
		{
			er_externalAgent.setValue(jData.selectedField['selectedExternalAgent']);
		}
		else
		{
			var externalAgentCombo=jData['externalAgentCombo'];
			if(externalAgentCombo != undefined && externalAgentCombo.length > 0)
			{
				er_externalAgent.setValue(externalAgentCombo[0].valueField);
			}
		}
	},
	setApplciationData:function(jData)
	{
		if(appConstants.reportFor != undefined && !appConstants.applicationComboHidden)
		{
			var er_application=Ext.getCmp('er_application');
			if (er_application.isHidden())
				er_application.show();
			appConstants.applicationComboHidden=false;
			if(jData.selectedField != undefined && jData.selectedField['selectedAppLabel'] != undefined)
				er_application.setFieldLabel(jData.selectedField['selectedAppLabel']);
			er_application.getStore().loadRawData(jData['applicationCombo']);
			if(jData.selectedField != undefined && jData.selectedField['selectedApplication'] != undefined)
			{
				er_application.setValue(jData.selectedField['selectedApplication']);
			}
			else
			{
				var applicationCombo=jData['applicationCombo'];
				if(applicationCombo != undefined && applicationCombo.length > 0)
				{
					er_application.setValue(applicationCombo[0].valueField);
				}
			}
		}
	},
	setComponentData:function(jData)
	{
		var er_Component=Ext.getCmp('er_Component');
		er_Component.getStore().clearFilter(true);
		er_Component.getStore().loadRawData(jData['componentCombo']);
		if(!Ext.isEmpty(jData.selectedField['selectedComponents']) && jData.selectedField['selectedComponents'] != undefined)
		{
			er_Component.setValue(jData.selectedField['selectedComponents']);
		}
		else
		{
			if(jData['componentCombo'][0].valueField != '-1')
				er_Component.setValue(jData['componentCombo'][0].valueField);
		}
	},	
	onSelectReportFor:function(obj)
	{		
		appConstants.reportFor=Ext.getCmp('er_type').getValue();
		var reportBy='reportFor='+appConstants.reportFor;
		var formObj=this;
		appConstants.LoadingMask.show();
		Ext.Ajax.request({
			url:'/final/reporter/ErExternalMonitorReportJSON.jsp',
			scope:this,
			method:'POST',
			params:reportBy,
			success: function(response)
			{
				var jsonText=response.responseText;
				var jsonData=Ext.decode(jsonText);
				appConstants.defaultLoadData=jsonData;
				formObj.setErOptionData(jsonData);
				var thisVal=Ext.getCmp('er_option').getValue();
				if(thisVal != 'Component' && thisVal != -1)
				{
					formObj.setSiteOptionData(jsonData);
					Ext.getCmp('er_site').show();
					Ext.getCmp('er_subZone').show();
				}
				else
				{
					Ext.getCmp('er_site').hide();
					Ext.getCmp('er_subZone').hide();
				}
				formObj.setComponentTypeData(jsonData);
				formObj.setExternalAgentData(jsonData);
				if(appConstants.defaultLoadData.enableAppCombo != undefined && appConstants.defaultLoadData.enableAppCombo == 'yes')
					appConstants.applicationComboHidden=false;
				else
					appConstants.applicationComboHidden=true;
				if(appConstants.reportFor != undefined && !appConstants.applicationComboHidden)
				{
					formObj.setApplciationData(jsonData);
					appConstants.applicationComboHidden=false;
					Ext.getCmp('er_application').show();
				}
				else
				{
					appConstants.applicationComboHidden=true;
					Ext.getCmp('er_application').hide();
				}				
				formObj.setComponentData(jsonData);
				appConstants.LoadingMask.hide();
			}
		});
	},
	onSelectAnalysisBy:function(obj)
	{
		var thisVal=Ext.getCmp('er_option').getValue();
		appConstants.reportFor=Ext.getCmp('er_type').getValue();
		var reportBy='analysisBy='+thisVal+'&reportFor='+appConstants.reportFor;
		var formObj=this;
		appConstants.LoadingMask.show();
		Ext.Ajax.request({
			url:'/final/reporter/ErExternalMonitorReportJSON.jsp',
			scope:this,
			method:'POST',
			params:reportBy,
			success: function(response)
			{
				var jsonText=response.responseText;
				var jsonData=Ext.decode(jsonText);
				appConstants.defaultLoadData=jsonData;
				if(thisVal != 'Component')
				{
					formObj.setSiteOptionData(jsonData);
					Ext.getCmp('er_site').show();
					Ext.getCmp('er_subZone').show();
				}
				else
				{
					Ext.getCmp('er_site').hide();
					Ext.getCmp('er_subZone').hide();
				}
				formObj.setComponentTypeData(jsonData);
				formObj.setExternalAgentData(jsonData);
				formObj.setApplciationData(jsonData);
				formObj.setComponentData(jsonData);
				appConstants.LoadingMask.hide();
			}
		});
	},
	onSelectSiteBy:function(obj)
	{
		var thisVal=this.getValue();
		var paramsObj='analysisBy='+Ext.getCmp(er_option).getValue()+'&er_site='+thisVal+'&er_subZone='+Ext.getCmp('er_subZone').getValue();
		appConstants.reportFor=Ext.getCmp('er_type').getValue();
		paramsObj+='&reportFor='+appConstants.reportFor;
		var formObj=this;
		appConstants.LoadingMask.show();
		Ext.Ajax.request({
			url:'/final/reporter/ErExternalMonitorReportJSON.jsp',
			scope:this,
			method:'POST',
			params:paramsObj,
			success:function(response)
			{
				var jsonText=response.responseText;
				var jsonData=Ext.decode(jsonText);
				appConstants.defaultLoadData=jsonData;
				formObj.setComponentTypeData(jsonData);
				formObj.setExternalAgentData(jsonData);
				formObj.setApplciationData(jsonData);
				formObj.setComponentData(jsonData);
				appConstants.LoadingMask.hide();
			}
		});
	},
	onSelectComponentType: function()
	{			
		var er_option = Ext.getCmp('er_option').getValue();
		var er_compType = Ext.getCmp('er_compType').getValue();
		var params='&analysisBy='+er_option;
		appConstants.reportFor=Ext.getCmp('er_type').getValue();
		params+='&reportFor='+appConstants.reportFor;
		if(!appConstants.enableMultiCompType)
		{
			params += "&er_compType="+er_compType;
		}
		else
		{
			for(var c=0;c<er_compType.length;c++)
			{
				params += "&er_compType="+ er_compType[c];
			}
		}
		var formObj = this;
		appConstants.LoadingMask.show();
		Ext.Ajax.request({
			url:'/final/reporter/ErExternalMonitorReportJSON.jsp',
			scope:this,
			method: 'POST',
			params: params,
			success:function(response)
			{
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);
				appConstants.defaultLoadData = jsonData;
				formObj.setComponentData(jsonData);
				formObj.setExternalAgentData(jsonData);
				formObj.setApplciationData(jsonData);
				appConstants.LoadingMask.hide();
			}
		});	
	},
	onSelectComponent:function(obj)
	{
		if(appConstants.isDrillDown != undefined && appConstants.isDrillDown=='true')
		{
			return;
		}
		if(appConstants.isSubmit !=undefined &&  appConstants.isSubmit == 'true')
		{
			return;
		}
		var er_option = Ext.getCmp('er_option').getValue();
		var er_compType = Ext.getCmp('er_compType').getValue();
		var params='&analysisBy='+er_option;
		appConstants.reportFor=Ext.getCmp('er_type').getValue();
		params+='&reportFor='+appConstants.reportFor;
		if(!appConstants.enableMultiCompType)
		{
			params += "&er_compType="+er_compType;
		}
		else
		{
			for(var c=0;c<er_compType.length;c++)
			{
				params += "&er_compType="+ er_compType[c];
			}
		}
		var er_Component=Ext.getCmp('er_Component').getValue();
		if(er_Component[0] == '-1')
		{
			this.showMessage('Components is Not Applicable');
			return false;
		}
		if (er_Component.length > 1 && (er_Component.indexOf('All') > -1 || er_Component.indexOf('all') > -1))
		{
			this.showMessage('Chosen component group not allowed');
			return false;
		}
		for(var c=0;c<er_Component.length;c++)
		{
			params += "&er_Component="+er_Component[c];
		}
		var formObj = this;
		appConstants.LoadingMask.show();
		Ext.Ajax.request({
			url:'/final/reporter/ErExternalMonitorReportJSON.jsp',
			scope:this,
			method: 'POST',
			params: params,
			success:function(response)
			{
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);
				appConstants.defaultLoadData = jsonData;
				formObj.setExternalAgentData(jsonData);
				formObj.setApplciationData(jsonData);
				appConstants.LoadingMask.hide();
			}
		});	
	},
	saveReportAsPDF:function()
	{
		appConstants.reportFor=Ext.getCmp('er_type').getValue();
		var queryString="../reporter/ErHtmlToSavePdf.jsp?reportFor="+appConstants.reportFor;
		if(Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils=Ext.widget('erutils');
		}
		appConstants.erUtils.savePDF(queryString);
	},
	bookletQuery:function(obj)
	{
		var s_qryString=this.getQueryString();
		return s_qryString;
	},
	bookletScheduleQuery:function(obj)
	{
		var bookletquery=this.getQueryString();
		bookletquery+='&er_rtype=ExternalMonitorReport&er_trgttype=ExternalMonitorReport&er_ViewName=ErExternalMonitorReport.jsp&er_RmDispName=ExternalMonitorReport';
		return bookletquery;
	},
	bookletPreview:function()
	{
		this.printReport();
	},
	printReport:function()
	{
		appConstants.reportFor=Ext.getCmp('er_type').getValue();
		var s_queryString="/final/reporter/ErExternalMonitorPrint.jsp?pdfPrint=yes&inidate="+appConstants.defaultLoadData.inidate+"&reportFor="+appConstants.reportFor;	
		parent.printWindowFn(s_queryString);
	},
	sendMail:function()
	{
		Ext.widget('sendmail').show();
	},
	saveCsv:function()
	{
		window.location='../servlet/com.eg.ErExternalMonitorReportC?er_view=CSV';
	},
	saveSchedule:function(obj)
	{
		var params = this.getQueryString();
		var qryString ="/final/reporter/ErSaveSchedule.jsp?er_rtype=ExternalMonitorReport&er_trgttype=ExternalMonitorReport&er_ViewName=ErExternalMonitorReport.jsp&er_RmDispName=ExternalMonitorReport&"+params;
		if (Ext.getCmp('er_timeline').getValue() == 'Any')
		{
		   this.showMessage('Chosen timeline not allowed');
			  return;
		}
		parent.scheduleWindowFn(qryString);
	},
	saveFavorite: function()
	{
		var params = this.getQueryString();
		var target = "/final/reporter/ErSaveFavorite.jsp?er_trgttype=ExternalMonitorReport&er_rtype=ExternalMonitorReport&er_ViewName=ErExternalMonitorReport.jsp&er_RmDispName=ExternalMonitorReport&"+params;
		/* if (Ext.getCmp('er_timeline').getValue() == 'Any')
		{
			  this.showMessage('Chosen timeline not allowed');
			  return;
		} */
		parent.favouriteWindowFn(target);
	},
	modifyScheduleFavorite: function()
	{
		var qryStr = this.getQueryString();
		var commonQStr = '&er_trgttype=ExternalMonitorReport&er_rtype=ExternalMonitorReport&er_ViewName=ErExternalMonitorReport.jsp&er_RmDispName=ExternalMonitorReport&fromFavoriteModify=Yes&cmd=client';
		var forSchedule = '&schedule_id='+appConstants.scheduleID+'&fromScheduleModify=Yes';
		var forFavorite = '&FavoriteId='+appConstants.favoriteID+'&fromFavoriteModify=Yes&er_favorite='+appConstants.erFavorite+'&er_rtype=ExternalMonitorReport';
		var urlNw         = "";
		if(appConstants.isModifyFavorite == 'Yes')
		{
			urlNw = "/final/reporter/ErSaveFavorite.jsp?showSchWindow=no";
			qryStr += commonQStr+forFavorite;
		}
		else
		{
			urlNw = "/final/reporter/ErSaveSchedule.jsp?showSchWindow=no";
			qryStr += commonQStr+forSchedule;
		}
		var formSave = Ext.create('Ext.form.Panel');
		formSave.submit({
			url: urlNw,
			params: qryStr,
			standardSubmit: true,
			method: 'POST'
		});
	},
	submitReport: function(qryStr)
	{
		Ext.getCmp('er_timeline').fireEvent('forceSelect',Ext.getCmp('er_timeline'));
	},
	showResult:function()
	{
		Ext.getCmp('panelinsidetoggle').setDisabled(false);
		if(!isSettingsEnabled)
			this.showConfigDropdown();
		var params ='';
		
		if(appConstants.isSubmit !=undefined &&  appConstants.isSubmit == 'true')
		{
			params = this.getQueryString();
		}
		else
		{
			params =  this.getQueryString();
			if(params==false) 
				return;
		}
		var formObj = this;
		var rGenType ='foreground';
		if(isSettingsEnabled)
		{
		   rGenType = Ext.getCmp("reportGeneration").getValue();
		}
		if(rGenType =='foreground')
		{
			var me1 = this;
			var limitforbg = appConstants.defaultLoadData.limitforbg;
			var maxDays    = appConstants.defaultLoadData.maxDays;

			var stDate    = Ext.getCmp("er_stdate").getValue();
			var startHr   = Ext.getCmp("er_sthr").getValue();
			var enDate    = Ext.getCmp("er_enddate").getValue();
			var endHr     = Ext.getCmp("er_endhr").getValue();
			stDate.setHours(startHr);
			enDate.setHours(endHr);          
			if(!checkTimeLineForBgLimit(limitforbg,maxDays,stDate,enDate))
			{
				Ext.Msg.confirm("Confirm", appConstants.forGrdReportConfirmMsg, function(btnText){				
					if(btnText === "no")
					{
						this.getReporterSettings().down('button').fireHandler();
						Ext.getCmp("reportGeneration").setValue('background');
						var reportNameObj =  Ext.getCmp('bgReportName');
						reportNameObj.show();
						reportNameObj.focus();
						return false;
					}
					else if(btnText === "yes")
					{
						me1.submitReportByAjaxCall(params);
					}
				}, this);
			}
			else
			{
				me1.submitReportByAjaxCall(params);
			}
		}
		else
		{
			params += '&servletName=ErExternalMonitorReportC&er_rtype=ExternalMonitorReport&er_ViewName=ErExternalMonitorReport.jsp&er_RmDispName=ExternalMonitorReport';
			params += '&er_trgttype=&forwardto=ExternalMonitorReport&er_bgreportfrom=ExternalMonitorReport&bgenabled=Yes&savereport=save';
			if(rGenType == 'background')
			{
				bgUrl= '/final/servlet/com.eg.ErStartBackGroundReportC';
			}
			else if (rGenType == 'background-csv')
			{
				bgUrl= "../servlet/com.eg.ErStartBackGroundReportC?SaveFormat=CSV";
					
			}
			appConstants.LoadingMask.show();
			this.getNomeasurepanel().hide();
			Ext.Ajax.request({
				url:bgUrl,
				scope:this,
				method:'POST',
				params:params,
				success:function(response)
				{
					var resultObj = Ext.getCmp('backGroundPanel');
					appConstants.LoadingMask.hide(); 
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);
					var reportValString = jsonData.reportVal;
					var status = reportValString.status;
					var htmlStr='';
					if(status=='success')
					{
						htmlStr = '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconInformation"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+reportValString.bgstr1+'.</br>'+'<a class="backgroundMsgLink" href='+ reportValString.queryString +'>'+ reportValString.bgstr2 + '</a></div></td></tr></table></td></tr></table>';
					}
					else if ( status == 'duplicate' )
					{
						htmlStr = '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconExclamation"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+reportValString.bgstr1+'.</br>'+'<a class="backgroundMsgLink" href='+ reportValString.queryString +'>'+ reportValString.bgstr2 + '</a></div></td></tr></table></td></tr></table>';
					}
					resultObj.update(htmlStr);
					resultObj.show();
				}
			});
		}
	},
	submitReportByAjaxCall:function(params)
	{
		appConstants.LoadingMask.show();
		params += '&er_view=submit';
		var me=this;
		var url='/final/servlet/com.eg.ErExternalMonitorReportC';
		this.getNomeasurepanel().hide();
		this.getBackGroundPanel().hide();
		Ext.Ajax.request({
			url:url,
			scope:this,
			method:'POST',
			params:params,
			success:function(response)
			{
				var resultPanelObj = Ext.getCmp('resultPanel');
				resultPanelObj.removeAll();		
				var jsonObject=response.responseText;
				var jsonData=Ext.decode(jsonObject);				
				resultPanelObj.show();
				
				if(jsonData.isData != undefined && jsonData.isData)
				{
					Ext.getCmp("bookletTool").setDisabled(false);
					Ext.getCmp("saveTool").setDisabled(false);
					Ext.getCmp("printTool").setDisabled(false);
					Ext.getCmp("mailTool").setDisabled(false);					
					Ext.getCmp('selectionDetails').setSelectionDetailsData(jsonData.selectionDetails);	
					try
					{
						if(jsonData.chartView != undefined && jsonData.chartView)
						{
							Ext.getCmp("csvTool").setDisabled(true);
							var eachColumnArry=new Array();
							var testPanelList=jsonData.testPanelList;
							for(var testPanel in testPanelList)
							{
								var eachPanel=testPanelList[testPanel];
								if(eachPanel.type != undefined)
								{
									if(eachPanel.type=='anyChart')
										eachColumnArry.push(me.getAnyChart(eachPanel));
									else if(eachPanel.type=='flowChart')
										eachColumnArry.push(me.getFlowChart(eachPanel));
									else if(eachPanel.type=='digitalWithChart')
										eachColumnArry.push(me.getDigitalWithChart(eachPanel));
									else if(eachPanel.type=='overviewPanel')
										eachColumnArry.push(me.getOverviewPanel(eachPanel));
								}	
							}
							resultPanelObj.add({
								xtype:'panel',
								layout:{
									type:'vbox',
									align:'stretch'
								},
								scroll:true,
								autoScroll:true,
								defaults:{
									xtype:'panel',
									ui:'newGraphPanel',
									columnWidth:1,
									margin:'0 2 0 0',
									bodyPadding: '0 10 10 10',
								},
								items:eachColumnArry
							});	
						}
						else
						{
							Ext.getCmp("csvTool").setDisabled(false);
							var appDetailData=me.getGrid('grid0',jsonData);
							resultPanelObj.add(appDetailData);
						}
						this.getNomeasurepanel().hide();
					}
					catch (e)
					{
						console.log("==Exception==>>>>"+e);
					}
				}
				else
				{
					this.disableTools();
					resultPanelObj.hide();
					this.getNomeasurepanel().show();			
					Ext.getCmp('panelinsidetoggle').setDisabled(true);
				}
				appConstants.LoadingMask.hide();	
			}
		});
	},
	getOverviewPanel:function(eachMainPanel)
	{
		var eachPanelTitle=eachMainPanel.title;
		var type=eachMainPanel.type;
		var eachPanelHeight=eachMainPanel.panelHeight;
		var subPanels=eachMainPanel.subPanels;
		var me=this;
		var internalSubPanelName=subPanels[0].internalSubPanelName;
		var params = me.getQueryString();
		var paramNew=params;
		return {
			xtype:'panel',
			margin:'0 10 10 10',
			bodyPadding:'0 0 4 0',
			padding:0,
			ui:'newGraphPanel',
			title:eachPanelTitle,
			height:parseFloat(eachPanelHeight),
			id:type+internalSubPanelName,
			name:internalSubPanelName,
			type:type,
			layout:{
				type:'hbox',
				align:'stretch'
			},
			defaults:{
				//flex:.22
			},
			items:[],
			listeners:{
			boxready:function(obj){		
				var initMask = new Ext.LoadMask(this.getEl(),{msg : "Loading ..."});
				initMask.show();
				var url='/final/servlet/com.eg.ErExternalMonitorReportC';
				params=paramNew+'&chartView=yes&panelName='+this.name+'&type='+this.type+'&er_view=submit';						
				Ext.Ajax.request({
					url:url,
					params:params,
					scope:this,
					success:function(response){		
						initMask.hide();
						var jsonObject=response.responseText;
						var jsonData=Ext.decode(jsonObject);								
						me.loadChart(jsonData,this.id,this.type,this.name,this.height,'');
					},
					failure:function(err)
					{
						Ext.MessageBox.alert("Error occured in ExternalMonitorReport.jsp page");
					}
				});
			}
		}
		};
	},
	getDigitalWithChart:function(eachMainPanel)
	{
		var eachPanelTitle=eachMainPanel.title;
		var type=eachMainPanel.type;
		var eachPanelHeight=eachMainPanel.panelHeight;
		var panelColWidth=eachMainPanel.panelColWidth;
		var subPanels=eachMainPanel.subPanels;
		var me=this;
		var subPanelArry=new Array();
		for(var s in subPanels)
		{
			var eachSubPanel=subPanels[s];
			var subTitle=eachSubPanel.title;
			var internalSubPanelName=eachSubPanel.internalSubPanelName;
			var params = me.getQueryString();
			var paramNew=params;
			subPanelArry.push({
				xtype:'container',
				id:type+internalSubPanelName,
				name:internalSubPanelName,
				type:type,
				margin:'0 0 0 10',
				cls:eachSubPanel.lineCls,
				height:parseFloat(eachPanelHeight),
				items:[],
				listeners:{
					boxready:function(obj){		
						var initMask = new Ext.LoadMask(this.getEl(),{msg : "Loading ..."});
						initMask.show();
						var url='/final/servlet/com.eg.ErExternalMonitorReportC';	
						params=paramNew+'&chartView=yes&panelName='+this.name+'&type='+this.type+'&er_view=submit';						
						Ext.Ajax.request({
							url:url,
							params:params,
							scope:this,
							success:function(response){		
								initMask.hide();
								var jsonObject=response.responseText;
								var jsonData=Ext.decode(jsonObject);								
								me.loadChart(jsonData,this.id,this.type,this.name,this.height,'');
							},
							failure:function(err)
							{
								Ext.MessageBox.alert("Error occured in ExternalMonitorReport.jsp page");
							}
						});
					}
				}
			});
		}
		return {
			xtype:'panel',
			margin:'0 10 10 10',
			ui:'newGraphPanel',
			title:eachPanelTitle,
			height:eachPanelHeight,
			layout:{
				type:'column',
				align:'stretch'
			},
			defaults:{
				columnWidth:panelColWidth,
			},
			items:subPanelArry		
		};
	},
	getFlowChart:function(eachMainPanel)
	{
		var eachPanelTitle=eachMainPanel.title;
		var type=eachMainPanel.type;
		var eachPanelHeight=eachMainPanel.panelHeight;
		var subPanels=eachMainPanel.subPanels;
		var subPanelArry=new Array();
		var me=this;
		for(var s in subPanels)
		{
			var eachSubPanel=subPanels[s];
			var subTitle=eachSubPanel.title;
			var internalSubPanelName=eachSubPanel.internalSubPanelName;
			var params = me.getQueryString();
			var paramNew=params;
			subPanelArry.push({
				xtype:'container',
				id:type+internalSubPanelName,
				name:internalSubPanelName,
				type:type,
				margin:'0 0 0 10',
				cls:eachSubPanel.lineCls,
				height:parseFloat(eachPanelHeight),
				items:[],
				listeners:{
					boxready:function(obj){		
						var initMask = new Ext.LoadMask(this.getEl(),{msg : "Loading ..."});
						initMask.show();
						var url='/final/servlet/com.eg.ErExternalMonitorReportC';	
						params=paramNew+'&chartView=yes&panelName='+this.name+'&type='+this.type+'&er_view=submit';						
						Ext.Ajax.request({
							url:url,
							params:params,
							scope:this,
							success:function(response){		
								initMask.hide();
								var jsonObject=response.responseText;
								var jsonData=Ext.decode(jsonObject);								
								//me.loadChart(jsonData,this.id,this.type,this.name,this.height,'');
							},
							failure:function(err)
							{
								Ext.MessageBox.alert("Error occured in ExternalMonitorReport.jsp page");
							}
						});
					}
				}
			});
		}
		return {
			xtype:'panel',
			margin:'0 10 10 10',
			ui:'newGraphPanel',
			title:eachPanelTitle,
			height:eachPanelHeight,
			layout:{
				type:'column',
				align:'stretch'
			},
			defaults:{
				columnWidth:.5,
			},
			items:subPanelArry				
		};
	},	
	getAnyChart:function(eachMainPanel)
	{
		var eachPanelTitle=eachMainPanel.title;
		var type=eachMainPanel.type;
		var eachPanelHeight=eachMainPanel.panelHeight;
		var subPanels=eachMainPanel.subPanels;
		var subPanelArry=new Array();
		var me=this;
		for(var s in subPanels)
		{
			var eachSubPanel=subPanels[s];
			var subTitle=eachSubPanel.title;
			var internalSubPanelName=eachSubPanel.internalSubPanelName;
			var params = me.getQueryString();
			var paramNew=params;			
			subPanelArry.push({
				xtype:'container',
				id:type+internalSubPanelName,
				name:internalSubPanelName,
				type:type,
				margin:'0 0 0 0',
				padding:'10 0 0 0',
				panelIndex:s,
				cls:eachSubPanel.lineCls,
				height:parseFloat(eachPanelHeight),
				items:[],
				listeners:{
					boxready:function(obj){		
						var initMask = new Ext.LoadMask(this.getEl(),{msg : "Loading ..."});
						initMask.show();
						var url='/final/servlet/com.eg.ErExternalMonitorReportC';	
						params=paramNew+'&chartView=yes&panelName='+this.name+'&type='+this.type+'&er_view=submit';						
						Ext.Ajax.request({
							url:url,
							params:params,
							scope:this,
							success:function(response){		
								initMask.hide();
								var jsonObject=response.responseText;
								var jsonData=Ext.decode(jsonObject);								
								me.loadChart(jsonData,this.id,this.type,this.name,this.height,this.panelIndex);
							},
							failure:function(err)
							{
								Ext.MessageBox.alert("Error occured in ExternalMonitorReport.jsp page");
							}
						});
					}
				}
			});	
		}
		return {
			xtype:'panel',
			margin:'0 10 10 10',
			ui:'newGraphPanel',
			title:eachPanelTitle,
			height:eachPanelHeight,
			layout:{
				type:'column',
				align:'stretch'
			},
			defaults:{
				columnWidth:.5,
			},
			items:subPanelArry				
		};
	},
	loadChart:function(jsonData,widgetId,type,name,height,temp)
	{
		var chartCollection=jsonData['chartCollection'];
		if(jsonData['gridCollection'] != undefined)
		{
			chartCollection=jsonData['gridCollection'];
		}
		var isData=jsonData['isData'];
		var panelIdStr=Ext.getCmp(widgetId);
		panelIdStr.removeAll();
		var template1Arry;
		var titleMargin='0 0 10 10';
		if(temp.length>0 && temp%2==0)
		{
			titleMargin='0 0 10 0';
		}
		if(isData)
		{
			var me=this;
			switch(type)	
			{
				case "anyChart":
				{
					template1Arry=new Array();
					if(chartCollection.chartType != undefined && chartCollection.chartType=='grid')
					{						
						template1Arry.push({
						xtype:'container',
						margin:titleMargin,
						html:'<span class="newFont_bold13">'+chartCollection.subPanelTitle+'</span>',
						});
						template1Arry.push(me.getGrid(this.id,jsonData));
					}
					else
					{
						template1Arry.push({
							xtype:'container',
							margin:titleMargin,
							html:'<span class="newFont_bold13">'+chartCollection.subPanelTitle+'</span>',
						});
						template1Arry.push({
							xtype:'container',
							border:true,
							id:'chartId'+widgetId,
							height:height-40,
							flex:1,
							listeners:{
								'boxready':function(c){
									try
									{									
										var lineChart = {};									
										if(chartCollection.TimeFormatOut != undefined)
										{
											lineChart = jQuery.extend(true, {}, getHighChartsInstance(this.id,this.height,""), lineChart);
										}
										else
											lineChart = jQuery.extend(true, {}, getHighChartsBarInstance(this.id,this.height,''), lineChart);
										lineChart.setData(chartCollection,currentDateFormat,'');
										lineChart.drawChart();
																			
									}
									catch (e)
									{
										console.log("template anychart exveption::::::"+this.id+"===>>"+e);
									}
								}
							}
						});
					}					
					panelIdStr.add(template1Arry);
					break;
				}
				case "digitalWithChart":
				{
					var digitalData=chartCollection.digitalObj;
					template1Arry=new Array();
					template1Arry.push({
						xtype:'container',
						html:'<table align="center"><tr><td align="right" style="padding-right:5px"><div class="'+digitalData.imageCls+'"></div></td><td style="text-align:left;padding-left:5px" class="newFont_bold28">'+digitalData.value+'</td></tr><tr><td align="right" colspan="2" style="padding:5px 5px 10px 5px"><span class="newFont_normal13">'+digitalData.title+'</span></td></tr></table>',
						width:'100%',
						style:{
							textAlign:'center',
							width:'50px'
						}
					});
					template1Arry.push({
						xtype:'container',
						border:true,
						id:'chartId'+widgetId,
						height:height-60,
						flex:1,
						listeners:{
							'boxready':function(c){
								try
								{
									var lineChart = {};			
									if(chartCollection.TimeFormatOut != undefined)
									{
										//lineChart = jQuery.extend(true, {}, getHighChartsInstance(this.id,this.height,""), lineChart);
									}
									else
										lineChart = jQuery.extend(true, {}, getHighChartsBarInstance(this.id,this.height,''), lineChart);
									lineChart.setData(chartCollection,currentDateFormat,'');
									lineChart.drawChart();
								}
								catch (e)
								{
									console.log("template digitalWithChart exveption::::::"+this.id+"===>>"+e);
								}
							}
						}
					});
					panelIdStr.add(template1Arry);
					break;
				}
				case "overviewPanel":
				{
					template1Arry=new Array();
					if(chartCollection.fistChartData != undefined)
					{
						var fistChartData=chartCollection.fistChartData;		
						var firstSummaryList=fistChartData.firstSummaryList;
						if(firstSummaryList != undefined && firstSummaryList.length>0)
						{
							for(var k in firstSummaryList)
							{
								var digitalData=firstSummaryList[k];
								if(digitalData.value != undefined)
								{
									template1Arry.push({
										xtype:'container',
										autoSize:true,
										align:'center',
										height:height,
										flex:.22,									
										layout:{
											type:'vbox',
											align:'stretch',
											pack:'center'
										},
										defaults:
										{
											padding:'6px 5px 5px 5px',
											width:'100%',
											style:{
												textAlign:'center',
												width:'50px'
											}
										},
										items:[
											{
												html:'<table align="center"><tr><td align="right" style="padding-right:5px"><div class="'+digitalData.imageCls+'"></div></td><td style="text-align:left;padding-left:5px" class="newFont_bold28">'+digitalData.value+'</td></td></table>',
												
											},
											{
												html:'<span class="newFont_normal13">'+digitalData.name+'</span>'
											}
										]
									});
								}
							}
						}
						template1Arry.push({
							xtype:'container',
							align:'center',
							id:'chartId'+widgetId,
							flex:.34,
							height:height,
							autoSize:true,	
							border:true,	
							layout:{
								type:'hbox',
								align:'stretch',
							},
							items:[
									{
										xtype:'container',
										align:'center',
										id:'chartId1'+widgetId,
										flex:.50,
										border:true,
										height:height,
										//style:{'border':'1px solid blue'},	
										margin:'0 0 0 0',
										align:'stretch',
										listeners:{
											'boxready':function(c){
												try
												{
													var lineChart = {};
													lineChart = jQuery.extend(true, {}, getHighChartsBarInstance(this.id,this.height,this.height), lineChart);
													lineChart.setData(fistChartData.fistSummaryDonut,currentDateFormat,'');
													lineChart.drawChart();

												}
												catch (e)
												{
													console.log("template overviewpanel exveption::::::"+this.id+"===>>"+e)
												}
											},
											resize:function(){
												if(!Ext.isEmpty($(this.id).highcharts()))
												{
													$(this.id).highcharts().reflow();
												}
											}
										
										}
									},
									{
										xtype:'container',									
										id:'chartId2'+widgetId,
										flex:.50,
										height:height,
										border:true,
										layout:{
											type:'vbox',
											align:'stretch',
											pack:'center'
										},
										items:[{
											xtype:'container',
											html:'<table cellpadding="0" cellspacing="0" border="0" ><tr></tr><tr><td><div style="background-color:'+fistChartData.successColor+';width:6px;height:6px;border-radius:4px;">&nbsp;</div></td><td style="padding:2px 10px;" class="font_normal11">Success</td><td class="font_normal11">'+fistChartData.successPercent+'</td></tr><tr><td><div style="background-color:'+fistChartData.failureColor+';width:6px;height:6px;border-radius:4px;">&nbsp;</div></td><td style="padding:2px 10px;" class="font_normal11">Failure</td><td class="font_normal11">'+fistChartData.failurePercent+'</td></tr></table>',
										}]
										
									}
									
								],							
						});				
					}
					panelIdStr.add(template1Arry);
					break;
				}
				default:
				{
					break;
				}
			}
		}
		else
		{
			template1Arry=new Array();
			var subPanelTitle='';
			if(chartCollection.subPanelTitle != undefined)
			{
				subPanelTitle=chartCollection.subPanelTitle;
			}
			template1Arry.push({
					xtype:'container',
					padding:titleMargin,
					html:'<span class="newFont_bold13">'+subPanelTitle+'</span>',
			});
			template1Arry.push(this.getNoMeasure());
			panelIdStr.add(template1Arry);
		}
	},
	getGrid:function(id,jsonData)
	{
		var appDetailData='';
		var me=this;
		var columnsArr=new Array();
		var fieldsArr=new Array();
		var gridCollection=jsonData.gridCollection;
		var columns=gridCollection.gridColumn;
		var data=gridCollection.gridData;
		var requestQueryString=gridCollection.requestQueryString;
		var needGridColLock=false;
		if(columns.length>8)
		{
			needGridColLock=true;
		}
		for (var k in columns)
		{
			var col=columns[k];	
			var headerAlign='center';		
			if(col.align != undefined && col.align.length>0)
				headerAlign=col.align;
			var headerCol=col.name;
			var indexCol=col.name;
			var colLock=false;
			if(col.lock != undefined && col.lock=='true')
				colLock=true;
			if(headerCol != undefined && headerCol.indexOf("(") != -1)
			{
				headerCol=headerCol.substring(0,headerCol.indexOf("("))+'<br>'+headerCol.substring(headerCol.indexOf("(")+1,headerCol.lastIndexOf(")"))
			}
			var colWidth=100;
			if(col.width != undefined && col.width.length>0)
				colWidth=parseFloat(col.width);
			var subColArry;			
			if(col.subColumnArry != undefined && col.subColumnArry.length>0)
			{
				subColArry=new Array();
				var subColumn=col.subColumnArry;
				for(var subKey in subColumn)
				{
					var eachSubColumn=subColumn[subKey];
					var indexSubCol=indexCol+eachSubColumn;
					fieldsArr.push(indexSubCol);
					subColArry.push({
						header:eachSubColumn,
						align:'center',
						dataIndex:indexSubCol,
						sortable:true,
						renderer:function(value,meta,record,rowIndex,colIndex,store,view){
							var strLink='';
							if(value != undefined && value.indexOf("~DDLink") != -1)
							{
								strLink=value.substring(value.indexOf("~DDLink")+7);
								value=value.substring(0,value.indexOf("~DDLink"));
							}
							if(value != undefined && value.indexOf("$") != -1)
							{
								var bgColor=value.substring(value.indexOf("$")+1);
								value=value.substring(0,value.indexOf("$"));
								meta.tdCls="iconColumn";
								value="<div style='position:relative;margin:2px auto 2px auto;width:50px;padding:3px 10px 1px 10px;color:#ffffff;border-radius:2px;background:"+bgColor+";'>"+value+"</div>";
							}
							if(strLink.length>0)
							{
								strLink=requestQueryString+"&"+strLink;
								value="<a class='anchorLinkDefault' href='javascript:void(0);' onClick='javascript:linkURL(\""+strLink+"\")'>"+value+"</a>";
							}
							return value;
						},
						doSort: function(state)
						{
							var ds = this.up('grid').store;
							var field = this.getSortParam();
							ds.sort({
								property: field,
								direction: state,
								sorterFn: function(v1, v2){
									v1 = v1.get(field);
									v2 = v2.get(field);
									if(v1.indexOf("~DDLink") != -1)
										v1=v1.substring(0,v1.indexOf("~DDLink"));
									if(v2.indexOf("~DDLink") != -1)
										v2=v2.substring(0,v2.indexOf("~DDLink"));
									if(v1.indexOf("$") != -1)
										v1=v1.substring(0,v1.indexOf("$"));
									if(v2.indexOf("$") != -1)
										v2=v2.substring(0,v2.indexOf("$"));
									if(!isNaN(v1) && !isNaN(v2))
									{
											v1 = Ext.isNumber(v1) ? v1 : parseFloat(String(v1), 10); 
											v2 = Ext.isNumber(v2) ? v2 : parseFloat(String(v2), 10);
											if (state=='ASC')
											{
												v1= isNaN(v1) ? 999999 : v1;
												v2= isNaN(v2) ? 999999 : v2;
											}
											else
											{
												v1= isNaN(v1) ? 0 : v1;

												v2= isNaN(v2) ? 0 : v2;
											}
									}
									else if(!isNaN(new Date(v1)) && !isNaN(new Date(v2)))
									{
										v2=new Date(v2).getTime(); 
										v1=new Date(v1).getTime(); 
									}
									// transform v1 and v2 here
									return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
								}
							});
						}
					});
				}
				var colObj={
					header: headerCol,
					align:headerAlign,
					width:colWidth,
					dataIndex:indexCol,
					sortable:true,
					columns:subColArry
					};
				if(needGridColLock && colLock)
				{
					colObj.locked=true;
				}
				columnsArr.push(colObj);
			
			}
			else
			{
				fieldsArr.push(col);
				var colObj={
				header:headerCol,
				align:headerAlign,
				height:55,
				width:colWidth,
				dataIndex:indexCol,
				sortable:true,
				renderer:function(value,meta,record,rowIndex,colIndex,store,view){
					var strLink='';
					if(value != undefined && value.indexOf("~DDLink") != -1)
					{
						strLink=value.substring(value.indexOf("~DDLink")+7);
						value=value.substring(0,value.indexOf("~DDLink"));
					}
					if(value != undefined && value.indexOf("$") != -1)
					{
						var bgColor=value.substring(value.indexOf("$")+1);
						value=value.substring(0,value.indexOf("$"));
						meta.tdCls="iconColumn";
						value="<div style='position:relative;margin:2px auto 2px auto;width:50px;padding:3px 10px 1px 10px;color:#ffffff;border-radius:2px;background:"+bgColor+";'>"+value+"</div>";
					}
					if(strLink.length>0)
					{
						strLink=requestQueryString+"&"+strLink;
						value="<a class='anchorLinkDefault' href='javascript:void(0);' onClick='javascript:linkURL(\""+strLink+"\")'>"+value+"</a>";
					}
					if(value != undefined && value.indexOf("stageColor") != -1)
					{
						var bgColor="#EE2C24";
						bgColor=value.substring(value.indexOf("stageColor")+10);
						value='<div style="background-color:'+bgColor+';width:7px;height:7px;border-radius:3px;">&nbsp;</div>';
					}
					return value;
				},
				doSort: function(state)
				{
					var ds = this.up('grid').store;
					var field = this.getSortParam();
					ds.sort({
						property: field,
						direction: state,
						sorterFn: function(v1, v2){
							v1 = v1.get(field);
							v2 = v2.get(field);
							if(v1.indexOf("~DDLink") != -1)
								v1=v1.substring(0,v1.indexOf("~DDLink"));
							if(v2.indexOf("~DDLink") != -1)
								v2=v2.substring(0,v2.indexOf("~DDLink"));
							if(v1.indexOf("$") != -1)
								v1=v1.substring(0,v1.indexOf("$"));
							if(v2.indexOf("$") != -1)
								v2=v2.substring(0,v2.indexOf("$"));
							if(!isNaN(v1) && !isNaN(v2))
							{
									v1 = Ext.isNumber(v1) ? v1 : parseFloat(String(v1), 10); 
									v2 = Ext.isNumber(v2) ? v2 : parseFloat(String(v2), 10);
									if (state=='ASC')
									{
										v1= isNaN(v1) ? 999999 : v1;
										v2= isNaN(v2) ? 999999 : v2;
									}
									else
									{
										v1= isNaN(v1) ? 0 : v1;

										v2= isNaN(v2) ? 0 : v2;
									}
							}
							else if(!isNaN(new Date(v1)) && !isNaN(new Date(v2)))
							{
								v2=new Date(v2).getTime(); 
								v1=new Date(v1).getTime(); 
							}
							// transform v1 and v2 here
							return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
						}
					});
				}};
				if(needGridColLock && colLock)
				{
					colObj.locked=true;
				}
				columnsArr.push(colObj);
			}
		}
		var gridPageSize=7;
		if(id != undefined && id=='grid0')
			gridPageSize=15;
		var store=Ext.create('Ext.data.ArrayStore',{
			fields:fieldsArr,
			proxy:{
				type:'pagingmemory',
				reader:{
					type:'array'
				}
			},
			pageSize:gridPageSize,
			sortable:true,
			autoLoad:true,
			remoteSort:true,
			data:data
		});
		var activePage=1;
		var isPagingHiddenDetailApp=false;
		if(data.length<=gridPageSize)
		{
			isPagingHiddenDetailApp=true;
		}
		else
		{
			isPagingHiddenDetailApp=false;
		}
		var forcefit=true;
		if(columnsArr != undefined && columnsArr.length>8)
			forcefit=false;
		var title='';
		var panelUi='';
		if(id != undefined && id=='grid0')
		{
			title=gridCollection.title;
			panelUi='newGraphPanel';
		}
		var marg = '0 10 10 10';
		var gridmarg = '0 10 10 10';
		if(title == '' ){
			marg = '0';
			gridmarg = '0 0 5 10';
		}
		appDetailData=Ext.create('Ext.panel.Panel',{
			title:title,
			ui:panelUi,
			margin:marg,
			items:[
				{
					xtype:'customgrid',
					sortableColumns: true,
					ui:'newGridPanel',
					id:id,
					margin:gridmarg,
					border:true,
					scroll: true,
					autoScroll:true,
					forceFit:forcefit,
					store: store,
					columns: columnsArr,
					listeners: 
					{
						render:function(obj)
						{
							//this.getView().on('refresh', this.updateRowSpan, this);// no need row span beacusue initially we put order by success % column and also grid lock also used				
						}
					},
					updateRowSpan: function() {
						var columns = this.columns,
							view = this.getView(),
							store = this.getStore(),
							rowCount = store.getCount(),
							
							column = columns[0],
							dataIndex = column.dataIndex,
							
							spanCell = null,
							spanCount = null;
							spanValue = null;
						
						for (var row = 0; row < rowCount; ++row) {
							var cell = view.getCellByPosition({ row: row, column: 0 }).dom,
								record = store.getAt(row),
								value = record.get(dataIndex);
							if(value != undefined && value.indexOf("~DDLink") != -1)
							{
								value=value.substring(0,value.indexOf("~DDLink"));
							}
							
							if (spanValue != value) {
								if (spanCell !== null) {
									spanCell.rowSpan = spanCount;
								}
								
								Ext.fly(cell).setStyle('display', '');
								spanCell = cell;
								spanCount = 1;
								spanValue = value;
							} else {
								spanCount++;
								Ext.fly(cell).setStyle('display', 'none');
							}
						}
						
						if (spanCell !== null) {
							spanCell.rowSpan = spanCount;
						}
					},
					dockedItems:[{
						xtype:'pagingtoolbar',
						cls:'newPagination',
						dock: 'bottom',
						store: store,
						hidden:isPagingHiddenDetailApp,
						displayInfo: true,
						displayMsg: 'Displaying topics {0} - {1} of {2}',
						emptyMsg: "No topics to display",
						listeners: {
							change : function(thisd, params)
							{   
								if(!Ext.isEmpty(params))
									activePage = params.currentPage;
								else
									activePage=1; 
							}
						}
					}]
				}
			],
		});
		return appDetailData;
	},
	disableTools: function(){
		Ext.getCmp("bookletTool").setDisabled(true);
		Ext.getCmp("saveTool").setDisabled(true);
		Ext.getCmp("printTool").setDisabled(true);
		Ext.getCmp("mailTool").setDisabled(true);
		Ext.getCmp("csvTool").setDisabled(true);
	},
	/*excludeWeekendsChange: function()
	{
		var excWeek=Ext.getCmp("er_excwe");
		var excDays=Ext.getCmp('excludeDays');
		if(excWeek.getValue()=="Yes")
		{	
			excDays.show();
			var excludeMessageData = appConstants.defaultLoadData['excludeMessage'];
			excDays.update(excludeMessageData);
		}
		else
		{
			excDays.hide();
		}
	 },*/
	showConfigDropdown:function()
	{
		isSettingsEnabled = true;
		var tpl = new Ext.XTemplate('<div style="float:left;margin:0px 0px 0px 0px">More Options</div><div style="text-align:right;float:right;"><div class="iconCloseNew" id="closeSettings"></div></div>');
		//config dropdown mode
		Ext.create('Ext.container.Container',{
			width:565,
			//padding:5,
			id:'configMod',
			ui:'settingsWindowContainer',
			items:[
				{
					xtype:'container',
					cls:'configMode_popupArrow',
					style:{'top':'-14px','left':'355px'}
				},
				{
					xtype:'container',
					html:tpl.apply(),
					cls:'containerHeader',
					style:{'top':'0px','margin':'0px'}
				},
				{
					xtype:'externalMonitorAppSettings',
					parent:this
				}
			],
			renderTo:'viewMain'
		});
		var timefromObj = Ext.getCmp('timefrom');
		timefromObj.setValue(appConstants.defaultLoadData.sHrForSetting);
		 
		var minfromObj = Ext.getCmp('minfrom');
		minfromObj.setValue(appConstants.defaultLoadData.sMinForSetting);
		 
		var timetoObj = Ext.getCmp('timeto');
		timetoObj.setValue(appConstants.defaultLoadData.eHourForSetting);
		 
		var mintoObj = Ext.getCmp('minto');
		mintoObj.setValue(appConstants.defaultLoadData.eMinForSetting);
 
		var externalMonitorAppSettingsForm=this.getExternalMonitorAppSettings().getForm();
		externalMonitorAppSettingsForm.findField('successCritical').setValue(appConstants.defaultLoadData.successCritical);
		externalMonitorAppSettingsForm.findField('successMajor').setValue(appConstants.defaultLoadData.successMajor);
		externalMonitorAppSettingsForm.findField('successMinor').setValue(appConstants.defaultLoadData.successMinor);

		var erExcweObj = Ext.getCmp('er_excwe');
		erExcweObj.getStore().loadRawData(appConstants.defaultLoadData.excludeWeekCombo);
		erExcweObj.setValue(appConstants.defaultLoadData.sExclweekUI);
			 

		var reportGen = Ext.getCmp('reportGeneration');
		reportGen.getStore().loadRawData(appConstants.defaultLoadData.reportGenerationCombo);
		reportGen.setValue(appConstants.defaultLoadData.sRepGenType);
	},
	closeSetting:function()
	{
		Ext.getCmp('moreOptionCloseId').show();
		var me = this;
		Ext.get('closeSettings').on('click', function() {
			if(me.validateSettings())
			{
				me.validateAndCloseSettings();
			}
		});
	},
	validateAndCloseSettings:function()
	{
		if(this.validateSettings())
		{
			Ext.get('configMod').animate({
				duration: 500,
				to: 
				{
					y: -500
				}
			});
			return true;
		}
	},
	closeSettingAndSubmit:function()
	{
		if(this.validateAndCloseSettings())
		{
			this.submitReport();
		}
	},
	validateSettings :function(){
		var reportgen=Ext.getCmp('reportGeneration').getValue();
		if ( reportgen!=null && (reportgen == 'background' || reportgen == 'background-csv')){
			var reportName = Ext.getCmp('bgReportName').getValue();
			if(!validateTextBoxWithSpecialChars(reportName,'Attachment',true))
				return false;
		}		
		return true;
	},
	getQueryString:function()
	{
		var isSettingsOk = true;
		var reportFor = Ext.getCmp('er_type').getValue();
		var er_option = Ext.getCmp('er_option').getValue();
		var er_compType = Ext.getCmp('er_compType').getValue();
		var er_Component = Ext.getCmp('er_Component').getValue();
		if(er_Component.length<1 || er_Component[0] == '-1')
		{
			this.showMessage('Components is Not Applicable');
			return false;
		}
		if (er_Component.length > 1 && (er_Component.indexOf('All') > -1 || er_Component.indexOf('all') > -1))
		{
			this.showMessage('Chosen component group not allowed');
			return false;
		}
		appConstants.reportFor=reportFor;
		var params='&analysisBy='+er_option;
		if(er_option != undefined && er_option != 'Component')
		{
			params += '&er_site='+Ext.getCmp('er_site').getValue();
			params += '&er_subZone='+Ext.getCmp('er_subZone').getValue();
		}
		if(!appConstants.enableMultiCompType)
		{
			params += "&er_compType="+er_compType;
		}
		else
		{
			for(var c=0;c<er_compType.length;c++)
			{
				params += "&er_compType="+ er_compType[c];
			}
		}
		
		var drillParams=appConstants.defaultLoadData.drillParams;
		params += "&er_Component1="+drillParams.er_Component;
		params += "&er_externalAgent1="+drillParams.er_externalAgent;
		if(appConstants.reportFor != undefined && !appConstants.applicationComboHidden)
			params += "&er_application1="+drillParams.er_application;
				
		for(var c=0;c<er_Component.length;c++)
		{
			params += "&er_Component="+er_Component[c];
		}
		var er_externalAgent=Ext.getCmp('er_externalAgent').getValue();
		params+='&er_externalAgent='+er_externalAgent;
		if(appConstants.reportFor != undefined && !appConstants.applicationComboHidden)
		{
			var er_application=Ext.getCmp('er_application').getValue();
			params+='&er_application='+er_application;
		}
		var timeline = Ext.getCmp("er_timeline").getValue();
		var startDate = Ext.getCmp("er_stdate").getValue();
		var startHr = Ext.getCmp("er_sthr").getValue();
		var endDate = Ext.getCmp("er_enddate").getValue();
		var endHr = Ext.getCmp("er_endhr").getValue()
		startDate.setHours(startHr);
		endDate.setHours(endHr); 
		if(!checkDateTime(startDate,endDate))
		{
			return false;
		}
		startDate = Ext.getCmp("er_stdate").dataArray;
		startHr = Ext.getCmp("er_sthr").dataArray;
		endDate = Ext.getCmp("er_enddate").dataArray;
		endHr = Ext.getCmp("er_endhr").dataArray;
		var params1 = '&er_timeline='+timeline+'&startdate='+startDate+'&enddate='+endDate+'&starthr='+startHr+'&endhr='+endHr+'&startmin='+mgr_stmin+'&endmin='+mgr_enmin+'&inidate='+appConstants.defaultLoadData.inidate;
		var params2 = '';
		if(isSettingsEnabled)
		{
			var timeFrom = Ext.getCmp("timefrom").getValue();
			var minFrom = Ext.getCmp("minfrom").getValue();
			var timeTo = Ext.getCmp("timeto").getValue();
			var minTo = Ext.getCmp("minto").getValue();
			var exculdeWeek = Ext.getCmp("er_excwe").getValue();
			var rGenType = Ext.getCmp("reportGeneration").getValue();
			var reportName = '';

			if(!checkTimePeriod(timeFrom,minFrom,timeTo,minTo))
			{
				return false;
			}
			if(rGenType != 'foreground')
			{
				reportName = Ext.getCmp("bgReportName").getValue();
				if(!validateTextBoxWithSpecialChars(reportName,'Attachment',true))
				{
					return false;
				}
			}
			params2 = '&hourFromUI='+timeFrom+'&minFromUI='+minFrom+'&hourToUI='+timeTo+'&minToUI='+minTo+'&exclweek='+exculdeWeek+'&rGenType='+rGenType+'&bg_reportname='+reportName;
			params2+='&successCritical='+Ext.getCmp('successCritical').getValue()+'&successMajor='+Ext.getCmp('successMajor').getValue()+'&successMinor='+Ext.getCmp('successMinor').getValue();
			params2+= '&er_reportgenration='+rGenType+'&bg_reportname='+reportName;
		}
		var userID   = '&userID='+appConstants.defaultLoadData.loginid;
		params += params1;
		params += params2;
		params += userID;
		params+='&reportFor='+appConstants.reportFor;
		if(appConstants.isDrillDown != undefined && appConstants.isDrillDown=='true')
			params+='&drillDown=true';
		return params;
	},
	reportGenChange:function()
	{
		Ext.getCmp('resultPanel').hide();
		var reportGenType=Ext.getCmp('reportGeneration').getValue();
		if(reportGenType != 'foreground')
		{
			Ext.getCmp('bgReportName').setValue("");
			Ext.getCmp('bgReportName').show();
			Ext.getCmp('moreOptionCloseId').hide();
			Ext.getCmp('submitViaSetting').show();
		}
		else
		{
			Ext.getCmp('bgReportName').hide();
			Ext.getCmp('submitViaSetting').hide();
			Ext.getCmp('moreOptionCloseId').show();
		}
	},
	showMessage:function(msg)
	{
		Ext.MessageBox.show({
			title:'External Monitor Report',
			msg:msg,
			buttons:Ext.MessageBox.OK,
			icon:Ext.MessageBox.WARNING			
		});
	},
	toggleForm:function(obj)
	{
		var ornt=Ext.getCmp('mainform');	
		Ext.getCmp('panelinsidetoggle').show();	
		if(appConstants.isDrillDown != undefined && appConstants.isDrillDown=='true')
			return;				
		if(ornt.isHidden())
		{
			ornt.show();
			Ext.getCmp('selectionDetails').hide();
		}
		else
		{
			ornt.hide();
			Ext.getCmp('selectionDetails').show();
		}
	},
	getNoMeasure:function()
	{
		return {
					xtype:'container',
					flex:1,
					html:'<table width="100%" height="100%"><tr><td align="center" valign="middle"><img src="/final/images/'+strSkin+'/nomeasures_custom.png" /></td></tr></table>'
				};
	},
	getNumberFormat:function(value)
	{
		if(!isNaN(value) && !isNaN(parseFloat(value))||value == '-')
		{
			if(value!=null && value.indexOf(".")>-1)
			{
				strDecimal = value.substring(value.indexOf("."));
				str = value.substring(0,value.indexOf("."));
				value='<span class="decimal-align">'+str+'</span><span class="decimal-align2">'+strDecimal+'</span>';
			}
			else
			{
				value='<span class="decimal-align">'+value+'</span>';
			}
		}
		return value;
	}
});