Ext.define('favorite.controller.Favorite', {
	extend : 'Ext.app.Controller',
	views : ['Main'],
	refs : [{
				selector : 'main',
				ref : 'main'
			}, {
				selector : 'favoriteform',
				ref : 'favoriteform'
			}],
	init : function() {
		this.control({
					'main' : {
						'afterrender' : this.initForm
					},
					'main > #parForm >  button[name=save]' : {
						'click' : this.saveFavorite
					},
					'main > #parForm >  button[name=modify]' : {
						'click' : this.modifyFavorite
					},
					'main > #parForm >  button[name=update]' : {
						'click' : this.UpdateSelection
					}
				});
	},
	initForm : function() {
		var thisForm = Ext.getCmp("parForm").getForm();
		Ext.Ajax.request({
					url : '/final/reporter/ErFavoriteService.jsp',
					params:Qstring+'&action=formload',
					scope : this,
					success : function(response) {
						var jsonText = response.responseText;
//						console.log(jsonText);
						var jsonData = Ext.decode(jsonText);
						//alert('showModifyLink---'+showModifyLink);
						if (showModifyLink == 'true')
						{	
 							Ext.getCmp('saveschedule').setTitle('Save Favorite');	
							//Ext.getCmp('saveschedule').getEl().setStyle({margin : '0 0 0 0'});
 							Ext.getCmp('clickModify').show();
							Ext.getCmp('update').show();
 							Ext.getCmp('savedDetails').show();
							Ext.getCmp('favBackButton').show();		   
						} else {
    							Ext.getCmp('save').show();   							
						}
						if (!Ext.isEmpty(jsonData)) {							
							this.getMain().loadData(jsonData);
						}
					}

				});

	},
	modifyFavorite : function(btn){
		//alert("modify Favorite");
		var thisForm = Ext.getCmp("parForm").getForm();
		var fav_name = thisForm.findField("fav_name").getValue();
		var id = thisForm.findField("id").getValue();
		var details = thisForm.findField("details").getValue();
		var er_favorite = thisForm.findField("sharingCombo").getValue();
		var publicUsers = thisForm.findField("publicUsers").getValue();
		var shareUsers = thisForm.findField("shareUsers").getValue();
		var cmd = "Show";
		var fav_Name = true;
		
		if(isDoubleByteEnabled!=null && isDoubleByteEnabled!="undefined" && isDoubleByteEnabled.toLowerCase()=="false")
			fav_Name = validateSingleByte(fav_name);
			
		if(!fav_Name)
		{
			Ext.Msg.show({
						title:'Alert',
						 msg: _checkdoublespace,
						buttons: Ext.Msg.OK,
						icon: Ext.Msg.WARNING
					});
			return;
		}
		
		
		var errorMsg=validateSchNameForAttachment(fav_name,'InLine',true);
					
		if(errorMsg!=true)
		{
			return;					
		}
		
		if(er_favorite=="Share")
		{
			
			var sub="false";
			var shareUsersLen=shareUsers.length;
			
			if(shareUsersLen>0)
			{
				sub="true";
			}
			if(sub=="false")
			{
				Ext.Msg.show({
						title:'Alert',
						 msg: sharingComboAlert,
						buttons: Ext.Msg.OK,
						icon: Ext.Msg.WARNING
					});
				return;
			}
			var list = Ext.getCmp("itemselector-field").toField.boundList;
			var store = list.getStore();
			
			if(store.getCount()>0)
			{
				var tempShareUsrs = '';
				var tmpShareArr = new Array();
				tmpShareArr = shareUsers.split(',');

				for(var su=0;su<tmpShareArr.length;su++)
				{
					var sharUsr = tmpShareArr[su];
					if (su < tmpShareArr.length-1)
					{
						tempShareUsrs += sharUsr+",";
					} else
						tempShareUsrs += sharUsr;
				}
				shareUsers = tempShareUsrs;
			}else
			{
				Ext.Msg.show({
					title:'Alert',
					 msg: 'Please select Atleast one User',
					buttons: Ext.Msg.OK,
					icon: Ext.Msg.WARNING
				});
				return;
			}

		}
	
		
		var loadMask = new Ext.LoadMask(Ext.getBody(), {msg:"Loading ..." });
		loadMask.show();
		
		//alert("details____________"+details);
		var param = "cmd=" +cmd +"&fav_name=" + fav_name + "&id=" + id + "&details="
				+ encodeURI(details) + "&er_favorite=" + er_favorite +"&showFavorite=yes";


		if(er_favorite=='Public')
		{
			param = param+ "&publicUsers=" +publicUsers + "&shareUsers=None";
		}
		else if(er_favorite=='Share')
		{
			param = param+ "&publicUsers=None" + "&shareUsers="+shareUsers;
		}
		else 
		{
			param = param+ "&publicUsers=None" + "&shareUsers=None";
		}

				

				
		var url = '/final/servlet/com.eg.ErFavoriteC?'+param;
		document.location = url;
		/*Ext.Ajax.request({
					url : url,
					params : param,
					scope : this,
					success : function(response) {
						loadMask.hide();
						var jsontext = response.responseText;
						alert(jsontext);
						
						//var jsonData = Ext.decode(jsontext);
						//alert(jsonData);

						if (!Ext.isEmpty(jsontext)) {
							this.getMain().loadPanel(jsontext);
						}
					}
				});*/
	},
	saveFavorite : function(btn) {
		
		var thisForm = Ext.getCmp("parForm").getForm();
		var fav_name = thisForm.findField("fav_name").getValue();
		var id = thisForm.findField("id").getValue();
		var details = thisForm.findField("details").getValue();
		var er_favorite = thisForm.findField("sharingCombo").getValue();
		var publicUsers = thisForm.findField("publicUsers").getValue();
		var shareUsers = thisForm.findField("shareUsers").getValue();
		var cmd = thisForm.findField("cmdValue").getValue();
		var fav_Name = true;
		if(isDoubleByteEnabled!=null && isDoubleByteEnabled!="undefined" && isDoubleByteEnabled.toLowerCase()=="false")
			fav_Name = validateSingleByte(fav_name);
			
		if(!fav_Name)
		{
			Ext.Msg.show({
						title:'Alert',
						 msg: _checkdoublespace,
						buttons: Ext.Msg.OK,
						//icon: Ext.Msg.WARNING
						icon:'iconExclamation'
					});
			return;
		}
	 if((fav_name.length >200))
    {
       Ext.Msg.show({
                title:'Alert',
                msg: 'Favorite Name should not exceed 200 characters ',
                buttons: Ext.Msg.OK,
               //icon: Ext.Msg.WARNING
	       icon:'iconExclamation'
        });
        return false;
		}
		
		
		var errorMsg=validateTextBoxWithSpecialChars(fav_name,'InLine',true);		
					
		if(errorMsg!=true)
		{
			return;					
		}
		
		if(er_favorite=="Share")
		{
			
			var sub="false";
			var shareUsersLen=shareUsers.length;

			if(shareUsersLen>0)
			{
				sub="true";
			}
			if(sub=="false")
			{
				Ext.Msg.show({
						title:'Alert',
						 msg: sharingComboAlert,
						buttons: Ext.Msg.OK,
						//icon: Ext.Msg.WARNING
						icon:'iconExclamation'
					});
				return;
			}
			var list = Ext.getCmp("itemselector-field").toField.boundList;
			var store = list.getStore();
			
			if(store.getCount()>0)
			{
				var tempShareUsrs = '';
				var tmpShareArr = new Array();
				tmpShareArr = shareUsers.split(',');

				for(var su=0;su<tmpShareArr.length;su++)
				{
					var sharUsr = tmpShareArr[su];
					if (su < tmpShareArr.length-1)
					{
						tempShareUsrs += sharUsr+",";
					} else
						tempShareUsrs += sharUsr;
				}
				shareUsers = tempShareUsrs;
			}else
			{
				Ext.Msg.show({
					title:'Alert',
					 msg: 'Please select Atleast one User',
					buttons: Ext.Msg.OK,
					//icon: Ext.Msg.WARNING
					icon:'iconExclamation'
				});
				return;
			}

		}


		var loadMask = new Ext.LoadMask(Ext.getBody(), {msg:"Loading ..." });
		loadMask.show();

		if(!Ext.isEmpty(fav_name)){
			if(fav_name.indexOf("&")!=-1){
						var Re = new RegExp("\\&","g");
						fav_name = fav_name.replace(Re,'|amp|');
			}
			if(fav_name.indexOf("+")!=-1){
						var Re = new RegExp("\\+","g");
						fav_name = fav_name.replace(Re,'|plus|');
			}
			if(fav_name.indexOf("%")!=-1){
						var Re = new RegExp("\\%","g");
						fav_name = fav_name.replace(Re,'|pct|');
			}
		}
		var param = "cmd=" +cmd +"&fav_name=" + fav_name + "&id=" + id + "&er_favorite=" + er_favorite+"&details="
				+ encodeURI(details) ;


		if(er_favorite=='Public')
		{
			param = param+ "&publicUsers=" +publicUsers + "&shareUsers=None";
		}
		else if(er_favorite=='Share')
		{
			param = param+ "&publicUsers=None" + "&shareUsers="+shareUsers;
		}
		else
		{
			param = param+ "&publicUsers=None" + "&shareUsers=None";
		}



		var url = '/final/servlet/com.eg.ErFavoriteC?';




		Ext.Ajax.request({
					url : url,
					params : param,
					scope : this,
					success : function(response) {
						loadMask.hide();
						var jsontext = response.responseText;

						var jsonData = Ext.decode(jsontext);

						if (!Ext.isEmpty(jsonData)) {
							this.getMain().loadPanel(jsonData);
						}
					}
				});
	},

	UpdateSelection : function() {		
		var schForm = Ext.getCmp('parForm');
		var frmObj = schForm.getForm();
		if (frmObj.isValid()) {
			var sc_id  = frmObj.findField("id").getValue();
			//var FavoriteId  = frmObj.findField("FavoriteId").getValue();
			var fav_name  = frmObj.findField("fav_name").getValue();
			var er_favorite  = frmObj.findField("sharingCombo").getValue();
			var shareUsers  = frmObj.findField("shareUsers").getValue();
			var publicUsers  = frmObj.findField("publicUsers").getValue();

			var list = Ext.getCmp("itemselector-field").toField.boundList;
			var store = list.getStore();			 
			shareUsers="";
			
			
			for(var i=0;i<store.getCount();i++)
			{
				shareUsers+=","+store.getAt(i).data.valueField;
			}
			shareUsers=shareUsers.substring(1);
			
			if(er_favorite=="Share")
			{
				
				if(store.getCount()==0)
				{
					Ext.Msg.show({
						title:'Alert',
						 msg: 'Please select Atleast one User',
						buttons: Ext.Msg.OK,
						icon: Ext.Msg.WARNING
					});
					return;
				}

				var sub="false";
				var shareUsersLen=shareUsers.length;

				if(shareUsersLen>0)
				{
					sub="true";
				}
				if(sub=="false")
				{
					Ext.Msg.show({
							title:'Alert',
							 msg: sharingComboAlert,
							buttons: Ext.Msg.OK,
							icon: Ext.Msg.WARNING
						});
					return;
				}
				var tempShareUsrs = '';
				var tmpShareArr = new Array();
				tmpShareArr = shareUsers.split(',');

				for(var su=0;su<tmpShareArr.length;su++)
				{
					var sharUsr = tmpShareArr[su];
					if (su < tmpShareArr.length-1)
					{
						tempShareUsrs += sharUsr+",";
					} else 
						tempShareUsrs += sharUsr;
				}
				shareUsers = tempShareUsrs;


			}
			var param = "";
			if(er_favorite=='Public')
			{
				param =  "&publicUsers=" +publicUsers + "&shareUsers=None";
			}
			else if(er_favorite=='Share')
			{
				param = "&publicUsers=None" + "&shareUsers="+shareUsers;
			}
			else 
			{
				param = "&publicUsers=None" + "&shareUsers=None";
			}
			var loadMask1 = new Ext.LoadMask(Ext.getBody(), {msg:"Loading ..." });
			loadMask1.show();
			var url = "../servlet/com.eg.ErFavoriteC?"
			var param = "cmd=Update&id="+sc_id+"&enableBack=true&backServletName=/servlet/com.eg.ErFavoriteC?&fromFavoriteModify=yes&details="+Qstring+"&er_favorite="+er_favorite+encodeURI(param)+"&fav_name="+encodeURIComponent(fav_name);
			Ext.Ajax.request({
				url : url,
				params : param,
				method:"POST",
				scope : this,
				success : function(response) {
					loadMask1.hide();
					var jsontext = response.responseText;
					
					var jsonData = Ext.decode(jsontext);

					if (!Ext.isEmpty(jsonData)) {
						this.getMain().loadPanel(jsonData);
					}
				}
			});
			//document.location = urlForView;
		}
		else
		{
			if(validateTextBoxWithSpecialChars(frmObj.findField("fav_name").getValue(),'InLine',true))
				return;
			
		}
	}


});