
// JavaScript Document
Ext.define('favorite.view.Main', {
			extend :((showModifyLink=='true')?'utilities.NewOuterPanel':'Ext.Panel'),
			alias : 'widget.main',
 			refs : [{
						selector : 'favoriteform',
						ref : 'favoriteform'
					},{
						selector : 'favoritedetails',
						ref : 'favoritedetails'
					}],
			requires:[
				'favorite.view.FavoriteForm',
				'favorite.view.FavoriteDetails',
				'Ext.ux.form.MultiSelect',
				'Ext.ux.form.ItemSelector',
				'utilities.CommonPanel'
			],
			//ui:'newOuterPanel',
			//cls :((showModifyLink=='true')? 'outerpanel':'scheduleFavoriteInner'),
			preventHeader:((showModifyLink=='true')?false:true),
			id : 'saveschedule',
 			autoScroll : true,
			layout : {
				align : 'stretch',
				type : 'vbox',
				pack : 'start'
			},
			items : [{
						xtype : 'form',
						id : 'parForm',
						ui:((showModifyLink=='true')?'newFormPanel':''),
						//ui:'newFormPanel',
						margin :((showModifyLink=='true')?'10':'0'),
						//margin :10,
						standardSubmit : true,
						url : '',
						layout : {
							type : 'vbox',
							align : 'stretch'
						},
						items : [{
									xtype : 'favoriteform',
									id : 'sch_formpanel',
									style:{'background-color':'transparent','-webkit-box-shadow': '0px 0px 0px 0px', '-moz-box-shadow': '0px 0px 0px 0px', 'box-shadow': '0px 0px 0px 0px'}
								}, {
									xtype : 'favoritedetails',
									id : 'savedDetails',
									style:{'background-color':'transparent','-webkit-box-shadow': '0px 0px 0px 0px', '-moz-box-shadow': '0px 0px 0px 0px', 'box-shadow': '0px 0px 0px 0px'},
									hidden:true

								},
								{
											xtype:'fieldcontainer',
											id:'buttonCont',
 											layout: {
														type: "hbox",
														pack: "center",
														align: "middle"
													},
 											items:[

													{
														xtype : 'button',
														ui:'newButtonSmall',
														name:'update',
														id:'update',
														text : 'Update',
														margin:'0 20 0 0 ',
														hidden:true

													},
													{
														xtype: 'button',
														ui:'newButtonSmall',
														text: 'Modify Selection',
														id: 'clickModify',
														name: 'clickModify',
														hidden:true,
														handler: function(){
															var schForm = Ext.getCmp('parForm');
															var frmObj = schForm.getForm();
															if (frmObj.isValid()) {
																var sc_id  = frmObj.findField("id").getValue();
																var fav_name  = frmObj.findField("fav_name").getValue();
																var sharingCombo  = frmObj.findField("sharingCombo").getValue();
																var shareUsers  = frmObj.findField("shareUsers").getValue();

																var urlForView = "../servlet/com.eg.ErFavoriteC?cmd=Modify&id="+sc_id+"&enableBack=true&backServletName=/servlet/com.eg.ErFavoriteC?&fromFavoriteModify=yes&er_favorite="+sharingCombo+"&com.eg.CSRF_NONCE="+csrfToken;
																document.location = urlForView;
															}
															else
															{
																if(validateTextBoxWithSpecialChars(frmObj.findField("fav_name").getValue(),'InLine',true))
																	return;
																
															}
														}
													},
													{
																	xtype : 'button',
																	ui:'newButtonSmall',
																	name:'save',
																	id:'save',
																	text : 'Save',
																	//padding:'0 10 0 10',
																	hidden:true
													}
													/*,
													{
														xtype : 'panel',
														padding : '10',
														style : 'text-align:center',
														items : [{
																	xtype : 'button',
																	cls : 'button20',
																	id:'favCloseButton',
																	text : 'Close',
																	handler : function() {
 																			window.parent.destroyFavWindow();
 																	}
																}]
													} */
											  ]
										}]

								//}]

					}],
			tools : [{
						xtype : 'button',
						text :backText,
						cls : 'backbutton',
						hidden:true,
						margin:'0 10 0 0',
						id:'favBackButton',
						iconCls:'iconBack',
						listeners : {
							'click' : function() {
								document.location = '../reporter/ErViewFavorite.jsp?com.eg.CSRF_NONCE='+csrfToken;
							}
						}

					}],

			loadData : function(jsonData) {

				var thisForm = Ext.getCmp('parForm').getForm();

				var screenLabels = jsonData.screenLabels;
				var comboarray = jsonData.shareCombojson;
				var combovalue = jsonData.sharecombo_value;
				var fav_name = jsonData.favoritename;

				thisForm.findField("fav_name")
						.setFieldLabel(screenLabels["reporter.common.Name"]);

				thisForm.findField("fav_name").setValue(fav_name);

				thisForm.findField("sharingCombo")
						.setFieldLabel(screenLabels["reporter.common.Sharing"]);
				thisForm.findField("sharingCombo").getStore()
						.loadRawData(comboarray);


				thisForm.findField("sharingCombo").suspendEvents(false);
				thisForm.findField("sharingCombo").setValue(combovalue);
				thisForm.findField("sharingCombo").resumeEvents();




				var details = Ext.getCmp("savedDetails");

				details.loadDetails(jsonData);

				var hiddenFields = jsonData.hiddenfields;
				var me = Ext.getCmp('parForm');
				for (var hiddenField in hiddenFields) {

					if (!thisForm.findField("'" + hiddenField + "'")) {

						me.add({
									xtype : 'hidden',
									name : hiddenField,
									id:hiddenField,
									value : hiddenFields[hiddenField]
								});
					} else {
						thisForm.findField("'" + hiddenField + "'")
								.setValue(hiddenFields[hiddenField]);
					}
				}

				var Rep_name = thisForm.findField("Rep_name").getValue();
				var str="";
				var no_params = "&P0=["+ str+ "]&P1=[REPORTER-"+jsonData.ReportType+"]";
				var param = "F=getValidUsers&C=fromview1"+ no_params;

				var itemselector = Ext.getCmp("itemselector-field");

				Ext.Ajax.request({
					url : '/final/servlet/com.eg.ErRemoteScriptingServlet',
					params : param,
					scope : this,
					method : 'POST',
					success : function(response) {
						var jsonText = response.responseText;
						var jsonData = Ext.decode(jsonText);
						if(!Ext.isEmpty(jsonData))
						{
							itemselector.getStore().removeAll();
							itemselector.getStore().loadRawData(jsonData.combo);

							thisForm.findField("publicUsers").setValue(jsonData.values);
							if(combovalue=="Share")
							{
								itemselector.show()
								thisForm.findField("shareUsers").setValue(jsonData.values);

								var favname = thisForm.findField("fav_name").getValue();
								var loginid = thisForm.findField("urs_name").getValue();
								var rep_name = favname+"$"+loginid;
								var prepare_params = "&P0=["+ rep_name+ "]&P1=[Share]&P2=[favorite]";
								var req_param = "F=getFavoriteExistingUsers&C=fromview" + prepare_params;

								Ext.Ajax.request({
									url : '/final/servlet/com.eg.ErRemoteScriptingServlet',
									params : req_param,
									scope : this,
									method : 'POST',
									success : function(response) {
										var jsonText = response.responseText;
										var jsonObj = Ext.decode(jsonText);
										if(!Ext.isEmpty(jsonData))
										{

											itemselector.getStore().remove(jsonObj.values);
											itemselector.setValue(jsonObj.values);
											thisForm.findField("publicUsers").setValue(jsonData.values);
											thisForm.findField("shareUsers").setValue(jsonData.values);
										}
									}
								});
							}
						}
					}
				});

				if(combovalue=="Share")
				{
					Ext.getCmp("itemselector-field").show();
				}
			},
			loadPanel : function (jsonData) {



					var errMsg = jsonData.errMsg;
					if(!Ext.isEmpty(errMsg)) {

						 Ext.MessageBox.show({
							title: 'Save as Favourite',
							msg:errMsg["error"],
							buttons: Ext.MessageBox.OK,
							//icon: Ext.MessageBox.WARNING,
							icon:'iconExclamation',
							fn: function(val)
							{
								console.log(val);
								if(val=='ok')
								{
									Ext.getCmp('fav_name').setValue('');
									Ext.getCmp('fav_name').focus();
								}
							}
						});
						
						/*var htm = 	'<div><b>'
									+errMsg["error"]
									+'</b></div>';

						var statuspanel = {
							xtype:'panel',
							id:'status',
							html:htm
						};
						this.remove(Ext.getCmp("status"),false);
						this.add(statuspanel);*/
					}
					else
					{
						var savelink = jsonData.savelink;
						var htm = '<table border="0px" width="100%" height="100%">'+
										'<tr><td align="center" valign="middle">'+
											'<table style="width:480px;"border="0px">'+
												'<tr>'+
													'<td>'+
														'<div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconSuccess"></div>'+
													'</td>'+
													'<td>'+
														'<div style="line-height:1.5em" class="font_bold11">'+savelink["reporter.common.Your selection has been saved successfully"]+'<br/> '+ savelink["To view your selections, please go to the"]+' <a class="backgroundMsgLink" id="/final/servlet/com.eg.ErFavoriteC?cmd=View&fromNavLink=true" href="javascript:void(0)">Favorites</a> '+savelink["reporter.common.link"]+'</div>'+
													'</td>'+
												'</tr>'+
											'</table></td>'+
										'</tr>'+
									'</table>';

						var statuspanel = {
							//back=true&cmd=viewfav	 id="alarmlink"
							xtype:'panel',
							id:'favResPane',
							flex:1,
							align:'stretch',
							html:htm,
							/*items:[

									{
											xtype : 'button',
											cls : 'button20',
											align:'center',
											id:'schCloseButton',
											style:'{margin-top:220px;margin-left:280px;position:fixed}',
											text : 'Close',
											handler : function() {
														window.parent.destroyFavWindow();
												}
									}

							], */
							listeners: {
									'afterRender': function()
									{
 										Ext.get('favResPane').on('click',function(event,target,options)
										{  
											if (window.parent.loadFavouriteConfigureApp!=undefined)
											{
												window.parent.loadFavouriteConfigureApp(target.id);
											}
											else
											{
												parent.document.getElementById('main').src=target.id; // for vm user
											}
 										},
										this,
										{
											delegate: 'a'
										});
									}
								}  //delegate listener end
						};

						this.removeAll();
						this.add(statuspanel);
					}

			}

		});