// JavaScript Document

Ext.define('Schedules.view.SchedulesView',{
	extend:'Ext.panel.Panel',
	alias:'widget.schedulesview',
	//title:'SAVE SCHEDULES',
	requires:[
		'Schedules.view.SchedulesForm',
		'Schedules.view.SchedulesDetails'
	],
	//margin:'20',
	frame:true,
	//bodyPadding:10,
	cls:'outerpanel',
	id:'saveschedule',
	autoScroll:true,
	layout:{
			align: 'stretch',
			type:'vbox',
			pack:'start'
	},
	
	items:[
				{
				xtype:'form',
				id:'parForm',
				standardSubmit:true,
				url:'',
				layout:{
					type:'vbox',
					align:'stretch'
				},
				items:[
					{
						xtype:'schedulesform',
						id:'sch_formpanel'
					},
					{
						xtype:'schedulesdetails',
						id:'savedDetails'
						
					},{
					xtype: 'panel',
					cls:'borders-t',
					padding:'10',
					style: 'text-align:center',
					items: [{
						xtype: 'button',
						ui:'newButtonSmall',
						text: 'Save',
						handler: function(){
						var frmObj = Ext.getCmp('parForm').getForm();
				
					   if (frmObj.isValid()) {

						   var urlForSubmit = Ext.getCmp('parForm').url;

						   var params = frmObj.getValues(true);
							frmObj.submit( { url : urlForSubmit
								});
						}
						}
					}]
					}
				]
				
				}
			],
			tools:[
			{
				xtype:'button',
				text:backText,
				cls:'backbutton',
				listeners:{
					'click':function(){
						firebackbutton('../reporter/EgReporterback.jsp')
					}
				}
				
			}	
		],
	
	loadData :  function(jsonData)
	{
		//var formObj =this.up('form');
		var frmObj = Ext.getCmp('parForm').getForm();

		//alert(Ext.getCmp('parForm').url);

		Ext.getCmp('parForm').url = jsonData.pageParams.submitURL;
		//alert(Ext.getCmp('parForm').url);

		frmObj.findField("sch_name").setValue(jsonData.pageParams.scheduleName);
		frmObj.findField("mail_id").setValue(jsonData.pageParams['mail_id']);

		frmObj.findField("mail_freq").getStore().loadRawData(jsonData.mailFreqJSON);
		frmObj.findField("mail_freq").suspendEvents(false);
		frmObj.findField("mail_freq").setValue(jsonData.pageParams.selectedMailFreq_value);
		frmObj.findField("mail_freq").resumeEvents();

		
		frmObj.findField("mail_on").getStore().loadRawData(jsonData.mailOnJSON);
		frmObj.findField("mail_on").suspendEvents(false);
		frmObj.findField("mail_on").setValue(jsonData.pageParams.selectedMailOn_value);
		frmObj.findField("mail_on").resumeEvents();
		
		frmObj.findField("schedule_held_on").getStore().loadRawData(jsonData.scheduleTypeJson);
		frmObj.findField("schedule_held_on").suspendEvents(false);
		frmObj.findField("schedule_held_on").setValue(jsonData.pageParams.selectedScheduleType);
		frmObj.findField("schedule_held_on").resumeEvents();

		frmObj.findField("fromHours").getStore().loadRawData(jsonData.hrsComboJSON);
		frmObj.findField("fromHours").suspendEvents(false);
		frmObj.findField("fromHours").setValue(jsonData.pageParams.selectedScheduleHr);
		frmObj.findField("fromHours").resumeEvents();

		frmObj.findField("fromMinutes").getStore().loadRawData(jsonData.minsComboJSON);
		frmObj.findField("fromMinutes").suspendEvents(false);
		frmObj.findField("fromMinutes").setValue(jsonData.pageParams.selectedScheduleMin);
		frmObj.findField("fromMinutes").resumeEvents();

		if(jsonData.hasOwnProperty('hiddenParams'))
		{
			var me = Ext.getCmp('parForm');
			var frmObj = Ext.getCmp('parForm').getForm();
			var hiddenFields = jsonData.hiddenParams;
			for (var hiddenField in hiddenFields) {
				if (!frmObj.findField("'" + hiddenField + "'")) {
					me.add({
							xtype : 'hidden',
							name : hiddenField,
							value : hiddenFields[hiddenField]
							});
				}
				else
				{
					frmObj.findField("'" + hiddenField + "'").setValue(hiddenFields[hiddenField]);
				}
			}
		}
		var tableContent = jsonData.tableContent;

		if(!Ext.isEmpty(tableContent))
		{
			var htmlStr = '<div class="x-table">' 
						+'<table cellspacing="0" cellpadding="0" border="0" class="x-grid-table x-grid-table-resizer">'
						+'<tbody>' 
							
							
						
			var thData = tableContent[0];
			htmlStr += '<tr class="x-grid-row">'
					+'<td class=" x-grid-cell x-grid-cell-first">'
						+'<div class="x-grid-cell-inner" >'+thData.Report_name+'</div>' 
					+'</td>'
					+'<td class=" x-grid-cell">' 
						+'<div class="x-grid-cell-inner" >'+thData.Report_value+'</div>' 
					+'</td>' 
				+'</tr>'; 
			for(var tr in tableContent)
			{
				var trData = tableContent[tr];
				if(tr==0)
					continue;

				htmlStr += '<tr class="x-grid-row">' 
								+'<td class=" x-grid-cell x-grid-cell-first">' 
									+'<div class="x-grid-cell-inner"> '+trData.Report_name+'</div>' 
								+'</td>'
								+'<td class=" x-grid-cell">' 
									+'<div class="x-grid-cell-inner" >'+trData.Report_value+'</div>' 
								+'</td>' 
							+'</tr>';
			}
			htmlStr +='</tbody>'
						+'</table>'
						+'</div>';

			Ext.getCmp("savedDetails").update(htmlStr);
	
		}

	}
});