 Ext.define('healthreport.controller.HealthReportController',{
	extend:'Ext.app.Controller',
	views:['Main'],
	drillDownHashMap : new Ext.util.HashMap(),
	drillDownChartType : null,
	refs:[
		{selector:'main',ref:'main'},
		{selector:'newUtilities',ref:'newUtilities'},
		{selector:'ReporterSettings',ref:'ReporterSettings'},
		{selector:'nomeasurepanel', ref:'nomeasurepanel'},
		{selector: 'backGroundPanel',ref: 'backGroundPanel'}
	],
	init:function(){
		this.control({

			'newUtilities':{
				'afterrender':this.loadTools
			},
			'main':{
				'boxready':this.afterMainRender
			},
			'healthreportform':{
				'afterrender':this.fillMainFormFields
			},
			'healthreportsettings':{
				'afterrender':this.fillSettingsFields
			},
			'newUtilities > #printTool > button':
			{
				'click':this.printFile
			},
			'newUtilities > #saveTool > button':{
					'click': this.saveReportAsPDF
			},
			'newUtilities > #mailTool > button':{
					'click':this.sendMail
			},
			'newUtilities > #csvTool > button':{
					'click':this.saveCsv
			},
			'newUtilities > #favoriteTool > button':{
					'click':this.saveFavorite
			},
			'newUtilities > #scheduleTool > button':{
					'click':this.saveSchedule
			},
			'egcomponent button[id="expandSelector"]':{
				'click': this.expandMe
			},
			'healthreportform combo[name="er_option"]':{
				'select': this.analyzeByOnChange
			},
			'healthreportform combo[name="er_site"]':{
				'select': this.seg_serv_zoneOnChange
			},
			'healthreportform combo[name="er_includezones"]':{
				'select': this.subZoneOnChange
			},
			'healthreportform combo[name="er_healthSummary"]':{
				'select': this.healthSummaryOnChange
			},
			/*
				'healthreportsettings combo[name="er_excwe"]':{
				'select': this.weekendOnChange
			},
			*/
			'healthreportsettings button[id="moreOptionCloseId"]': {
				'click': this.validateAndCloseSettings
			},
			'healthreportsettings button[id="submitViaSetting"]': {
				'click': this.closeSettingAndSubmit
			},
			'healthreportsettings combo[name="reportGeneration"]':{
				'select': this.reportGenChange
			},
			'mainform button[name="submit"]':{
				'click': this.showResult
			},
			'mainform button[name="save"]': {
				'click': this.goTo
			},
			'mainform button[id="panelinsidetoggle"]': {
                'click': this.toggleForm
            },
			'egcomponent trigger[id="compSearch"]':{
				'change':this.filterMultiselect
			}
		});
	},
	showConfigDropdown:function(){
			isSettingsEnabled=true;
			var thisController = this;
		    var tpl = new Ext.XTemplate('<div style="float:left;margin:0px 0px 0px 0px;">'+settings+'</div><div style="text-align:right;float:right;"><div class="iconCloseNew" id="closeSettings"></div></div>');
			Ext.create('Ext.container.Container',{
			width:570,
			//padding:5,
			id:'configMod',
			//cls:'configMode_popup',

			ui:'settingsWindowContainer',
			items:[
				{
					xtype:'container',
					cls:'configMode_popupArrow',
					style:{'top':'-14px','left':'360px'}
				},
				{
					xtype:'container',
					html:tpl.apply(),
					cls:'containerHeader',
					style:{'top':'0px','margin':'0px'}
				},
				{
					xtype:'healthreportsettings',
					parent:this
				}
			],
			onRender:function(){
				Ext.get('closeSettings').on('click', function () {
					thisController.validateAndCloseSettings();
				});
			},
			renderTo:'hReport-body'
			});
	},
	filterMultiselect: function (obj) {
		if (Ext.isEmpty(appConstants.erUtils))
		{
		appConstants.erUtils = Ext.widget("erutils");
		}
		obj.toggleTriggger();
		appConstants.erUtils.filterComboStore(obj,Ext.getCmp('er_comptype'),appConstants.rawDataForComponents);
	},
	goTo: function (btn) {
 		var hiddenFields =  appConstants.publicJsonData['hiddenFields'];
		var from_schedule = hiddenFields["fromScheduleModify"];
		if ((from_schedule != null && from_schedule == "Yes")) {
			 this.saveSchedule(btn);
		}else{
			this.saveFavorite(btn);
		}
	},
	showResult:function()
	{	
		Ext.getCmp('panelinsidetoggle').setDisabled(false);
		var stDateTime = Ext.getCmp('er_stdate').getValue();
        var tmpStartHour = Ext.getCmp('er_sthr').getValue();
        stDateTime.setHours(tmpStartHour);
        var enDateTime = Ext.getCmp('er_enddate').getValue();
        var tmpEndHour = Ext.getCmp('er_endhr').getValue();
        enDateTime.setHours(tmpEndHour);
 		if (!checkDateTime(stDateTime, enDateTime)) {
            return;
        }
 		if(this.validateMainForm() && this.validateSettings())
		this.submitReport();
	},
	updateFormQueryString_forSubmission:function(){
		var isErSite=false;
		var analyzeByValue=Ext.getCmp('er_option').getValue();
		if(analyzeByValue=='Zone'||analyzeByValue=='Segment'||analyzeByValue=='Service')
		isErSite=true;
		//syntax---7arguments---updateFormQueryString(isErOption,isErSite,isCompType,isHealthSummary,isHidddens,isSettings,isReportGeneration){
	    this.updateFormQueryString(true,isErSite,true,true,true,true,true);
 	},
	submitReport:function(){
		this.updateFormQueryString_forSubmission();
		this.updateAjaxFormData(true);
	},
	loadReportData:function(){
		var resultPanelObj=Ext.getCmp('resultPanel');
			 var reportGeneration;
		if (isSettingsEnabled)
		{
			Ext.get('configMod').animate({duration: 500,to: {y: -500}});
			reportGeneration=Ext.getCmp('reportGeneration').getValue();
		}
		else
		{
			reportGeneration=appConstants.publicJsonData.selectedFields.reportGenerationComboSelected;
		}
		if(reportGeneration == 'foreground'){

			Ext.getCmp("bookletTool").setDisabled(false);
			Ext.getCmp("saveTool").setDisabled(false);
			Ext.getCmp("printTool").setDisabled(false);
			Ext.getCmp("mailTool").setDisabled(false);
			Ext.getCmp("upbutton").setDisabled(false);
			this.getBackGroundPanel().hide();
			this.showForeGroundData(resultPanelObj);
			Ext.getCmp('selectionDetails').setSelectionDetailsData(appConstants.publicJsonData.selectionDetails);
		}
		else if(reportGeneration == 'background')
		{
 			resultPanelObj.hide();
			var htmlStr = '';
			var backgroundReportStatus=appConstants.publicJsonData.displayFields.backgroundReportStatus;
			if(backgroundReportStatus!= 'undefined' && backgroundReportStatus== 'success')
			{
				var bgroundResponseTxt=appConstants.publicJsonData.displayFields.bgroundResponseTxt;
				var bgroundReportsURL=appConstants.publicJsonData.urlFields.bgroundReportsURL;
				var backgroundAnchor=appConstants.publicJsonData.displayFields.backgroundAnchor;
				var sub = backgroundAnchor;//.slice(0, -3);
				htmlStr = '<center><div style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:480px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconSuccess"></div><div style="margin-top:20px"><b>'+bgroundResponseTxt+'</b></br><a class="backgroundMsgLink" href="'+bgroundReportsURL+'">'+sub+'</a></div></div></center>';
				//backgroundresultsObj.update('<span>'+bgroundResponseTxt+'</br><a href="'+bgroundReportsURL+'">'+backgroundAnchor+'</a></span>');
			
				htmlStr = '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconSuccess"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+bgroundResponseTxt+'.</br>'+'<a class="backgroundMsgLink" href='+ bgroundReportsURL +'>'+ sub + '</a></div></td></tr></table></td></tr></table>';
			}
			else if(backgroundReportStatus!= 'undefined' && backgroundReportStatus== 'duplicate')
			{
				var bgroundResponseTxt=appConstants.publicJsonData.displayFields.bgroundResponseTxt;
				var bgroundReportsURL=appConstants.publicJsonData.urlFields.bgroundReportsURL;
				var backgroundAnchor=appConstants.publicJsonData.displayFields.backgroundAnchor;
				var sub = backgroundAnchor;//.slice(0, -3);
				//htmlStr = '<center><div style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:480px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconExists"></div><div style="margin-top:20px"><b>'+bgroundResponseTxt+'</b></br><a class="backgroundMsgLink" href="'+bgroundReportsURL+'">'+sub+'</a></div></div></center>';

				htmlStr = '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconExclamation"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+bgroundResponseTxt+'.</br>'+'<a class="backgroundMsgLink" href='+ bgroundReportsURL +'>'+ sub + '</a></div></td></tr></table></td></tr></table>';

			}
			else
			{
				//htmlStr = '<center><div style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:480px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconExclamation"></div><div style="margin-top:20px"><b>Error In BackGround Generation</div></div></center>';
			
				htmlStr = '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconExclamation"></div></td><td><div style="line-height:1.5em" class="font_bold11">Error In BackGround Generation</div></td></tr></table></td></tr></table>';
			}
			this.getBackGroundPanel().update(htmlStr);
 			this.getBackGroundPanel().show();
		}
	},
	showForeGroundData: function (resultPanelObj) {
		
			 resultPanelObj.removeAll();
			
 		 resultPanelObj.setTitle(appConstants.publicJsonData.data.dataTitle);
		 
		 var content;
		 var temper_healthsummary = Ext.getCmp('er_healthSummary').getValue();

		 if(temper_healthsummary=='At Tier Level' || temper_healthsummary=='Component_type')
		 
			 content=this.getForeGroundTierData(temper_healthsummary);
		
		else
			 content=this.getForeGroundServerData();
	//	console.log("foreground data"+content);
		  var foreGroundDataPanel=this.getForeGroundDataPanel(content);
		 resultPanelObj.add(foreGroundDataPanel);
		 resultPanelObj.show();
	},
	getToolLabel:function(){
	    var lb=appConstants.publicJsonData.data.dataLabel;
		/*var lbl=Ext.create('Ext.form.Label',{
		  id:'lblTool',
		  html:'<div style="margin:2px;"><div style="background-color:'+lb.normalColor+';float:left;padding:6px;"></div><div style="float:left;">&nbsp;'+lb.ok+'&nbsp;&nbsp;&nbsp;</div><div style="background-color:'+lb.majorColor+';float:left;padding:6px;"></div><div style="float:left;">&nbsp;'+lb.caution+'&nbsp;&nbsp;&nbsp;</div><div style="background-color:'+lb.criticalColor+';float:left;padding:6px;margin-left;50px;"></div><div style="float:left;">&nbsp;'+lb.needAttention+'</div></div>'
		});	*/

		var backTool={
							xtype:'toolbar',
							id:'rpTool',
							items: [
										{
											 xtype:'label',
											 id:'lblTool',
											 html:'<div style="margin:2px;"><div style="background-color:'+lb.normalColor+';float:left;padding:6px;"></div><div style="float:left;">&nbsp;'+lb.ok+'&nbsp;&nbsp;&nbsp;</div><div style="background-color:'+lb.majorColor+';float:left;padding:6px;"></div><div style="float:left;">&nbsp;'+lb.caution+'&nbsp;&nbsp;&nbsp;</div><div style="background-color:'+lb.criticalColor+';float:left;padding:6px;margin-left;50px;"></div><div style="float:left;">&nbsp;'+lb.needAttention+'</div></div>'
								  		}
									]
								};

		var rp=Ext.getCmp('resultPanel');
		rp.addTool(backTool);

	},
	getForeGroundDataPanel:function(content){
		var me=this;
 		  if (Ext.get('lblTool')==null) {
				this.getToolLabel();
			}

		  var dataContainer = new Ext.panel.Panel({
            id: 'tableCont',
			//title:appConstants.publicJsonData.data.dataTitle,
            scroll: true,
            autoScroll: true,
            border: false,
			frame:false,
            html: content,
			listeners: {
			'afterRender': function()
			{
					if (Ext.get('tierWiseTable')!=null)
 					  me.getTROddEvenBG('tierWiseTable');

 				   	if (Ext.get('serverWiseTable')!=null)
					  me.getTROddEvenBG('serverWiseTable');

					var el = Ext.get('tableCont');
					el.on('click', function(event, target, options)
					{	
				
					//	console.log("target id-------->"+target.id);
				
						me.getPopUpRequest(target.id);
					},
					this,
					{
						delegate: 'td'
					});

				}
			 }
		  });

		return dataContainer;
	},
	getbackTool:function(query)
	{
		var me=this;
		var backTool={
					xtype:'container',
					id:'backCont',
					hidden:false,
					items:[

							{
								xtype:'button',
								text:backText,
								cls:'backbutton',
								iconCls:'iconBack',
								id:query,
 								listeners:{
									'click':function(){
										me.getPopUpRequest(this.id);
										this.up('container').hide();
									}
								}
							}
						]
				};
			return backTool;
	},
	getSaveandPrintTool:function(jsonData,hideSavePrint)
	{
			var me=this;
 			var windowToolbar = new Ext.Toolbar({
			    pack: 'left',
				items : [
							/*{
								xtype: 'tbseparator'
							},
							{
								 xtype:'label',
								 id:'headLink',
 								 html:'<a href="javascript:void(0)" id="hLink" style="text-decoration:underline;font-weight:bold;font-size:12px;">Associated metrics and their health %</a>',
								 listeners:
								 {
									afterrender:function()
									{
										Ext.get('hLink').on('click',function()
										{
											var content=me.getPopUpData(jsonData);
 											var subdata=jsonData.subData;
											var i= subdata.length-1;
											var contentTitle=subdata[i].header;
											var contentPanel= me.getContentPanel(content,contentTitle);
											Ext.create('Ext.window.Window', {
													title:contentTitle,
													autoScroll:true,
													id:'win',
													height: 250,
													width: 600,
													layout: 'fit',
													closeAction: 'destroy',
													html:content,
													listeners:{
														afterrender:function()
														{
															me.getTROddEvenBG('tableId1');
															//$('#win-body').jScrollPane();
														}
													}
												}).show();


										});
									}
								 }
							},
							{
								xtype:'tbspacer', width:100
							}, */
							
							{
								xtype: 'container',
								margin : '0 3 0 6',
								id: 'savTool',
								hidden:hideSavePrint,
								cls: 'iconBg',
								disabled: false,
								items: [
								{
									xtype: 'button',
									iconCls: 'iconPdfDownload',
									style: {
										background: 'none',
										border: '0px'
									},
									listeners: {
										afterrender: function () {
											Ext.create('Ext.tip.ToolTip', {
												target: this.id,
												anchor: 'top',
												cls: 'yellowTip',
												trackMouse: true,
												html: 'Save'
											});
											Ext.get('savTool').on('click',function(){
												if (Ext.isEmpty(appConstants.erUtils))
												{
												appConstants.erUtils = Ext.widget("erutils");
												}
												appConstants.erUtils.savePDF(jsonData.urlFields.pdfUrl+"&drillSes=yes");
  											});
										}
									}
								}]
							},
							//{
							//	xtype: 'container',
							//	cls:'popUpWindowIconSeperator'
							//},
							{
								xtype: 'container',
								margin : '0 3 0 3',
								id: 'prnTool',
								cls: 'iconBg',
								disabled: false,
								hidden:hideSavePrint,
								items: [{
									xtype: 'button',
									iconCls: 'iconPrintPreview',
									style: {
										background: 'none',
										border: '0px'
									},
									listeners: {
										afterrender: function () {
											Ext.create('Ext.tip.ToolTip', {
												target: this.id,
												anchor: 'top',
												cls: 'yellowTip',
												trackMouse: true,
												html: 'Print'
											});
											Ext.get('prnTool').on('click',function(){ 
												parent.printWindowFn(jsonData.urlFields.drilldownPrintUrl);
												//Ext.widget('newwindow',{header:true,}).show();
												//Ext.select('#drillDownContentDiv').set({src: jsonData.urlFields.drilldownPrintUrl});
												
											    /*var divToPrint = document.getElementById('container');
												var popupWin = window.open('', '_blank', 'width=800,height=500');
												popupWin.document.open();
												popupWin.document.write('<html><link rel="stylesheet" type="text/css" href="/final/styles/eGLightTheme.css" /><body onload="window.print()">' + divToPrint.innerHTML + '</html>');
												popupWin.document.close();*/
											});
										}
									}
								}]
							},
							{
								xtype: 'container',
								margin : '0 3 0 3',
								id: 'closeBtn',
								cls: 'iconBg',
								disabled: false,
								items: [
								{
									xtype: 'button',
									iconCls: 'iconCloseNew',
									style: {
										background: 'none',
										border: '0px'
									},
									listeners: {
										afterrender: function () {
											Ext.create('Ext.tip.ToolTip', {
												target: this.id,
												anchor: 'top',
												cls: 'yellowTip',
												trackMouse: true,
												html: 'Close'
											});
											Ext.get('closeBtn').on('click',function(){

												if(Ext.getCmp('win')!=undefined)
													Ext.getCmp('win').doClose();
												else if(Ext.getCmp('customWindow')!=undefined)
													Ext.getCmp('customWindow').doClose();
  											});
										}
									}
								}]
							},
//							{
//								xtype: 'container',
//								cls:'popUpWindowIconSeperator'
//							}
						]
					});
			return windowToolbar;
	},
	showPopUpData:function(jsonData)
	{
		var me=this;
		var content=this.getPopUpData(jsonData);
		var subdata=jsonData.subData;
		var i= subdata.length-1;
		var contentTitle=subdata[i].header;
		//var contentPanel= this.getContentPanel(content,contentTitle);
		Ext.create('Ext.window.Window', {
				title:contentTitle,
				autoScroll:true,
				id:'win',
				height: 250,
				width: 600,
				layout: 'fit',
				ui:'newPopupWindow',
				bodyPadding:10,
				modal:true,
				closeAction: 'destroy',
				html:content,
				listeners:{
					afterrender:function()
					{
						if (Ext.get('tableId1')!=null)
						me.getTROddEvenBG('tableId1');
						//$('#win-body').jScrollPane();
					}
				}
			}).show();
	},
	getTROddEvenBG:function(tableId)
	{
 			$(document).ready(function(){


  				$("#"+tableId+" tr:even").addClass('tableTrBgEven');
				$("#"+tableId+" tr:odd").addClass('tableTrBgOdd');
				 $(".tableTrBgEven_myalternate:odd").addClass("tableTrBgEvenReport");
				 $(".tableTrBgEven_myalternate:even").addClass("tableTrBgAddReport");
				// $(".tableTrBgEven_myalternate").addClass("border", "1px solid #D9D9D9");


			});
	},
	getHeaderLink:function()
	{
		var lbl=Ext.create('Ext.form.Label',{
		  id:'headLink',
		  html:'<a href="javascript:void(0)" id="hLink" class="tdAnchor anchorLink" >Associated metrics and their health %</a>'
		});
		return lbl;
	},
	getPopUpData:function(jsonData)
	{
		   var subdata=jsonData.subData;
		   var i= subdata.length-1;
		   var content;
		   if(i==subdata.length-1)
		   {
				if (subdata[i].tableData[0]!=undefined && subdata[i].tableData[0].array!=undefined && subdata[i].tableData[0].array.length>0)
				{
								/*content+= '<p style="padding:0px 4px 4px 0px;font-weight:bold">';
									content+= subdata[i].header;
								content+= '</p>'; */

							content = '<div  class="newTable" >';
								content += '<table border="0" id="tableId1" align="center" width="100%">';
									content +='<thead>';
										content +='<tr>';
//						for (var key in subdata[i].cols) {
//								if (subdata[i].cols.hasOwnProperty(key)) {
//											content+= '<th>';
//												content+= subdata[i].cols[key];
//											content+= '</th>';
//								}
//							}
								for (var td=0;td<Object.keys(subdata[i].cols).length;td++){
									var key='c'+(td+1);
									if (subdata[i].cols.hasOwnProperty(key)) {
												content+= '<th>';
													content+= subdata[i].cols[key];
												content+= '</th>';
									}
								}

										content+= '</tr>';
									content +='</thead>';
									content +='<tbody>';
						for (var m = 0; m < subdata[i].tableData.length; m++)
						{
							var test = subdata[i].tableData[m].test;
							var rowsp = subdata[i].tableData[m].array.length;
 							var heit=rowsp*30;
										content += '<tr>';
											content += '<td rowspan="' + rowsp + '"  valign="top" class="rowspanRightBorder">';
												content += subdata[i].tableData[m].test;
											content += '</td>';
							if (rowsp > 1)
							{
								for (var c=0;c<subdata[i].tableData[m].array.length;c++ )
								{
									if (c !== 0){
										content += '<tr>';
									}
											content += '<td>';
												content += subdata[i].tableData[m].array[c].measure;
											content += '</td>';

											content += '<td>';
												content += subdata[i].tableData[m].array[c].health;
											content += '</td>';
										content += '</tr>';
								}
							}
							else
							{
											content += '<td>';
												content += subdata[i].tableData[m].array[0].measure;
											content += '</td>';
											content += '<td>';
												content += subdata[i].tableData[m].array[0].health;
											content += '</td>';
										content += '</tr>';
							}
						}
										content +='</tbody>';
									content+= '</table>';
								content+= '</div>';
				}
				else
				{

							//xtype:'container',
							//height:500,
							//bodyStyle:{'background-color':'#E6E6E6 !important'},
							//style:{'text-align':'center','padding':'50px 0px'},
							content='<div style="text-align:center;padding:50px 0px;"><div class = "iconExclamation" style="margin:0 auto;"></div><div>No Measures Available</div></div>';

				}
			}

			return content;
	},
	getPopUpRequest:function(target){
		
		var me=this;
 		if(target==null||target=='undefined'||target=='')
		return;
		else
		{
 			if (target.indexOf('componentMeasureTabSet')<=0&&target.indexOf('ErHtmlToSavePdf')<=0&&(target!='ErInfrastructureHealthStatusPrint'))
			{
				Ext.Ajax.request(
						{
							url : target,
							//params :appConstants.queryString,
							scope:this,
							async: true,
							success: function(response){
								var jsonText = response.responseText;
								var jsonData=Ext.decode(jsonText);
								//appConstants.publicJsonData=jsonData;
								if(target.indexOf('ErInfrastructureHealthDetails')>0)
								{
									var content=this.getHealthDetailsContent(jsonData);
									var customWindow=Ext.create('healthreport.view.CustomWindow');
									var contentTitle= jsonData.popUpHeader;
									var contentPanel= this.getContentPanel(content,contentTitle);
									customWindow.add(contentPanel);
									//customWindow.setTitle(contentTitle);
									customWindow.setHeight(250);
									customWindow.setWidth(600);
									//customWindow.addCls('mycustom_shadow');
									customWindow.show();
									Ext.getCmp('commonPanelId').addTool(this.getSaveandPrintTool(jsonData,true));
								}
								if(target.indexOf('ErInfrastructureHealthStatus')>0)
								{
									var content=this.getHealthStatusContent(jsonData);
									//alert("status----"+content);
									var customWindow=Ext.create('healthreport.view.CustomWindow');
									var contentTitle= '<div><div style="float:left;">'+jsonData.title+'</div><div style="float:right;"><a href="javascript:void(0)" id="hlink" class="font_bold12 anchorLink">Associated metrics and their health %</a></div></div>';
									var contentPanel= this.getContentPanel(content,contentTitle);
									customWindow.add(contentPanel);
									//customWindow.setTitle('<div><div style="float:left;">'+contentTitle+'</div><div style="float:right;"><a href="javascript:void(0)" id="hlink" class="font_bold12 anchorLink">Associated metrics and their health %</a></div></div>');

									var h=document.body.scrollHeight;	//Ext.getBody().getViewSize().height,
									var browserw=window.innerWidth;   //(excludes browser toolbar width)
									var browserh=window.innerHeight;  //(excludes browser toolbar height)
 									customWindow.popUpJson=jsonData;
 									customWindow.setHeight(browserh-50);
									customWindow.setWidth(browserw-50);
 									//customWindow.addTool(this.getSaveandPrintTool(jsonData));
									customWindow.show();
									Ext.getCmp('commonPanelId').addTool(this.getSaveandPrintTool(jsonData,false));
									//customWindow.getHeader().getEl().update(g);
									if (this.drillDownChartType=='highchart')
									{
											this.drillDownHashMap.each(function(key, value, length){
												//console.log(key, value, length);
												reportHighStockChart(value+'&chartType=highchart',key,'70%','100%',null);
											});
									}
								}
								if(target.indexOf('ErInfrastructureProblemDetails')>0)
								{
									var content=this.getProblemDetailsContent(jsonData);
 									//alert("---ProblemDetails----");
									var contentTitle= jsonData.head;
									var contentPanel= this.getContentPanel(content,contentTitle);
									Ext.create('Ext.window.Window', {
											title: contentTitle,
											autoScroll:true,
											id:'win',
											height: 250,
											ui:'newPopupWindow',
											width: 600,
											layout: 'fit',
											closeAction: 'destroy',
											html:content,
											bodyPadding:10,
											//header:false,
											modal:true,
											listeners:{
												afterrender:function()
												{
 													me.getTROddEvenBG('tableId1');
													//$('#win-body').jScrollPane();
												}
											}
										}).show();
								}
								if(target.indexOf('ErInfrastructureHealthReportC')>0&&target.indexOf('backQuery=queryString')<=0)
								{
									var content=this.getComponentTypeContent(jsonData);
									// console.log("content"+content);
									var resultPanelObj=Ext.getCmp('resultPanel');
									var resultPanelChildObj=Ext.getCmp('tableCont');
									resultPanelChildObj.removeAll();
									resultPanelChildObj.update(content);
									//alert('isback exist--'+Ext.get('backCont'));
 									if (Ext.get('backCont')==null)
									{
										Ext.getCmp('rpTool').add(this.getbackTool(appConstants.queryString+'&backQuery=queryString'));
						 			}
									else
									{
									  // alert(Ext.getCmp('backCont').down('button').id);
									   //assign last updated querystring to back buuton id
									   Ext.getCmp('backCont').down('button').id=appConstants.queryString+'&backQuery=queryString';
									   Ext.getCmp('backCont').show();
									}
 									//resultPanelObj.setTitle('<a href="javascript:void(0)" id="'+queryString+'&backQuery=queryString"><img src="../images/back.gif"></img></a>&nbsp;&nbsp;&nbsp;'+jsonData.data.dataTitle+' - '+jsonData.data.tableData[0].text+' - '+jsonData.data.tableData[0].sText);
 								  	//resultPanelObj.setTitle("<span class='font_bold'>"+jsonData.data.dataTitle+' - '+jsonData.data.tableData[0].text+' - '+jsonData.data.tableData[0].sText+"</span>");
 								  	resultPanelObj.setTitle("<span class='font_bold'>"+jsonData.data.dataTitle+' - '+jsonData.data.tableData[0].text+"</span>");
 								}
								if((target.indexOf('ErInfrastructureHealthReportC')>0)&&(target.indexOf('&backQuery=queryString')>0))
								{
									//alert('having backquery');
									appConstants.publicJsonData=jsonData;
									var resultPanelObj=Ext.getCmp('resultPanel');
									this.showForeGroundData(resultPanelObj);
								}
							}
						});
			}
			else
			{	// alert("frame "+target);
				if(target.indexOf('componentMeasureTabSet')>0)
				{
					/*var frameObj = {
							xtype: 'container',
							height:Ext.getBody().getViewSize().height,
							layout: 'fit',
							items: [{
									xtype: 'component',
									 autoEl: {
										tag: 'iframe',
										src: target
									}
								}]
						};
						Ext.create('Ext.window.Window', {
												title: 'Diagnosis for errors - egManager',
												autoScroll:true,
												height: 500,
												width: 800,
												layout: 'fit',
												closeAction: 'destroy',
												items:frameObj
											}).show();*/
					window.open(target,"DDWindow","width=1012,height=603,left=0,top=0,scrollbars=1,scrollbars=yes,resizable");
				}
				if(target.indexOf('ErHtmlToSavePdf')>0)
				{
					if (Ext.isEmpty(appConstants.erUtils))
					{
					appConstants.erUtils = Ext.widget("erutils");
					}
					appConstants.erUtils.savePDF(target);
				}
				if(target=='ErInfrastructureHealthStatusPrint')
				{
					//Ext.widget('print',{title:publicJsonData.displayFields.reportTitle}).show();
					//var printContentDiv = Ext.select('#printContentDiv');
 					//printContentDiv.set({src :target}); container
					var divToPrint = document.getElementById('container');
					var popupWin = window.open('', '_blank', 'width=800,height=500');
					popupWin.document.open();
					popupWin.document.write('<html><body onload="window.print()">' + divToPrint.innerHTML + '</html>');
					popupWin.document.close();
				}

			}
		}
	},
	getComponentTypeContent:function(jsonData){
		var jsonObject=jsonData.data.tableData;
		var titlee=jsonData.data.dataColumn;
			var content= '<table border="0" class="tableBorderHtml" align="center" width="100%">';
				content +='<thead>';
				content +='<tr>';
				content += '<th style="padding: 5px;" class="theadBorderHtml">'+titlee.c2+'</th>';
				content += '<th style="padding: 5px;" class="theadBorderHtml"  colspan="'+jsonObject[0].array[0].array.length+'">'+titlee.c4+'</th>';
				content +='</tr>';
				content +='<thead>';
				content +='<tbody>';
			for (var tr=0;tr<jsonObject.length;tr++)
			{
				content+= '<tr class="tableTrBgEven">';
					content+= '<td class="tdBorderHtml handSymbol" style="padding: 6px;">'+jsonObject[tr].array[0].text+'</td>';
				for (var td=0;td<jsonObject[tr].array[0].array.length;td++)
				{
					//var marg;
					//var j;
					//if(j==jsonObject[tr].array[0].array.length-1)
					//='0px';
					//else
					//marg='4px';
 					content+= '<td class="tdBorderHtml kpiTableTdBorder" style="background-color:'+jsonObject[tr].array[0].array[td].bgcolor+'!important;color:#000000" id="'+jsonObject[tr].array[0].array[td].query+'">';
						content += '<div  style="text-align:center;height:100%;padding:6px;" class="handSymbol">';

						content+= jsonObject[tr].array[0].array[td].health;
						content+='<br/>';
						content+= jsonObject[tr].array[0].array[td].displayName;
						
						
						content+= '</div>';
					content+= '</td>';
				}
 				content+= '</tr>';
			}
			content +='</tbody>';
			content+= '</table>';
		return content;
	},
	getProblemDetailsContent:function(jsonData){
	   	var content;
		if (jsonData.tableData.length>0)
		{
			content = '<div class="newTable">'; // height="100%"
			content += '<table id="tableId1" border="0" align="center" width="100%">'; // height="100%"
				content +='<thead>';
					content +='<tr>';
//			for (var key in jsonData.cols) {
//				if (jsonData.cols.hasOwnProperty(key)) {
//						content+= '<th>';
//							content+= jsonData.cols[key];
//						content+= '</th>';
//				}
//			}
				for (var td=0;td<Object.keys(jsonData.cols).length;td++){
					var key='c'+(td+1);
					if (jsonData.cols.hasOwnProperty(key)) {
						content+= '<th>';
						content+= jsonData.cols[key];
						content+= '</th>';
					}
				}

					content+='</tr>';
				content +='</thead>';

				content +='<tbody>';
			for (var tr=0;tr<jsonData.tableData.length;tr++)
			{

				if (tr==0)
				{
					content+= '<tr>';
				}
				if ((tr)%4==0&&tr!=0)
				{
					content+= '</tr>';	 //class="tableTrBgEven"
					content+= '<tr>';
				}
						content+= '<td>'+jsonData.tableData[tr]+'</td>';
			}
					content+= '</tr>';
				content +='</tbody>';
			content+= '</table>';
			content+= '</div>';
		}
		else
		{
			 content={
				xtype:'container',
 				//height:500,
				//bodyStyle:{'background-color':'#E6E6E6 !important'},
				style:{'text-align':'center','padding':'50px 0px'},
				html:'<div class = "iconExclamation" style="margin:0 auto;"></div><div>No Measures Available</div>'
			};
		}
		return content;
	},
	getHealthStatusContent:function(jsonData){
 		this.drillDownHashMap.clear();
	 	this.drillDownChartType=jsonData.chartType;
		var subdata=jsonData.subData;
 		var content = '<div id="container">';
		//content+='<div class="tableBorderHtml">';
		//content+= '<div style="width:100%;">';
			/*content+= '<div style="float:left;width:90%;">';
			//content+= publicJsonData.displayFields.reportTitle;
			content+= '</div>';*/
					/*
						save and print tool
					content+= '<div style="float:right;">';
						content+= '<div style="float:right;"><a href="javascript:void(0)" id="'+jsonData.urlFields.pdfUrl+'"><div class="iconSave"></div></a></div>';
						content+= '<div style="float:right;"><a href="javascript:void(0)" id="'+jsonData.urlFields.printUrl+'"><div class="iconPrinter"></div></a></div>';
					content+= '</div>';

					*/
		//content+= '</div>';

		//content+= '<hr/>';
		for (var i=0;i<subdata.length-1;i++ )
		{
			if(i==subdata.length-1)	//this condition wont execute for removing associated metrics content from this window
			{
				if (subdata[i].tableData[0].array.length>0)
				{
					content+= '<br/>';

								content+= '<p style="padding:0px 4px 4px 0px;"class="font_bold11">';
									content+= subdata[i].header;
								content+= '</p>';

								content += '<table border="0" id="tableId" class="tableBorderHtml" align="center"  height="100%">';
									content +='<thead>';
										content +='<tr>';
//						for (var key in subdata[i].cols) {
//								if (subdata[i].cols.hasOwnProperty(key)) {
//											content+= '<th class="theadBorderHtml">';
//												content+= subdata[i].cols[key];
//											content+= '</th>';
//								}
//							}

									for (var td=0;td<Object.keys(subdata[i].cols).length;td++){
										var key='c'+(td+1);
										if (subdata[i].cols.hasOwnProperty(key)) {
											content+= '<th class="theadBorderHtml">';
											content+= subdata[i].cols[key];
											content+= '</th>';
										}
									}


										content+= '</tr>';
									content +='</thead>';
									content +='<tbody>';
						for (var m = 0; m < subdata[i].tableData.length; m++)
						{
							var test = subdata[i].tableData[m].test;
							var rowsp = subdata[i].tableData[m].array.length;
							var heit=rowsp*30;
										content += '<tr class="tableTrBgEven">';
											content += '<td rowspan="' + rowsp + '" class="x-grid-cell x-grid-cell-first" style="padding:6px;">';
												content += subdata[i].tableData[m].test;
											content += '</td>';
							if (rowsp > 1)
							{
								for (var c=0;c<subdata[i].tableData[m].array.length;c++ )
								{
									if (c !== 0){
										content += '<tr class="tableTrBgEven">';
									}
											content += '<td class="tdBorderHtml">';
												content += subdata[i].tableData[m].array[c].measure;
											content += '</td>';

											content += '<td class="tdBorderHtml">';
												content += subdata[i].tableData[m].array[c].health;
											content += '</td>';
										content += '</tr>';
								}
							}
							else
							{
											content += '<td class="tdBorderHtml">';
												content += subdata[i].tableData[m].array[0].measure;
											content += '</td>';
											content += '<td class="tdBorderHtml">';
												content += subdata[i].tableData[m].array[0].health;
											content += '</td>';
										content += '</tr>';
							}
						}
										content +='</tbody>';
									content+= '</table>';
				}
			}
			else
			{
				var tableTrBgEven='tableTrBgEven';

					content+= '<table  align="center" width="100%" >';
				//1
						content +='<thead>';
							content +='<tr>';
								content+= '<th class="newFont_bold13">';
							if(subdata[i].hasOwnProperty('count')){
									content+= subdata[i].count;
							}
									content+= subdata[i].header1;
								content+= '</th>';
							content+= '</tr>';
						//content +='<tr class="reportTrBgColor">';
						//content +='<td ><div class="border_bottomtable"></div></td>';
						//content +='</tr>';
						content +='</thead>';
					//2
						content +='<tbody>';
							content+= '<tr>';
								content+= '<td >';
								content+= '<div class="divBoxOne" style="margin:5px 0px 10px 0px">';
									content+='<div id="div1" style="margin-right:30px;float: left;" class="formSelectionName">';
									content+= subdata[i].label1;
									content+= '<span class="formSelectionValue">'+subdata[i]['label1-1']+'</span>';
									content+='</div>',
									content+='<div id="div2" style="margin-right:30px;float: left;" class="formSelectionName">';
									content+= subdata[i]['label2-1'];
									content+= '<span class="formSelectionValue">'+subdata[i]['label2-2']+'</span>';
									content+='</div>',
									content+='<div id="div3" style="margin-right:30px;float: left;" class="formSelectionName">';
									content+= subdata[i]['label2-3'];
									content+= '<span class="formSelectionValue">'+subdata[i]['label2-4']+'</span>';
									content+='</div>',
									content+= '</td>';
									content+= '</div>';
							content+= '</tr>';
					//3


					//4
							content+= '<tr>';
								content+= '<td>';
									content+= '<div style="margin:0px 0px 10px 0px;">';
										content+='<div class="newTableHeader">';
											content+= '<div style="float:left;line-height:1.7em" class="newFont_bold13">';
												content+= subdata[i].label3;
											content+= '</div>';
											content+= '<div style="float:right;padding:0px 0px 0px 8px;"><a href="javascript:void(0)" id="'+subdata[i].label4Param+'" class="newHtmlButton"  >';
												content+= subdata[i].label4;
											content+= '</a></div>';
										content+='</div>';
										content+='<div class="newTable">';
											content+= '<table border="0" width="100%" >';
												content+= '<thead>';
													content+= '<tr>';
//								for (var key in subdata[i].table.cols) {
//									console.log('key----',key)
//									if (subdata[i].table.cols.hasOwnProperty(key)) {
//														content+= '<th>';
//															content+= subdata[i].table.cols[key];
//														content+= '</th>';
//									}
//								}
								for (var td=0;td<Object.keys(subdata[i].table.cols).length;td++){
									var key='c'+(td+1);
									if (subdata[i].table.cols.hasOwnProperty(key)) {
														content+= '<th>';
															content+= subdata[i].table.cols[key];
														content+= '</th>';
									}
								}
								content+= '</tr>';
								content+= '</thead>';
								content+= '<tbody';

						for (var tr=0;tr<subdata[i].table.tableData.length;tr++) {
							tableTrBgEven='tableTrBgEven';
							if(tr%2==0)
							{
								tableTrBgEven='tableTrBgEven1';
							}
							else
							{

							}
													content+= '<tr>';
							for (var td=0;td<subdata[i].table.tableData[tr].row.length;td++)
							{
														content+= '<td>';
								if (subdata[i].table.tableData[tr].row[td].hasOwnProperty('tdParam'))
								{
												if(subdata[i].table.tableData[tr].row[td].tdText=="View Diagnosis")
												{

															content+='<a href="javascript:void(0)" id="'+ subdata[i].table.tableData[tr].row[td].tdParam+'" style="margin-left: 60px;" >';
															content+='<img src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" class="iconDiagnosis" valign="middle">';
															content+= '</img>';
															content+= '</a>';

												}
												else
												{
															content+='<a href="javascript:void(0)" id="'+ subdata[i].table.tableData[tr].row[td].tdParam+'" class="anchorLink">';
															content+= subdata[i].table.tableData[tr].row[td].tdText;
															content+= '</a>';
												}
								}
								else
								{
														content+=subdata[i].table.tableData[tr].row[td].tdText;
								}
														content+= '</td>';
							}
													content+= '</tr>';
						}
										
												content+= '</tbody>';
											content+= '</table>';
										content+= '</div>';
									content+='</div>';
								content+= '</td>';
							content+= '</tr>';
					//8 chart img


							content+= '<tr>';
								content+= '<td align="center">';
									content+= '<table width="100%">';
										content+= '<tr>';
											content+= '<td align="center" style="padding:4px">';
												content+= '<b style="padding:4px" class="newFont_bold13">'+subdata[i].label5+'</b><div class="iconMaximize" style="float:right;cursor:pointer;" onclick="javascript:loadUrlInDrillDown(\''+subdata[i].imageServletExpandUrl+'\');"></div><br/>';
 												if (jsonData.chartType=='highchart')
												{
													var key="highchart_"+i;
													content+= '<div id='+key+' style="height:350px;"></div>';
													var legLength=((subdata[i].boxImageServlet.length)*24)+25;
													content+= '<div id=legend_'+key+' style="height:'+legLength+'px;"></div>';
													this.drillDownHashMap.add(key, subdata[i].imageServlet);
   												}
												else
												{
													content+= '<img src="'+subdata[i].imageServlet+'" height="350px" ></img>';
												}

											content+= '</td>';
										content+= '</tr>';

//										content+= '<tr>';
//											content+= '<td style="padding:4px;" align="center"><table align="center">';
//												content+= '<tr>';
//												var count=0;
//												for (var tr=0;tr<subdata[i].boxImageServlet.length;tr++)
//												{
//													if (count==3)
//													{
//														count=0;
//														content+= '</tr>';
//														content+= '<tr>';
//													}
////													content+= '<td align="center" style="padding:4px;">';
//// 														content+= '<div><div style="float:left;margin-right:4px;"><img src="'+subdata[i].boxImageServlet[tr]+'"></img></div>';
////														content+='<div style="float:left;margin-right:4px" class="font_normal11">'+ subdata[i].label6[tr]+'</div></div>';
//// 													content+= '</td>';
//													content+= '<td style="padding:4px;">';
// 														content+= '<table><tr><td style="float:left;margin-right:4px;"><img src="'+subdata[i].boxImageServlet[tr]+'"></img></td>';
//														content+='<td style="margin-right:4px;margin-top:4px" class="font_normal11">'+ subdata[i].label6[tr]+'</td></tr></table>';
// 													content+= '</td>';
//													count++;
//
//												}
//											content+= '</tr></table></td>';
//										content+= '</tr>';
									content+= '</table>';
								content+= '</td>';
							content+= '</tr>';
					//8 chart img
					if (!Ext.isEmpty(subdata[i].label7))
					{

//							content+= '<tr>';
//								content+= '<td class="recomm_footerline">';
//								content+='<div style="margin: 10px;" class="datapanel">';
//								content+= '<div style="margin: 10px 10px 0px 10px;" class="font_bold11">'+subdata[i].label7+'</div>';
//									content+= '<div style="padding:10px;" class="textFromHelpPage"><table><tr>'+subdata[i].label8+'</tr></table></div>';
//									content+='</div>';
//								content+= '</td>';
//							content+= '</tr>';

							content+= '<tr>';
								content+= '<td width="100%">';
									content+='<div class="notes" style="margin-bottom:15px;width:100%">';
										content+= '<div class="paperPin"></div>';
										content+= '<div class="textFromHelpPage"><table width="100%"> <tr>'+subdata[i].label8+'</tr></table></div>';
									content+='</div>';
								content+= '</td>';
							content+= '</tr>';
						}


						content +='</tbody>';
					content+= '</table>';
					//content+= '<div style="height:13px;background:#fff"></div>';
			}
		}
		   //  content+='</div>';
			content+= '</div>';
		return content;
	},
	getContentPanel:function(content,contentTitle){
 		var me=this;
		  var dataContainer = Ext.create('Ext.panel.Panel',{
			//margin:10,
			ui:'newOuterPanel',
			//cls:'mytable_shadow',
			id:'commonPanelId',
			title:contentTitle,		   //$('#cont-body').jScrollPane();
            scroll: true,
            //bodyPadding: '5 5 5 5',
            border:false,
			frame:false,
			items:[{
				xtype:'panel',
				id: 'cont',
				margin:10,
				bodyPadding:10,
				ui:'newGraphPanel',
				html: content,
				listeners: {
					'afterRender': function()
					{
						if (Ext.get('tableId')!=null)
						{
							me.getTROddEvenBG('tableId');
						}
						var el = Ext.get('cont');
						el.on('click', function(event, target, options)
						{
							//alert(target.id);
							me.getPopUpRequest(target.id);
						},
						this,
						{
							delegate: 'a'
						});
					}
				}
			}],
		});
		//me.getTROddEvenBG('tableId');
		return dataContainer;
	},
	getHealthDetailsContent:function(jsonData)
	{
		var JSONObject=jsonData;

				//var content='<p class="heading_border">'+JSONObject.dataHeader+'</p>';

			var content='<div class="newTableHeader">';
					content+= '<div style="float:left;line-height:1.7em" class="newFont_bold13">';
						content+= JSONObject.dataHeader;
					content+= '</div>';
				content+='</div>';

				content += '<div class="newTable" align="center" width="100%">';
					content += '<table id="tableId" border="0" align="center" width="100%">';
						content +='<thead>';
							content +='<tr>';
								content += '<th>'+JSONObject.dataColumn['c1']+'</th>';
								content += '<th>'+JSONObject.dataColumn['c2']+'</th>';
							if (JSONObject.dataColumn.hasOwnProperty('c3'))
							{
								content += '<th>'+JSONObject.dataColumn['c3']+'</th>';
							}
								content += '<th>'+JSONObject.dataColumn['c4']+'</th>';
							content +='</tr>';
						content +='</thead>';
						content +='<tbody>';

				for (var i = 0; i < JSONObject.tableData.length; i++)
				{
					var test = JSONObject.tableData[i].test;
					var rowsp = JSONObject.tableData[i].array.length;
					var heit=rowsp*30;
							content += '<tr>';		//height="'+heit+'px"
								content += '<td rowspan="' + rowsp + '" class="rowspanRightBorder" valign="top">';
									content += JSONObject.tableData[i].test;
								content += '</td>';
					if (rowsp > 1)
					{
						for (var c=0;c<JSONObject.tableData[i].array.length;c++ )
						{
							if (c !== 0)
							content += '<tr>';
								content += '<td>';
									content += JSONObject.tableData[i].array[c].measure;
								content += '</td>';
							if (JSONObject.dataColumn.hasOwnProperty('c3'))
							{
								content += '<td>';
									content += JSONObject.tableData[i].array[c].info;
								content += '</td>';
							}
								content += '<td>';
									content += JSONObject.tableData[i].array[c].health;
								content += '</td>';

							content += '</tr>';
						}
					}
					else
					{
							content += '<td>';
								content += JSONObject.tableData[i].array[0].measure;
							content += '</td>';
						if (JSONObject.dataColumn.hasOwnProperty('c3'))
						{
							content += '<td>';
								content += JSONObject.tableData[i].array[0].info;
							content += '</td>';
						}
							content += '<td>';
								content += JSONObject.tableData[i].array[0].health;
							content += '</td>';

						content += '</tr>';
					}
				}
						content +='</tbody>';
					content += '</table>';
				content += '</div>';

            return content;
	},
	orderByLayerAscending:function(a, b) {
                if (a.text === b.text) {
                    return 0;
                } else if (a.text > b.text) {
                    return 1;
                }
                return -1;
   	 },
	getForeGroundTierData:function(temer_healthsummary)
	{	//	alert(" showing tier data getForeGroundTierData");

		var JSONObject=appConstants.publicJsonData.data;
		//console.log(JSONObject.tableData);
		var content;
		if (JSONObject.tableData.length>0)
		{
			//content = '<div class="x-table">';
			content = '<table border="0" id="tierWiseTable" class="tableBorderHtml" align="center" width="100%" height="100%">';
			content +='<thead>';
				content +='<tr>';
					if(temer_healthsummary == 'At Tier Level')
					{
						content += '<th width="15%" align="center" class="theadBorderHtml" style="padding-left: 15px;">'+JSONObject.dataColumn['c1']+'</th>';
						JSONObject.tableData.sort(this.orderByLayerAscending);
						//console.log(JSONObject.tableData);
					}
					content += '<th width="15%" align="center" class="theadBorderHtml" style="padding-left: 10px;">'+JSONObject.dataColumn['c2']+'</th>';
					content += '<th width="70%" align="center" class="theadBorderHtml" style="padding-left: 10px;">'+JSONObject.dataColumn['c3']+'</th>';
				content +='</tr>';
			content +='</thead>';
			content +='<tbody>';
            for (var i = 0; i < JSONObject.tableData.length; i++)
            {
                var text = JSONObject.tableData[i].text;
                var count = 1;
                for (c = i + 1; c < JSONObject.tableData.length; c++)
                {
					if(temer_healthsummary == 'At Tier Level'){
						if (text === JSONObject.tableData[c].text)
		                    count++;
					}
                }
				var rowsp = count;
				var heit=count*30;
				content += '<tr>';  //height="'+heit+'%"
				if(temer_healthsummary == 'At Tier Level'){
					content += '<td rowspan="' + rowsp + '" align="left" style="text-align:left;valign:middle;padding-left: 15px;line-height: 1em;" class="tdBorderHtml">';
						content += JSONObject.tableData[i].text;
					content += '</td>';
				}
				if (rowsp > 1)
				{
					var g = 0;
					for (i; g <count; i++)
					{
						if (g !== 0){
				content += '<tr>';	//height="30%"
						}
					content += '<td align="left" id="'+JSONObject.tableData[i].array[0].textQuery+'" style="text-align:left;valign:middle;padding-left: 10px;line-height: 1em;" class="tdBorderHtml handSymbol">';
					content += '<span class="anchorLink">'+JSONObject.tableData[i].array[0].text+'</span>';
					content += '</td>';

					content += '<td class=" class="tdBorderHtml">';
						content += '<table border="0" width="100%" height="100%" style="padding:0.2px">';
							content += '<tr>';
						for (var j = 0; j < JSONObject.tableData[i].array[0].array.length; j++)
						{
							var m = JSONObject.tableData[i].array[0].array.length;
							var p = Math.round(100 / m);
							var marg;
							if(j==JSONObject.tableData[i].array[0].array.length-1)
							marg='0px';
							else
							marg='4px';
									content += '<td class="kpiTableTdBorderWithRowspan" style="background-color:'+JSONObject.tableData[i].array[0].array[j].bgcolor+';color:#000000;text-align:center;valign:middle;" align="center" id="'+ JSONObject.tableData[i].array[0].array[j].query+'">';
									content += '<div style="padding:6px;line-height: 1em;" class="handSymbol">';
									content += JSONObject.tableData[i].array[0].array[j].displayName;
									content += '<br/>';
									content += JSONObject.tableData[i].array[0].array[j].health;
									content += '</div>';
								content += '</td>';

						}
							content += '</tr>';
						content += '</table>';
					content += '</td>';

				content += '</tr>';
						g++;
					}
					i--;
				}
				else
				{	
					
					content += '<td id="'+JSONObject.tableData[i].array[0].textQuery+'" style="text-align:left;valign:left;padding-left: 10px;line-height: 1em;" class="tdBorderHtml handSymbol">';
					content += '<span class="anchorLink">'+JSONObject.tableData[i].array[0].text+'</span>';
					
					content += '</td>';
					
					content += '<td class="tdBorderHtml">';
						content += '<table border="0" width="100%" height="100%" >';
							content += '<tr>';
					for (var j = 0; j < JSONObject.tableData[i].array[0].array.length; j++)
					{
					   // var borderClass;
						//if(j==0||j==JSONObject.tableData[i].array[0].array.length-1)
						//borderClass='ex3';
						//else
						//borderClass='ex1';
   						//alert(j+'=='+borderClass);
						var marg;
						if(j==JSONObject.tableData[i].array[0].array.length-1)
						marg='0px';
						else
						marg='4px';
						var m = JSONObject.tableData[i].array[0].array.length;
						var p = Math.round(100 / m);
								content += '<td align="center" id="'+ JSONObject.tableData[i].array[0].array[j].query+'" height="100%" style="background-color:'+JSONObject.tableData[i].array[0].array[j].bgcolor+';color:#000000;text-align:center;valign:middle;" class="kpiTableTdBorder">';
								if(JSONObject.tableData[i].array[0].array[j].bgcolor=="#dd3939")
								{
									content += '<div style="padding: 6px;line-height: 1em;color:#ffffff" class="handSymbol">';
									content += '<span class="font_bold11">',
 									content += JSONObject.tableData[i].array[0].array[j].health;
									content += '</span>',
									content += '<br/>';
									content += JSONObject.tableData[i].array[0].array[j].displayName;
									content += '</div>';
									}
									else
									{
									content += '<div style="padding: 6px;" class="handSymbol">';
									content += '<span class="font_bold11">',
 									content += JSONObject.tableData[i].array[0].array[j].health;
									content += '</span>',
									content += '<br/>';
									content += JSONObject.tableData[i].array[0].array[j].displayName;
									content += '</div>';
									}
								content += '</td>';
					}
							content += '</tr>';
						content += '</table>';
					content += '</td>';
				content += '</tr>';
				}
			}

			content +='</tbody>';
			content += '</table>';
			//content += '</div>';
		}
		else
		{
			content={
				xtype:'container',
 				height:300,
				style:{'text-align':'center','padding':'50px 0px'},
				html:'<div class = "iconExclamation" style="margin:0 auto;"></div><div>No Measures Available</div>'
			};
 		}

		   return content;
	},
	getForeGroundServerData:function()
	{
		//alert(" showing tier data getForeGroundServerData");

		var JSONObject=appConstants.publicJsonData.data;
		var content;
		if (JSONObject.tableData.length>0)
		{
			content= '<table border="0" id="serverWiseTable" class="tableBorderHtml" align="center" width="100%" height="100%">';
				content +='<thead>';
					content +='<tr>';
						//content += '<th width="10%" class="theadBorderHtml" align="center">'+JSONObject.dataColumn['c1']+'</th>';
						content += '<th width="10%" class="theadBorderHtml" align="center">'+JSONObject.dataColumn['c2']+'</th>';
						content += '<th width="10%" class="theadBorderHtml" align="center">'+JSONObject.dataColumn['c3']+'</th>';
						content += '<th width="70%" class="theadBorderHtml" align="center">'+JSONObject.dataColumn['c4']+'</th>';
					content +='</tr>';
				content +='</thead>';
				content +='<tbody>';
            for (var i = 0; i < JSONObject.tableData.length; i++)
            {
                var text = JSONObject.tableData[i].sText;
                var count = 1;
                for (c = i + 1; c < JSONObject.tableData.length; c++)
                {
                    if (text === JSONObject.tableData[c].sText)
                        count++;
                }
                var rowsp = count;
				var heit=count*30;
					content += '<tr class="tableTrBgEven">';   //height="'+heit+'%"
						/*content += '<td rowspan="' + rowsp + '" align="center" class="tdBorderHtml">';
							content += JSONObject.tableData[i].text;
						content += '</td>';*/

						content += '<td rowspan="' + rowsp + '" align="center" style="text-align:center;valign:middle;" class="tdBorderHtml">';
							content += JSONObject.tableData[i].sText;
						content += '</td>';
				if (rowsp > 1)
				{
					var g = 0;
					for (i; g <count; i++)
					{
						if (g !== 0){
					content += '<tr class="tableTrBgEven">';
						}
						content += '<td align="center" style="text-align:center;valign:middle;" class="tdBorderHtml">' ;
							content += JSONObject.tableData[i].array[0].text;
						content += '</td>';

						content += '<td class="tdBorderHtml">';
							content += '<table border="0" width="100%" height="100%">';
								content += '<tr>';
						for (var j = 0; j < JSONObject.tableData[i].array[0].array.length; j++)
						{
							//var m = JSONObject.tableData[i].array[0].array.length;
							//var p = Math.round(100 / m);
							//width="' + p + '%"
							var marg;
							if(j==JSONObject.tableData[i].array[0].array.length-1)
							marg='0px';
							else
							marg='4px';

								content += '<td class="kpiTableTdBorder" style="background-color:'+JSONObject.tableData[i].array[0].array[j].bgcolor+';color:#000000;text-align:center;valign:middle;min-width:32px;" align="center" id="'+JSONObject.tableData[i].array[0].array[j].query+'">';
								if(JSONObject.tableData[i].array[0].array[j].bgcolor=="#dd3939")
								{
//									content += '<div style="padding: 6px;color:white" class="handSymbol">';
									content += '<div style="color:white" class="handSymbol">';
									content += '<span class="font_bold11" style="color:white">',
 									content += JSONObject.tableData[i].array[0].array[j].health;
									content += '</span>',
									content += '<br/>';
									content += JSONObject.tableData[i].array[0].array[j].displayName;
									content += '</div>';
								}
								else
								{
									content += '<div style="padding-top: 6px;padding-bottom: 6px;" class="handSymbol">';
									content += '<span class="font_bold11">',
 									content += JSONObject.tableData[i].array[0].array[j].health;
									content += '</span>',
									content += '<br/>';
									content += JSONObject.tableData[i].array[0].array[j].displayName;
									content += '</div>';
								}
								content += '</td>';
							}
								content += '</tr>';
							content += '</table>';
						content += '</td>';
					content += '</tr>';
						g++;
					}
					i--;
				}
				else
				{
						content += '<td align="center" style="text-align:center;valign:middle;" class="tdBorderHtml">';
							content += JSONObject.tableData[i].array[0].text;
						content += '</td>';

						content += '<td class="tdBorderHtml">';
							content += '<table border="0" width="100%" height="100%">';
								content += '<tr>';
						for (var j = 0; j < JSONObject.tableData[i].array[0].array.length; j++)
						{
						var marg;
						if(j==JSONObject.tableData[i].array[0].array.length-1)
						marg='0px';
						else
						marg='4px';
						//var m = JSONObject.tableData[i].array[0].array.length;
						//var p = Math.round(100 / m); width="' + p + '%"
										content += '<td  align="center" class="kpiTableTdBorder" style="background-color:'+JSONObject.tableData[i].array[0].array[j].bgcolor+';color:#000000;text-align:center;valign:middle;"id="'+JSONObject.tableData[i].array[0].array[j].query+'" height="100%">';
										content += '<div style="padding: 6px;" class="handSymbol">';
										content += '<span class="font_bold11">',
 									content += JSONObject.tableData[i].array[0].array[j].health;
									content += '</span>',
									content += '<br/>';
									content += JSONObject.tableData[i].array[0].array[j].displayName;
									content += '</div>';
 									content += '</td>';
								}
								content += '</tr>';
							content += '</table>';
						content += '</td>';
					content += '</tr>';
							}
						}

				content +='</tbody>';
				content += '</table>';
		}
		else
		{
			content={
				xtype:'container',
 				height:300,
				style:{'text-align':'center','padding':'50px 0px'},
				html:'<div class = "iconExclamation" style="margin:0 auto;"></div><div>No Measures Available</div>'
			};
 		}
            return content;
 	},
	validateMainForm: function () {
		var analyzeByObj=Ext.getCmp('er_option');
		var seg_ser_zoneObj=Ext.getCmp('er_site');
 		var componentTypeObj=Ext.getCmp('er_comptype');

		var analyzeByCombo_jsonProperty='analyzeByCombo';
		var seg_ser_zoneCombo_jsonProperty;
		if(analyzeByObj.getValue()=='Zone')
		seg_ser_zoneCombo_jsonProperty='zoneCombo';
		else if(analyzeByObj.getValue()=='segment')
		seg_ser_zoneCombo_jsonProperty='segmentCombo';
		else if(analyzeByObj.getValue()=='service')
		seg_ser_zoneCombo_jsonProperty='serviceCombo';
		else
		{//do nothing
		}
 		var componentTypeCombo_jsonProperty='componentTypeCombo';

		 if(this.validateFormField(analyzeByObj.getValue(),analyzeByObj,analyzeByCombo_jsonProperty))
		  {
			if(this.validateFormField(seg_ser_zoneObj.getValue(),seg_ser_zoneObj,seg_ser_zoneCombo_jsonProperty))
			  {
			  	   if (this.validateFormField(componentTypeObj.getValue(),componentTypeObj,componentTypeCombo_jsonProperty))
				   {
						return true;
				   }
			  }
		  }
	},
	validateFormField:function(objValue,obj,jsonProperty)
	{

		if(appConstants.publicJsonData.combo.hasOwnProperty(jsonProperty))
		{
		   if(objValue=='-1'||objValue=='Not Applicable'||objValue=='')
			{
				Ext.MessageBox.show({
							title: appConstants.publicJsonData.displayFields.reportTitle,
							msg: obj.getStore().getAt(0).get('displayField'),
							buttons: Ext.MessageBox.OK,
							icon: Ext.MessageBox.WARNING
						});
						return false;
			}else
			{

				return true;
			}
		}
		else
		{
			 return true;
		}
	},
	subZoneOnChange:function()
	{
		Ext.getCmp('resultPanel').hide();
		this.disableTools();
		this.updateFormQueryString(true,true,false,false,false,false,false);
		this.updateAjaxFormData(false);
	},
	healthSummaryOnChange:function()
	{
	    Ext.getCmp('resultPanel').hide();
		this.disableTools();
	},
	seg_serv_zoneOnChange:function()
	{
	    //syntax---7arguments---updateFormQueryString(isErOption,isErSite,isCompType,isHealthSummary,isHidddens,isSettings,isReportGeneration){
	    Ext.getCmp('resultPanel').hide();
		this.disableTools();
		this.updateFormQueryString(true,true,false,false,false,false,false);
		this.updateAjaxFormData(false);
	},
	analyzeByOnChange:function()
	{
		Ext.getCmp('resultPanel').hide();
		this.disableTools();
 		this.updateFormQueryString(true,false,false,false,false,false,false);
		this.updateAjaxFormData(false);
	},
	updateFormQueryString:function(isErOption,isErSite,isCompType,isHealthSummary,isHidddens,isSettings,isReportGeneration)
	{
		var params='';
		var timefrom,minfrom,timeto,minto,er_excwe,reportGeneration,bg_reportname;
		if (isSettingsEnabled)
		{
			timefrom=Ext.getCmp('timefrom').getValue();
			minfrom=Ext.getCmp('minfrom').getValue();
			timeto=Ext.getCmp('timeto').getValue();
			minto=Ext.getCmp('minto').getValue();
			er_excwe=Ext.getCmp('er_excwe').getValue();
			reportGeneration=Ext.getCmp('reportGeneration').getValue();
			bg_reportname=Ext.getCmp('bgReportName').getValue();
		}
		else
		{
			var localjson=appConstants.publicJsonData.selectedFields;
			timefrom=localjson.hrsFromSelected;
			minfrom=localjson.minsFromSelected;
			timeto=localjson.hrsToSelected;
			minto=localjson.minsToSelected;
			er_excwe=localjson.excludeWeekendsComboSelected;
			reportGeneration=localjson.reportGenerationComboSelected;
			bg_reportname=localjson.bgReportName;
		}
		var url='/final/reporter/ErInfrastructureHealthReportJSON.jsp';
		if(isErOption)
		{
		  params+='er_option='+Ext.getCmp('er_option').getValue();
		}
		if (isErSite)
		{
			var er_option= Ext.getCmp('er_option').getValue();
			var er_site=Ext.getCmp('er_site').getValue();
			if(er_option=='Zone')
			{
				params+='&er_site='+er_site+'&er_includezones='+Ext.getCmp('er_includezones').getValue();
			}
			else if(er_option=='Segment'||er_option=='Service')
			{
				params+='&er_site='+er_site;
			}
			else
			{
				//do nothing
			}
		}
		if (isCompType)
		{
			  var compArray=Ext.getCmp("er_comptype").getValue();
			  for(var k=0;compArray.length>k;k++)
			  {
				params+="&er_comptype="+compArray[k];
			  }
		}
		if (isHealthSummary)
		{
			 params+="&er_healthSummary="+Ext.getCmp("er_healthSummary").getValue();
		}
		if (isHidddens)
		{
			if(appConstants.publicJsonData.hasOwnProperty('hiddenFields'))
			{
				var hiddenFields = appConstants.publicJsonData.hiddenFields;
				for (var hiddenField in hiddenFields)
				{
					params+="&"+hiddenField+"="+hiddenFields[hiddenField];
				}
			}
		}
		if (isSettings)
		{			
			var startDateM = Ext.getCmp('er_stdate').dataArray;
			var endDateM = Ext.getCmp('er_enddate').dataArray;
			params+= "&er_timeline=" + Ext.getCmp('er_timeline').getValue() + "&startdate=" + startDateM + "&enddate=" + endDateM + "&starthr=" + Ext.getCmp('er_sthr').dataArray + "&endhr=" + Ext.getCmp('er_endhr').dataArray + "&startmin="+mgr_stmin+"&endmin="+mgr_enmin;

			params+="&timefrom="+timefrom+"&minfrom="+minfrom+"&timeto="+timeto+"&minto="+minto;

			params+="&er_excwe="+er_excwe;
		}

		if (isReportGeneration)
		{
		  // var reportGeneration=Ext.getCmp('reportGeneration').getValue();
			if (reportGeneration == 'foreground') {
				url='../servlet/com.eg.ErInfrastructureHealthReportC';
				params+="&er_reportgenration="+reportGeneration+"&option=data&isSubmit=true&responseType=json";
			} else{
				url='../servlet/com.eg.ErStartBackGroundReportC';
				//var bg_reportname = Ext.getCmp('bgReportName').getValue();
				bg_reportname=checkFileName(bg_reportname);
				params+="&bg_reportname="+bg_reportname+"&isSubmit=true&responseType=json";
			}
		}

		appConstants.queryString=url+'?'+encodeURI(params);
	   	appConstants.queryString +="&er_RmDispName="+appConstants.er_RmDispName+"&pageWidthProces=1024";
	
	},
	updateAjaxFormData:function(isFormSubmitted)
    {
		this.getNomeasurepanel().hide();
		this.getBackGroundPanel().hide();
  		Ext.Ajax.request(
				{
					url : appConstants.queryString,
 					//params :queryString,
					scope:this,
					async: true,
					success: function(response){
						var jsonText = response.responseText;
						var jsonData=Ext.decode(jsonText);
						appConstants.publicJsonData=jsonData;
						if(isFormSubmitted)
						{
							 this.loadReportData();
						}
						else
						{

							this.fillMainFormFields();
							//this.fillSettingsFields();
						}
					}
				});
   },
//	this.loadComboField('componentTypeCombo','er_comptype','componentTypeComboLabel','componentTypeComboSelected',publicJsonData);

	loadComboField:function(comboProperty,comoboObject,comboLabelProperty,comboSelectedProperty,parentJsonProperty)
   {
		 var obj = Ext.getCmp(comoboObject);
		 if(comoboObject=='er_comptype')
	     {
 			 appConstants.rawDataForComponents=parentJsonProperty.combo[comboProperty];
 		 }
 		 if(parentJsonProperty.combo.hasOwnProperty(comboProperty))
		 {
				var rawData = parentJsonProperty.combo[comboProperty];
 				obj.getStore().loadRawData(rawData);
				 if(parentJsonProperty.selectedFields.hasOwnProperty(comboSelectedProperty))
				 {
						var selection=parentJsonProperty.selectedFields[comboSelectedProperty];
						obj.setValue(selection);
				 }
				 else
				 {
						 obj.setValue(rawData[0].valueField);
				 }

				 if(parentJsonProperty.displayFields.hasOwnProperty(comboLabelProperty))
				 {
					if(comoboObject=='er_comptype')
					{
						var componentLabelObj=Ext.getCmp('componentLabel');
						var multiSelectComboObj=Ext.getCmp('multiSelectPanel');
						componentLabelObj.setText(parentJsonProperty.displayFields[comboLabelProperty]);
						multiSelectComboObj.show();
					}
					else
					{
						obj.setFieldLabel(parentJsonProperty.displayFields[comboLabelProperty]);
						obj.show();
					}
				 }
		 }
		 else
		 {
		 		if(comoboObject=='er_comptype')
				{
					var multiSelectComboObj=Ext.getCmp('multiSelectPanel');
					multiSelectComboObj.hide();
				}
				else
				{
					obj.hide();;
				}
		 }
	},
	fillMainFormFields:function(){
 	//argument syntax-----comboProperty,comoboObject,comboLabelProperty,comboSelectedProperty,globalJsonData
	var localjson=appConstants.publicJsonData;
	this.loadComboField('analyzeByCombo','er_option','analyzeByComboLabel','analyzeByComboSelected',localjson);
	var hiddenFields = localjson.hiddenFields;
	var from_schedule = hiddenFields["fromScheduleModify"];
	var fromFavoriteModify = hiddenFields["fromFavoriteModify"];
	if ((from_schedule != null && from_schedule == "Yes") || (fromFavoriteModify != null && fromFavoriteModify == "Yes")) {
		Ext.getCmp("submit").hide();
		Ext.getCmp("save").show();
		Ext.getCmp("favoriteTool").setDisabled(true);
	    Ext.getCmp("scheduleTool").setDisabled(true);
	}else{
		Ext.getCmp("submit").show();
		Ext.getCmp("save").hide();
	}
	var analyzeByValue=Ext.getCmp('er_option').getValue();
	if(analyzeByValue=='Zone')
	this.loadComboField('zoneCombo','er_site','zoneComboLabel','zoneComboSelected',localjson);
	else if(analyzeByValue=='Segment')
	this.loadComboField('segmentCombo','er_site','segmentComboLabel','segmentComboSelected',localjson);
	else
	this.loadComboField('serviceCombo','er_site','serviceComboLabel','serviceComboSelected',localjson);

	this.loadComboField('subZoneCombo','er_includezones','subZoneComboLabel','subZoneComboSelected',localjson);
	this.loadComboField('componentTypeCombo','er_comptype','componentTypeComboLabel','componentTypeComboSelected',localjson);
	this.loadComboField('healthSummaryCombo','er_healthSummary','healthSummaryComboLabel','healthSummaryComboSelected',localjson);


	this.loadComboField('timelineCombo','er_timeline','timelineComboLabel','timelineComboSelected',localjson);


	var start_hour=localjson.selectedFields.startHour;
	var end_hour=localjson.selectedFields.endHour;
	var start_date=localjson.selectedFields.startDate;
	var end_date=localjson.selectedFields.endDate;

	var startDateObj=Ext.getCmp('er_stdate');
	startDateObj.setValue(localjson.selectedFields.startDateForDisplay);
	startDateObj.dataArray = start_date;
	var startHrObj = Ext.getCmp('er_sthr');
	startHrObj.setValue(localjson.selectedFields.startHourForDisplay);
	startHrObj.dataArray = start_hour;
	var endDateObj = Ext.getCmp('er_enddate');
	endDateObj.setValue(localjson.selectedFields.endDateForDisplay);
	endDateObj.dataArray = end_date;
	var endHrObj = Ext.getCmp('er_endhr');
	endHrObj.setValue(localjson.selectedFields.endHourForDisplay);
	endHrObj.dataArray = end_hour;

	stmin = localjson.selectedFields.startMinForDisplay;
	enmin = localjson.selectedFields.endMinForDisplay;
	mgr_stmin = localjson.selectedFields.startmin;
	mgr_enmin = localjson.selectedFields.endmin;
 		 updatingAppSettings();
	},
	fillSettingsFields:function()
	{
		Ext.getCmp('moreOptionCloseId').show();
 		var hiddenFields = appConstants.publicJsonData['hiddenFields'];
		var favorite_id = hiddenFields["favorite_id"];
		if(!Ext.isEmpty(favorite_id)){
			Ext.getCmp('reportGeneration').setDisabled(true);
		}

		var localjson=appConstants.publicJsonData;
		Ext.getCmp('er_mode').hide();
		this.loadComboField('excludeWeekendsCombo','er_excwe','excludeWeekendsComboLabel','excludeWeekendsComboSelected',localjson);
		this.loadComboField('reportGenerationCombo','reportGeneration','reportGenerationComboLabel','reportGenerationComboSelected',localjson);
		//this.weekendOnChange();
		Ext.getCmp('timeperiodLbl').setText(localjson.displayFields['timePeriodlabel']);
		Ext.getCmp('timefrom').setValue(localjson.selectedFields.hrsFromSelected);
		Ext.getCmp('minfrom').setValue(localjson.selectedFields.minsFromSelected);
		Ext.getCmp('timeto').setValue(localjson.selectedFields.hrsToSelected);
		Ext.getCmp('minto').setValue(localjson.selectedFields.minsToSelected);
	},
	extractQueryString:function(){
		var query=appConstants.queryString.substring(appConstants.queryString.indexOf('?')+1,appConstants.queryString.length);
		// alert(query);
		 return query;
	},
	saveReportAsPDF:function(){
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		appConstants.erUtils.savePDF(appConstants.publicJsonData.urlFields.pdfUrl);
	
	},
	bookletQuery: function(obj)
	{
		var s_qryString = appConstants.publicJsonData.urlFields.pdfUrl.replace('../reporter/ErHtmlToSavePdf.jsp?','');
		return s_qryString;
	},
	bookletScheduleQuery: function(obj)
	{
		var bookletquery=this.extractQueryString()+"&option=data";
		return bookletquery;
	},
	bookletPreview:function()
	{
		this.printFile();
	},
	printFile:function(){
				parent.printWindowFn(appConstants.publicJsonData.urlFields.printUrl); //this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
	},
	sendMail:function(){
		Ext.widget('sendmail').show();
 	},
	saveCsv:function(){
		window.location='../servlet/egurkha.reporter.SaveInCSVFormat';
	},
	saveSchedule:function(btn){
		var isValid = this.validateMainForm();
		if( isValid && Ext.getCmp('er_timeline').getValue() == 'Any'){
				Ext.MessageBox.show({
				title: appConstants.publicJsonData.displayFields.reportTitle,
				msg: 'Chosen timeline not allowed',
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
				isValid=false;
		}

		if(isValid){
		this.updateFormQueryString_forSubmission();
		var target="/final/reporter/ErSaveSchedule.jsp?"+this.extractQueryString()+"&option=data&com.eg.CSRF_NONCE="+csrfToken;
		if (btn.getId()=='save')
		{
			//document.location=target+'&showSchWindow=no';
			target+='&showSchWindow=no';
			var urlNw=target.substr(0,target.indexOf("?"));
			var queryString=target.substr(target.indexOf("?")+1,target.length-1);
			var formSave = Ext.create('Ext.form.Panel');
			formSave.submit({
				url:urlNw,
				params:queryString,
				standardSubmit: true,
				method: 'POST'
			});
		}
		else
			parent.scheduleWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
		}
	},
	saveFavorite:function(btn){
		var isValid = this.validateMainForm();
		/* if(isValid && Ext.getCmp('er_timeline').getValue() == 'Any'){
				Ext.MessageBox.show({
				title: appConstants.publicJsonData.displayFields.reportTitle,
				msg: 'Chosen timeline not allowed',
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
			isValid=false;
		} */
		if(isValid){
		this.updateFormQueryString_forSubmission();
 		var hiddenFields = appConstants.publicJsonData['hiddenFields'];
		var favorite_id = hiddenFields["favorite_id"];
		var target="../servlet/com.eg.ErFavoriteC?"+this.extractQueryString()+"&er_view=GRAPH&cmd=client"+"&er_RmDispName="+appConstants.er_RmDispName+"&com.eg.CSRF_NONCE="+csrfToken;//&FavoriteId="+favorite_id;;
		if (btn.getId()=='save')
		{
			//document.location=target+'&showWindow=no'+'&FavoriteId='+favorite_id;
			target+='&showSchWindow=no'+'&FavoriteId='+favorite_id;
			var urlNw=target.substr(0,target.indexOf("?"));
			var queryString=target.substr(target.indexOf("?")+1,target.length-1);
			var formSave = Ext.create('Ext.form.Panel');
			formSave.submit({
				url:urlNw,
				params:queryString,
				standardSubmit: true,
				method: 'POST'
			});
		}
		else
			parent.favouriteWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp


		}
	},
	toggleForm:function(obj)
	{
		Ext.getCmp('panelinsidetoggle').show();
		var ornt = Ext.getCmp('mainform');
		if (ornt.isHidden())
		{
			ornt.show();
			Ext.getCmp('selectionDetails').hide();
		}
		else
		{
			ornt.hide();
			Ext.getCmp('selectionDetails').show();
		}
	},
	closeSettingAndSubmit:function()
	{
		if(this.validateAndCloseSettings())
		{
			this.showResult();
		}
	},
	validateAndCloseSettings :  function()
	{
		var timefrom = Ext.getCmp('timefrom').getValue();
		var minfrom = Ext.getCmp('minfrom').getValue();
		var timeto = Ext.getCmp('timeto').getValue();
		var minto = Ext.getCmp('minto').getValue();
		if(!checkTimePeriod(timefrom,minfrom,timeto,minto)){
			return false;
		}
		if (Ext.getCmp('reportGeneration').getValue() == 'background' && !validateTextBoxWithSpecialChars(Ext.getCmp('bgReportName').getValue(),'Attachment',true))
		{
			return false;
		}
		Ext.getCmp('submit').setDisabled(false);
		Ext.get('configMod').animate({duration: 500,to: {y: -500}});
		return true;
	 },
	validateSettings :function(){
		var isSettingsOk = true;
 		var MaxDaysInMonth = appConstants.publicJsonData['hiddenFields']['getMaxDaysInMonth'];
		var er_usertimeline = appConstants.publicJsonData['hiddenFields']['userTimeline'];
		var reportgen,reportName;
		if (isSettingsEnabled)
		{
			reportgen=Ext.getCmp('reportGeneration').getValue();
			reportName = Ext.getCmp('bgReportName').getValue();
		}
		else
		{
			reportgen=appConstants.publicJsonData.selectedFields.reportGenerationComboSelected;
			reportName=appConstants.publicJsonData.bgReportName;
		}

		var er_timeline=Ext.getCmp('er_timeline').getValue();
		var stDate = Ext.getCmp('er_stdate').getValue();
		var enDate = Ext.getCmp('er_enddate').getValue();
		var startHour = Ext.getCmp('er_sthr').getValue();
		var endHour = Ext.getCmp('er_endhr').getValue();
		stDate.setHours(startHour);
		enDate.setHours(endHour);

		if(!checkDateTime(stDate,enDate)){
			isSettingsOk = false;
		}
		if(er_usertimeline!=null && er_usertimeline != '-1'){
			var usertimelineValid = isUserTimelineLimitExceeded(er_usertimeline, MaxDaysInMonth,  stDate, enDate);
			if ( !usertimelineValid ){
				Ext.MessageBox.show({
				title: appConstants.publicJsonData.displayFields.reportTitle,
				msg:  _invalidUserTime,
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
				isSettingsOk = false;
			}
		}
		if ( reportgen!=null && reportgen == 'foreground' ){
			var limitforbg = appConstants.publicJsonData['hiddenFields']['limitforbg'];
			if(!Ext.isEmpty(limitforbg)){
				if(!checkTimeLineForBgLimit(limitforbg,MaxDaysInMonth,stDate,enDate)){
					Ext.MessageBox.confirm('Confirm', appConstants.forGrdReportConfirmMsg,this.showConfirmResult,this);
					isSettingsOk = false;
				}
			}
		}
		else{
			if(!validateTextBoxWithSpecialChars(reportName,'Attachment',true))
			isSettingsOk = false;
		}
		return isSettingsOk;
	},
	showConfirmResult : function(btn){
		if(btn=="yes")
		{
			if (isSettingsEnabled)
			{
				Ext.get('configMod').animate({duration: 500,to: {y: -500}});
			}
			Ext.getCmp('submit').setDisabled(false);
			this.submitReport();
		}
		else{
			if (!isSettingsEnabled)
			{
				this.getReporterSettings().down('button').fireHandler();
			}
 			var bgreportNameObj=Ext.getCmp('bgReportName');
			Ext.getCmp('reportGeneration').setValue('background');
			bgreportNameObj.setValue("");
			bgreportNameObj.show();
			bgreportNameObj.focus(false, 1000);
			this.showResult();
 		}
	},
	reportGenChange:function(){
		Ext.getCmp('resultPanel').hide();
		this.disableTools();
		var reportGenType=Ext.getCmp('reportGeneration').getValue();
		if(reportGenType== 'background'){
			Ext.getCmp('bgReportName').setValue("");
			Ext.getCmp('bgReportName').show();
			Ext.getCmp('submitViaSetting').show();
			Ext.getCmp('moreOptionCloseId').hide();
		}
		else{
			Ext.getCmp('bgReportName').hide();
			Ext.getCmp('submitViaSetting').hide();
			Ext.getCmp('moreOptionCloseId').show();
		}
	},

/*
	weekendOnChange:function(){
		var weekendvalue=Ext.getCmp('er_excwe').getValue();;
		var excludeDaysObj=Ext.getCmp('excludeDays');
		if(weekendvalue == 'Yes'){
			excludeDaysObj.show();
			excludeDaysObj.update(appConstants.publicJsonData.displayFields['excludedDaysLabel']);
		}
		else
		{
			excludeDaysObj.hide();
		}
	},
*/

	loadTools : function(){
		this.getNewUtilities().loadIcon(true, true, true, false, true, true, true, false, false, false,true);
		Ext.getCmp("favoriteTool").setDisabled(false);
		Ext.getCmp("scheduleTool").setDisabled(false);
	},
	disableTools: function(){
		Ext.getCmp("bookletTool").setDisabled(true);
		Ext.getCmp("saveTool").setDisabled(true);
		Ext.getCmp("printTool").setDisabled(true);
		Ext.getCmp("mailTool").setDisabled(true);
		Ext.getCmp("upbutton").setDisabled(true);
		Ext.getCmp("csvTool").setDisabled(true);
	},

	afterMainRender:function(){
		this.disableTools();
		if(!appConstants.hideBackButton){
			Ext.getCmp('healthReportForm').add(
				{
					xtype: 'hidden',
					id: 'ID',
					name: 'ID',
					value: appConstants.publicJsonData['ID']
				}
			);
		}
		if (appConstants.er_RmDispName!= null && appConstants.er_RmDispName!= 'null')
			this.getMain().setTitle(appConstants.er_RmDispName);
		else
			this.getMain().setTitle(appConstants.publicJsonData.displayFields.reportTitle);
		var hiddenFields =  appConstants.publicJsonData['hiddenFields'];
		var fromScheduleModify = hiddenFields["fromScheduleModify"];
		
	
		if(fromScheduleModify==null || fromScheduleModify=='null')
		this.refreshReportData();
		this.registerAjaxEvents();
	},
	registerAjaxEvents:function(){
		Ext.Ajax.on('beforerequest', function(conn, response, opts) {
			Ext.get(document.body).mask('Loading ...');
		});
		Ext.Ajax.on('requestcomplete', function(conn, response, opts) {
			Ext.get(document.body).unmask();
		});
		Ext.Ajax.on('requestexception', function(conn, response, opts) {
			Ext.get(document.body).unmask();
			if (response.timedout) {
					alert('ajax timeout exception occured...');
			}
			else
			{
				alert('server-side failure with status code ' + response.status);
			}
		});
	},
	refreshReportData:function(){
		var hiddenFields =  appConstants.publicJsonData['hiddenFields'];
		var fromFavoriteModify = hiddenFields["fromFavoriteModify"];
		if(appConstants.isSubmit=="true" && (fromFavoriteModify == null || fromFavoriteModify == 'null'))
		{
			this.loadReportData();
		}
		else
		{
			if(appConstants.isForceSubmit=='true')
			{
				appConstants.isForceSubmit='false';
				this.showResult();
			}
		}
	},
	expandMe:function(btn){
		if (Ext.isEmpty(appConstants.erUtils))
		{
		appConstants.erUtils = Ext.widget("erutils");
		}
		appConstants.erUtils.expandMultiComboButton(Ext.getCmp('er_comptype'),Ext.getCmp('componentLabel').text,btn);
	}
});

