// JavaScript Document

Ext.define('HistogramReportApp.view.LTDReportsForm',{
	extend:'Ext.form.FieldContainer',
	alias:'widget.LTDReportsForm',
	collapseMode:'mini',
	id:'LTDReportsForm',
	layout:'column',
	defaults:{
		labelAlign:'top',
		 margin:'0 20 10 0',
		labelSeparator:''
	},
	items:[
			{
				xtype:'scrollcombo',
				cls: 'dropdown',
				width: 220,
				editable : true,
				id: 'select_farm',
				name: 'select_farm',
				fieldLabel:'Report For',
				listConfig:{
					emptyText:noMatch
				},
				store: new Ext.data.Store({
					fields : ['displayField', 'valueField'],
					data : ['Activity','Activity']
				}),
				displayField: 'displayField',
				valueField: 'valueField',
				queryMode: 'local',
				hidden: false
			},
			{
				xtype:'scrollcombo',
				cls: 'dropdown',
				width: 170,
				editable : true,
				id: 'er_server',
				name: 'er_server',
				fieldLabel:'Report For',
				listConfig:{
					emptyText:noMatch
				},
				store: new Ext.data.Store({
					fields : ['displayField', 'valueField'],
					data : ['Activity','Activity']
				}),
				displayField: 'displayField',
				valueField: 'valueField',
				queryMode: 'local',
				hidden: true
			},					
			{
				xtype:'scrollcombo',
				cls: 'dropdown',
				width: 130,
				editable : false,
				id: 'report_category',
				name: 'report_category',
				fieldLabel:'Report For',
				store: new Ext.data.Store({
					fields : ['displayField', 'valueField'],
					data : ['Activity','Activity']
				}),
				displayField: 'displayField',
				valueField: 'valueField',
				queryMode: 'local',
				hidden: true
			},{
				xtype:'scrollcombo',
				width: 90,
				cls: 'dropdown',
				editable : false,
				fieldLabel:'Report Type',
				name: 'er_type',
				id: 'er_type',
				store: new Ext.data.Store({
					fields : ['displayField', 'valueField'],
					data : []
				}),
				displayField: 'displayField',
				valueField: 'valueField',
				queryMode: 'local'
			},
			
			{
				xtype:'scrollcombo',
				width: 200,
				cls: 'dropdown',
				editable : true,
				fieldLabel:'RUM Type',
				name: 'er_rum_type',
				id: 'er_rum_type',
				listConfig:{
					emptyText:noMatch
				},
				store: new Ext.data.Store({
					fields : ['displayField', 'valueField','groupField'],
					data : []
				}),
				displayField: 'displayField',
				valueField: 'valueField',
				groupField: 'groupField',
				queryMode: 'local',
				listConfig: {
					tpl: Ext.create('Ext.XTemplate',
					  '<ul><tpl for=".">',
					  '<tpl if="xindex == 1 || this.getGroupLabel(parent[xindex - 2]) != this.getGroupLabel(values)">',
					  '<li class="x-combo-list-group"><b>{[this.getGroupLabel(values)]}</b></li>',
					  '</tpl>',
					  '<li role="option" class="x-boundlist-item" style="<tpl if="xindex != 0">padding-left: 12px</tpl>">{displayField}</li>',
					  '</tpl>' +
					  '</ul>',
					  {
						getGroupLabel: function (values) {
						  return values.groupField
						}
					  }
					)
				}
			},			
					
			{
				xtype:'scrollcombo',
				width: 220,
				cls: 'dropdown',
				editable : false,
				fieldLabel:'Component Type',
				name: 'er_compType',
				id: 'er_compType',
				store: new Ext.data.Store({
					fields : ['displayField', 'valueField'],
					data : []
				}),
				displayField: 'displayField',
				valueField: 'valueField',
				queryMode: 'local',
				hidden:true
			},	
			{
				xtype:'scrollcombo',
				fieldLabel:'Graph Type',
				name: 'er_graphType',
				id: 'er_graphType',
				cls: 'dropdown',
				width:130,
				editable:false,
				hidden:true,
				store: Ext.data.Store
				(
					{
						fields: ['displayField','valueField'],
						data: []
					}
				),
				displayField: 'displayField',
				valueField: 'valueField',
				queryMode: 'local'
			},
			
			{
				xtype:'scrollcombo',
				width: 250,
				cls: 'dropdown',
				editable : false,
				fieldLabel:'Measure',
				name: 'select_testmes',
				id: 'select_testmes',
				store: new Ext.data.Store({
					fields : ['displayField', 'valueField'],
					data : []
				}),
				displayField: 'displayField',
				valueField: 'valueField',
				queryMode: 'local'
			},
			{
				xtype:'scrollcombo',
				width: 100,
				cls: 'dropdown',
				editable : false,
				fieldLabel:'Show Top',
				name: 'er_priority',
				id: 'er_priority',
				store: new Ext.data.Store({
					fields : ['displayField', 'valueField'],
					data : []
				}),
				displayField: 'displayField',
				valueField: 'valueField',
				queryMode: 'local',
				hidden:true
			},{
				xtype:'scrollcombo',
				width: 220,
				cls: 'dropdown',
				editable : true,
				fieldLabel:'Measures',
				name: 'er_sortby',
				id: 'er_sortby',
				listConfig:{
					emptyText:noMatch
				},
				store: new Ext.data.Store({
					fields : ['displayField', 'valueField'],
					data : []
				}),
				displayField: 'displayField',
				valueField: 'valueField',
				queryMode: 'local',
				hidden:true
			},
			{
				xtype:'scrollcombo',
				width: 220,
				cls: 'dropdown',
				editable : false,
				fieldLabel:'Application',
				name: 'er_application',
				id: 'er_application',
				store: new Ext.data.Store({
					fields : ['displayField', 'valueField'],
					data : []
				}),
				displayField: 'displayField',
				valueField: 'valueField',
				queryMode: 'local',
				hidden:true
			},				
			{xtype:'timeline',margin:0},
			{
				xtype:'checkboxfield',
				cls: 'checkbt',
				margin:'21 20 0 0',
				boxLabel: 'Show Legends',
				inputValue: 'true',
				hidden:true,
				id: 'showLegend'
			},
			{
				xtype:'button',
				text: submitValue,
				ui:'newButtonSmall',
				itemId: 'submit',
  				margin:'20 10 10 0'
			},
			{
				xtype:'button',
				text: "Save",
				ui:'newButtonSmall',
				itemId: 'save',
  				margin: "20 10 10 0",
				hidden:true
			},
			
		],
		listeners:{
		render:function(obj)
		{
			this.toggleSubmitSaveBtn(obj);
		},
		show:function(obj)
		{
			this.toggleSubmitSaveBtn(obj);
		},
		hide:function(obj)
		{
			this.toggleSubmitSaveBtn(obj);
		}
	},
	toggleSubmitSaveBtn:function(component){

			var mainform=Ext.getCmp('mainform');
			var LTDReportsForm=Ext.getCmp('LTDReportsForm');
			var hiddenFields =  appConstants.publicjsonDataActivity.hiddenfields;
			
			if (hiddenFields.fromScheduleModify == "Yes" || hiddenFields.fromFavoriteModify == "Yes") 
			{
				if (component.isHidden())
				{
					mainform.getComponent('save').hide();
					LTDReportsForm.getComponent('submit').hide();
					LTDReportsForm.getComponent('save').show();
				//	LTDReportsForm.getComponent('submit').hide();
				}
				else
				{
					mainform.getComponent('save').show();
					LTDReportsForm.getComponent('submit').hide();
					LTDReportsForm.getComponent('save').hide();
					//LTDReportsForm.getComponent('submit').hide();
				}
 			}
			else
			{
				if (component.isHidden())
				{
					mainform.getComponent('save').hide();
					LTDReportsForm.getComponent('submit').hide();
					LTDReportsForm.getComponent('save').hide();
					LTDReportsForm.getComponent('submit').show();
				}
				else
				{
					mainform.getComponent('save').hide();
					LTDReportsForm.getComponent('submit').show();
					LTDReportsForm.getComponent('save').hide();
					//LTDReportsForm.getComponent('submit').hide();
				}
			}
	}
});