// JavaScript Document
 Ext.Loader.setConfig({
	enable:true,
	garbageCollect:true,
	preserveScripts:false,
	disableCaching:false	
});
Ext.Ajax.timeout=ajaxTimeout;
Ext.Ajax.disableCaching=false;
registerAjaxExceptionEvent();
Ext.Loader.setPath('utilities', '../scripts/utilities');
Ext.Loader.setPath('Ext.ux', '../scripts/ux'); 
Ext.application({
	name:'JvmMemory',
 	requires:['JvmMemory.view.Main'],
	controllers:['JvmMemory.controller.JvmMemoryController'],
	appFolder:'../reporter/scripts/JvmMemoryApp',
	launch:function()
	{
		if (Ext.firefoxVersion >= 18) {
			var noArgs = [];
			Ext.override(Ext.Base, {
				callParent : function(args) 
				{ 
					var method, superMethod = (method = this.callParent.caller) && (method.$previous || ((method = method.$owner ? method : method.caller) && method.$owner.superclass[method.$name]));
					return superMethod.apply(this, args || noArgs);
				}
			});
		};
		appConstants.appObj = this;
		appConstants.appController='JvmMemoryController';
		var s_url='/final/reporter/JvmMemoryReportJson.jsp';
		var reportName=appConstants.reportName;
		if(reportName != undefined && reportName == 'jvm_cpu'){
			appConstants.foregroundControllerUrl = '../servlet/com.eg.ErJvmCpuC';
			if(appConstants.fromScheduleView=="Yes" || appConstants.executeFavorite == 'true'|| appConstants.isForceSubmit=="true" || appConstants.isSubmit=="true")
			{
				s_url = appConstants.foregroundControllerUrl+'?responseType=json';
			}
		}
		else if(reportName != undefined && reportName == 'jvm_garbage'){
			appConstants.foregroundControllerUrl = '../servlet/com.eg.ErJvmGarbageC';
			if(appConstants.fromScheduleView=="Yes" || appConstants.executeFavorite == 'true'|| appConstants.isForceSubmit=="true" || appConstants.isSubmit=="true")
			{
				s_url = appConstants.foregroundControllerUrl+'?responseType=json';
			}
		}
		else if(reportName != undefined && reportName == 'jvm_thrd'){
			appConstants.foregroundControllerUrl = '../servlet/com.eg.ErJvmThreadC';
			if(appConstants.fromScheduleView=="Yes" || appConstants.executeFavorite == 'true'|| appConstants.isForceSubmit=="true" || appConstants.isSubmit=="true")
			{
				s_url = appConstants.foregroundControllerUrl+'?responseType=json';
			}
		}
		else
		{
			appConstants.foregroundControllerUrl = '../servlet/com.eg.ErJvmMemoryC';
			if(appConstants.fromScheduleView=="Yes" || appConstants.executeFavorite == 'true'|| appConstants.isForceSubmit=="true" || appConstants.isSubmit=="true")
			{
				s_url = appConstants.foregroundControllerUrl+'?responseType=json';
			}
		}
		Ext.Ajax.request(
		{
			url : s_url,
			params : appConstants.QueryStringFromURL+"&er_reportname="+reportName,
			scope:this,
			success: function(response){
				appConstants.publicJsonData=Ext.decode(response.responseText);
				Ext.create('Ext.container.Viewport',{
					layout:'fit',
					items:[
						{ 
							xtype:'main'
						}
					]
				});
				Ext.get('loadmask').remove();
			}
		});
	}
});