Ext.define('JvmMemory.controller.JvmMemoryController',{
	extend:'Ext.app.Controller',
 	refs:[
 		{selector:'newUtilities',ref:'newUtilities'},
 		{selector:'main',ref:'main'},
 		{selector:'nomeasurepanel',ref:'nomeasurepanel'},
 		{selector:'ReporterSettings',ref:'ReporterSettings'}
 	],
	foregroundJspUrl:'/final/reporter/JvmMemoryReportJson.jsp',
	foregroundControllerUrl:'../servlet/com.eg.ErJvmMemoryC',
	backgroundControllerUrl:'../servlet/com.eg.ErStartBackGroundReportC',
	isNewFav:false,
	init:function(){
		this.control({
			'main':{
				'afterrender':this.boxready
			},
			'mainform':{
 				'afterrender':this.loadForm
			},
			'newUtilities':{
				'render':this.loadTools
			},
			'newUtilities > #printTool > button':
			{
				'click':this.printFile
			},
			'newUtilities > #saveTool > button':{
					'click': this.saveReportAsPDF
			},
			'newUtilities > #mailTool > button':{
					'click':this.sendMail
			},
			'newUtilities > #favoriteTool > button':{
					'click':this.saveFavorite
			},
			'newUtilities > #scheduleTool > button':{
					'click':this.saveSchedule
			},
			'egcomponent button[id="compExpand"]':{
				'click': this.expandMe
			},
			'egcomponent trigger[id="compSearch"]':
			{
				'change': this.filterMultiselect
			},
			'mainform combo[id="er_option"]':
			{
			'select': this.onSelectAnalysisBy
			},
			'mainform combo[id="er_site"]':
			{
			'select': this.onSelectSiteBy
			},
			'mainform combo[id="er_compType"]':
			{
			'select': this.onSelectCompTypeBy
			},
			'jvmmemorysettings':{
 				'afterrender':this.loadSettings
			},
			'jvmmemorysettings combo[name="reportGeneration"]':{
				'select': this.onChangeReportGeneration
			},
			'jvmmemorysettings button[id="moreOptionCloseId"]': {
				'click': this.validateAndCloseSettings
			},
			'jvmmemorysettings button[id="submitViaSetting"]': {
				'click': this.closeSettingAndSubmit
			},
			'jvmmemoryform button[name="submit"]':{
				'click': this.submitReoprt
			},
			'mainform button[id="panelinsidetoggle"]': {
				'click': this.toggleForm
			},
			'newUtilities > #csvTool > button':{
				'click':this.csvDownload
			}
		});
	},
	expandMe:function(btn)
	{
		if (Ext.isEmpty(appConstants.erUtils))
			appConstants.erUtils = Ext.widget("erutils");

		if (btn.getId()=='compExpand')
		{
			appConstants.erUtils.expandMultiComboButton(Ext.getCmp('er_component'),componentsTxt,btn);
		}
 	},
	typewatch:function(field, event)
	{
		 this.searchTask.delay(500);
	},
	addToolBarItems:function(items)
	{
		if(Ext.isArray(items)){
			var toolbar = {
				xtype:'toolbar',
				padding:'4 5 4 0',
				bodypadding:0,
				margin:'0 0 0 0',
				border:false,
				items:items
			}
			return toolbar;
		}
		else
		{
			alert('error in  @param, use as array [{..},{..}]');
		}
	},
	goTo: function (obj)
	{
 		if (appConstants.frmSchModify == "Yes")
			 this.saveSchedule(obj);
		else
 			this.saveFavorite(obj);
	},
	csvDownload: function(){
		var infoName=appConstants.infoName;
		var reportName=appConstants.reportName;
		var controllerUrl='../servlet/com.eg.ErJvmMemoryC?';
		if(reportName != undefined && reportName == 'jvm_cpu'){
			controllerUrl='../servlet/com.eg.ErJvmCpuC?';
		}
		if(reportName != undefined && reportName == 'jvm_garbage'){
			controllerUrl='../servlet/com.eg.ErJvmGarbageC?graphParam='+infoName+'&';
		}
		if(reportName != undefined && reportName == 'jvm_thrd'){
			controllerUrl='../servlet/com.eg.ErJvmThreadC?';
		}
		var csvUrl=controllerUrl+"option=csv&er_info_list="+infoName+"&"+this.getQueryString(true,true,true)+'&isFromDrillDown=yes';;
		window.location=csvUrl;
	},
	saveSchedule:function(obj)
	{
 		if(this.validateMainForm(false) && Ext.getCmp('er_timeline').getValue() == 'Any')
		{
			Ext.MessageBox.show({
				title: alert_text,
				msg: 'Chosen timeline not allowed',
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
			});
			return false;
		}
		var reportName=appConstants.reportName;
		var target="/final/reporter/ErSaveSchedule.jsp?isSubmit=true&"+this.getQueryString(true,true,true)+"&option=data"+"&er_reportname="+reportName+"&com.eg.CSRF_NONCE="+csrfToken;
 		if (obj.getId()=='save')
		{
			if(target!=undefined && target.indexOf("schedule_id")==-1)
				target+='&schedule_id='+appConstants.schedule_id;
			target+='&showSchWindow=no';
			var urlNw=target.substr(0,target.indexOf("?"));
			var queryString=target.substr(target.indexOf("?")+1,target.length-1);
			var formSave = Ext.create('Ext.form.Panel');
			formSave.submit({
				url:urlNw,
				params:queryString,
				standardSubmit: true,
				method: 'POST'
			});
		}
		else
 			parent.scheduleWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
 	},
	saveFavorite:function(obj)
	{
		var target="";
		var reportName=appConstants.reportName;
		if (obj.getId()=='save')
		{
			this.isNewFav=false;
			target="/final/reporter/ErSaveFavorite.jsp?isSubmit=true&"+this.getQueryString(true,true,true)+"&er_view=GRAPH&cmd=client&fromFavoriteModify=Yes"+"&er_RmDispName="+appConstants.er_RmDispName+"&er_reportname="+reportName+"&com.eg.CSRF_NONCE="+csrfToken;
			
			if(target!=undefined && target.indexOf("FavoriteId")==-1)
				target+='&FavoriteId='+appConstants.favorite_id;
			target+='&showSchWindow=no';
			var urlNw=target.substr(0,target.indexOf("?"));
			var queryString=target.substr(target.indexOf("?")+1,target.length-1);
			var formSave = Ext.create('Ext.form.Panel');
			formSave.submit({
				url:urlNw,
				params:queryString,
				standardSubmit: true,
				method: 'POST'
			});
		}
		else
		{
			this.isNewFav=true;
			target="../servlet/com.eg.ErFavoriteC?isSubmit=true&"+this.getQueryString(true,true,true)+"&er_view=GRAPH&cmd=client"+"&er_RmDispName="+appConstants.er_RmDispName+"&er_reportname="+reportName+"&com.eg.CSRF_NONCE="+csrfToken;
			parent.favouriteWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
		}
 	},
	saveReportAsPDF:function()
	{
 		var s_qryString = "../reporter/ErHtmlToSavePdf.jsp?"+this.getQueryString(true,true,true);
		s_qryString += "&printGraph=yes&savePrint=yes&er_view=PRINT&option=print&pageWidthProces=1024";
		var infoName=appConstants.infoName;
		if(infoName != undefined && infoName != 'null')
		{
			s_qryString+='&er_info_list='+infoName+'&isFromDrillDown=yes';
		}
		if (Ext.isEmpty(appConstants.erUtils))
 			appConstants.erUtils = Ext.widget("erutils");

		 appConstants.erUtils.savePDF(s_qryString);
	},
	bookletQuery: function(obj)
	{
		var s_qryString = this.getQueryString(true,true,true);
		return s_qryString;
	},
	bookletScheduleQuery: function(obj)
	{
		var bookletquery="isSubmit=true&"+this.getQueryString(true,true,true)+"&option=data";
		return bookletquery;
	},
	bookletPreview:function()
	{
		this.printFile();
	},
	printFile:function()
	{
 		var s_qryString = this.getQueryString(true,true,true)+"&er_view=PRINT&pdfPrint=yes";
		var url="/final/reporter/JvmMemoryReportPrint.jsp?option=print&";
		var infoName=appConstants.infoName;
		if(infoName != undefined && infoName != 'null')
		{
			s_qryString+='&er_info_list='+infoName+'&isFromDrillDown=yes';
		}
		var reportName=appConstants.reportName;
		if(reportName != undefined && reportName == 'jvm_cpu')
		{
			url="/final/reporter/JvmCpuReportPrint.jsp?option=print&";
		}
		else if(reportName != undefined && reportName == 'jvm_garbage')
		{
			url="/final/reporter/JvmGarbageReportPrint.jsp?option=print&";
		}
		else if(reportName != undefined && reportName == 'jvm_thrd')
		{
			url="/final/reporter/JvmThreadReportPrint.jsp?option=print&";
		}
		parent.printWindowFn(url+s_qryString); //this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
	},
	sendMail:function(){
		Ext.widget('sendmail').show();
 	},
	loadReportData:function()
	{
		var backGroundPanel=Ext.getCmp('backGroundPanel');
 		var reportGeneration=appConstants.publicJsonData.selectedFields.reportGenerationSelected;
		this.hideResults();

		var tmpStartDate = Ext.getCmp('er_stdate').getValue();
		tmpStartDate.setHours(Ext.getCmp('er_sthr').getValue());
		var tmpEndDate = Ext.getCmp('er_enddate').getValue();
		tmpEndDate.setHours(Ext.getCmp('er_endhr').getValue());
		var result = checkDateTime(tmpStartDate, tmpEndDate);
		if (!result) {
			return;
		}
 		if(reportGeneration == 'foreground')
		{
			if (appConstants.publicJsonData.hasOwnProperty('NO_DATA'))
			{
				this.disableTools();
				this.getNomeasurepanel().show();
			}
			else 
			{
				Ext.getCmp('selectionDetails').setSelectionDetailsData(appConstants.publicJsonData.selectionDetails);
				this.enableTools();
				var reportName=appConstants.reportName;
				if(reportName != undefined && reportName == 'jvm_garbage')
				{
					this.loadGarbageResultData();
				}
				else if(reportName != undefined && reportName == 'jvm_cpu')
				{
					this.loadCPUResultData();
				}
				else if(reportName != undefined &&  reportName == 'jvm_thrd')
				{
					this.loadThrdResultData();
				}
				else
				{
					this.loadResultData();
					this.getTROddEvenBG('tableId');
				}

			}	//end of else
		}
		else if(reportGeneration == 'background')
		{
			var backgroundReportStatus=appConstants.publicJsonData.labelFields.bgStatus;
			if(backgroundReportStatus== 'success')
			{
				var bgroundResponseTxt=appConstants.publicJsonData.labelFields.bgResponseText;
				var backgroundAnchor=appConstants.publicJsonData.labelFields.bgAnchor;
				var bgroundReportsURL=appConstants.publicJsonData.urlFields.bgUrl;
				backGroundPanel.update('<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconInformation"></div></td><td><div style="line-height:1.25em" class="font_bold11">'+bgroundResponseTxt+'.</br>'+'<a class="backgroundMsgLink" href='+ bgroundReportsURL +'>'+ backgroundAnchor + '</a></div></td></tr></table></td></tr></table>');
			}
			else if(backgroundReportStatus== 'duplicate')
			{
				var bgroundResponseTxt=appConstants.publicJsonData.labelFields.bgResponseText;
				var backgroundAnchor=appConstants.publicJsonData.labelFields.bgAnchor;
				var bgroundReportsURL=appConstants.publicJsonData.urlFields.bgUrl;
			
				backGroundPanel.update('<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconExclamation"></div></td><td><div style="line-height:1.25em" class="font_bold11">'+bgroundResponseTxt+'.</br>'+'<a class="backgroundMsgLink" href='+ bgroundReportsURL +'>'+ backgroundAnchor + '</a></div></td></tr></table></td></tr></table>');
			}
			else
			{
			
				backGroundPanel.update('<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconInformation"></div></td><td><div style="line-height:1.25em" class="font_bold11">Error In BackGround Generation</a></div></td></tr></table></td></tr></table>');
			}
			backGroundPanel.show();
		}
		else
		{
			console.log('No data found for report generation in json');
		}
		keepResult = false;
	},
	getNoMeasure:function(title,id)
	{
		return {
			xtype:'panel',
			ui:'newGraphPanel graphHeaderBottomBorder ',
			columnWidth:0.5,
			height:370,
			id:id,
			header : {
			style: (strSkin == "Light")? 'border-bottom: 1px solid #EBEBEB !important;padding: 2px 0 5px 0;margin:0px 20px 0px 20px':'margin:0px 20px 0px 20px; padding:  2px 0 5px 0;border-bottom: 1px solid #5e5e5e !important;'
			},
			margin: '0 10 10 0',
			title:title,
			items:[{
				xtype:'container',
				id:''+id+'_GraphPanel',
				html:'<div id='+id+' style="height:330px"><table width="100%" height="100%"><tr><td align="center" valign="middle"><img src="/final/images/Light/nomeasures_custom.png" /></td></tr></table></div>',
				
			}]
		}
	},
	getTROddEvenBG:function(tableId)
	{
		$(document).ready(function(){
			$("#"+tableId+" tr:even").addClass('tableTrBgEven');
			$("#"+tableId+" tr:odd").addClass('tableTrBgOdd');
		});
	},
	getDeductionsPanel:function(title,deductionsAry)
	{
		var deductionsHTML='';
		var seperatorCls='jvmGraphSeperatorLineRight';
		if(deductionsAry!=undefined && deductionsAry.length>0)
		{
			if(deductionsAry.length==1)
			{
				seperatorCls='';
			}
			deductionsHTML = '<div style="padding:0px 0px 10px 0px" class="font_bold15 jvmNotes">' + title + '</div><div class="" style="margin:0px 0px 0px 0px; padding: 0 20px 0 0;" ><table style="width: 100%;margin-bottom:10px; "><tbody>';
			for(var index=0;index<=deductionsAry.length-1;index+=2)
			{
				var deductionsAryObj = deductionsAry[index];
				var deductionsAryObj1 = deductionsAry[index+1];
				deductionsHTML+='<tr style="padding-bottom:10px;">'
				if(deductionsAryObj != undefined)
				{
					deductionsHTML+='<td width="50%" class="jvmHeaptable"><table><tr><td width="10px;" style="vertical-align:top;padding-top:7px;" ><div style="background-color:transparent;height:8px;width:8px;border-radius: 50%; border:2px solid  #707070;vertical-align: text-top;"></div></td><td style="line-height:1.5;">'+deductionsAryObj+'</td></tr></table></td>';
				}
				if(deductionsAryObj1 != undefined)
				{
					deductionsHTML+='<td width="50%" class="jvmHeaptable"><table><tr><td width="10px"  style="vertical-align:top;padding-top:7px;" ><div style="background-color:transparent;height:8px;width:8px;border-radius: 50%; border:2px solid  #707070;vertical-align: text-top;"></div></td><td style="line-height:1.5;">'+deductionsAryObj1+'</td></tr></table></td>';
				}
			}
			deductionsHTML+='</tbody></table></div>';
			return {
				xtype:'panel',
				ui: 'newGraphPanel noShadow ',
				margin: '0 0 0 0',
				bodyPadding: '10px 0px 0px 10px',
				columnWidth:1.0,
				margin:'0 10 10 0',
				items:[
					{
						xtype:'container',
						cls: seperatorCls,
						columnWidth:1.0,
						margin: '0 0 0 0',
						padding: 0,
						html:deductionsHTML
					}
				]
			}
		}
	},
	getGraphPanel:function(title,hiddenFlag,graphId,graphdata,dataUrl,csvUrl,imageDrillDownUrl)
	{
		var dataUrlTempHeap=dataUrl+'&er_info_list='+graphId;
		var csvUrlTempHeap=csvUrl+'&er_info_list='+graphId;
		var imageDrillDownUrlTempHeap=imageDrillDownUrl+'&er_info_list='+graphId;
		return {
			xtype:'panel',
			ui:'newGraphPanel',
			columnWidth:1.0,
			title:title,
			margin:'0 10 10 0',
			header : {
				style: (strSkin == "Light")? 'border-bottom: 1px solid #EBEBEB !important;padding: 2px 0 2px 0;margin:0px 10px 0px 10px':'margin:0px 10px 0px 10px; padding:  2px 0 2px 0;border-bottom: 1px solid #5e5e5e !important;'
			},
			layout: {
				type: 'vbox',
				align:'stretch'
			},
			flex:1,
			tools:[
				this.addToolBarItems([
					{
						xtype: 'button',
						cls:'iconData',
						style:{'border':'0px'},
						width:16,
						height:16,
						margin:'0 3 0 3',
						hidden:hiddenFlag,
						handler:function(){
							loadDataWindow(dataUrlTempHeap);
						}
					},
					{
						xtype: 'button',
						width:16,
						height:16,
						margin:'0 3 0 3',
						style:{'border':'0px'},
						cls: 'iconCsv',
						hidden:hiddenFlag,
						handler:function(){
							window.location=csvUrlTempHeap;
						}
					},
					{
						xtype: 'button',
						width:16,
						height:16,
						margin:'0 0 0 3',
						style:{'border':'0px'},
						cls:'iconMaximize',
						hidden:hiddenFlag,
						handler:function(){
							loadUrlInDrillDown(imageDrillDownUrlTempHeap);
						}
					}
				])
			],
			items:[
			{
				xtype:'container',
				id:graphId+'_GraphPanel',
				html:'<div id='+graphId+' style="height:270px"> </div>',
				listeners:
				{
					'boxready':function()
					{
						
						{
							var lineChart = {};
							lineChart = jQuery.extend(true, {}, getHighChartsInstance(graphId,"230","200"), lineChart);
							lineChart.setData(graphdata,appConstants.currentDateFormat,'');
							lineChart.drawChart();
							if(document.getElementById(graphId+'_legendClose')){document.getElementById(graphId+'_legendClose').className="iconCloseCircle hideDiv";}
							if(document.getElementById(graphId+'_legendExpand')){document.getElementById(graphId+'_legendExpand').className="iconCloseCircle hideDiv";}
						}
						
					}
				}
			},
			{
				xtype:'container',
				margin:'0 10 10 0',
				id:graphId+'_legendPanel',
				style:
				{
					'overflow':'hidden'
				}
			}]
		}
	},
	loadThrdResultData:function()
	{
		var resultContainerObj=Ext.getCmp('resultContainer');
		resultContainerObj.removeAll();
		resultContainerObj.show();
		var totalAndRunnableThrdGraph  = appConstants.publicJsonData.totalAndRunnableThrdGraph;
		var totalAndRunnableThrdGraphTitle  = appConstants.publicJsonData.totalAndRunnableThrdGraphTitle;
		var blockWaitingDeadlockThrdGraph  = appConstants.publicJsonData.blockWaitingDeadlockThrdGraph;
		var blockWaitingDeadlockThrdGraphTitle  = appConstants.publicJsonData.blockWaitingDeadlockThrdGraphTitle;
		var highAndMediumThrdGraph  = appConstants.publicJsonData.highAndMediumThrdGraph;
		var highAndMediumThrdGraphTitle  = appConstants.publicJsonData.highAndMediumThrdGraphTitle;
		var csvUrl =  appConstants.publicJsonData.CSV_URL;
		var dataUrl =  appConstants.publicJsonData.DATA_URL;
		var imageDrillDownUrl = appConstants.publicJsonData.IMAGE_DRILL_DOWN_URL;
		var slaViolationsObj = appConstants.publicJsonData.slaViolationsObj;
		var totalCurrentThrdIncident=slaViolationsObj.totalCurrentThrd!= undefined?slaViolationsObj.totalCurrentThrd:0;
		var runningThrdIncident=slaViolationsObj.runningThrd!= undefined?slaViolationsObj.runningThrd:0;
		var blockedThrdIncident=slaViolationsObj.blockedThrd!= undefined?slaViolationsObj.blockedThrd:0;
		var deadlockThrdIncident=slaViolationsObj.deadlockThrd!= undefined?slaViolationsObj.deadlockThrd:0;
		var waitingThrdIncident=slaViolationsObj.waitingThrd!= undefined?slaViolationsObj.waitingThrd:0;
		var timedWaitingThrdIncident=slaViolationsObj.timedWaiting!= undefined?slaViolationsObj.timedWaiting:0;
		var highCPUThrdIncident=slaViolationsObj.highCPU!= undefined?slaViolationsObj.highCPU:0;
		var mediumCPUThrdIncident=slaViolationsObj.mediumCPU!= undefined?slaViolationsObj.mediumCPU:0;
		var infoName=appConstants.infoName;
		var donutChartObj = appConstants.publicJsonData.donutChartObj;
		var coefficientValue = appConstants.publicJsonData.coefficientValue;
		var correlationCoeffRange = appConstants.publicJsonData.correlationCoeffRange;
		var deductionsTitle = appConstants.publicJsonData.deductionsTitleThrd;
		var recommendationsTitle = appConstants.publicJsonData.recommendationsTitleThrd;
		var blockedAlarmDuration = appConstants.publicJsonData.blockedAlarmDuration;
		var blockedAlarmDate = appConstants.publicJsonData.blockedAlarmDate;
		var deadlockAlarmDuration = appConstants.publicJsonData.deadlockAlarmDuration;
		var deadlockAlarmDate = appConstants.publicJsonData.deadlockAlarmDate;
		var historyOfAlaramUrl = appConstants.publicJsonData.historyOfAlaramUrl;
		var summaryAry = appConstants.publicJsonData.summaryAry;
		var totalAndRunnableThrdGraphTable="";
		var blockWaitingDeadlockThrdGraphTable="";
		var highAndMediumThrdGraphTable="";
		//
		var summaryHtml = '';
		//overview table
		summaryHtml='<table align="center" style="margin:0px;width:100%;"><tbody><tr>';
		if(donutChartObj!=undefined)
		{
			summaryHtml+='<td width="30%" class="jvmRightBorder"><table width="100%"><tbody><tr>';
			var dataSet = donutChartObj.DataSet;
			var data = dataSet[0].data;
			summaryHtml+='<td class="jvmRightBorder"><table width="100%"><tbody><tr>';
			summaryHtml+='<td width="50%"><div style="height: 90px;"><div id="donutChartThrd" style="height:120px; position:relative; top:-15px; " ></div></div></td>';
			summaryHtml+='<td width="50%"><table style="line-height:1.5;padding: 0 10 0 0px;width:100%;"><tbody>';
			for(var index in data)
			{
				var value = data[index].val;
				var color = data[index].color;
				var name = data[index].name;
				var state = data[index].state;
				summaryHtml+='<tr><td width="5%"><div style="height:7px;width:7px;-webkit-border-radius:4px;background-color:'+color+'"></div>';
				summaryHtml+='</td><td width="75%" class="newFont_bold13">&nbsp;'+name+'</td><td width="20%" class="newFont_bold13"><a href="javascript:void(0);" class="jvmAnchorLink" onclick=window.location.href="'+historyOfAlaramUrl+"&measureName=&state="+state+'">'+value+'</a></td></tr>';
			}
			summaryHtml +='</tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table></td>';
		}
		else
		{
			summaryHtml+='<td width="25%" class="jvmRightBorder"><table width="100%"><tbody><tr>';
			summaryHtml+='<td align="center" valign="middle"><div class="iconNoalarms" ></div><div class="commonErrorMsgText">'+noIncidentMsg+'</div></td>';
			summaryHtml+='</td></tr><tbody></table></td>';
		}
		for(var index in summaryAry)
		{
			var summaryAryData = summaryAry[index];
			summaryHtml+='<td width="25%" class="jvmRightBorder">';
			summaryHtml+='<table  width="100%" align="center" cellspacing="0" cellpadding="0" border="0" Style="align:center;margin:auto auto;"><tbody><tr><td colspan="1" rowspan="1"><table align="center"><tbody><tr><td align="right" style="padding-right:5px"><div class="'+summaryAryData.iconCls+'"></div></td><td class="newFont_bold28">'+summaryAryData.data+'</td>';
			summaryHtml+='</tr></tbody></table></td></tr><tr style="text-align: center;"><td colspan="1" rowspan="1" class="newFont_bold13">'+summaryAryData.name+'</td></tr></tbody></table>';
			summaryHtml+='</td>';
		}
		summaryHtml+='</tr></tbody></table>';
		if(infoName=='null')
		{
			resultContainerObj.add({
				xtype: 'panel',
				ui:'newGraphPanel',
				title:overViewTxt,
				margin: '0 10 10 0',
				html:summaryHtml,
				bodyPadding: '0 0 20 0',
				columnWidth:1.0,
				listeners:
				{
					'boxready':function()
					{
						{
							if(donutChartObj != undefined)
							{
								var lineChart = {};
								lineChart = jQuery.extend(true, {}, getHighChartsBarInstance('donutChartThrd',100,100), lineChart);
								lineChart.setData(donutChartObj,appConstants.currentDateFormat,'');
								lineChart.drawChart();
							}
						}
					}
				}
			});
		}
		var hiddenFlag=false;
		if(infoName!=undefined&&infoName!='null')
		{
			hiddenFlag=true;
		}
		var totalThrdDedAry=[];
		var blockedDeadlockDedAry=[];
		var highAndMediumDedAry=[];
		var blockedThreadPer = appConstants.publicJsonData.blockedThreadPer;
		var deadlockThreadPer = appConstants.publicJsonData.deadlockThreadPer;
		var highCPUThreadPer = appConstants.publicJsonData.highCPUThreadPer;
		var medCPUThreadPer = appConstants.publicJsonData.medCPUThreadPer;
		var highCpuAlarmDuration = appConstants.publicJsonData.highCpuAlarmDuration;
		var highCpuAlarmDate = appConstants.publicJsonData.highCpuAlarmDate;
		var mediumCpuAlarmDuration = appConstants.publicJsonData.mediumCpuAlarmDuration;
		var mediumCpuAlarmDate = appConstants.publicJsonData.mediumCpuAlarmDate;
		var blockedMeasure = appConstants.publicJsonData.blockedMeasure;
		var deadlockMeasure = appConstants.publicJsonData.deadlockMeasure;
		var mediumCpuMeasure = appConstants.publicJsonData.mediumCpuMeasure;
		var highCpuMeasure = appConstants.publicJsonData.highCpuMeasure;
		var blockedDDUrl = appConstants.publicJsonData.blockedDDUrl;
		var deadlockDDUrl = appConstants.publicJsonData.deadlockDDUrl;
		var highCPUDDUrl = appConstants.publicJsonData.highCPUDDUrl;
		var totalDDUrl = appConstants.publicJsonData.totalDDUrl;
		var longestDurationParamBlocked = appConstants.publicJsonData.longestDurationParamBlocked;
		var longestDurationParamDeadlock = appConstants.publicJsonData.longestDurationParamDeadlock;
		var longestDurationParamHighCPU = appConstants.publicJsonData.longestDurationParamHighCPU;
		var longestDurationParamMediumCPU = appConstants.publicJsonData.longestDurationParamMediumCPU;
		if(coefficientValue >= correlationCoeffRange)
		{
			totalThrdDedAry.push("<div style='margin:0px 0px 3px 5px'><span class='newFont_normal13'>There is a upward trend in total threads<span class='newFont_bold14'>&nbsp;&nbsp;[correlation coefficient "+coefficientValue+"]</span></span></div>");
		}
		if(blockedThrdIncident!=0)
		{
			blockedDeadlockDedAry.push("<div style='margin:0px 0px 3px 5px'><span class='newFont_bold14'>"+blockedThrdIncident+"</span><span class='newFont_normal13'> Number of blocked thread incidents detected. <a href='javascript:void(0)' class='jvmAnchorLink' onclick=window.location.href='"+historyOfAlaramUrl+"&state=&measureName="+blockedMeasure+"'><span class='newFont_bold14'>Click here</span></a> to look at the stack trace</span></div>");
		}
		else
		{
			blockedDeadlockDedAry.push("<div style='margin:0px 0px 3px 5px'><span class='newFont_normal13'>No blocked threads detected</span></div>");
		}
		if(blockedThreadPer!=0)
		{
			blockedDeadlockDedAry.push("<div style='margin:0px 0px 3px 5px'><span class='newFont_bold13'>"+blockedThreadPer+" % </span><span class='newFont_normal13'> of time blocked threads existed </span></div>");
		}
		if(blockedAlarmDuration != "" && blockedAlarmDuration != undefined)
		{
			blockedDeadlockDedAry.push("<div style='margin:0px 0px 3px 5px'><span class='newFont_normal13'>The longest alarm for blocked threads  violation was for </span><span class='newFont_bold14'><a href='javascript:void(0);' class='jvmAnchorLink'  onclick=window.location.href='"+historyOfAlaramUrl+"&state="+"&measureName="+blockedMeasure+longestDurationParamBlocked+"'>"+blockedAlarmDuration+"</a></span><span class='newFont_normal13'> on  </span><span class='newFont_bold13'>"+blockedAlarmDate+"</span></div>");
		}
		if(deadlockThrdIncident!=0)
		{
			blockedDeadlockDedAry.push("<div style='margin:0px 0px 3px 5px'><span class='newFont_bold14'>"+deadlockThrdIncident+" </span><span class='newFont_normal13'> Number of deadlock thread incidents detected. <a href='javascript:void(0)' class='jvmAnchorLink' onclick=window.location.href='"+historyOfAlaramUrl+"&state=&measureName="+deadlockMeasure+"'><span class='newFont_bold14'>Click here</span></a> to look at the stack trace</span></div>");
		}
		else
		{
			blockedDeadlockDedAry.push("<div style='margin:0px 0px 3px 5px'><span class='newFont_normal13'>No deadlock threads detected</span></div>");
		}
		if(deadlockAlarmDuration != "" && deadlockAlarmDuration != undefined)
		{
			blockedDeadlockDedAry.push("<div style='margin:0px 0px 3px 5px'><span class='newFont_normal13'>The longest alarm for deadlock threads was for </span><span class='newFont_bold14'><a href='javascript:void(0);' class='jvmAnchorLink'  onclick=window.location.href='"+historyOfAlaramUrl+"&state="+"&measureName="+deadlockMeasure+longestDurationParamDeadlock+"'>"+deadlockAlarmDuration+"</a></span><span class='newFont_normal13'> on  </span><span class='newFont_bold13'>"+deadlockAlarmDate+"</span></div>");
		}
		if(deadlockThreadPer!=0)
		{
			blockedDeadlockDedAry.push("<div style='margin:0px 0px 3px 5px'><span class='newFont_bold13'>"+deadlockThreadPer+" %</span><span class='newFont_normal13'> of time deadlock threads existed </span></div>");
		}
		if(highCPUThrdIncident!=0)
		{
			highAndMediumDedAry.push("<div style='margin:0px 0px 3px 5px'><span class='newFont_bold14'>"+highCPUThrdIncident+"   </span><span class='newFont_normal13'> Number of High CPU thread incidents detected</span></div>");
		}
		else
		{
			highAndMediumDedAry.push("<div style='margin:0px 0px 3px 5px'><span class='newFont_normal13'>No High CPU threads detected</span></div>");
		}
		if(highCpuAlarmDuration != "" && highCpuAlarmDuration != undefined)
		{
			highAndMediumDedAry.push("<div style='margin:0px 0px 3px 5px'><span class='newFont_normal13'>The longest alarm for High CPU thread  violation was for </span><span class='newFont_bold14'><a href='javascript:void(0);' class='jvmAnchorLink'  onclick=window.location.href='"+historyOfAlaramUrl+"&state="+"&measureName="+highCpuMeasure+longestDurationParamHighCPU+"'>"+highCpuAlarmDuration+"</a></span><span class='newFont_normal13'> on  </span><span class='newFont_bold13'>"+highCpuAlarmDate+"</span></div>");
		}
		if(highCPUThreadPer!=0)
		{
			highAndMediumDedAry.push("<div style='margin:0px 0px 3px 5px'><span class='newFont_bold13'>"+highCPUThreadPer+" % </span><span class='newFont_normal13'> of time High CPU threads existed </span></div>");
		}
		if(mediumCPUThrdIncident!=0)
		{
			highAndMediumDedAry.push("<div style='margin:0px 0px 3px 5px'><span class='newFont_bold14'>"+mediumCPUThrdIncident+"</span><span class='newFont_normal13'> Number of Medium CPU thread incidents detected</span></div>");
		}
		else
		{
			highAndMediumDedAry.push("<div style='margin:0px 0px 3px 5px'><span class='newFont_normal13'>No Medium CPU threads detected</span></div>");
		}
		if(mediumCpuAlarmDuration != "" && mediumCpuAlarmDuration != undefined)
		{
			highAndMediumDedAry.push("<div style='margin:0px 0px 3px 5px'><span class='newFont_normal13'>The longest alarm for Medium CPU thread was for </span><span class='newFont_bold14'><a href='javascript:void(0);' class='jvmAnchorLink'  onclick=window.location.href='"+historyOfAlaramUrl+"&state="+"&measureName="+mediumCpuMeasure+longestDurationParamMediumCPU+"'>"+mediumCpuAlarmDuration+"</a></span><span class='newFont_normal13'> on  </span><span class='newFont_bold13'>"+mediumCpuAlarmDate+"</span></div>");
		}
		if(medCPUThreadPer!=0)
		{
			highAndMediumDedAry.push("<div style='margin:0px 0px 3px 5px'><span class='newFont_bold13'>"+medCPUThreadPer+" % </span><span class='newFont_normal13'> of time medium CPU threads existed </span></div>");
		}
		//
		if(totalAndRunnableThrdGraph!=undefined)
		{
			resultContainerObj.add(this.getGraphPanel(totalAndRunnableThrdGraphTitle,hiddenFlag,'total_runnable',totalAndRunnableThrdGraph,dataUrl,csvUrl,imageDrillDownUrl));
			if(totalThrdDedAry != undefined && infoName=='null')
			{
				resultContainerObj.add(this.getDeductionsPanel(deductionsTitle,totalThrdDedAry));
			}
		}
		if(blockWaitingDeadlockThrdGraph!=undefined)
		{
			resultContainerObj.add(this.getGraphPanel(blockWaitingDeadlockThrdGraphTitle,hiddenFlag,'block_waiting',blockWaitingDeadlockThrdGraph,dataUrl,csvUrl,imageDrillDownUrl));
			if(blockedDeadlockDedAry != undefined && infoName=='null')
			{
				resultContainerObj.add(this.getDeductionsPanel(deductionsTitle,blockedDeadlockDedAry));
			}
		}
		if(highAndMediumThrdGraph!=undefined)
		{
			resultContainerObj.add(this.getGraphPanel(highAndMediumThrdGraphTitle,hiddenFlag,'high_medium',highAndMediumThrdGraph,dataUrl,csvUrl,imageDrillDownUrl));
			if(highAndMediumDedAry != undefined && infoName=='null')
			{
				resultContainerObj.add(this.getDeductionsPanel(deductionsTitle,highAndMediumDedAry));
			}
		}
		//recommadation
		var blockThrdMaxValue = appConstants.publicJsonData.blockThrdMaxValue;
		var deadlockThrdMaxValue = appConstants.publicJsonData.deadlockThrdMaxValue;
		var highCPUThrdMaxValue = appConstants.publicJsonData.highCPUThrdMaxValue;
		var blockThrdMaxRange = appConstants.publicJsonData.blockThrdMaxRange;
		var deadlockThrdMaxRange = appConstants.publicJsonData.deadlockThrdMaxRange;
		var highCPUThrdMaxRange = appConstants.publicJsonData.highCPUThrdMaxRange;
		var recommendationsAry=[];
		if(blockThrdMaxValue!=undefined && blockThrdMaxValue >= blockThrdMaxRange)
		{
			recommendationsAry.push("<div style='margin:0px 0px 3px 5px'><table><tbody><tr><td class='newFont_normal13' style='padding-right:10px;line-height:1.5;color:#1a1a1a;'>Block threads detected, investigate the cause of blocked threads using stack trace </td><td title='DD' class='iconDiagnosis' onclick='javascript:loadPopup(\""+blockedDDUrl+"\")' style='margin:0px;padding:0px;width:16px;height:16px;position:absolute;display:block;cursor:pointer'></td></tr></tbody></table></div>");
		}
		if(deadlockThrdMaxValue!=undefined && deadlockThrdMaxValue >= deadlockThrdMaxRange)
		{
			recommendationsAry.push("<div style='margin:0px 0px 3px 5px'><table><tbody><tr><td class='newFont_normal13' style='padding-right:10px;line-height:1.5;color:#1a1a1a;'>Deadlock threads detected, investigate the cause of deadlock threads using stack trace </td><td title='DD' class='iconDiagnosis' onclick='javascript:loadPopup(\""+deadlockDDUrl+"\")' style='margin:0px;padding:0px;width:16px;height:16px;position:absolute;display:block;cursor:pointer'></td></tr></tbody></table></div>");
		}
		if(highCPUThrdMaxValue!=undefined && highCPUThrdMaxValue >= highCPUThrdMaxRange)
		{
			recommendationsAry.push("<div style='margin:0px 0px 3px 5px'><table><tbody><tr><td class='newFont_normal13' style='padding-right:10px;line-height:1.5;color:#1a1a1a;'>CPU threads detected, investigate the cause of high CPU threads using stack trace </td><td title='DD' class='iconDiagnosis' onclick='javascript:loadPopup(\""+highCPUDDUrl+"\")' style='margin:0px;padding:0px;width:16px;height:16px;position:absolute;display:block;cursor:pointer'></td></tr></tbody></table></div>");
		}
		if(coefficientValue!=undefined && coefficientValue >= correlationCoeffRange)
		{
			recommendationsAry.push("<div style='margin:0px 0px 3px 5px'><table><tbody><tr><td class='newFont_normal13' style='padding-right:10px;line-height:1.5;color:#1a1a1a;'>Upward trend detected, could be due to thread leaks. Investigate further  </td><td title='DD' class='iconDiagnosis' onclick='javascript:loadPopup(\""+totalDDUrl+"\")' style='margin:0px;padding:0px;width:16px;height:16px;position:absolute;display:block;cursor:pointer'></td></tr></tbody></table></div>");
		}
		//
		var recommendationsHtml = '';
		if(recommendationsAry!=undefined && recommendationsAry.length == 0)
		{
			recommendationsAry.push("<div style='margin:0px 0px 6px 5px'><span class='newFont_normal13'>"+conclusionTxtThrd+"</span></div>");
			recommendationsTitle=conclusionTitle;
		}
		if(recommendationsAry!=undefined && recommendationsAry.length > 0)
		{
			recommendationsHtml+='<div class="notes" style="width:100%;padding: 10px 25px 0px 10px;">';
			recommendationsHtml+= '<div class="paperPin 44"></div>';
			recommendationsHtml+='<div style="padding:0px 0px 10px 0px;color:#000;" class="font_bold15">'+recommendationsTitle+'</div><div style="margin:0px 0px 0px 0px"><table width="100%" align="center"><tbody>';
			for(var index in recommendationsAry)
			{
				var recommendationsAryObj = recommendationsAry[index];
				recommendationsHtml+='<tr><td width="10px" style="padding-top: 7px; vertical-align:top;"><div style="background-color:transparent;height:8px;width:8px;border-radius: 50%; border:2px solid  #707070;"></div></td><td style="padding: 0 0 10px 0;color:#1a1a1a;line-height:1.5">'+recommendationsAryObj+'</td></tr>'
			}
			recommendationsHtml+='</tbody></table></div></div>';
		}
		if(recommendationsAry!=undefined && recommendationsAry.length > 0)
		{
			resultContainerObj.add({
				xtype:'panel',
				ui:'newGraphPanel',
				id:'observationPanelId',
				columnWidth:1.0,
				layout: {
					type: 'vbox',
					align: 'stretch'
				},
				flex:1,
				margin:'0 10 10 0',
				items:[
					{
						xtype:'container',
						columnWidth:1.0,
						margin:'10',
						html:recommendationsHtml
					}]
			});
		}
		if(infoName!=undefined&&infoName!='null')
		{
			this.disableToolsForDrilldown();
			if(infoName=='total_runnable')
			{
				if(Ext.getCmp('block_waiting')){Ext.getCmp('block_waiting').hide();}
				if(Ext.getCmp('high_medium')){Ext.getCmp('high_medium').hide();}
			}
			if(infoName=='block_waiting')
			{
				if(Ext.getCmp('total_runnable')){Ext.getCmp('total_runnable').hide();}
				if(Ext.getCmp('high_medium')){Ext.getCmp('high_medium').hide();}
			}
			if(infoName=='high_medium')
			{
				if(Ext.getCmp('total_runnable')){Ext.getCmp('total_runnable').hide();}
				if(Ext.getCmp('block_waiting')){Ext.getCmp('block_waiting').hide();}
			}
		}
	},
	loadCPUResultData:function()
	{
		var resultContainerObj=Ext.getCmp('resultContainer');
		resultContainerObj.removeAll();
		resultContainerObj.show();
		var summaryAry  = appConstants.publicJsonData.summaryAry;
		var heap_graph  = appConstants.publicJsonData.heap_graph;
		var non_heap_graph  = appConstants.publicJsonData.non_heap_graph;
		var ObservationTitleForHeap = appConstants.publicJsonData.ObservationTitleForHeap;
		var ObservationTitleForNonHeap = appConstants.publicJsonData.ObservationTitleForNonHeap;
		var recommentationTitle = appConstants.publicJsonData.recommentationTitle;
		var observationAryForHeap  = appConstants.publicJsonData.observationAryForHeap;
		var observationAryForNonHeap  = appConstants.publicJsonData.observationAryForNonHeap;
		var recommendationsAry  = appConstants.publicJsonData.recommendationsAry;
		var heapMemoryUsageTxt  = appConstants.publicJsonData.firstGraphTitle;
		var nonHeapMemoryUsageTxt  = appConstants.publicJsonData.secondGraphTitle;
		var outliersAry  = appConstants.publicJsonData.outliersAry;
		var outliersHeaderAry  = appConstants.publicJsonData.outliersHeaderAry;
		var outliersRowspanCount  = appConstants.publicJsonData.outliersRowspanCount;
		var csvUrl =  appConstants.publicJsonData.CSV_URL;
		var dataUrl =  appConstants.publicJsonData.DATA_URL;
		var imageDrillDownUrl = appConstants.publicJsonData.IMAGE_DRILL_DOWN_URL;
		var lastRowStyle='';
		var otherRowStyle='border-bottom:1px solid #d8d8d8;';
		var reportName=appConstants.reportName;
		var infoName=appConstants.infoName;
		var columnWidth=1.0;
		var drillDownFlag=false;
		var donutChartObj = appConstants.publicJsonData.donutChartObj;
		var outliersTableHeader = appConstants.publicJsonData.outliersTableHeader;
		var historyOfAlaramUrl = appConstants.publicJsonData.historyOfAlaramUrl;
		if(infoName!=undefined&&infoName!='null')
		{
			drillDownFlag=true;
		}
		if(infoName!=undefined&&infoName!='null')
		{
			columnWidth=1.0;
		}
		if(summaryAry!= undefined && summaryAry.length>0)
		{
			var summaryHtml = '<table align="center" style="margin:0px;width:100%;"><tr>';
			if(donutChartObj != undefined)
			{
				var dataSet = donutChartObj.DataSet;
				var data = dataSet[0].data;
				summaryHtml+='<td width="25%"  class="jvmRightBorder" ><table width="100%" style="text-align:center;"><tr>';
				summaryHtml+='<td width="50%"><div style="height: 90px;"><div id="donutChartCPU" style="height:120px; position:relative; top:-15px; "  ></div></div></td>';
				summaryHtml+='<td width="50%" style=""><table align="left" style="padding: 0 10px  0 0;line-height:1.5;width:100%;">';
				for(var index in data)
				{
					var value = data[index].val;
					var color = data[index].color;
					var name = data[index].name;
					var state=data[index].state;
					summaryHtml+='<tr><td width="5%"><div style="height:7px;width:7px;-webkit-border-radius:4px;background-color:'+color+'"></div>';
					summaryHtml+='</td><td width="75%" class="newFont_bold13">&nbsp;'+name+'</td>';
					summaryHtml+='<td width="20%" class="newFont_bold13"><a href="javascript:void(0);" class="jvmAnchorLink"  onclick=window.location.href="'+historyOfAlaramUrl+"&state="+state+'">'+value+'</a></td></tr>';
				}
				summaryHtml+='</td></table></tr></table></td>';
			}
			else
			{
				summaryHtml+='<td width="25%" class="jvmRightBorder">';
				summaryHtml+='<table  width="100%" align="center" cellspacing="0" cellpadding="0" border="0" Style="align:center;margin:auto auto;"><tr><td colspan="1" rowspan="1"><table align="center"><tr><td align="right" style="padding-right:5px"><div class="iconNoalarms"></div></td></tr></table></td></tr><tr style="text-align: center;"><td colspan="1" rowspan="1" class="newFont_bold13">'+noIncidentMsg+'</td></tr></table>';
				summaryHtml+='</td>';
			}
			for(var index in summaryAry)
			{
				var summaryAryData = summaryAry[index];
				summaryHtml+='<td width="25%" class="jvmRightBorder">';
				summaryHtml+='<table  width="100%" align="center" cellspacing="0" cellpadding="0" border="0" Style="align:center;margin:auto auto;"><tr><td colspan="1" rowspan="1"><table align="center"><tr><td align="right" style="padding-right:5px"><div class="'+summaryAryData.iconCls+'"></div></td><td class="newFont_bold28">'+summaryAryData.data+'</td>';
				summaryHtml+='<td class="newFont_bold20">%</td>';
				summaryHtml+='</tr></table></td></tr><tr style="text-align: center;"><td colspan="1" rowspan="1" class="newFont_bold13">'+summaryAryData.name+'</td></tr></table>';
				summaryHtml+='</td>';
			}
			summaryHtml+='</tr></table>';
			resultContainerObj.add({
			xtype: 'panel',
			ui:'newGraphPanel',
			columnWidth:1.0,
			header:true,
			bodyPadding: '0 0 20 0',
			title:overViewTxt,
			margin: '0 10 10 0',
			html:summaryHtml,
			listeners:
			{
				'boxready':function()
				{
					{
						if(donutChartObj != undefined)
						{
							var lineChart1 = {};
							lineChart1 = jQuery.extend(true, {}, getHighChartsBarInstance('donutChartCPU',100,100), lineChart1);
							lineChart1.setData(donutChartObj,appConstants.currentDateFormat,'');
							lineChart1.drawChart();
						}
					}
				}
			}
		});
		}
		var dataUrlTempHeap='';
		var csvUrlTempHeap='';
		var imageDrillDownUrlTempHeap='';
		var dataInfoUrlFlag=false;
		var csvInfoUrlFlag=false;
		var drillDownUrlFlag=false;
		var heapGraphHtml='<div id="extra_options_heap">';
		if(heap_graph != undefined)
		{
			dataUrlTempHeap=dataUrl+'&er_info_list=heap';
			csvUrlTempHeap=csvUrl+'&er_info_list=heap';
			imageDrillDownUrlTempHeap=imageDrillDownUrl+'&er_info_list=heap';
		}
		heapGraphHtml+='</div>';
		var headerLine = ' graphHeaderBottomBorder';
		if(infoName!=undefined&&infoName!='null')
		{
			headerLine = '';
			dataInfoUrlFlag=true;
			csvInfoUrlFlag=true;
			drillDownUrlFlag=true;
		}
		if(heap_graph != undefined && heap_graph != 'NO_DATA')
		{
			var colorIndicatorHtml='';
			colorIndicatorHtml+='<table align="center"><tbody><tr><td width="10px" style="padding-right:5px;"><div style="height:8px;width:8px;-webkit-border-radius:4px;background-color:#5867a9"></div></td><td class="newFont_bold13" style="padding-right: 20px;">Normal</td><td width="10px" style="padding-right:5px;"><div style="height:8px;width:8px;-webkit-border-radius:4px;background-color:#AC4399"></div></td><td class="newFont_bold13">Above normal</td></tr></tbody></table>';
			//
			var tableData=heap_graph['ShowLegendinTableFormatforUIData'];
			var cpuTable='<div class="newTable" style="padding: 0px 0px 0px 10px;">';
			cpuTable+='<table cellpadding="0px" cellspacing="0px" style="table-layout:fixed;width:100%;">';
			cpuTable+='<colgroup>';
			cpuTable+='<col width="49%">';
			cpuTable+='<col width="17%">';
			cpuTable+='<col width="17%">';
			cpuTable+='<col width="17%">';
			cpuTable+='</colgroup>';
			cpuTable+='<thead>';
			cpuTable+='<tr style="background-color:#DBDBDB;font-size:11px;font-family:Arial;" height="22px">';
			cpuTable+='<th>&nbsp;</th>';
			cpuTable+='<th style="text-align:left;">AVG</th>';
			cpuTable+='<th style="text-align:left;">MAX</th>';
			cpuTable+='<th style="text-align:left;">MIN</th>';
			cpuTable+='</tr>';
			cpuTable+='</thead>';
			cpuTable+='<tbody>';
			cpuTable+='<tr>';
			cpuTable+='<td style="padding-left:9px;" align="left">';
			cpuTable+='<div>';
			cpuTable+='<div style="margin-left:14px;line-height:1.5em;word-break:break-all">'+tableData[0]+'</div>';
			cpuTable+='</div>';
			cpuTable+='</td>';
			cpuTable+='<td align="left">'+tableData[2]+'</td>';
			cpuTable+='<td align="left">'+tableData[3]+'</td>';
			cpuTable+='<td align="left">'+tableData[4]+'</td>';
			cpuTable+='</tr>';
			cpuTable+='</tbody>';
			cpuTable+='</table>';
			cpuTable+='</div>';
			//
			resultContainerObj.add({
			xtype:'panel',
			ui:'newGraphPanel',
			header: {
				style: (strSkin == "Light")? 'border-bottom: 1px solid #EBEBEB !important;padding: 2px 0 2px 0;margin:0px 10px 0px 10px':'margin:0px 10px 0px 10px; padding:  2px 0 2px 0;border-bottom: 1px solid #5e5e5e !important;'
			},
			margin: '0 10 10 0',
			padding: '0 0 0 0',
			columnWidth:columnWidth,
			//height:380,
			title:heapMemoryUsageTxt,
			html:heapGraphHtml,
			tools:[
				this.addToolBarItems([
					{
						xtype: 'button',
						cls:'iconData',
						style:{'border':'0px'},
						width:16,
						height:16,
						margin:'0 3 0 3',
						hidden:dataInfoUrlFlag,
						handler:function(){
							loadDataWindow(dataUrlTempHeap);
						}
					},
					{
						xtype: 'button',
						width:16,
						height:16,
						margin:'0 3 0 3',
						style:{'border':'0px'},
						cls: 'iconCsv',
						hidden:csvInfoUrlFlag,
						handler:function(){
							window.location=csvUrlTempHeap;
						}
					},
					{
						xtype: 'button',
						width:16,
						height:16,
						margin:'0 0 0 3',
						style:{'border':'0px'},
						cls:'iconMaximize',
						hidden:drillDownUrlFlag,
						handler:function(){
							loadUrlInDrillDown(imageDrillDownUrlTempHeap);
						}
					}
				])
			],
			items:[{
				xtype:'container',
				id:'heap_graph_GraphPanel',
				html:'<div id="heap_graph" style="height:270px"> </div>',
				listeners:
				{
					'boxready':function()
					{
						
						{
							var lineChart = {};
							lineChart = jQuery.extend(true, {}, getHighChartsInstance('heap_graph',"230","200"), lineChart);
							lineChart.setData(heap_graph,appConstants.currentDateFormat,'');
							lineChart.drawChart();
						}
						
					}
				}
			},
			{
				xtype:'container',
				margin:'0 10 10 50',
				id:'heap_graph_color',
				html:colorIndicatorHtml
			},
			{
				xtype:'container',
				margin:'0 10 10 0',
				html:cpuTable,
				height:55,
				style:
				{
					'overflow':'hidden'
				}
			},
			{
				xtype:'container',
				margin:'0 20 10 10',
				id:'heap_graph_legendPanel',
				hidden:true,
				height:55,
				style:
				{
					'overflow':'hidden'
				}
			}]
		});
	}
	else
	{
		resultContainerObj.add(this.getNoMeasure(heapMemoryUsageTxt,"heap_graph"));

	}
	var dataUrlTempNonHeap='';
	var csvUrlTempNonHeap='';
	var imageDrillDownUrlTempNonHeap='';
	var nonHeapGraphHtml='<div id="extra_options_nonHeap">';
	if(non_heap_graph != undefined)
	{
		dataUrlTempNonHeap=dataUrl+'&er_info_list=nonheap';
		csvUrlTempNonHeap=csvUrl+'&er_info_list=nonheap';
		imageDrillDownUrlTempNonHeap=imageDrillDownUrl+'&er_info_list=nonheap';
	}
	nonHeapGraphHtml+='</div>';
	if(non_heap_graph != undefined && non_heap_graph != 'NO_DATA')
	{
		resultContainerObj.add({
			xtype:'panel',
			ui:'newGraphPanel',
			columnWidth:columnWidth,
			header: {
				style: (strSkin == "Light")? 'border-bottom: 1px solid #EBEBEB !important;padding: 2px 0 2px 0;margin:0px 10px 10px 10px':'margin:0px 10px 10px 10px; padding:  2px 0 2px 0;border-bottom: 1px solid #5e5e5e !important;'
			},
			margin: '0 10 10 0',
			padding: '0 0 0 0',
			title:nonHeapMemoryUsageTxt,
			html:nonHeapGraphHtml,
			tools:[
				this.addToolBarItems([
					{
						xtype: 'button',
						cls:'iconData',
						style:{'border':'0px'},
						width:16,
						height:16,
						margin:'0 3 0 3',
						hidden:dataInfoUrlFlag,
						handler:function(){
							loadDataWindow(dataUrlTempNonHeap);
						}
					},
					{
						xtype: 'button',
						width:16,
						height:16,
						margin:'0 3 0 3',
						style:{'border':'0px'},
						cls: 'iconCsv',
						hidden:csvInfoUrlFlag,
						handler:function(){
							window.location=csvUrlTempNonHeap;
						}
					},
					{
						xtype: 'button',
						width:16,
						height:16,
						margin:'0 0 0 3',
						style:{'border':'0px'},
						cls:'iconMaximize',
						hidden:drillDownUrlFlag,
						handler:function(){
							loadUrlInDrillDown(imageDrillDownUrlTempNonHeap);
						}
					}
				])
			],
			items:[{
				xtype:'container',
				id:'non_heap_graph_GraphPanel',
				html:'<div id="non_heap_graph"  style="height:270px"> </div>',
				listeners:
				{
					'boxready':function()
					{
						var lineChart = {};
						lineChart = jQuery.extend(true, {}, getHighChartsInstance('non_heap_graph',"230","200"), lineChart);
						lineChart.setData(non_heap_graph,appConstants.currentDateFormat,'');
						lineChart.drawChart();
						if(document.getElementById('non_heap_graph_legendClose')){document.getElementById('non_heap_graph_legendClose').className="iconCloseCircle hideDiv";}
						if(document.getElementById('non_heap_graph_legendExpand')){document.getElementById('non_heap_graph_legendExpand').className="iconCloseCircle hideDiv";}
					}
				}
			},
			{
				xtype:'container',
				margin:'0 10 10 0',
				id:'non_heap_graph_legendPanel',
				style:
				{
					'overflow':'hidden'
				}
			}]
		});
	}
	else
	{
		resultContainerObj.add(this.getNoMeasure(nonHeapMemoryUsageTxt,"non_heap_graph"));
	}
	if(infoName!=undefined&&infoName!='null')
	{
		this.disableToolsForDrilldown();
		if(infoName=='heap')
		{
			if(Ext.getCmp('non_heap_graph')){Ext.getCmp('non_heap_graph').hide();}
		}
		if(infoName=='nonheap')
		{
			if(Ext.getCmp('heap_graph')){Ext.getCmp('heap_graph').hide();}
		}
	}
	var observationHtml ="";
	var seperatorCls='jvmGraphSeperatorLineRight';
	if(observationAryForHeap!=undefined && observationAryForHeap.length>0)
	{
		if(observationAryForHeap.length==1)
		{
			seperatorCls='';
		}
		observationHtml = '<div style="padding:10px 0px 10px 0px" class="font_bold15 jvmNotes">' + ObservationTitleForHeap + '</div><div class="" style="margin:0px 0px 0px 0px; padding: 0 20px 0 0;" ><table style="width: 100%;margin-bottom:10px; "><tbody>';
		for(var index=0;index<=observationAryForHeap.length-1;index+=2)
		{
			var observationAryObj = observationAryForHeap[index];
			var observationAryObj1 = observationAryForHeap[index+1];
			observationHtml+='<tr style="padding-bottom:10px;">'
			if(observationAryObj != undefined)
			{
				observationHtml+='<td width="50%" class="jvmHeaptable "><table><tr><td width="10px;" style="vertical-align:top;padding-top:7px;" ><div style="background-color:transparent;height:8px;width:8px;border-radius: 50%; border:2px solid  #707070;vertical-align: text-top;"></div></td><td style="line-height:1.5;">'+observationAryObj+'</td></tr></table></td>';
			}
			if(observationAryObj1 != undefined)
			{
				observationHtml+='<td width="50%" class="jvmHeaptable"><table><tr><td width="10px"  style="vertical-align:top;padding-top:7px;" ><div style="background-color:transparent;height:8px;width:8px;border-radius: 50%; border:2px solid  #707070;vertical-align: text-top;"></div></td><td style="line-height:1.5;">'+observationAryObj1+'</td></tr></table></td>';
			}
		}
		observationHtml+='</tbody></table></div>';
	}
	//
	var contentHTML="";
	if(outliersAry != undefined && outliersAry.length>0)
	{
		contentHTML ='<div style="font-size: 14px;font-weight: 500;padding: 0 0 0 10px;">'+outliersTableHeader+'</div>';
		contentHTML += '<div class="newTable" id="tableId" style="margin: 10px 10px 10px 10px;">';
		contentHTML += '<table cellpadding="0px" cellspacing="0px" style="table-layout:fixed;width:100%;">';
		contentHTML +='<thead>';
		contentHTML +='<tr>';
		for(var index in outliersHeaderAry)
		{
			contentHTML +='<th align="left">'+outliersHeaderAry[index]+'</th>';
		}
		contentHTML +='</tr>';
		contentHTML +='</thead>';
		contentHTML +='<tbody>';
		var tempArr=[];
		for(var index in outliersAry)
		{
			var outliersAryObj = outliersAry[index];
			var rowSpanCount = outliersRowspanCount[outliersAryObj.monthAndYr];
			contentHTML +='<tr>';
			if(tempArr.indexOf(outliersAryObj.monthAndYr) < 0)
			{
				contentHTML +='<td align="left" valign="center" class="rowspanRightBorder" rowspan="'+rowSpanCount+'">'+outliersAryObj.monthAndYr+' </td>';
				tempArr.push(outliersAryObj.monthAndYr);
			}
			if(outliersAryObj.hour!= undefined)
				 contentHTML +='<td align="left">'+outliersAryObj.hour+'</td>';
			contentHTML +='<td align="left">'+ outliersAryObj.value+ '</td>';
			contentHTML +='</tr>';
		}
		contentHTML +='</tbody></table></div>';
	}
	//recommadation
	var recommendationsHtml = '';
	if(recommendationsAry!=undefined && recommendationsAry.length == 0)
	{
		recommendationsAry.push("<div style='margin:0px 0px 6px 5px'><span class='newFont_normal13'>"+conclusionTxtCPU+"</span></div>");
		recommentationTitle=conclusionTitle;
	}
	if(recommendationsAry!=undefined && recommendationsAry.length > 0)
	{
		recommendationsHtml+='<div class="notes" style="width:100%;padding: 10px 25px 0px 10px;">';
		recommendationsHtml+= '<div class="paperPin "></div>';
		recommendationsHtml+='<div style="padding:0px 0px 10px 0px;color:#000;" class="font_bold15">'+recommentationTitle+'</div><div style="margin:0px 0px 0px 0px"><table width="100%"  style="width: 100%;" align="center"><tbody>';
		for(var index in recommendationsAry)
		{
			var recommendationsAryObj = recommendationsAry[index];
			recommendationsHtml+='<tr><td width="10px" style="padding-top:7px;vertical-align:top;"><div style="background-color:transparent;height:8px;width:8px;border-radius: 50%; border:2px solid  #707070;"></div></td><td style="padding: 0 0 10px 0;color:#1a1a1a;line-height:1.5">'+recommendationsAryObj+'</td></tr>'
		}
		recommendationsHtml+='</tbody></table></div></div>';
	}

	if(ObservationTitleForHeap != undefined)
	{
		resultContainerObj.add({
			xtype:'panel',
			ui:'newGraphPanel',
			id:'observationPanelId',
			margin:'0 10 10 0',
			items:[
					{
						xtype: 'container',
						padding: '0 10 0 10',
						margin: '10 10 10 10',
						cls: 'jvmObservPanelBox',
						items: [
								{
								xtype: 'container',
								ui: 'newGraphPanel noShadow ',
								margin: '0 0 0 0',
								bodyPadding: '10px 0px 0px 10px',
								columnWidth: 1.0,
								layout: 'column',
								id:'heapObs',
								items: [
										{
											xtype: 'container',
											columnWidth: 1.0,
											padding: 0,
											cls: seperatorCls,
											margin: '0 0 0 0',
											html:observationHtml
										}]					
								}
							]
					},
				{
					xtype:'container',
					columnWidth:1.0,
					margin:'10 0 0 0',
					html:contentHTML
				}]
		});
		if(recommendationsAry!=undefined && recommendationsAry.length > 0)
		{
			resultContainerObj.add({
				xtype:'panel',
				ui:'newGraphPanel',
				margin:'0 10 20 0',
				columnWidth:1.0,
				items:[{
					xtype:'container',
					columnWidth:1.0,
					margin:'10 10 10 10',
					html:recommendationsHtml
				}]
			});
		}
	}
	},
	loadResultData:function()
	{
		var resultContainerObj=Ext.getCmp('resultContainer');
		resultContainerObj.removeAll();
		resultContainerObj.show();
		var summaryAry  = appConstants.publicJsonData.summaryAry;
		var heap_graph  = appConstants.publicJsonData.heap_graph;
		var non_heap_graph  = appConstants.publicJsonData.non_heap_graph;
		var ObservationTitleForHeap = appConstants.publicJsonData.ObservationTitleForHeap;
		var ObservationTitleForNonHeap = appConstants.publicJsonData.ObservationTitleForNonHeap;
		var recommentationTitle = appConstants.publicJsonData.recommentationTitle;
		var observationAryForHeap  = appConstants.publicJsonData.observationAryForHeap;
		var observationAryForNonHeap  = appConstants.publicJsonData.observationAryForNonHeap;
		var recommendationsAry  = appConstants.publicJsonData.recommendationsAry;
		var heapMemoryUsageTxt  = appConstants.publicJsonData.firstGraphTitle;
		var nonHeapMemoryUsageTxt  = appConstants.publicJsonData.secondGraphTitle;
		var outliersAry  = appConstants.publicJsonData.outliersAry;
		var outliersHeaderAry  = appConstants.publicJsonData.outliersHeaderAry;
		var outliersRowspanCount  = appConstants.publicJsonData.outliersRowspanCount;
		var csvUrl =  appConstants.publicJsonData.CSV_URL;
		var dataUrl =  appConstants.publicJsonData.DATA_URL;
		var imageDrillDownUrl = appConstants.publicJsonData.IMAGE_DRILL_DOWN_URL;
		var donutChartObj = appConstants.publicJsonData.donutChartObj;
		var historyOfAlaramUrl = appConstants.publicJsonData.historyOfAlaramUrl;
		var lastRowStyle='';
		var otherRowStyle='border-bottom:1px solid #d8d8d8;';
		var reportName=appConstants.reportName;
		var infoName=appConstants.infoName;
		var columnWidth=1.0;
		var drillDownFlag=false;
		var observationHtml ="";
		var seperatorCls='jvmGraphSeperatorLineRight';
		if(observationAryForHeap!=undefined && observationAryForHeap.length>0)
		{
			if(observationAryForHeap.length==1)
			{
				seperatorCls='';
			}
			observationHtml = '<div style="padding:10px 0px 10px 0px" class="font_bold15 jvmNotes">' + ObservationTitleForHeap + '</div><div class="" style="margin:0px 0px 0px 0px; padding: 0 20px 0 0;" ><table style="width: 100%;margin-bottom:10px; "><tbody>';
			for(var index=0;index<=observationAryForHeap.length-1;index+=2)
			{
				var observationAryObj = observationAryForHeap[index];
				var observationAryObj1 = observationAryForHeap[index+1];
				observationHtml+='<tr style="padding-bottom:10px;">'
				if(observationAryObj != undefined)
				{
					observationHtml+='<td width="50%" class="jvmHeaptable "><table><tr><td width="10px;" style="vertical-align:top;padding-top:7px;" ><div style="background-color:transparent;height:8px;width:8px;border-radius: 50%; border:2px solid  #707070;vertical-align: text-top;"></div></td><td style="line-height:1.5;">'+observationAryObj+'</td></tr></table></td>';
				}
				if(observationAryObj1 != undefined)
				{
					observationHtml+='<td width="50%" class="jvmHeaptable"><table><tr><td width="10px"  style="vertical-align:top;padding-top:7px;" ><div style="background-color:transparent;height:8px;width:8px;border-radius: 50%; border:2px solid  #707070;vertical-align: text-top;"></div></td><td style="line-height:1.5;">'+observationAryObj1+'</td></tr></table></td>';
				}
				observationHtml+='</tr>';
			}
			observationHtml+='</tbody></table></div>';
		}
		//
		seperatorCls='jvmGraphSeperatorLineRight';
		if(observationAryForNonHeap!=undefined && observationAryForNonHeap.length>0)
		{
			if(observationAryForNonHeap.length==1)
			{
				seperatorCls='';
			}
			var observationHtmlNonHeap = '<div style="padding:10px 0px 10px 0px" class="font_bold15 jvmNotes">' + ObservationTitleForNonHeap + '</div><div class="" style="margin:0px 0px 0px 0px; padding: 0 20px 0 0;" ><table style="width: 100%;margin-bottom:10px; "><tbody>';
			for(var index=0;index<=observationAryForNonHeap.length-1;index+=2)
			{
				var observationAryObj = observationAryForNonHeap[index];
				var observationAryObj1 = observationAryForNonHeap[index+1];
				if(index==observationAryForNonHeap.length-1)
					observationHtmlNonHeap+='<tr style="padding-bottom:10px;">'
				else
					observationHtmlNonHeap+='<tr style="padding-bottom:10px;">'
				if(observationAryObj != undefined)
				{
					observationHtmlNonHeap+='<td width="50%" class="jvmHeaptable"><table><tr><td width="10px"  style="vertical-align:top;padding-top: 7px;" ><div style="background-color:transparent;height:8px;width:8px;border-radius: 50%; border:2px solid  #707070;"></div></td><td style="line-height:1.5;">'+observationAryObj+'</td></tr></table></td>';
				}
				if(observationAryObj1 != undefined)
				{
					observationHtmlNonHeap+='<td width="50%" style="padding-bottom:10px;" class="jvmHeaptable"><table><tr><td width="10px"  style="vertical-align:top;padding-top: 7px;" ><div style="background-color:transparent;height:8px;width:8px;border-radius: 50%; border:2px solid  #707070;"></div></td><td style="line-height:1.5;" >'+observationAryObj1+'</td></tr></table></td>';
				}
				observationHtmlNonHeap+='</tr>';
			}
		}
		observationHtmlNonHeap+='</tbody></table></div>';
		//recommadation
		var recommendationsHtml = '';
		if(recommendationsAry!=undefined && recommendationsAry.length > 0)
		{
			recommendationsHtml+='<div class="notes" style="width:100%;padding: 10px 25px 0px 10px;">';
			recommendationsHtml+= '<div class="paperPin"></div>';
			recommendationsHtml+='<div style="padding:0px 0px 10px 0px;color:#000;" class="font_bold15" >'+recommentationTitle+'</div><div style="margin:0px 0px 0px 0px"><table width="100%"  style="width: 100%; " align="center"><tbody>';
			for(var index in recommendationsAry)
			{
				var recommendationsAryObj = recommendationsAry[index];
				recommendationsHtml+='<tr>';
				if(recommendationsAryObj.indexOf('Review')<0 && recommendationsAryObj.indexOf('dumps')<0)
				{
					recommendationsHtml+='<td width="15px" style="padding-top:7px;vertical-align:top;"><div style="background-color:transparent;height:8px;width:8px;border-radius: 50%; border:2px solid  #707070;"></div></td>';
				}
				else
				{
					recommendationsHtml+='<td></td>';
				}
				recommendationsHtml+='<td style="color:#1a1a1a;line-height:1.5">'+recommendationsAryObj+'</td>';
				recommendationsHtml+='</tr>';
			}
			recommendationsHtml+='</tbody></table></div></div>';
		}
		
		if(infoName!=undefined&&infoName!='null')
		{
			drillDownFlag=true;
		}
		if(infoName!=undefined&&infoName!='null')
		{
			columnWidth=1.0;
		}
		if(summaryAry!= undefined && summaryAry.length>0)
		{
			var summaryHtml = '<table align="center" style="margin:0px;width:100%;"><tr>';
			if(donutChartObj != undefined)
			{
				var dataSet = donutChartObj.DataSet;
				var data = dataSet[0].data;
				summaryHtml+='<td width="25%" class="jvmRightBorder"><table width="100%"><tr>';
				summaryHtml+='<td width="40%" ><div style="height: 90px;"><div id="donutChart" style="height:120px; position:relative; top:-15px; "  ></div></div></td>';
				summaryHtml+='<td width="50%"><table align="left" style="width:100%;padding: 0 10px 0 0;line-height:1.5;">';
				for(var index in data)
				{
					var value = data[index].val;
					var color = data[index].color;
					var name = data[index].name;
					var state=data[index].state;
					summaryHtml+='<tr><td width="5%"><div style="height:7px;width:7px;-webkit-border-radius:4px;background-color:'+color+'"></div>';
					summaryHtml+='</td><td width="75%" class="newFont_bold13">&nbsp;'+name+'</td><td width="20%" class="newFont_bold13"><a href="javascript:void(0);" class="jvmAnchorLink"  onclick=window.location.href="'+historyOfAlaramUrl+"&infoName=heapAndNon&state="+state+'">'+value+'</a></td></tr>';
				}
				summaryHtml+='</td></table></tr></table></td>';
			}
			else
			{
				summaryHtml+='<td width="25%" class="jvmRightBorder">';
				summaryHtml+='<table  width="100%" align="center" cellspacing="0" cellpadding="0" border="0" Style="align:center;margin:auto auto;"><tr><td colspan="1" style="padding: 0px 0 0 0;" rowspan="1"><table align="center"><tr><td align="right" style="padding-right:5px; vertical-align:top;"><div class="iconNoalarms"></div></td></tr></table></td></tr><tr style="text-align: center;"><td colspan="1" rowspan="1" class="newFont_bold13">'+noIncidentMsg+'</td></tr></table>';
				summaryHtml+='</td>';
			}
			for(var index in summaryAry)
			{
				var summaryAryData = summaryAry[index];
				summaryHtml+='<td width="25%" class="jvmRightBorder">';
				summaryHtml+='<table  width="100%" align="center" cellspacing="0" cellpadding="0" border="0" Style="align:center;margin:auto auto;"><tr><td colspan="1" style="padding: 0px 0 0 0;" rowspan="1"><table align="center"><tr><td align="right" style="padding-right:5px;vertical-align:top;"><div class="'+summaryAryData.iconCls+'"></div></td><td class="newFont_bold28" style="line-height: 1;">'+summaryAryData.data+'</td>';
				summaryHtml+='<td class="newFont_bold20">%</td>';
				summaryHtml+='</tr></table></td></tr><tr style="text-align: center;"><td colspan="1" rowspan="1" class="newFont_bold13">'+summaryAryData.name+'</td></tr></table>';
				summaryHtml+='</td>';
			}
			summaryHtml+='</tr></table>';
			resultContainerObj.add({
				xtype: 'panel',
				ui:'newGraphPanel',
				columnWidth:1.0,
				title:overViewTxt,
				bodyPadding: '5 0 0 0',
				margin: '0 10 10 0',
				padding: '0 0 20 0',
				html:summaryHtml,
				listeners:
				{
					'boxready':function()
					{
						{
							if(donutChartObj != undefined)
							{
								var lineChart1 = {};
								lineChart1 = jQuery.extend(true, {}, getHighChartsBarInstance('donutChart',100,100), lineChart1);
								lineChart1.setData(donutChartObj,appConstants.currentDateFormat,'');
								lineChart1.drawChart();
							}
						}
					}
				}
			});
		}
		var dataUrlTempHeap='';
		var csvUrlTempHeap='';
		var imageDrillDownUrlTempHeap='';
		var dataInfoUrlFlag=false;
		var csvInfoUrlFlag=false;
		var drillDownUrlFlag=false;
		var heapGraphHtml='<div id="extra_options_heap">';
		if(heap_graph != undefined)
		{
			dataUrlTempHeap=dataUrl+'&er_info_list=heap';
			csvUrlTempHeap=csvUrl+'&er_info_list=heap';
			imageDrillDownUrlTempHeap=imageDrillDownUrl+'&er_info_list=heap';
		}
		heapGraphHtml+='</div>';
		var headerLine = ' graphHeaderBottomBorder';
		var legendPanelColumnWidth=0.5;
		if(infoName!=undefined&&infoName!='null')
		{
			headerLine = '';
			dataInfoUrlFlag=true;
			csvInfoUrlFlag=true;
			drillDownUrlFlag=true;
			legendPanelColumnWidth=1.0;
		}
		if(heap_graph != undefined && heap_graph != 'NO_DATA')
		{
			resultContainerObj.add({
			xtype:'panel',
			ui:'newGraphPanel',
			columnWidth:columnWidth,
			header : {
			style: (strSkin == "Light")? 'border-bottom: 1px solid #EBEBEB !important;padding: 2px 0 2px 0;margin:0px 10px 0px 10px':'margin:0px 10px 0px 10px; padding:  2px 0 2px 0;border-bottom: 1px solid #5e5e5e !important;'
			},
			layout: {
				type: 'vbox',
				align:'stretch'
			},
			flex:1,
			margin: '0 10 10 0',
			padding: '0 0 0 0',
			title:heapMemoryUsageTxt,
			html:heapGraphHtml,
			tools:[
				this.addToolBarItems([
					{
						xtype: 'button',
						cls:'iconData',
						style:{'border':'0px'},
						width:16,
						height:16,
						margin:'0 3 0 3',
						hidden:dataInfoUrlFlag,
						handler:function(){
							loadDataWindow(dataUrlTempHeap);
						}
					},
					{
						xtype: 'button',
						width:16,
						height:16,
						margin:'0 3 0 3',
						style:{'border':'0px'},
						cls: 'iconCsv',
						hidden:csvInfoUrlFlag,
						handler:function(){
							window.location=csvUrlTempHeap;
						}
					},
					{
						xtype: 'button',
						width:16,
						height:16,
						margin:'0 0 0 3',
						style:{'border':'0px'},
						cls:'iconMaximize',
						hidden:drillDownUrlFlag,
						handler:function(){
							loadUrlInDrillDown(imageDrillDownUrlTempHeap);
						}
					}
				])
			],
			items:[{
				xtype:'container',
				id:'heap_graph_GraphPanel',
				
				html:'<div id="heap_graph" style="height:270px"> </div>',
				listeners:
				{
					'boxready':function()
					{
						{
							var lineChart = {};
							lineChart = jQuery.extend(true, {}, getHighChartsInstance('heap_graph',"230","200"), lineChart);
							lineChart.setData(heap_graph,appConstants.currentDateFormat,'');
							lineChart.drawChart();
							if(document.getElementById('heap_graph_legendClose')){document.getElementById('heap_graph_legendClose').className="iconCloseCircle hideDiv";}
							if(document.getElementById('heap_graph_legendExpand')){document.getElementById('heap_graph_legendExpand').className="iconCloseCircle hideDiv";}
						}
					}
				}
			},
			{
				xtype:'container',
				margin:'10 10 10 0',
				id:'heap_graph_legendPanel',
				//height:55,
				style:
				{
					'overflow':'hidden'
				}
			},
			{
				xtype: 'container',
				id:'heapObs', 
				padding: '0 0 0 10',
				margin: '0 10 10 10',
				cls: 'jvmObservPanelBox',
				items: [
					{
					xtype:'container',
					margin:'0 0 0 0',
					padding: '0 10 0 0',
					cls:seperatorCls,
					html:observationHtml
					}
				]
			}
			]
		});
	}
	else
	{
		resultContainerObj.add(this.getNoMeasure(heapMemoryUsageTxt,"heap_graph"));
	}
	var dataUrlTempNonHeap='';
	var csvUrlTempNonHeap='';
	var imageDrillDownUrlTempNonHeap='';
	var nonHeapGraphHtml='<div id="extra_options_nonHeap">';
	if(non_heap_graph != undefined)
	{
		dataUrlTempNonHeap=dataUrl+'&er_info_list=nonheap';
		csvUrlTempNonHeap=csvUrl+'&er_info_list=nonheap';
		imageDrillDownUrlTempNonHeap=imageDrillDownUrl+'&er_info_list=nonheap';
	}
	nonHeapGraphHtml+='</div>';
	if(non_heap_graph != undefined && non_heap_graph != 'NO_DATA')
	{
		resultContainerObj.add({
			xtype:'panel',
			ui:'newGraphPanel ',
			columnWidth:columnWidth,
			header: {
				style: (strSkin == "Light")? 'border-bottom: 1px solid #EBEBEB !important;padding: 2px 0 2px 0;margin:0px 10px 10px 10px':'margin:0px 10px 10px 10px; padding:  2px 0 2px 0;border-bottom: 1px solid #5e5e5e !important;'
				},
				margin: '0 10 10 0',
				padding: '0 0 0 0',
			title:nonHeapMemoryUsageTxt,
			html:nonHeapGraphHtml,
			tools:[
				this.addToolBarItems([
					{
						xtype: 'button',
						cls:'iconData',
						style:{'border':'0px'},
						width:16,
						height:16,
						margin:'0 3 0 3',
						hidden:dataInfoUrlFlag,
						handler:function(){
							loadDataWindow(dataUrlTempNonHeap);
						}
					},
					{
						xtype: 'button',
						width:16,
						height:16,
						margin:'0 3 0 3',
						style:{'border':'0px'},
						cls: 'iconCsv',
						hidden:csvInfoUrlFlag,
						handler:function(){
							window.location=csvUrlTempNonHeap;
						}
					},
					{
						xtype: 'button',
						width:16,
						height:16,
						margin:'0 0 0 3',
						style:{'border':'0px'},
						cls:'iconMaximize',
						hidden:drillDownUrlFlag,
						handler:function(){
							loadUrlInDrillDown(imageDrillDownUrlTempNonHeap);
						}
					}
				])
			],
			items:[{
				xtype:'container',
				id:'non_heap_graph_GraphPanel',
				
				margin: '0 0 0 0 ',
				html:'<div id="non_heap_graph"  style="height:270px"> </div>',
				listeners:
				{
					'boxready':function()
					{
						var lineChart = {};
						lineChart = jQuery.extend(true, {}, getHighChartsInstance('non_heap_graph',"230","200"), lineChart);
						lineChart.setData(non_heap_graph,appConstants.currentDateFormat,'');
						lineChart.drawChart();
						if(document.getElementById('non_heap_graph_legendClose')){document.getElementById('non_heap_graph_legendClose').className="iconCloseCircle hideDiv";}
						if(document.getElementById('non_heap_graph_legendExpand')){document.getElementById('non_heap_graph_legendExpand').className="iconCloseCircle hideDiv";}
					}
				}
			},
			{
				xtype:'container',
				margin:'10 10 10 0',
				//height:55,
				id:'non_heap_graph_legendPanel',
				style:
				{
					'overflow':'hidden'
				}
			},
			{
				xtype: 'container',
				id:'nonheapObs',
				padding: '0 0 0 10',
				margin: '0 10 10 10',
				cls: 'jvmObservPanelBox',
				items: [
					{
						xtype:'container',
						margin:'0 0 0 0',
						padding: '0 10 0 0',
						cls:seperatorCls,
						html:observationHtmlNonHeap
					}
				]
			}
			]
		});
	}
	else
	{
		resultContainerObj.add(this.getNoMeasure(nonHeapMemoryUsageTxt,"non_heap_graph"));
	}
	resultContainerObj.add({
		xtype:'panel',
		ui:'newGraphPanel',
		id:'observationPanelId',
		columnWidth:1.0,
		layout:'column',
		margin:'0 10 20 0',
		items:[
			{
				xtype:'container',
				margin:10,
				columnWidth:1.0,
				html:recommendationsHtml
			}]
	});
	if(infoName!=undefined&&infoName!='null')
	{
		this.disableToolsForDrilldown();
		if(infoName=='heap')
		{
			if(Ext.getCmp('non_heap_graph')){Ext.getCmp('non_heap_graph').hide();}
		}
		if(infoName=='nonheap')
		{
			if(Ext.getCmp('heap_graph')){Ext.getCmp('heap_graph').hide();}
		}
	}
	},
	submitReoprt:function(obj)
	{
		this.showResult(obj)
	},
	showResult:function(obj)
	{
		var reportGeneration;
		if (isSettingsEnabled)
			reportGeneration=Ext.getCmp('reportGeneration').getValue();
		else
			reportGeneration=appConstants.publicJsonData.selectedFields.reportGenerationSelected;
		var reportName=appConstants.reportName;
		var infoName=appConstants.infoName;
		var extraParam='&er_reportname='+reportName;
		if(infoName!= undefined && infoName!= 'null')
		{
			extraParam+='&er_info_list='+infoName+'&isFromDrillDown=yes';
		}
		if(reportName != undefined && reportName == 'jvm_cpu'){
			this.foregroundControllerUrl='../servlet/com.eg.ErJvmCpuC';
		}
		if(reportName != undefined && reportName == 'jvm_garbage'){
			this.foregroundControllerUrl='../servlet/com.eg.ErJvmGarbageC';
		}
		if(reportName != undefined && reportName == 'jvm_thrd'){
			this.foregroundControllerUrl='../servlet/com.eg.ErJvmThreadC';
		}
		if (reportGeneration == 'foreground' && this.validateMainForm(true)) {
			this.getAjaxDataForSubmit(this.foregroundControllerUrl,'isSubmit=true&'+this.getQueryString(true,true,true)+extraParam);
		}
		else if(reportGeneration == 'background-csv'&& this.validateMainForm(true)){
			this.getAjaxDataForSubmit("../servlet/com.eg.ErStartBackGroundReportC?isSubmit=true&SaveFormat=CSV&isBackgroundCSV=Yes",this.getQueryString(true,true,true)+extraParam);
		}
		else if(reportGeneration == 'background-xls'&& this.validateMainForm(true))
		{
			this.getAjaxDataForSubmit( "../servlet/com.eg.ErStartBackGroundReportC?isSubmit=true&SaveFormat=XLSX",this.getQueryString(true,true,true)+extraParam);
		}
		else if(reportGeneration == 'background' && this.validateMainForm(true)){
			this.getAjaxDataForSubmit(this.backgroundControllerUrl,"isSubmit=true&"+this.getQueryString(true,true,true)+extraParam);
		}
	},
	/*onWeekendChange:function(obj)
	{
 		var excludeDaysObj=Ext.getCmp('excludeDays');
		if(obj.getValue() == 'Yes'){
			excludeDaysObj.show();
			excludeDaysObj.update(appConstants.publicJsonData.labelFields.excludeDaysLabel);
		}
		else
			excludeDaysObj.hide();
	},*/
	disableTools: function()
	{
		Ext.getCmp("saveTool").setDisabled(true);
		Ext.getCmp("bookletTool").setDisabled(true);
		Ext.getCmp("printTool").setDisabled(true);
		Ext.getCmp("mailTool").setDisabled(true);
		Ext.getCmp("csvTool").setDisabled(true);
	},
	enableTools: function()
	{
		Ext.getCmp("saveTool").setDisabled(false);
		Ext.getCmp("bookletTool").setDisabled(false);
		Ext.getCmp("printTool").setDisabled(false);
		Ext.getCmp("mailTool").setDisabled(false);
	},
	hideResults:function()
	{
		Ext.getCmp('resultContainer').hide();
		Ext.getCmp('backGroundPanel').hide();
		this.getNomeasurepanel().hide();
	},
	disableToolsForDrilldown: function()
	{
		Ext.getCmp("bookletTool").hide();
		Ext.getCmp("mailTool").hide();
		Ext.getCmp("favoriteTool").hide();
		Ext.getCmp("scheduleTool").hide();
		Ext.getCmp("leftCallout").hide();
		Ext.getCmp("er_option").hide();
		Ext.getCmp("er_site").hide();
		Ext.getCmp("er_compType").hide();
		Ext.getCmp("er_component").hide();
		Ext.getCmp("popClose").show();
		Ext.getCmp("csvTool").setDisabled(false);
		Ext.getCmp("csvTool").show();
		if(Ext.getCmp("heapObs")){Ext.getCmp("heapObs").hide();}
		if(Ext.getCmp("nonheapObs")){Ext.getCmp("nonheapObs").hide();}
		if(Ext.getCmp("observationPanelId")){Ext.getCmp("observationPanelId").hide();}
	},
		
	onSelectAnalysisBy: function (obj) 
	{
		var er_option=obj.getValue();
		var params='er_option='+er_option+"&er_reportname="+appConstants.er_reportname;
		var me = this;
		initLdgMask.show();
		var reportName=appConstants.reportName;
		if(reportName != undefined && reportName == 'jvm_cpu'){
			me.foregroundJspUrl = '/final/reporter/JvmMemoryReportJson.jsp';
		}
		Ext.Ajax.request(
		{
			url : me.foregroundJspUrl,
			params : params,
			scope:this,
			success: function(response)
			{
				initLdgMask.hide();
				me.hideResults();
				appConstants.publicJsonData=Ext.decode(response.responseText);
				if(appConstants.publicJsonData.combo.siteCombo!=undefined)
				{
					Ext.getCmp('er_site').show();
					me.loadComboField('er_site','siteCombo','siteComboLabel','selectedSiteCombo',appConstants.publicJsonData,false,null,true);
				}
				else
				{
					Ext.getCmp('er_site').hide();
				}
				me.loadComboField('er_compType','compTypeCombo','compTypeComboLabel','selectedCompTypeCombo',appConstants.publicJsonData,false,null,true);
				this.loadComboField('er_component','componentCombo','componentLabel','componentSelected',appConstants.publicJsonData,false,null,true);
			
			}
		});
	},
	onSelectSiteBy: function (obj) 
	{
		var me = this
		var er_site=obj.getValue();
		var params='er_option='+Ext.getCmp('er_option').getValue(); 
		params+='&er_site='+er_site; 
		params+='&er_reportname='+appConstants.er_reportname; 
		initLdgMask.show();
		Ext.Ajax.request(
		{
			url : me.foregroundJspUrl,
			params : params,
			scope:this,
			success: function(response)
			{
				initLdgMask.hide();
				me.hideResults();
				appConstants.publicJsonData=Ext.decode(response.responseText);
				me.loadComboField('er_compType','compTypeCombo','compTypeComboLabel','selectedCompTypeCombo',appConstants.publicJsonData,false,null,true);
				this.loadComboField('er_component','componentCombo','componentLabel','componentSelected',appConstants.publicJsonData,false,null,true);
			
			}
		});
	},
	onSelectCompTypeBy: function (obj) 
	{
		var er_compType=obj.getValue();
		var params='er_compType='+er_compType;
		params+='&er_site='+Ext.getCmp('er_site').getValue(); 
		params+='&er_option='+Ext.getCmp('er_option').getValue();
		params+='&er_reportname='+appConstants.er_reportname; 
		var me = this;
		initLdgMask.show();
		Ext.Ajax.request(
		{
			url : me.foregroundJspUrl,
			params : params,
			scope:this,
			success: function(response)
			{
				initLdgMask.hide();
				me.hideResults();
				appConstants.publicJsonData=Ext.decode(response.responseText);
				this.loadComboField('er_component','componentCombo','componentLabel','componentSelected',appConstants.publicJsonData,false,null,true);
			
			}
		});
	},
	onChangeReportGeneration:function(obj)
	{
		this.hideResults();
		this.disableTools();
		Ext.getCmp('submitViaSetting').show();
		Ext.getCmp('moreOptionCloseId').hide();
 		if(obj.getValue()== 'background'){
			Ext.getCmp('bgReportName').setValue("");
			Ext.getCmp('bgReportName').show();
		}
		else if(obj.getValue()== 'background-csv'){
			Ext.getCmp('bgReportName').setValue("");
			Ext.getCmp('bgReportName').show();
		}
		else{
			Ext.getCmp('submitViaSetting').hide();
			Ext.getCmp('moreOptionCloseId').show();
			Ext.getCmp('bgReportName').hide();
		}
	},
	getAjaxData:function(url,query)
	{
		Ext.Ajax.request(
		{
			url : url,
			params : query,
			async:false,
			scope:this,
			success: function(response){
			appConstants.publicJsonData=Ext.decode(response.responseText);
			}
		});
	},
	getAjaxDataForSubmit:function(url,query)
	{
		var me=this;
		initLdgMask.show();
		Ext.Ajax.request(
		{
			url : url,
			params : query,
			scope:this,
			success: function(response)
			{
				initLdgMask.hide();
				appConstants.publicJsonData=Ext.decode(response.responseText);
				me.loadReportData();
			}
		});
	},
	getQueryString:function(needFilter,isOthers,isSettings)
	{
		var queryString;
		var timefrom,minfrom,timeto,minto,er_excwe,reportGeneration,bg_reportname;
		
		if (isSettingsEnabled)
		{
			timefrom=Ext.getCmp('timefrom').getValue();
			minfrom=Ext.getCmp('minfrom').getValue();
			timeto=Ext.getCmp('timeto').getValue();
			minto=Ext.getCmp('minto').getValue();
			er_excwe=Ext.getCmp('er_excwe').getValue();
			reportGeneration=Ext.getCmp('reportGeneration').getValue();
			bg_reportname = Ext.getCmp('bgReportName').getValue();
 		}
		else
		{
			var selectedFields=appConstants.publicJsonData.selectedFields;
			timefrom=selectedFields.selectedTimeFrom;
			minfrom=selectedFields.selectedMinsFrom;
			timeto=selectedFields.selectedTimeTo;
			minto=selectedFields.selectedMinsTo;
			er_excwe=selectedFields.excludeWeekendsSelected;
			reportGeneration=selectedFields.reportGenerationSelected;
			bg_reportname=selectedFields.reportNameSelected;
 		}
		var er_option=Ext.getCmp('er_option').getValue();
		queryString='er_type=Yes';
		queryString+='&er_option='+er_option;
		if(er_option!=undefined && er_option!='Component')
		{
			queryString+='&er_site='+Ext.getCmp('er_site').getValue();
		}
		queryString+='&er_compType='+Ext.getCmp('er_compType').getValue();
		var queryArray = Ext.getCmp('er_component').getValue();
		queryString+="&er_component="+queryArray;
		if (isSettings)
		{
			var stHr=Ext.getCmp('er_sthr').dataArray;
			var startDateConverted = Ext.getCmp('er_stdate').dataArray;
			var endDateConverted = Ext.getCmp('er_enddate').dataArray;
			queryString+= "&er_timeline=" + Ext.getCmp('er_timeline').getValue() + "&startdate=" + startDateConverted + "&enddate=" + endDateConverted + "&starthr=" + Ext.getCmp('er_sthr').dataArray + "&endhr=" + Ext.getCmp('er_endhr').dataArray + "&startmin=" + mgr_stmin + "&endmin=" + mgr_enmin;
			
			queryString+="&timefrom="+timefrom+"&minfrom="+minfrom+"&timeto="+timeto+"&minto="+minto;
			queryString+="&er_excwe="+er_excwe;
			var queryArray=new Array();
					
 			if (reportGeneration == 'foreground') 
			{
 				queryString+="&er_reportgenration="+reportGeneration+"&responseType=json";
			} 
			else
			{
				bg_reportname=checkFileName(bg_reportname);
				queryString+="&er_reportgenration="+reportGeneration+"&bg_reportname="+bg_reportname;
			}
		}
		if (isOthers)
		{
			if(appConstants.publicJsonData.hasOwnProperty('hiddenFields'))
			{
				var hiddenFields = appConstants.publicJsonData.hiddenFields;
				for (var hiddenField in hiddenFields)
				{
					if(this.isNewFav!=undefined && this.isNewFav)
					{
						if(hiddenField!=undefined && hiddenField=='ID')
						{
							continue;
						}
						if(hiddenField!=undefined && hiddenField=='FavoriteId')
						{
							continue;
						}
					}
					queryString+="&"+hiddenField+"="+hiddenFields[hiddenField];
				}
			}
		}
		queryString+="&er_RmDispName="+appConstants.er_RmDispName;
		queryString+="&chartType="+appConstants.chartType;
		return queryString;
	},
	boxready:function()
	{
  		var thisController = this;
		if(!appConstants.hideBackButton){
			Ext.getCmp('mainform').add(
				{
					xtype: 'hidden',
					id: 'ID',
					name: 'ID',
					value: appConstants.publicJsonData['ID']
				}
			);
		}
		this.getMain().setTitle(appConstants.er_RmDispName);
		if(appConstants.frmFavModify!=undefined && appConstants.frmFavModify=='Yes')
		{
			return;
		}
		if(appConstants.frmSchModify!=undefined && appConstants.frmSchModify=='Yes')
		{
			return;
		}
		if (appConstants.isForceSubmit=="true" || appConstants.isSubmit=="true"){
			this.loadReportData(appConstants.publicjsonData);
		}
 	},
	onChangeReportGeneration:function(obj)
	{
		this.hideResults();
		this.disableTools();
		Ext.getCmp('submitViaSetting').show();
		Ext.getCmp('moreOptionCloseId').hide();
 		if(obj.getValue()== 'background'){
			Ext.getCmp('bgReportName').setValue("");
			Ext.getCmp('bgReportName').show();
		}
		else if(obj.getValue()== 'background-csv'){
			Ext.getCmp('bgReportName').setValue("");
			Ext.getCmp('bgReportName').show();
		}
		else if(obj.getValue()== 'background-xls'){
			Ext.getCmp('bgReportName').setValue("");
			Ext.getCmp('bgReportName').show();
		}
		else{
			Ext.getCmp('submitViaSetting').hide();
			Ext.getCmp('moreOptionCloseId').show();
			Ext.getCmp('bgReportName').hide();
		}
	},
	loadForm:function()
	{
		this.loadFormFields();
        var from_schedule = appConstants.frmSchModify;
		var fromFavoriteModify = appConstants.frmFavModify;
		if (from_schedule == "Yes" || fromFavoriteModify == "Yes") {
			Ext.getCmp("submit").hide();
			Ext.getCmp("save").show();
			Ext.getCmp("favoriteTool").setDisabled(true);
			Ext.getCmp("scheduleTool").setDisabled(true);
		}
		else
		{
			Ext.getCmp("submit").show();
			Ext.getCmp("save").hide();
		}
		var date=appConstants.publicJsonData.selectedFields.startDateForDisplay;
		var component=Ext.getCmp('er_stdate');
		component.setValue(date);
		component.dataArray=date;
		date=appConstants.publicJsonData.selectedFields.endDateForDisplay;
		component=Ext.getCmp('er_enddate');
		component.setValue(date);
		component.dataArray=date;
	
		Ext.getCmp('er_sthr').setValue(appConstants.publicJsonData.selectedFields.startHourForDisplay);
		Ext.getCmp('er_endhr').setValue(appConstants.publicJsonData.selectedFields.endHourForDisplay);
		Ext.getCmp('er_sthr').dataArray=appConstants.publicJsonData.selectedFields.startHour;
		Ext.getCmp('er_endhr').dataArray=appConstants.publicJsonData.selectedFields.endHour;
		stmin = appConstants.publicJsonData.selectedFields.startMinForDisplay;
		enmin = appConstants.publicJsonData.selectedFields.endMinForDisplay;
		mgr_stmin=appConstants.publicJsonData.selectedFields.startmin;
		mgr_enmin=appConstants.publicJsonData.selectedFields.endmin;
 	},
	loadFormFields:function()
	{
		this.loadComboField('er_option','analysisByCombo','analysisComboLabel','selectedAnalysisByCombo',appConstants.publicJsonData,false,null,true);
		this.loadComboField('er_timeline','timelineCombo','timelineComboLabel','selectedTimeline',appConstants.publicJsonData,false,null,false);
		if(appConstants.publicJsonData.combo.siteCombo!=undefined)
		{
			Ext.getCmp('er_site').show();
			this.loadComboField('er_site','siteCombo','siteComboLabel','selectedSiteCombo',appConstants.publicJsonData,false,null,true);
		}
		this.loadComboField('er_compType','compTypeCombo','compTypeComboLabel','selectedCompTypeCombo',appConstants.publicJsonData,false,null,true);
		this.loadComboField('er_component','componentCombo','componentLabel','componentSelected',appConstants.publicJsonData,false,null,true);
	},
	loadSettings:function()
	{
		var hiddenFields=appConstants.publicJsonData.hiddenFields;
		var FavoriteId =hiddenFields["FavoriteId"];
		if(!Ext.isEmpty(FavoriteId)){
			Ext.getCmp('reportGeneration').setDisabled(true);
		}
		Ext.getCmp('moreOptionCloseId').show();
 		this.loadComboField('er_excwe','excludeWeekendsCombo','excludeWeekendsLabel','excludeWeekendsSelected',appConstants.publicJsonData,false,null,true);
		this.loadComboField('reportGeneration','reportGenerationCombo','reportGenerationLabel','reportGenerationSelected',appConstants.publicJsonData,false,null,true);
		
		var selectedFields=appConstants.publicJsonData.selectedFields;
		Ext.getCmp('timefrom').setValue(selectedFields.selectedTimeFrom);
 		Ext.getCmp('minfrom').setValue(selectedFields.selectedMinsFrom);
 		Ext.getCmp('timeto').setValue(selectedFields.selectedTimeTo);
 		Ext.getCmp('minto').setValue(selectedFields.selectedMinsTo);
		if(selectedFields.hasOwnProperty('reportNameSelected'))
 			Ext.getCmp('bgReportName').setValue(selectedFields.reportNameSelected);
		selectedFields =null;delete selectedFields;
	},
	showConfigDropdown:function()
	{
		Ext.widget('configform');
		isSettingsEnabled = true;
 		var thisController = this;
		Ext.get('closeSettings').on('click',function(){
			thisController.validateAndCloseSettings();
 		});
 	},
	validateAndCloseSettings:function()
	{
		if(this.validateSettings())
		{
			Ext.get('configMod').animate({duration: 500,to: {y: -500}});
			return true;
		}
		return false;
	},
	closeSettingAndSubmit:function()
	{
		if(this.validateAndCloseSettings())
		{
			this.showResult();
		}
	},
	loadComboField:function(comboId,comboProperty,comboLabelProperty,comboSelectedProperty,parentJsonProperty,isMultiSelect,multiSelectPaneId,isSetLabel)
	{
		 var component = Ext.ComponentManager.get(comboId);
 		 if(parentJsonProperty.combo.hasOwnProperty(comboProperty))
		 {
 				var rawData = parentJsonProperty.combo[comboProperty];
				component.getStore().clearFilter(true); 
 				component.getStore().loadRawData(rawData);
			 
				if(parentJsonProperty.selectedFields.hasOwnProperty(comboSelectedProperty))
				{
					component.setValue(parentJsonProperty.selectedFields[comboSelectedProperty]);
				}
 				else
				{
					component.setValue(rawData[0].valueField);
				}
				if (isSetLabel)
				{
					 if(parentJsonProperty.labelFields.hasOwnProperty(comboLabelProperty))
					 {
						if(!isMultiSelect)
							component.setFieldLabel(parentJsonProperty.labelFields[comboLabelProperty]);
 						else
							Ext.ComponentManager.get(multiSelectPaneId).setFieldLabel(parentJsonProperty.labelFields[comboLabelProperty]);
					 }
				}
				if(!isMultiSelect)
				{
					if(component.isHidden())
					component.show();
				}
				else
				{
					var m=Ext.ComponentManager.get(multiSelectPaneId);
					if(m.isHidden())
					m.show();
				}
 		 }
		 else
		 {
			if(!isMultiSelect)
			{
				if(!component.isHidden())
				component.hide();
			}
			else
			{
				var m=Ext.ComponentManager.get(multiSelectPaneId);
				if(!m.isHidden())
				m.hide();
			}
		 }
 	},
	loadTools : function()
	{
 		this.getNewUtilities().loadIcon(true, true, true, false, true, true, true, false, false, false, true);
		Ext.getCmp("favoriteTool").setDisabled(false);
		Ext.getCmp("scheduleTool").setDisabled(false);
		Ext.getCmp("csvTool").hide();
 	},
	toggleForm:function(obj)
	{
		Ext.getCmp('panelinsidetoggle').show();
		Ext.getCmp('panelinsidetoggle').setDisabled(false);
		var ornt = Ext.getCmp('mainform');
		if (ornt.isHidden())
		{
			ornt.show();
			Ext.getCmp('selectionDetails').hide();
		}
		else
		{
			ornt.hide();
			Ext.getCmp('selectionDetails').show();
		}
	},
	getMessageBox:function(title,msg)
	{
	  	 Ext.MessageBox.show({
			title: title,
			msg: msg,
			buttons: Ext.MessageBox.OK,
			icon: Ext.MessageBox.WARNING
		});
		return false;
	},
	validateMainForm:function(flag)
	{
		var hiddenFields=appConstants.publicJsonData.hiddenFields;
 		var MaxDaysInMonth = hiddenFields.getMaxDaysInMonth;
		var er_usertimeline = hiddenFields.userTimeline;

		var er_timeline=Ext.getCmp('er_timeline').getValue();
		var stDate = Ext.getCmp('er_stdate').getValue();
		var enDate = Ext.getCmp('er_enddate').getValue();
		var startHour = Ext.getCmp('er_sthr').getValue();
		var endHour = Ext.getCmp('er_endhr').getValue();
		stDate.setHours(startHour);
		enDate.setHours(endHour);
		var reportgen = appConstants.publicJsonData.selectedFields.reportGenerationSelected;
		if (isSettingsEnabled)
		{
			reportgen = Ext.getCmp('reportGeneration').getValue();
		}
		if(er_usertimeline!=null && er_usertimeline != '-1')
		{
			var usertimelineValid = isUserTimelineLimitExceeded(er_usertimeline, MaxDaysInMonth,  stDate, enDate);
			if ( !usertimelineValid )
			{
				Ext.MessageBox.show({
				title: alert_text,
				msg:  _invalidUserTime,
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
				return false;
			}
		}
		obj=Ext.getCmp('er_option');
		if(obj.getValue()== '-1'){
			this.getMessageBox(alert_text,reportTypeMsg);
			return false;
		}
		obj=Ext.getCmp('er_site');
		if(obj.getValue()== '' ||(obj.getValue()== '-1' && !obj.isHidden())){
			this.getMessageBox(alert_text,pleaseChooseTxt+' '+obj.getFieldLabel());
			return false;
		}
		obj=Ext.getCmp('er_compType');
		if(obj.getValue()== '' ||(obj.getValue()== '-1' && !obj.isHidden())){
			this.getMessageBox(alert_text,pleaseChooseTxt+' '+obj.getFieldLabel());
			return false;
		}
		obj=Ext.getCmp('er_component');
		if(obj.getValue()== '' ||(obj.getValue()== '-1' && !obj.isHidden()))
		{
			this.getMessageBox(alert_text,componentMsg);
			return false;
		}
		if (reportgen == 'foreground')
		{
			if(flag)
			{
				var limitforbg = hiddenFields.limitforbg;
				if(!Ext.isEmpty(limitforbg))
				{
					if(!checkTimeLineForBgLimit(limitforbg,MaxDaysInMonth,stDate,enDate))
					{
						Ext.MessageBox.confirm('Confirm', appConstants.forGrdReportConfirmMsg,this.showConfirmResult,this);
						return false;
					}
				}
			}
		}
		else
		{
			var reportName = Ext.getCmp('bgReportName').getValue();
			if(!validateTextBoxWithSpecialChars(reportName,'Attachment',true))
				return false;
		}
		return true;
	},
	validateMainFormForFavAndSch:function()
	{
		var hiddenFields=appConstants.publicJsonData.hiddenFields;
 		var MaxDaysInMonth = hiddenFields.getMaxDaysInMonth;
		var er_usertimeline = hiddenFields.userTimeline;

		var er_timeline=Ext.getCmp('er_timeline').getValue();
		var stDate = Ext.getCmp('er_stdate').getValue();
		var enDate = Ext.getCmp('er_enddate').getValue();
		var startHour = Ext.getCmp('er_sthr').getValue();
		var endHour = Ext.getCmp('er_endhr').getValue();
		stDate.setHours(startHour);
		enDate.setHours(endHour);
		var reportgen = appConstants.publicJsonData.selectedFields.reportGenerationSelected;
		if (isSettingsEnabled)
		{
			reportgen = Ext.getCmp('reportGeneration').getValue();
		}
		if(er_usertimeline!=null && er_usertimeline != '-1')
		{
			var usertimelineValid = isUserTimelineLimitExceeded(er_usertimeline, MaxDaysInMonth,  stDate, enDate);
			if ( !usertimelineValid )
			{
				Ext.MessageBox.show({
					title: alert_text,
					msg:  _invalidUserTime,
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
				});
				return false;
			}
		}
		var obj=Ext.getCmp('select_farm');
		if(obj.getValue()== '-1'){
				this.getMessageBox(alert_text,obj.getStore().getAt(0).get('displayField'));
				return false;
		}
		obj=Ext.getCmp('er_compType');
		if(obj.getValue()== '-1'){
				this.getMessageBox(alert_text,compTypeMsg);
				return false;
		}
		obj=Ext.getCmp('er_component');
		if(obj.getValue()== '' ||(obj.getValue()== '-1' && !obj.isHidden()))
		{
				this.getMessageBox(alert_text,componentMsg);
				return false;
		}
		var objAry = obj.getValue();
		return true;
	},
	showConfirmResult : function(btn)
	{
		var reportName=appConstants.reportName;
		var extraParam='&er_reportname='+reportName;
		var infoName=appConstants.infoName;
		if(infoName!= undefined && infoName!= 'null')
		{
			extraParam+='&er_info_list='+infoName+'&isFromDrillDown=yes';
		}
		if(reportName != undefined && reportName == 'jvm_cpu'){
			this.foregroundControllerUrl='../servlet/com.eg.ErJvmCpuC';
		}
		if(reportName != undefined && reportName == 'jvm_garbage'){
			this.foregroundControllerUrl='../servlet/com.eg.ErJvmGarbageC';
		}
		if(reportName != undefined && reportName == 'jvm_thrd'){
			this.foregroundControllerUrl='../servlet/com.eg.ErJvmThreadC';
		}
		if(btn=="yes")
		{
			var getButtonObj = Ext.getCmp('submit');
			getButtonObj.setDisabled(false);
			if(isSettingsEnabled)
				Ext.get('configMod').animate({duration: 500,to: {y: -500}});
				this.getAjaxDataForSubmit(this.foregroundControllerUrl,'isSubmit=true&'+this.getQueryString(true,true,true)+extraParam);
		}			
		else
		{
			if (!isSettingsEnabled)
			{
				this.getReporterSettings().down('button').fireHandler();
			}
			var reportGenType=Ext.getCmp('reportGeneration');
			var bgreportNameObj=Ext.getCmp('bgReportName');
			reportGenType.setValue('background');
			bgreportNameObj.setValue("");
			bgreportNameObj.show();
			bgreportNameObj.focus(false, 1000);
			validateTextBoxWithSpecialChars(bgreportNameObj.getValue(),'Attachment',true);
			return false;
		}
	},
	validateSettings :function()
	{
		var isSettingsOk = true;
		var reportgen=Ext.getCmp('reportGeneration').getValue();
		var timefrom = Ext.getCmp('timefrom').getValue();
		var minfrom = Ext.getCmp('minfrom').getValue();
		var timeto = Ext.getCmp('timeto').getValue();
		var minto = Ext.getCmp('minto').getValue();
		if(!checkTimePeriod(timefrom,minfrom,timeto,minto)){
			isSettingsOk = false;
		}
		if ( reportgen!=null && (reportgen == 'background' || reportgen == 'background-xls' || reportgen == 'background-csv' )){
			var reportName = Ext.getCmp('bgReportName').getValue();
			if(!validateTextBoxWithSpecialChars(reportName,'Attachment',true))
			isSettingsOk = false;
		}
		return isSettingsOk;
	},
	loadGarbageResultData:function()
	{
		var resultContainerObj=Ext.getCmp('resultContainer');
		resultContainerObj.removeAll();
		resultContainerObj.show();
		var summaryAry  = appConstants.publicJsonData.summaryAry;
		var recommentationTitle = appConstants.publicJsonData.recommentationTitle;
		var deductionsTitle = appConstants.publicJsonData.deductionsTitle;
		var graphCount  = appConstants.publicJsonData.gc_graph_count;
		var gc_graph_info  = appConstants.publicJsonData.gc_graph_info;
		if(summaryAry != undefined && summaryAry.length>0)
		{
			var summaryTitleAry  = appConstants.publicJsonData.summaryTitleArr;
			
			var infoHtml = '<div><table align="center" style="width:100%; padding: 0 0 13px 0; "><tbody><tr>';
			var timeSpendHtml = '<div><table align="center" style="width:100%; padding: 0 0 13px 0;"><tbody><tr>';
			var slaHtml = '<div><table align="center" style="width:100%; padding: 0 0 13px 0;"><tbody><tr>';
			for(var index in summaryAry)
			{
				var summaryAryData = summaryAry[index];
				if(index==0)
				{
					infoHtml+='<td class="jvmRightBorder" style="padding: 0 0 0px 0; width: 33.3%;"><table align="center" style="width:100%;"><tr style="text-align: center;">';
					infoHtml+='<td class="newFont_bold15" style="font-size: 12px;">'+summaryAryData.name+'</td></tr><tr style="text-align: center;line-height:1.5;"><td style="font-weight: 500;font-size:26px;">'+summaryAryData.data+'</td>';
					infoHtml+='</tr></table></td>';
				}
				else if(index < summaryAry.length-1)
				{
					timeSpendHtml+='<td class="jvmRightBorder" style="padding: 0 0 0px 0;width: 33.3%;"><table align="center" style="width:100%;"><tr style="text-align: center;">';
					timeSpendHtml+='<td class="newFont_bold14" style="font-size: 12px;">'+summaryAryData.name+'</td></tr><tr style="text-align: center;line-height:1.5;"><td style="font-weight: 500;font-size:26px;">'+summaryAryData.data+'</td>';
					timeSpendHtml+='</tr></table></td>';
				}
				else
				{
					slaHtml+='<td class="jvmRightBorder" style="padding: 0 0 13px 0;width: 33.3%;"><table align="center" style="width:100%;"><tr style="text-align: center;">';
					slaHtml+='<td class="newFont_bold14" style="font-size: 12px;">'+summaryAryData.name+'</td></tr><tr style="text-align: center;line-height:1.5;"><td style="font-weight: 500;font-size:26px;">'+summaryAryData.data+'</td>';
					slaHtml+='</tr></table></td>';
				}
			}
			infoHtml+='</tr></tbody></table></div>'; 
			timeSpendHtml+='</tr></tbody></table></div>'; 
			slaHtml+='</tr></tbody></table></div>'; 


			resultContainerObj.add({
				xtype: 'panel',
				ui:'newGraphPanel',
				margin: '0 10 10 0',
				padding: '0 0 0 0',
				header: {
					style: (strSkin == "Light")? 'border-bottom: 1px solid #EBEBEB !important;margin: 0 10px 0 10px;padding: 4px 0px 5px 0px;':'border-bottom: 1px solid #5e5e5e !important;padding: padding: 4px 0px 5px 0px;margin: 0 10px 0 10px; '
				},
				title:overViewTxt,
				
				columnWidth:1.0,
				layout:
				{
					type:'hbox',
					align:'stretch'
				},
				flex:1,
				items:[
				{
					xtype:'container',
					cls:'dividerGradient',
					padding: '0 17 0 10',
					layout: {
						type: 'vbox',
						align: 'stretch'
					},
					flex: 1,
					items: [
					{
						xtype: 'panel',
						style: {
							'box-shadow': 'none'
						},
						title: '<div style="padding: 10px 0 5px 0;">'+summaryTitleAry[0]+'</div>',
						
						ui:'newGraphPanel',
						items:
						[{
							xtype:'container',
							html:infoHtml
						}]
					}
					]

					
				},
				{
					xtype:'container',
					cls:'dividerGradient',
					padding: '0 17 0 10',
					flex: 2,
					layout: {
						type: 'vbox',
						align: 'stretch'
					},
					items : [
						{
						xtype: 'panel',
						title: '<div style="padding: 10px 0 5px 0;">'+summaryTitleAry[1]+'</div>',
						style: {
							'box-shadow': 'none'
						},
						ui:'newGraphPanel',
						items:
						[{
							xtype:'container',
							html:timeSpendHtml
						}]
						}
					]
					
				},
				{
					xtype:'panel',
					padding: '0 0 0 10',
					title: '<div style=" padding: 10px 0 5px 0;">'+summaryTitleAry[2]+'</div>',
					style: {
							'box-shadow': 'none'
						},
					layout: {
						type: 'vbox',
						align: 'stretch'
					},
					ui:'newGraphPanel',
					flex: 1,
					items:
					[{
						xtype:'container',
						html:slaHtml
					}]
				}]
			});
		}
		//
		var dataInfoUrlFlag=false;
		var csvInfoUrlFlag=false;
		var drillDownUrlFlag=false;
		var recommadationFlag=false;
		var deductionsFlag=false;
		//
		if(graphCount != undefined)
		{
			for(var i=0;i<graphCount;i++)
			{
				var temp = 'gc_graph'+i;
				recommadationFlag=false;
				if(gc_graph_info != undefined && gc_graph_info != 'null')
				{
					temp = gc_graph_info;
					dataInfoUrlFlag=true;
					csvInfoUrlFlag=true;
					drillDownUrlFlag=true;
					recommadationFlag=true;
					deductionsFlag=true;
					this.disableToolsForDrilldown();
				}
				var heap_graph  = appConstants.publicJsonData[temp];
				var graphTitle=heap_graph['DataSet'][0].info;
				var gcCount  = heap_graph['DataSet'][0].gcCount;
				var letContainerValues=heap_graph['ShowLegendinTableFormatforUIData'];
				var tempDiv = '<div id="'+temp+'" style="height:350px"> </div>';
				var leftContainerHtml = '<div class="jvmListTimingBox" style="width:80px;  border-style: solid; margin-top: 20px; ">';
				leftContainerHtml+='<div class="jvmListTiming" style="text-align: center;height:75px;"><div style="font-weight: 500;font-size:18px;margin-top:20px">'+gcCount+'</div><div style="font-size: 12px;line-height:1.5;">'+collectionsTitle+'</div></div>';
				leftContainerHtml+='<div class="jvmListTiming" style="text-align: center;height:75px;"><div style="font-weight: 500;font-size:18px;margin-top:20px">'+ letContainerValues[2]+'</div><div style="font-size: 12px;line-height:1.5;">'+perTitle+'</div></div>';
				leftContainerHtml+='<div class="jvmListTiming" style="text-align: center;height:75px;"><div style="font-weight: 500;font-size:18px;margin-top:20px">'+ letContainerValues[3]+'</div><div style="font-size: 12px;line-height:1.5;">'+perTitle+'</div></div>';
				leftContainerHtml+='</div>';
				var recommendationsAry  = appConstants.publicJsonData['recommendationsAry'+i];
				var recommendationsHtml ='';
				var seperatorCls='jvmGraphSeperatorLineRight';
				if(recommendationsAry!=undefined && recommendationsAry.length>0)
				{
					if(recommendationsAry.length==1)
					{
						seperatorCls='';
					}
					recommendationsHtml = '<div style="padding:10px 0px 10px 10px" class="font_bold15 jvmNotes">' + recommentationTitle + '</div><div class="" style="margin:0px 0px 0px 0px; padding: 0 20px 0 0;" ><table  style="width: 100%;margin-bottom:10px; "><tbody>';
					for (var index = 0; index < recommendationsAry.length; index += 2)
					{
						var recommendationsAryObj = recommendationsAry[index];
						var recommendationsAryObj1 = recommendationsAry[index + 1];
						recommendationsHtml += '<tr style="padding-bottom:10px;">';
						if (recommendationsAryObj != undefined) {
							recommendationsHtml += '<td width="50%" class="jvmHeaptable"><table><tr><td width="10px" style="vertical-align:top;padding-top:7px;padding-left: 10px;"><div style="background-color:transparent;height:8px;width:8px;border-radius: 50%; border:2px solid  #707070;vertical-align: text-top;"></div></td><td style="line-height:1.5;">' + recommendationsAryObj + '</td></tr></table></td>';
						}
						if (recommendationsAryObj1 != undefined) {
							recommendationsHtml += '<td width="50%" class="jvmHeaptable"><table><tr><td width="10px" style="vertical-align:top;padding-top:7px;"><div style="background-color:transparent;height:8px;width:8px;border-radius: 50%; border:2px solid  #707070;vertical-align: text-top;"></div></td><td style="line-height:1.5;">' + recommendationsAryObj1 + '</td></tr></table></td>';
						} else {
							recommendationsHtml += '<td width="50%"></td>';
						}
						recommendationsHtml +='</tr>';
					}
					recommendationsHtml+='</tbody></table></div>';
				}
				else
				{
					recommadationFlag=true;
				}
				var deductionsAry  = appConstants.publicJsonData['deductionsAry'+i];
				var deductionsHtml = '';
				if(deductionsAry!=undefined && deductionsAry.length == 0)
				{
					deductionsAry.push("<div style='margin:0px 0px 6px 5px'><span class='newFont_normal13'>"+conclusionTxtGC+"</span></div>");
					deductionsTitle=conclusionTitle;
				}
				if(deductionsAry!=undefined && deductionsAry.length > 0)
				{
					deductionsHtml+='<div class="notes" style="width:100%;padding: 10px 25px 0px 10px;">';
					deductionsHtml+= '<div class="paperPin"></div>';
					deductionsHtml+='<div style="padding:0px 0px 10px 0px;color:#000;" class="font_bold15 ">'+deductionsTitle+'</div><div style="margin:0px 0px 0px 0px"><table width="100%"  style="width: 100%; " align="center"><tbody>';
					for(var index in deductionsAry)
					{
						var deductionsAryObj = deductionsAry[index];
						if(index==0)
							deductionsHtml+='<tr><td width="10px" style="padding-top:7px;vertical-align:top;"><div style="background-color:transparent;height:8px;width:8px;border-radius: 50%; border:2px solid  #707070;"></div><td class="font_normal12 "><td style="color:1a1a1a;">'+deductionsAryObj+'</td></tr>';
						else
							deductionsHtml+='<tr><td width="10px"><td class="font_normal12"><td><div style="margin:0px 0px 3px 20px;"color:1a1a1a;">'+deductionsAryObj+'</div></td></tr>';
					}
					deductionsHtml+='</tbody></table></div></div>';
				}
				//
				var csvUrl =  appConstants.publicJsonData.CSV_URL;
				var dataUrl =  appConstants.publicJsonData.DATA_URL;
				var imageDrillDownUrl = appConstants.publicJsonData.IMAGE_DRILL_DOWN_URL;
				//
				resultContainerObj.add({
					xtype:'panel',
					ui:'newGraphPanel',
					columnWidth:1.0,
					layout: {
						type: 'vbox',
						align: 'stretch'
					},
					title:'Time taken for Garbage Collection - '+graphTitle,
					header: {
						style: (strSkin == "Light")? 'border-bottom: 1px solid #EBEBEB !important;margin: 0 10px 0 10px;padding: 4px 0px 5px 0px;':'border-bottom: 1px solid #5e5e5e !important;padding: padding: 4px 0px 5px 0px;margin: 0 10px 0 10px; '
					},
					margin: '0 10 10 0',
					tools:[
						this.addToolBarItems([
							{
								xtype: 'button',
								cls:'iconData',
								style:{'border':'0px'},
								width:16,
								height:16,
								margin:'0 3 0 3',
								id:temp+'_data',
								hidden:dataInfoUrlFlag,
								handler:function(){
									loadDataWindowGC(dataUrl,this.id);
								}
							},
							{
								xtype: 'button',
								width:16,
								height:16,
								margin:'0 3 0 3',
								style:{'border':'0px'},
								cls: 'iconCsv',
								hidden:csvInfoUrlFlag,
								id:temp+'_csv',
								handler:function(){
									window.location=csvUrl+"&graphParam="+this.id;
								}
							},
							{
								xtype: 'button',
								width:16,
								height:16,
								margin:'0 0 0 3',
								style:{'border':'0px'},
								cls:'iconMaximize',
								id:temp+'_drill',
								hidden:drillDownUrlFlag,
								handler:function(){
									loadUrlInDrillDownGC(imageDrillDownUrl,this.id);
								}
							}
						])
					],
					items:
					[
						{
							xtype:'panel',
							columnWidth:1.0,
							layout:{
								type:'hbox',
								align:'stretch',
							},
								
							items:[
							{
								xtype:'panel',
								flex:1,
								items:[{
									xtype:'container',
									margin: '0 10 10 0',
									id:temp+'_GraphPanel',
									graphId:temp,
									graphData:heap_graph,
									html:tempDiv,
									listeners:
									{
										'boxready':function()
										{
											var lineChart = {};
											lineChart = jQuery.extend(true, {}, getHighChartsInstance_combined(this.graphId,"230","200"), lineChart);
											lineChart.setData(this.graphData,appConstants.currentDateFormat,'');
											lineChart.drawChart();
											if(document.getElementById(this.graphId+'_legendClose')){document.getElementById(this.graphId+'_legendClose').className="iconCloseCircle hideDiv";}
											if(document.getElementById(this.graphId+'_legendExpand')){document.getElementById(this.graphId+'_legendExpand').className="iconCloseCircle hideDiv";}
										}
									}
								}]
							},
							{
								xtype:'container',
								width:80,
								margin: '0 65 10 0', 
								html:leftContainerHtml
							}
							]
						},
						{
							xtype:'container',
							columnWidth:1.0,
							margin:'10 10 0 0',
							id:temp+'_legendPanel'
						},
						{
							xtype: 'container',
							margin:'10 10 0 10',
							hidden:recommadationFlag,
							cls: 'jvmObservPanelBox',
							items: [{
								xtype:'container',
								ui: 'newGraphPanel noShadow ',
								columnWidth: 1.0,
								layout: 'column',
								id:temp+'recommentationPanel1',
								cls: seperatorCls,
								html:recommendationsHtml
							}]
						},
						{
							xtype:'container',
							columnWidth:1.0,
							margin:'10 10 10 10',
							html:deductionsHtml
						}
					]
				});
			}
		}
	}
});


