Ext.define('JvmUptime.controller.JvmUptimeController', {
    extend: 'Ext.app.Controller',
    refs: [{
            selector: 'newUtilities',
            ref: 'newUtilities'
        },
        {
            selector: 'main',
            ref: 'main'
        },
        {
            selector: 'nomeasurepanel',
            ref: 'nomeasurepanel'
        },
        {
            selector: 'ReporterSettings',
            ref: 'ReporterSettings'
        }
    ],
    foregroundJspUrl: '/final/reporter/JvmUptimeReportJson.jsp',
    foregroundControllerUrl: '../servlet/com.eg.ErJvmUptimeC',
    backgroundControllerUrl: '../servlet/com.eg.ErStartBackGroundReportC',
    isNewFav: false,
    init: function() {
        this.control({
            'main': {
                'afterrender': this.boxready
            },
            'mainform': {
                'afterrender': this.loadForm
            },
            'newUtilities': {
                'render': this.loadTools
            },
            'newUtilities > #printTool > button': {
                'click': this.printFile
            },
            'newUtilities > #saveTool > button': {
                'click': this.saveReportAsPDF
            },
            'newUtilities > #mailTool > button': {
                'click': this.sendMail
            },
            'newUtilities > #favoriteTool > button': {
                'click': this.saveFavorite
            },
            'newUtilities > #scheduleTool > button': {
                'click': this.saveSchedule
            },
            'egcomponent button[id="compExpand"]': {
                'click': this.expandMe
            },
            'egcomponent trigger[id="compSearch"]': {
                'change': this.filterMultiselect
            },
            'mainform combo[id="er_option"]': {
                'select': this.onSelectAnalysisBy
            },
            'mainform combo[id="er_site"]': {
                'select': this.onSelectSiteBy
            },
            'mainform combo[id="er_compType"]': {
                'select': this.onSelectCompTypeBy
            },
            'jvmuptimesettings': {
                'afterrender': this.loadSettings
            },
            'jvmuptimesettings combo[name="reportGeneration"]': {
                'select': this.onChangeReportGeneration
            },
            'jvmuptimesettings button[id="moreOptionCloseId"]': {
                'click': this.validateAndCloseSettings
            },
            'jvmuptimesettings button[id="submitViaSetting"]': {
                'click': this.closeSettingAndSubmit
            },
            'jvmuptimeform button[name="submit"]': {
                'click': this.submitReoprt
            },
            'mainform button[id="panelinsidetoggle"]': {
                'click': this.toggleForm
            },
        });
    },
    expandMe: function(btn) {
        if (Ext.isEmpty(appConstants.erUtils))
            appConstants.erUtils = Ext.widget("erutils");

        if (btn.getId() == 'compExpand') {
            appConstants.erUtils.expandMultiComboButton(Ext.getCmp('er_component'), componentsTxt, btn);
        }
    },
    typewatch: function(field, event) {
        this.searchTask.delay(500);
    },
    goTo: function(obj) {
        if (appConstants.frmSchModify == "Yes")
            this.saveSchedule(obj);
        else
            this.saveFavorite(obj);
    },
    saveSchedule: function(obj) {
        if (this.validateMainForm(false) && Ext.getCmp('er_timeline').getValue() == 'Any') {
            Ext.MessageBox.show({
                title: alert_text,
                msg: 'Chosen timeline not allowed',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.WARNING
            });
            return false;
        }
        var reportName = appConstants.reportName;
        var target = "/final/reporter/ErSaveSchedule.jsp?isSubmit=true&" + this.getQueryString(true, true, true) + "&option=data" + "&er_reportname=" + reportName+"&com.eg.CSRF_NONCE="+csrfToken;
        if (obj.getId() == 'save') {
            if (target != undefined && target.indexOf("schedule_id") == -1)
                target += '&schedule_id=' + appConstants.schedule_id;
            //document.location=target+'&showSchWindow=no';
            target += '&showSchWindow=no';
            var urlNw = target.substr(0, target.indexOf("?"));
            var queryString = target.substr(target.indexOf("?") + 1, target.length - 1);
            var formSave = Ext.create('Ext.form.Panel');
            formSave.submit({
                url: urlNw,
                params: queryString,
                standardSubmit: true,
                method: 'POST'
            });
        } else
            parent.scheduleWindowFn(target); //this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
    },
    saveFavorite: function(obj) {
        /* if(this.validateMainForm(false) && Ext.getCmp('er_timeline').getValue() == 'Any'){
			Ext.MessageBox.show({
				title: alert_text,
				msg: invalidTimelineTxt,
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
			});
			return false;
 		} */
        var target = "";

        //&FavoriteId="+appConstants.publicjsonData.hiddenFields["favorite_id"];
        if (!this.validateMainForm(false)) {
            return false;
        }
        if (obj.getId() == 'save') {
            this.isNewFav = false;
            target = "/final/reporter/ErSaveFavorite.jsp?isSubmit=true&" + this.getQueryString(true, true, true) + "&er_view=GRAPH&cmd=client&fromFavoriteModify=Yes" + "&er_RmDispName=" + appConstants.er_RmDispName+"&com.eg.CSRF_NONCE="+csrfToken;
            if (target != undefined && target.indexOf("FavoriteId") == -1)
                target += '&FavoriteId=' + appConstants.favorite_id;
            //document.location=target+'&showWindow=no';
            target += '&showSchWindow=no';
            var urlNw = target.substr(0, target.indexOf("?"));
            var queryString = target.substr(target.indexOf("?") + 1, target.length - 1);
            var formSave = Ext.create('Ext.form.Panel');
            formSave.submit({
                url: urlNw,
                params: queryString,
                standardSubmit: true,
                method: 'POST'
            });
        } else {
            this.isNewFav = true;
            target = "../servlet/com.eg.ErFavoriteC?isSubmit=true&" + this.getQueryString(true, true, true) + "&er_view=GRAPH&cmd=client" + "&er_RmDispName=" + appConstants.er_RmDispName+"&com.eg.CSRF_NONCE="+csrfToken;
            parent.favouriteWindowFn(target); //this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
        }
    },
    saveReportAsPDF: function() {
        var s_qryString = "../reporter/ErHtmlToSavePdf.jsp?" + this.getQueryString(true, true, true);
        s_qryString += "&printGraph=yes&savePrint=yes&er_view=PRINT";
        if (Ext.isEmpty(appConstants.erUtils))
            appConstants.erUtils = Ext.widget("erutils");
        appConstants.erUtils.savePDF(s_qryString);
    },
    bookletQuery: function(obj) {
        var s_qryString = appConstants.publicJsonData.urlFields.saveQueryString;
        return s_qryString;
    },
    bookletScheduleQuery: function(obj) {
        var bookletquery = "isSubmit=true&" + this.getQueryString(true, true, true) + "&option=data";
        return bookletquery;
    },
    bookletPreview: function() {
        this.printFile();
    },
    printFile: function() {
        var s_qryString = "/final/reporter/JvmUptimeReportPrint.jsp?" + this.getQueryString(true, true, true) + "&er_view=PRINT&pdfPrint=yes";
        parent.printWindowFn(s_qryString); //this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
    },
    sendMail: function() {
        Ext.widget('sendmail').show();
    },
    loadReportData: function() {
        var backGroundPanel = Ext.getCmp('backGroundPanel');
        var reportGeneration = appConstants.publicJsonData.selectedFields.reportGenerationSelected;
        this.hideResults();

        var tmpStartDate = Ext.getCmp('er_stdate').getValue();
        tmpStartDate.setHours(Ext.getCmp('er_sthr').getValue());
        var tmpEndDate = Ext.getCmp('er_enddate').getValue();
        tmpEndDate.setHours(Ext.getCmp('er_endhr').getValue());
        var result = checkDateTime(tmpStartDate, tmpEndDate);
        if (!result) {
            return;
        }
        if (reportGeneration == 'foreground') {
            if (appConstants.publicJsonData.hasOwnProperty('NO_DATA') && appConstants.fromRunBtn == 'yes') {
                this.disableTools();
                this.getNomeasurepanel().show();
            } else {
                Ext.getCmp('selectionDetails').setSelectionDetailsData(appConstants.publicJsonData.selectionDetails);
                this.enableTools();
                this.loadResultData();
            } //end of else
        } else if (reportGeneration == 'background') {
            var backgroundReportStatus = appConstants.publicJsonData.labelFields.bgStatus;
            if (backgroundReportStatus == 'success') {
                var bgroundResponseTxt = appConstants.publicJsonData.labelFields.bgResponseText;
                var backgroundAnchor = appConstants.publicJsonData.labelFields.bgAnchor;
                var bgroundReportsURL = appConstants.publicJsonData.urlFields.bgUrl;
                var sub = backgroundAnchor.slice(0, -3);
                //backGroundPanel.update('<center><div style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:480px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconSuccess"></div><div style="margin-top:20px"><b>'+bgroundResponseTxt+'</b></br><a class="backgroundMsgLink" href="'+bgroundReportsURL+'">'+sub+'</a></div></div></center>');

                backGroundPanel.update('<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconInformation"></div></td><td><div style="line-height:1.5em" class="font_bold11">' + bgroundResponseTxt + '.</br>' + '<a class="backgroundMsgLink" href=' + bgroundReportsURL + '>' + backgroundAnchor + '</a></div></td></tr></table></td></tr></table>');
            } else if (backgroundReportStatus == 'duplicate') {
                var bgroundResponseTxt = appConstants.publicJsonData.labelFields.bgResponseText;
                var backgroundAnchor = appConstants.publicJsonData.labelFields.bgAnchor;
                var bgroundReportsURL = appConstants.publicJsonData.urlFields.bgUrl;
                var sub = backgroundAnchor.slice(0, -3);

                backGroundPanel.update('<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconExclamation"></div></td><td><div style="line-height:1.5em" class="font_bold11">' + bgroundResponseTxt + '.</br>' + '<a class="backgroundMsgLink" href=' + bgroundReportsURL + '>' + backgroundAnchor + '</a></div></td></tr></table></td></tr></table>');
            } else {

                backGroundPanel.update('<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconInformation"></div></td><td><div style="line-height:1.5em" class="font_bold11">Error In BackGround Generation</a></div></td></tr></table></td></tr></table>');
            }
            backGroundPanel.show();
        } else {
            console.log('No data found for report generation in json');
        }
        keepResult = false;
    },
    loadResultData: function() {
        var resultContainerObj = Ext.getCmp('resultContainer');
        resultContainerObj.removeAll();
        resultContainerObj.show();
        var summaryAry = appConstants.publicJsonData.summaryAry;
        var barChartObj = appConstants.publicJsonData.barChartObj;
        var ObservationTitle = appConstants.publicJsonData.ObservationTitle;
        var recommentationTitle = appConstants.publicJsonData.recommentationTitle;
        var observationAry = appConstants.publicJsonData.observationAry;
        var downTimeAry = appConstants.publicJsonData.downTimeAry;
        var recommendationsAry = appConstants.publicJsonData.recommendationsAry;
        var downTimeAryTable = appConstants.publicJsonData.downTimeAryTable;
        var downTimeAryTableHeader = appConstants.publicJsonData.downTimeAryTableHeader;
        var downtimeTableHeaderAry = appConstants.publicJsonData.downtimeTableHeaderAry;
        var summaryHtml = '<table align="center" style="margin:0px;width:100%;height:100%;"><tr>';
        for (var index in summaryAry) {
            var summaryAryData = summaryAry[index];
            summaryHtml += '<td width="25%" class="jvmRightBorder" >';
            summaryHtml += '<table  width="100%" align="center" cellspacing="0" cellpadding="0" border="0" Style="margin:auto auto;"><tr ><td colspan="1" style="padding: 9px 0 0 0;" rowspan="1"><table align="center"><tr><td align="right" style="vertical-align:top; padding-right:5px"><div class="' + summaryAryData.iconCls + '"></div></td><td class="newFont_bold28"  style="vertical-align:top;line-height: 1;">' + summaryAryData.data + '</td>';
			if(index!=summaryAry.length-1)
			{
				summaryHtml += '<td style="vertical-align:top;line-height:1.5;" class="newFont_bold20">%</td>';
			}
            summaryHtml += '</tr></table></td></tr><tr style="text-align: center;"  style="vertical-align:top;" ><td colspan="1" rowspan="1" style="padding: 0 0 13px 0;"class="newFont_bold13">' + summaryAryData.name + '</td></tr></table>';
            summaryHtml += '</td>';
        }
        summaryHtml += '</tr></table>';

        resultContainerObj.add({
            xtype: 'panel',
            ui: 'newGraphPanel',
            header: true,
            title: overViewTxt,
			
            layout: {
                type: 'vbox',
                align: 'stretch'
            },
            height: 140,
            flex: 1,
            padding: '0 0 0 0',
            margin: '0 10 10 0',
            items: [{
                xtype: 'container',
                flex: 1,
				 margin: '0 10 20 0',
                padding: '10 0 0 0',
               
				 html: summaryHtml,
               
            }]


        });
        resultContainerObj.add();
        var observationHtml = '';
        var seperatorCls='jvmGraphSeperatorLineRight';
        if (observationAry != undefined && observationAry.length > 0) {
            observationHtml = '<div style="padding:10px 0px 10px 0px" class="font_bold15">' + ObservationTitle + '</div><div class="" style="margin:0px 0px 0px 0px; padding: 0 20px 0 0;" ><table  style="width: 100%;margin-bottom:10px; "><tbody>';
        if(observationAry.length==1)
        {
          seperatorCls='';
        }
            for (var index = 0; index < observationAry.length; index += 2) {
                var observationAryObj = observationAry[index];
                var observationAryObj1 = observationAry[index + 1];
                observationHtml += '<tr style="padding-bottom:10px;">';
                if (observationAryObj != undefined) {
                    observationHtml += '<td width="50%" class="jvmHeaptable"><table><tr><td width="10px" style="vertical-align:top;padding-top:7px;"><div style="background-color:transparent;height:8px;width:8px;border-radius: 50%; border:2px solid  #707070;vertical-align: text-top;"></div></td><td style="line-height:1.5;">' + observationAryObj + '</td></tr></table></td>';
                }
                if (observationAryObj1 != undefined) {
                    observationHtml += '<td width="50%" class="jvmHeaptable"><table><tr><td width="10px" style="vertical-align:top;padding-top:7px;"><div style="background-color:transparent;height:8px;width:8px;border-radius: 50%; border:2px solid  #707070;vertical-align: text-top;"></div></td><td style="line-height:1.5;">' + observationAryObj1 + '</td></tr></table></td>';
                } else {
                    observationHtml += '<td width="50%"></td>';
                }
                observationHtml += '</tr>';
            }
            observationHtml += '</tbody></table></div></td>';
        }
        //
        var downTimeHtml = '';
        var content;
        var observationColWidth = 1;
        if (downTimeAryTable != undefined && downTimeAryTable.length > 0) {
            content = '<div style="font-size: 15px;font-weight: 500;margin: 0px 0px 10px 10px;">' + downTimeAryTableHeader + '</div>';
            content += '<div class="newTable" id="tableId" style="margin: 0px 0px 0px 10px;flex:1;">';
            content += '<table cellpadding="0px" cellspacing="0px" style="width:100%">';
            content += '<thead>';
            content += '<tr>';
            for (var index in downtimeTableHeaderAry) {
                if (index == 0) {
                    content += '<th style="text-align:center;">' + downtimeTableHeaderAry[index] + '</th>';
                } else {
                    content += '<th style="text-align:left;">' + downtimeTableHeaderAry[index] + '</th>';
                }
            }
            content += '</tr>';
            content += '</thead>';
            content += '<tbody>';
            var tempArr = [];
            for (var index in downTimeAryTable) {
                var outliersAryObj = downTimeAryTable[index];
                content += '<tr>';
                content += '<td align="center"><div class="' + outliersAryObj.type + '" title="' + outliersAryObj.tooltip + '"></td>';
                content += '<td align="left">' + outliersAryObj.shutDate + '</td>';
                content += '<td align="left">' + outliersAryObj.rebootDate + '</td>';
                content += '<td align="left">' + outliersAryObj.duration + '</td>';
                content += '</tr>';
            }
            content += '</tbody></table></div>';
            downTimeHtml += content;
            observationColWidth = 0.5;
        }
        //
        var recommendationsHtml = '';
	if (recommendationsAry != undefined && recommendationsAry.length == 0)
	{
		recommendationsAry.push("<div style='margin:0px 0px 6px 5px'><span class='newFont_normal13'>"+conclusionTxt+"</span></div>");
		recommentationTitle=conclusionTitle;
	}
        if (recommendationsAry != undefined && recommendationsAry.length > 0) {
            recommendationsHtml += '<div class="notes" style="width:100%; padding: 10px 25px 0px 10px;" >';
            recommendationsHtml += '<div class="paperPin"></div>';
            recommendationsHtml += '<div style="padding:0px 0px 10px 0px;color:#000;" class="font_bold15 ">' + recommentationTitle + '</div><div style="margin:0px 0px 0px 0px"><table width="100%"  style="width: 100%;" align="center" class="font_normal12 jvmNotes"><tbody>';
            for (var index in recommendationsAry) {
                var recommendationsAryObj = recommendationsAry[index];
                recommendationsHtml += '<tr><td width="10px" style="padding-top:7px;vertical-align:top;"><div style="background-color:transparent;height:8px;width:8px;border-radius: 50%; border:2px solid #707070;"></div></td><td style="padding: 0 0 10px 0;color:#1a1a1a;line-height:1.5">' + recommendationsAryObj + '</td></tr>'
            }
            recommendationsHtml += '</tbody></table></div></div>';
        }
		if(barChartObj!=undefined)
		{
			resultContainerObj.add({
				xtype: 'container',
				ui: 'newContainer',
				margin: '0 12 10 0',
				padding: 0,
				layout: {
					type: 'vbox',
					align: 'stretch'
				},
				items: [{
						xtype: 'container',
						margin: '0 10 0 0',
						columnWidth: 1.0,
						items: [{
								xtype: 'panel',
								ui: 'newGraphPanel noShadow',
								height: 340,
								flex: 1,
								columnWidth: 1.0,
								margin: '0 0 0 0',
								padding: '0 0 0 5',
								bodyPadding: '0 0 0px 0',
								title: barChartObj.chartTitle,
								items: [{
										xtype: 'container',
										flex: 1,
										margin: 0,
										padding: 0,
										html: '<div id="graphPanelId" ></div>',
										listeners: {
											'boxready': function() {
												var jvmBarChart = {};
												jvmBarChart = jQuery.extend(true, {}, getHighChartsBarInstance('graphPanelId', barChartObj.chartHeight, barChartObj.chartWidth), jvmBarChart);
												jvmBarChart.setData(barChartObj, '<%=currentDateFormat%>', '');
												jvmBarChart.drawChart();
											}
										}
									},

								]
							},

						]
					},

					{
						xtype: 'container',
						margin: '0 10 0 0',
						padding: '0 0 10 0',
						columnWidth: 1,
						html: downTimeHtml
					},

					{
						xtype: 'container',
						padding: '0 10 0 10',
						margin: '0 10 10 10',
						cls: 'jvmObservPanelBox',
						items: [{
								xtype: 'container',
								ui: 'newGraphPanel noShadow ',

								id: 'observationPanelId',
								margin: '0 0 0 0',
								bodyPadding: '10px 0px 0px 0px',
								columnWidth: 1.0,
								layout: 'column',
								title: ObservationTitle,
								items: [,
									{
										xtype: 'container',
										//columnWidth:observationColWidth,
										columnWidth: 1.0,
										padding: 0,
										cls: seperatorCls,
										margin: '0 0 0 0',
										html: observationHtml
									}
								]
							}

						]
					}

				]
			});
		}
		if (recommendationsAry != undefined && recommendationsAry.length > 0) 
		{
			resultContainerObj.add({
				xtype: 'panel',
				ui: 'newGraphPanel ',
				padding: 0,
				margin: '0 10 3 0',
				columnWidth: 1.0,
				items: [{
						xtype: 'container',
						margin: 10,
						columnWidth: 1.0,
						html: recommendationsHtml
					}

				]

			});
		}
    },
    submitReoprt: function(obj) {
        appConstants.fromRunBtn = 'yes';
        this.showResult(obj)
    },
    showResult: function(obj) {
        var reportGeneration;
        if (isSettingsEnabled)
            reportGeneration = Ext.getCmp('reportGeneration').getValue();
        else
            reportGeneration = appConstants.publicJsonData.selectedFields.reportGenerationSelected;
        if (reportGeneration == 'foreground' && this.validateMainForm(true)) {
            this.getAjaxDataForSubmit(this.foregroundControllerUrl, 'isSubmit=true&' + this.getQueryString(true, true, true));
        } else if (reportGeneration == 'background-csv' && this.validateMainForm(true)) {
            this.getAjaxDataForSubmit("../servlet/com.eg.ErStartBackGroundReportC?isSubmit=true&SaveFormat=CSV&isBackgroundCSV=Yes", this.getQueryString(true, true, true));
        } else if (reportGeneration == 'background-xls' && this.validateMainForm(true)) {
            this.getAjaxDataForSubmit("../servlet/com.eg.ErStartBackGroundReportC?isSubmit=true&SaveFormat=XLSX", this.getQueryString(true, true, true));
        } else if (reportGeneration == 'background' && this.validateMainForm(true)) {
            this.getAjaxDataForSubmit(this.backgroundControllerUrl, "isSubmit=true&" + this.getQueryString(true, true, true));
        }
    },
   /* onWeekendChange: function(obj) {
        var excludeDaysObj = Ext.getCmp('excludeDays');
        if (obj.getValue() == 'Yes') {
            excludeDaysObj.show();
            excludeDaysObj.update(appConstants.publicJsonData.labelFields.excludeDaysLabel);
        } else
            excludeDaysObj.hide();
    },*/
    disableTools: function() {
        Ext.getCmp("saveTool").setDisabled(true);
        Ext.getCmp("bookletTool").setDisabled(true);
        Ext.getCmp("printTool").setDisabled(true);
        Ext.getCmp("mailTool").setDisabled(true);
    },
    enableTools: function() {
        Ext.getCmp("saveTool").setDisabled(false);
        Ext.getCmp("bookletTool").setDisabled(false);
        Ext.getCmp("printTool").setDisabled(false);
        Ext.getCmp("mailTool").setDisabled(false);
    },
    hideResults: function() {
        Ext.getCmp('resultContainer').hide();
        Ext.getCmp('backGroundPanel').hide();
        this.getNomeasurepanel().hide();
    },

    onSelectAnalysisBy: function(obj) {
        var er_option = obj.getValue();
        var params = 'er_option=' + er_option;
        var me = this;
        initLdgMask.show();
        Ext.Ajax.request({
            url: me.foregroundJspUrl,
            params: params,
            scope: this,
            success: function(response) {
                initLdgMask.hide();
                me.hideResults();
                appConstants.publicJsonData = Ext.decode(response.responseText);
                if (appConstants.publicJsonData.combo.siteCombo != undefined) {
                    Ext.getCmp('er_site').show();
                    me.loadComboField('er_site', 'siteCombo', 'siteComboLabel', 'selectedSiteCombo', appConstants.publicJsonData, false, null, true);
                } else {
                    Ext.getCmp('er_site').hide();
                }
                me.loadComboField('er_compType', 'compTypeCombo', 'compTypeComboLabel', 'selectedCompTypeCombo', appConstants.publicJsonData, false, null, true);
                this.loadComboField('er_component', 'componentCombo', 'componentLabel', 'componentSelected', appConstants.publicJsonData, false, null, true);

            }
        });
    },
    onSelectSiteBy: function(obj) {
        var me = this
        var er_site = obj.getValue();
        var params = 'er_option=' + Ext.getCmp('er_option').getValue();
        params += '&er_site=' + er_site;
        initLdgMask.show();
        Ext.Ajax.request({
            url: me.foregroundJspUrl,
            params: params,
            scope: this,
            success: function(response) {
                initLdgMask.hide();
                me.hideResults();
                appConstants.publicJsonData = Ext.decode(response.responseText);
                me.loadComboField('er_compType', 'compTypeCombo', 'compTypeComboLabel', 'selectedCompTypeCombo', appConstants.publicJsonData, false, null, true);
                this.loadComboField('er_component', 'componentCombo', 'componentLabel', 'componentSelected', appConstants.publicJsonData, false, null, true);

            }
        });
    },
    onSelectCompTypeBy: function(obj) {
        var er_compType = obj.getValue();
        var params = 'er_compType=' + er_compType;
        params += '&er_site=' + Ext.getCmp('er_site').getValue();
        params += '&er_option=' + Ext.getCmp('er_option').getValue();
        var me = this;
        initLdgMask.show();
        Ext.Ajax.request({
            url: me.foregroundJspUrl,
            params: params,
            scope: this,
            success: function(response) {
                initLdgMask.hide();
                me.hideResults();
                appConstants.publicJsonData = Ext.decode(response.responseText);
                this.loadComboField('er_component', 'componentCombo', 'componentLabel', 'componentSelected', appConstants.publicJsonData, false, null, true);

            }
        });
    },
    onChangeReportGeneration: function(obj) {
        this.hideResults();
        this.disableTools();
        Ext.getCmp('submitViaSetting').show();
        Ext.getCmp('moreOptionCloseId').hide();
        if (obj.getValue() == 'background') {
            Ext.getCmp('bgReportName').setValue("");
            Ext.getCmp('bgReportName').show();
        } else if (obj.getValue() == 'background-csv') {
            Ext.getCmp('bgReportName').setValue("");
            Ext.getCmp('bgReportName').show();
        } else {
            Ext.getCmp('submitViaSetting').hide();
            Ext.getCmp('moreOptionCloseId').show();
            Ext.getCmp('bgReportName').hide();
        }
    },
    getAjaxData: function(url, query) {
        Ext.Ajax.request({
            url: url,
            params: query,
            async: false,
            scope: this,
            success: function(response) {
                appConstants.publicJsonData = Ext.decode(response.responseText);
            }
        });
    },
    getAjaxDataForSubmit: function(url, query) {
        var me = this;
        initLdgMask.show();
        Ext.Ajax.request({
            url: url,
            params: query,
            scope: this,
            success: function(response) {
                initLdgMask.hide();
                appConstants.publicJsonData = Ext.decode(response.responseText);
                me.loadReportData();
                appConstants.fromRunBtn = 'no';
            }
        });
    },
    getQueryString: function(needFilter, isOthers, isSettings) {
        var queryString;
        var timefrom, minfrom, timeto, minto, er_excwe, reportGeneration, bg_reportname;

        if (isSettingsEnabled) {
            timefrom = Ext.getCmp('timefrom').getValue();
            minfrom = Ext.getCmp('minfrom').getValue();
            timeto = Ext.getCmp('timeto').getValue();
            minto = Ext.getCmp('minto').getValue();
            er_excwe = Ext.getCmp('er_excwe').getValue();
            reportGeneration = Ext.getCmp('reportGeneration').getValue();
            bg_reportname = Ext.getCmp('bgReportName').getValue();
        } else {
            var selectedFields = appConstants.publicJsonData.selectedFields;
            timefrom = selectedFields.selectedTimeFrom;
            minfrom = selectedFields.selectedMinsFrom;
            timeto = selectedFields.selectedTimeTo;
            minto = selectedFields.selectedMinsTo;
            er_excwe = selectedFields.excludeWeekendsSelected;
            reportGeneration = selectedFields.reportGenerationSelected;
            bg_reportname = selectedFields.reportNameSelected;
            //queryArray=selectedFields.userSelected;
        }
        var er_option = Ext.getCmp('er_option').getValue();
        queryString = 'er_type=Yes';
        queryString += '&er_option=' + er_option;
        if (er_option != undefined && er_option != 'Component') {
            queryString += '&er_site=' + Ext.getCmp('er_site').getValue();
        }
        queryString += '&er_compType=' + Ext.getCmp('er_compType').getValue();
        var queryArray = Ext.getCmp('er_component').getValue();
        queryString += "&er_component=" + queryArray;
        if (isSettings) {
            //var startDateConverted = Ext.Date.dateFormat(Ext.getCmp('er_stdate').getValue(), mgrDateFormat);
            //var endDateConverted = Ext.Date.dateFormat(Ext.getCmp('er_enddate').getValue(), mgrDateFormat);
            var stHr = Ext.getCmp('er_sthr').dataArray;
            var startDateConverted = Ext.getCmp('er_stdate').dataArray;
            var endDateConverted = Ext.getCmp('er_enddate').dataArray;
            queryString += "&er_timeline=" + Ext.getCmp('er_timeline').getValue() + "&startdate=" + startDateConverted + "&enddate=" + endDateConverted + "&starthr=" + Ext.getCmp('er_sthr').dataArray + "&endhr=" + Ext.getCmp('er_endhr').dataArray + "&startmin=" + mgr_stmin + "&endmin=" + mgr_enmin;

            queryString += "&timefrom=" + timefrom + "&minfrom=" + minfrom + "&timeto=" + timeto + "&minto=" + minto;
            queryString += "&er_excwe=" + er_excwe;
            var queryArray = new Array();

            if (reportGeneration == 'foreground') {
                queryString += "&er_reportgenration=" + reportGeneration + "&responseType=json";
            } else {
                bg_reportname = checkFileName(bg_reportname);
                queryString += "&er_reportgenration=" + reportGeneration + "&bg_reportname=" + bg_reportname;
            }
        }
        if (isOthers) {
            if (appConstants.publicJsonData.hasOwnProperty('hiddenFields')) {
                var hiddenFields = appConstants.publicJsonData.hiddenFields;
                for (var hiddenField in hiddenFields) {
                    if (this.isNewFav != undefined && this.isNewFav) {
                        if (hiddenField != undefined && hiddenField == 'ID') {
                            continue;
                        }
                        if (hiddenField != undefined && hiddenField == 'FavoriteId') {
                            continue;
                        }
                    }
                    queryString += "&" + hiddenField + "=" + hiddenFields[hiddenField];
                }
            }
        }
        queryString += "&er_RmDispName=" + appConstants.er_RmDispName;
        queryString += "&chartType=" + appConstants.chartType;
        return queryString;
    },
    boxready: function() {
        var thisController = this;
        if (!appConstants.hideBackButton) {
            Ext.getCmp('mainform').add({
                xtype: 'hidden',
                id: 'ID',
                name: 'ID',
                value: appConstants.publicJsonData['ID']
            });
        }
        this.getMain().setTitle(appConstants.er_RmDispName);
        if (appConstants.frmFavModify != undefined && appConstants.frmFavModify == 'Yes') {
            return;
        }
        if (appConstants.frmSchModify != undefined && appConstants.frmSchModify == 'Yes') {
            return;
        }
        if (appConstants.isForceSubmit == "true" || appConstants.isSubmit == "true") {
            this.loadReportData(appConstants.publicjsonData);
        }
    },
    onChangeReportGeneration: function(obj) {
        this.hideResults();
        this.disableTools();
        Ext.getCmp('submitViaSetting').show();
        Ext.getCmp('moreOptionCloseId').hide();
        if (obj.getValue() == 'background') {
            Ext.getCmp('bgReportName').setValue("");
            Ext.getCmp('bgReportName').show();
        } else if (obj.getValue() == 'background-csv') {
            Ext.getCmp('bgReportName').setValue("");
            Ext.getCmp('bgReportName').show();
        } else if (obj.getValue() == 'background-xls') {
            Ext.getCmp('bgReportName').setValue("");
            Ext.getCmp('bgReportName').show();
        } else {
            Ext.getCmp('submitViaSetting').hide();
            Ext.getCmp('moreOptionCloseId').show();
            Ext.getCmp('bgReportName').hide();
        }
    },
    loadForm: function() {
        this.loadFormFields();
        var from_schedule = appConstants.frmSchModify;
        var fromFavoriteModify = appConstants.frmFavModify;
        if (from_schedule == "Yes" || fromFavoriteModify == "Yes") {
            Ext.getCmp("submit").hide();
            Ext.getCmp("save").show();
            Ext.getCmp("favoriteTool").setDisabled(true);
            Ext.getCmp("scheduleTool").setDisabled(true);
        } else {
            Ext.getCmp("submit").show();
            Ext.getCmp("save").hide();
        }
        var date = appConstants.publicJsonData.selectedFields.startDateForDisplay;
        var component = Ext.getCmp('er_stdate');
        component.setValue(date);
        component.dataArray = date;
        date = appConstants.publicJsonData.selectedFields.endDateForDisplay;
        component = Ext.getCmp('er_enddate');
        component.setValue(date);
        component.dataArray = date;

        Ext.getCmp('er_sthr').setValue(appConstants.publicJsonData.selectedFields.startHourForDisplay);
        Ext.getCmp('er_endhr').setValue(appConstants.publicJsonData.selectedFields.endHourForDisplay);
        Ext.getCmp('er_sthr').dataArray = appConstants.publicJsonData.selectedFields.startHour;
        Ext.getCmp('er_endhr').dataArray = appConstants.publicJsonData.selectedFields.endHour;
        stmin = appConstants.publicJsonData.selectedFields.startMinForDisplay;
        enmin = appConstants.publicJsonData.selectedFields.endMinForDisplay;
        mgr_stmin = appConstants.publicJsonData.selectedFields.startmin;
        mgr_enmin = appConstants.publicJsonData.selectedFields.endmin;
    },
    loadFormFields: function() {
        this.loadComboField('er_option', 'analysisByCombo', 'analysisComboLabel', 'selectedAnalysisByCombo', appConstants.publicJsonData, false, null, true);
        this.loadComboField('er_timeline', 'timelineCombo', 'timelineComboLabel', 'selectedTimeline', appConstants.publicJsonData, false, null, false);
        if (appConstants.publicJsonData.combo.siteCombo != undefined) {
            Ext.getCmp('er_site').show();
            this.loadComboField('er_site', 'siteCombo', 'siteComboLabel', 'selectedSiteCombo', appConstants.publicJsonData, false, null, true);
        }
        this.loadComboField('er_compType', 'compTypeCombo', 'compTypeComboLabel', 'selectedCompTypeCombo', appConstants.publicJsonData, false, null, true);
        this.loadComboField('er_component', 'componentCombo', 'componentLabel', 'componentSelected', appConstants.publicJsonData, false, null, true);
    },
    loadSettings: function() {
        var hiddenFields = appConstants.publicJsonData.hiddenFields;
        var FavoriteId = hiddenFields["FavoriteId"];
        if (!Ext.isEmpty(FavoriteId)) {
            Ext.getCmp('reportGeneration').setDisabled(true);
        }
        Ext.getCmp('moreOptionCloseId').show();
        this.loadComboField('er_excwe', 'excludeWeekendsCombo', 'excludeWeekendsLabel', 'excludeWeekendsSelected', appConstants.publicJsonData, false, null, true);
        this.loadComboField('reportGeneration', 'reportGenerationCombo', 'reportGenerationLabel', 'reportGenerationSelected', appConstants.publicJsonData, false, null, true);

        var selectedFields = appConstants.publicJsonData.selectedFields;
        Ext.getCmp('timefrom').setValue(selectedFields.selectedTimeFrom);
        Ext.getCmp('minfrom').setValue(selectedFields.selectedMinsFrom);
        Ext.getCmp('timeto').setValue(selectedFields.selectedTimeTo);
        Ext.getCmp('minto').setValue(selectedFields.selectedMinsTo);
        if (selectedFields.hasOwnProperty('reportNameSelected'))
            Ext.getCmp('bgReportName').setValue(selectedFields.reportNameSelected);
        selectedFields = null;
        delete selectedFields;
    },
    showConfigDropdown: function() {
        Ext.widget('configform');
        isSettingsEnabled = true;
        var thisController = this;
        Ext.get('closeSettings').on('click', function() {
            thisController.validateAndCloseSettings();
        });
    },
    validateAndCloseSettings: function() {
        if (this.validateSettings()) {
            Ext.get('configMod').animate({
                duration: 500,
                to: {
                    y: -500
                }
            });
            return true;
        }
        return false;
    },
    closeSettingAndSubmit: function() {
        if (this.validateAndCloseSettings()) {
            this.showResult();
        }
    },
    loadComboField: function(comboId, comboProperty, comboLabelProperty, comboSelectedProperty, parentJsonProperty, isMultiSelect, multiSelectPaneId, isSetLabel) {
        var component = Ext.ComponentManager.get(comboId);
        if (parentJsonProperty.combo.hasOwnProperty(comboProperty)) {
            var rawData = parentJsonProperty.combo[comboProperty];
            component.getStore().clearFilter(true);
            component.getStore().loadRawData(rawData);

            if (parentJsonProperty.selectedFields.hasOwnProperty(comboSelectedProperty)) {
                component.setValue(parentJsonProperty.selectedFields[comboSelectedProperty]);
            } else {
                component.setValue(rawData[0].valueField);
            }
            if (isSetLabel) {
                if (parentJsonProperty.labelFields.hasOwnProperty(comboLabelProperty)) {
                    if (!isMultiSelect)
                        component.setFieldLabel(parentJsonProperty.labelFields[comboLabelProperty]);
                    else
                        Ext.ComponentManager.get(multiSelectPaneId).setFieldLabel(parentJsonProperty.labelFields[comboLabelProperty]);
                }
            }
            if (!isMultiSelect) {
                if (component.isHidden())
                    component.show();
            } else {
                var m = Ext.ComponentManager.get(multiSelectPaneId);
                if (m.isHidden())
                    m.show();
            }
        } else {
            if (!isMultiSelect) {
                if (!component.isHidden())
                    component.hide();
            } else {
                var m = Ext.ComponentManager.get(multiSelectPaneId);
                if (!m.isHidden())
                    m.hide();
            }
        }
    },
    loadTools: function() {
        this.getNewUtilities().loadIcon(true, true, true, false, false, true, true, false, false, false, true);
        Ext.getCmp("favoriteTool").setDisabled(false);
        Ext.getCmp("scheduleTool").setDisabled(false);
    },
    toggleForm: function(obj) {
        Ext.getCmp('panelinsidetoggle').show();
        Ext.getCmp('panelinsidetoggle').setDisabled(false);
        var ornt = Ext.getCmp('mainform');
        if (ornt.isHidden()) {
            ornt.show();
            Ext.getCmp('selectionDetails').hide();
        } else {
            ornt.hide();
            Ext.getCmp('selectionDetails').show();
        }
    },
    getMessageBox: function(title, msg) {
        Ext.MessageBox.show({
            title: title,
            msg: msg,
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.WARNING
        });
        return false;
    },
    validateMainForm: function(flag) {
        var hiddenFields = appConstants.publicJsonData.hiddenFields;
        var MaxDaysInMonth = hiddenFields.getMaxDaysInMonth;
        var er_usertimeline = hiddenFields.userTimeline;

        var er_timeline = Ext.getCmp('er_timeline').getValue();
        var stDate = Ext.getCmp('er_stdate').getValue();
        var enDate = Ext.getCmp('er_enddate').getValue();
        var startHour = Ext.getCmp('er_sthr').getValue();
        var endHour = Ext.getCmp('er_endhr').getValue();
        stDate.setHours(startHour);
        enDate.setHours(endHour);
        var reportgen = appConstants.publicJsonData.selectedFields.reportGenerationSelected;
        if (isSettingsEnabled) {
            reportgen = Ext.getCmp('reportGeneration').getValue();
        }
        if (er_usertimeline != null && er_usertimeline != '-1') {
            var usertimelineValid = isUserTimelineLimitExceeded(er_usertimeline, MaxDaysInMonth, stDate, enDate);
            if (!usertimelineValid) {
                Ext.MessageBox.show({
                    title: alert_text,
                    msg: _invalidUserTime,
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.WARNING
                });
                return false;
            }
        }
        obj = Ext.getCmp('er_option');
        if (obj.getValue() == '-1') {
            this.getMessageBox(alert_text, reportTypeMsg);
            return false;
        }
        obj = Ext.getCmp('er_site');
        if (obj.getValue() == '' || (obj.getValue() == '-1' && !obj.isHidden())) {
            this.getMessageBox(alert_text, pleaseChooseTxt + ' ' + obj.getFieldLabel());
            return false;
        }
        obj = Ext.getCmp('er_compType');
        if (obj.getValue() == '' || (obj.getValue() == '-1' && !obj.isHidden())) {
            this.getMessageBox(alert_text, pleaseChooseTxt + ' ' + obj.getFieldLabel());
            return false;
        }
        obj = Ext.getCmp('er_component');
        if (obj.getValue() == '' || (obj.getValue() == '-1' && !obj.isHidden())) {
            this.getMessageBox(alert_text, componentMsg);
            return false;
        }
        if (reportgen == 'foreground') {
            if (flag) {
                var limitforbg = hiddenFields.limitforbg;
                if (!Ext.isEmpty(limitforbg)) {
                    if (!checkTimeLineForBgLimit(limitforbg, MaxDaysInMonth, stDate, enDate)) {
                        Ext.MessageBox.confirm('Confirm', appConstants.forGrdReportConfirmMsg, this.showConfirmResult, this);
                        return false;
                    }
                }
            }
        } else {
            var reportName = Ext.getCmp('bgReportName').getValue();
            if (!validateTextBoxWithSpecialChars(reportName, 'Attachment', true))
                return false;
        }
        return true;
    },
    validateMainFormForFavAndSch: function() {
        var hiddenFields = appConstants.publicJsonData.hiddenFields;
        var MaxDaysInMonth = hiddenFields.getMaxDaysInMonth;
        var er_usertimeline = hiddenFields.userTimeline;

        var er_timeline = Ext.getCmp('er_timeline').getValue();
        var stDate = Ext.getCmp('er_stdate').getValue();
        var enDate = Ext.getCmp('er_enddate').getValue();
        var startHour = Ext.getCmp('er_sthr').getValue();
        var endHour = Ext.getCmp('er_endhr').getValue();
        stDate.setHours(startHour);
        enDate.setHours(endHour);
        var reportgen = appConstants.publicJsonData.selectedFields.reportGenerationSelected;
        if (isSettingsEnabled) {
            reportgen = Ext.getCmp('reportGeneration').getValue();
        }
        if (er_usertimeline != null && er_usertimeline != '-1') {
            var usertimelineValid = isUserTimelineLimitExceeded(er_usertimeline, MaxDaysInMonth, stDate, enDate);
            if (!usertimelineValid) {
                Ext.MessageBox.show({
                    title: alert_text,
                    msg: _invalidUserTime,
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.WARNING
                });
                return false;
            }
        }
        var obj = Ext.getCmp('select_farm');
        if (obj.getValue() == '-1') {
            this.getMessageBox(alert_text, obj.getStore().getAt(0).get('displayField'));
            return false;
        }
        obj = Ext.getCmp('er_compType');
        if (obj.getValue() == '-1') {
            this.getMessageBox(alert_text, compTypeMsg);
            return false;
        }
        obj = Ext.getCmp('er_component');
        if (obj.getValue() == '' || (obj.getValue() == '-1' && !obj.isHidden())) {
            this.getMessageBox(alert_text, componentMsg);
            return false;
        }
        var objAry = obj.getValue();
        return true;
    },
    showConfirmResult: function(btn) {
        if (btn == "yes") {
            var getButtonObj = Ext.getCmp('submit');
            getButtonObj.setDisabled(false);
            if (isSettingsEnabled)
                Ext.get('configMod').animate({
                    duration: 500,
                    to: {
                        y: -500
                    }
                });
            this.getAjaxDataForSubmit(this.foregroundControllerUrl, 'isSubmit=true&' + this.getQueryString(true, true, true));
            //this.doUpdate(true,false);
        } else {
            if (!isSettingsEnabled) {
                this.getReporterSettings().down('button').fireHandler();
            }
            var reportGenType = Ext.getCmp('reportGeneration');
            var bgreportNameObj = Ext.getCmp('bgReportName');
            reportGenType.setValue('background');
            bgreportNameObj.setValue("");
            bgreportNameObj.show();
            bgreportNameObj.focus(false, 1000);
            validateTextBoxWithSpecialChars(bgreportNameObj.getValue(), 'Attachment', true);
            return false;
        }
    },
    validateSettings: function() {
        var isSettingsOk = true;
        var reportgen = Ext.getCmp('reportGeneration').getValue();
        var timefrom = Ext.getCmp('timefrom').getValue();
        var minfrom = Ext.getCmp('minfrom').getValue();
        var timeto = Ext.getCmp('timeto').getValue();
        var minto = Ext.getCmp('minto').getValue();
        if (!checkTimePeriod(timefrom, minfrom, timeto, minto)) {
            isSettingsOk = false;
        }
        if (reportgen != null && (reportgen == 'background' || reportgen == 'background-xls' || reportgen == 'background-csv')) {
            var reportName = Ext.getCmp('bgReportName').getValue();
            if (!validateTextBoxWithSpecialChars(reportName, 'Attachment', true))
                isSettingsOk = false;
        }
        return isSettingsOk;
    }
});