Ext.define('LogonFailureApp.controller.LogonFailureAppController', {
	extend: 'Ext.app.Controller',
	views: ['Main', 'EgComponentsGroup'],
	refs: [
		{
			selector: 'main',
			ref: 'main'
		},
		{
			selector: 'newUtilities',
			ref: 'newUtilities'
		},
		{
			selector: 'egcomponentsGroup',
			ref: 'egcomponentsGroup'
		}, 
		{
			selector: 'logonFailureAppDetailsForm',
			ref: 'logonFailureAppDetailsForm'
		},
		{
			selector: 'logonFailureAppSettings',
			ref: 'logonFailureAppSettings'
		},
		{
			selector: 'mainform',
			ref: 'mainform'
		},
		{
			selector: 'resultpanel',
			ref: 'resultpanel'
		},
		{
			selector: 'nomeasurepanel',
			ref: 'nomeasurepanel'
		},
		{
			selector: 'customtrigger',
			ref:'customtrigger'
		}
	],
	init: function() 
	{
		this.control({
			'newUtilities': 
			{
				'afterrender': this.loadTools
			},
			'main':
			{
				'afterrender': this.afterMainRender,
			},
			'mainform button[name="submit"]':
			{
				'click': this.submitReport
			},
			'mainform button[name="save"]':
			{
				'click': this.modifyScheduleFavorite
			},
			'newUtilities > #saveTool > button':
			{
				'click': this.saveReportAsPDF
			},
			'newUtilities > #printTool > button':
			{
				'click': this.printReport
			},
			'newUtilities > #mailTool > button':
			{
				'click': this.sendMail
			},
			'newUtilities > #csvTool > button':
			{
				'click': this.saveCsv
			},
			'newUtilities > #favoriteTool > button':
			{
				'click': this.saveFavorite
			},
			'newUtilities > #scheduleTool > button':
			{
				'click': this.saveSchedule
			},
			'mainform button[id="expandSelector"]':
			{
				'click': this.expandMe
			},
			'logonFailureAppDetailsForm combo[id="er_option"]':
			{
				'select': this.onSelectAnalysisBy
			},
			'logonFailureAppDetailsForm combo[id="er_site"]':
			{
				'select': this.onSelectSiteBy
			},
			'logonFailureAppDetailsForm combo[id="er_compType"]':
			{
				'select': this.onSelectComponentType
			},
			'egcomponentsGroup multiselectfield[name="er_CompGrp"]':
			{
				'change': this.ComponentOnChange
			},
			'mainform trigger[id="compGroupSearch"]':
			{
				'change': this.compMultiselect
			},
			'logonFailureAppSettings':
			{
				'afterrender': this.closeSetting
			},
			'logonFailureAppSettings combo[name="reportGeneration"]':
			{
				'select': this.reportGenChange
			},
			'logonFailureAppSettings button[id="moreOptionCloseId"]':
			{
				'click': this.validateAndCloseSettings
			},
			'logonFailureAppSettings button[id="submitViaSetting"]':
			{
				'click': this.closeSettingAndSubmit
			},
		   /* 'logonFailureAppSettings combo[id="er_excwe"]': {
				'select': this.excludeWeekendsChange
			}, */
	       'mainform button[id="panelinsidetoggle"]': {
				'click': this.toggleForm
			}
		});
	},
	loadTools: function() 
	{
		this.getNewUtilities().loadIcon(true, true, true, false, true, true, true, false, false, false,true);
		Ext.getCmp("favoriteTool").setDisabled(false);
		Ext.getCmp("scheduleTool").setDisabled(false);
	},
	afterMainRender: function()
	{
		this.getMain().setTitle(appConstants.defaultLoadData.reportTitle);
		var jData = appConstants.defaultLoadData;
		this.setErOptionData(jData);
		var analysisBy = Ext.getCmp('er_option');
		var er_site=Ext.getCmp('er_site');
		//var er_subZone=Ext.getCmp('er_subZone');
		if(analysisBy != undefined && analysisBy.getValue() != undefined && analysisBy.getValue() != 'Component')
		{				
			this.setSiteOptionData(jData);
			er_site.show();
			//er_subZone.show();
		}
		else
		{
			er_site.hide();
			//er_subZone.hide();
		}
		this.setComponentTypeData(jData);
		this.setComponentData(jData);
		var erTimeline = Ext.getCmp('er_timeline');
		erTimeline.getStore().loadRawData(jData['timelineCombo']);
		erTimeline.setValue(jData['selectedTimeline']);
		var startDateObj = Ext.getCmp('er_stdate');
		startDateObj.setValue(jData.startDateForDisplay);
		startDateObj.dataArray = jData.startDate;
		var startHrObj = Ext.getCmp('er_sthr');
		startHrObj.setValue(jData.startHourForDisplay);
		startHrObj.dataArray = jData.startHour;
		var endDateObj = Ext.getCmp('er_enddate');
		endDateObj.setValue(jData.endDateForDisplay);
		endDateObj.dataArray = jData.endDate;
		var endHrObj = Ext.getCmp('er_endhr');
		endHrObj.setValue(jData.endHourForDisplay);
		endHrObj.dataArray = jData.endHour;
		mgr_stmin=appConstants.defaultLoadData.startmin;
		mgr_enmin=appConstants.defaultLoadData.endmin;
		Ext.getCmp('logonFailureAppDetailsForm').add({
			xtype: 'hidden',
			id: 'ID',
			name: 'ID',
			value: jData['ID']
		});
	},
	expandMe: function(btn)
	{
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		appConstants.erUtils.expandMultiComboButton(Ext.getCmp('er_Component'), Ext.getCmp('compLbl').text, btn);
	},
	setSiteOptionData:function(jData)
	{
		var siteBy = Ext.getCmp('er_site');
		//var er_subZone = Ext.getCmp('er_subZone');
		if(jData.subZoneCombo != undefined)
		{
			var analysisBy = Ext.getCmp('er_option');			
			siteBy.setFieldLabel(analysisBy.getValue());
			siteBy.getStore().loadRawData(jData['siteCombo']);
			siteBy.setValue(jData.selectedField['selectedSiteCombo']);
			siteBy.show();
			/*var er_subZone=Ext.getCmp('er_subZone');
			er_subZone.getStore().loadRawData(jData['subZoneCombo']);
			er_subZone.setValue(jData.selectedField['selectedSubZone']);			
			er_subZone.show();*/
		}
		else
		{
			siteBy.hide();
			//er_subZone.hide();
		}
	},
	setErOptionData: function(jData)
	{ 
		var analysisBy = Ext.getCmp('er_option');
		analysisBy.getStore().loadRawData(jData['analysisBy']);
		analysisBy.setValue(jData.selectedField['selectedAnalysisBy']);
		analysisBy.setFieldLabel(jData.screenLabel['lblAnalysisBy']);
	},
	setComponentTypeData:function(jData)
	{
		var er_componentType=Ext.getCmp('er_compType');
		er_componentType.getStore().loadRawData(jData['compTypeCombo']);
		er_componentType.setValue(jData.selectedField['selectedComponentTypes']);
		er_componentType.setFieldLabel(jData.screenLabel['lblCompType']);
	},
	setComponentData:function(jData)
	{
		var er_Component=Ext.getCmp('er_Component');
		er_Component.getStore().clearFilter(true);
		er_Component.getStore().loadRawData(jData['componentCombo']);
		if(!Ext.isEmpty(jData.selectedField['selectedComponents']) && jData.selectedField['selectedComponents'] != undefined)
		{
			er_Component.setValue(jData.selectedField['selectedComponents']);
		}
		else
		{
			er_Component.setValue(jData['componentCombo'][0].valueField);
		}
	},		
	onSelectAnalysisBy: function(obj)
	{
		var thisVal = Ext.getCmp('er_option').getValue();
		var reportBy = 'analysisBy=' + thisVal;
		reportBy += '&supportedComponents='+appConstants.supportedComponents+'&reportType='+appConstants.reportType;
		var formObj = this;
		appConstants.LoadingMask.show();
		Ext.Ajax.request({
			url: '/final/reporter/ErLogonFailureJson.jsp',
			scope: this,
			method: 'POST',
			params: reportBy,
			success: function(response) 
			{
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);
				appConstants.defaultLoadData = jsonData;
				if(thisVal != 'Component')
				{
					formObj.setSiteOptionData(jsonData);
					Ext.getCmp('er_site').show();
					//Ext.getCmp('er_subZone').show();
				}
				else
				{
					Ext.getCmp('er_site').hide();
					//Ext.getCmp('er_subZone').hide();
				}
				formObj.setComponentTypeData(jsonData);
				formObj.setComponentData(jsonData);
				appConstants.LoadingMask.hide();
			}
		});
	},
	onSelectSiteBy: function(obj)
	{
		var thisVal=Ext.getCmp('er_site').getValue();
		var paramsObj='analysisBy='+Ext.getCmp('er_option').getValue()+"&er_site="+thisVal;
		paramsObj += '&supportedComponents='+appConstants.supportedComponents+'&reportType='+appConstants.reportType;
		var formObj = this;
		appConstants.LoadingMask.show();
		Ext.Ajax.request({
			url: '/final/reporter/ErLogonFailureJson.jsp',
			scope: this,
			method: 'POST',
			params: paramsObj,
			success: function(response) 
			{
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);
				appConstants.defaultLoadData = jsonData;
				formObj.setComponentTypeData(jsonData);
				formObj.setComponentData(jsonData);
				appConstants.LoadingMask.hide();
			}
		});
	},
	onSelectComponentType: function()
	{
		var er_option = Ext.getCmp('er_option').getValue();
		var er_compType = Ext.getCmp('er_compType').getValue();
		var params='&analysisBy='+er_option;
		if(!appConstants.enableMultiCompType)
		{
			params += "&er_compType="+er_compType;
		}
		else
		{
			for(var c=0;c<er_compType.length;c++)
			{
				params += "&er_compType="+ er_compType[c];
			}
		}
		params += '&supportedComponents='+appConstants.supportedComponents+'&reportType='+appConstants.reportType;
		var formObj = this;
		appConstants.LoadingMask.show();
		Ext.Ajax.request({
			url:'/final/reporter/ErLogonFailureJson.jsp',
			scope:this,
			method: 'POST',
			params: params,
			success:function(response)
			{
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);
				appConstants.defaultLoadData = jsonData;
				formObj.setComponentData(jsonData);
				appConstants.LoadingMask.hide();
			}
		});
		

	},
	ComponentOnChange: function(obj, newValue, oldValue, eOpts)
	{
		var er_option = Ext.getCmp('er_option').getValue();
		if(er_option != undefined && er_option == 'Aggregate')
		{
			return;
		}
		if (newValue.length > 1 && (newValue.indexOf('All') > -1 || newValue.indexOf("all") > -1))
		{
			this.showMessage('Chosen components group not allowed');
			return;
		}
		if (Ext.isEmpty(oldValue) || oldValue == undefined) 
		{
			return false;
		}
		var er_type = Ext.getCmp('er_type').getValue();		
		var er_compType = Ext.getCmp('er_compType').getValue();
		var er_CompGrp = Ext.getCmp('er_CompGrp').getValue();
		var params='reportType='+er_type+'&analysisBy='+er_option;
		params += "&er_compType=all";
		for(var c=0;c<er_CompGrp.length;c++)
		{
			params += "&selectedGroups="+er_CompGrp[c];
		}
		var formObj = this;
		appConstants.LoadingMask.show();
		Ext.Ajax.request({
			url: '/final/reporter/ErLogonFailureJson.jsp',
			scope: this,
			method: 'POST',
			params: params,
			success: function(response)
			{
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);
				formObj.setComponentTypeData(jsonData);
				appConstants.LoadingMask.hide();
			}
		});
	},
	saveReportAsPDF: function() 
	{
		if(appConstants.customPaging)
		{
			this.exportDataAlert();
			return '';
		}
		var qryString = "../reporter/ErHtmlToSavePdf.jsp?";
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		appConstants.erUtils.savePDF(qryString);
	},
	bookletQuery: function(obj)
	{	
		if(appConstants.customPaging)
		{
			this.exportDataAlert();
			return '';
		}
		var s_qryString = appConstants.defaultLoadData;
		return s_qryString;
	},
	bookletScheduleQuery: function(obj)
	{		
		if(appConstants.customPaging)
		{
			this.exportDataAlert();
			return '';
		}
		var bookletquery=this.getQueryString();
		bookletquery+="&er_rtype="+appConstants.er_rtype+"&er_trgttype="+appConstants.er_bgreportfrom+"&er_ViewName=ErLogonFailure.jsp&er_RmDispName="+appConstants.er_RmDispName+"&opt=data";
		bookletquery = encodeURI(bookletquery);
		return bookletquery;
	},
	bookletPreview:function()
	{	
		if(appConstants.customPaging)
		{
			this.exportDataAlert();
			return '';
		}
		this.printReport();
	},
	
	printReport: function() 
	{
		if(appConstants.customPaging)
		{
			this.exportDataAlert();
			return '';
		}
		var s_qryString = "/final/reporter/ErLogonFailurePrint.jsp?&pdfPrint=yes&inidate="+appConstants.defaultLoadData.inidate+'&reportType='+appConstants.reportType;
		parent.printWindowFn(s_qryString);
	},
	sendMail: function()
	{
		if(appConstants.customPaging)
		{
			this.exportDataAlert();
			return '';
		}
		Ext.widget('sendmail').show();
	},
	saveCsv: function()
	{		
		window.location = '../servlet/com.eg.ErLogonFailureReportC?er_view=CSV&reportType='+appConstants.reportType;
	},
	saveSchedule: function(obj)
	{
		if(appConstants.customPaging)
		{
			this.exportDataAlert();
			return '';
		}
		var params = this.getQueryString();
		var qryString ="/final/reporter/ErSaveSchedule.jsp?er_rtype="+appConstants.er_rtype+"&er_trgttype="+appConstants.er_bgreportfrom+"&er_ViewName=ErLogonFailure.jsp&opt=data&er_RmDispName="+appConstants.er_RmDispName+"&"+params+"&com.eg.CSRF_NONCE="+csrfToken;
		if (Ext.getCmp('er_timeline').getValue() == 'Any')
		{
		   this.showMessage('Chosen timeline not allowed');
			  return;
		}
		var scheduleQryStr = encodeURI(qryString);
		parent.scheduleWindowFn(scheduleQryStr);
	},
	saveFavorite: function()
	{
		if(appConstants.customPaging)
		{
			this.exportDataAlert();
			return '';
		}
		var params = this.getQueryString();
		var target = "/final/reporter/ErSaveFavorite.jsp?er_trgttype="+appConstants.er_bgreportfrom+"&er_rtype="+appConstants.er_rtype+"&er_ViewName=ErLogonFailure.jsp&er_RmDispName="+appConstants.er_RmDispName+"&opt=data"+params+"&com.eg.CSRF_NONCE="+csrfToken;
		/*if (Ext.getCmp('er_timeline').getValue() == 'Any')
		{
			  this.showMessage('Chosen timeline not allowed');
			  return;
		}*/
		var favQryString = encodeURI(target);
		parent.favouriteWindowFn(favQryString);
	},
	modifyScheduleFavorite: function()
	{
		var qryStr = this.getQueryString();
		var commonQStr = '&er_trgttype='+appConstants.er_bgreportfrom+'&er_rtype='+appConstants.er_rtype+'&er_ViewName=ErLogonFailure.jsp&er_RmDispName='+appConstants.er_RmDispName+'&cmd=client'
		var forSchedule = '&schedule_id='+appConstants.scheduleID+'&fromScheduleModify=Yes';
		var forFavorite = '&FavoriteId='+appConstants.favoriteID+'&fromFavoriteModify=Yes&er_favorite='+appConstants.erFavorite;
		var urlNw         = "";
		if(appConstants.isModifyFavorite == 'Yes')
		{
			urlNw = "/final/reporter/ErSaveFavorite.jsp?showSchWindow=no" ;
			qryStr += commonQStr+forFavorite;
		}
		else
		{
			urlNw = "/final/reporter/ErSaveSchedule.jsp?showSchWindow=no";
			qryStr += commonQStr+forSchedule;
		}
		var modifyQryStr = encodeURI(qryStr);
		var formSave = Ext.create('Ext.form.Panel');
		formSave.submit({
			url: urlNw,
			params: modifyQryStr,
			standardSubmit: true,
			method: 'POST'
		});
	},
	compMultiselect: function(obj)
	{
		if (Ext.isEmpty(appConstants.erUtils))
			appConstants.erUtils = Ext.widget("erutils");
		obj.toggleTriggger();
		appConstants.erUtils.filterComboStore(obj, Ext.getCmp('er_Component'), appConstants.defaultLoadData['groupList']);
	},

	submitReport: function(qryStr)
	{
		Ext.getCmp('panelinsidetoggle').setDisabled(false);
		if(!isSettingsEnabled)
			this.showConfigDropdown();//..
		var params ='';
		this.getNomeasurepanel().hide();
		
		if(appConstants.isSubmit !=null &&  appConstants.isSubmit == 'true')
		{
			params = this.getQueryString();
		}
		else
		{
			params =  this.getQueryString();
			if(params==false) 
				return;
		}
		var formObj = this;
		var rGenType ='foreground';
		if(isSettingsEnabled)
		{
		   rGenType = Ext.getCmp("reportGeneration").getValue();
		}
		if(rGenType =='foreground')
		{
			var me1 = this;
			var limitforbg = appConstants.defaultLoadData.limitforbg;
			var maxDays    = appConstants.defaultLoadData.maxDays;

			var stDate    = Ext.getCmp("er_stdate").getValue();
			var startHr   = Ext.getCmp("er_sthr").getValue();
			var enDate    = Ext.getCmp("er_enddate").getValue();
			var endHr     = Ext.getCmp("er_endhr").getValue();
			stDate.setHours(startHr);
			enDate.setHours(endHr);          
			if(!checkTimeLineForBgLimit(limitforbg,maxDays,stDate,enDate))
			{
				Ext.Msg.confirm("Confirm", appConstants.forGrdReportConfirmMsg, function(btnText){				
					if(btnText === "no")
					{
						this.getReporterSettings().down('button').fireHandler();
						Ext.getCmp("reportGeneration").setValue('background');
						var reportNameObj =  Ext.getCmp('bgReportName');
						reportNameObj.show();
						reportNameObj.focus();
						return false;
					}
					else if(btnText === "yes")
					{
						me1.submitReportByAjaxCall(params);
					}
				}, this);
			}
			else
			{
				me1.submitReportByAjaxCall(params);
			}
		}
		else
		{
			// param forwardto=LogonFailure common for Logon Failure And Unregister
			params += '&servletName=ErLogonFailureReportC&er_ViewName=ErLogonFailure.jsp&er_rtype='+appConstants.er_rtype+'&er_RmDispName='+appConstants.er_RmDispName;
			params += '&er_trgttype=&forwardto=LogonFailure&er_bgreportfrom='+appConstants.er_bgreportfrom+'&bgenabled=Yes&savereport=save&opt=data';
			if(rGenType == 'background')
			{
				bgUrl= '/final/servlet/com.eg.ErStartBackGroundReportC';
			}
			else if (rGenType == 'background-csv')
			{
				bgUrl= "../servlet/com.eg.ErStartBackGroundReportC?SaveFormat=CSV";
					
			}
			var bgParam = encodeURI(params);
			appConstants.LoadingMask.show();
			this.getNomeasurepanel().hide();
			Ext.Ajax.request({
				url: bgUrl,
				scope: this,
				method: 'POST',
				params: bgParam,
				success: function(response)
				{
					var resultPanelObj = Ext.getCmp('resultPanel');	
					resultPanelObj.removeAll();
					var resultObj = Ext.getCmp('backGroundPanel');
					resultObj.removeAll();
					appConstants.LoadingMask.hide(); 
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);
					var reportValString = jsonData.reportVal;
					var status = reportValString.status;
					var htmlStr='';
					if ( status == 'success' )
					{
						htmlStr='<center><div style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:480px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconSuccess"></div><div style="margin-top:20px"><b>'+reportValString.bgstr1+'</b><br/><a class="backgroundMsgLink" href="'+reportValString.queryString+'">'+reportValString.bgstr2+'</a></div></div></center>';
					}
					else if ( status == 'duplicate' )
					{
						htmlStr='<center><div style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:480px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconExists"></div><div style="margin-top:20px"><b>'+reportValString.bgstr1+'</b><br/><a class="backgroundMsgLink" href="'+reportValString.queryString+'">'+reportValString.bgstr2+'</a></div></div></center>';
					}
					resultObj.update(htmlStr);
					resultObj.show();
				}
			});
		}
	},
	getFocusToGrid:function()
	{
		Ext.getCmp('vengat2').focus();
	},
	submitReportByAjaxCall:function(params)
	{
		appConstants.LoadingMask.show();
		appConstants.currentPage = 1;
		params += '&er_view=submit';
		var me = this;
		var url='/final/servlet/com.eg.ErLogonFailureReportC';
		this.getNomeasurepanel().hide();
		Ext.Ajax.request({
			url: url,
			scope: this,
			method: 'POST',
			params: params,
			success: function(response)
			{
				var resultPanelObj = Ext.getCmp('resultPanel');	
				resultPanelObj.removeAll();
				resultPanelObj.show();
				var jsonObject=response.responseText;
				var jsonData=Ext.decode(jsonObject);
				if (!Ext.isEmpty(jsonData))
				{
					Ext.getCmp("bookletTool").setDisabled(false);
					Ext.getCmp("saveTool").setDisabled(false);
					Ext.getCmp("printTool").setDisabled(false);
					Ext.getCmp("mailTool").setDisabled(false);
					Ext.getCmp("csvTool").setDisabled(false);
					Ext.getCmp('selectionDetails').setSelectionDetailsData(jsonData.selectionDetails);
					var otherInfo = jsonData.OTHER_INFO;
					var overAllRecCount = otherInfo.overAllRecCount;
					var failureOverView = jsonData.failureOverView;
					var hideDesign = jsonData.hideDesign;
					if(appConstants.reportType == "Logon Failure")
					{
						if(hideDesign != undefined && hideDesign == "No")
						{
							appConstants.customPaging = false;
							var failureOverViewChart = jsonData.failureOverViewChart;
							var pieChartResults = jsonData.donutChartFailure;
							var overViewArray = new Array();
													
							var eachCol = failureOverView[0];
							overViewArray.push({
								xtype:'container',
								autoSize: true,
								align:'stretch',
								cls:'mouseOverHighlight',
								margin:'5 10 10 10',
								bodyPadding: '0 0 4 0',
								padding:0,
								layout:{
									type:'vbox',
									align:'center',
									pack:'center'
								},
								defaults: {
									padding:'6px 5px 5px 5px',
								},
								items:[{
									xtype:'container',
									html: '<table align="center" style="cursor:pointer" onclick="javascript:getFocusToGrid()"><tr><td align="right" style="padding-right:5px"><div class="'+eachCol.imageCls+'" ></div></td><td style="text-align:left;padding-left:5px" class="newFont_bold28" >'+eachCol.value+'</td></tr></table>',
									width:'100%',
									style: {
										textAlign:'center',
										width:'50px'
									}
								},
								{
									html:'<span class="newFont_normal13">'+eachCol.displayName+'</span>'
								}]
							});
							for(var k in failureOverView)
							{
								if(k==0)
									continue;
								eachCol=failureOverView[k];
								overViewArray.push({
									xtype:'container',
									autoSize: true,
									align:'stretch',
									margin:'5 10 10 10',
									bodyPadding: '0 0 4 0',
									padding:0,
									layout:{
										type:'vbox',
										align:'center',
										pack:'center'
									},
									defaults: {
										padding:'6px 5px 5px 5px',
										//padding:'10px 10px 10px 10px',
									},
									items: [{
										html: '<table align="center"><tr><td align="right" style="padding-right:5px"><div class="'+eachCol.imageCls+'" ></div></td><td style="text-align:left;padding-left:5px" class="newFont_bold28" >'+eachCol.value+'</td></tr></table>',
										width:'100%',
										style: {
											textAlign:'center',
											width:'50px'
										}
									},
									{
										html:'<span class="newFont_normal13">'+eachCol.displayName+'</span>'
									}]
								});
							}
														
							resultPanelObj.add({
								xtype:'panel',
								ui:'newGraphPanel',
								title:'Overview ',
								margin:'5 10 10 10',
								bodyPadding: '0 0 4 0',
								padding:0,
								layout:{
									type:'hbox',
									align:'center'
								},
								defaults:{
									flex:.22,
								},
								items:overViewArray,
							});
							if (Ext.isEmpty(appConstants.erUtils))
							{
								appConstants.erUtils = Ext.widget("erutils");
							}
							
							if (!Ext.isEmpty(pieChartResults)) {

								var logonDistData='<div><table width="100%"><tr>';
								logonDistData+='<td id="logon_1" width="65%"></td>';
								var legData=pieChartResults['legendArray'];
								var legObj="";
								logonDistData+='<td valign="middle" width="35%"><div><table>';
								for (var key in legData)
								{
									legObj = legData[key];
									logonDistData+='<tr><td valign="middle" style="padding-right: 5px;"><div style="height:7px;width:7px;-webkit-border-radius:4px;background-color:'+legObj.color+'"></div></td><td style="padding-top: .5em;padding-bottom: .5em;"><font size=1.5px">'+legObj.name+'&nbsp;('+legObj.percent+' %)</font></td></tr>';
								}
								logonDistData+='</table></div></td>';							
								logonDistData+='</tr></table></div>';
								chartAvailable = true;
								var Title = pieChartResults['TITLE'];
								var swfPath = pieChartResults['SWFPATH'];
								var xmlData = pieChartResults['XMLDATA'];
								if (!Ext.isEmpty(pieChartResults['LEGENDS'])) {
									var legendsData = pieChartResults['LEGENDS'];
									getPieChartHiddens = pieChartResults['HIDDENS']; 
								}
								var pieChartFail='<div id="pieChartFail" style="height:300px;width:450px !important;overflow:auto;padding:0px">'+logonDistData+'</div>';
								var topNUserByFail='<div id="topNApplByFail" style="height:300px;width:450px !important;overflow:auto;padding:0px"></div>';	
								var failCharAndGraph = Ext.create('Ext.container.Container', {	
									layout :'column',
									xtype: 'panel',
									margin:'10 10 10 10',
									items:[{
										xtype:'panel',
										margin:'0 10 0 0',		
										columnWidth:0.5,
										id:'pieChartContainer',
										ui:'newGraphPanel',
										title:'Logon Failure',
										html: logonDistData,
										listeners:
										{
											'boxready':function(c)
											{
												var activeSessionGraph=pieChartResults;
												if(activeSessionGraph != undefined){
													var lineChart_1 = {};
													lineChart_1 = jQuery.extend(true, {}, getHighChartsBarInstance('logon_1',300,450), lineChart_1);
													lineChart_1.setData(activeSessionGraph,appConstants.currentDateFormat,'');
													lineChart_1.drawChart();
												}else
												{
													//Ext.get('id_1').update('<div style="text-align:center;vertical-align:middle;top:20%;position:relative;"><img src="/final/images/'+strSkin+'/nomeasures_custom.png"></img></div>');
												}
											}
										}
									},	
									{
										xtype:'panel',		
										columnWidth:0.5,
										ui:'newGraphPanel',
										title:'Top 10 Users With Most Number Of Failures',
										html: topNUserByFail
									},
									]
								});
								resultPanelObj.add(failCharAndGraph);
								var topNAppSBar = {};
								topNAppSBar = jQuery.extend(true, {}, getHighChartsBarInstance('topNApplByFail',260,170), topNAppSBar);
								topNAppSBar.setData(jsonData.userGraphObj,'<%=currentDateFormat%>','');
								topNAppSBar.drawChart();
							}
							var topNServerByFail='<div id="topNSerByFail" style="height:300px;width:450px !important;overflow:auto;padding:0px"></div>';	
							var topNClientByFail='<div id="topNClinetIpByFail" style="height:300px;width:450px !important;overflow:auto;padding:0px"></div>';										
							var topNAppContainer = Ext.create('Ext.container.Container', {	
								layout :'column',
								margin:'10 10 10 10',
								items:[{
									xtype:'panel',
									margin:'0 10 0 0',			
									columnWidth:0.5,	
									ui:'newGraphPanel',
									title:'Top 10 Servers With Most Number Of Failures',
									html: topNServerByFail,
								},	
								{
									xtype:'panel',		
									columnWidth:0.5,
									ui:'newGraphPanel',
									title:'Top 10 Client IP With Most Number Of Failures',
									html: topNClientByFail
								},
								]
							});
							resultPanelObj.add(topNAppContainer);
							var topNAppSBar = {};
							topNAppSBar = jQuery.extend(true, {}, getHighChartsBarInstance('topNSerByFail',260,170), topNAppSBar);
							topNAppSBar.setData(jsonData.serverGraphObj,'<%=currentDateFormat%>','');
							topNAppSBar.drawChart();
							var topNAppSBar = {};
							topNAppSBar = jQuery.extend(true, {}, getHighChartsBarInstance('topNClinetIpByFail',260,170), topNAppSBar);
							topNAppSBar.setData(jsonData.clientIpGraphObj,'<%=currentDateFormat%>','');
							topNAppSBar.drawChart();

							var applFailContent='<div id="applFailTimeId" style="height:300px;width:97% !important;overflowY:hidden;padding:0px"></div>'; 
							resultPanelObj.add({
								xtype:'panel',
								margin:'10 10 10 10',
								ui:'newGraphPanel',
								title:'Logon Failure Trend',
								html:applFailContent
							});
							var topNAppSBar = {};
							topNAppSBar = jQuery.extend(true, {}, getHighChartsBarInstance('applFailTimeId',300,300), topNAppSBar);
							topNAppSBar.setData(jsonData.timeGraphObj,'<%=currentDateFormat%>','');
							topNAppSBar.drawChart();

							
													
							var userViewSubCol = jsonData.userDetailCol.userViewSubColumn;
							var userGridArray = jsonData.allFailGridData;
							var gridTitle = jsonData.gridTitle;
							var userViewColunmArray = new Array();
							//var userGridArray=new Array();
							var userDetailsFields = new Array();
							for(var key in userViewSubCol)
							{
								var align = 'left';
								var mainColumn = userViewSubCol[key];
								userDetailsFields.push(mainColumn);
								userViewColunmArray.push({
									header: mainColumn,
									sortable: true,
									resizable :true,
									//flex:1,
									align:align,
									dataIndex: mainColumn,
									/*renderer :function(value, metaData, record, row, col, store, gridView)
									{
										metaData.tdAttr = 'data-qtip="' + value + '"';
										return value;
									},*/
									doSort: function(state) 
									{
										var ds = this.up('grid').store;
										var field = this.getSortParam();
										ds.sort({
											property: field,
											direction: state,
											sorterFn: function(v1, v2)
											{
												v1 = v1.get(field);
												v2 = v2.get(field);
												if(v1.indexOf('.')>-1 && v1.indexOf(' ')>-1)
												{
													var tmp = v1.substring(0, v1.lastIndexOf(' '));

													var dateobj=new Date(Ext.Date.parse(tmp, mgrDateFormat));
													var formDate = Ext.Date.dateFormat(dateobj, getExtjsDateFormat('MMM-dd-yyyy'));
													v1 = formDate + v1.substring(v1.lastIndexOf(' '), v1.length);
												}
												if(v2.indexOf('.')>-1 && v2.indexOf(' ')>-1)
												{
													var tmp = v2.substring(0, v2.lastIndexOf(' '));

													var dateobj=new Date(Ext.Date.parse(tmp, mgrDateFormat));
													var formDate = Ext.Date.dateFormat(dateobj, getExtjsDateFormat('MMM-dd-yyyy'));
													v2 = formDate + v2.substring(v2.lastIndexOf(' '), v2.length);
												}
												if(!isNaN(new Date(v1)) && !isNaN(new Date(v2)))
												{
													v2=new Date(v2).getTime(); 
													v1=new Date(v1).getTime(); 
												}
												else if(!isNaN(v1) && !isNaN(v2))
												{
													v1 = Ext.isNumber(v1) ? v1 : parseFloat(String(v1), 10);
													v2 = Ext.isNumber(v2) ? v2 : parseFloat(String(v2), 10);
													if (state=='ASC')
													{
														v1= isNaN(v1) ? 999999 : v1;
														v2= isNaN(v2) ? 999999 : v2;
													}
													else
													{
														v1= isNaN(v1) ? 0 : v1;

														v2= isNaN(v2) ? 0 : v2;
													}
												}
												
												// transform v1 and v2 here
												return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
												}
											});
									},
									renderer :function(value, metaData, record, row, col, store, gridView)
									{
										metaData.tdAttr = 'data-qtip="' + value + '"';
										return value;
									},
								});	
							}
							
							var isPagingHidden=false;
							 if (userGridArray!=undefined && userGridArray.length<gridPageSize)
								isPagingHidden=true;
							else
								isPagingHidden=false;

							var failDetailsObj=Ext.create('Ext.data.Store', {
								fields:userDetailsFields,
								proxy: {
									type: 'pagingmemory',
									reader: {
										type: 'array', root : 'data', totalProperty : 'total'
									}
								},
								data : userGridArray,
								pageSize:gridPageSize,
								autoLoad : true,
							});

							var activePage=1;
							var userGridpanel = Ext.widget('customgrid',{
								store:failDetailsObj,
								sortableColumns:false,
								columnWidth:1.0,							
								ui:'newGridPanel',
								border:true,							
								id:'vengat2',
								margin:'0 0 0 0',
								columns:userViewColunmArray,
								scroll:true,
								autoScroll:true,
								forceFit:true,
								viewConfig:
								{
									stripeRows: true,
									getRowClass: function (record, rowIndex, rowParams, store)
									{
										if (record.raw.length>0)
										{
											return ;
										}
										else
										{
											return 'hidePlus';
										}
									}
								},
								listeners:{
									sortchange:function(ct, column, e, t, eOpts ){
										me.gridColIndexParam=column.getIndex();
										me.gridColStateParam=column.sortState;
										this.getStore().loadPage(activePage);
									},
									render:function(obj){
										Ext.defer(function() {
										},100);
									}
								},
								dockedItems:[{
									xtype:'pagingtoolbar',
									cls:'newPagination',
									dock: 'bottom',
									displayInfo: true,
									store: failDetailsObj,
									hidden:isPagingHidden,
									displayInfo: true,
									displayMsg: 'Displaying topics {0} - {1} of {2}',
									emptyMsg: "No topics to display",
									listeners: {
										change : function(thisd, params)
										{
											if(!Ext.isEmpty(params))
												activePage = params.currentPage;
											else
												activePage=1;
										}
									}
								}]
							});
							var gridChartAry = new Array();
							gridChartAry.push(userGridpanel);
							resultPanelObj.add({
								xtype:'panel',
								title:gridTitle,
								margin:'10 10 10 10',
								padding:'0 0 0 0',
								ui:'newGraphPanel',
								layout:{
									type:'column',
									align:'stretch',
								},
								items:gridChartAry
							});
							this.getNomeasurepanel().hide();
						}
						else if(overAllRecCount > 0 && hideDesign != undefined && hideDesign == 'Yes')  
						{
							this.loadCustomGrid(jsonData);
							this.loadOverAllPageNavigation(otherInfo);
							fromPerBtn=false;
						}
						else
						{
							this.disableTools();
							resultPanelObj.hide();
							this.getNomeasurepanel().show();			
							Ext.getCmp('panelinsidetoggle').setDisabled(true);
						}
					}
					else if(appConstants.reportType == "VMUnregistered")
					{						
						var isData = jsonData['isData'];
						if(isData)
						{
							var detailTable ='';
							var uniqueTblStr ='';
							uniqueTblStr += '<div class="newTable"><table align="center" valign="middle" width="50%">';
							uniqueTblStr += '<thead><tr><th  align="center" colspan ="2">Summary</th></tr></thead>';
							uniqueTblStr += '<tbody>';
							uniqueTblStr += '<tr><td>Total Unique Pool</td><td>'+jsonData['poolCount']+'</td></tr>';
							uniqueTblStr += '<tr><td>Total Unregister Machines </td><td>'+jsonData['machineCount']+'</td></tr></tbody></table></div>';	
							
							resultPanelObj.add({
								xtype:'panel',
								ui:'newGraphPanel',
								margin:'10 10 10 10',
								id:'new_chk',
								title:'Unregister Machine Details',
								items:[{
									xtype:'container',									
									margin:'10 10 10 10',
									html:uniqueTblStr
								}]
							});
							
							var appExpandDetail = '';
							var appDetailData='';
							appExpandDetail=[{
								ptype: 'rowexpander',
								selectRowOnExpand : true,   // true to select a row when clicking on the expander icon
								expandOnDblClick: false,     // true to toggle a row between expanded/collapsed when double clicked
								expandOnEnter : false,
								collapsible: true,
								animCollapse: false,
								rowBodyTpl: ['<div style="padding:10px 10px 10px 0px;" >{detailsData}</div>']
							}];
							var headings = new Array();
							if (!Ext.isEmpty(jsonData.heading) && jsonData.heading!=undefined)
							{
								var s=0;
								for(var key in jsonData.heading)
								{
									headings[s] = key;
									s++;
								}
							}
							var colm = new Array();
							for(var keys in jsonData.heading)
							{
								colm.push({
									header: jsonData.heading[keys],
									sortable: true,
									dataIndex: keys,
									align:keys=='appName'?'left':'left',
									width:keys=='appName'?300:250,
									renderer :function(value, metaData, record, row, col, store, gridView)
									{
										return value;
									}
								});
							}
							var activePage=1;
							var gridPageSize=15;
							var isPagingHiddenDetailApp=false;
							if (jsonData.eventData.length < gridPageSize)
								isPagingHiddenDetailApp = true;
							else
								isPagingHiddenDetailApp = false;
							headings[s] = 'detailsData';
							var store = Ext.create('Ext.data.Store', {
								fields: headings,
								data: jsonData.eventData,
								pageSize:gridPageSize,
								autoLoad : true,
								sortable: true,
								proxy : {
								  type : 'pagingmemory'
								}
							});
							var me=this;
//							appDetailData=Ext.create('Ext.panel.Panel',{
							Ext.getCmp("new_chk").add(
							{
//								xtype:'panel',
//								title : 'Application Failure Details',
//								//ui:'newGraphPanel',
//								//margin:'0 2 10 0',
//								margin:'10 10 10 10',
//								items:[
//									{
										xtype:'customgrid',
										sortableColumns: true,
										ui:'newGridPanel',
										id:'grid0',
										margin:'0 10 10 10',
										border:true,
										scroll: true,
										autoScroll:true,
										forceFit:true,
										sortableColumns: true,		
										store: store,
										columns: colm,
										//title:'Application Failure Details',
										plugins: appExpandDetail,
										viewConfig:
										{
											stripeRows: true,
											getRowClass: function (record, rowIndex, rowParams, store)
											{
												if (record.raw.detailsData =='')
												{
													return 'hidePlus';
												}
												else
												{
													return;
												}
											},
											listeners: 
											{
												sortchange:function(ct, column, e, t, eOpts ){
													this.getStore().loadPage(activePage);
												}
											}
										},
										dockedItems:[{
											xtype:'pagingtoolbar',
											cls:'newPagination',
											dock: 'bottom',
											displayInfo: true,
											store: store,
											hidden:isPagingHiddenDetailApp,
											displayInfo: true,
											displayMsg: 'Displaying topics {0} - {1} of {2}',
											emptyMsg: "No topics to display",
											listeners: {
												change : function(thisd, params)
												{   
													if(!Ext.isEmpty(params))
														activePage = params.currentPage;
													else
														activePage=1;
												}
											}
										}]
									}
//								]
//							}
								)
//							});
//								Ext.getCmp("new_chk").add(
//									
//								)
							//resultPanelObj.add(appDetailData);
							this.getNomeasurepanel().hide();
						}												
						else
						{
							this.disableTools();
							resultPanelObj.hide();
							this.getNomeasurepanel().show();			
							Ext.getCmp('panelinsidetoggle').setDisabled(true);
						}						
					}
					else
					{
						this.disableTools();
						resultPanelObj.hide();
						this.getNomeasurepanel().show();			
						Ext.getCmp('panelinsidetoggle').setDisabled(true);
					}
				}			
				appConstants.LoadingMask.hide();
			}
		});		
	},
	disableTools: function(){
		Ext.getCmp("bookletTool").setDisabled(true);
		Ext.getCmp("saveTool").setDisabled(true);
		Ext.getCmp("printTool").setDisabled(true);
		Ext.getCmp("mailTool").setDisabled(true);
		Ext.getCmp("csvTool").setDisabled(true);
	},	
	/* excludeWeekendsChange: function()
	{
		var excWeek=Ext.getCmp("er_excwe");
		var excDays=Ext.getCmp('excludeDays');
		if(excWeek.getValue()=="Yes")
		{	
			excDays.show();
			var excludeMessageData = appConstants.defaultLoadData['excludeMessage'];
			excDays.update(excludeMessageData);
		}
		else
		{
			excDays.hide();
		}
	 },	*/
	showConfigDropdown:function()
	{
		isSettingsEnabled = true;
		var tpl = new Ext.XTemplate('<div style="float:left;margin:0px 0px 0px 0px">'+settings+'</div><div style="text-align:right;float:right;"><div class="iconCloseNew" id="closeSettings"></div></div>');
		//config dropdown mode
		Ext.create('Ext.container.Container',{
			width:569,
			//padding:5,
			id:'configMod',
			ui:'settingsWindowContainer',
			items:[
				{
					xtype:'container',
					cls:'configMode_popupArrow',
					style:{'top':'-14px','left':'359px'}
				},
				{
					xtype:'container',
					html:tpl.apply(),
					style:{'top':'0px','margin':'0px'},
					cls:'containerHeader',
				},
				{
					xtype : 'logonFailureAppSettings',
					parent:this
				}
			],
			renderTo:'viewMain'
		});
		var timefromObj = Ext.getCmp('timefrom');
		timefromObj.setValue(appConstants.defaultLoadData.sHrForSetting);
		 
		var minfromObj = Ext.getCmp('minfrom');
		minfromObj.setValue(appConstants.defaultLoadData.sMinForSetting);
		 
		var timetoObj = Ext.getCmp('timeto');
		timetoObj.setValue(appConstants.defaultLoadData.eHourForSetting);
		 
		var mintoObj = Ext.getCmp('minto');
		mintoObj.setValue(appConstants.defaultLoadData.eMinForSetting);
 

		var erExcweObj = Ext.getCmp('er_excwe');
		erExcweObj.getStore().loadRawData(appConstants.defaultLoadData.excludeWeekCombo);
		erExcweObj.setValue(appConstants.defaultLoadData.sExclweekUI);
			 

		var reportGen = Ext.getCmp('reportGeneration');
		reportGen.getStore().loadRawData(appConstants.defaultLoadData.reportGenerationCombo);
		reportGen.setValue(appConstants.defaultLoadData.sRepGenType);
	},
	closeSetting:function()
	{
		Ext.getCmp('moreOptionCloseId').show();
		var me = this;
		Ext.get('closeSettings').on('click', function() {
		if(me.validateSettings())
		{
			me.validateAndCloseSettings();
		}
		});
	},
	validateAndCloseSettings:function()
	{
		if(this.validateSettings())
		{
			Ext.get('configMod').animate({
				duration: 500,
				to: 
				{
					y: -500
				}
			 });	
			return true;
		}
	},
	closeSettingAndSubmit:function()
	{
		if(this.validateAndCloseSettings())
		{
			this.submitReport();
		}
	},
	validateSettings :function(){
		var reportgen=Ext.getCmp('reportGeneration').getValue();
		if ( reportgen!=null && (reportgen == 'background' || reportgen == 'background-csv')){
			var reportName = Ext.getCmp('bgReportName').getValue();
			if(!validateTextBoxWithSpecialChars(reportName,'Attachment',true))
				return false;
		}		
		return true;
	},
	getQueryString:function()
	{
		var isSettingsOk = true;
		var er_option = Ext.getCmp('er_option').getValue();
		var er_compType = Ext.getCmp('er_compType').getValue();
		var er_Component = Ext.getCmp('er_Component').getValue();
		if(er_Component[0] == '-1')
		{
			this.showMessage(noComponentMsg);
			return false;
		}
		if (er_Component.length > 1 && (er_Component.indexOf('All') > -1 || er_Component.indexOf('all') > -1))
		{
			this.showMessage('Chosen component group not allowed');
			return false;
		}
		var params='&analysisBy='+er_option;
		if(er_option != undefined && er_option != 'Component')
		{
			params += '&er_site='+Ext.getCmp('er_site').getValue();			
		}
		if(!appConstants.enableMultiCompType)
		{
			params += "&er_compType="+er_compType;
		}
		else
		{
			for(var c=0;c<er_compType.length;c++)
			{
				params += "&er_compType="+ er_compType[c];
			}
		}
		for(var c=0;c<er_Component.length;c++)
		{
			params += "&er_Component="+er_Component[c];
		}
		var timeline = Ext.getCmp("er_timeline").getValue();
		var startDate = Ext.getCmp("er_stdate").getValue();
		var startHr = Ext.getCmp("er_sthr").getValue();
		var endDate = Ext.getCmp("er_enddate").getValue();
		var endHr = Ext.getCmp("er_endhr").getValue()
		startDate.setHours(startHr);
		endDate.setHours(endHr); 
		if(!checkDateTime(startDate,endDate))
		{
			return false;
		}
		startDate = Ext.getCmp("er_stdate").dataArray;
		endDate = Ext.getCmp("er_enddate").dataArray;
		startHr = Ext.getCmp("er_sthr").dataArray;
		endHr = Ext.getCmp("er_endhr").dataArray;
		//var params1 = '&er_timeline='+timeline+'&startdate='+startDate+'&enddate='+endDate+'&starthr='+startHr+'&endhr='+endHr+'&startmin='+appConstants.defaultLoadData.startmin+'&endmin='+appConstants.defaultLoadData.endmin+'&inidate='+appConstants.defaultLoadData.inidate;
		var params1 = '&er_timeline='+timeline+'&startdate='+startDate+'&enddate='+endDate+'&starthr='+startHr+'&endhr='+endHr+'&startmin='+mgr_stmin+'&endmin='+mgr_enmin+'&inidate='+appConstants.defaultLoadData.inidate;
		var params2 = '';
		if(isSettingsEnabled)
		{
			var timeFrom = Ext.getCmp("timefrom").getValue();
			var minFrom = Ext.getCmp("minfrom").getValue();
			var timeTo = Ext.getCmp("timeto").getValue();
			var minTo = Ext.getCmp("minto").getValue();
			var exculdeWeek = Ext.getCmp("er_excwe").getValue();
			var rGenType = Ext.getCmp("reportGeneration").getValue();
			var reportName = '';

			if(!checkTimePeriod(timeFrom,minFrom,timeTo,minTo))
			{
				return false;
			}
			if(rGenType != 'foreground')
			{
				reportName = Ext.getCmp("bgReportName").getValue();
				if(!validateTextBoxWithSpecialChars(reportName,'Attachment',true))
				{
					return false;
				}
				params2 += '&bg_reportname='+reportName;
			}
			params2 += '&hourFromUI='+timeFrom+'&minFromUI='+minFrom+'&hourToUI='+timeTo+'&minToUI='+minTo+'&exclweek='+exculdeWeek+'&rGenType='+rGenType+'&er_reportgenration='+rGenType;
			

		}
		var userID   = '&userID='+appConstants.defaultLoadData.loginid;
		params += params1;
		params += params2;
		params += userID;
		params += '&supportedComponents='+appConstants.supportedComponents+'&dataPageNo='+appConstants.currentPage+'&reportType='+appConstants.reportType;
		return params;
	},
	reportGenChange:function()
	{
		Ext.getCmp('resultPanel').hide();
		var reportGenType=Ext.getCmp('reportGeneration').getValue();
		if(reportGenType != 'foreground')
		{
			Ext.getCmp('bgReportName').setValue("");
			Ext.getCmp('bgReportName').show();
			Ext.getCmp('moreOptionCloseId').hide();
			Ext.getCmp('submitViaSetting').show();
		}
		else
		{
			Ext.getCmp('bgReportName').hide();
			Ext.getCmp('submitViaSetting').hide();
			Ext.getCmp('moreOptionCloseId').show();
		}
	},
	showMessage:function(msg)
	{
		Ext.MessageBox.show({
			title: 'Application Crash/Fault Report',
			msg: msg,
			buttons: Ext.MessageBox.OK,
			icon: Ext.MessageBox.WARNING
		});
	},toggleForm:function(obj){
		Ext.getCmp('panelinsidetoggle').show();
		var ornt = Ext.getCmp('mainform');
		if (ornt.isHidden())
		{
			ornt.show();
			Ext.getCmp('selectionDetails').hide();
		}
		else
		{
			ornt.hide();
			Ext.getCmp('selectionDetails').show();
		}
	},
	getNumberFormat:function(value)
	{
		if(!isNaN(value) && !isNaN(parseFloat(value))||value == '-')
		{
			if(value!=null && value.indexOf(".")>-1)
			{
				strDecimal = value.substring(value.indexOf("."));
				str = value.substring(0,value.indexOf("."));
				value='<span class="decimal-align">'+str+'</span><span class="decimal-align2">'+strDecimal+'</span>';
			}
			else
			{
				value='<span class="decimal-align">'+value+'</span>';
			}
		}
		return value;
	},
	loadOverAllPageNavigation:function(other_Info)
	{
		var me = this;
		var overAllRecCount = 0;
		var resultObj = Ext.getCmp('customGridData');
		var isRangeNeed = other_Info['isRangeNeed'];
		var dataPageNo = parseInt(other_Info['dataPageNo']);// current page no		
		var recordPerPage = parseInt(other_Info['recordPerPage']);
		if(dataPageNo > 1)
			overAllRecCount = appConstants.totalRec;
		else
		{
			overAllRecCount = parseInt(other_Info['overAllRecCount']);
			appConstants.totalRec = overAllRecCount;
		}

		var dataPageNo_disp = ((dataPageNo-1)*Math.ceil(recordPerPage/gridPageSize)) + 1; 
	
		if(fromPerBtn)
		{
			dataPageNo_disp = dataPageNo_disp+activePage-1
		}
		
		if(isRangeNeed != 'true' && dataPageNo == 1)
		{
			return;
		}
		else
		{
			var nextDisable = false;
			var perDisable = false;
			var totalPage = Math.ceil(overAllRecCount/gridPageSize);
			if(dataPageNo == 1 && dataPageNo_disp == 1)
				perDisable=true;
			if(dataPageNo_disp == totalPage)
				nextDisable=true;
			var labelText = '<div style="text-align:center">Page '+dataPageNo_disp+' of '+totalPage+'<div>';
			var totatLabelText = '<div style="text-align:right";">Total Records: '+overAllRecCount+'</div>';			
			resultObj.add(
			{
				xtype:'container',
				columnWidth:1.0,
				style:
				{
					'border':'1px solid #C5C4C5',
					'border-top':'0px !important'
				},
				height:28,
				layout: 'column',
				margin: '0 10 10 10',
				padding:'5 0 10 0',
				items:[
				{
					xtype:'container',
					layout: 'hbox',
					columnWidth:.5,
					margin: '0 0 10 0',
					items:[
					{
						xtype:'container',
						width:48,
						margin: '0 0 10 5',
						items:[
						{
							xtype:'button',
							id:'firstPageBtn',
							tooltip: '<b>First Page</b>',
							iconCls: 'al_first_enabled',
							style: {
								background: 'none',
								border: '0px'
							},
							margin: '0 3 0 0',
							currentPage:dataPageNo,
							disabled:perDisable,
							listeners:
							{
								click:function()
								{
									fromPerBtn = false;
									var pageingTool = Ext.getCmp('pageingTool');
									var infolabel = Ext.getCmp('infolabel');
									var last = pageingTool.store.currentPage - 1;
									if(last == 0 && dataPageNo == 1)
										return;
									infolabel.update('<div style="text-align:center">Page '+1+' of '+totalPage+'</div>');
									if(dataPageNo > 1)
									{
										Ext.getCmp('mainform').show();
										Ext.getCmp('selectionDetails').hide(); 
										appConstants.currentPage = 1;
										keepResult = true;
										me.closeSettingAndSubmit();
									}
									else
									{
										Ext.getCmp('firstPageBtn').setDisabled(true);
										Ext.getCmp('customPer').setDisabled(true);
										Ext.getCmp('customNext').setDisabled(false);
										Ext.getCmp('lastPageBtn').setDisabled(false);
										if (pageingTool.fireEvent('beforechange', pageingTool, last) !== false) 
										{
											pageingTool.store.loadPage(1);
										}
									}
								}
							}
						},
						{
							xtype:'button',
							iconCls: 'al_previous_enabled',
							style: {
								background: 'none',
								border: '0px'
							},
							id:'customPer',
							tooltip: '<b>Previous Page</b>',
							currentPage:dataPageNo,
							disabled:perDisable,
							listeners:
							{
								click:function()
								{
									fromPerBtn = false;
									var pageingTool = Ext.getCmp('pageingTool');
									var infolabel = Ext.getCmp('infolabel');
									var last = pageingTool.store.currentPage - 1;
									if(last == 0 && dataPageNo == 1)
										return;
									var temp = ((dataPageNo-1)*Math.ceil(recordPerPage/gridPageSize)) + last; 
									infolabel.update('<div style="text-align:center">Page '+temp+' of '+totalPage+'</div>');
									
									if(last == 0 && dataPageNo > 1)
									{
										Ext.getCmp('mainform').show();
										Ext.getCmp('selectionDetails').hide(); 
										fromPerBtn = true;
										appConstants.currentPage = this.currentPage-1;
										keepResult = true;
										me.closeSettingAndSubmit();
									}
									else
									{
										if(temp == 1)
										{
											Ext.getCmp('customPer').setDisabled(true);
											Ext.getCmp('firstPageBtn').setDisabled(true);
										}
										Ext.getCmp('customNext').setDisabled(false);
										Ext.getCmp('lastPageBtn').setDisabled(false);
										if (pageingTool.fireEvent('beforechange', pageingTool, last) !== false) 
										{
											pageingTool.store.loadPage(last);
										}
									}
								}
							}
						}
						]
					},
					{
						xtype: 'tbseparator',
					},
					{
						xtype:'label',
						width:101,
						id:'infolabel',
						html :labelText
					},
					{
						xtype: 'tbseparator',
					},
					{
						xtype:'container',
						margin: '0 0 10 0',
						width:48,
						items:[
						{
							xtype:'button',
							iconCls: 'al_next_enabled',
							style: {
								background: 'none',
								border: '0px'
							},
							id:'customNext',
							tooltip: '<b>Next Page</b>',
							margin: '0 3 0 0',
							currentPage:dataPageNo,
							disabled:nextDisable,
							listeners:
							{
								'click':function()
								{
									fromPerBtn = false;
									var pageingTool = Ext.getCmp('pageingTool');
									var infolabel = Ext.getCmp('infolabel');
									var next = pageingTool.store.currentPage + 1;
									var temp = ((dataPageNo-1)* Math.ceil(recordPerPage/gridPageSize)) + next; 
									if(temp > totalPage)
										return;
									infolabel.update('<div style="text-align:center">Page '+temp+' of '+totalPage+'</div>');
									
									if(next <= Math.ceil(recordPerPage/gridPageSize))
									{
										Ext.getCmp('customPer').setDisabled(false);
										Ext.getCmp('firstPageBtn').setDisabled(false);
										if(temp == totalPage)
										{
											Ext.getCmp('customNext').setDisabled(true);
											Ext.getCmp('lastPageBtn').setDisabled(true);
										}
										if (pageingTool.fireEvent('beforechange', pageingTool, next) !== false) 
										{
											pageingTool.store.nextPage();
										}
									}
									else
									{
										Ext.getCmp('mainform').show();
										Ext.getCmp('selectionDetails').hide();
										appConstants.currentPage = this.currentPage+1;
										keepResult = true;
										me.closeSettingAndSubmit();
									}
								}
							}
						},
						{
							xtype:'button',
							iconCls: 'al_last_enabled',
							style: {
								background: 'none',
								border: '0px'
							}, 
							id:'lastPageBtn',
							tooltip: '<b>Last Page</b>',
							currentPage:dataPageNo,
							disabled:nextDisable,
							listeners:
							{
								'click':function()
								{
									fromPerBtn = true;
									var pageingTool = Ext.getCmp('pageingTool');
									var infolabel = Ext.getCmp('infolabel');
									var next = Math.ceil(pageingTool.store.totalCount/gridPageSize);
									var temp = ((dataPageNo-1)* Math.ceil(recordPerPage/gridPageSize)) + next; 
									if(temp > totalPage)
										return;
									infolabel.update('<div style="text-align:center">Page '+totalPage+' of '+totalPage+'</div>');
									
									if(dataPageNo == Math.ceil(overAllRecCount/recordPerPage))
									{
										Ext.getCmp('customPer').setDisabled(false);
										Ext.getCmp('firstPageBtn').setDisabled(false);
										Ext.getCmp('customNext').setDisabled(true);
										Ext.getCmp('lastPageBtn').setDisabled(true);
										if (pageingTool.fireEvent('beforechange', pageingTool, next) !== false) 
										{
											pageingTool.store.loadPage(next);
										}
									}
									else
									{
										Ext.getCmp('mainform').show();
										Ext.getCmp('selectionDetails').hide();
										appConstants.currentPage = Math.ceil(overAllRecCount/recordPerPage);
										keepResult = true;
										me.closeSettingAndSubmit();
									}
								}
							}
						}
						]
					},
					{
						xtype: 'tbseparator',
					},
					{
						xtype:'container',
						width:25,
						margin: '0 0 10 0',
						items:[
						{
							xtype:'button',
							iconCls: 'al_refresh_enabled',
							style: {
								background: 'none',
								border: '0px'
							},
							margin: '0 0 0 0',
							currentPage:dataPageNo,
							listeners:
							{
								click:function()
								{
									var pageingTool = Ext.getCmp('pageingTool');
									var infolabel = Ext.getCmp('infolabel');
									var last = pageingTool.store.currentPage ;
									if (pageingTool.fireEvent('beforechange', pageingTool, last) !== false) 
									{
										pageingTool.store.loadPage(last);
									}
								}
							}
						}]
					}]
				},
				{
					xtype:'container',
					margin: '0 0 0 0',
					columnWidth:.5,
					layout :
					{
						type : 'hbox',
						pack : 'end'
					},
					items:
					{
						xtype:'label',
						html :totatLabelText
					}
				}]
			});
		}
	},
	loadCustomGrid:function(jsonData)
	{
		var resultPanelObj = Ext.getCmp('resultPanel');
		var userViewSubCol = jsonData.userDetailCol.userViewSubColumn;
		var userGridArray = jsonData.allFailGridData;
		var gridTitle = jsonData.gridTitle;
		var userViewColunmArray = new Array();
		var me = this;
		//var userGridArray=new Array();
		var userDetailsFields = new Array();
		for(var key in userViewSubCol)
		{
			var align = 'left';
			var mainColumn = userViewSubCol[key];
			userDetailsFields.push(mainColumn);
			userViewColunmArray.push({
				header: mainColumn,
				sortable: true,
				resizable :true,
				//flex:1,
				align:align,
				dataIndex: mainColumn,
				renderer :function(value, metaData, record, row, col, store, gridView)
				{
					metaData.tdAttr = 'data-qtip="' + value + '"';
					return value;
				},
				doSort: function(state) 
				{
					var ds = this.up('grid').store;
					var field = this.getSortParam();
					ds.sort({
						property: field,
						direction: state,
						sorterFn: function(v1, v2)
						{
							v1 = v1.get(field);
							v2 = v2.get(field);
							if(v1.indexOf('.')>-1)
							{
								var tmp = v1.substring(0, v1.lastIndexOf(' '));

								var dateobj=new Date(Ext.Date.parse(tmp, mgrDateFormat));
								var formDate = Ext.Date.dateFormat(dateobj, getExtjsDateFormat('MMM-dd-yyyy'));
								v1 = formDate + v1.substring(v1.lastIndexOf(' '), v1.length);
							}
							if(v2.indexOf('.')>-1)
							{
								var tmp = v2.substring(0, v2.lastIndexOf(' '));

								var dateobj=new Date(Ext.Date.parse(tmp, mgrDateFormat));
								var formDate = Ext.Date.dateFormat(dateobj, getExtjsDateFormat('MMM-dd-yyyy'));
								v2 = formDate + v2.substring(v2.lastIndexOf(' '), v2.length);
							}
							if(!isNaN(new Date(v1)) && !isNaN(new Date(v2)))
							{
								v2=new Date(v2).getTime(); 
								v1=new Date(v1).getTime(); 
							}
							else if(!isNaN(v1) && !isNaN(v2))
							{
							v1 = Ext.isNumber(v1) ? v1 : parseFloat(String(v1), 10);
								v2 = Ext.isNumber(v2) ? v2 : parseFloat(String(v2), 10);
								if (state=='ASC')
								{
									v1= isNaN(v1) ? 999999 : v1;
									v2= isNaN(v2) ? 999999 : v2;
								}
								else
								{
							v1= isNaN(v1) ? 0 : v1;

							v2= isNaN(v2) ? 0 : v2;
								}
							}
							
							// transform v1 and v2 here
							return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
							}
						});
				},
			});	
		}
		
		var isPagingHidden=false;
		
		 if (userGridArray!=undefined && userGridArray.length<gridPageSize)
			isPagingHidden=true;
		else
			isPagingHidden=false;

		var failDetailsObj=Ext.create('Ext.data.Store', {
			fields:userDetailsFields,
			proxy: {
				type: 'pagingmemory',
				reader: {
					type: 'array', root : 'data', totalProperty : 'total'
				}
			},
			data : userGridArray,
			pageSize:gridPageSize,
			autoLoad : true,
		});

		var activePage=1;
		var userGridpanel = Ext.widget('customgrid',{
			store:failDetailsObj,
			sortableColumns:false,
			columnWidth:1.0,							
			ui:'newGridPanel',
			border:true,							
			id:'vengat3',
			margin:'10 10 0 10',
			columns:userViewColunmArray,
			scroll:true,
			autoScroll:true,
			forceFit:true,
			viewConfig:
			{
				stripeRows: true,
				getRowClass: function (record, rowIndex, rowParams, store)
				{
					if (record.raw.length>0)
					{
						return ;
					}
					else
					{
						return 'hidePlus';
					}
				}
			},
			listeners:{
				sortchange:function(ct, column, e, t, eOpts ){
					me.gridColIndexParam=column.getIndex();
					me.gridColStateParam=column.sortState;
					this.getStore().loadPage(activePage);
				},
				render:function(obj){
					Ext.defer(function() {
					},100);
				}
			},
			dockedItems:[{
				xtype:'pagingtoolbar',
				cls:'newPagination',
				dock: 'bottom',
				displayInfo: true,
				id:'pageingTool',
				store: failDetailsObj,
				hidden:isPagingHidden,
				displayInfo: true,
				displayMsg: 'Displaying topics {0} - {1} of {2}',
				emptyMsg: "No topics to display",
				hidden:true,
				listeners: {
					change : function(thisd, params)
					{
						if(!Ext.isEmpty(params))
							activePage = params.currentPage;
						else
							activePage=1;
					}
				}
			}]
		});
		gridChartAry = new Array();
		gridChartAry.push(userGridpanel);
		resultPanelObj.add({
			xtype:'panel',
			id:'customGridData',
			title:gridTitle,
			margin:'10 10 0 10',
			padding:'0 0 0 0',
			columnWidth:1.0,
			ui:'newGraphPanel',
			layout:{
				type:'column',
				align:'stretch',
			},
			items:gridChartAry
		});
		this.getNomeasurepanel().hide();
	},
	exportDataAlert:function()
	{
		Ext.MessageBox.show({
			title: 'Alert',
			msg: 'Exporting the report may take too long to complete. Choose the Background option to export this report',
			buttons: Ext.MessageBox.OK,
			icon: Ext.MessageBox.WARNING
		});
	}
});