Ext.define('MailExchangeReport.controller.Main', {
	extend: 'Ext.app.Controller',
	gridColStateParam:'ASC',//deafult 1 for ascending
	gridColIndexParam:-1,//added for updating sort by option
	views: ['Main'],
	refs: [{
		selector: 'main',
		ref: 'main'
	}, {
		selector: 'newUtilities',
		ref: 'newUtilities'
	},{
		selector: 'ReporterSettings',
		ref: 'ReporterSettings'
	}, {
		selector: 'resultpanel',
		ref: 'resultpanel'
	},
	{selector:'nomeasurepanel', ref:'nomeasurepanel'},
	{selector: 'backGroundPanel',ref: 'backGroundPanel'}
	],
	init: function () {
		this.control({
			'newUtilities': {
				'afterrender': this.loadTools
			},
			'main': {
				'boxready': this.afterMainRender
			},
			'reportsettings': {
				'afterrender': this.loadSettings
			},
			'zonereportform combo[name="er_comptype"]': {
				'select': this.ComponentsChange
			},
			'zonereportform combo[name="eventfor"]':{
				'select': this.ZonSegServChange
			},
			'zonereportform combo[name="er_option"]':{
				'select': this.ReloadFields
			},
			/*'reportsettings combo[name="er_excwe"]': {
				'select': this.weekendOnChange
			},*/
			'reportsettings button[id="moreOptionCloseId"]':{	 
				'click':this.validateAndCloseSettings
			},
			'reportsettings button[id="submitViaSetting"]':{
				'click':this.closeAndSubmitSettings
			},
			'reportsettings combo[name="reportGeneration"]': {
				'select': this.reportGenChange
			},
			'zonereportform button[name="submit"]': {
				'click': this.showResult
			},
			'zonereportform button[name="save"]': {
				'click': this.goTo
			},
			'timeline combo[name="er_mode"]':
			 {
				'select': this.changeEr_mode
			 },
			'egcomponent trigger[id="compsearch"]':{
				'change': this.filterMultiselect
			},
			'egcomponent button[id="expandSelector"]':
			{
				'click': this.expandMe
			},
			'newUtilities > #printTool > button': {
				'click': this.printFile
			},
			'newUtilities > #saveTool > button': {
				'click': this.saveReportAsPDF
			},
			'newUtilities > #mailTool > button': {
				'click': this.sendMail
			},
			'newUtilities > #scheduleTool > button': {
				'click': this.saveSchedule
			},
			'newUtilities > #favoriteTool > button': {
				'click': this.saveFavorite
			},
			  'zonereportform button[id="panelinsidetoggle"]': {
				'click': this.toggleForm
			},
			'resultpanel': {
				'render': this.resizePanel
			}
		});
	},
	showConfigDropdown:function(){
			isSettingsEnabled=true;
			var thisController = this;
			//var tpl = new Ext.XTemplate('<div style="float:left;margin:0px 0px 0px 0px;" class="settingsfont"><b>MORE OPTIONS</b></div><div style="text-align:right;float:right;"><div class="iconCloseNew" id="closeSettings"></div></div>');
			var tpl = new Ext.XTemplate('<div style="float:left;margin:0px 0px 0px 0px" >More Options</div><div style="text-align:right;float:right;"><div class="iconCloseNew" id="closeSettings"></div></div>');
			Ext.create('Ext.container.Container',{
			width:565,
			//padding:5,
			id:'configMod',
			//cls:'configMode_popup',
			ui:'settingsWindowContainer',
			items:[
				{
					xtype:'container',
					cls:'configMode_popupArrow',
					style:{'top':'-14px','left':'355px'}
				},
				{
					xtype:'container',
					cls:'containerHeader',
					html:tpl.apply(),
					style:{'top':'0px','margin':'0px'}
				},
				{
					xtype:'reportsettings',
					parent:this
				}
			],
			onRender:function(){
				Ext.EventManager.onWindowResize(function () {
					Ext.get('configMod').setStyle('left', '');
				});
				Ext.get('closeSettings').on('click', function () {
					thisController.validateAndCloseSettings();
				});
			},
			renderTo:'MailExchangeReport-body',
			});
			//Ext.getCmp('moreOptionCloseId').show();
	},
	closeAndSubmitSettings : function()
	{
		if(this.validateAndCloseSettings())
		{
			this.showResult();
		}
	},
	validateAndCloseSettings :  function()
	{
		var timefrom = Ext.getCmp('timefrom').getValue();
		var minfrom = Ext.getCmp('minfrom').getValue();
		var timeto = Ext.getCmp('timeto').getValue();
		var minto = Ext.getCmp('minto').getValue();
		if (!checkTimePeriod(timefrom, minfrom, timeto, minto)) {
			return false;
		}
		if (Ext.getCmp('reportGeneration').getValue() == 'background' && !validateTextBoxWithSpecialChars(Ext.getCmp('bgReportName').getValue(),'Attachment',true))
		{
			return false;
		}
		Ext.getCmp('submit').setDisabled(false);
		Ext.get('configMod').animate({duration: 500,to: {y: -500}});
		return true;
	},
	goTo: function(btn){
		var from_sch = appConstants.publicjsonData['hiddenfields']['fromScheduleModify'];
		 if (from_sch != null && from_sch == "Yes")
			 this.saveSchedule(btn);
		 else
			 this.saveFavorite(btn);
	},
	resizePanel: function () {
		var me = this;
		Ext.EventManager.onWindowResize(function () {
			if (!Ext.isEmpty(appConstants.publicGridData)) {
			}
		});
	},
	  changeEr_mode: function (combo) {
		var hiddenFields = appConstants.publicjsonData.hiddenfields;
		var from_schModify = hiddenFields["fromScheduleModify"];
		var favorite_id = hiddenFields["favorite_id"];
		if (!(favorite_id == 'undefined' || favorite_id == undefined) || !(from_schModify == null || from_schModify == 'null'))
		{
			return;
		}
		if (isSettingsEnabled)
		{
			Ext.get('configMod').animate({
						duration: 250,
						to: {
							y: -530
						}
					});
		}
		this.showResult();
	 },
	toggleForm:function(obj)
	{
		Ext.getCmp('panelinsidetoggle').show();
		var ornt = Ext.getCmp('zonereportform');
		if (ornt.isHidden())
		{
			ornt.show();
			Ext.getCmp('selectionDetails').hide();
		}
		else
		{
			ornt.hide();
			Ext.getCmp('selectionDetails').show();
		}
	},
	sendMail: function () {
		Ext.widget('sendmail').show();
	 },
	saveSchedule: function (btn) {
		var isValid = this.validateMainForm();
		if (isValid && Ext.getCmp('er_timeline').getValue() == 'Any') {
			Ext.MessageBox.show({
				title: 'Outbound Domains Report',
				msg: 'Chosen timeline not allowed',
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
			});
			isValid = false;
		}
		if (isValid) {
				this.updateQueryString();
				var qryStr=null;
				var target= "/final/reporter/ErSaveSchedule.jsp?" + appConstants.queryString+"&com.eg.CSRF_NONCE="+csrfToken;
				if (btn.getId()=='save')
				{
					target+='&showSchWindow=no';
					var urlNw=target.substr(0,target.indexOf("?"));
					var queryString=target.substr(target.indexOf("?")+1,target.length-1);
					var formSave = Ext.create('Ext.form.Panel');
					formSave.submit({
						url:urlNw,
						params:queryString,
						standardSubmit: true,
						method: 'POST'
					});
				}
				else
				parent.scheduleWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
		}
	},
	saveFavorite: function (btn) {
		var isValid = this.validateMainForm();
		/* if (isValid && Ext.getCmp('er_timeline').getValue() == 'Any') {
			Ext.MessageBox.show({
				title: 'Outbound Domains Report',
				msg: 'Chosen timeline not allowed',
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
			});
			isValid = false;
		} */
		if (isValid) {
			this.updateQueryString();
			var hiddenFields = appConstants.publicjsonData.hiddenfields;
			var favorite_id = hiddenFields["favorite_id"];
			var target = "../servlet/com.eg.ErFavoriteC?" + appConstants.queryString + "&er_view=GRAPH&cmd=client&FavoriteId="+favorite_id+"&er_RmDispName="+appConstants.er_RmDispName+"&com.eg.CSRF_NONCE="+csrfToken;
			if (btn.getId()=='save')
			{
					target+='&showSchWindow=no';
					var urlNw=target.substr(0,target.indexOf("?"));
					var queryString=target.substr(target.indexOf("?")+1,target.length-1);
					var formSave = Ext.create('Ext.form.Panel');
					formSave.submit({
						url:urlNw,
						params:queryString,
						standardSubmit: true,
						method: 'POST'
					});
			}
			else
				parent.favouriteWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
		}
	},
	showResult: function ()
	{
		Ext.getCmp('panelinsidetoggle').setDisabled(false);
		var stDateTime = Ext.getCmp('er_stdate').getValue();
		var tmpStartHour = Ext.getCmp('er_sthr').getValue();
		stDateTime.setHours(tmpStartHour);
		var enDateTime = Ext.getCmp('er_enddate').getValue();
		var tmpEndHour = Ext.getCmp('er_endhr').getValue();
		enDateTime.setHours(tmpEndHour);
		var result = checkDateTime(stDateTime, enDateTime);
		if (!result)
		{
			return;
		}
		if (this.validateMainForm() && this.validateSettings())
		{
			this.submitReport();
		}
	},
	validateMainForm: function () {
		var zone = Ext.getCmp('er_option');
		var componenttype = Ext.getCmp('er_comptype');
		if (zone.getValue() == '-1') {
			Ext.MessageBox.show({
				title: 'Outbound Domains Report',
				msg: zone.getStore().getAt(0).get('displayField'),
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
			});
			return false;
		}
		if (componenttype.getValue() == '-1') {
			Ext.MessageBox.show({
				title: 'Outbound Domains Report',
				msg: componenttype.getStore().getAt(0).get('displayField'),
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
			});
			return false;
		}
		return true;
	},
	validateSettings: function () {
		var localhiddens=appConstants.publicjsonData['hiddenfields'];
		var isSettingsOk = true;
		var MaxDaysInMonth = localhiddens['getMaxDaysInMonth'];
		var er_usertimeline = localhiddens['userTimeline'];
		var reportgen;
		if (isSettingsEnabled)
		{
			reportgen= Ext.getCmp('reportGeneration').getValue();
		}
		else
		{
			reportgen= appConstants.publicjsonData.reportGeneration;
		}

		var er_timeline = Ext.getCmp('er_timeline').getValue();
		var stDate = Ext.getCmp('er_stdate').getValue();
		var enDate = Ext.getCmp('er_enddate').getValue();
		var startHour = Ext.getCmp('er_sthr').getValue();
		var endHour = Ext.getCmp('er_endhr').getValue();
		stDate.setHours(startHour);
		enDate.setHours(endHour);
		if (!checkDateTime(stDate, enDate)) {
			isSettingsOk = false;
		}
		var usertimelineValid=true;
		if (er_usertimeline != null && er_usertimeline != '-1') {
			
			usertimelineValid = isUserTimelineLimitExceeded(er_usertimeline, MaxDaysInMonth, stDate, enDate);
						
			if (!usertimelineValid) {
				Ext.MessageBox.show({
					title: 'Outbound Domains Report Settings',
					msg: _invalidUserTime,
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
				});
				isSettingsOk = false;
			}
		}
		if (reportgen != null && reportgen == 'foreground' && usertimelineValid) {
			var limitforbg = localhiddens['limitforbg']
			if (!Ext.isEmpty(limitforbg)) {
				if (!checkTimeLineForBgLimit(limitforbg, MaxDaysInMonth, stDate, enDate)) {
					Ext.MessageBox.confirm('Confirm', appConstants.forGrdReportConfirmMsg, this.showConfirmResult, this);
					isSettingsOk = false;
				}
			}
		} else if(usertimelineValid) {
			var reportName;
			if (isSettingsEnabled)
			{
				reportName= Ext.getCmp('bgReportName').getValue();
			}
			else
			{
				reportName= appConstants.publicjsonData.bgReportName;
			}
			if (!validateTextBoxWithSpecialChars(reportName,'Attachment',true))
				isSettingsOk = false;
		}
		return isSettingsOk;
	},
	showConfirmResult: function (btn) {
		if (btn == "yes") {
			var getButtonObj = Ext.getCmp('submit');
			getButtonObj.setDisabled(false);
			if (isSettingsEnabled)
			{
				Ext.get('configMod').animate({
					duration: 500,
					to: {
						y: -500
					}
				});
			}
			this.submitReport();
		}
		else
		{
			if (!isSettingsEnabled)
			{
				this.getReporterSettings().down('button').fireHandler();
			}
			var reportGenType = Ext.getCmp('reportGeneration');
			var bgreportNameObj = Ext.getCmp('bgReportName');
			reportGenType.setValue('background');
			bgreportNameObj.setValue("");
			bgreportNameObj.show();
			bgreportNameObj.focus(false, 1000);
			this.showResult();
		 }
	},
	getGridColSortParam:function(query)
	{
		var qindex=query.indexOf('er_sortby');
		if (qindex > -1)
		{
			var delVar;
			var qsub=query.substring(qindex+10,qindex+12);
			if (qsub=='-1')
			{
				delVar='er_sortby='+qsub;
			}
			else
			{
				delVar='er_sortby='+parseInt(qsub);
			}
			query=query.replace(delVar,'er_sortby='+this.gridColIndexParam);
		}
		else
		{
			query+='&er_sortby='+this.gridColIndexParam;
		}
		if (this.gridColStateParam=='ASC')
			this.gridColStateParam='1';
		else
			this.gridColStateParam='0';
		return query+'&orderBy='+this.gridColStateParam;
	},
	filterMultiselect: function (obj) {
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		appConstants.erUtils.filterComboStore(obj,Ext.getCmp('compNameList'),appConstants.publicjsonData['componentsCombo']);
		 obj.toggleTriggger();
    },
	expandMe:function(btn){
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		appConstants.erUtils.expandMultiComboButton(Ext.getCmp('compNameList'),Ext.getCmp('systemLabel').text,btn);
	},
	printFile: function () {
		var saveQString = appConstants.publicjsonData.saveQString;
		var s_qryString = "../servlet/com.eg.ErExchangeMailReportC?" + saveQString;
		s_qryString += "printGraph=yes&opt=chart&pdfPrint=yes&chartType=bar&er_view=PRINT&chartType=pie";
		s_qryString=this.getGridColSortParam(s_qryString);

		parent.printWindowFn(s_qryString); //this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp

	},
	saveReportAsPDF: function () {
		var saveQString = appConstants.publicjsonData.saveQString;
		var s_qryString = "../reporter/ErHtmlToSavePdf.jsp?" + saveQString;
		s_qryString += "printGraph=yes&opt=chart&chartType=bar&er_view=PRINT&chartType=pie";
		s_qryString=this.getGridColSortParam(s_qryString);

		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		appConstants.erUtils.savePDF(s_qryString);
	},
	bookletQuery: function(obj)
	{
		var s_qryString = saveQString;
		s_qryString += "printGraph=yes&opt=chart&chartType=bar&er_view=PRINT&chartType=pie";
		s_qryString=this.getGridColSortParam(s_qryString);

		return s_qryString;
	},
	bookletScheduleQuery: function(obj)
	{
		var bookletquery=appConstants.queryString;
		return bookletquery;
	},
	bookletPreview:function()
	{
		this.printReport();
	},
	disableTools: function () {
		Ext.getCmp("saveTool").setDisabled(true);
		Ext.getCmp("bookletTool").setDisabled(true);
		Ext.getCmp("printTool").setDisabled(true);
		Ext.getCmp("mailTool").setDisabled(true);
		Ext.getCmp("csvTool").setDisabled(true);
	},
	getXmlForUrl: function (URL) {
		try {
			var chartAttrib;
			Ext.Ajax.request({
				url: URL,
				method: 'GET',
				async: false,
				success: function (response) {
					var jsonText = response.responseText;
					chartAttrib = Ext.decode(jsonText);
				},
				failure: function () {
					alert('I am not loading...' + URL);
				}
			});
			return chartAttrib;
		} catch (e) {
			alert('[Exception] ' + e);
		}
	},
	loadGrid: function (GridData) {

		var me=this;
		var resultPanelObj = Ext.getCmp('resultPanel');
		/*
		resultPanelObj.add({
							xtype:'container',
							columnWidth:1,
							html:"<br>",
							id:'html_content_br'
						});
		*/
		if (!Ext.isEmpty(GridData))
		{
			var gridColumn=GridData.columns;

 			var gridData=GridData.dataArray;
			var mainColArray=new Array();
			var fieldsToStore=new Array();
			var v=0;
			var setWidth=60;
			for (var key in gridColumn)
			{
				
				var align='center';
				mainColumn = gridColumn[key];
				fieldsToStore.push(mainColumn);
				if(key == 0)
					align='left';
				mainColArray.push({
					header: mainColumn,
					sortable: true,
					width:setWidth,
					align:align,
					dataIndex: mainColumn,
 					doSort: function(state) {
								var ds = this.up('grid').store;
								var field = this.getSortParam();
								ds.sort({
									property: field,
									direction: state,
									sorterFn: function(v1, v2){
										v1 = v1.get(field);
										v2 = v2.get(field);
										if(v1=='-')
											return -1;
										else if(v2=='-')
											return 1;

										if(field!=undefined && (field=='Domain'||field=='Total Mails Sent'||field=='Total Mails Size'||field=='Average'))
											return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);

										if(field!=undefined && (field=='Domain'||field=='Total Mails Sent'||field=='Total Mails Size'||field=='Average'))
										{
											if(!isNaN(new Date(v1)) && !isNaN(new Date(v2)))
											{
												v2=new Date(v2).getTime(); 
												v1=new Date(v1).getTime(); 
												return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
											}
										}
										v1 = Ext.isNumber(v1) ? v1 : parseFloat(String(v1), 10);
										v1= isNaN(v1) ? 0 : v1;

										v2 = Ext.isNumber(v2) ? v2 : parseFloat(String(v2), 10);
										v2= isNaN(v2) ? 0 : v2;

										// transform v1 and v2 here
										return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
							}
						}); 
					}
				});
			}
		var isPagingHidden;
		var gridPageSize=15;
 		if (gridData.length<gridPageSize)
			isPagingHidden=true;
		else
			isPagingHidden=false;	
				
 			var storeObj=Ext.create('Ext.data.Store', {
						fields:fieldsToStore,
						proxy : {
							type : 'pagingmemory',
							reader : {
								type: 'array', root : 'data', totalProperty : 'total'
							}
						},
						pageSize:gridPageSize,
						data : gridData,
						autoLoad : true,
			});
			var activePage=1;
			resultPanelObj.add({
				xtype:'panel',
				ui:'newGraphPanel',
				margin:'10 10 10 10',
				title:"<span class='newfont_bold15'>Details of "+appConstants.detailsFor+"bound Domains</span>",
				items:[{
					xtype:'customgrid',
					ui:'newGridPanel',
					store:storeObj,
					sortableColumns:true,
					align:'center',
					columns:mainColArray,
					//width:"100%",
					forceFit:true,
					frame:false,
					border:true,
					margin:'0 10 10 10',
					//style: 'margin:0 auto;margin-top:0px;',
					//title:"<span class='font_bold'>Details of "+appConstants.detailsFor+"bound Domains</span>",
					// title:"<span class='newfont_bold15'>Details of "+appConstants.detailsFor+"bound Domains</span>",
					listeners:{
						sortchange:function(ct, column, e, t, eOpts ){
							me.gridColIndexParam=column.getIndex();
							me.gridColStateParam=column.sortState;
							this.getStore().loadPage(activePage);
						},
					},
					dockedItems:[{
									xtype:'pagingtoolbar',
									cls:'newPagination',
									dock: 'bottom',
									displayInfo: true,
									store: storeObj,
									hidden:isPagingHidden,
									displayInfo: true,
									displayMsg: 'Displaying topics {0} - {1} of {2}',
									emptyMsg: "No topics to display",
									listeners: {
										change : function(thisd, params)
										{   
											if(!Ext.isEmpty(params))
												activePage = params.currentPage;
											else
												activePage=1;
										}

										}
					
					}]
				}]		
			});
			//resultPanelObj.add(gridpanel);
		}
	},
	loadReportData: function (jsonData) {
		var dataAvailable = false;
		this.getNomeasurepanel().hide();
		this.getBackGroundPanel().hide();
		var resultPanelObj = Ext.getCmp('resultPanel');
		Ext.select('.dataPanel ').setStyle('border-width','1px');
		var backgroundresultsObj = Ext.getCmp('backgroundresults');
		var reportGeneration = appConstants.publicjsonData.reportGeneration;
		if (reportGeneration == 'foreground')
		{
			resultPanelObj.removeAll();
			itemsArray = new Array();
			var reportData = jsonData.reportData;
			appConstants.initLdgMask.hide();
			var selectionDetailsjson = jsonData.selectionDetails;
			if (jsonData.data_found=='true') {
				Ext.getCmp("saveTool").setDisabled(false);
				Ext.getCmp("bookletTool").setDisabled(false);
				Ext.getCmp("printTool").setDisabled(false);
				Ext.getCmp("mailTool").setDisabled(false);
				Ext.getCmp("csvTool").setDisabled(true);
				var reportData = jsonData.reportData;
				var summary_data = '<div class="x-table"><table class="x-grid-table x-grid-table-resizer"><tr class="x-grid-row"><td class="x-grid-cell"><div style="padding:5px;">Unique Domains (Number)</div></td><td class="x-grid-cell" style="pading:5px;"><div style="padding:5px;">'+jsonData.domainCounts+'</div></td></tr></table>';
				var doamindetails="Sent";
				if(appConstants.detailsFor!=null && appConstants.detailsFor=='In')
				{
					doamindetails="Received";
					summary_data+= '<div class="x-table"><table class="x-grid-table x-grid-table-resizer"><tr class="x-grid-row"><td class="x-grid-cell"><div style="padding:5px;">Received Mails (Number) </div></td><td class="x-grid-cell" style="pading:5px;"><div style="padding:5px;">'+jsonData.totalSentMails+'</div></td></tr></table>';
					summary_data+= '<div class="x-table"><table class="x-grid-table x-grid-table-resizer"><tr class="x-grid-row"><td class="x-grid-cell"><div style="padding:5px;">Size of Received Mails (MB) </div></td><td class="x-grid-cell" style="pading:5px;"><div style="padding:5px;">'+jsonData.totalMailSize+'</div></td></tr></table>';
				}
				else
				{
					summary_data+= '<div class="x-table"><table class="x-grid-table x-grid-table-resizer"><tr class="x-grid-row"><td class="x-grid-cell"><div style="padding:5px;">Sent Mails (Number) </div></td><td class="x-grid-cell" style="pading:5px;"><div style="padding:5px;">'+jsonData.totalSentMails+'</div></td></tr></table>';
					summary_data+= '<div class="x-table"><table class="x-grid-table x-grid-table-resizer"><tr class="x-grid-row"><td class="x-grid-cell"><div style="padding:5px;">Size of Sent Mails (MB) </div></td><td class="x-grid-cell" style="pading:5px;"><div style="padding:5px;">'+jsonData.totalMailSize+'</div></td></tr></table>';
				}
				var chartbox="";
				if(appConstants.detailsFor!=null && appConstants.detailsFor=='In')	 
				{
					chartbox={
					//xtype:'container',
					xtype:'panel',
					//cls:'selectionDetailsBorder',
					ui:'newGraphPanel',
					padding:10,
					margin:'10 10 10 10',
					flex:1,
					layout:{
						type:'hbox',
						align:'center'
					},
					defaults:{
						flex:1,
						//cls:'smallIconBox',
					},
					items:[
						{
							xtype:'container',
							autoSize: true,
							align:'stretch',
							height:'auto',
							layout:{
								type:'vbox',
								align:'center',
								pack:'center'
							},
							defaults: {
								padding:'6px 5px 5px 5px',
							},
							items: [
							{
								xtype:'container',
								html:'<table align="center" ><tr><td align="center" nowrap><div style="display:flex;justify-content:center;align-items:center"><div class="iconUniqueDomains"/></div><div class="newFont_bold28" style="margin:5px;">'+jsonData.domainCounts+'</div></div></td></tr><tr><td align="center"  width="100%" style="padding:5px 5px 10px 5px"><span class="newFont_normal13">Unique Domains</span><span class="newFont_normal11" style="line-height:10px">&nbsp;(Number)</span></td></tr></table>'
							}]
						},
						{
							xtype:'container',
							autoSize: true,
							align:'stretch',
							height:'auto',
							layout:{
								type:'vbox',
								align:'center',
								pack:'center'
							},
							defaults: {
								padding:'6px 5px 5px 5px',
							},
							items: [
							{
								xtype:'container',
								html:'<table align="center" ><tr><td align="center" nowrap><div style="display:flex;justify-content:center;align-items:center"><div class="iconReceiveMails"/></div><div class="newFont_bold28" style="margin:5px;">'+jsonData.totalSentMails+'</div></div></td></tr><tr><td align="center"  width="100%" style="padding:5px 5px 10px 5px"><span class="newFont_normal13">'+doamindetails+' Mails</span><span class="newFont_normal11" style="line-height:10px">&nbsp;(Number)</span></td></tr></table>'
							}]
						},
						{
							xtype:'container',
							autoSize: true,
							align:'stretch',
							height:'auto',
							layout:{
								type:'vbox',
								align:'center',
								pack:'center'
							},
							defaults: {
								padding:'6px 5px 5px 5px',
							},
							items: [
							{
								xtype:'container',
								html:'<table align="center" ><tr><td align="center" nowrap><div style="display:flex;justify-content:center;align-items:center"><div class="iconReceiveMailsSize"/></div><div class="newFont_bold28" style="margin:5px;">'+jsonData.totalMailSize+'</div></div></td></tr><tr><td align="center"  width="100%" style="padding:5px 5px 10px 5px"><span class="newFont_normal13">Size of '+doamindetails+' Mails</span><span class="newFont_normal11" style="line-height:10px">&nbsp;(MB)</span></td></tr></table>'
							}]
						},
					]
				};
				}
				else
				{
					chartbox={
						xtype:'panel',
						//cls:'selectionDetailsBorder',
						padding:10,
						margin:'10 10 10 10',
						ui:'newGraphPanel',
						flex:1,
						layout:{
							type:'hbox',
							align:'center'
						},
						defaults:{
							flex:1,
							//cls:'smallIconBox',
						},
						items:[
							{
								xtype:'container',
								autoSize: true,
								align:'stretch',
								height:'auto',
								layout:{
									type:'vbox',
									align:'center',
									pack:'center'
								},
								defaults: {
									padding:'6px 5px 5px 5px',
								},
								items: [
								{
									xtype:'container',
									html:'<table align="center" ><tr><td align="center" nowrap><div style="display:flex;justify-content:center;align-items:center"><div class="iconUniqueDomains"/></div><div class="newFont_bold28" style="margin:5px;">'+jsonData.domainCounts+'</div></div></td></tr><tr><td align="center"  width="100%" style="padding:5px 5px 10px 5px"><span class="newFont_normal13">Unique Domains</span><span class="newFont_normal11" style="line-height:10px">&nbsp;(Number)</span></td></tr></table>'
								}]
							},
							{
								xtype:'container',
								autoSize: true,
								align:'stretch',
								height:'100%',
								layout:{
									type:'vbox',
									align:'center',
									pack:'center'
								},
								defaults: {
									padding:'6px 5px 5px 5px',
								},
								items: [
								{
									xtype:'container',
									html:'<table align="center" ><tr><td align="center" nowrap><div style="display:flex;justify-content:center;align-items:center"><div class="iconSentMails"/></div><div class="newFont_bold28" style="margin:5px;">'+jsonData.totalSentMails+'</div></div></td></tr><tr><td align="center"  width="100%" style="padding:5px 5px 10px 5px"><span class="newFont_normal13">'+doamindetails+' Mails</span><span class="newFont_normal11" style="line-height:10px">&nbsp;(Number)</span></td></tr></table>'
								}]
							},
							{
								xtype:'container',
								autoSize: true,
								align:'stretch',
								height:'100%',
								layout:{
									type:'vbox',
									align:'center',
									pack:'center'
								},
								defaults: {
									padding:'6px 5px 5px 5px',
								},
								items: [
								{
									xtype:'container',
									html:'<table align="center" ><tr><td align="center" nowrap><div style="display:flex;justify-content:center;align-items:center"><div class="iconSentMailsSize"/></div><div class="newFont_bold28" style="margin:5px;">'+jsonData.totalMailSize+'</div></div></td></tr><tr><td align="center"  width="100%" style="padding:5px 5px 10px 5px"><span class="newFont_normal13">Size of '+doamindetails+' Mails</span><span class="newFont_normal11" style="line-height:10px">&nbsp;(MB)</span></td></tr></table>'
								}]
							}]
					};
				}
					resultPanelObj.add(chartbox);
					resultPanelObj.doLayout();

					var content='<div style="width:100%"><table width="100%"  class="htmlGraphTable" style="border:0px;background-color:transparent"><col width="50%"><col width="50%"><tr>';
					content+='<td style="padding:0px 5px 0px 0px">';

					content+='<div width="100%" class="graphMainDiv" >';
					content+='<div class="htmlGraphTableHeader">';
					content+=jsonData.pie_title;
					content+='</div>';
					content+='<div id="pie_id" style="height:330px;width:100%;overflow:auto;padding:10px" class="htmlGraphTableBody">';
					content+='</div>';
					content+='</div></td>';


					content+='<td style="padding:0px 0px 0px 5px">';
					content+='<div width="100%" class="graphMainDiv">';
					content+='<div class="htmlGraphTableHeader">';
					content+=jsonData.bar_title;
					content+='</div>';
					content+='<div id="bar_id" style="height:330px;width:100%;overflow:auto;padding:10px" class="htmlGraphTableBody">';
					content+='</div>';
					content+='</div></td>';
					content+='</tr></table></div>';

					resultPanelObj.add({
						xtype:'container',
						ui:'newGraphPanel',
						columnWidth:1,
						margin:'0 10 10 10' ,
						border:false,
						html:content,
						id:'html_content'
					});
					resultPanelObj.show();

					var highChart_pie = {};
					highChart_pie = jQuery.extend(true, {}, getHighChartsBarInstance('pie_id',jsonData.pie_obj.chartHeight,jsonData.pie_obj.chartWidth), highChart_pie);
					highChart_pie.setData(jsonData.pie_obj,'<%=currentDateFormat%>','');
					highChart_pie.drawChart();

					var highChart_bar = {};
					highChart_bar = jQuery.extend(true, {}, getHighChartsBarInstance('bar_id',jsonData.bar_obj.chartHeight,jsonData.bar_obj.chartWidth), highChart_bar);
					highChart_bar.setData(jsonData.bar_obj,'<%=currentDateFormat%>','');
					highChart_bar.drawChart();
					if (Ext.isEmpty(appConstants.erUtils))
					{
						appConstants.erUtils = Ext.widget("erutils");
					} 
					appConstants.publicGridData = jsonData.GridObj;
					this.loadGrid(appConstants.publicGridData);
					Ext.getCmp('selectionDetails').setSelectionDetailsData(jsonData.selectionDetails);
					appConstants.initLdgMask.hide();
				}
				else 
				{
					this.disableTools();
					resultPanelObj.hide();
					this.getNomeasurepanel().show();
					appConstants.initLdgMask.hide();
				}
		} 
		else if (reportGeneration == 'background')
		{
			resultPanelObj.hide();
			var htmlStr = '';
			var backgroundReportStatus = jsonData.backgroundReportStatus;
			if (backgroundReportStatus != 'undefined' && backgroundReportStatus == 'success')
			{
				var bgroundResponseTxt = jsonData.bgroundResponseTxt;
				var bgroundReportsURL = jsonData.bgroundReportsURL;
				var backgroundAnchor = jsonData.backgroundAnchor;
				//htmlStr = '<center><div style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:480px;height:90" class=""><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconSuccess"></div><div style="margin-top:20px"><b>' + bgroundResponseTxt + '</b></br><a class="backgroundMsgLink" href="' + bgroundReportsURL + '">' + backgroundAnchor + '</a></div></div></center>';
				htmlStr = '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconInformation"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+bgroundResponseTxt+'.</br>'+'<a class="backgroundMsgLink" href='+ bgroundReportsURL +'>'+ backgroundAnchor + '</a></div></td></tr></table></td></tr></table>';
			}
			else if (backgroundReportStatus != 'undefined' && backgroundReportStatus == 'duplicate')
			{
				var bgroundResponseTxt = jsonData.bgroundResponseTxt;
				var bgroundReportsURL = jsonData.bgroundReportsURL;
				var backgroundAnchor = jsonData.backgroundAnchor;
				//htmlStr = '<center><div style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:480px;height:90" class=""><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconExists"></div><div style="margin-top:20px"><b>' + bgroundResponseTxt + '</b></br><a class="backgroundMsgLink" href="' + bgroundReportsURL + '">' + backgroundAnchor + '</a></div></div></center>';
				htmlStr = '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconExclamation"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+bgroundResponseTxt+'.</br>'+'<a class="backgroundMsgLink" href='+ bgroundReportsURL +'>'+ backgroundAnchor + '</a></div></td></tr></table></td></tr></table>';
			} 
			else
			{
				//htmlStr = '<center><div style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:480px;height:90" class=""><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconExclamation"></div><div style="margin-top:20px"><b>Error In BackGround Generation</div></div></center>';
				htmlStr = '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconInformation"></div></td><td><div style="line-height:1.5em" class="font_bold11"><b>Error In BackGround Generation</b></div></td></tr></table></td></tr></table>';
			}
			this.getBackGroundPanel().update('<div>'+htmlStr+'</div>');
			this.getBackGroundPanel().show();
			appConstants.initLdgMask.hide();
		}
	},
	submitReport: function () {
		appConstants.initLdgMask.show();
		var resultPanelObj = Ext.getCmp('resultPanel');
		var selectionDetailsObj = Ext.getCmp('selectionDetails');
		var backgroundresultsObj = Ext.getCmp('backgroundresults');

		var reportGeneration;
		if (isSettingsEnabled)
		{
			Ext.get('configMod').animate({duration: 500,to: {y: -500}});
			reportGeneration= Ext.getCmp('reportGeneration').getValue();
		}
		else
		{
			reportGeneration=appConstants.publicjsonData.reportGeneration;
		}
		this.updateQueryString();
		var noOfchart = 0;
		resultPanelObj.removeAll();
		var finalParams = '';
		var urlforAjax = '';
		if (reportGeneration == 'foreground')
		{
			urlforAjax = '../servlet/com.eg.ErExchangeMailReportC';
			finalParams = appConstants.queryString + "&isSubmit=true&responseType=json";
		}
		else if (reportGeneration == 'background')
		{
			urlforAjax = '../servlet/com.eg.ErStartBackGroundReportC';
			var bg_reportname;
			if (isSettingsEnabled)
			{
				bg_reportname=  Ext.getCmp('bgReportName').getValue();
			}
			else
			{
				bg_reportname=appConstants.publicjsonData.bg_reportname;
			}
			finalParams = appConstants.queryString + "&bg_reportname=" +bg_reportname+ "&isSubmit=true&responseType=json";
		}
			finalParams+= '&er_RmDispName='+appConstants.er_RmDispName;
			Ext.Ajax.request({
			url: urlforAjax,
			params: finalParams,
			method: 'POST',
			scope: this,
			async: true,
			success: function (response) {
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);
				appConstants.publicjsonData = jsonData;
				this.loadReportData(appConstants.publicjsonData);
			}
		});
	},
	reportGenChange: function () {
		Ext.getCmp('resultPanel').hide();
		this.disableTools();
		var reportGenType = Ext.getCmp('reportGeneration').getValue();
		if (reportGenType == 'background')
		{
			Ext.getCmp('bgReportName').setValue("");
			Ext.getCmp('bgReportName').show();
			Ext.getCmp('moreOptionCloseId').hide();
			Ext.getCmp('submitViaSetting').show();
		} 
		else
		{
			Ext.getCmp('bgReportName').hide();
			Ext.getCmp('moreOptionCloseId').show();
			Ext.getCmp('submitViaSetting').hide();
		}
	},
	/*weekendOnChange: function () {
		var weekendvalue = Ext.getCmp('er_excwe').getValue();
		var excludeDaysObj = Ext.getCmp('excludeDays');
		if (weekendvalue == 'Yes') {
			excludeDaysObj.show();
			excludeDaysObj.update(appConstants.publicjsonData.screenLabels['MappedExcludeDays']);
		} else {
			excludeDaysObj.hide();
		}
	},*/
	ZonSegServChange:function(obj)
	{
		var eventfor = Ext.getCmp("eventfor").getValue();
		var er_comptype = Ext.getCmp("er_comptype").getValue();
		var includeSubZone = Ext.getCmp("includeSubZone");
		var er_option = Ext.getCmp("er_option");
		var params = "&eventfor="+eventfor+"&er_option="+Ext.getCmp("er_option").getValue()+"&er_comptype="+er_comptype;
		var comboRawData;
		var selectedComboOption;
		var comboObject;
		Ext.Ajax.request(
		{
			url : '/final/reporter/MailExchangeReport_JSON.jsp',
			params : params,
			scope:this,
			async: false,
			method : 'POST',
			success: function(response){
				var jsonData=Ext.decode(response.responseText);
				comboRawData = jsonData.compTypeCombo;
				selectedComboOption = jsonData.selectedcompType;
				comboObject = Ext.getCmp('er_comptype');
				comboObject.getStore().clearFilter(true); 
				comboObject.getStore().loadRawData(comboRawData);
				if (!Ext.isEmpty(selectedComboOption)) {
					comboObject.setValue(selectedComboOption);
				} else {
					comboObject.setValue(comboRawData[0].valueField);
				}
				comboRawData = jsonData.componentsCombo;
				selectedComboOption = jsonData.selectedComponents;
				comboObject = Ext.getCmp('compNameList');
				comboObject.getStore().clearFilter(true); 
				comboObject.getStore().loadRawData(comboRawData);
				if (!Ext.isEmpty(comboRawData))
				{
					if (!Ext.isEmpty(selectedComboOption)) {
						comboObject.setValue(selectedComboOption);
					} else {
						comboObject.setValue(comboRawData[0].valueField);
					}
				}
				else
				{
					comboObject.setValue("-1");
				}
				if (eventfor=='Component')
				{
					er_option.hide();
					includeSubZone.hide();
				}
				else
				{
					er_option.show();
					if (eventfor=='Segment')
					{
						er_option.setFieldLabel('Segment');
						er_option.getStore().clearFilter(true);
						er_option.getStore().loadRawData(jsonData.elementsCombo);
						er_option.setValue(jsonData.elementsCombo[0].valueField);
						includeSubZone.hide();
					}
					else if (eventfor=='Service')
					{
						er_option.setFieldLabel('Service');
						er_option.getStore().clearFilter(true);
						er_option.getStore().loadRawData(jsonData.elementsCombo);
						er_option.setValue(jsonData.elementsCombo[0].valueField);
						includeSubZone.hide();
					}
					else if (eventfor=='Zone')
					{
						er_option.setFieldLabel('Zone');
						er_option.getStore().clearFilter(true);
						er_option.getStore().loadRawData(jsonData.elementsCombo);
						er_option.setValue(jsonData.elementsCombo[0].valueField);
						includeSubZone.show();
						var setSubzone = jsonData.subzone;
						includeSubZone.getStore().loadRawData(jsonData.subZoneCombo);
						includeSubZone.setValue(setSubzone);
					}
				}
			}
		});
	},
	ReloadFields: function (obj) {
		Ext.getCmp('resultPanel').hide();
		this.disableTools();
		clickedButton = obj.getId();
		var eventfor = Ext.getCmp('eventfor').getValue();
		var er_option = Ext.getCmp('er_option').getValue();
		var er_comptype = Ext.getCmp('er_comptype').getValue();
		this.updateQueryString();
		var Qstring = "";
		var comboRawData;
		var selectedComboOption;
		var comboObject;
		Qstring = "&eventfor="+eventfor+"&er_option="+er_option;
		Ext.Ajax.request({
			url: '/final/reporter/MailExchangeReport_JSON.jsp',
			params: Qstring,
			scope: this,
			async: false,
			method: 'GET',
			success: function (response) {
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);
				comboRawData = jsonData.compTypeCombo;
				selectedComboOption = jsonData.selectedCompType;
				comboObject = Ext.getCmp('er_comptype');
				comboObject.getStore().clearFilter(true); 
				comboObject.getStore().loadRawData(comboRawData);
				if (!Ext.isEmpty(comboRawData))
				{
					if (!Ext.isEmpty(selectedComboOption))
					{
						comboObject.setValue(selectedComboOption);
					} 
					else 
					{
						comboObject.setValue(comboRawData[0].valueField);
					}
				}
				else
				{
					comboObject.setValue("-1");
				}
				comboRawData = jsonData.componentsCombo;
				selectedComboOption = jsonData.selectedComponents;
				comboObject = Ext.getCmp('compNameList');
				comboObject.getStore().clearFilter(true); 
				comboObject.getStore().loadRawData(comboRawData);
				if (!Ext.isEmpty(comboRawData))
				{
					if (!Ext.isEmpty(selectedComboOption)) {
						comboObject.setValue(selectedComboOption);
					} else {
						comboObject.setValue(comboRawData[0].valueField);
					}
				}
				else
				{
					comboObject.setValue("-1");
				}
			}
		});
	},
	ComponentsChange: function (obj)
	{
		Ext.getCmp('resultPanel').hide();
		this.disableTools();
		clickedButton = obj.getId();
		var eventfor = Ext.getCmp('eventfor').getValue();
		var er_option = Ext.getCmp('er_option').getValue();
		var er_comptype = Ext.getCmp('er_comptype').getValue();
		this.updateQueryString();
		var Qstring = "";
		var comboRawData;
		var selectedComboOption;
		var comboObject;
		Qstring = "&eventfor="+eventfor+"&er_option="+er_option+"&er_comptype="+er_comptype;
		Ext.Ajax.request({
			url: '/final/reporter/MailExchangeReport_JSON.jsp',
			params: Qstring,
			scope: this,
			async: false,
			method: 'GET',
			success: function (response) {
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);
				comboRawData = jsonData.componentsCombo;
				selectedComboOption = jsonData.selectedComponents;
				comboObject = Ext.getCmp('compNameList');
				comboObject.getStore().clearFilter(true); 
				comboObject.getStore().loadRawData(comboRawData);
				if (!Ext.isEmpty(comboRawData))
				{
					if (!Ext.isEmpty(selectedComboOption)) {
						comboObject.setValue(selectedComboOption);
					} else {
						comboObject.setValue(comboRawData[0].valueField);
					}
				}
				else
				{
					comboObject.setValue("-1");
				}
			}
		});
	},
	loadTools: function () {
		this.getNewUtilities().loadIcon(true, true, true, false, true, true, true, false, false, false,true);
		Ext.getCmp("favoriteTool").setDisabled(false);
		Ext.getCmp("scheduleTool").setDisabled(false);
	},
	afterMainRender: function () {
		if(!appConstants.hideBackButton){
			Ext.getCmp('zonereportform').add(
				{
					xtype: 'hidden',
					id: 'ID',
					name: 'ID',
					value: appConstants.publicjsonData['ID']
				}
			);
		}
		if (appConstants.er_RmDispName!= null && appConstants.er_RmDispName!= 'null' && appConstants.er_RmDispName!= 'undefined')
			this.getMain().setTitle(appConstants.er_RmDispName);
		else
			this.getMain().setTitle(appConstants.publicjsonData.reportTitle);
		this.DefaultLoad(appConstants.publicjsonData);
		this.refreshReportData();
	},
	refreshReportData: function () {
		if (appConstants.isSubmit == "true") {
			appConstants.initLdgMask.show();
			this.loadReportData(appConstants.publicjsonData);
		}
		else
		{
			if(appConstants.isForceSubmit=='true')
			{
				appConstants.isForceSubmit='false';
				this.showResult();
			}
		}
	},
	updateQueryString: function () {
		var mainFormParams;
		var settingsFormParams;
		var hiddenfieldQString = '';
		var timelineParams;
		var timePeriodParams;
		var localjson=appConstants.publicjsonData;
		var reportGeneration,er_trenddata,er_excwe,er_priority,timefrom,minfrom,timeto,minto;
		if (!isSettingsEnabled)
		{
			reportGeneration=localjson.reportGeneration;
			er_priority=localjson.selectedPriority;
			er_excwe=localjson.excludeWeek;
			timefrom=localjson.selectedTimeFrom;
			minfrom=localjson.selectedMinsFrom;
			timeto=localjson.selectedTimeTo;
			minto=localjson.selectedMinsTo;
		}
		else
		{
			reportGeneration= Ext.getCmp('reportGeneration').getValue();
			er_priority= Ext.getCmp('er_priority').getValue();
			er_excwe= Ext.getCmp('er_excwe').getValue();
			timefrom= Ext.getCmp('timefrom').getValue();
			minfrom= Ext.getCmp('minfrom').getValue();
			timeto= Ext.getCmp('timeto').getValue();
			minto= Ext.getCmp('minto').getValue();
		}
		if ((minfrom == 'undefined' || minfrom == undefined) || (minfrom == null || minfrom == 'null'))
			minfrom='00';
		if ((minto == 'undefined' || minto == undefined) || (minto == null || minto == 'null'))
			minto='00';

		var eventfor = Ext.getCmp('eventfor').getValue();
		mainFormParams = "&eventfor="+eventfor+"&er_option=" + Ext.getCmp('er_option').getValue() + "&er_comptype=" + Ext.getCmp('er_comptype').getValue()+ "&er_excwe=" +er_excwe + "&er_reportgenration=" +reportGeneration;
		var compVal = Ext.getCmp('compNameList').getValue();
		for ( var key in compVal )
		{
			mainFormParams += '&er_component='+encodeURI(compVal[key]);
		}
		mainFormParams += "&opt=chart&er_priority=" + er_priority;
		mainFormParams += "&er_sortby=-1&&opt=data"; // ommitting sort by combo beacause using  grid panel
		var startDateConverted = Ext.Date.dateFormat(Ext.getCmp('er_stdate').getValue(), mgrDateFormat);
		var endDateConverted = Ext.Date.dateFormat(Ext.getCmp('er_enddate').getValue(), mgrDateFormat);
		var timelineParams = "&er_timeline=" + Ext.getCmp('er_timeline').getValue() + "&startdate=" + Ext.getCmp('er_stdate').dataArray + "&enddate=" + Ext.getCmp('er_enddate').dataArray + "&starthr=" + Ext.getCmp('er_sthr').dataArray + "&endhr=" + Ext.getCmp('er_endhr').dataArray + "&startmin=" + mgr_stmin + "&endmin=" + mgr_enmin;
		var timperiodParams = "&timefrom=" + timefrom + "&minfrom=" + minfrom + "&timeto=" +timeto + "&minto=" + minto;
		if (appConstants.publicjsonData.hasOwnProperty('hiddenfields')) {
			var hiddenFields = appConstants.publicjsonData.hiddenfields;
			for (var hiddenField in hiddenFields) {
				hiddenfieldQString += "&" + hiddenField + "=" + hiddenFields[hiddenField];
			}
		}
		appConstants.queryString = mainFormParams + timelineParams + hiddenfieldQString + timperiodParams;
		appConstants.queryString += '&er_RmDispName='+appConstants.er_RmDispName;
	},

	DefaultLoad: function (jsonData) {
		var comboRawData;
		var selectedComboOption;
		var comboObject;
		var eventfor=Ext.getCmp("eventfor").getValue();
		var isSubmitted = "false";
		if (jsonData.hasOwnProperty('isSubmit'))
			var isSubmitted = jsonData.isSubmit;
		var hiddenFields = jsonData.hiddenfields;
		var from_schedule = hiddenFields["fromScheduleModify"];
		var from_favourite= hiddenFields["fromFavoriteModify"];
		if ((from_schedule != null && from_schedule == "Yes")||(from_favourite != null && from_favourite == "Yes")) {
			Ext.getCmp("submit").hide();
			Ext.getCmp("save").show();
			Ext.getCmp("favoriteTool").setDisabled(true);
			Ext.getCmp("scheduleTool").setDisabled(true);
		}else{
			Ext.getCmp("submit").show();
			Ext.getCmp("save").hide();
		}
		var screenLabels = jsonData.screenLabels;
		var analysisRawData=jsonData.analysisCombo;
		var selectedAnalysis=jsonData.selectedAnalysis;
		var analysisObj=Ext.getCmp('eventfor');
		analysisObj.setFieldLabel(screenLabels['reporter.common.Analysis by']);
		analysisObj.getStore().loadRawData(analysisRawData);
		if ( !Ext.isEmpty(selectedAnalysis) )
		{
			analysisObj.setValue(selectedAnalysis);
		}
		else
		{
			analysisObj.setValue(analysisRawData[0].valueField);
		}
		if(selectedAnalysis != 'Component')
		{
			var event_select_obj = Ext.getCmp('er_option');
			if(selectedAnalysis == 'Zone'){
				Ext.getCmp('includeSubZone').show();
			}
			var elementsrawdata=jsonData.elementsCombo;
			if(!Ext.isEmpty(elementsrawdata))
			{
				var selectedElement=jsonData.selectedElement;
				event_select_obj.setFieldLabel(selectedAnalysis);
				event_select_obj.getStore().loadRawData(elementsrawdata);
				if ( !Ext.isEmpty(selectedElement) )
				{
					event_select_obj.setValue(selectedElement);
				}
				else
				{
					event_select_obj.setValue(elementsrawdata[0].valueField);
				}
				event_select_obj.show();
			}
		}
		var subzoneObj=Ext.getCmp('includeSubZone');
		var subzoneRawData=jsonData.subZoneCombo
		subzoneObj.setFieldLabel(jsonData.screenLabels['reporter.history.Include Subzones']);
		subzoneObj.getStore().loadRawData(subzoneRawData);
		subzoneObj.setValue(jsonData.subzone);
		var compTypeRawData=jsonData.compTypeCombo;
		var selectedType=jsonData.selectedCompType;
		var compTypeObj=Ext.getCmp('er_comptype');
		compTypeObj.setFieldLabel(screenLabels['reporter.common.Component Type']);
		compTypeObj.getStore().clearFilter(true);
		compTypeObj.getStore().loadRawData(compTypeRawData);
		if ( !Ext.isEmpty(selectedType) )
		{
			compTypeObj.setValue(selectedType);
		}
		else
		{
			compTypeObj.setValue(compTypeRawData[0].valueField);
		}
		var comboRawData = jsonData.componentsCombo;
		var selectedComboOption = jsonData.selectedComponents;
		var comboObject = Ext.getCmp('compNameList');
		comboObject.getStore().clearFilter(true); 
		comboObject.getStore().loadRawData(comboRawData);
		if (!Ext.isEmpty(selectedComboOption)) {
			comboObject.setValue(selectedComboOption);
		} else {
			comboObject.setValue(comboRawData[0].valueField);
		}
		var timelineRawData = jsonData.timelineCombo;
		var selectedTimeline = jsonData.selectedTimeline;
		var timelineObj = Ext.getCmp('er_timeline');
		timelineObj.setFieldLabel(screenLabels['reporter.common.Timeline']);
		timelineObj.getStore().loadRawData(timelineRawData);
		if (!Ext.isEmpty(timelineRawData)) {
			if (!Ext.isEmpty(selectedTimeline)) {
				timelineObj.setValue(selectedTimeline);
			} else {
				timelineObj.setValue(timelineRawData[0].valueField);
			}
		}
		var start_hour = jsonData.startHour;
		var end_hour = jsonData.endHour;
		var start_date = jsonData.startDate;
		var end_date = jsonData.endDate;
		var startDateObj = Ext.getCmp('er_stdate');
		startDateObj.setValue(jsonData.startDateForDisplay);
		startDateObj.dataArray = start_date;
		var startHrObj = Ext.getCmp('er_sthr');
		startHrObj.setValue(jsonData.startHourForDisplay);
		startHrObj.dataArray = start_hour;
		var endDateObj = Ext.getCmp('er_enddate');
		endDateObj.setValue(jsonData.endDateForDisplay);
		endDateObj.dataArray = end_date;
		var endHrObj = Ext.getCmp('er_endhr');
		endHrObj.setValue(jsonData.endHourForDisplay);
		endHrObj.dataArray = end_hour;
		stmin = jsonData.startMinForDisplay;
		enmin = jsonData.endMinForDisplay;
		mgr_stmin = jsonData.startmin;
		mgr_enmin = jsonData.endmin;
		updatingAppSettings();
	},
	loadSettings:function()
	{
		Ext.getCmp('moreOptionCloseId').show();
		var hiddenFields = appConstants.publicjsonData.hiddenfields;
		var favorite_id = hiddenFields["favorite_id"];
			if(!Ext.isEmpty(favorite_id)){
			//Ext.getCmp('reportGeneration').setDisabled(true);
		}
		var jsonData=appConstants.publicjsonData;
		var screenLabels = jsonData.screenLabels;
		var comboRawData = jsonData.excludeWeekCombo;
		var selectedComboOption = jsonData.excludeWeek;
		comboObject = Ext.getCmp('er_excwe');
		comboObject.setFieldLabel(screenLabels['reporter.consolidated.Exclude weekends']);
		comboObject.getStore().loadRawData(comboRawData);
		if (!Ext.isEmpty(selectedComboOption)) {
			comboObject.setValue(selectedComboOption);
		} else {
			comboObject.setValue(comboRawData[0].valueField);
		}
		comboRawData = jsonData.priorityCombo;
		selectedComboOption = jsonData.selectedPriority;
		comboObject = Ext.getCmp('er_priority');
		comboObject.setFieldLabel(screenLabels['reporter.comparison.Show']);
		comboObject.getStore().loadRawData(comboRawData);
		if (!Ext.isEmpty(selectedComboOption)) {
			comboObject.setValue(selectedComboOption);
		} else {
			comboObject.setValue(comboRawData[0].valueField);
		}
		Ext.getCmp('timeperiodLbl').setText(screenLabels['reporter.common.Time period']);
		Ext.getCmp('timefrom').setValue(jsonData.selectedTimeFrom);
		Ext.getCmp('minfrom').setValue(jsonData.selectedMinsFrom);
		Ext.getCmp('timeto').setValue(jsonData.selectedTimeTo);
		Ext.getCmp('minto').setValue(jsonData.selectedMinsTo);

		var reportGenCombo = jsonData.reportGenerationCombo;
		var selreportGeneration = jsonData.reportGeneration;
		var reportGen = Ext.getCmp('reportGeneration');
		reportGen.setFieldLabel(screenLabels['reporter.consolidated.Report Generation']);
		if (!Ext.isEmpty(reportGenCombo) && reportGenCombo!=undefined)
		{
			reportGen.getStore().loadRawData(reportGenCombo);
		}
		reportGen.setValue(selreportGeneration);
	}
});