Ext.define('MeasurePopupApp.view.MeasurePopupMainForm',{
	extend:'Ext.form.Panel',
	alias:'widget.measurepopupmainform',
	requires:[
			'utilities.ScrollCombo',
			'MeasurePopupApp.view.TimeLine'
	],
	id:'meaurepopupform',
	ui:'newFormPanelForWindow',
	layout: 'column',
	collapseMode: 'mini',
	initComponent: function(){
		this.bodyPadding ='10 10 0 10';
		this.buttonAlign = 'center';
		this.callParent();
	},
	margin:'10 10 0 10',
	items:[
			{
				xtype:'fieldcontainer',
				layout: 'column',
				defaults:{
					margin:'0 20 10 0',
					labelSeparator:''
				},
				items:[
					{
						xtype:'scrollcombo',
						cls: 'dropdown',
						labelSeparator:'',
						width: 150,
						editable : false,
						fieldLabel:'Filter By',
						labelAlign:'top',
						name: 'filterSelectBox',
						id: 'filterSelectBox',
						store: new Ext.data.Store({
							fields : ['displayField', 'valueField'],
							data : []
						}),
						displayField : 'displayField',
						valueField : 'valueField',
						queryMode : 'local',
						hidden : true
					},
					{
						xtype:'scrollcombo',
						cls: 'dropdown',
						labelSeparator:'',
						width: 150,
						editable : false,
						fieldLabel:'Descriptor Priority',
						labelAlign:'top',
						name: 'descriptorPrioritySelectBox',
						id: 'descriptorPrioritySelectBox',
						store: new Ext.data.Store({
							fields : ['displayField', 'valueField'],
							data : []
						}),
						displayField : 'displayField',
						valueField : 'valueField',
						queryMode : 'local',
						hidden : true
					},
					{
						xtype:'scrollcombo',
						cls: 'dropdown',
						labelSeparator:'',
						width: 150,
						editable : false,
						fieldLabel:'Descriptor',
						labelAlign:'top',
						name: 'descriptorFilter',
						id: 'descriptorFilter',
						store: new Ext.data.Store({
							//fields : ['displayField', 'valueField'],
							fields : [{name:'displayField', convert:function(value,record)
							{
								return Ext.String.htmlDecode(value);
							}}, 'valueField'],
							data : []
						}),
						displayField : 'displayField',
						valueField : 'valueField',
						queryMode : 'local',
						hidden :true
					},
					{
						xtype:'container',
						layout:'column',
						id:'rangeSelector',
						hidden :true,
						defaults:{
						margin:'0 20 5 0',
						labelSeparator:''
						},
						items:[
							/*{
							xtype:'label',
							text:'Range',
							id:'rangeLbl',
							name:'rangeLbl',
							labelSeparator:'',
							hidden :  true
						},*/
						{
								xtype: 'textfield',
								id: 'fromRange',
								labelSeparator:'',
								labelAlign:'top',
								name: 'fromRange',
								value: '',
								fieldLabel:'Range',
								cls: 'textbox',
								width: 125,
								disabled: true,
								hidden : true
						},

						{
								xtype: 'textfield',
								id: 'toRange',
								labelAlign:'top',
								labelSeparator:'',
								name: 'toRange',
								value: '',
								fieldLabel:'To',
								cls: 'textbox',
								width: 125,
								disabled: true,
								hidden : true
						}
						]
					}

				]
			},
			{
				xtype:'scrollcombo',
				fieldLabel:'Component',
				labelAlign:'top',
				labelSeparator:'',
				margin:'0 20 5 0',
				editable : true,
				typeAhead:true,
				listConfig:{
					emptyText:noComponentTypeMatch
				},
				cls: 'dropdown',
				id: 'er_components',
				name: 'er_components',				
				hidden:hideComponentCombo,
				width:200,
				store: Ext.data.Store
				(
					{
						fields: ['displayField','valueField'],
						data: []
					}
				),
				displayField: 'displayField',
				valueField: 'valueField',
				queryMode: 'local'
			
			},
			{
			    xtype:'timelinemeasurepopup',
				margin:'0 20 0 0'
			},			
			{
                xtype : 'scrollcombo',
                cls : 'dropdown',
                width:100,
                editable : false,
                labelAlign: 'top',
				margin:'0 20 10 0',
                labelSeparator:'',
                hidden:true,
                fieldLabel : 'Predict For',
                name : 'er_look_forward',
                id : 'er_look_forward',
                store : new Ext.data.Store({
                            fields : ['displayField', 'valueField'],
                            data : [
                                ]
                        }),
                displayField : 'displayField',
                valueField : 'valueField',
                queryMode : 'local'
            },
			{
				xtype:'button',
				text: submitValue,
 				//cls: 'button20',
				ui:'newButtonSmall',
				id: 'submit',
				name: 'submit',
				//margin:'20 0 0 0'
				margin:'20 0 10 0'
			},
			{
				xtype:'container',
				border:true,
				style:{
					'right':'10px',
					'top':'10px',
					'position':'absolute',
				},
				items:[
					{
						xtype:'button',
						cls:'iconPanelUpArrow',
						id:'panelinsidetoggle',
						border:false,
						bodyStyle:{'background':'none'},
						disabled: true,
					}
				]
			}
		]
});