Ext.define('MeasurePopupApp.view.PopupPrint',{
	extend:'Ext.window.Window',
	alias:'widget.popupprint',
	modal:true,
	ghost:false,
	header:false,  
	dom:null,
	closeAction:'destroy',
	constrain:true,
	border:false,
	title: '',
	ui:'newPopupWindow',
	width:950,
	id:'popupprint',
	height:450,
	frame:false,
	resizable:false,
	autoScroll:true,
	layout:{
		type:'fit'
	},
	defaults:{
		margin:'0 0 0 0'
	},
	items:[{
		xtype:"component",
		id:"popupPrintContentDiv",
		margin:0,
		autoEl:{
			tag:'iframe',
			frameborder:'0',
			height:'100%',
			margin:0,
			src :''
		},
		listeners:{
			load:{
				element:'el',
				fn:function(){
					 this.parent().unmask();
				}
			},
			render:function(){
				this.up('window').body.mask('Loading...');
				$('#popupPrintContentDiv').on('load', function(){ 
					$(this).contents().find('body').css({
						//margin: '0'
					});
				});
			}
		}
	}],

	listeners:{
		show: function(win) {
			if (this.modal) {
				var doms = Ext.dom.Query.select('.x-mask');
				for (var key in doms)
				{
					this.dom=doms[key];
					if (!Ext.isEmpty(this.dom.offsetParent))
					{
						if (this.dom.offsetParent.tagName=='BODY')
						{
							Ext.fly(this.dom).addCls('windowModal');
						}
					}
				}
			}
		},
		hide:function(win) {
			if (this.modal) {
				Ext.fly(this.dom).removeCls('windowModal');
			}
		}
	
	}

});