var isTrend=false;
Ext.define('MultiMeasurePopupApp.view.TimeLine',{
	alias:'widget.timelinemeasurepopup',
	extend:'Ext.form.FieldContainer',
	requires:[
		'utilities.DatePicker',
		'utilities.ScrollCombo'
	],
	layout:'column',
	defaults:{
		labelAlign: 'top',
		margin:'0 20 5 0',
		labelSeparator:''
	},
	initComponent: function()
	{
		this.items = this.getReporterTimelineItems();
		this.callParent();
	},
	getReporterTimelineItems: function()
	{
		return [
		{
			xtype: 'scrollcombo',
			fieldLabel: timelineLbl,
			id: 'timeLineCombo',
			name: 'timeLineCombo',
			displayField: 'displayField',
			valueField: 'valueField',
			queryMode: 'local',
			store: Ext.data.Store(
			{
				fields: ['displayField', 'valueField'],
				data: []
			}),
			width: 90,
			cls: 'dropdown',
			defaultListConfig:
			{
				loadingHeight: 70,
				minWidth: 90,
				maxHeight: 300,
				shadow: 'sides'
			},
			listeners:
			{
				'boxready': function(obj)
				{
					var stDateObj = Ext.getCmp('startdate');
					var enDateObj = Ext.getCmp('enddate');
					var stHourObj = Ext.getCmp('startHour');
					var enHourObj = Ext.getCmp('endHour');

					if (obj.getValue() == 'Any')
					{
						stDateObj.setDisabled(false);
						enDateObj.setDisabled(false);
						stHourObj.setDisabled(false);
						enHourObj.setDisabled(false);
					}
					else
					{
						stDateObj.setDisabled(true);
						enDateObj.setDisabled(true);
						stHourObj.setDisabled(true);
						enHourObj.setDisabled(true);

					}
				},
				'select': function(obj)
				{

					var stDateObj = Ext.getCmp('startdate');
					var enDateObj = Ext.getCmp('enddate');
					var stHourObj = Ext.getCmp('startHour');
					var enHourObj = Ext.getCmp('endHour');
					var startMinObj = Ext.getCmp('startMins');
					var endMinObj = Ext.getCmp('endMins');
					if (obj.getValue() == 'Any')
					{
						stDateObj.setDisabled(false);
						enDateObj.setDisabled(false);
						stHourObj.setDisabled(false);
						enHourObj.setDisabled(false);
						startMinObj.setDisabled(false);
						endMinObj.setDisabled(false);
					}
					else
					{
						stDateObj.setDisabled(true);
						enDateObj.setDisabled(true);
						stHourObj.setDisabled(true);
						enHourObj.setDisabled(true);
						startMinObj.setDisabled(true);
						endMinObj.setDisabled(true);
					}
					{
						var timeline = obj.getValue();
						var strtdt = stDateObj.getValue();
						var enddt = enDateObj.getValue();
						var strthour = stHourObj.getValue();
						var endhr = enHourObj.getValue();
						var stmin = startMinObj.getValue();
						var enmin = endMinObj.getValue();

						strtdt = Ext.Date.dateFormat(strtdt, mgrDateFormat);
						enddt = Ext.Date.dateFormat(enddt, mgrDateFormat);
						var param = "C=id&P0=[" + timeline + "]&P1=[" + strtdt + "]&P2=[" + enddt + "]&P3=[" + strthour + "]&P4=[" + endhr + "]";
						if (isTrend == true)
						{
							param += "&P5=[" + stmin + "]&P6=[" + enmin + "]&P7=[" + dateFormatForTimeline + "]&F=getTrendTime";
						}
						else
						{
							param += "&P5=[" + dateFormatForTimeline + "]&F=getTime";
						}
						Ext.Ajax.request(
						{
							url: '/final/servlet/com.eg.ErRemoteScriptingServlet',
							params: param,
							scope: this,
							method: 'POST',
							success: function(response)
							{
								var jsontext = response.responseText;
								var jsonData = Ext.decode(jsontext);
								if (!Ext.isEmpty(jsonData))
								{
									var timedata = jsonData.timeline;
									stDateObj.dataArray = timedata[0];
									enDateObj.dataArray = timedata[1];
									stHourObj.dataArray = timedata[2];
									enHourObj.dataArray = timedata[3];
									startMinObj.dataArray = timedata[4];
									endMinObj.dataArray = timedata[5];
									stDateObj.setValue(timedata[6]);
									enDateObj.setValue(timedata[7]);
									stHourObj.setValue(timedata[8]);
									enHourObj.setValue(timedata[9]);
									startMinObj.setValue(timedata[10]);
									endMinObj.setValue(timedata[11]);
								}
							}
						});
					}
				}
			}
		},
		{
			xtype: 'datepicker',
			id: 'startdate',
			name: 'startdate',
			format: mgrDateFormat,
			fieldLabel: fromLbl,
			cls: 'datepicker',
			disabled: true,
			dataArray: null,
			listeners:
			{
				'select': function(obj)
				{

					var timeline = Ext.getCmp("timeLineCombo").getValue();
					var strtdt = Ext.getCmp("startdate").getValue();
					var enddt = Ext.getCmp("enddate").getValue();
					var strthour = Ext.getCmp("startHour").getValue();
					var endhr = Ext.getCmp("endHour").getValue();
					var stmin = Ext.getCmp('startMins').getValue();
					var enmin = Ext.getCmp('endMins').getValue();

					if (timeline == "Any")
					{
						strtdt = Ext.Date.dateFormat(strtdt, 'm/d/Y');
						enddt = Ext.Date.dateFormat(enddt, 'm/d/Y');
					}
					else
					{
						strtdt = Ext.Date.dateFormat(strtdt, mgrDateFormat);
						enddt = Ext.Date.dateFormat(enddt, mgrDateFormat);
					}

					var param = "C=id&P0=[" + timeline + "]&P1=[" + strtdt + "]&P2=[" + enddt + "]&P3=[" + strthour + "]&P4=[" + endhr + "]&P5=[" + stmin + "]&P6=[" + enmin + "]&P7=[" + dateFormatForTimeline + "]&F=getTime";

					Ext.Ajax.request(
					{
						url: '/final/servlet/com.eg.ErRemoteScriptingServlet',
						params: param,
						scope: this,
						method: 'POST',
						success: function(response)
						{
							var jsontext = response.responseText;
							var jsonData = Ext.decode(jsontext);
							if (!Ext.isEmpty(jsonData))
							{
								var timedata = jsonData.timeline;
								Ext.getCmp("startdate").dataArray = timedata[0];
								Ext.getCmp("enddate").setValue(timedata[7]);
								Ext.getCmp("startdate").setValue(timedata[6]);
								Ext.getCmp("enddate").dataArray = timedata[1];
								if (!isTrend)
								{
									Ext.getCmp("startHour").setValue(timedata[8]);
									Ext.getCmp("startHour").dataArray = timedata[2];
									Ext.getCmp("endHour").setValue(timedata[9]);
									Ext.getCmp("endHour").dataArray = timedata[3];
									
									Ext.getCmp("startMins").setValue(timedata[10]);
									Ext.getCmp("startMins").dataArray = timedata[11];
									Ext.getCmp("endMins").setValue(timedata[4]);
									Ext.getCmp("endMins").dataArray = timedata[5];
								}
							}
						}
					});
				}
			}
		},
		{
			xtype: 'scrollcombo',
			width: 50,
			id: 'startHour',
			name: 'startHour',
			defaultListConfig:
			{
				loadingHeight: 70,
				minWidth: 50,
				maxHeight: 300,
				shadow: 'sides'
			},
			store: ['00', '01', '02', '03', '04', '05', '06', '07', '08', '09', '10', '11', '12', '13', '14', '15', '16', '17', '18', '19', '20', '21', '22', '23'],
			displayField: 'displayField',
			valueField: 'valueField',
			queryMode: 'local',
			fieldLabel: hrLbl,
			cls: 'dropdown',
			disabled: true,
			dataArray: null,
			listeners:
			{
				'select': function(combo)
				{
					formated_sdate = Ext.Date.dateFormat(Ext.getCmp("startdate").getValue(), mgrDateFormat); 
					var stmin=Ext.getCmp("startMins").getValue();
					if (stmin == null || stmin == "undefined" || stmin == '')
						stmin = "00"
					var dateValue = formated_sdate + " " + combo.getValue() + ":" + stmin + ":00";
					
					var param = "date=" + dateValue + "&method=getDateTime&isReverse=true&isFromReporter=true";
					Ext.Ajax.request(
					{
						url: '/final/servlet/com.eg.EgTimeZoneConverterServlet',
						params: param,
						scope: this,
						method: 'POST',
						success: function(response)
						{
							var responseText = response.responseText;
							responseText = Ext.String.trim(responseText);
							var dt = responseText.substring(0, responseText.lastIndexOf(" "));
							var tim = responseText.substring(responseText.lastIndexOf(" ") + 1);

							Ext.getCmp("startdate").dataArray = dt;
							Ext.getCmp("startHour").dataArray = tim.substring(0, tim.indexOf(":"));
							Ext.getCmp("startMins").dataArray = tim.substring(tim.indexOf(":")+1, tim.lastIndexOf(":")); 
						}
					});
				}
			}
		},
		{
			xtype:'scrollcombo',
			width:50,
			editable:false,
			defaultListConfig: {
								loadingHeight: 50,
								minWidth: 50,
								maxHeight: 300,
								shadow: 'sides'
							},
			id: 'startMins',
			name:'startMins',
			store: ['00','01', '02', '03', '04', '05', '06', '07', '08', '09', '10', '11', '12', '13', '14', '15', '16', '17', '18','19', '20', '21','22','23','24','25','26','27','28','29','30','31','32','33','34','35','36','37','38','39','40','41','42','43','44','45','46','47','48','49','50','51','52','53','54','55','56','57','58','59'],
			displayField: 'displayField',
			valueField: 'valueField',
			queryMode: 'local',
			fieldLabel:'Mins',
			cls: 'dropdown',
			disabled: true,
			hidden : true,
			listeners: {
				'select': function (combo) {
					formated_sdate = Ext.Date.dateFormat(Ext.getCmp("startdate").getValue(),mgrDateFormat); 
					var stmin=Ext.getCmp("startMins").getValue();
					var starthor=Ext.getCmp("startHour").getValue();
					if(stmin==null || stmin=="undefined" ||stmin=='')
						stmin="00";
					//var dateValue = formated_sdate + " " + combo.getValue() + ":" + stmin + ":00";
					var dateValue = formated_sdate + " " + starthor + ":" + stmin + ":00";
					var param = "date=" + dateValue + "&method=getDateTime&isReverse=true&isFromReporter=true";
					Ext.Ajax.request({
						url: '/final/servlet/com.eg.EgTimeZoneConverterServlet',
						params: param,
						scope: this,
						method: 'POST',
						success: function (response) {
								var responseText = response.responseText;
								responseText = Ext.String.trim(responseText);
								var dt = responseText.substring(0, responseText.lastIndexOf(" "));
								var tim = responseText.substring(responseText.lastIndexOf(" ") + 1);

								Ext.getCmp("startdate").dataArray = dt;
								Ext.getCmp("startHour").dataArray = tim.substring(0, tim.indexOf(":"));
								Ext.getCmp("startMins").dataArray = tim.substring(tim.indexOf(":")+1, tim.lastIndexOf(":")); 
							}
					});
				}
			}
		},
		{
			xtype: 'datepicker',
			id: 'enddate',
			name: 'enddate',
			format: mgrDateFormat,
			fieldLabel: Tolbl,
			cls: 'datepicker',
			//width: 115,
			disabled: true,
			dataArray: null,
			listeners:
			{
				'select': function(obj)
				{
					var timeline = Ext.getCmp("timeLineCombo").getValue();
					var strtdt = Ext.getCmp("startdate").getValue();
					var enddt = Ext.getCmp("enddate").getValue();
					var strthour = Ext.getCmp("startHour").getValue();
					var endhr = Ext.getCmp("endHour").getValue();
					var stmin = Ext.getCmp('startMins').getValue();
					var enmin = Ext.getCmp('endMins').getValue();

					if (timeline == "Any")
					{
						strtdt = Ext.Date.dateFormat(strtdt, 'm/d/Y');
						enddt = Ext.Date.dateFormat(enddt, 'm/d/Y');
					}
					else
					{
						strtdt = Ext.Date.dateFormat(strtdt, mgrDateFormat);
						enddt = Ext.Date.dateFormat(enddt, mgrDateFormat);
					}
					var param = "C=id&P0=[" + timeline + "]&P1=[" + strtdt + "]&P2=[" + enddt + "]&P3=[" + strthour + "]&P4=[" + endhr + "]&P5=[" + stmin + "]&P6=[" + enmin + "]&P7=[" + dateFormatForTimeline + "]&F=getTime";

					Ext.Ajax.request(
					{
						url: '/final/servlet/com.eg.ErRemoteScriptingServlet',
						params: param,
						scope: this,
						method: 'POST',
						success: function(response)
						{
							var jsontext = response.responseText;
							var jsonData = Ext.decode(jsontext);
							if (!Ext.isEmpty(jsonData))
							{
								var timedata = jsonData.timeline;
								Ext.getCmp("startdate").setValue(timedata[6]);
								Ext.getCmp("startdate").dataArray = timedata[0];
								Ext.getCmp("enddate").setValue(timedata[7]);
								Ext.getCmp("enddate").dataArray = timedata[1];
								if (!isTrend)
								{
									Ext.getCmp("startHour").setValue(timedata[8]);
									Ext.getCmp("startHour").dataArray = timedata[2];
									Ext.getCmp("endHour").setValue(timedata[9]);
									Ext.getCmp("endHour").dataArray = timedata[3];
									Ext.getCmp("startMins").setValue(timedata[10]);
									Ext.getCmp("startMins").dataArray = timedata[11];
									Ext.getCmp("endMins").setValue(timedata[4]);
									Ext.getCmp("endMins").dataArray = timedata[5];
								}
							}
						}
					});
				}
			}
		},
		{
			xtype: 'scrollcombo',
			width: 50,
			defaultListConfig:
			{
				loadingHeight: 70,
				minWidth: 50,
				maxHeight: 300,
				shadow: 'sides'
			},
			fieldLabel: hrLbl,
			cls: 'dropdown',
			id: 'endHour',
			name: 'endHour',
			store: ['00', '01', '02', '03', '04', '05', '06', '07', '08', '09', '10', '11', '12', '13', '14', '15', '16', '17', '18', '19', '20', '21', '22', '23'],
			displayField: 'displayField',
			valueField: 'valueField',
			queryMode: 'local',
			disabled: true,
			dataArray: null,
			listeners:
			{
				'select': function(combo)
				{
					formated_sdate = Ext.Date.dateFormat(Ext.getCmp("enddate").getValue(), mgrDateFormat);
					var enmin=Ext.getCmp("endMins").getValue();
					if (enmin == null || enmin == "undefined" || enmin == '')
						enmin = "00"
					var dateValue = formated_sdate + " " + combo.getValue() + ":" + enmin + ":00";
					var param = "date=" + dateValue + "&method=getDateTime&isReverse=true&isFromReporter=true";
					Ext.Ajax.request(
					{
						url: '/final/servlet/com.eg.EgTimeZoneConverterServlet',
						params: param,
						scope: this,
						method: 'POST',
						success: function(response)
						{
							var responseText = response.responseText;
							responseText = Ext.String.trim(responseText);
							var dt = responseText.substring(0, responseText.lastIndexOf(" "));
							var tim = responseText.substring(responseText.lastIndexOf(" ") + 1);
							Ext.getCmp("enddate").dataArray = dt;
							Ext.getCmp("endHour").dataArray = tim.substring(0, tim.indexOf(":"));
							Ext.getCmp("endMins").dataArray = tim.substring(tim.indexOf(":")+1, tim.lastIndexOf(":")); 
						}
					});
				}
			}
		},
		{
			xtype:'scrollcombo',
			width:50,
			editable:false,
			defaultListConfig: {
								loadingHeight: 50,
								minWidth: 50,
								maxHeight: 300,
								shadow: 'sides'
							},
			id: 'endMins',
			name:'endMins',
			store: ['00','01', '02', '03', '04', '05', '06', '07', '08', '09', '10', '11', '12', '13', '14', '15', '16', '17', '18','19', '20', '21','22','23','24','25','26','27','28','29','30','31','32','33','34','35','36','37','38','39','40','41','42','43','44','45','46','47','48','49','50','51','52','53','54','55','56','57','58','59'],
			displayField: 'displayField',
			valueField: 'valueField',
			queryMode: 'local',
			fieldLabel:'Mins',
			cls: 'dropdown',
			disabled: true,
			hidden : true,
			listeners: {
					'select': function (combo) {
						formated_sdate = Ext.Date.dateFormat(Ext.getCmp("enddate").getValue(),mgrDateFormat); 
						var enmin=Ext.getCmp("endMins").getValue();
						var endhor=Ext.getCmp("endHour").getValue();
						if(enmin==null || enmin=="undefined" ||enmin=='')
							var enmin="00";
						
						//var dateValue = formated_sdate + " " + combo.getValue() + ":" + enmin + ":00";
						var dateValue = formated_sdate + " " + endhor + ":" + enmin + ":00";
						var param = "date=" + dateValue + "&method=getDateTime&isReverse=true&isFromReporter=true";
						Ext.Ajax.request({
							url: '/final/servlet/com.eg.EgTimeZoneConverterServlet',
							params: param,
							scope: this,
							method: 'POST',
							success: function (response) {
								var responseText = response.responseText;
								responseText = Ext.String.trim(responseText);
								var dt = responseText.substring(0, responseText.lastIndexOf(" "));
								var tim = responseText.substring(responseText.lastIndexOf(" ") + 1);
								Ext.getCmp("enddate").dataArray = dt;
								Ext.getCmp("endHour").dataArray = tim.substring(0, tim.indexOf(":"));
								Ext.getCmp("endMins").dataArray = tim.substring(tim.indexOf(":")+1, tim.lastIndexOf(":")); 
							}
						});
					}
				}
		},
		{
			xtype:'checkboxgroup',
			cls: 'checkbt',
			id: 'er_checkbox',
			width: 130,
			margin: '20 0 0 5',
			items: [{
				boxLabel: 'Show Legends',
				inputValue: 'true',
				id: 'showLegend'
			}]
		}]
	}
});