Ext.define('OperationAlarmsHistory.view.AlarmDetailsGrid',{
		extend:'utilities.CustomGrid',
		requires:['Ext.ux.grid.FiltersFeature','Ext.ux.data.PagingMemoryProxy'],
		alias:'widget.alarmdetailsgrid',
		id:'alarmDetailsGrid',
		//cls:'gridSkin',
		ui:'newGridPanel',
		margin:'10 10 10 10',
		border:true,
		screenLabels:null,
		dataArray : null,
		//forceFit:false,
		layout:{
			type:'fit',
		},
		//flex:1,
		pageLimit: null,
		scroll:true,
		autoScroll:true,
		//margin:'0 0 0 0',
		initComponent:function()
		{
			var filters = {
			ftype: 'filters',
			// encode and local configuration options defined previously for easier reuse
			encode: false, // json encode the filter query
			local: true,   // defaults to false (remote filtering)
			filters: [ // Filters are most naturally placed in the column definition, but can also be // added here.
				{
					dataIndex:'startTime',
					 type: 'number'
				},
				{
					dataIndex:'compType',
					 type: 'string'

				},
				{
					dataIndex:'compName',
					 type: 'string'

				},
				{
					dataIndex:'service',
					 type: 'string'

				},
				{
					dataIndex:'GroupName',
					 type: 'string'
				},
				{
					dataIndex:'test',
					 type: 'string'

				},
				{
					dataIndex:'measureOrDesc',
					 type: 'string'

				},
				{
					dataIndex:'user',
					 type: 'string'

				},
				{
					dataIndex:'duration',
					 type: 'string'

				},
				{
					dataIndex:'ack_status',
					 type: 'string'
				},
				{
					dataIndex:'ack_time',
					 type: 'string'
				},
				{
					dataIndex:'ack_user',
					 type: 'string'
				},
				{
					dataIndex:'reponsetime',
					 type: 'string'
				}
			]
			 };
			this.features= [filters];
			this.store = Ext.create('Ext.data.Store', {
				fields:['severity', {name:'compType',sortType:Ext.data.SortTypes.asUCString}, {name:'compName',sortType:Ext.data.SortTypes.asUCString}, {name:'service',sortType:Ext.data.SortTypes.asUCString}, {name:'GroupName',sortType:Ext.data.SortTypes.asUCString}, {name:'test',sortType:Ext.data.SortTypes.asUCString}, {name:'measureOrDesc',sortType:Ext.data.SortTypes.asUCString}, {name:'user',sortType:Ext.data.SortTypes.asUCString}, 'starttime', 'duration', 'durationInSec', 'graph', 'ack_status', 'ack_time', {name:'ack_user',sortType:Ext.data.SortTypes.asUCString}, 'reponsetime', 'responseTimeInSec', 'dd'],
				proxy : {
					type : 'pagingmemory',
					reader : {
						type : 'json'
					}
				},
				pageSize:this.pageLimit,
				autoLoad : true,
				data : this.dataArray,
				remoteSort: true,
				id: 'tmpStore'
			});
			var thisForm = Ext.getCmp("operationAlarmHistory").getForm();
			var hideUserColumn=true;
			var hideGroupName=true;
			var hideDDColumn=true;
			var isAckReport = false;
			var durationWidth = 80;
			//var usercolumn = thisForm.findField("enableUserCombo").getValue();
			var usercolumn = appConstants.publicjsonData['hiddenfields']['enableUserCombo'];

			//var alarmType = thisForm.findField("alarmType").getValue();
			var alarmType = appConstants.publicjsonData['hiddenfields']['alarmType'];
 			if (usercolumn != null && usercolumn != 'undefined'  && usercolumn =='yes' && appConstants.AlluserSelected)
			{
				hideUserColumn=false;
			}
 			if (this.screenLabels["GroupName"] != undefined && this.screenLabels["GroupName"] != 'undefined')
			{
				hideGroupName=false;
			}
			if (alarmType != null && alarmType != 'undefined'  && alarmType =='KNOWN')
			{
				hideDDColumn=false;
			}
			if (alarmType != null && alarmType != 'undefined'  && alarmType =='ACKNOWLEDGEMENT')
			{
				hideDDColumn=false;
				isAckReport = true;
				durationWidth = 130;
			}
			this.columns = [
				{
					dataIndex:'severity',
					header:'',
					align:'center',
					locked:true,
					width:35,
 					sortable:false,
					hideable:false,
					menuDisabled:true,
					renderer: function(val,metaData)
					{
						metaData.tdCls="iconColumn";
						var getStatus = '<div style="position:relative;height:16px;"><span class="state_'+val+'" style="margin:0px;padding:0px;width:16px;height:16px;position:absolute;display:block;"></span></div>';
						return getStatus;
					}
				},
				{
					header : !Ext.isEmpty(this.screenLabels["compType"])?this.screenLabels["compType"]:"Comp Type",
					dataIndex:'compType',
					align:'left',
					minWidth:180,
					flex:4,
					renderer: function(val,meta)
					{
						meta.tdAttr = 'data-qclass=yellowTip data-qtip="'+val.trim()+'"';
						return val;
					}
				},
				{
					header : !Ext.isEmpty(this.screenLabels["compName"])?this.screenLabels["compName"]:"Comp Name",
					dataIndex:'compName',
					align:'left',
					minWidth:130,
					locked:true,
					flex:3,
					renderer: function(val,meta)
					{
						if (val.indexOf('~') > -1) {
							var text = val.substring(0, val.indexOf('~'));
							var url = val.substring(val.indexOf('~') + 1);
							//prakash
							//var er_rmDispName = 'Operation Reports';
							//url = url+'er_RmDispName='+er_rmDispName;
							//
							if (appConstants.menuForVM=='true')
							{
								url+='&menuForVM=true';
							}
							val = '<a href="javascript:void(0);" onClick="window.location.href=\'' + url + '\'" class="anchorLinkDefault" >' + text + '</a>';
							meta.tdAttr = 'data-qclass=yellowTip data-qtip="'+text.trim()+'"';
						}
						else
							meta.tdAttr = 'data-qclass=yellowTip data-qtip="'+val.trim()+'"';
						return val;
					}
				},
				{
					header : !Ext.isEmpty(this.screenLabels["SERVICE"])?this.screenLabels["SERVICE"]:"SERVICE(S)",
					dataIndex:'service',
					align:'left',
					minWidth:130,
					flex:2,
					style:{'text-transform':'none'},
					renderer: function(val,meta)
					{
						if (val.indexOf('~') > -1) {
							var text = val.substring(0, val.indexOf('~'));
							var url = val.substring(val.indexOf('~') + 1);
							if (appConstants.menuForVM=='true')
							{
								url+='&menuForVM=true';
							}
							val = '<a href="javascript:void(0);" onClick="window.location.href=\'' + url + '\'" >' + text + '</a>';
							meta.tdAttr = 'data-qclass=yellowTip data-qtip="'+text.trim()+'"';
						}
						else
							meta.tdAttr = 'data-qclass=yellowTip data-qtip="'+val.trim()+'"';
						return val;
					}
				},
				{
					header : !Ext.isEmpty(this.screenLabels["GroupName"])?this.screenLabels["GroupName"]:"Group name",
					dataIndex:'GroupName',
					align:'left',
					minWidth:130,
					hidden:hideGroupName,
					flex:2,
					style:{'text-transform':'none'},
					renderer: function(val,meta)
					{
						if (val.indexOf('~') > -1) {
							var text = val.substring(0, val.indexOf('~'));
							var url = val.substring(val.indexOf('~') + 1);
							if (appConstants.menuForVM=='true')
							{
								url+='&menuForVM=true';
							}
							val = '<a href="javascript:void(0);" onClick="window.location.href=\'' + url + '\'" >' + text + '</a>';
							meta.tdAttr = 'data-qclass=yellowTip data-qtip="'+text.trim()+'"';
						}
						else
							meta.tdAttr = 'data-qclass=yellowTip data-qtip="'+val.trim()+'"';
						return val;
					}
				},
				{
					header : !Ext.isEmpty(this.screenLabels["test"])?this.screenLabels["test"]:"Test",
					dataIndex:'test',
					align:'left',
					minWidth:130,
					flex:2,
					renderer: function(val,meta)
					{
						meta.tdAttr = 'data-qclass=yellowTip data-qtip="'+val.trim()+'"';
						return val;
					}
				},
				{
					header :this.screenLabels["measureOrDesc"],
					dataIndex:'measureOrDesc',
					minWidth:240,
					flex:5,
					renderer: function(val,meta)
					{
						meta.tdAttr = 'data-qclass=yellowTip data-qtip="'+val.trim()+'"';
						return val;
					}
				},
				{
					header : !Ext.isEmpty(this.screenLabels["user"])?this.screenLabels["user"]:"User(s)",
					dataIndex:'user',
					align:'left',
					hidden:hideUserColumn,
					//width:130,
					//flex:2,
					style:{'text-transform':'none'},
					renderer: function(val,meta)
					{
						meta.tdAttr = 'data-qclass=yellowTip data-qtip="'+val.trim()+'"';
						return val;
					}
				},
				{
					header : !Ext.isEmpty(this.screenLabels["starttime"])?this.screenLabels["starttime"]:"Start Time",
					dataIndex:'starttime',
					align:'left',
					minWidth:130,
					//flex:2,
					renderer: function(val,meta)
					{
						meta.tdAttr = 'data-qclass=yellowTip data-qtip="'+val.trim()+'"';
						return val;
					},
					doSort: function(state)
					{
						var ds = this.up('grid').store;
						var field = this.getSortParam();
						ds.sort({
							property: field,
							direction: state,
							sorterFn: function(v1, v2){
								v1 = v1.get(field);
								v2 = v2.get(field);
								if(v1.indexOf('.')>-1 && v1.indexOf(' ')>-1)
								{
									var tmp = v1.substring(0, v1.lastIndexOf(' '));

									var dateobj=new Date(Ext.Date.parse(tmp, mgrDateFormat));
									var formDate = Ext.Date.dateFormat(dateobj, getExtjsDateFormat('MMM-dd-yyyy'));
									v1 = formDate + v1.substring(v1.lastIndexOf(' '), v1.length);
								}
								if(v2.indexOf('.')>-1 && v2.indexOf(' ')>-1)
								{
									var tmp = v2.substring(0, v2.lastIndexOf(' '));

									var dateobj=new Date(Ext.Date.parse(tmp, mgrDateFormat));
									var formDate = Ext.Date.dateFormat(dateobj, getExtjsDateFormat('MMM-dd-yyyy'));
									v2 = formDate + v2.substring(v2.lastIndexOf(' '), v2.length);
								}																
								if(!isNaN(new Date(v1)) && !isNaN(new Date(v2)))
								{
									v2=new Date(v2).getTime(); 
									v1=new Date(v1).getTime(); 
								}
								return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
							}
						});
					}
				},
				{
					header : !Ext.isEmpty(this.screenLabels["duration"])?this.screenLabels["duration"]:"Duration",
					dataIndex:'duration',
					align:'left',
					//flex:3,
					minWidth:durationWidth,
					renderer: function(val,meta)
					{
						meta.tdAttr = 'data-qclass=yellowTip data-qtip="'+val.trim()+'"';
						return val;
					},
					doSort: function(state)
					{
						var ds = this.up('grid').store;
						var field = this.getSortParam();
						field = 'durationInSec';
						ds.sort({
							property: field,
							direction: state,
							sorterFn: function(v1, v2)
							{
								v1 = v1.get(field);
								v2 = v2.get(field);
								v1 = Ext.isNumber(v1) ? v1 : parseFloat(String(v1), 10);
								v1= isNaN(v1) ? 0 : v1;

								v2 = Ext.isNumber(v2) ? v2 : parseFloat(String(v2), 10);
								v2= isNaN(v2) ? 0 : v2;
								return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
							}
						});
					}
				},
				{
					header : !Ext.isEmpty(this.screenLabels["ack_status"])?this.screenLabels["ack_status"]:"Status",
					dataIndex:'ack_status',
					align:'left',
					minWidth:130,
					//flex:2,
					hidden:!isAckReport,
					renderer: function(val,meta)
					{
						meta.tdAttr = 'data-qclass=yellowTip data-qtip="'+val.trim()+'"';
						return val;
					}
				},
				{
					header : !Ext.isEmpty(this.screenLabels["reponsetime"])?this.screenLabels["reponsetime"]:"Response time",
					dataIndex:'reponsetime',
					align:'left',
					minWidth:130,
					//flex:2,
					hidden:!isAckReport,
					renderer: function(val,meta)
					{
						meta.tdAttr = 'data-qclass=yellowTip data-qtip="'+val.trim()+'"';
						return val;
					},
					doSort: function(state)
					{
						var ds = this.up('grid').store;
						var field = this.getSortParam();
						field = 'responseTimeInSec';
						ds.sort({
							property: field,
							direction: state,
							sorterFn: function(v1, v2)
							{
								v1 = v1.get(field);
								v2 = v2.get(field);
								v1 = Ext.isNumber(v1) ? v1 : parseFloat(String(v1), 10);
								v1= isNaN(v1) ? 0 : v1;

								v2 = Ext.isNumber(v2) ? v2 : parseFloat(String(v2), 10);
								v2= isNaN(v2) ? 0 : v2;
								return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
							}
						});
					}
				},
				{
					header : !Ext.isEmpty(this.screenLabels["ack_user"])?this.screenLabels["ack_user"]:"Acknowledged by",
					dataIndex:'ack_user',
					align:'left',
					minWidth:140,
					//flex:2,
					hidden:!isAckReport,
					renderer: function(val,meta)
					{
						meta.tdAttr = 'data-qclass=yellowTip data-qtip="'+val.trim()+'"';
						return val;
					}
				},
				{
					header : !Ext.isEmpty(this.screenLabels["ack_time"])?this.screenLabels["ack_time"]:"Time",
					dataIndex:'ack_time',
					align:'center',
					minWidth:140,
					//flex:1,
					hidden:!isAckReport,
					renderer: function(val,meta)
					{
						meta.tdAttr = 'data-qclass=yellowTip data-qtip="'+val.trim()+'"';
						return val;
					},
					doSort: function(state)
					{
						var ds = this.up('grid').store;
						var field = this.getSortParam();
						ds.sort({
							property: field,
							direction: state,
							sorterFn: function(v1, v2){
								v1 = v1.get(field);
								v2 = v2.get(field);
								if(v1.indexOf('.')>-1 && v1.indexOf(' ')>-1)
								{
									var tmp = v1.substring(0, v1.lastIndexOf(' '));

									var dateobj=new Date(Ext.Date.parse(tmp, mgrDateFormat));
									var formDate = Ext.Date.dateFormat(dateobj, getExtjsDateFormat('MMM-dd-yyyy'));
									v1 = formDate + v1.substring(v1.lastIndexOf(' '), v1.length);
								}
								if(v2.indexOf('.')>-1 && v2.indexOf(' ')>-1)
								{
									var tmp = v2.substring(0, v2.lastIndexOf(' '));

									var dateobj=new Date(Ext.Date.parse(tmp, mgrDateFormat));
									var formDate = Ext.Date.dateFormat(dateobj, getExtjsDateFormat('MMM-dd-yyyy'));
									v2 = formDate + v2.substring(v2.lastIndexOf(' '), v2.length);
								}																
								if(!isNaN(new Date(v1)) && !isNaN(new Date(v2)))
								{
									v2=new Date(v2).getTime(); 
									v1=new Date(v1).getTime(); 
								}
								return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
							}
						});
					}
				},
				{

					header : !Ext.isEmpty(this.screenLabels["graph"])?this.screenLabels["graph"]:"Graph",
					dataIndex:'graph',
					align:'center',
					width:60,
					sortable:false,
					menuDisabled:true,
					renderer: function(val, metaData)
					{
						metaData.tdCls="iconColumn";
						//return '<div style="position:relative;height:13px;align:center"><span class="iconLineChart" onClick=\'javascript:loadUrlInDrillDown("{val}");\' style="margin:0px;padding:0px;width:20px;height:20px;position:absolute;display:block;top:-4px"></span></div>';
						return '<div data-qclass=yellowTip data-qtip="Graph" style="position:relative;height:16px;align:center"><div class="iconLineChart" onClick=\'javascript:loadUrlInDrillDown("'+val+'");\' style="margin:0px;padding:0px;width:16px;height:16px;position:absolute;display:block;cursor:pointer;margin-left: 10px;"></div></div>';
					}
				},
				{
					header : !Ext.isEmpty(this.screenLabels["DD"])?this.screenLabels["DD"]:"DD",
					dataIndex:'dd',
					width:45,
					align:'left',
					
						style:{
							"text-align":"left"
							},
					
					sortable:false,
					menuDisabled:true,
					hidden:hideDDColumn,
					renderer:function(val,metaData){
						if(val != '-')
						{
							metaData.tdCls="iconColumn";
							return '<div data-qclass=yellowTip data-qtip="DD" style="position:relative;height:16px;"><span class="iconDiagnosis" onClick=\'javascript:loadPopup("'+val+'");\' style="margin:0px;padding:0px;width:16px;height:16px;position:absolute;display:block;cursor:pointer"></span></div>';
						}
						else
						{
							metaData.tdCls="iconColumn";
							return '<div style="position:relative;height:16px;align:center"><span style="margin:0px;padding:0px;width:16px;height:16px;position:absolute;display:block;"></span></div>';
						}

					}
				}
			];

			this.dockedItems=[{
				xtype:'pagingtoolbar',
				cls:'newPagination',
				layout:{
						type:'hbox',
						align:'stretch',
						pack:'center'
					},
				dock: 'bottom',
				displayInfo: true,
				id:'id-pagingtoobar',
				pageSize:this.pageLimit,
				store: this.store,
				displayInfo: true,
				displayMsg: 'Displaying topics {0} - {1} of {2}',
				emptyMsg: "",
				
			}
		]
			this.callParent();
		}
});