var stmin = '';
var enmin = '';
var mgr_stmin = '';
var mgr_enmin = '';
var isTrend = false;
Ext.define('OperationAlarmsHistory.view.TimeLine',
{
	alias: 'widget.timeline',
	requires: ['utilities.DatePicker', 'utilities.ScrollCombo'],
	extend: 'Ext.form.FieldContainer',
	layout: 'column',
	erUtils: null,
	gtype: '',
	hideMinutes : true,
	selectedMgrStMin : '',
	selectedMgrEndMin : '',
	selectedStMinForDisplay : '',
	selectedEndminForDisplay : '',
	defaults:
	{
		labelAlign: 'top',
		margin: "0 10 10 0",
		labelSeparator: '',
		editable: false
	},
	initComponent: function()
	{
		if (window['moduleEntry']!=undefined)
		{
			if (!Ext.isEmpty(moduleEntry) && moduleEntry == 'reporter')
			{
				this.items = this.getReporterTimelineItems();
			}
			else
			{
				this.items = this.getTimelineItems();
			}
		}
		else
		{
			this.items = this.getTimelineItems();
		}
		this.callParent();
	},
	getReporterTimelineItems: function()
	{
		return [
		{
			xtype: 'scrollcombo',
			fieldLabel: timelineLbl,
			id: 'er_timeline',
			name: 'er_timeline',
			displayField: 'displayField',
			valueField: 'valueField',
			queryMode: 'local',
			store: Ext.data.Store(
			{
				fields: ['displayField', 'valueField'],
				data: []
			}),
			width: 90,
			cls: 'dropdown',
			defaultListConfig:
			{
				loadingHeight: 70,
				minWidth: 90,
				maxHeight: 340,
				shadow: 'sides'
			},
			listeners:
			{
				'boxready': function(obj)
				{
					var stDateObj = Ext.getCmp('er_stdate');
					var enDateObj = Ext.getCmp('er_enddate');
					var stHourObj = Ext.getCmp('er_sthr');
					var enHourObj = Ext.getCmp('er_endhr');
					var erModeObj = Ext.getCmp('er_mode');

					if (obj.getValue() == 'Any')
					{
						stDateObj.setDisabled(false);
						enDateObj.setDisabled(false);
						stHourObj.setDisabled(false);
						enHourObj.setDisabled(false);
					}
					else
					{
						stDateObj.setDisabled(true);
						enDateObj.setDisabled(true);
						stHourObj.setDisabled(true);
						enHourObj.setDisabled(true);

					}
					erModeObj.hide();
				},
				'select': function(obj)
				{

					var stDateObj = Ext.getCmp('er_stdate');
					var enDateObj = Ext.getCmp('er_enddate');
					var stHourObj = Ext.getCmp('er_sthr');
					var enHourObj = Ext.getCmp('er_endhr');
					var erModeObj = Ext.getCmp('er_mode');
					if (obj.getValue() == 'Any')
					{
						stDateObj.setDisabled(false);
						enDateObj.setDisabled(false);
						stHourObj.setDisabled(false);
						enHourObj.setDisabled(false);
					}
					else
					{
						stDateObj.setDisabled(true);
						enDateObj.setDisabled(true);
						stHourObj.setDisabled(true);
						enHourObj.setDisabled(true);
					}
					{
						var timeline = obj.getValue();
						var strtdt = stDateObj.getValue();
						var enddt = enDateObj.getValue();
						var strthour = stHourObj.getValue();
						var endhr = enHourObj.getValue();

						strtdt = Ext.Date.dateFormat(strtdt, mgrDateFormat);
						enddt = Ext.Date.dateFormat(enddt, mgrDateFormat);
						var param = "C=id&P0=[" + timeline + "]&P1=[" + strtdt + "]&P2=[" + enddt + "]&P3=[" + strthour + "]&P4=[" + endhr + "]";
						if (isTrend == true)
						{
							param += "&P5=[" + stmin + "]&P6=[" + enmin + "]&P7=[" + dateFormatForTimeline + "]&F=getTrendTime";
						}
						else
						{
							param += "&P5=[" + dateFormatForTimeline + "]&F=getTime";
						}
						Ext.Ajax.request(
						{
							url: '/final/servlet/com.eg.ErRemoteScriptingServlet',
							params: param,
							scope: this,
							method: 'POST',
							success: function(response)
							{
								var jsontext = response.responseText;
								var jsonData = Ext.decode(jsontext);
								if (!Ext.isEmpty(jsonData))
								{
									var timedata = jsonData.timeline;
									var startDate = timedata[0];
									var startHr = timedata[2];
									var StartMin = timedata[4];
									var endDate = timedata[1];
									var endHr = timedata[3];
									var endMin = timedata[5];
									stDateObj.dataArray = timedata[0];
									enDateObj.dataArray = timedata[1];
									stHourObj.dataArray = timedata[2];
									enHourObj.dataArray = timedata[3];
									mgr_stmin = timedata[4];
									mgr_enmin = timedata[5];
									stDateObj.setValue(timedata[6]);
									enDateObj.setValue(timedata[7]);
									stHourObj.setValue(timedata[8]);
									enHourObj.setValue(timedata[9]);
									stmin = timedata[10];
									enmin = timedata[11];

									var startDateTime = startDate + " " + startHr + ":" + StartMin;
									var endDateTime = endDate + " " + endHr + ":" + endMin;
									getResultType(startDateTime, endDateTime, dateFormatForTimeline);
								    //enDateObj.getPicker().setMaxDate(new Date(timedata[12]));
									/*if (window['appConstants']!=undefined && appConstants.appController!='reportermenudashboard.controller.ReporterController')
										{					
											this.up('fieldcontainer').erUtils.toggleGraphCombo(obj.getValue(),stDateObj.getValue(),enDateObj.getValue(),stHourObj.getValue(),enHourObj.getValue(),erModeObj);
										}*/
								}
							}
						});
					}
				}
			}
		},
		{
			xtype: 'datepicker',
			id: 'er_stdate',
			name: 'er_stdate',
			format: mgrDateFormat,
			fieldLabel: fromLbl,
			cls: 'datepicker',
			disabled: true,
			dataArray: null,
			listeners:
			{
				'select': function(obj)
				{

					var timeline = Ext.getCmp("er_timeline").getValue();
					var strtdt = Ext.getCmp("er_stdate").getValue();
					var enddt = Ext.getCmp("er_enddate").getValue();
					var strthour = Ext.getCmp("er_sthr").getValue();
					var endhr = Ext.getCmp("er_endhr").getValue();
					var erModeObj = Ext.getCmp('er_mode');

					/*if (window['appConstants']!=undefined && appConstants.appController!='reportermenudashboard.controller.ReporterController')
						{					
							this.up('fieldcontainer').erUtils.toggleGraphCombo(timeline,strtdt,enddt,strthour,endhr,erModeObj);
						}*/

					if (timeline == "Any")
					{
						strtdt = Ext.Date.dateFormat(strtdt, 'm/d/Y');
						enddt = Ext.Date.dateFormat(enddt, 'm/d/Y');
					}
					else
					{
						strtdt = Ext.Date.dateFormat(strtdt, mgrDateFormat);
						enddt = Ext.Date.dateFormat(enddt, mgrDateFormat);
					}

					var param = "C=id&P0=[" + timeline + "]&P1=[" + strtdt + "]&P2=[" + enddt + "]&P3=[" + strthour + "]&P4=[" + endhr + "]&P5=[" + stmin + "]&P6=[" + enmin + "]&P7=[" + dateFormatForTimeline + "]&F=getTime";

					Ext.Ajax.request(
					{
						url: '/final/servlet/com.eg.ErRemoteScriptingServlet',
						params: param,
						scope: this,
						method: 'POST',
						success: function(response)
						{
							var jsontext = response.responseText;
							var jsonData = Ext.decode(jsontext);
							if (!Ext.isEmpty(jsonData))
							{

								var timedata = jsonData.timeline;
								
								var startDate = timedata[0];
								var startHr = timedata[2];
								var startMin = timedata[4];
								var endDate = timedata[1];
								var endHr = timedata[3];
								var endMin = timedata[5];

								Ext.getCmp("er_stdate").dataArray = timedata[0];
								Ext.getCmp("er_enddate").setValue(timedata[7]);
								Ext.getCmp("er_stdate").setValue(timedata[6]);
								Ext.getCmp("er_enddate").dataArray = timedata[1];
								if (!isTrend)
								{
									Ext.getCmp("er_sthr").setValue(timedata[8]);
									Ext.getCmp("er_sthr").dataArray = timedata[2];
									Ext.getCmp("er_endhr").setValue(timedata[9]);
									Ext.getCmp("er_endhr").dataArray = timedata[3];
									stmin = timedata[10];
									enmin = timedata[11];
									mgr_stmin = timedata[4];
									mgr_enmin = timedata[5];
								}

								var startDateTime = startDate + " " + startHr + ":" + startMin;
								var endDateTime = endDate + " " + endHr + ":" + endMin;
								getResultType(startDateTime, endDateTime, dateFormatForTimeline);
							}
						}
					});
				}
			}
		},
		{
			xtype: 'scrollcombo',
			width: 50,
			id: 'er_sthr',
			name: 'er_sthr',
			defaultListConfig:
			{
				loadingHeight: 70,
				minWidth: 50,
				maxHeight: 300,
				shadow: 'sides'
			},
			store: ['00', '01', '02', '03', '04', '05', '06', '07', '08', '09', '10', '11', '12', '13', '14', '15', '16', '17', '18', '19', '20', '21', '22', '23'],
			displayField: 'displayField',
			valueField: 'valueField',
			queryMode: 'local',
			fieldLabel: hrLbl,
			cls: 'dropdown',
			disabled: true,
			dataArray: null,
			listeners:
			{
				'select': function(combo)
				{
					formated_sdate = Ext.Date.dateFormat(Ext.getCmp("er_stdate").getValue(), mgrDateFormat);
					if (stmin == null || stmin == "undefined" || stmin == '')
						stmin = "00"
					var dateValue = formated_sdate + " " + combo.getValue() + ":" + stmin + ":00";

					var param = "date=" + dateValue + "&method=getDateTime&isReverse=true&isFromReporter=true";
					Ext.Ajax.request(
					{
						url: '/final/servlet/com.eg.EgTimeZoneConverterServlet',
						params: param,
						scope: this,
						method: 'POST',
						success: function(response)
						{
							var responseText = response.responseText;
							responseText = Ext.String.trim(responseText);
							var dt = responseText.substring(0, responseText.lastIndexOf(" "));
							var tim = responseText.substring(responseText.lastIndexOf(" ") + 1);

							Ext.getCmp("er_stdate").dataArray = dt;
							Ext.getCmp("er_sthr").dataArray = tim.substring(0, tim.indexOf(":"));
							mgr_stmin = tim.substring(tim.indexOf(":")+1, tim.lastIndexOf(":")); 
						}
					});
				}
			}
		},
		{
			xtype: 'datepicker',
			id: 'er_enddate',
			name: 'er_enddate',
			format: mgrDateFormat,
			fieldLabel: Tolbl,
			cls: 'datepicker',
			//width: 115,
			disabled: true,
			dataArray: null,
			listeners:
			{
				'select': function(obj)
				{
					var timeline = Ext.getCmp("er_timeline").getValue();
					var strtdt = Ext.getCmp("er_stdate").getValue();
					var enddt = Ext.getCmp("er_enddate").getValue();
					var strthour = Ext.getCmp("er_sthr").getValue();
					var endhr = Ext.getCmp("er_endhr").getValue();
					var erModeObj = Ext.getCmp('er_mode');

					/*if (window['appConstants']!=undefined && appConstants.appController!='reportermenudashboard.controller.ReporterController')
						{					
							this.up('fieldcontainer').erUtils.toggleGraphCombo(timeline,strtdt,enddt,strthour,endhr,erModeObj);
						}*/
					if (timeline == "Any")
					{
						strtdt = Ext.Date.dateFormat(strtdt, 'm/d/Y');
						enddt = Ext.Date.dateFormat(enddt, 'm/d/Y');
					}
					else
					{
						strtdt = Ext.Date.dateFormat(strtdt, mgrDateFormat);
						enddt = Ext.Date.dateFormat(enddt, mgrDateFormat);
					}
					var param = "C=id&P0=[" + timeline + "]&P1=[" + strtdt + "]&P2=[" + enddt + "]&P3=[" + strthour + "]&P4=[" + endhr + "]&P5=[" + stmin + "]&P6=[" + enmin + "]&P7=[" + dateFormatForTimeline + "]&F=getTime";

					Ext.Ajax.request(
					{
						url: '/final/servlet/com.eg.ErRemoteScriptingServlet',
						params: param,
						scope: this,
						method: 'POST',
						success: function(response)
						{
							var jsontext = response.responseText;
							var jsonData = Ext.decode(jsontext);
							if (!Ext.isEmpty(jsonData))
							{
								var timedata = jsonData.timeline;

								var startDate = timedata[0];
								var startHr = timedata[2];
								var startMin = timedata[4];
								var endDate = timedata[1];
								var endHr = timedata[3];
								var endMin = timedata[5];

								Ext.getCmp("er_stdate").setValue(timedata[6]);
								Ext.getCmp("er_stdate").dataArray = timedata[0];
								Ext.getCmp("er_enddate").setValue(timedata[7]);
								Ext.getCmp("er_enddate").dataArray = timedata[1];
								if (!isTrend)
								{
									Ext.getCmp("er_sthr").setValue(timedata[8]);
									Ext.getCmp("er_sthr").dataArray = timedata[2];
									Ext.getCmp("er_endhr").setValue(timedata[9]);
									Ext.getCmp("er_endhr").dataArray = timedata[3];
									stmin = timedata[10];
									enmin = timedata[11];
									mgr_stmin = timedata[4];
									mgr_enmin = timedata[5];
								}

								var startDateTime = startDate + " " + startHr + ":" + startMin;
								var endDateTime = endDate + " " + endHr + ":" + endMin;
								getResultType(startDateTime, endDateTime, dateFormatForTimeline);
							}
						}
					});
				}
			}
		},
		{
			xtype: 'scrollcombo',
			width: 50,
			defaultListConfig:
			{
				loadingHeight: 70,
				minWidth: 50,
				maxHeight: 300,
				shadow: 'sides'
			},
			fieldLabel: hrLbl,
			cls: 'dropdown',
			id: 'er_endhr',
			name: 'er_endhr',
			store: ['00', '01', '02', '03', '04', '05', '06', '07', '08', '09', '10', '11', '12', '13', '14', '15', '16', '17', '18', '19', '20', '21', '22', '23'],
			displayField: 'displayField',
			valueField: 'valueField',
			queryMode: 'local',
			disabled: true,
			dataArray: null,
			listeners:
			{
				'select': function(combo)
				{
					formated_sdate = Ext.Date.dateFormat(Ext.getCmp("er_enddate").getValue(), mgrDateFormat);
					if (enmin == null || enmin == "undefined" || enmin == '')
						enmin = "00"
					var dateValue = formated_sdate + " " + combo.getValue() + ":" + enmin + ":00";
					var param = "date=" + dateValue + "&method=getDateTime&isReverse=true&isFromReporter=true";
					Ext.Ajax.request(
					{
						url: '/final/servlet/com.eg.EgTimeZoneConverterServlet',
						params: param,
						scope: this,
						method: 'POST',
						success: function(response)
						{
							var responseText = response.responseText;
							responseText = Ext.String.trim(responseText);
							var dt = responseText.substring(0, responseText.lastIndexOf(" "));
							var tim = responseText.substring(responseText.lastIndexOf(" ") + 1);
							Ext.getCmp("er_enddate").dataArray = dt;
							Ext.getCmp("er_endhr").dataArray = tim.substring(0, tim.indexOf(":"));
							mgr_enmin = tim.substring(tim.indexOf(":")+1, tim.lastIndexOf(":")); 
						}
					});
				}
			}
		},
		{
			xtype: 'combo',
			width: 50,
			defaultListConfig:
			{
				loadingHeight: 70,
				minWidth: 50,
				maxHeight: 300,
				shadow: 'sides'
			},
			id: 'er_mode',
			name: 'er_mode',
			hidden:true,
			fieldLabel: graphLbl,
			margin: "0 20 10 10",
			value: er_modeInTracker,
			cls: 'dropdown',
			store: ['2D', '3D']
		}]
	},
	getTimelineItems: function()
	{
		return [
		{
			xtype: 'scrollcombo',
			fieldLabel: timelineLbl,
			id: 'er_timeline',
			name: 'er_timeline',
			displayField: 'displayField',
			valueField: 'valueField',
			queryMode: 'local',
			store: Ext.data.Store(
			{
				fields: ['displayField', 'valueField'],
				data: []
			}),
			width: 90,
			cls: 'dropdown',
			defaultListConfig:
			{
				loadingHeight: 70,
				minWidth: 90,
				maxHeight: 300,
				shadow: 'sides'
			},
			listeners:
			{
				'boxready': function(obj)
				{
					var stDateObj = Ext.getCmp('er_stdate');
					var enDateObj = Ext.getCmp('er_enddate');
					var stHourObj = Ext.getCmp('er_sthr');
					var enHourObj = Ext.getCmp('er_endhr');
					var erModeObj = Ext.getCmp('er_mode');
					var stMinObj=Ext.getCmp('er_stmin');
					var enMinObj=Ext.getCmp('er_endmin');

					if (obj.getValue() == 'Any')
					{
						stDateObj.setDisabled(false);
						enDateObj.setDisabled(false);
						stHourObj.setDisabled(false);
						enHourObj.setDisabled(false);
						stMinObj.setDisabled(false); 
						enMinObj.setDisabled(false);
					}
					else
					{
						stDateObj.setDisabled(true);
						enDateObj.setDisabled(true);
						stHourObj.setDisabled(true);
						enHourObj.setDisabled(true);
						stMinObj.setDisabled(true); 
						enMinObj.setDisabled(true); 
					}
					erModeObj.hide();
				},
				'select': function(obj)
				{

					var stDateObj = Ext.getCmp('er_stdate');
					var enDateObj = Ext.getCmp('er_enddate');
					var stHourObj = Ext.getCmp('er_sthr');
					var enHourObj = Ext.getCmp('er_endhr');
					var erModeObj = Ext.getCmp('er_mode');
					var stMinObj=Ext.getCmp('er_stmin');
					var enMinObj=Ext.getCmp('er_endmin');
					if (obj.getValue() == 'Any')
					{
						stDateObj.setDisabled(false);
						enDateObj.setDisabled(false);
						stHourObj.setDisabled(false);
						enHourObj.setDisabled(false);
						stMinObj.setDisabled(false); 
						enMinObj.setDisabled(false);

						var timeline = obj.getValue();
						var strtdt = stDateObj.getValue();
						var enddt = enDateObj.getValue();
						var strthour = stHourObj.getValue();
						var endhr = enHourObj.getValue();
						var strtmin = stMinObj.getValue();
						var endmin = enMinObj.getValue();
						var isHideMinutes=this.up('fieldcontainer').hideMinutes;
						if (stmin == '')
						{
							/*var gtype = this.up('fieldcontainer').gtype;
							var dummyTimeline = "1 hour";
							var no_params = "&P0=[" + dummyTimeline + "]&P1=[" + strtdt + "]&P2=[" + enddt + "]&P3=[" + strthour + "]&P4=[" + endhr + "]&P5=[" + dateFormatForTimeline + "]";
							if (gtype != null && (gtype == 'summary' || gtype == 'trend'))
							{
								var period = Ext.getCmp("period").getValue();
								no_params += "&P6=[" + period + "]&P7=[]&F=getTimeForSummary";
								isTrend = true;
							}
							else
							{
								no_params += "&F=getTime";
							}
							var param = "C=id" + no_params;
							Ext.Ajax.request(
							{
								url: '/final/servlet/com.eg.ErRemoteScriptingServlet',
								params: param,
								scope: this,
								method: 'POST',
								success: function(response)
								{

									var jsontext = response.responseText;
									var jsonData = Ext.decode(jsontext);
									if (!Ext.isEmpty(jsonData))
									{
										var timedata = jsonData.timeline;
										stmin = timedata[10];
										enmin = timedata[11];
										mgr_stmin = timedata[4];
										mgr_enmin = timedata[5]; */

										strtdt = Ext.Date.dateFormat(strtdt, 'm/d/Y');
										enddt = Ext.Date.dateFormat(enddt, 'm/d/Y');

										var gtype = this.up('fieldcontainer').gtype;
										var no_params = "&P0=[" + timeline + "]&P1=[" + strtdt + "]&P2=[" + enddt + "]&P3=[" + strthour + "]&P4=[" + endhr + "]&P5=[" + strtmin + "]&P6=[" + endmin + "]&P7=[" + dateFormatForTimeline + "]";
										if (gtype != null && (gtype == 'summary' || gtype == 'trend'))
										{
											var period = Ext.getCmp("period").getValue();
											no_params += "&P8=[" + period + "]&P9=[]&F=getTimeForSummary";
										}
										else
										{
											no_params += "&F=getTime";
											if(!isHideMinutes)
											{
												param +="&P8=true";
											}
										}
										var param = "C=id" + no_params;
										Ext.Ajax.request(
										{
											url: '/final/servlet/com.eg.ErRemoteScriptingServlet',
											params: param,
											scope: this,
											method: 'POST',
											success: function(response)
											{

												var jsontext = response.responseText;
												var jsonData = Ext.decode(jsontext);
												if (!Ext.isEmpty(jsonData))
												{
													var timedata = jsonData.timeline;



													if (!isTrend)
													{

														stDateObj.setValue(timedata[6]);
														stDateObj.dataArray = timedata[0];
														enDateObj.setValue(timedata[7]);
														enDateObj.dataArray = timedata[1];
														stHourObj.setValue(timedata[8]);
														stHourObj.dataArray = timedata[2];
														enHourObj.setValue(timedata[9]);
														enHourObj.dataArray = timedata[3];
														if(!isHideMinutes)
														{
															if((selectedStMinForDisplay!=null && selectedStMinForDisplay!='') && (selectedEndminForDisplay!=null && selectedEndminForDisplay!=''))
															{
																stMinObj.setValue(selectedStMinForDisplay);
																stMinObj.dataArray = selectedMgrStMin;
																enMinObj.setValue(selectedEndminForDisplay);
																enMinObj.dataArray = selectedMgrEndMin;
																this.up('fieldcontainer').selectedStMinForDisplay='';
																this.up('fieldcontainer').selectedMgrStMin='';
																this.up('fieldcontainer').selectedEndminForDisplay='';
																this.up('fieldcontainer').selectedMgrEndMin='';
															}
															else
															{
																stMinObj.setValue(timedata[10]);
																stMinObj.dataArray = timedata[4];
																enMinObj.setValue(timedata[11]);
																enMinObj.dataArray = timedata[5];
															}
														}
														else
														{
															stMinObj.setValue(timedata[10]);
															stMinObj.dataArray = timedata[4];
															enMinObj.setValue(timedata[11]);
															enMinObj.dataArray = timedata[5];
														}
														//stmin = timedata[10];
													   // enmin = timedata[11];
														//mgr_stmin = timedata[4];
														//mgr_enmin = timedata[5];
													}

												}
											}
										});

									//}
								//}
							//});

						}
						else
						{

							strtdt = Ext.Date.dateFormat(strtdt, 'm/d/Y');
							enddt = Ext.Date.dateFormat(enddt, 'm/d/Y');
							var gtype = this.up('fieldcontainer').gtype;
							var no_params = "&P0=[" + timeline + "]&P1=[" + strtdt + "]&P2=[" + enddt + "]&P3=[" + strthour + "]&P4=[" + endhr + "]&P5=[" + strtmin + "]&P6=[" + endmin + "]&P7=[" + dateFormatForTimeline + "]";
							if (gtype != null && (gtype == 'summary' || gtype == 'trend'))
							{
								var period = Ext.getCmp("period").getValue();
								no_params += "&P8=[" + period + "]&P9=[]&F=getTimeForSummary";
								isTrend = true;
							}
							else
							{
								no_params += "&F=getTime";
								if(!isHideMinutes)
								{
									no_params +="&P8=[true]";
								}
							}
							var param = "C=id" + no_params;
							Ext.Ajax.request(
							{
								url: '/final/servlet/com.eg.ErRemoteScriptingServlet',
								params: param,
								scope: this,
								method: 'POST',
								success: function(response)
								{

									var jsontext = response.responseText;
									var jsonData = Ext.decode(jsontext);
									if (!Ext.isEmpty(jsonData))
									{
										var timedata = jsonData.timeline;
										if (!isTrend)
										{
											stDateObj.setValue(timedata[6]);
											stDateObj.dataArray = timedata[0];
											enDateObj.setValue(timedata[7]);
											enDateObj.dataArray = timedata[1];
											stHourObj.setValue(timedata[8]);
											stHourObj.dataArray = timedata[2];
											enHourObj.setValue(timedata[9]);
											enHourObj.dataArray = timedata[3];

											if(!isHideMinutes)
											{
												var selectedStMinForDisplay=this.up('fieldcontainer').selectedStMinForDisplay;
												var selectedEndminForDisplay=this.up('fieldcontainer').selectedEndminForDisplay;
												
												if((selectedStMinForDisplay!=null && selectedStMinForDisplay!='') && (selectedEndminForDisplay!=null && selectedEndminForDisplay!=''))
												{
													var selectedMgrStMin=this.up('fieldcontainer').selectedMgrStMin;
													var selectedMgrEndMin=this.up('fieldcontainer').selectedMgrEndMin;
													stMinObj.setValue(selectedStMinForDisplay);
													stMinObj.dataArray = selectedMgrStMin;
													enMinObj.setValue(selectedEndminForDisplay);
													enMinObj.dataArray = selectedMgrEndMin;
													this.up('fieldcontainer').selectedStMinForDisplay='';
													this.up('fieldcontainer').selectedMgrStMin='';
													this.up('fieldcontainer').selectedEndminForDisplay='';
													this.up('fieldcontainer').selectedMgrEndMin='';
												}
												else
												{
													stMinObj.setValue(timedata[10]);
													stMinObj.dataArray = timedata[4];
													enMinObj.setValue(timedata[11]);
													enMinObj.dataArray = timedata[5];
												}
											}
											else
											{
												stMinObj.setValue(timedata[10]);
												stMinObj.dataArray = timedata[4];
												enMinObj.setValue(timedata[11]);
												enMinObj.dataArray = timedata[5];
											}
											/*stmin = timedata[10];
											enmin = timedata[11];
											mgr_stmin = timedata[4];
											mgr_enmin = timedata[5];*/
										}
									}
								}
							});

						}
					}
					else
					{
						stDateObj.setDisabled(true);
						enDateObj.setDisabled(true);
						stHourObj.setDisabled(true);
						enHourObj.setDisabled(true);
						stMinObj.setDisabled(true);
						enMinObj.setDisabled(true);
						var timeline = obj.getValue();
						var strtdt = stDateObj.getValue();
						var enddt = enDateObj.getValue();
						var strthour = stHourObj.getValue();
						var endhr = enHourObj.getValue();
						var strtmin = stMinObj.getValue();
						var endmin = enMinObj.getValue();

						if (timeline == "Any")
						{
							strtdt = Ext.Date.dateFormat(strtdt, 'm/d/Y');
							enddt = Ext.Date.dateFormat(enddt, 'm/d/Y');
						}
						else
						{
							strtdt = Ext.Date.dateFormat(strtdt, mgrDateFormat);
							enddt = Ext.Date.dateFormat(enddt, mgrDateFormat);
						}
						var gtype = this.up('fieldcontainer').gtype;
						var no_params = "&P0=[" + timeline + "]&P1=[" + strtdt + "]&P2=[" + enddt + "]&P3=[" + strthour + "]&P4=[" + endhr + "]&P5=[" + strtmin + "]&P6=[" + endmin + "]&P7=["+ dateFormatForTimeline + "]";
						if (gtype != null && (gtype == 'summary' || gtype == 'trend'))
						{
							var period = Ext.getCmp("period").getValue();
							no_params += "&P8=[" + period + "]&P9=[]&F=getTimeForSummary";
						}
						else
						{
							no_params += "&F=getTime";
						}
						var param = "C=id" + no_params;
						Ext.Ajax.request(
						{
							url: '/final/servlet/com.eg.ErRemoteScriptingServlet',
							params: param,
							scope: this,
							method: 'POST',
							success: function(response)
							{
								var jsontext = response.responseText;
								var jsonData = Ext.decode(jsontext);
								if (!Ext.isEmpty(jsonData))
								{
									var timedata = jsonData.timeline;
									stDateObj.setValue(timedata[6]);
									stDateObj.dataArray = timedata[0];
									enDateObj.setValue(timedata[7]);
									enDateObj.dataArray = timedata[1];
									stHourObj.setValue(timedata[8]);
									stHourObj.dataArray = timedata[2];
									enHourObj.setValue(timedata[9]);
									enHourObj.dataArray = timedata[3];
									stMinObj.setValue(timedata[10]);
									stMinObj.dataArray = timedata[4];
									enMinObj.setValue(timedata[11]);
									enMinObj.dataArray = timedata[5];
									/*stmin = timedata[10];
									enmin = timedata[11];
									mgr_stmin = timedata[4];
									mgr_enmin = timedata[5];
									if (window['appConstants']!=undefined && appConstants.appController!='reportermenudashboard.controller.ReporterController')
									{					
										this.up('fieldcontainer').erUtils.toggleGraphCombo(obj.getValue(),stDateObj.getValue(),enDateObj.getValue(),stHourObj.getValue(),enHourObj.getValue(),erModeObj);
									}*/
								}
							}
						});
					}
				}
			}
		},
		{
			xtype: 'datepicker',
			id: 'er_stdate',
			name: 'er_stdate',
			format: mgrDateFormat,
			fieldLabel: fromLbl,
			cls: 'datepicker',
			//width: 115,
			disabled: true,
			dataArray: null,
			listeners:
			{
				'select': function(obj)
				{
					var stMinObj=Ext.getCmp('er_stmin');
					var enMinObj=Ext.getCmp('er_endmin');

					var timeline = Ext.getCmp("er_timeline").getValue();
					var strtdt = Ext.getCmp("er_stdate").getValue();
					var enddt = Ext.getCmp("er_enddate").getValue();
					var strthour = Ext.getCmp("er_sthr").getValue();
					var endhr = Ext.getCmp("er_endhr").getValue();
					var strtmin = Ext.getCmp("er_stmin").getValue();
					var endmin = Ext.getCmp("er_endmin").getValue();
					var erModeObj = Ext.getCmp('er_mode');
					var isHideMinutes=this.up('fieldcontainer').hideMinutes;
					/*if (window['appConstants']!=undefined && appConstants.appController!='reportermenudashboard.controller.ReporterController')
				{					
					this.up('fieldcontainer').erUtils.toggleGraphCombo(timeline,strtdt,enddt,strthour,endhr,erModeObj);
				}*/

					if (timeline == "Any")
					{
						strtdt = Ext.Date.dateFormat(strtdt, 'm/d/Y');
						enddt = Ext.Date.dateFormat(enddt, 'm/d/Y');
					}
					else
					{
						strtdt = Ext.Date.dateFormat(strtdt, mgrDateFormat);
						enddt = Ext.Date.dateFormat(enddt, mgrDateFormat);
					}

					var no_params = "&P0=[" + timeline + "]&P1=[" + strtdt + "]&P2=[" + enddt + "]&P3=[" + strthour + "]&P4=[" + endhr + "]&P5=[" + strtmin + "]&P6=[" + endmin + "]&P7=[" + dateFormatForTimeline + "]";
					var gtype = this.up('fieldcontainer').gtype;
					if (gtype != null && (gtype == 'summary' || gtype == 'trend'))
					{
						var period = Ext.getCmp("period").getValue();
						no_params += "&P8=[" + period + "]&P9=[]&F=getTimeForSummary";
						isTrend = true;
					}
					else
					{
						no_params += "&F=getTime";
						if(!isHideMinutes)
						{
							no_params +="&P8=[true]";
						}
					}
					var param = "C=id" + no_params;
					Ext.Ajax.request(
					{
						url: '/final/servlet/com.eg.ErRemoteScriptingServlet',
						params: param,
						scope: this,
						method: 'POST',
						success: function(response)
						{
							var jsontext = response.responseText;
							var jsonData = Ext.decode(jsontext);
							if (!Ext.isEmpty(jsonData))
							{

								var timedata = jsonData.timeline;

								Ext.getCmp("er_stdate").dataArray = timedata[0];
								Ext.getCmp("er_enddate").setValue(timedata[7]);
								Ext.getCmp("er_stdate").setValue(timedata[6]);
								Ext.getCmp("er_enddate").dataArray = timedata[1];
								if (!isTrend)
								{
									Ext.getCmp("er_sthr").setValue(timedata[8]);
									Ext.getCmp("er_sthr").dataArray = timedata[2];
									Ext.getCmp("er_endhr").setValue(timedata[9]);
									Ext.getCmp("er_endhr").dataArray = timedata[3];
									Ext.getCmp("er_stmin").setValue(timedata[10]);
									Ext.getCmp("er_stmin").dataArray = timedata[4];
									Ext.getCmp("er_endmin").setValue(timedata[11]);
									Ext.getCmp("er_endmin").dataArray = timedata[5];
									/*stmin = timedata[10];
									enmin = timedata[11];
									mgr_stmin = timedata[4];
									mgr_enmin = timedata[5];*/

									if(!isHideMinutes)
									{
										var selectedStMinForDisplay=this.up('fieldcontainer').selectedStMinForDisplay;
										var selectedEndminForDisplay=this.up('fieldcontainer').selectedEndminForDisplay;
										
										if((selectedStMinForDisplay!=null && selectedStMinForDisplay!='') && (selectedEndminForDisplay!=null && selectedEndminForDisplay!=''))
										{
											var selectedMgrStMin=this.up('fieldcontainer').selectedMgrStMin;
											var selectedMgrEndMin=this.up('fieldcontainer').selectedMgrEndMin;
											stMinObj.setValue(selectedStMinForDisplay);
											stMinObj.dataArray = selectedMgrStMin;
											enMinObj.setValue(selectedEndminForDisplay);
											enMinObj.dataArray = selectedMgrEndMin;
											this.up('fieldcontainer').selectedStMinForDisplay='';
											this.up('fieldcontainer').selectedMgrStMin='';
											this.up('fieldcontainer').selectedEndminForDisplay='';
											this.up('fieldcontainer').selectedMgrEndMin='';
										}
										else
										{
											stMinObj.setValue(timedata[10]);
											stMinObj.dataArray = timedata[4];
											enMinObj.setValue(timedata[11]);
											enMinObj.dataArray = timedata[5];
										}
									}
								}
							}
						}
					});
				}
			}
		},
		{
			xtype: 'scrollcombo',
			width: 50,
			id: 'er_sthr',
			name: 'er_sthr',
			defaultListConfig:
			{
				loadingHeight: 70,
				minWidth: 50,
				maxHeight: 300,
				shadow: 'sides'
			},
			store: ['00', '01', '02', '03', '04', '05', '06', '07', '08', '09', '10', '11', '12', '13', '14', '15', '16', '17', '18', '19', '20', '21', '22', '23'],
			displayField: 'displayField',
			valueField: 'valueField',
			queryMode: 'local',
			fieldLabel: hrLbl,
			cls: 'dropdown',
			disabled: true,
			dataArray: null,
			listeners:
			{
				'select': function(combo)
				{
					formated_sdate = Ext.Date.dateFormat(Ext.getCmp("er_stdate").getValue(), mgrDateFormat);
					if (stmin == null || stmin == "undefined" || stmin == '')
						stmin = "00"
					var dateValue = formated_sdate + " " + combo.getValue() + ":" + stmin + ":00";


					var param = "date=" + dateValue + "&method=getDateTime&isReverse=true&isFromReporter=true";
					Ext.Ajax.request(
					{
						url: '/final/servlet/com.eg.EgTimeZoneConverterServlet',
						params: param,
						scope: this,
						method: 'POST',
						success: function(response)
						{


							var responseText = response.responseText;
							responseText = Ext.String.trim(responseText);
							var dt = responseText.substring(0, responseText.lastIndexOf(" "));
							var tim = responseText.substring(responseText.lastIndexOf(" ") + 1);

							if (!isTrend)
							{
								if (tim != null && (tim.indexOf(":") == tim.lastIndexOf(":")))
								{
									Ext.getCmp("er_sthr").dataArray = tim.substring(0, tim.indexOf(":"));
								}
								else if (tim != null && tim.length > 0 && tim.indexOf(":") > -1)
								{
									Ext.getCmp("er_sthr").dataArray = tim.substring(0, tim.indexOf(":"));

								}
							}
						}
					});
				}
			}
		},
		{
			xtype: 'scrollcombo',
			width: 50,
			id: 'er_stmin',
			name: 'er_stmin',
			defaultListConfig: {
				loadingHeight: 70,
				minWidth: 50,
				maxHeight: 300,
				shadow: 'sides'
			},
			store: ['00', '01', '02', '03', '04', '05', '06', '07', '08', '09', '10', '11', '12', '13', '14', '15', '16', '17', '18', '19', '20', '21', '22', '23','24','25','26','27','28','29','30','31','32','33','34','35','36','37','38','39','40','41','42','43','44','45','46','47','48','49','50','51','52','53','54','55','56','57','58'],
			displayField: 'displayField',
			valueField: 'valueField',
			queryMode: 'local',
			fieldLabel: minLbl,
			cls: 'dropdown',
			disabled: true,
			hidden : this.hideMinutes,
			dataArray: null,
			listeners: {
				'select': function (combo) {
					formated_sdate = Ext.Date.dateFormat(Ext.getCmp("er_stdate").getValue(),mgrDateFormat);
					var dateValue = formated_sdate + " " + Ext.getCmp("er_sthr").getValue() + ":" + combo.getValue() + ":00";
					var param = "date=" + dateValue + "&method=getDateTime&isReverse=true&isFromReporter=true";
					Ext.Ajax.request({
						url: '/final/servlet/com.eg.EgTimeZoneConverterServlet',
						params: param,
						scope: this,
						method: 'POST',
						success: function (response) {
							var responseText = response.responseText;
							responseText = Ext.String.trim(responseText);
							var dt = responseText.substring(0, responseText.lastIndexOf(" "));
							var tim = responseText.substring(responseText.lastIndexOf(" ") + 1);
						   if(!isTrend){
							if (tim != null && (tim.indexOf(":") == tim.lastIndexOf(":"))) {
							   Ext.getCmp("er_stmin").dataArray = '00';
							} else if (tim != null && tim.length > 0 && tim.indexOf(":") > -1) {
								Ext.getCmp("er_stmin").dataArray = tim.substring(tim.indexOf(":")+1,tim.lastIndexOf(":"));
							}
						   }
						}
					});
				}
			}
		},
		{
			xtype: 'datepicker',
			id: 'er_enddate',
			name: 'er_enddate',
			format: mgrDateFormat,
			fieldLabel: Tolbl,
			cls: 'datepicker',
			//width: 115,
			disabled: true,
			dataArray: null,
			listeners:
			{
				'select': function(obj)
				{
					var stMinObj=Ext.getCmp('er_stmin');
					var enMinObj=Ext.getCmp('er_endmin');

					var timeline = Ext.getCmp("er_timeline").getValue();
					var strtdt = Ext.getCmp("er_stdate").getValue();
					var enddt = Ext.getCmp("er_enddate").getValue();
					var strthour = Ext.getCmp("er_sthr").getValue();
					var endhr = Ext.getCmp("er_endhr").getValue();
					var strtmin = Ext.getCmp("er_stmin").getValue();
					var endmin = Ext.getCmp("er_endmin").getValue();
					var erModeObj = Ext.getCmp('er_mode');
					var isHideMinutes=this.up('fieldcontainer').hideMinutes;
					/*if (window['appConstants']!=undefined && appConstants.appController!='reportermenudashboard.controller.ReporterController')
				{					
					this.up('fieldcontainer').erUtils.toggleGraphCombo(timeline,strtdt,enddt,strthour,endhr,erModeObj);
				}*/
					if (timeline == "Any")
					{
						strtdt = Ext.Date.dateFormat(strtdt, 'm/d/Y');
						enddt = Ext.Date.dateFormat(enddt, 'm/d/Y');
					}
					else
					{
						strtdt = Ext.Date.dateFormat(strtdt, mgrDateFormat);
						enddt = Ext.Date.dateFormat(enddt, mgrDateFormat);
					}
					var no_params = "&P0=[" + timeline + "]&P1=[" + strtdt + "]&P2=[" + enddt + "]&P3=[" + strthour + "]&P4=[" + endhr + "]&P5=[" + strtmin + "]&P6=[" + endmin + "]&P7=[" + dateFormatForTimeline + "]";
					var gtype = this.up('fieldcontainer').gtype;
					if (gtype != null && (gtype == 'summary' || gtype == 'trend'))
					{
						var period = Ext.getCmp("period").getValue();
						no_params += "&P8=[" + period + "]&P9=[]&F=getTimeForSummary";
					}
					else
					{
						no_params += "&F=getTime";
						if(!isHideMinutes)
						{
							no_params +="&P8=[true]";
						}
					}
					var param = "C=id" + no_params;
					Ext.Ajax.request(
					{
						url: '/final/servlet/com.eg.ErRemoteScriptingServlet',
						params: param,
						scope: this,
						method: 'POST',
						success: function(response)
						{
							var jsontext = response.responseText;
							var jsonData = Ext.decode(jsontext);
							if (!Ext.isEmpty(jsonData))
							{
								var timedata = jsonData.timeline;
								Ext.getCmp("er_stdate").setValue(timedata[6]);
								Ext.getCmp("er_stdate").dataArray = timedata[0];
								Ext.getCmp("er_enddate").setValue(timedata[7]);
								Ext.getCmp("er_enddate").dataArray = timedata[1];
								if (!isTrend)
								{

									Ext.getCmp("er_sthr").setValue(timedata[8]);
									Ext.getCmp("er_sthr").dataArray = timedata[2];
									Ext.getCmp("er_endhr").setValue(timedata[9]);
									Ext.getCmp("er_endhr").dataArray = timedata[3];
									Ext.getCmp("er_stmin").setValue(timedata[10]);
									Ext.getCmp("er_stmin").dataArray = timedata[4];
									Ext.getCmp("er_endmin").setValue(timedata[11]);
									Ext.getCmp("er_endmin").dataArray = timedata[5];
									/*stmin = timedata[10];							
									enmin = timedata[11];
									mgr_stmin = timedata[4];
									mgr_enmin = timedata[5];*/

									if(!isHideMinutes)
									{
										var selectedStMinForDisplay=this.up('fieldcontainer').selectedStMinForDisplay;
										var selectedEndminForDisplay=this.up('fieldcontainer').selectedEndminForDisplay;
										
										if((selectedStMinForDisplay!=null && selectedStMinForDisplay!='') && (selectedEndminForDisplay!=null && selectedEndminForDisplay!=''))
										{
											var selectedMgrStMin=this.up('fieldcontainer').selectedMgrStMin;
											var selectedMgrEndMin=this.up('fieldcontainer').selectedMgrEndMin;
											stMinObj.setValue(selectedStMinForDisplay);
											stMinObj.dataArray = selectedMgrStMin;
											enMinObj.setValue(selectedEndminForDisplay);
											enMinObj.dataArray = selectedMgrEndMin;
											this.up('fieldcontainer').selectedStMinForDisplay='';
											this.up('fieldcontainer').selectedMgrStMin='';
											this.up('fieldcontainer').selectedEndminForDisplay='';
											this.up('fieldcontainer').selectedMgrEndMin='';
										}
										else
										{
											stMinObj.setValue(timedata[10]);
											stMinObj.dataArray = timedata[4];
											enMinObj.setValue(timedata[11]);
											enMinObj.dataArray = timedata[5];
										}
									}
								}
							}
						}
					});
				}
			}
		},
		{
			xtype: 'scrollcombo',
			width: 50,
			defaultListConfig:
			{
				loadingHeight: 70,
				minWidth: 50,
				maxHeight: 300,
				shadow: 'sides'
			},
			fieldLabel: hrLbl,
			cls: 'dropdown',
			id: 'er_endhr',
			name: 'er_endhr',
			store: ['00', '01', '02', '03', '04', '05', '06', '07', '08', '09', '10', '11', '12', '13', '14', '15', '16', '17', '18', '19', '20', '21', '22', '23'],
			displayField: 'displayField',
			valueField: 'valueField',
			queryMode: 'local',
			disabled: true,
			dataArray: null,
			listeners:
			{
				'select': function(combo)
				{
					formated_sdate = Ext.Date.dateFormat(Ext.getCmp("er_enddate").getValue(), mgrDateFormat);
					if (enmin == null || enmin == "undefined" || enmin == '')
						enmin = "00"
					var dateValue = formated_sdate + " " + combo.getValue() + ":" + enmin + ":00";
					var param = "date=" + dateValue + "&method=getDateTime&isReverse=true&isFromReporter=true";
					Ext.Ajax.request(
					{
						url: '/final/servlet/com.eg.EgTimeZoneConverterServlet',
						params: param,
						scope: this,
						method: 'POST',
						success: function(response)
						{
							var responseText = response.responseText;
							responseText = Ext.String.trim(responseText);
							var dt = responseText.substring(0, responseText.lastIndexOf(" "));
							var tim = responseText.substring(responseText.lastIndexOf(" ") + 1);
							if (!isTrend)
							{
								if (tim != null && (tim.indexOf(":") == tim.lastIndexOf(":")))
								{
									Ext.getCmp("er_endhr").dataArray = tim.substring(0, tim.indexOf(":"));
								}
								else if (tim != null && tim.length > 0 && tim.indexOf(":") > -1)
								{
									Ext.getCmp("er_endhr").dataArray = tim.substring(0, tim.indexOf(":"));
								}
							}
						}
					});
				}
			}
		},
		{
			xtype: 'scrollcombo',
			width: 50,
			id: 'er_endmin',
			name: 'er_endmin',
			defaultListConfig: {
				loadingHeight: 70,
				minWidth: 50,
				maxHeight: 300,
				shadow: 'sides'
			},
			store: ['00', '01', '02', '03', '04', '05', '06', '07', '08', '09', '10', '11', '12', '13', '14', '15', '16', '17', '18', '19', '20', '21', '22', '23','24','25','26','27','28','29','30','31','32','33','34','35','36','37','38','39','40','41','42','43','44','45','46','47','48','49','50','51','52','53','54','55','56','57','58'],
			displayField: 'displayField',
			valueField: 'valueField',
			queryMode: 'local',
			fieldLabel: minLbl,
			cls: 'dropdown',
			disabled: true,
			hidden : this.hideMinutes,
			dataArray: null,
			listeners: {
				'select': function (combo) {
					formated_sdate = Ext.Date.dateFormat(Ext.getCmp("er_enddate").getValue(),mgrDateFormat);
					var dateValue = formated_sdate + " " + Ext.getCmp("er_endhr").getValue() + ":" + combo.getValue() + ":00";
					var param = "date=" + dateValue + "&method=getDateTime&isReverse=true&isFromReporter=true";
					Ext.Ajax.request({
						url: '/final/servlet/com.eg.EgTimeZoneConverterServlet',
						params: param,
						scope: this,
						method: 'POST',
						success: function (response) {
							var responseText = response.responseText;
							responseText = Ext.String.trim(responseText);
							var dt = responseText.substring(0, responseText.lastIndexOf(" "));
							var tim = responseText.substring(responseText.lastIndexOf(" ") + 1);
						   if(!isTrend){
							if (tim != null && (tim.indexOf(":") == tim.lastIndexOf(":"))) {
							   Ext.getCmp("er_endmin").dataArray = '00';
							} else if (tim != null && tim.length > 0 && tim.indexOf(":") > -1) {
								Ext.getCmp("er_endmin").dataArray = tim.substring(tim.indexOf(":")+1,tim.lastIndexOf(":"));
							}
						   }
						}
					});
				}
			}
		},
		{
			xtype: 'combo',
			width: 50,
			defaultListConfig:
			{
				loadingHeight: 70,
				minWidth: 50,
				maxHeight: 300,
				shadow: 'sides'
			},
			id: 'er_mode',
			name: 'er_mode',
			fieldLabel: graphLbl,
			margin: "0 20 10 10",
			value: er_modeInTracker,
			cls: 'dropdown',
			store: ['2D', '3D']
		}]
	}
});