Ext.define('OperationDetails.controller.Main', {
    extend: 'Ext.app.Controller',
    views: ['Main'],
    refs: [{
            selector: 'main',
            ref: 'main'
        }, {
            selector: 'newUtilities',
            ref: 'newUtilities'
        }, {
            selector: 'emptypanel',
            ref: 'emptypanel'
        },{
			selector: 'ReporterSettings',
			ref: 'ReporterSettings'
        },{
			selector: 'nomeasurepanel',
			ref: 'nomeasurepanel'
		}
    ],
    init: function () {
        this.control({
            'main': {
                'boxready': this.defaulLoading
            },
			'mainform':{
				'afterrender':this.fillMainElements
			},
			'operationssystemdetailsconfig':{
				'afterrender':this.fillSettingsElements
			},
            'newUtilities': {
                'afterrender': this.loadTools
            },
            'newUtilities #saveTool button': {
                'click': this.saveReportAsPDF
            },
            'newUtilities > #printTool > button': {
                'click': this.printFile
            },
            'newUtilities > #mailTool > button': {
                'click': this.sendMail
            },
            'newUtilities > #favoriteTool > button': {
                'click': this.saveFavorite
            },
            'newUtilities > #scheduleTool > button': {
                'click': this.sendToschedule
            },
			'newUtilities > #csvTool > button': {
                'click': this.sendCsv
            },
            'mainform button[id="panelinsidetoggle"]': {
				'click': this.toggleForm
			},
            'operationssystemdetails combo[name="reportFor"]': {
                'select': this.RepotForOnChange
            },
            'operationssystemdetails combo[name="group"]': {
                'select': this.groupOnChange
            },
            'operationssystemdetails combo[name="subZone"]': {
                'select': this.groupOnChange
            },
            'operationssystemdetails combo[name="metric"]': {
                'select': this.metricOnChange
            },
            'mainform button[name="submit"]': {
                'click': this.showResult
            },
            'mainform button[name="save"]': {
                'click': this.goTo
            },
            'operationssystemdetails combo[name="reportType"]': {
                'select': this.reportTypeOnChange
            },
            /* 'operationssystemdetailsconfig combo[name="excludeWeek"]': {
                'select': this.weekendOnChange 
            },*/
            'operationssystemdetailsconfig combo[name="CommonMaximum"]': {
                'select': this.commonMaxOnChange
            },
            'operationssystemdetailsconfig combo[name="autoMaximum"]': {
                'select': this.autoMaxOnChange
            },
            'operationssystemdetailsconfig combo[name="reportGeneration"]': {
                'select': this.reportGenChange
            },
			'reportgeneration button[id="submitViaSetting"]': {
				'click': this.closeSettingAndSubmit
			},
			'reportgeneration button[id="moreOptionCloseId"]': {
				'click': this.validateAndCloseSettings
			},
            'egcomponent button[id="expandSelector"]': {
                'click': this.expandMe
            },
            'operationssystemdetailsconfig combo[name="er_timeline"]': {
                //                'select': this.timeLineOnChange
            },
            'commonPanel': {
              //  render: this.showDrillDown
            },
            'graphpopup combo[name="timeLineDrillDown"]': {
                'select': this.drillDownTimeOnchange
            },
            'graphpopup': {
                'render': this.drilldownResize
            },
            'graphpopup button[name="DrillDownsubmit"]': {
                'click': this.submitDrillDown
            },
            'drilldowntools button[id="print"]': {
                'click': this.drillDownPrint
            },
            'drilldowntools > #saveToolDrill > button': {
                'click': this.drillDownSave
            },
            'drilldowntools button[id="mail"]': {
                'click': this.drillDownMail
            },
			'timeline combo[name="er_mode"]':
             {
                  'select': this.changeEr_mode
             },
			'component trigger[id="compSearch"]':
			{
				'change': this.filterMultiselect
			}
            /*'print' :{
				'afterrender':this.printPageRender
			},*/
        });
    },
	showConfigDropdown:function(){
			isSettingsEnabled=true;
			var thisController = this;
			 var tpl = new Ext.XTemplate('<div style="float:left;margin:0px 0px 0px 0px;">'+settings+'</div><div style="text-align:right;float:right;"><div class="iconCloseNew" id="closeSettings"></div></div>');
			Ext.create('Ext.container.Container',{
			width:565,
			//padding:5,
			id:'configMod',
			//cls:'configMode_popup',
			ui:'settingsWindowContainer',
 			items:[
				{
					xtype:'container',
					cls:'configMode_popupArrow',
					style:{'top':'-14px','left':'355px'}
				},
				{
					xtype:'container',
					html:tpl.apply(),
					cls:'containerHeader',
					style:{'top':'0px','margin':'0px'}
				},
				{
					xtype:'operationssystemdetailsconfig',
					parent: this
				}
			],
			onRender:function(){
				Ext.EventManager.onWindowResize(function () {
					Ext.get('configMod').setStyle('left', '');
				});
				Ext.get('closeSettings').on('click', function () {
					thisController.validateAndCloseSettings();
				});
			},
			renderTo:'opdetails-body'
			});
	},
	closeSettingAndSubmit:function()
	{
		if(this.validateAndCloseSettings())
		{
			this.showResult();
		}
	},
	validateAndCloseSettings :  function()
	{
		var timefrom = Ext.getCmp('timefrom').getValue();
        var minfrom = Ext.getCmp('minfrom').getValue();
        var timeto = Ext.getCmp('timeto').getValue();
        var minto = Ext.getCmp('minto').getValue();
		var autoMaximumvalue = Ext.getCmp('autoMaximum');
        if (!checkTimePeriod(timefrom, minfrom, timeto, minto)) {
            return false;
        }
		if (autoMaximumvalue.getValue() == 'no' && !autoMaximumvalue.isHidden()) {
				var maxObj = Ext.getCmp('maxValue');
				var maxvalue = maxObj.getValue();
				if (maxvalue == "" || !(maxvalue >= 0 || maxvalue <= 0)) {
					Ext.MessageBox.show({
						title: 'Operation Reports Settings',
						msg: 'Wrong Input Value',
						buttons: Ext.MessageBox.OK,
						icon: Ext.MessageBox.WARNING,
						fn:function(val){
								if (val=='ok')
								{
									maxObj.focus();
								}
							}
					});
					return false;
				}
		}
		if (Ext.getCmp('reportGeneration').getValue() == 'background' && !validateTextBoxWithSpecialChars(Ext.getCmp('bgReportName').getValue(),'Attachment',true))
		{
  			return false;
		}
		Ext.getCmp('submit').setDisabled(false);
		Ext.get('configMod').animate({duration: 500,to: {y: -500}});
		return true;
 	},
	 changeEr_mode: function (combo) {
		var hiddenFields=appConstants.publicjsonData["hiddenfields"];
		var favorite_id = hiddenFields["favorite_id"];
		var from_schModify = hiddenFields["fromScheduleModify"];
		if (!(favorite_id == 'undefined' || favorite_id == undefined) || !(from_schModify == null || from_schModify == 'null'))
		{
			return;
		}
		if (isSettingsEnabled)
		{
			Ext.get('configMod').animate({
                    duration: 250,
                    to: {
                        y: -530
                    }
                });
		}

		this.showResult();
     },
	goTo: function (btn) {
		 // by karthikeyan
if (Ext.getCmp('er_timeline').getValue() == 'Any')
		{
				Ext.MessageBox.show({
                        title : 'Operation Reports',
                        msg : 'Chosen timeline not allowed',
                        buttons : Ext.Msg.OK,
                        icon: Ext.MessageBox.WARNING
                    });
				return;
		}
//
 		if ( appConstants.publicjsonData.hiddenfields.fromScheduleModify == "Yes") {
			 this.sendToschedule(btn);
		}else{
 			this.saveFavorite(btn);
		}
    },
    drilldownResize: function (panel) {
        Ext.EventManager.onWindowResize(function () {
            panel.doComponentLayout();
        });
    },
    drillDownMail: function () {
		drillDownParams = '&keyPrefix=enlarged&DrillDown=yes';
        var windowMail = Ext.widget('sendmail');
        windowMail.show();
    },
    drillDownSave: function () {
        var saveQString = appConstants.DrillDownPublicJsonData.printQString;
        var s_qryString = "../reporter/ErHtmlToSavePdf.jsp?er_trgttype=SystemDetails&isSubmit=true&drillDown=yes&sample=yes&drillSes=yes&" + saveQString;
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
        appConstants.erUtils.savePDF(s_qryString);
    },
    drillDownPrint: function () {
        var saveQString = appConstants.DrillDownPublicJsonData.printQString;
         var s_qryString = "/final/reporter/Er53TopNPrintReport.jsp?" + saveQString + "&pdfPrint=yes&er_trgttype=SystemDetails";
        //var printURL = Ext.getCmp('printURL').getValue();
       /* Ext.widget('print').show();
        var printContentDiv = Ext.select('#printContentDiv');
        printContentDiv.set({
            src: s_qryString
        });*/
		parent.printWindowFn(s_qryString);	 //this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
    
    },
	filterMultiselect: function (obj) {
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		obj.toggleTriggger();
		appConstants.erUtils.filterComboStore(obj,Ext.getCmp('systems'),appConstants.publicjsonData['systemCombo']);
    },
    submitDrillDown: function () {
        this.updateDrillDownQueryString();
        //var Qstring=appConstants.DrillDownQueryStringGlobal+"&er_timeline="+timelineVal+"&er_priority="+priorityVal;
        var timelineDrill = Ext.getCmp('timeLineDrillDown').getValue();
        if (timelineDrill == 'Any') {
            var stDateTime = Ext.getCmp('startdateDrillDown').getValue();
            var tmpStartHour = Ext.getCmp('startHourDrillDown').getValue();
            stDateTime.setHours(tmpStartHour);
            var enDateTime = Ext.getCmp('enddateDrillDown').getValue();
            var tmpEndHour = Ext.getCmp('endHourDrillDown').getValue();
            enDateTime.setHours(tmpEndHour);
            if (stDateTime > enDateTime) {
                Ext.MessageBox.show({
                    title: 'Operation Reports',
                    msg: dateValidateError,
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.WARNING
                });
                return;
            }
        }
        Ext.Ajax.request({
            url: '/final/reporter/Er53TopNDrillDownJSON.jsp',
            params: appConstants.DrillDownQueryStringGlobal,
            method: 'POST',
            scope: this,
            success: function (response) {
                var jsonText = response.responseText;
                var jsonData = Ext.decode(jsonText);
                appConstants.DrillDownPublicJsonData = jsonData;
                var drilldownXmlCode = appConstants.DrillDownPublicJsonData.XMLData
                var charidDrilldown = "drillpanel";
                if (drilldownXmlCode != '-') {
					if(appConstants.chartType=='fusionchart')
					{
                    if (FusionCharts(charidDrilldown))
                        FusionCharts(charidDrilldown).dispose();
                    var myChart = new FusionCharts(appConstants.DrillDownPublicJsonData.swfpath, charidDrilldown, "100%", "100%", "0", "1");
                    myChart.setXMLData(drilldownXmlCode);
                    myChart.setTransparent(true);
                    myChart.render('drilldownChartDiv');
					}
					else
					{

					var highChart = {};
							highChart = jQuery.extend(true, {}, getHighChartsBarInstance('drilldownChartDiv',jsonData.chartHeight-20,450), highChart);
							highChart.setData(jsonData,'<%=currentDateFormat%>','');
							highChart.drawChart();
					}
                } else {
	                    Ext.get('drilldownChartDiv').update('<center> <table width="100%" height="100%"><tr><td align="center" valign="middle"><img src="/final/images/'+strSkin+'/nomeasures_custom.png" /></td></tr></table></center>');
                }
            }
        });
    },
    drillDownTimeOnchange: function () {
        //Ext.getCmp('drillDownResultPanel').hide();
        var startDateObj = Ext.getCmp('startdateDrillDown');
        var startHrObj = Ext.getCmp('startHourDrillDown');
        var endDateObj = Ext.getCmp('enddateDrillDown');
        var endHrObj = Ext.getCmp('endHourDrillDown');
        var timelineVal = Ext.getCmp('timeLineDrillDown').getValue();
        //var priorityVal=Ext.getCmp('priorityDrillDown').getValue();

        if (timelineVal == 'Any') {
            startDateObj.setDisabled(false);
            startHrObj.setDisabled(false);
            endDateObj.setDisabled(false);
            endHrObj.setDisabled(false);
        } else {
            this.updateDrillDownQueryString();
            //var Qstring=appConstants.DrillDownQueryStringGlobal+"&er_timeline="+timelineVal+"&er_priority="+priorityVal;
            Ext.Ajax.request({
                url: '/final/reporter/Er53TopNDrillDownJSON.jsp',
                params: appConstants.DrillDownQueryStringGlobal,
                method: 'POST',
                scope: this,
                success: function (response) {
                    var jsonText = response.responseText;
                    var jsonData = Ext.decode(jsonText);
                    appConstants.DrillDownPublicJsonData = jsonData;
                    var start_hour = jsonData.startHourForDisplay;
                    var end_hour = jsonData.endHourForDisplay;
                    var start_date = jsonData.startDate;
                    var end_date = jsonData.endDate;
                    startDateObj.setDisabled(true);
                    startHrObj.setDisabled(true);
                    endDateObj.setDisabled(true);
                    endHrObj.setDisabled(true);
                    startDateObj.setValue(start_date);
                    startHrObj.setValue(start_hour);
                    endDateObj.setValue(end_date);
                    endHrObj.setValue(end_hour);
                }
            });
        }
    },
    updateDrillDownQueryString: function () {
        var priorityVal = Ext.getCmp('priorityDrillDown').getValue();

        var startDateConverted = Ext.Date.dateFormat(Ext.getCmp('startdateDrillDown').getValue(), mgrDateFormat);
        var endDateConverted = Ext.Date.dateFormat(Ext.getCmp('enddateDrillDown').getValue(), mgrDateFormat);

        var timelineParams = "&er_timeline=" + Ext.getCmp('timeLineDrillDown').getValue() + "&startdate=" + startDateConverted + "&enddate=" + endDateConverted + "&starthr=" + Ext.getCmp('startHourDrillDown').getValue() + "&endhr=" + Ext.getCmp('endHourDrillDown').getValue();

        var hiddenfieldQString;
        if (appConstants.DrillDownPublicJsonData.hasOwnProperty('hiddenfields')) {
            var hiddenFields = appConstants.DrillDownPublicJsonData.hiddenfields;
            for (var hiddenField in hiddenFields) {
                hiddenfieldQString += "&" + hiddenField + "=" + hiddenFields[hiddenField];
            }
        }
        appConstants.DrillDownQueryStringGlobal = hiddenfieldQString + timelineParams + "&er_priority=" + priorityVal + "&er_mode=" + Ext.getCmp('graphmodeDrillDown').getValue();
    },
    showDrillDown: function (QueryString) {
  		    var reportTypeChoosen = Ext.getCmp('reportType').getValue();

    // if(reportTypeChoosen=='graph')
    // {
       // c.body.on('mousedown', function () {

           // var QueryString = Ext.getCmp(c.id).dataArray;
             drillDownURL = "/final/reporter/Er53TopNDrillDownJSON.jsp?";
            var htmlstr1 = '<div id="drilldownChartDiv" style="overflow:auto;height:370px;padding:10px;align:center;valign:middle"></div>';

//var htmlstr1 = '<center><table width="100%" height="100%"><tr><td align="center" valign="middle"> <div id="drilldownChartDiv"></div></td</tr></table></center>';
//  Ext.get('drilldownChartDiv').update('<center> <table width="100%" height="100%"><tr><td align="center" valign="middle"><img src="/final/images/nomeasures_custom.png" /></td></tr></table></center>');

            Ext.Ajax.request({
                url: drillDownURL,
                params: QueryString,
                method: 'POST',
                async: false,
                success: function (response) {
                    var jsonText = response.responseText;
                    if (response.status == 200) {
                        //drilldownJsonData = Ext.decode( jsonText );
                        appConstants.DrillDownPublicJsonData = Ext.decode(jsonText);
                    }
                },
                failure: function () {
                    alert('failure calling...');
                }
            });

			var priorityStore,priorityValue;
			if (isSettingsEnabled)
			{
				priorityStore=Ext.getCmp('priority').getStore();
				priorityValue=Ext.getCmp('priority').getValue();
			}
			else
			{
				priorityStore=Ext.create('Ext.data.Store',{
													fields : ['displayField', 'valueField'],
													data :appConstants.publicjsonData.priorityCombo
												});
				priorityValue=appConstants.publicjsonData.selectedPriority;
			}

			var isAnySelected = true;
			if (Ext.getCmp('er_timeline').getValue() == 'Any') {
				isAnySelected = false;
			}

			var graphpopup=Ext.widget('graphpopup');
			graphpopup.add({
				xtype: 'panel',
				ui:'newFormFieldsInPopup popupHeaderBottomBorder',
				margin:5,
				frame:false,
				closable:false,
				scroll:true,
				autoScroll:true,
				height:520,
				closeAction:'destroy',
				title: appConstants.DrillDownPublicJsonData.reportTitle,
				hidden: false,
				layout: {type:'vbox',align:'stretch'},
				tools: [{xtype: 'drilldowntools'}],
				items: [
							{
								xtype: 'form',
 								layout: 'column',
								//cls:'formOuter',
								ui:'newFormPanelForWindow',
								bodyPadding:10,
								margin: '5 10 0 10',
								defaults: {
									margin: '0 20 10 0',
									labelAlign: 'top'
								},
								items: [{
										xtype: 'scrollcombo',
										fieldLabel: 'Show',
										labelAlign: 'top',
										cls: 'dropdown',
										id: 'priorityDrillDown',
										editable: false,
										labelSeparator: '',
										width: 80,
										store: priorityStore,
										value:priorityValue,
										displayField: 'displayField',
										valueField: 'valueField',
										queryMode: 'local'
									},
									{
										fieldLabel: timelineLbl,
										xtype: 'scrollcombo',
										id: 'timeLineDrillDown',
										name: 'timeLineDrillDown',
										displayField: 'displayField',
										valueField: 'valueField',
										labelSeparator: '',
										queryMode: 'local',
										store: Ext.getCmp('er_timeline').getStore(),
										value: Ext.getCmp('er_timeline').getValue(),
										width: 90,
										cls: 'dropdown'
									}, {
										xtype: 'datepicker',
										id: 'startdateDrillDown',
										name: 'startdateDrillDown',
										format: mgrDateFormat,
										fieldLabel: fromLbl,
										cls: 'datepicker',
										value: Ext.getCmp('er_stdate').getValue(),
										width: 100,
										labelSeparator: '',
										disabled: isAnySelected
									}, {
										xtype: 'scrollcombo',
										width: 45,
										id: 'startHourDrillDown',
										name: 'startHourDrillDown',
										store: ['00', '01', '02', '03', '04', '05', '06', '07', '08', '09', '10', '11', '12', '13', '14', '15', '16', '17', '18', '19', '20', '21', '22', '23'],
										value: Ext.getCmp('er_sthr').getValue(),
										queryMode: 'local',
										fieldLabel: hrLbl,
										cls: 'dropdown',
										labelSeparator: '',
										disabled: isAnySelected

									}, {
										xtype: 'datepicker',
										id: 'enddateDrillDown',
										name: 'enddateDrillDown',
										format: mgrDateFormat,
										fieldLabel: Tolbl,
										cls: 'datepicker',
										width: 100,
										labelSeparator: '',
										disabled: isAnySelected,
										value: Ext.getCmp('er_enddate').getValue()
									}, {
										xtype: 'scrollcombo',
										width: 45,

										fieldLabel: hrLbl,
										cls: 'dropdown',
										id: 'endHourDrillDown',
										name: 'endHourDrillDown',
										labelSeparator: '',
										store: ['00', '01', '02', '03', '04', '05', '06', '07', '08', '09', '10', '11', '12', '13', '14', '15', '16', '17', '18', '19', '20', '21', '22', '23'],
										value: Ext.getCmp('er_endhr').getValue(),
										queryMode: 'local',
										labelSeparator: '',
										disabled: isAnySelected
									}, {
										xtype: 'scrollcombo',
										width: 60,
										id: 'graphmodeDrillDown',
										name: 'graphmodeDrillDown',
										fieldLabel: 'Graph',
										value: Ext.getCmp('er_mode').getValue(),
										cls: 'dropdown',
										labelSeparator: '',
										store: ['2D', '3D'],
										hidden:true
									},
									{
										xtype: 'button',
										text: 'Submit',
										//cls: 'button20',
										ui:'newButtonSmall',
										name: 'DrillDownsubmit',
										margin: '20 0 0 0'
									}
								]
							},
							
							{
									//xtype: 'container',
									xtype: 'panel',
									ui:'newGraphPanelForWindow',
									//bodyPadding: '0 0 0 0',
									//cls:'containerShadow',
									id: "drillDownResultPanel",
									//margin:10,
									margin:'10 0 20 0',
									layout:'fit',
									//title:appConstants.DrillDownPublicJsonData.chartTitle,
									html: htmlstr1
							}
						],
						listeners:{
							'close':function(){			 
								var win =Ext.getCmp('graphpopup');
								if(win)win[win.closeAction]();
							},
							'hide':function(){
								var win =Ext.getCmp('graphpopup');
								if(win)win[win.closeAction]();
							}
						},
					});
			graphpopup.show();

            var drilldownXmlCode = appConstants.DrillDownPublicJsonData.XMLData
            var charidDrilldown = "drillpanel";
            if (drilldownXmlCode != '-') {
				if(appConstants.chartType=='fusionchart')
				{
                if (FusionCharts(charidDrilldown))
                    FusionCharts(charidDrilldown).dispose();
                var myChart = new FusionCharts(appConstants.DrillDownPublicJsonData.swfpath, charidDrilldown, "100%", "100%", "0", "1");
                myChart.setXMLData(drilldownXmlCode);
                myChart.setTransparent(true);
                myChart.render('drilldownChartDiv');
				}else
				{
						var highChart = {};
							highChart = jQuery.extend(true, {}, getHighChartsBarInstance('drilldownChartDiv',appConstants.DrillDownPublicJsonData.chartHeight-20,450), highChart);
							highChart.setData(appConstants.DrillDownPublicJsonData,'<%=currentDateFormat%>','');
							highChart.drawChart();
				}
            } else {
                Ext.get('drilldownChartDiv').update('<center> <table width="100%" height="100%"><tr><td align="center" valign="middle"><img src="/final/images/'+strSkin+'/nomeasures_custom.png" /></td></tr></table></center>');
            }

       // });
		//}
    },
    printPageRender: function () {
        var saveQString = appConstants.publicjsonData.saveQstring;
        var s_qryString = "../servlet/com.eg.ErRepoLiteC?" + saveQString;
        var printContentDiv = Ext.select('#printContentDiv');
        printContentDiv.update("<iframe src=" + s_qryString + " width='800' height='500' ></iframe>");
    },
    showResult: function () {
        var isSettingsOk;
		Ext.getCmp('panelinsidetoggle').setDisabled(false);
		Ext.getCmp('resultPanel').hide();
        var component = Ext.getCmp('systems').getValue();
        var reportFor = Ext.getCmp('reportFor').getValue();
        if (reportFor != 'System') {
            var groupcombo = Ext.getCmp('group').getValue();
            if (groupcombo == '-1' || groupcombo == 'Not Applicable') {
                Ext.MessageBox.show({
                    title: 'Operation Reports',
                    msg: Ext.getCmp('group').getStore().getAt(0).get('displayField'),
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.WARNING
                });
                return;
            }
        } else if (component == 'Not Applicable') {
            Ext.MessageBox.show({
                title: 'Operation Reports',
                msg: Ext.getCmp('systems').getStore().getAt(0).get('displayField'),
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.WARNING
            });
            return;
        }
        isSettingsOk= this.validateSettings();
        if(isSettingsOk)
		{
			var getButtonObj = Ext.getCmp('submit');
			getButtonObj.setDisabled(false);
			if (isSettingsEnabled)
			{
				Ext.get('configMod').animate({duration: 500,to: {y: -500}});
			}
			this.formSubmit();
		}
		

    },
    formSubmit: function () {
        this.updateQueryString();
		var localjson=appConstants.publicjsonData;
		var urlforAjax;
        var start_date = localjson.startDate;
        var end_date = localjson.endDate;
        var reportGeneration;

		if (isSettingsEnabled)
		{
			reportGeneration= Ext.getCmp('reportGeneration').getValue();
		}
		else
		{
			reportGeneration=localjson.reportGeneration;
		}

        var hiddenfieldQString = "";
        var finalParams = "";
        var comQuery = "";
        var compArray = new Array();
        compArray = Ext.getCmp('systems').getValue();
        if (localjson.hasOwnProperty('hiddenfields')) {
            var hiddenFields = localjson.hiddenfields;
            for (var hiddenField in hiddenFields) {
                hiddenfieldQString += "&" + hiddenField + "=" + hiddenFields[hiddenField];
            }
        }
        for (var k = 0; compArray.length > k; k++) {
            comQuery += "&er_component=" + compArray[k];
        }

        finalParams = appConstants.queryString + comQuery + hiddenfieldQString + "&option=data&isSubmit=true";
        if (reportGeneration == 'foreground') {
			urlforAjax='../servlet/com.eg.ErRepoLiteC?beta=true';
		} else if (reportGeneration == 'background') {
			urlforAjax='../servlet/com.eg.ErStartBackGroundReportC';
			var bg_reportname;
			if (isSettingsEnabled)
			{
				bg_reportname = Ext.getCmp('bgReportName').getValue();
			}
			else
			{
				bg_reportname=localjson.bgReportName;
			}
				bg_reportname=checkFileName(bg_reportname);
            finalParams += "&bg_reportname=" + bg_reportname;
		}
		else if(reportGeneration == 'background-csv') {
			urlforAjax='../servlet/com.eg.ErStartBackGroundReportC?SaveFormat=CSV';
			var bg_reportname;
			if (isSettingsEnabled)
			{
				bg_reportname = Ext.getCmp('bgReportName').getValue();
			}
			else
			{
				bg_reportname=localjson.bgReportName;
			}
				bg_reportname=checkFileName(bg_reportname);
            finalParams += "&bg_reportname=" + bg_reportname;
		}
		finalParams +="&er_RmDispName="+appConstants.er_RmDispName;
		if(Ext.getCmp('systems').getValue()=='Not Applicable')
		{
			Ext.MessageBox.show({
					title: 'Operation Reports',
					msg: Ext.getCmp('systems').getStore().getAt(0).get('displayField'),
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
					});
					return;
		}
		appConstants.initLdgMask.show();
		this.getEmptypanel().hide();
		Ext.Ajax.request({
			url:urlforAjax,
			params: finalParams,
			scope: this,
			success: function (response) {
				var jsonText = response.responseText;
				var jsonData=Ext.decode(jsonText);
				appConstants.publicjsonData=jsonData;
				this.loadReportData(jsonData);
			}
		});
		
		
    },
	loadReportData:function(jsonData){
		var localjson=appConstants.publicjsonData;
		var resultPanelObj = Ext.getCmp('resultPanel');
        //var selectionDetailsObj = Ext.getCmp('selectionDetails');
        var backgroundresultsObj = Ext.getCmp('backGroundPanel');
       var reportLayout = 'column';
		var reportGeneration=localjson.reportGeneration;
		if(reportGeneration == 'background'){
			var backgroundReportStatus = jsonData.backgroundReportStatus;
			resultPanelObj.hide();
			this.getEmptypanel().hide();
			backgroundresultsObj.show();
			this.getNomeasurepanel().hide();
			if (backgroundReportStatus != 'undefined' && backgroundReportStatus == 'success') {
				var bgroundResponseTxt = jsonData.bgroundResponseTxt;
				var bgroundReportsURL = jsonData.bgroundReportsURL;
				var backgroundAnchor = jsonData.backgroundAnchor;
				var sub = backgroundAnchor.substring(0, backgroundAnchor.length - 3);
				//backgroundresultsObj.update('<center><div style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:480px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconSuccess"></div><div style="margin-top:20px"><b>' + bgroundResponseTxt + '</br><a class="backgroundMsgLink" href="' + bgroundReportsURL + '">' + backgroundAnchor + '</a></div></div></center>');
				backgroundresultsObj.update('<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconSuccess"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+bgroundResponseTxt+'.</br>'+'<a class="backgroundMsgLink" href='+ bgroundReportsURL +'>'+ sub + '</a></div></td></tr></table></td></tr></table>');
			} else if (backgroundReportStatus != 'undefined' && backgroundReportStatus == 'duplicate') {
				var bgroundResponseTxt = jsonData.bgroundResponseTxt;
				var bgroundReportsURL = jsonData.bgroundReportsURL;
				var backgroundAnchor = jsonData.backgroundAnchor;
				var sub = backgroundAnchor.substring(0, backgroundAnchor.length - 3);
				//backgroundresultsObj.update('<center><div style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:480px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconExists"></div><div style="margin-top:20px"><b>' + bgroundResponseTxt + '</br><a class="backgroundMsgLink" href="' + bgroundReportsURL + '">' + backgroundAnchor + '</a></div></div></center>');
				backgroundresultsObj.update('<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconExclamation"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+bgroundResponseTxt+'.</br>'+'<a class="backgroundMsgLink" href='+ bgroundReportsURL +'>'+ sub + '</a></div></td></tr></table></td></tr></table>');
			}
		}
		else if(reportGeneration == 'background-csv')
		{
			var backgroundReportStatus = jsonData.backgroundReportStatus;
			resultPanelObj.hide();
			this.getEmptypanel().hide();
			backgroundresultsObj.show();
			this.getNomeasurepanel().hide();
			if (backgroundReportStatus != 'undefined' && backgroundReportStatus == 'success') {
				var bgroundResponseTxt = jsonData.bgroundResponseTxt;
				var bgroundReportsURL = jsonData.bgroundReportsURL;
				var backgroundAnchor = jsonData.backgroundAnchor;
				var sub = backgroundAnchor.substring(0, backgroundAnchor.length - 3);
				//backgroundresultsObj.update('<center><div style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:480px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconSuccess"></div><div style="margin-top:20px"><b>' + bgroundResponseTxt + '</br><a class="backgroundMsgLink" href="' + bgroundReportsURL + '">' + backgroundAnchor + '</a></div></div></center>');
				backgroundresultsObj.update('<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconSuccess"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+bgroundResponseTxt+'.</br>'+'<a class="backgroundMsgLink" href='+ bgroundReportsURL +'>'+ sub + '</a></div></td></tr></table></td></tr></table>');
			} else if (backgroundReportStatus != 'undefined' && backgroundReportStatus == 'duplicate') {
				var bgroundResponseTxt = jsonData.bgroundResponseTxt;
				var bgroundReportsURL = jsonData.bgroundReportsURL;
				var backgroundAnchor = jsonData.backgroundAnchor;
				var sub = backgroundAnchor.substring(0, backgroundAnchor.length - 3);

				backgroundresultsObj.update('<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconExclamation"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+bgroundResponseTxt+'.</br>'+'<a class="backgroundMsgLink" href='+ bgroundReportsURL +'>'+ sub + '</a></div></td></tr></table></td></tr></table>');
			}
		}
		else{
			backgroundresultsObj.hide();
			resultPanelObj.show();
			var selectedreportType = localjson.selectedReportType
			Ext.getCmp("bookletTool").setDisabled(false);
			Ext.getCmp("saveTool").setDisabled(false);
			Ext.getCmp("printTool").setDisabled(false);
			Ext.getCmp("mailTool").setDisabled(false);
			Ext.getCmp("upbutton").setDisabled(false);
			Ext.getCmp('csvTool').setDisabled(false);
			if (selectedreportType == 'graph') {
				Ext.getCmp('csvTool').setDisabled(true);
				if (localjson.hasOwnProperty('chartData')) {
					var chartArray = localjson.chartData;
					var reportData=localjson.reportData;
					var noOfCharts;
					var hideSelection=false;
					
					var itemsArray = new Array();
					var doms = new Array();
					var itmArry=new Array();
					
					for (var m = 0; chartArray.length > m;m++)
					{
						var chartObjXmlData = chartArray[m].XMLData;
						if (chartObjXmlData != '-')
							hideSelection=true;
					}
					if(!hideSelection){
						Ext.getCmp('resultPanel').hide();
						this.getNomeasurepanel().show();
					}else{
						Ext.getCmp('selectionDetails').setSelectionDetailsData(jsonData.selectionDetails);
					}
					//resultPanelObj.setTitle("<span class='font_bold'>"+localjson.resultTitle+"</span>");
					
					if(appConstants.isForceSubmit=='true')
					{
						reportLayout = 'vbox';
					}
					var content='';
					noOfCharts=0;
					
					for (var i = 0; chartArray.length > i; i++) {
						var chartObj = chartArray[i];
						var charid = "myChartId" + i;
						var xmlcode = chartObj.XMLData;
						var containerId = doms[i];
						
						if (xmlcode != '-') {
							noOfCharts+=1;
							itmArry.push(i);
						}
					}
					if(noOfCharts==1)
						{
							content='<div style="width:100%"><table  width="100%" border="0" class="htmlGraphTable" ><col width="50%"><col width="50%"><tr>';
							//content='<div style="width:100%"><table width="100%" border="0" class="htmlTable"><col width="50%"><col width="50%"><tr>';
							// content='<div style="width:100%"><table width="100%" border="0" class="htmlGraphTable"><col width="50%"><col width="50%"><tr>';//<col width="50%"><col width="50%">
						}else
						{
							//content='<div style="width:100%"><table class="htmlGraphTable" width="100%"  ><col width="50%"><col width="50%"><tr>';
							content='<div style="width:100%"><table width="100%" border="0" class="htmlGraphTable" ><col width="50%"><col width="50%"><tr>';
						}
					var col=0;

					for(var key in itmArry) {
						var evenLastTd=false;
						var j=itmArry[key];
						var chartObj = chartArray[j];
						if (col==2)
						{
							col=0;
							content+='</tr>';
							content+='<tr>';
						}
						if(key == 0){
							if (itmArry.length>2)
							{
								
								//content+='<td style="padding:10px 5px 5px 10px">';
								content+='<td style="padding:0px 5px 10px 10px">';
							}
							else if(itmArry.length==2)
							{
								
								//content+='<td style="padding:10px 5px 10px 10px">';
								content+='<td style="padding:0px 5px 10px 10px">';
							}
							else
							{
							
								//content+='<td style="padding:10px 10px 10px 10px">';
								content+='<td style="padding:0px 5px 10px 10px">';
							}
						}
						else if(key == 1){
							if (itmArry.length>2)
							{
								//content+='<td style="padding:10px 10px 5px 5px">';
								content+='<td style="padding:0px 10px 10px 5px">';
							}
							else
							{
								//content+='<td style="padding:10px 10px 10px 5px">';
								content+='<td style="padding:0px 5px 10px 5px">';
							}
						}
						else if((key%2) == 0){
							if (key==itmArry.length-1)
							{
								evenLastTd=true;
								//content+='<td style="padding:5px 5px 10px 10px">';
								content+='<td style="padding:0px 5px 10px 10px">';
							}
							else if (key==itmArry.length-2)
							{
								//content+='<td style="padding:5px 5px 10px 10px">';
								content+='<td style="padding:0px 5px 10px 10px">';
							}
							else{
								//content+='<td style="padding:5px 5px 5px 10px">';
								content+='<td style="padding:0px 5px 10px 10px">';
							}
						}
						else if((key%2) != 0){
							if (key==itmArry.length-1)
							{
								//content+='<td style="padding:5px 10px 10px 5px">';
								content+='<td style="padding:0px 10px 10px 5px">';
							}
							else{
								//content+='<td style="padding:5px 10px 5px 5px">';
								content+='<td style="padding:0px 10px 10px 5px">';
							}
						}
						content+='<div width="50%" class="graphMainDiv">';

						//content+='<div class="htmlGraphTableHeader"><div style="float:left;">';
						content+='<div class="htmlGraphTableHeader"><div style="float:left;width:75%" class="infoText" data-qtip="'+chartObj.chartTitle+'">';
						content+=chartObj.chartTitle;
						content+='</div>';
						//content+='<div style="float:right;">'; 
						content+='<div style="float:right; margin:3px 0px 4px 5px;">';
						content+='<div style="float:right;cursor:pointer; margin:0 0 0 5px" class="iconMaximize" onclick="javascript:loadUrlInDrillDown(\''+chartObj.drillDownQstring+'\');"></div>';
						content+='</div></div>';
						content+='<div class="headerBottomBorder" ></div>';

						var dom="img_" + key;
						doms.push(dom);

						//content+='<div id="'+dom+'" style="height:330px;width:100%;overflow:hidden;margin-bottom:5px" class="htmlfTableBody">';
						content+='<div id="'+dom+'" style="height:330px;width:100%;overflow:auto;" class="htmlGraphTableBody">';
						content+='</div>';
						content+='</div></td>';
						if (evenLastTd)
						{
							content+='<td style="padding:5px 10px 10px 5px;">&nbsp;</td>';
						}
						col++;
					}
					if (col==2)
					{
						content+='</tr>';
					}
					content+='</table>';
					content+='</div>';

					resultPanelObj.removeAll();
					//resultPanelObj.setTitle(localjson.resultTitle);

						/*resultPanelObj.add({
						//	xtype:'panel',
							ui:'multiGraphPanel',
							margin:10,
							html:content
						});	*/
							resultPanelObj.add({
							xtype:'panel',
							ui:'multiGraphPanel',
							title:localjson.resultTitle,
							margin:'10 10 0 10',
							//margin:10,
							columnWidth:1,
							html:content
						});

				}

				for(var i=0;i<itmArry.length;i++) {
					//var defaultHeight=255;
					var j=itmArry[i];
					var chartObj = chartArray[j];
					var charid = "myChartId" + j;
					var xmlcode = chartObj.XMLData;
					var containerId = doms[i];
					if (xmlcode != '-') {
						//this.getNomeasurepanel().doLayout();
						this.getNomeasurepanel().hide();
						if(appConstants.chartType=='fusionchart')
						{
						if (FusionCharts(charid))
							FusionCharts(charid).dispose();
							var myChart = new FusionCharts(chartObj.swfpath, charid, "98%", "98%", "0", "1");
							myChart.setXMLData(xmlcode);
							myChart.setTransparent(true);
							myChart.render(doms[i]);
						}
						else
						{
							var highChart = {};
							var chartWidth;
							if (noOfCharts == 1)
								chartWidth=chartObj.chartWidth+300;
							else
								chartWidth=chartObj.chartWidth;

							highChart = jQuery.extend(true, {}, getHighChartsBarInstance(containerId,chartObj.chartHeight-20,450), highChart);
							//highChart = jQuery.extend(true, {}, getHighChartsBarInstance(containerId,chartObj.chartHeight,'450'), highChart);
							highChart.setData(chartObj,'<%=currentDateFormat%>','');
							highChart.drawChart();
						}
					} else {
							
						if(Ext.get(doms[i])!=null)
						Ext.get(doms[i]).update('<div style="text-align:center;vertical-align:middle;top:20%;position:relative;"><img src="/final/images/'+strSkin+'/nomeasures_custom.png"></img></div>');
					}
				}
			} else if (selectedreportType == 'data') {
				Ext.getCmp('csvTool').show();
				itemsArray = new Array();
				var doms = new Array();
				var titleAry = new Array();
				var content;
				var noOfCharts;
				
				//var headingObj  = {id:'resultHeading',xtype:'panel',title:publicjsonData.resultTitle,cls: 'getScrollClass'}
				//resultPanelObj.setTitle("<span class='font_bold'>"+jsonData.resultTitle+"</span>");

				if (jsonData.hasOwnProperty('chartData')) {
					var chartData = jsonData.chartData;
					//noOfCharts = chartData.length;
					var hideSelection=false;
					for (var tmpObj in chartData){
						var tmpDataObj = chartData[tmpObj];
						for (var tmpCompName in tmpDataObj) {
							var tmpDataArray = tmpDataObj[tmpCompName];
							if (!Ext.isEmpty(tmpDataArray)) {
								hideSelection=true;
							}
						}
					}
					this.getNomeasurepanel().hide();//by ezhil
					if(!hideSelection){
						Ext.getCmp('resultPanel').hide();
						this.getNomeasurepanel().doLayout();
						this.getNomeasurepanel().show();
						Ext.getCmp('panelinsidetoggle').setDisabled(true);
					}else	{
						Ext.getCmp('panelinsidetoggle').setDisabled(false);
						Ext.getCmp('selectionDetails').setSelectionDetailsData(jsonData.selectionDetails);
					}

					//prakash
					var csvArray = jsonData.jArr;
					for (var tmp2 in csvArray)
					{
						csvUrl2 = csvArray[tmp2];
						itemsArray.push(csvUrl2);
					}
					//
								
					var col=0;
					noOfCharts=0;
					for (var tmp in chartData) {
						var dataObj = chartData[tmp];
						for (var compName in dataObj) {
							
							var dataArray = dataObj[compName];
							if (!Ext.isEmpty(dataArray)) {
								noOfCharts+=1;
							}
						}
					}
					if(noOfCharts==1)
						{
							content='<div style="width:100%"><table width="100%" border="0" class="htmlGraphTable"><col width="100%"><tr>';
						}else
						{
							content='<div style="width:100%"><table width="100%" border="0" class="htmlGraphTable"><col width="50%"><col width="50%"><tr>';
						}
					var count=0;
					//var divWidth = Ext.select('.graphMainDiv').getWidth();
					//console.log('divWidth---',divWidth);
					for (var tmp in chartData) {
						var enableScroll;
						var evenLastTd=false;
						var dataObj = chartData[tmp];
						for (var compName in dataObj) {
							
							var dataArray = dataObj[compName];
							
							if (!Ext.isEmpty(dataArray)) {
								if (col==2)
								{
									col=0;
									content+='</tr>';
									content+='<tr>';
								}

								//enableScroll="overflow-y: auto;";
								var tabledata = '<div class="newTable"  style="overflow-y:auto;overflow-x:hidden;height:290px;width:98%">' + '<table cellspacing="0" cellpadding="0" border="0" style="margin:0px 10px 10px 10px; table-layout:fixed;width:98%">' + '<thead>' + '<tr>' + '<th>' + '<div>Process(s)</div>' + '</th>' + '<th width="80">' + '<div style="text-align:center;">Max</div>' + '</th>' + '<th width="70">' + '<div style="text-align:center;">Avg</div>' + '</th>' + '</tr>' + '</thead>' + '<tbody>' + '<tpl for=".">';

								for (var j in dataArray) {
									var realdata = dataArray[j];
									tabledata += '<tr>' + '<td>' + '<div style="word-wrap:break-word">' + realdata[0] + '</div>' + '</td>' + '<td>' + '<div style="text-align:center;">' + this.getDecimalAlignFormat(realdata[1]) + '</div>' + '</td>' + '<td>' + '<div style="text-align:center;">' + this.getDecimalAlignFormat(realdata[2]) + '</div>' + '</td>' + '</tr>';
								}
								tabledata += '</tpl>' + '</tbody>' + '</table>' + '</div>';

								if(count == 0){
									if (chartData.length>2)
									{ 
										//content+='<td style="padding:10px 5px 5px 10px">';
										content+='<td style="padding:0px 10px 10px 10px">';
									}
									else if(chartData.length==2)
									{ 
										//content+='<td style="padding:10px 5px 10px 10px">';
										content+='<td style="padding:0px 10px 10px 5px">';
									}
									else
									{  
										//content+='<td style="padding:10px 10px 10px 10px">';
										content+='<td style="padding:0px 10px 10px 5px">';
									}
								}
								else if(count == 1){
									if (chartData.length>2)
									{	
										//content+='<td style="padding:10px 10px 5px 5px">';
										content+='<td style="padding:0px 10px 10px 0px">';
									}
									else
									{  
										//content+='<td style="padding:10px 10px 10px 5px">';
										content+='<td style="padding:0px 10px 10px 5px">';
									}
								}
								else if((count%2) == 0){
									if (count==chartData.length-1)
									{
										evenLastTd=true;
										//content+='<td style="padding:5px 5px 10px 10px">';
										content+='<td style="padding:0px 10px 10px 5px">';
									}
									else if (count==chartData.length-2)
									{
										//content+='<td style="padding:5px 5px 10px 10px">';
										content+='<td style="padding:0px 10px 10px 0px">';
									}
									else{
										//content+='<td style="padding:5px 5px 5px 10px">';
										content+='<td style="padding:0px 10px 10px 10px">';
									}
								}
								else if((count%2) != 0){
									if (count==chartData.length-1)
									{	
										//content+='<td style="padding:5px 10px 10px 5px">';
										content+='<td style="padding:0px 10px 10px 5px">';
									}
									else{  
										//content+='<td style="padding:5px 10px 5px 5px">';
										content+='<td style="padding:0px 10px 10px 0px">';
									}
								}

								content+='<div width="100%" class="graphMainDiv">';
								//content+='<div class="htmlGraphTableHeader"><div style="float:left;">';
								content+='<div class="htmlGraphTableHeader"><div style="float:left;width:75%" class="infoText" data-qtip="'+compName+'">';
								content+=compName;
								content+='</div>';
								//content+='<div style="float:right; margin:5px 5px 4px 5px">';
								content+='<div style="float:right; margin:10px 10px 10px 10px">';
								content+='<div style="float:right;cursor:pointer;margin:0 5px 0 5px" class="iconCsv" onclick="window.location=\''+itemsArray[count]+'\'"></div>';
								content+='</div></div>';
								content+='<div  style="width:100%;" class=" ">';
								content+=tabledata;
								content+='</div>';
								content+='</div></td>';
								if (evenLastTd)
								{
									content+='<td style="padding:5px 10px 10px 5px;">&nbsp;</td>';
								}
								col++;
								count++;
							} /*else {
								enableScroll="";
								tabledata = '<div style="margin:20% 0px 0px 48%;"></div><div style="text-align:center;"><img src="/final/images/'+strSkin+'/nomeasures_custom.png"/></div>';
							}*/
							
						}
						if (col==2)
						{
							content+='</tr>';
						}
					}
					content+='</table></div>';
						
					resultPanelObj.removeAll();
					resultPanelObj.add({
						xtype:'panel',
						ui:'multiGraphPanel',
						/*cls:'newTable',*/
						title:jsonData.resultTitle,
						margin:'10 10 0 10',
						
						html:content 
					});
					
				}		
		
			}	
			resultPanelObj.doLayout();
		}		
		appConstants.initLdgMask.hide();
	},
    loadTools: function () {
        this.getNewUtilities().loadIcon(true, true, true, false, true, true,
            true, false, false, false,true);
        Ext.getCmp("favoriteTool").setDisabled(false);
        Ext.getCmp("scheduleTool").setDisabled(false);

    },
    disableTools: function () {
        Ext.getCmp("bookletTool").setDisabled(true);
        Ext.getCmp("saveTool").setDisabled(true);
        Ext.getCmp("printTool").setDisabled(true);
        Ext.getCmp("mailTool").setDisabled(true);
        Ext.getCmp("upbutton").setDisabled(true);
		Ext.getCmp('csvTool').setDisabled(true);
    },
	toggleForm:function(obj)
	{
		Ext.getCmp('panelinsidetoggle').show();
		var ornt = Ext.getCmp('mainform');
		if (ornt.isHidden())
		{
			ornt.show();
			Ext.getCmp('selectionDetails').hide();
		}
		else
		{
			ornt.hide();
			Ext.getCmp('selectionDetails').show();
		}
	},
    printFile: function () {
        var s_qryString = "../servlet/com.eg.ErRepoLiteC?" + appConstants.publicjsonData.saveQstring + "&pdfPrint=yes";

		parent.printWindowFn(s_qryString);	 //this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
    },
    sendMail: function () {
        Ext.widget('sendmail').show();
    },
    sendToschedule: function (obj) {
        //this.loadHiddenFields(publicjsonData['hiddenfields']);
        this.updateQueryString();
        var finalParams;
		var localjson=appConstants.publicjsonData;
        var hiddenfieldQString = "";
        var compArray = new Array();
        var comQuery = "";
        var start_date = localjson.startDate;
        var end_date = localjson.endDate;

        if (localjson.hasOwnProperty('hiddenfields')) {
            var hiddenFields = localjson.hiddenfields;
            for (var hiddenField in hiddenFields) {
                hiddenfieldQString += "&" + hiddenField + "=" + hiddenFields[hiddenField];
            }
        }
        compArray = Ext.getCmp('systems').getValue();
        for (var k = 0; compArray.length > k; k++) {
            comQuery += "&er_component=" + compArray[k];
        }
        finalParams = appConstants.queryString + comQuery + hiddenfieldQString + "&option=data&isSubmit=true";
        var target = "/final/reporter/ErSaveSchedule.jsp?" + finalParams;
		if (obj.getId()=='save')
		{
			//document.location=target+'&showSchWindow=no';
			target+='&showSchWindow=no';
			var urlNw=target.substr(0,target.indexOf("?"));
			var queryString=target.substr(target.indexOf("?")+1,target.length-1);
			var formSave = Ext.create('Ext.form.Panel');
			formSave.submit({
				url:urlNw,
				params:queryString,
				standardSubmit: true,
				method: 'POST'
			});
		}
		else
		{
			parent.scheduleWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
		}
 	},
	sendCsv:function()
	{
		window.location='../servlet/egurkha.reporter.SaveInCSVFormat?reporttype=csvHead';
	},

    expandMe: function (btn) {
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		appConstants.erUtils.expandMultiComboButton(Ext.getCmp('systems'),Ext.getCmp('systemLabel').text,btn);
	},
    saveFavorite: function (obj) {
        this.updateQueryString();
        var finalParams;
		var localjson=appConstants.publicjsonData;
        var hiddenfieldQString = "";
        var compArray = new Array();
        var comQuery = "";
		var favorite_id = "";
        var start_date = localjson.startDate;
        var end_date = localjson.endDate;

        if (localjson.hasOwnProperty('hiddenfields')) {
            var hiddenFields = localjson.hiddenfields;
			favorite_id = hiddenFields["favorite_id"];
            for (var hiddenField in hiddenFields) {
                hiddenfieldQString += "&" + hiddenField + "=" + hiddenFields[hiddenField];
            }
        }
        compArray = Ext.getCmp('systems').getValue();
        for (var k = 0; compArray.length > k; k++) {
            comQuery += "&er_component=" + compArray[k];
        }
        finalParams = appConstants.queryString + comQuery + hiddenfieldQString +"&option=data&isSubmit=true";
        //document.location='/final/reporter/ErSaveFavorite.jsp?'+finalParams+"&cmd=client";
        var target = "../servlet/com.eg.ErFavoriteC?" + finalParams + "&er_view=GRAPH&cmd=client"+"&er_RmDispName="+appConstants.er_RmDispName;//&FavoriteId="+favorite_id;
		if (obj.getId()=='save')
		{
			//document.location=target+'&showWindow=no'+"&FavoriteId="+favorite_id;
			target+='&showWindow=no'+"&FavoriteId="+favorite_id;
			var urlNw=target.substr(0,target.indexOf("?"));
			var queryString=target.substr(target.indexOf("?")+1,target.length-1);
			var formSave = Ext.create('Ext.form.Panel');
			formSave.submit({
				url:urlNw,
				params:queryString,
				standardSubmit: true,
				method: 'POST'
			});
		}
		else
			parent.favouriteWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp

	},
   /* weekendOnChange: function () {
        var weekendvalue = Ext.getCmp('excludeWeek').getValue();;
        var excludeDaysObj = Ext.getCmp('excludeDays');
        if (weekendvalue == 'yes') {
            excludeDaysObj.show();
            excludeDaysObj.update(appConstants.globalScreenLabels['MappedExcludeDays']);
        } else {
            excludeDaysObj.hide();
        }
    },*/
    updateQueryString: function () {

		if (!isSettingsEnabled)
		{
			var localjson=appConstants.publicjsonData;
			reportGeneration=localjson.reportGeneration;
			priority=localjson.selectedPriority;
			excludeWeek=localjson.excludeWeekend;
			CommonMaximum=localjson.er_commonMax;
			autoMaximum=localjson.er_AutoCommonMax;
			maxValue=localjson.er_commonMaxRange;
			showBy=localjson.selectedCriterion;
			timefrom=localjson.selectedTimeFrom;
			minfrom=localjson.selectedMinsFrom;
			timeto=localjson.selectedTimeTo;
			minto=localjson.selectedMinsTo;
 		}
		else
		{
			reportGeneration=Ext.getCmp('reportGeneration').getValue();
			priority=Ext.getCmp('priority').getValue();
			excludeWeek=Ext.getCmp('excludeWeek').getValue();
			CommonMaximum=Ext.getCmp('CommonMaximum').getValue();
			autoMaximum=Ext.getCmp('autoMaximum').getValue();
			maxValue=Ext.getCmp('maxValue').getValue()
			showBy=Ext.getCmp('showBy').getValue();
			timefrom= Ext.getCmp('timefrom').getValue();
			minfrom= Ext.getCmp('minfrom').getValue();
			timeto= Ext.getCmp('timeto').getValue();
			minto= Ext.getCmp('minto').getValue();
		}

        var timperiodParams = "&timefrom=" + timefrom + "&minfrom=" + minfrom + "&timeto=" + timeto + "&minto=" + minto;
        var timelineParams = "&er_timeline=" + Ext.getCmp('er_timeline').getValue() + "&startdate=" + Ext.getCmp('er_stdate').dataArray + "&enddate=" + Ext.getCmp('er_enddate').dataArray + "&starthr=" + Ext.getCmp('er_sthr').dataArray + "&endhr=" + Ext.getCmp('er_endhr').dataArray + "&startmin=" + mgr_stmin + "&endmin=" + mgr_enmin;
        var configParams = "";
        var detailedParams = "";
        var reporttype = Ext.getCmp('reportType').getValue();

         var selectedMetric = Ext.getCmp('metric').getValue();
        var newTest = selectedMetric.substring(0, selectedMetric.indexOf(":"));
        var newMeasure = selectedMetric.substring(selectedMetric.indexOf(":") + 1);
        configParams = "&er_reportType=" + reporttype;

        configParams += "&er_priority=" + priority;

        configParams += "&er_excwe=" + excludeWeek;

        configParams += "&er_sortby=" + showBy;

        configParams += "&er_commonMax=" + CommonMaximum;
        configParams += "&er_AutoCommonMax=" + autoMaximum;

        configParams += "&er_commonMaxRange=" + maxValue;
        configParams += "&er_mode=" + Ext.getCmp('er_mode').getValue();

        var reportFor = Ext.getCmp('reportFor').getValue();
        detailedParams = "er_dataFrom=" + reportFor + "&er_template=" + Ext.getCmp('metric').getValue() + "&er_reportgenration=" + reportGeneration + "&er_test=" + newTest + "&er_measure=" + newMeasure;
        if (reportFor != 'System') {
            if (reportFor == 'Zone') {
                var includeSubzone = Ext.getCmp('subZone').getValue();
                detailedParams += "&er_dataZone=" + includeSubzone;
            }
            detailedParams += "&er_service=" + Ext.getCmp('group').getValue();
        }
        appConstants.queryString = detailedParams + configParams + timperiodParams + timelineParams;
		//alert('appConstants.queryString ----->'+appConstants.queryString);
    },
    metricOnChange: function () {
        Ext.getCmp('resultPanel').hide();
        this.disableTools();
    },
    timeLineOnChange: function () {
        Ext.getCmp('resultPanel').hide();
        this.disableTools();
        var startDateObj = Ext.getCmp('er_stdate');
        var startHrObj = Ext.getCmp('er_sthr');
        var endDateObj = Ext.getCmp('er_enddate');
        var endHrObj = Ext.getCmp('er_endhr');

        if (Ext.getCmp('er_timeline').getValue() == 'Any') {
            startDateObj.setDisabled(false);
            startHrObj.setDisabled(false);
            endDateObj.setDisabled(false);
            endHrObj.setDisabled(false);
        } else {
            this.updateQueryString();
            Ext.Ajax.request({
                url: '/final/reporter/ErOperationSystemDetails.jsp',
                params: appConstants.queryString,
                scope: this,
                success: function (response) {
                    var jsonText = response.responseText;
                    var jsonData = Ext.decode(jsonText);
                    appConstants.publicjsonData = jsonData;
                    var start_hour = jsonData.startHour;
                    var end_hour = jsonData.endHour;
                    var start_date = jsonData.startDate;
                    var end_date = jsonData.endDate;
                    startDateObj.setDisabled(true);
                    startHrObj.setDisabled(true);
                    endDateObj.setDisabled(true);
                    endHrObj.setDisabled(true);
                    startDateObj.setValue(start_date);
                    startHrObj.setValue(start_hour);
                    endDateObj.setValue(end_date);
                    endHrObj.setValue(end_hour);
                }
            });
        }
    },
    autoMaxOnChange: function () {
        Ext.getCmp('resultPanel').hide();
        this.disableTools();
        var automaxx = Ext.getCmp('autoMaximum').getValue();
        Ext.getCmp('maxValue').setValue("");
        if (automaxx == 'no') {
            Ext.getCmp('maxValue').show();
        } else {
            Ext.getCmp('maxValue').hide();
        }
    },
    reportGenChange: function () {
        Ext.getCmp('resultPanel').hide();
        this.disableTools();
        var reportGenType = Ext.getCmp('reportGeneration').getValue();	
			Ext.getCmp('submitViaSetting').hide();
			Ext.getCmp('moreOptionCloseId').show();
        if (reportGenType == 'background') {
            Ext.getCmp('bgReportName').setValue("");
            Ext.getCmp('bgReportName').show();
			Ext.getCmp('submitViaSetting').show();
			Ext.getCmp('moreOptionCloseId').hide();
        }
		else if(reportGenType == 'background-csv')
		{
			Ext.getCmp('bgReportName').setValue("");
			Ext.getCmp('bgReportName').show();
			Ext.getCmp('submitViaSetting').show();
			Ext.getCmp('moreOptionCloseId').hide();
		}
		else {
            Ext.getCmp('bgReportName').hide();
        }
    },
    commonMaxOnChange: function () {
        Ext.getCmp('resultPanel').hide();
        this.disableTools();
        var commonMax = Ext.getCmp('CommonMaximum').getValue();
        var automaxObj = Ext.getCmp('autoMaximum');
        automaxObj.setValue("yes");
        Ext.getCmp('maxValue').value == "";
        if (commonMax == 'yes') {
            automaxObj.show();
        } else {
            automaxObj.hide();
            Ext.getCmp('maxValue').hide();
        }
    },
    reportTypeOnChange: function () {
        Ext.getCmp('resultPanel').hide();
        this.disableTools();
        var reportTypeChoosen = Ext.getCmp('reportType').getValue();
		this.updateQueryString();
		//var queryString = "er_reportType="+reportTypeChoosen;
		Ext.Ajax.request({
			url:'/final/reporter/ErOperationSystemDetails.jsp?er_reportType='+reportTypeChoosen,
			params:appConstants.queryString,
			scope:this,
			success:function(response)
			{
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);
				appConstants.publicjsonData = jsonData;
				if(isSettingsEnabled)
				{
					var reportGenerationCombo = jsonData.reportGenerationCombo;
					var reportGenTemp = Ext.getCmp('reportGeneration');
					reportGenTemp.getStore().loadRawData(reportGenerationCombo);
				}
			}
		});
       /*if (reportTypeChoosen == 'data') {

            Ext.getCmp('showBy').setFieldLabel(appConstants.globalScreenLabels['reporter.Operation.Sort by']);
            Ext.getCmp('CommonMaximum').hide();
            Ext.getCmp('autoMaximum').hide();
            Ext.getCmp('maxValue').hide();
            Ext.getCmp('er_mode').hide();
        } else {
            Ext.getCmp('showBy').setFieldLabel(appConstants.globalScreenLabels['reporter.Operation.Show by']);
            Ext.getCmp('CommonMaximum').show();
            Ext.getCmp('er_mode').setValue("3D");
            Ext.getCmp('er_mode').show();
        }
        Ext.getCmp('CommonMaximum').setValue("no");
        Ext.getCmp('autoMaximum').setValue("yes");
        Ext.getCmp('maxValue').setValue("");*/	

    },
    groupOnChange: function () {
        Ext.getCmp('resultPanel').hide();
        this.disableTools();
        this.updateQueryString();
        Ext.Ajax.request({
            url: '/final/reporter/ErOperationSystemDetails.jsp',
            params: appConstants.queryString,
            scope: this,
            success: function (response) {
                var jsonText = response.responseText;
                var jsonData = Ext.decode(jsonText);
                appConstants.publicjsonData = jsonData;
                this.loadSystemCombo(jsonData);
            }
        });
    },
    RepotForOnChange: function () {
        Ext.getCmp('resultPanel').hide();
        this.disableTools();
        var detailedParams = "er_dataFrom=" + Ext.getCmp('reportFor').getValue() + "&er_timeline=" + Ext.getCmp('er_timeline').getValue();
        Ext.Ajax.request({
            url: '/final/reporter/ErOperationSystemDetails.jsp',
            params: detailedParams,
            scope: this,
            success: function (response) {

                var jsonText = response.responseText;
                var jsonData = Ext.decode(jsonText);
                appConstants.publicjsonData = jsonData;
                this.loadGroupNames(jsonData);
            }
        });
    },
	fillSettingsElements:function()
	{
		var hiddenFields=appConstants.publicjsonData["hiddenfields"];
		var favorite_id = hiddenFields["favorite_id"];
		if(!Ext.isEmpty(favorite_id)){
			Ext.getCmp('reportGeneration').setDisabled(true);
		}
		Ext.getCmp('moreOptionCloseId').show();
		var localjson=appConstants.publicjsonData;
		var screenLabels = localjson.screenLabels;
        var weekendRawData = localjson.weekendCombo;
        var excludeWeekendsRawData = localjson.excludeWeekendsCombo;
        var weekendObj = Ext.getCmp('excludeWeek');
        weekendObj.setFieldLabel(screenLabels['reporter.common.Exclude Weekends']);
        weekendObj.getStore().loadRawData(excludeWeekendsRawData);
		if (!Ext.isEmpty(localjson.excludeWeekend)) {
			weekendObj.setValue(localjson.excludeWeekend);
		} else {
			weekendObj.setValue(weekendCombo[0].valueField);
		}
        var commonMaxObj = Ext.getCmp('CommonMaximum');
        var autoMaxObj = Ext.getCmp('autoMaximum');
        commonMaxObj.getStore().loadRawData(weekendRawData);
        autoMaxObj.getStore().loadRawData(weekendRawData);

        var priorityRawData = localjson.priorityCombo;
        var selectedpriority = localjson.selectedPriority;
        var priorityObj = Ext.getCmp('priority');
        priorityObj.setFieldLabel(screenLabels['reporter.Operation.Show']);
        priorityObj.getStore().loadRawData(priorityRawData);
		if (!Ext.isEmpty(selectedpriority)) {
			priorityObj.setValue(selectedpriority);
		} else {
			priorityObj.setValue(priorityRawData[0].valueField);
		}

        var selectedCriterion = localjson.selectedCriterion;
        var showByObj = Ext.getCmp('showBy');
        showByObj.setFieldLabel(screenLabels['reporter.Operation.Show by']);
        showByObj.setValue(selectedCriterion);

        var reportGenCombo = localjson.reportGenerationCombo;
        var selreportGeneration = localjson.reportGeneration;
        var reportGen = Ext.getCmp('reportGeneration');
        reportGen.setFieldLabel(screenLabels['reporter.consolidated.Report Generation']);
        reportGen.getStore().loadRawData(reportGenCombo);
        reportGen.setValue(selreportGeneration);

        Ext.getCmp('reportType').setFieldLabel(screenLabels['reporter.Operation.Report Type']);
        Ext.getCmp('excludeWeek').setFieldLabel(screenLabels['reporter.common.Exclude weekends']);
        Ext.getCmp('CommonMaximum').setFieldLabel(screenLabels['reporter.Operation.Common Maximum']);
        Ext.getCmp('autoMaximum').setFieldLabel(screenLabels['reporter.Operation.Auto Set Maximum Value']);
        Ext.getCmp('maxValue').setFieldLabel(screenLabels['reporter.Operation.Max Value']);
        Ext.getCmp('bgReportName').setFieldLabel(screenLabels['reporter.consolidated.Report Name']);
        Ext.getCmp('subZone').setFieldLabel(screenLabels['reporter.Operation.Include SubZones']);

		Ext.getCmp('timefrom').setValue(localjson.selectedTimeFrom);
		Ext.getCmp('minfrom').setValue(localjson.selectedMinsFrom);;
		Ext.getCmp('timeto').setValue( localjson.selectedTimeTo);
		Ext.getCmp('minto').setValue(localjson.selectedMinsTo);

        var er_commonMax = localjson.er_commonMax;
        var er_AutoCommonMax = localjson.er_AutoCommonMax
        commonMaxObj.setValue(er_commonMax);
        autoMaxObj.setValue(er_AutoCommonMax);
        if (er_commonMax == 'Yes') {
            autoMaxObj.show();
            if (er_AutoCommonMax == 'No') {
                Ext.getCmp('maxValue').setValue(localjson.er_commonMaxRange);
                Ext.getCmp('maxValue').show();
            }
        }
		
	},
	fillMainElements:function()
	{
		var localjson=appConstants.publicjsonData;
		var screenLabels = localjson.screenLabels;
		appConstants.globalScreenLabels = localjson.screenLabels;

		var hiddenFields = localjson['hiddenfields'];
        var from_schedule = hiddenFields["fromScheduleModify"];
		var from_favourite = hiddenFields["fromFavoriteModify"];
        if ((from_schedule != null && from_schedule == "Yes") || (from_favourite != null && from_favourite == "Yes")){
			Ext.getCmp("submit").hide();
			Ext.getCmp("save").show();
			Ext.getCmp("favoriteTool").setDisabled(true);
			Ext.getCmp("scheduleTool").setDisabled(true);
		}else{
			Ext.getCmp("submit").show();
			Ext.getCmp("save").hide();
		}
		var ReportForRawData = localjson.reportForCombo;
		var selectedreportFor = localjson.selectedreportFor;
		var reportForObj = Ext.getCmp('reportFor');
		reportForObj.setFieldLabel(analysisByTxt);
		reportForObj.getStore().loadRawData(ReportForRawData);
		if (selectedreportFor != 'System') {
			var groupObj = Ext.getCmp('group');
			var elementsRawData = localjson.elementsCombo;
			if (selectedreportFor == 'Zone') {
				var subzoneRawData = localjson.subZoneCombo;
				var subzoneObj = Ext.getCmp('subZone');
				groupObj.setFieldLabel(screenLabels['reporter.common.Zone']);
				
				subzoneObj.getStore().loadRawData(subzoneRawData);
				subzoneObj.setValue(localjson.er_dataZone);
				Ext.getCmp('subZone').show();
			}
			groupObj.setFieldLabel(screenLabels['reporter.common.' + selectedreportFor]);
			groupObj.getStore().loadRawData(elementsRawData);
			groupObj.setValue(localjson.er_service);
			groupObj.show();
		}
		var MetricRawData = localjson.metricsCombo;
		var selectedMetric = localjson.selectedMetric;
		var metricObj = Ext.getCmp('metric');
		metricObj.setFieldLabel(screenLabels['reporter.Operation.Metric']);
		metricObj.getStore().clearFilter(true);
		metricObj.getStore().loadRawData(MetricRawData);

		var systemsRawData = localjson.systemCombo;
		var selectedsystems = localjson.selectedSystems;
		var systemObj = Ext.getCmp('systems');
		Ext.getCmp('systemLabel').setText(screenLabels['reporter.Operation.System']);
		systemObj.getStore().loadRawData(systemsRawData);

		var reportypeRawData = localjson.rtypeCombo;
		var reportTypeObj = Ext.getCmp('reportType');
		reportTypeObj.setFieldLabel(screenLabels['reporter.Operation.Report Type']);
		reportTypeObj.getStore().loadRawData(reportypeRawData);
        if (!Ext.isEmpty(ReportForRawData)) {
            if (!Ext.isEmpty(selectedreportFor)) {
                reportForObj.setValue(selectedreportFor);
            } else {
                reportForObj.setValue(ReportForRawData[0].valueField);
            }
        }
        if (!Ext.isEmpty(MetricRawData)) {
            if (!Ext.isEmpty(selectedMetric)) {
                metricObj.setValue(selectedMetric);
            } else {
                metricObj.setValue(MetricRawData[0].valueField);
            }
        }
        if (!Ext.isEmpty(systemsRawData)) {
            if (!Ext.isEmpty(selectedsystems)) {
                systemObj.setValue(selectedsystems);
            } else {
                systemObj.setValue(systemsRawData[0].valueField);
            }
        }
        if (!Ext.isEmpty(localjson.selectedReportType)) {
            reportTypeObj.setValue(localjson.selectedReportType);
        } else {
            reportTypeObj.setValue(reportypeRawData[0].valueField);
        }

 		var timelineRawData = localjson.timelineCombo;
        var selectedTimeline = localjson.selectedTimeline;
        var timelineObj = Ext.getCmp('er_timeline');
        timelineObj.setFieldLabel(screenLabels['reporter.common.Timeline']);
        timelineObj.getStore().loadRawData(timelineRawData);

        var startDateObj = Ext.getCmp('er_stdate');
        startDateObj.setValue(localjson.startDateForDisplay);
        startDateObj.dataArray = localjson.startDate;
        var startHrObj = Ext.getCmp('er_sthr');
        startHrObj.setValue(localjson.startHourForDisplay);
        startHrObj.dataArray = localjson.startHour;
        var endDateObj = Ext.getCmp('er_enddate');
        endDateObj.setValue(localjson.endDateForDisplay);
        endDateObj.dataArray = localjson.endDate;
        var endHrObj = Ext.getCmp('er_endhr');
        endHrObj.setValue(localjson.endHourForDisplay);
        endHrObj.dataArray = localjson.endHour;
        stmin = localjson.startMinForDisplay;
        enmin = localjson.endMinForDisplay;
        mgr_stmin = localjson.startmin;
        mgr_enmin = localjson.endmin;

		var graphModeObj = Ext.getCmp('er_mode');
        graphModeObj.setFieldLabel(screenLabels['reporter.common.Graph']);
        graphModeObj.setValue(localjson.selectedGraphMode);

		 if (!Ext.isEmpty(timelineRawData)) {
			if (!Ext.isEmpty(selectedTimeline)) {
				timelineObj.setValue(selectedTimeline);
			} else {
				timelineObj.setValue(timelineRawData[0].valueField);
			}
		}
		updateAppSettings();

		if(!appConstants.hideBackButton){
		Ext.getCmp('operationDetails').add(
			{
				xtype: 'hidden',
				id: 'ID',
				name: 'ID',
				value: localjson['ID']
			}
		);
		}
	},
    defaulLoading: function () {
		if(appConstants.publicjsonData['fromFavSch'] == "true")
		{ this.formSubmit();
		}
	     this.disableTools();
		if (!Ext.isEmpty(appConstants.er_RmDispName) && appConstants.er_RmDispName!= 'null')
			this.getMain().setTitle(appConstants.er_RmDispName);
		else
			this.getMain().setTitle(appConstants.publicjsonData.reportTitle);
        //this.loadField(publicjsonData);
		var hiddenFields = appConstants.publicjsonData['hiddenfields'];
        var from_schedule = hiddenFields["fromScheduleModify"];
		
		var from_favourite = hiddenFields["fromFavoriteModify"];
		
		if(from_schedule==null && from_favourite==null)
		this.refreshReportData();
		
    },
	refreshReportData:function(){
		if(appConstants.isSubmit=="true")
		{
			this.loadReportData(appConstants.publicjsonData);
		}
		else
		{
		   if(appConstants.isForceSubmit=='true')
			{
				this.showResult();
				appConstants.isForceSubmit='false';
			}
		}
	},
    saveReportAsPDF: function () {
        var s_qryString = "../reporter/ErHtmlToSavePdf.jsp?" + appConstants.publicjsonData.saveQstring;
        if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
        appConstants.erUtils.savePDF(s_qryString);
    },
	bookletQuery: function(obj)
	{
		var qryString=appConstants.publicjsonData.saveQstring;
		return qryString;
	},
	bookletScheduleQuery: function(obj)
	{
		var bookletquery="";
		this.updateQueryString();
		bookletquery+= "&option=data&";
		bookletquery+= appConstants.queryString;
		var localjson=appConstants.publicjsonData;
        var compArray = new Array();
        if (localjson.hasOwnProperty('hiddenfields')) {
            var hiddenFields = localjson.hiddenfields;
            for (var hiddenField in hiddenFields) {
                bookletquery+= "&" + hiddenField + "=" + hiddenFields[hiddenField];
            }
        }
        compArray = Ext.getCmp('systems').getValue();
        for (var k = 0; compArray.length > k; k++) {
            bookletquery+= "&er_component=" + compArray[k];
        }
		return bookletquery;
	},
	bookletPreview:function()
	{
		this.printFile();
	},
    loadGroupNames: function (jsonData) {
        var reportFor = Ext.getCmp('reportFor').getValue();
        var groupObj = Ext.getCmp('group');
        var systemObj = Ext.getCmp('systems');

        var screenLabels = jsonData.screenLabels;
        var systemsRawData = jsonData.systemCombo;
        var selectedsystems = jsonData.selectedSystems;
        if (reportFor == 'Zone') {
            var elementsRawData = jsonData.elementsCombo;
            var subzoneRawData = jsonData.subZoneCombo;

            var subzoneObj = Ext.getCmp('subZone');
            groupObj.setFieldLabel(screenLabels['reporter.common.Zone']);
			groupObj.getStore().clearFilter(true);
            groupObj.getStore().loadRawData(elementsRawData);
            groupObj.setValue(elementsRawData[0].valueField);
            subzoneObj.getStore().loadRawData(subzoneRawData);
            subzoneObj.setValue(subzoneRawData[0].valueField);
            systemObj.getStore().loadRawData(systemsRawData);
            systemObj.setValue(selectedsystems);
            Ext.getCmp('subZone').show();
            groupObj.show();

        } else if (reportFor == 'Segment') {
            var elementsRawData = jsonData.elementsCombo;
            groupObj.setFieldLabel(screenLabels['reporter.common.Segment']);
			groupObj.getStore().clearFilter(true);
            groupObj.getStore().loadRawData(elementsRawData);
            groupObj.setValue(elementsRawData[0].valueField);
            systemObj.getStore().loadRawData(systemsRawData);
            systemObj.setValue(selectedsystems);
            Ext.getCmp('subZone').hide();
            groupObj.show();
        } else if (reportFor == 'Service') {
            var elementsRawData = jsonData.elementsCombo;
            groupObj.setFieldLabel(screenLabels['reporter.common.Service']);
			groupObj.getStore().clearFilter(true);
            groupObj.getStore().loadRawData(elementsRawData);
            groupObj.setValue(elementsRawData[0].valueField);
            systemObj.getStore().loadRawData(systemsRawData);
            systemObj.setValue(selectedsystems);
            Ext.getCmp('subZone').hide();
            groupObj.show();
        } else {
            Ext.getCmp('subZone').hide();
            groupObj.hide();
            systemObj.getStore().loadRawData(systemsRawData);
            systemObj.setValue(selectedsystems);
        }
    },
    loadSystemCombo: function (jsonData) {
        var systemObj = Ext.getCmp('systems');
        var systemsRawData = jsonData.systemCombo;
        var selectedsystems = jsonData.selectedSystems;
        systemObj.getStore().loadRawData(systemsRawData);
        systemObj.setValue(selectedsystems);
    },
    validateSettings: function () {
        var isSettingsOk = true;
		var hiddens=appConstants.publicjsonData['hiddenfields'];
        var MaxDaysInMonth = hiddens['getMaxDaysInMonth'];
        var er_usertimeline =hiddens['userTimeline'];

        var reportgen,reportName;
		if (isSettingsEnabled)
		{
			reportgen= Ext.getCmp('reportGeneration').getValue();
 			var timePeriodFromHrs = Ext.getCmp('timefrom').getValue();
			var timePeriodFromMins = Ext.getCmp('minfrom').getValue();
			var timePeriodToHrs = Ext.getCmp('timeto').getValue();
			var timePeriodToMins = Ext.getCmp('minto').getValue();
			var autoMaximumvalue = Ext.getCmp('autoMaximum');
			reportName = Ext.getCmp('bgReportName').getValue();
			if (!checkTimePeriod(timePeriodFromHrs, timePeriodFromMins, timePeriodToHrs, timePeriodToMins)) {
				isSettingsOk = false;
			}
			if (autoMaximumvalue.getValue() == 'no' && !autoMaximumvalue.isHidden()) {
				var maxObj = Ext.getCmp('maxValue');
				var maxvalue = maxObj.getValue();
				if (maxvalue == "" || !(maxvalue >= 0 || maxvalue <= 0)) {
					Ext.MessageBox.show({
						title: 'Operation Reports Settings',
						msg: 'Wrong Input Value',
						buttons: Ext.MessageBox.OK,
						icon: Ext.MessageBox.WARNING,
						fn:function(val){
								if (val=='ok')
								{
									 Ext.get('configMod').animate({
 										to: {
											y: 51
										}});
									maxObj.focus();
								}
							}
					});
					isSettingsOk = false;
				}
			}
		}
		else
		{
			reportgen= appConstants.publicjsonData.reportGeneration;
			reportName=appConstants.publicjsonData.bgReportName;
		}


		var er_timeline = Ext.getCmp('er_timeline').getValue();
        var stDate = Ext.getCmp('er_stdate').getValue();
        var enDate = Ext.getCmp('er_enddate').getValue();
        var startHour = Ext.getCmp('er_sthr').getValue();
        var endHour = Ext.getCmp('er_endhr').getValue();
        stDate.setHours(startHour);
        enDate.setHours(endHour);

        if (!checkDateTime(stDate, enDate)) {
            isSettingsOk = false;
        }
        if (er_usertimeline != null && er_usertimeline != '-1') {
            var usertimelineValid = isUserTimelineLimitExceeded(er_usertimeline, MaxDaysInMonth, stDate, enDate);
            if (!usertimelineValid) {
                Ext.MessageBox.show({
                    title: 'Operation Reports Settings',
                    msg: _invalidUserTime,
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.WARNING
                });
                isSettingsOk = false;
            }
        }
        if (reportgen == 'foreground') {
            var limitforbg = hiddens['limitforbg'];
            if (!Ext.isEmpty(limitforbg)) {
                if (!checkTimeLineForBgLimit(limitforbg, MaxDaysInMonth, stDate, enDate)) {
                    Ext.MessageBox.confirm('Confirm', appConstants.forGrdReportConfirmMsg, this.showConfirmResult, this);
                    isSettingsOk = false;
                }
            }
        } else {
             if (!validateTextBoxWithSpecialChars(reportName,'Attachment',true))
                isSettingsOk = false;
        }
		if (isSettingsOk && isSettingsEnabled) {
            var getButtonObj = Ext.getCmp('submit');
            getButtonObj.setDisabled(false);
            Ext.get('configMod').animate({
                duration: 500,
                to: {
                    y: -500
                }
            });
        }
        return isSettingsOk;

    },
    showConfirmResult: function (btn) {
        if (btn == "yes") {
            var getButtonObj = Ext.getCmp('submit');
            getButtonObj.setDisabled(false);
			if (isSettingsEnabled)
			{
				Ext.get('configMod').animate({
					duration: 500,
					to: {
						y: -500
					}
				});
			}
			 this.formSubmit();
        } else {
			if (!isSettingsEnabled)
			{
				this.getReporterSettings().down('button').fireHandler();
			}
            var bgreportNameObj = Ext.getCmp('bgReportName');
            Ext.getCmp('reportGeneration').setValue('background');
            bgreportNameObj.setValue("");
            bgreportNameObj.show();
            bgreportNameObj.focus(false, 1000);
			this.showResult();
         }
    },
	getDecimalAlignFormat:function(value)
	{
		//if(!isNaN(value) && !isNaN(parseFloat(value))||value == '-')
		if(!isNaN(value) && !isNaN(parseFloat(value)))
		{
			if(value!=null && value.indexOf(".")>-1)
			{
				strDecimal = value.substring(value.indexOf("."));
				str = value.substring(0,value.indexOf("."));
				value='<span class="decimal-align">'+str+'</span><span class="decimal-align2">'+strDecimal+'</span>';
			}
			else
			{
				value='<span class="decimal-align">'+value+'</span>';
			}
		}
		return value;
	}
});