Ext.define('OperationEventAnalysis.controller.Main',{
	extend:'Ext.app.Controller',
	views:['Main','OpertionEventDrillDown'],
	
	refs:[
		{selector:'main', ref:'main'},
		{selector:'utilitiestool', ref:'utilitiestool'},
		{selector:'operationdrilldown',ref:'operationdrilldown'},
		{selector:'timeline',ref:'timeline'},
		{selector:'operationnetworksettings',ref:'operationnetworksettings'},
		{selector:'operationeventsubmitteddata',ref:'operationeventsubmitteddata'},
		{selector:'operationeventmainform', ref:'operationeventmainform'},
		{selector:'operationeventsettings', ref:'operationeventsettings'},
		{selector: 'eventdetails', ref:'eventdetails'}
	],
	requires: ['OperationEventAnalysis.view.EventDetails'],
	myJson: null,
	init:function()
	{
		this.control(
		{
			'main':
			{
				//'boxready':this.defaultLoads
			},
			'operationeventmainform':
			{
				'boxready':this.defaultLoads
			},
			'operationeventsettings':
			{
				'boxready':this.loadSettingsFields
			},
			'main utilitiestool':
			{
				'afterrender': this.hideTools
			},
			'utilitiestool > #upbutton':
			{
				'click':this.toggleForm
			},
			'utilitiestool #saveTool > button ':
			{
				'click':this.saveMe
			},
			'utilitiestool #printTool > button ':
			{
				'click': this.printMe
			},
			'utilitiestool #mailTool > button ':
			{
				'click': this.sendMail
			},
			'utilitiestool #favoriteTool > button ':
			{
				'click': this.favorites
			},
			'utilitiestool #scheduleTool > button ':
			{
				'click': this.schedules
			},
			'timeline combo[name="er_mode"]':
			 {
                'select': this.changeEr_mode
             },
			'operationdrilldown':
			{
				render:this.resizePanel
			},
			'operationdrilldown combo[name ="er_mode"]':
			{
				select:this.graphModeC
			},
			'operationeventsettings timeline combo[name ="graphMode"]':
			{
				select:this.graphModeA
			},
			'operationeventsubmitteddata':
			{
				/*afterrender:function(){
					var me = this;
					Ext.getBody().on('click',function(e,target){
						me.showDrillDown();
					},this,{delegate:'div.iconLineChart'});
				}*/
			},
			'operationeventmainform combo[name="eventfor"]':
			{
				'select': this.analysisChange
			},
			'operationeventmainform button[name="submit"]':
			{
				'click': this.formSubmit
			},
			'operationeventmainform button[name="save"]':
			{
				'click': this.goTo
			},
			'operationeventmainform combo[name="zone"]':
			{
				'select': this.selectZone
			},
			'operationeventsettings combo[name="timeLineCombo"]':
			{
				//'select': this.changeTimeline
			},
			'operationeventsettings combo[name="reportGeneration"]':
			{
				'select': this.selectReportGeneration
			}
		});
	},	
		goTo: function () {
		// by karthikeyan
if (Ext.getCmp('er_timeline').getValue() == 'Any')
		{
				Ext.MessageBox.show({
                        title : 'Operation Reports',
                        msg : 'Chosen timeline not allowed',
                        buttons : Ext.Msg.OK,
                        icon: Ext.MessageBox.WARNING
                    });
				return;
		}
//
		var hiddenFields = publicJSON['hiddens'];
		var from_schedule = hiddenFields["fromScheduleModify"];
		if ((from_schedule != null && from_schedule == "Yes")) {
			 this.sendToschedule();
		}else{
			//document.location = '/final/servlet/com.eg.ErFavoriteC?' + queryString + '&call=json&cmd=client&FavoriteId='+favorite_id+ "&shareUsers=" + er_favorite + "&publicUsers=" + er_favorite+"&fromFavoriteModify=yes";
			this.favorites();
		}
    },
	loadMask: function()
	{
		initLdgMask.show();
	},
	loadPage:function()
	{
		Ext.EventManager.onWindowResize(function(){
			Ext.get('configMod').setStyle('left', '');
		});
		var thisController = this;
		Ext.get('closeSettings').on('click',function(){
			 //Ext.get('configMod').slideOut();
			var result = thisController.validateSettings('timeline');
			if ( !result )
			{
				return false;
			}
			Ext.get('configMod').animate({duration: 500,to: {y: -500}});
		});
	},
	selectReportGeneration: function(combo)
	{
		if ( combo.getValue() == 'foreground' )
		{
			Ext.getCmp('bgReportName').hide();
		}
		else
		{
			Ext.getCmp('bgReportName').show();
		}
	},
	schedules: function()
	{
		this.updateQueryString();
		//var favURL = Ext.getCmp('favURL').getValue();
		var tmpQueryString = queryString; 
		var target = '/final/reporter/ErSaveSchedule.jsp?'+tmpQueryString;
 		
	    parent.scheduleWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp

	},
	  changeEr_mode: function (combo) {
		Ext.get('configMod').animate({
                    duration: 250,
                    to: {
                        y: -530
                    }
                });
				// var c=combo.getValue();
		this.formSubmit(Ext.getCmp('submit'));
     },
	favorites: function()
	{
		this.updateQueryString();
		var favorite_id = "";
		//var favURL = Ext.getCmp('favURL').getValue();
		
		var hiddenFields = publicJSON['hiddens'];
		favorite_id = hiddenFields["favorite_id"];
		var tmpQueryString = queryString; 
		var target = '/final/servlet/com.eg.ErFavoriteC?'+tmpQueryString+'&cmd=client&FavoriteId='+favorite_id+"&er_RmDispName="+appConstants.er_RmDispName;
 	    parent.favouriteWindowFn(target);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp 

        


	},
	sendMail: function()
	{
		Ext.widget('sendmail').show();
	},
	printMe: function()
	{
		var printURL = this.myJson['PRINT_URL'];
			parent.printWindowFn(printURL); //this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp

	},
	saveMe:function()
	{
		this.updateQueryString(); 
		var PDF_URL_QUERY_STRING = this.myJson['PDF_URL_QUERY_STRING'];
		var getSaveObj = Ext.widget('erutils');
		getSaveObj.savePDF(PDF_URL_QUERY_STRING);
	},
	changeTimeline: function(combo)
	{
		var settingsForm = this.getOperationeventsettings().getForm();
		var mainForm = this.getOperationeventmainform().getForm();
		if ( Ext.getCmp('er_timeline').getValue() == 'Any' )
		{
			settingsForm.findField('er_stdate').setDisabled(false);
			settingsForm.findField('er_enddate').setDisabled(false);
			settingsForm.findField('er_sthr').setDisabled(false);
			settingsForm.findField('er_endhr').setDisabled(false);
		}
		else
		{
			settingsForm.findField('er_stdate').setDisabled(true);
			settingsForm.findField('er_enddate').setDisabled(true);
			settingsForm.findField('er_sthr').setDisabled(true);
			settingsForm.findField('er_endhr').setDisabled(true);
			if ( !Ext.isEmpty( combo ) )
			{
				this.formSubmit(combo);
			}
		}
	},
	selectZone: function(combo)
	{
		var getZoneVal = Ext.getCmp('zone').getValue();
		if ( getZoneVal == '-1' || getZoneVal == '--Default--' )
		{
			this.getOperationeventmainform().getForm().findField('subzone').setDisabled(true);
		}
		else
		{
			this.getOperationeventmainform().getForm().findField('subzone').setDisabled(false);
		}
	},
	analysisChange: function(combo)
	{
		Ext.getCmp('saveTool').setDisabled(true);
		Ext.getCmp('printTool').setDisabled(true);
		Ext.getCmp('mailTool').setDisabled(true);
		Ext.getCmp("upbutton").setDisabled(true);
		
		var eventForVal = Ext.getCmp('eventfor').getValue();
		var mainForm = this.getOperationeventmainform().getForm();
		var zoneObj = mainForm.findField('zone');
		var subzoneObj = mainForm.findField('subzone');		
		var serviceObj = mainForm.findField('service');
		var segmentObj = mainForm.findField('segment');
		if ( eventForVal == 'Zone' )
		{
			zoneObj.show();
			subzoneObj.show();
			subzoneObj.setDisabled(true);
			serviceObj.hide();
			segmentObj.hide();			
		}
		else if ( eventForVal == 'Segment' )
		{
			zoneObj.hide();
			subzoneObj.hide();
			serviceObj.hide();
			segmentObj.show();			
		}
		else if ( eventForVal == 'Service' )
		{
			zoneObj.hide();
			subzoneObj.hide();
			serviceObj.show();
			segmentObj.hide();			
		}
		else
		{
			zoneObj.hide();
			subzoneObj.hide();
			serviceObj.hide();
			segmentObj.hide();			
		}
		if ( eventForVal != 'Component' && !Ext.isEmpty( combo ) )
		{
			this.formSubmit(combo);
		}
	},
	beforeForSubmit: function()
	{
		alert('I am before Submit');
	},
	updateQueryString: function()
	{
			var settingsForm = this.getOperationeventsettings().getForm();
			var mainForm = this.getOperationeventmainform().getForm();
			var FormParams;
			var hiddenfieldQString = '';
			var timelineParams;
			var eventForVal = mainForm.findField('eventfor').getValue();
			var subeventVal = '';
			if ( eventForVal == 'Zone' )
			{
				subeventVal = mainForm.findField('zone').getValue();
			}
			else if ( eventForVal == 'Segment' )
			{
				subeventVal = mainForm.findField('segment').getValue();
			}
			else if ( eventForVal == 'Service' )
			{
				subeventVal = mainForm.findField('service').getValue();
			}
			var showValueVal = settingsForm.findField('showdetailsCombo').getValue();
			var insubzoneVal = 'null';
			if ( eventForVal == 'Zone' && !mainForm.findField('subzone').isDisabled() )
			{
				insubzoneVal = mainForm.findField('subzone').getValue();
			}
			var groupBy = '';
			if ( mainForm.findField('comp').getValue() )
			{
				groupBy = 'compName';
			}
			if ( mainForm.findField('compType').getValue() )
			{
				groupBy += '#compType';
			}
			if ( mainForm.findField('test').getValue() )
			{
				groupBy += '#testName';
			}
			if ( mainForm.findField('severity').getValue() )
			{
				groupBy += '#severity';
			}
			if ( groupBy.indexOf('#') == 0 )
			{
				groupBy = groupBy.substring(1);
			}
			var graphMode = Ext.getCmp('er_mode').getValue();
			FormParams='&v_event='+encodeURI(eventForVal)+'&subevent='+encodeURI(subeventVal)+'&insubzone='+encodeURI(insubzoneVal)+'&showvalue='+encodeURI(showValueVal)+"&vw="+encodeURI(groupBy)+"&er_mode="+graphMode;

	        var timelineParams = "&er_timeline=" + Ext.getCmp('er_timeline').getValue() + "&er_time=" + Ext.getCmp("er_timeline").getValue()+"&startdate=" + Ext.getCmp('er_stdate').dataArray + "&enddate=" + Ext.getCmp('er_enddate').dataArray + "&starthr=" + Ext.getCmp('er_sthr').dataArray + "&endhr=" + Ext.getCmp('er_endhr').dataArray;
		
			if (publicJSON.hasOwnProperty('hiddens')) {
				var hiddenFields = publicJSON.hiddens;
				for (var hiddenField in hiddenFields) {
					hiddenfieldQString += "&" + hiddenField + "=" + hiddenFields[hiddenField];
				}
			}
			queryString = FormParams + timelineParams + hiddenfieldQString;
			//queryString = 'eventfor='+encodeURIComponent(analysisVal)+'&reporttype='+encodeURI(reporttypeVal)+'&er_gtype='+encodeURI(er_gtypeVal)+'&er_trgttype='+encodeURI(er_trgttypeVal)+'&er_rtype=Event&servletName='+encodeURI(servletNameVal)+'&inidate='+encodeURI(inidateVal)+'&endmin='+encodeURI(endminVal)+'&insubzone='+encodeURI(insubzoneVal)+'&showvalue='+encodeURI(showValueVal)+'&userID='+encodeURI(userIDVal)+'&startmin='+encodeURI(startminVal)+'&endhr='+encodeURI(endhrVal)+'&starthr='+encodeURI(starthrVal)+'&enddate='+encodeURI(enddateVal)+'&startdate='+encodeURI(startdateVal)+'&er_tbound=null&uid='+encodeURI(uidVal)+'&urole='+encodeURI(uroleVal)+'&er_mode='+er_modeVal+'&er_timeline='+encodeURI(er_timelineVal)+'&v_event='+encodeURI(eventForVal)+'&subevent='+encodeURI(subeventVal)+'&forwardto='+encodeURIComponent('ErCtxEventReportJSON')+'&savereport='+encodeURI(savereportVal)+'&bgenabled='+bgenabledVal+'&er_bgreportfrom=Operation_Event_Analysis&bg_reportname='+bg_reportnameVal+'&limitforbg='+limitforbgVal;
	},
	validateSaveSettings :function(){
		var isSettingsOk = true;
  		var er_usertimeline =publicJSON['hiddens']['er_usertimeline'];
		var MaxDaysInMonth = publicJSON['hiddens']['getMaxDaysInMonth'];
		var er_timeline=Ext.getCmp('er_timeline').getValue();
		var stDate = Ext.getCmp('er_stdate').getValue();
		var enDate = Ext.getCmp('er_enddate').getValue();
		var startHour = Ext.getCmp('er_sthr').getValue();
		var endHour = Ext.getCmp('er_endhr').getValue();
 		stDate.setHours(startHour);
 		enDate.setHours(endHour);
		
		if(!checkDateTime(stDate,enDate)){
			isSettingsOk = false;
		}
		if(er_usertimeline!=null && er_usertimeline != '-1'){
			var usertimelineValid = isUserTimelineLimitExceeded(er_usertimeline, MaxDaysInMonth,  stDate, enDate);
			if ( !usertimelineValid ){
				Ext.MessageBox.show({
				title: 'Operation Reports Settings',
				msg:  _invalidUserTime,
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
				isSettingsOk = false;
			}
		}		
		return isSettingsOk;
	},
	validateSettings: function( val )
	{
		if ( val == 'submit' )
		{
			var eventforVal = Ext.getCmp('eventfor').getValue();
			if ( eventforVal != 'Component' )
			{
				if ( eventforVal == 'Zone' && Ext.getCmp('zone').getValue() == '-1' )
				{
					Ext.MessageBox.show({
								title: 'Alert',
								msg: chooseZone,
								buttons: Ext.MessageBox.OK,
								icon: Ext.MessageBox.WARNING
							});
					return false;
				}
				else if ( eventforVal == 'Segment' && Ext.getCmp('segment').getValue() == '-1' )
				{
					Ext.MessageBox.show({
								title: 'Alert',
								msg: chooseSegment,
								buttons: Ext.MessageBox.OK,
								icon: Ext.MessageBox.WARNING
							});
				
					return false;
				}
				else if ( eventforVal == 'Service' && Ext.getCmp('service').getValue() == '-1' )
				{
					Ext.MessageBox.show({
								title: 'Alert',
								msg: chooseService,
								buttons: Ext.MessageBox.OK,
								icon: Ext.MessageBox.WARNING
							});				
					return false;
				}
			}
			return true;
		}
		else if ( val == 'timeline' )
		{
			var er_usertimeline =publicJSON['hiddens']['er_usertimeline'];
			var getMaxDaysInMonth = publicJSON['hiddens']['getMaxDaysInMonth'];

			var tmpStartDate = Ext.getCmp('er_stdate').getValue();
			tmpStartDate.setHours(Ext.getCmp('er_sthr').getValue());
			var tmpEndDate = Ext.getCmp('er_enddate').getValue();
			tmpEndDate.setHours(Ext.getCmp('er_endhr').getValue());
			if ( er_usertimeline != '-1' )
			{
				var usertimelineValid = isUserTimelineLimitExceeded(er_usertimeline, getMaxDaysInMonth,  tmpStartDate, tmpEndDate);
				if ( !usertimelineValid )
				{
					Ext.MessageBox.show({
						title: 'Alert',
						msg: userTimelineErrorMsg,
						buttons: Ext.MessageBox.OK,
						icon: Ext.MessageBox.WARNING
					});
					return false;
				}
			}
			if ( tmpStartDate.getTime() > tmpEndDate.getTime() )
			{
				Ext.MessageBox.show({
						title: 'Alert',
						msg: dateValidateError,
						buttons: Ext.MessageBox.OK,
						icon: Ext.MessageBox.WARNING
					});
					return false;
			}
			var limitforbg = publicJSON['hiddens']['limitforbg'];
			var reportgenVal = Ext.getCmp('reportGeneration').getValue();
			var isSettingsOk = true;
			if ( reportgenVal == 'foreground' )
			{
				if ( !Ext.isEmpty(limitforbg ) )
				{
					if(!checkTimeLineForBgLimit(limitforbg,getMaxDaysInMonth,tmpStartDate,tmpEndDate))
					{
						Ext.MessageBox.confirm('Confirm', forGrdReportConfirmMsg,this.showResult,this);
						isSettingsOk = false;
					}
				}
				return isSettingsOk;
			}
			if ( reportgenVal == 'background' )
			{
				var reportName = Ext.getCmp('bgReportName').getValue();
				var ret = validateTextBoxWithSpecialChars(reportName,'Attachment',true);
				if ( !ret )
				{
					Ext.getCmp('bgReportName').focus();
					return false;
				}
				else
				{
					return true;
				}
			}
			return true;
		}
		
	},
	showResult : function(btn)
	{
		if( btn == 'yes' )
		{
			var getButtonObj = Ext.getCmp('submit');
			getButtonObj.setDisabled(false);
			Ext.get('configMod').animate({duration: 500,to: {y: -500}});			
		}			
		else
		{
			Ext.getCmp('reportGeneration').setValue('background');
			Ext.getCmp('bgReportName').show();
			Ext.getCmp('bgReportName').focus(false, 1000);
			return false;
		}
	},
	formSubmit: function( obj )
	{
		var me = this;
		this.updateQueryString();
		//this.getOperationeventsubmitteddata().hide();

		var actionFrom = obj.getId();
		var settingsForm = this.getOperationeventsettings().getForm();
		var mainForm = this.getOperationeventmainform().getForm();
		var URL = '';
		var me = this;
		var isSubmit = false;
		var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Loading...'});
			if ( !Ext.isEmpty( actionFrom ) )
			{
				if ( actionFrom == 'submit' )
				{
					isSubmit = true;

					if ( Ext.isEmpty( groupBy ) )
					{
						Ext.MessageBox.show({
							title: 'Alert',
							msg: requiredParams,
							buttons: Ext.MessageBox.OK,
							icon: Ext.MessageBox.WARNING
						});
						return false;
					}
					queryString += '&vw='+encodeURI(groupBy);
					if ( settingsForm.findField('reportGeneration').getValue() == 'foreground' )
					{
						queryString += '&call=json&&isSubmit=true';
						URL = '/final/servlet/com.eg.ErCtxServerReportC';
					}
					else
					{
						queryString += '&isSubmit=true';
						//alert('queryString-->'+queryString);
						URL = '/final/servlet/com.eg.ErStartBackGroundReportC';
					}
				}
				else
				{
					URL = '/final/reporter/ErCtxEventReportJSON.jsp';
					Ext.getCmp('saveTool').setDisabled(true);
					Ext.getCmp('printTool').setDisabled(true);
					Ext.getCmp('mailTool').setDisabled(true);
					Ext.getCmp("upbutton").setDisabled(true);

				}
				
				
				if ( isSubmit )
				{
					var result = this.validateSettings('submit');
					if ( !result )
					{
						return false;
					}
					myMask.show();
				}
				 queryString +="&er_RmDispName="+appConstants.er_RmDispName;

				if ( !Ext.isEmpty( URL ) )
				{
					//alert('queryString--->form submitting...'+queryString);
					Ext.Ajax.request({
						url: URL,
						params: queryString,
						method: 'POST',
						scope: me,
						success: function( response )
						{
							if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
							{
								var jsonText = response.responseText;
									var jsonData = Ext.decode( jsonText );
									me.myJson = jsonData;
									if ( actionFrom == 'eventfor' )
									{
										var eventForVal = mainForm.findField('eventfor').getValue();
										if ( eventForVal == 'Zone' )
										{
											var zoneObj = mainForm.findField('zone');
											var zoneData = jsonData['Zone'];
											if ( !Ext.isEmpty( zoneData ) )
											{
												zoneObj.suspendEvents(true);
												zoneObj.getStore().loadRawData(zoneData);
												zoneObj.resumeEvents();
												zoneObj.fireEvent('afterrender',zoneObj);												
											}
											var subzoneObj = mainForm.findField('subzone');
											var subzoneData = jsonData['includeSubZonesCombo'];
											if ( !Ext.isEmpty( subzoneData ) )
											{
												subzoneObj.suspendEvents(true);
												subzoneObj.getStore().loadRawData(subzoneData);
												var includeSubzoneSelectedData = jsonData['includeSubzoneSelected'];
												if ( !Ext.isEmpty( includeSubzoneSelectedData ) )
												{
													subzoneObj.setValue( includeSubzoneSelectedData );
												}
												subzoneObj.resumeEvents();
											}
										}
										else if ( eventForVal == 'Segment' )
										{
											var segmentObj = mainForm.findField('segment');
											var segmentData = jsonData['Segment'];
											if ( !Ext.isEmpty( segmentData ) )
											{
												segmentObj.suspendEvents(true);
												segmentObj.getStore().loadRawData(segmentData);
												segmentObj.resumeEvents();
												segmentObj.fireEvent('afterrender',segmentObj);												
											}
										}
										else if ( eventForVal == 'Service' )
										{
											var serviceObj = mainForm.findField('service');
											var serviceData = jsonData['Service'];
											if ( !Ext.isEmpty( serviceData ) )
											{
												serviceObj.suspendEvents(true);
												serviceObj.getStore().loadRawData(serviceData);
												serviceObj.resumeEvents();
												serviceObj.fireEvent('afterrender',serviceObj);												
											}
										}
									}
									else if ( actionFrom == 'timeLineCombo' )
									{
										var startdateObj = settingsForm.findField('er_stdate');
										var startHourObj = settingsForm.findField('er_sthr');
										var enddateObj = settingsForm.findField('er_stdate');
										var endHourObj = settingsForm.findField('er_endhr');
										var startDateVal = jsonData['startdate'];
										var endDateVal = jsonData['enddate'];
										var startHourVal = jsonData['selectedStartHour'];
										var endHourVal = jsonData['selectedEndHour'];
										
										startdateObj.suspendEvents(true);
										startdateObj.setValue(startDateVal);
										startdateObj.resumeEvents();
										
										enddateObj.suspendEvents(true);
										enddateObj.setValue(endDateVal);
										enddateObj.resumeEvents();
										
										startHourObj.suspendEvents(true);
										startHourObj.setValue(startHourVal);
										startHourObj.resumeEvents();
										
										endHourObj.suspendEvents(true);
										endHourObj.setValue(endHourVal);
										endHourObj.resumeEvents();										
									}
									else if ( actionFrom == 'submit' && settingsForm.findField('reportGeneration').getValue() == 'foreground' )
									{
										myMask.hide();
										me.loadResults( jsonData );
										Ext.getCmp('saveTool').setDisabled(false);
										Ext.getCmp('printTool').setDisabled(false);
										Ext.getCmp('mailTool').setDisabled(false);
										Ext.getCmp("upbutton").setDisabled(false);
									}
									else if ( actionFrom == 'submit' && settingsForm.findField('reportGeneration').getValue() == 'background' )
									{
										myMask.hide();
										//this.getOperationeventsubmitteddata().hide();
										var status = jsonData['status'];
										var backgroundResponseTextVal = jsonData['backgroundResponseText'];
										var backgroundResponseURLVal = jsonData['backgroundResponseURL'];
										var backgroundResponseResultVal = jsonData['backgroundResponseResult'];
										var genHtml = '';
										if ( Ext.isEmpty( Ext.getCmp('background') ) )
										{
											this.getMain().add(
											{
												xtype: 'panel',
												id: 'background',
												html: genHtml
											});
											this.getMain().doLayout();
										}
										if ( status == 'duplicate' )
										{
											genHtml = '<center><div class="block1" style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:480px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconExists"></div><div style="margin:20px"><b>'+backgroundResponseResultVal+'</b><br /><a class="backgroundMsgLink" href="'+backgroundResponseURLVal+'" >'+backgroundResponseTextVal+'</a></div></div></center>';
										}
										else
										{
											genHtml = '<center><div class="block1" style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:480px;height:90" class="panelwithoutheader"><div style="margin:20px;display:block;width:38px;height:34px;float:left;" class="iconSuccess"></div><div style="margin:20px"><b>'+backgroundResponseResultVal+'</b><br /><a class="backgroundMsgLink" href="'+backgroundResponseURLVal+'" >'+backgroundResponseTextVal+'</a></div></div></center>';
										}
										Ext.getCmp('background').update(genHtml);

										Ext.getCmp('saveTool').setDisabled(true);
										Ext.getCmp('printTool').setDisabled(true);
										Ext.getCmp('mailTool').setDisabled(true);
										Ext.getCmp("upbutton").setDisabled(true);
									}
									
									if ( actionFrom == 'submit' )
									{
										var selectionDetailsObj = Ext.getCmp('selectionDetails');
										var selectionDetailsData = jsonData['selectionDetails'];
										var selectionDetailsTitle = jsonData['selectionDetailsTitle'];
										selectionDetailsObj.setTitle(selectionDetailsTitle);
										var fieldContainerArray = new Array();
										for ( var key in selectionDetailsData)
										{
											var htmlStr = selectionDetailsData[key];
											var fieldAdd = {xtype:'container', margin:'0 20 5 0',layout:'column',frame: false,border:false,items:[{xtype:'container',margin:'0 5 5 0',frame: false,border:false,html:'<b>'+key+'</b>'},{xtype:'container',margin:'0 5 5 0',frame: false,border:false,html:'-'},{xtype:'container',margin:'0 5 5 0',frame: false,border:false,html:htmlStr}]};
											//var fieldAdd = {xtype:'fieldcontainer',fieldLabel:key, items:[{xtype:'container',html:htmlStr}]};
											fieldContainerArray.push(fieldAdd);
										}
										selectionDetailsObj.removeAll();
										selectionDetailsObj.add(fieldContainerArray);
									}
								
							}
							else
							{
								console.log('Exception @ formSubmit Error: No Response...');
							}
						}
					});
				}
			}
	},
	loadResults: function ( jsonData )
	{
		var me = this;
		if(Ext.isEmpty(Ext.getCmp('operationeventsubmitteddata'))){
			me.getMain().add({
			xtype:'operationeventsubmitteddata'
			
			});
			me.getMain().doLayout();
		}
		var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Loading...'});
		var settingsForm = this.getOperationeventsettings().getForm();
		var mainForm = this.getOperationeventmainform().getForm();
		this.getOperationeventsubmitteddata().show();
		var fusionChartObj = Ext.getCmp('fusionChart');
		var summaryOfEventsObj = Ext.getCmp('summaryOfEvents');
		var detailOfEventsObj = Ext.getCmp('detailOfEvents');
		
		if ( settingsForm.findField('showdetailsCombo').getValue() == 'Yes' )
		{
			detailOfEventsObj.show();
			
		}
		else
		{
			detailOfEventsObj.hide();
		}	
		var xmlData = jsonData['eventsChartXMLData'];
		var graphMode = settingsForm.findField('er_mode').getValue();
		var eventsChartTitleData = jsonData.screenLabels['eventsChartTitle'];
		fusionChartObj.setTitle(eventsChartTitleData);
		if ( !Ext.isEmpty( xmlData ) )
		{
			if (FusionCharts("chart" )) 
						FusionCharts("chart").dispose();
			var myChart = new FusionCharts('/final/FusionCharts/swf/MSBar'+graphMode+'.swf','chart', "100%", "100%","0","1");
			myChart.setXMLData(xmlData);
			myChart.setTransparent(true);
			myChart.render('MyChart');
		}
		else
		{
			fusionChartObj.setHeight(325);
			Ext.get('MyChart').update('<img src="/final/reporter/images/nographformeasure.png" width="500" />')
		}
		
		var eventsTableTitleData = jsonData.screenLabels['eventsTableTitle']; 
		summaryOfEventsObj.setTitle(eventsTableTitleData);
		var tableHeadings = jsonData['tableHeadings'];
		var tableValues = jsonData['tableValues'];
		//alert('tableValues--->'+tableValues);
		var tableHtml = '<div class="x-table">'
						+'<table cellspacing="0" cellpadding="0" border="0" class="x-grid-table x-grid-table-resizer">'
						+'<thead>'
						+'<tr class="x-grid-row">';
		var alertIdx = 0; 
		var idx = 0;
		for ( var key in tableHeadings )
		{
			if ( key.indexOf('ALERTS') > -1 )
			{
				alertIdx = idx;
			}
			if ( key.indexOf('GRAPH') > -1 )
			{
				tableHtml += '<th class=" x-grid-cell x-grid-cell-first" width="75px">'
							 +'<div class="x-grid-cell-inner">'+tableHeadings[key]+'</div>'
							 +'</th>';										 

			}
			else if ( key.indexOf('ALERTS') > -1 )
			{
				tableHtml += '<th class=" x-grid-cell x-grid-cell-first" width="90px">'
							 +'<div class="x-grid-cell-inner">'+tableHeadings[key]+'</div>'
							 +'</th>';	
			}
			else if ( key.indexOf('METRICS') > -1 )
			{
				tableHtml += '<th class=" x-grid-cell x-grid-cell-first" width="275px">'
							 +'<div class="x-grid-cell-inner">'+tableHeadings[key]+'</div>'
							 +'</th>';	
			}
			else if ( key.indexOf('SEVERITY') > -1 )
			{
				tableHtml += '<th class=" x-grid-cell x-grid-cell-first" width="75px">'
							 +'<div class="x-grid-cell-inner">'+tableHeadings[key]+'</div>'
							 +'</th>';
			}
			else
			{
				tableHtml += '<th class=" x-grid-cell x-grid-cell-first">'
							 +'<div class="x-grid-cell-inner">'+tableHeadings[key]+'</div>'
							 +'</th>';
			}
			idx++;														 
		}
		tableHtml += '</tr>'
					 +'</thead>'
					 +'<tbody>';
		
		var tableHeadingsCount = jsonData['tableHeadingsCount'];
		var chartId = 0;										
		for ( var key in tableValues )
		{
			var data = tableValues[key];
			tableHtml += '<tr class="x-grid-row">';
			for ( var tmpKey in data )
			{
				var titleText = data[tmpKey];
				if ( tmpKey.indexOf('GRAPH') > -1 )
				{
					titleText = 'GRAPH';
				}
				tableHtml += '<td class=" x-grid-cell x-grid-cell-first" title="'+titleText+'">'
				
				if ( tmpKey.indexOf('GRAPH') > -1 )
				{
					var graphURL = data[tmpKey];
					tableHtml += '<div class="x-grid-cell-inner" style="position:relative;height:20px" ><div class="iconLineChart" onclick="javascript:loadUrlInDrillDown(\''+graphURL+'\');" style="position:absolute;top:2px;cursor:pointer" ></div></div>'
				}
				else
				{
					tableHtml += '<div class="x-grid-cell-inner" >'+data[tmpKey]+'</div>'
				}
				chartId++;
				tableHtml += '</td>';
			}
			tableHtml += '</tr>';
		}
		
		tableHtml += '<tr class="x-grid-row">';
		for ( var i = 0; i < tableHeadingsCount; i++ )
		{
			if ( i == 0 )
			{
				var totalLabel = jsonData.screenLabels['total'];
				tableHtml += '<td class=" x-grid-cell x-grid-cell-first"><div class="x-grid-cell-inner"><b>'+totalLabel+'</b></div></td>';
			}
			else if ( i == alertIdx )
			{
				var totalValues = jsonData['totalValues'];
				tableHtml += '<td class=" x-grid-cell x-grid-cell-first"><div class="x-grid-cell-inner"><b>'+totalValues+'</b></div></td>';
			}
			else
			{
				tableHtml += '<td class=" x-grid-cell x-grid-cell-first"><div class="x-grid-cell-inner"></div></td>';
			}
		}
		tableHtml += '</tr>'
					 +'</tbody>'
					 +'</table>'
					 +'</div>';
		summaryOfEventsObj.update(tableHtml);
		//
		
		//me.loadTableData(tableHeadings, tableValues);
		if ( settingsForm.findField('showdetailsCombo').getValue() == 'Yes' )
		{
			Ext.Ajax.request({
				url: '/final/reporter/ErViewShowAlertJSON.jsp',
				method: 'POST',
				async: false,
				success: function(response)
				{
					myMask.hide();
					if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
					{
						var tmpJsonText = response.responseText;
						var tmpJsonData = Ext.decode(tmpJsonText);
						var gridData = tmpJsonData['gridValues'];
						var gridTitles = tmpJsonData['gridTitles'];
						var gridPanelTitle = tmpJsonData['gridTitle'];
						var limitPerPage = tmpJsonData['limitPerPage'];
						var detailOfEventsObj = Ext.getCmp('detailOfEvents');
						detailOfEventsObj.setTitle(gridPanelTitle);
						if ( !Ext.isEmpty( gridData ) )
						{
							detailOfEventsObj.add({
								xtype: 'eventdetails',
								dataArray: gridData,
								pageLimit: parseInt(limitPerPage)
							});
							detailOfEventsObj.doLayout();
							var colHeaderCount = 0;
							for ( var key in gridTitles )
							{
								Ext.getCmp('eventdetailsGrid').columns[colHeaderCount].setText(gridTitles[key]);
								colHeaderCount++;
							}
						}
						else
						{
							detailOfEventsObj.add({
								xtype: 'emptypanel'
							});
						}
					}
					else
					{
						console.log('No Response from ErViewShowAlert.jsp');
					}
				}
			});
		}
	},
	graphModeA:function()
	{ // This is in Main form Timeline 
		var s1Elementa = Ext.getCmp('configsettings').getForm();
		var graphModea = s1Elementa.findField('graphMode');
	},
	graphModeC:function()
	{ // This is in DRILL DOWN Timeline 
		var s1Element = this.getOperationdrilldown().getForm();
		var graphMode = s1Element.findField('graphMode');
	},
	showDrillDown:function()
	{ 
		Ext.widget('operationdrilldown',
												{
													title:'Server Report for orac190:1521:egurkha:Oracle Database',
													id:'operationdrilldownID',
													
													tools:[
														{xtype:'usertimelinetools'}
													],
													items:[
														{
															xtype:'form',
															//width:580,
															//style:{'margin':'0px auto'},
															buttonAlign:'center',
															items:[
																	{
																		xtype:'timeline'
																	}
																],
																buttons:[
																		{
																			text:'Submit',
																			ui:'newButtonSmall',
																		}
																]
														}
															]
												}
												
											).show();
	},
	resizePanel:function(panel){ //resize panel
		Ext.EventManager.onWindowResize(function(){
			panel.doComponentLayout();
		});
	},
	loadTableData:function( tableHeader, values )
	{
		var fieldArr = new Array();
		var i = 0;
		for ( var key in tableHeader )
		{
			fieldArr[i] = tableHeader[key];
			i++;
		}
		var objTable = Ext.getCmp('summaryOfEvents');
		objTable.add({
						xtype:'dataview',
						store: new Ext.data.Store({
							fields: fieldArr,
							data:[
								{NAME:'eg1',ALERTS:'1d'},
								{NAME:'eg1',ALERTS:'1d'},
								{NAME:'eg1',ALERTS:'1d'}
							]
						}),
						tpl:new Ext.XTemplate(
					'<div class="x-table">', 
					'<table cellspacing="0" cellpadding="0" border="0" class="x-grid-table x-grid-table-resizer">', 
						'<thead>', 
							'<tr class="x-grid-row">',
								'<tpl for=".">',
									'<th class=" x-grid-cell x-grid-cell-first">', 
										'<div class="x-grid-cell-inner">{fieldArr}</div>', 
									'</th>',
								'</tpl>',
							'</tr>',
						'</thead>', 
					'<tbody>', 
					'<tpl for=".">', 
						'<tr class="x-grid-row">', 
							'<td class=" x-grid-cell x-grid-cell-first">', 
								'<div class="x-grid-cell-inner" >val1{NAME}</div>', 
							'</td>', 
							'<td class=" x-grid-cell">', 
								'<div class="x-grid-cell-inner" >val2{ALERTS}</div>', 
							'</td>',
						'</tr>', 
					'</tpl>',
					'</tbody>', 
					'</table>', 
					'</div>'
						)
		
					});
		var detailsObj = Ext.getCmp('detailOfEvents');		
	},
	toggleForm:function()
	{
		Ext.getCmp('panelinsidetoggle').show();
		var ornt = Ext.getCmp('eventanalysisform');
		ornt.toggleCollapse(true);
	},
	getTools: function()
	{
		Ext.getCmp('saveTool').setDisabled(true);
		Ext.getCmp('printTool').setDisabled(true);
		Ext.getCmp('mailTool').setDisabled(true);
		Ext.getCmp("upbutton").setDisabled(true);
	},
	loadSettingsFields:function(){
			var selectedData = publicJSON['selectedValues'];
		var settingsForm = this.getOperationeventsettings().getForm();

				var timelineObj = settingsForm.findField('er_timeline');
				var timelineData = publicJSON['timeline'];
				if ( !Ext.isEmpty( timelineData ) )
				{
					var selectedTimeline = selectedData['selectedTimeline'];
					this.setValueWithOptionInList( settingsForm, 'er_timeline', timelineData, selectedTimeline);

				}

				if ( timelineData == 'Any' )
				{
					settingsForm.findField('er_stdate').setDisabled(false);
					settingsForm.findField('er_enddate').setDisabled(false);
					settingsForm.findField('er_sthr').setDisabled(false);
					settingsForm.findField('er_endhr').setDisabled(false);
				}
				else
				{
					settingsForm.findField('er_stdate').setDisabled(true);
					settingsForm.findField('er_enddate').setDisabled(true);
					settingsForm.findField('er_sthr').setDisabled(true);
					settingsForm.findField('er_endhr').setDisabled(true);
				}

				var startDateObj = Ext.getCmp('er_stdate');
				startDateObj.dataArray = publicJSON['startdate'];
				var startHrObj = Ext.getCmp('er_sthr');
				startHrObj.dataArray =  publicJSON['selectedStartHour'];
				var endDateObj = Ext.getCmp('er_enddate');
				endDateObj.dataArray = publicJSON['enddate'];
				var endHrObj = Ext.getCmp('er_endhr');
				endHrObj.dataArray = publicJSON['selectedEndHour'];

				this.setValueWithOptionInList( settingsForm, 'er_stdate', null,publicJSON['startDateForDisplay']);
				this.setValueWithOptionInList( settingsForm, 'er_enddate', null,publicJSON['endDateForDisplay']);
				this.setValueWithOptionInList( settingsForm, 'er_sthr', null,publicJSON['startHourForDisplay']);
				this.setValueWithOptionInList( settingsForm, 'er_endhr', null,publicJSON['endHourForDisplay']);
				this.setValueWithOptionInList( settingsForm, 'er_mode', null,publicJSON['graphMode']);
				this.setValueWithOptionInList( settingsForm, 'showdetailsCombo',publicJSON['showDetailsCombo'], publicJSON['showDetailsChecked']);



				var reportgenObj = settingsForm.findField('reportGeneration');
				var reportgenData = publicJSON['reportGeneration'];
				if ( !Ext.isEmpty( reportgenData ) )
				{
					reportgenObj.suspendEvents(true);
					reportgenObj.getStore().loadRawData(reportgenData);
					reportgenObj.setValue( publicJSON['reportGenSelected'] );
					reportgenObj.resumeEvents();

				}	
				updateAppSettings();
	},
	loadMainFields:function(){
		var me = this;
		var mainForm = this.getOperationeventmainform().getForm();
			var jsonData = publicJSON;
			var selectedData = jsonData['selectedValues'];
			if ( !Ext.isEmpty( jsonData ) )
			{
				me.myJson = jsonData; // To catch all JSON Values at first
				me.loadScreenLabels();
				//me.loadHiddens();

				var hiddenFields = publicJSON['hiddens'];
				var from_schedule = hiddenFields["fromScheduleModify"];
				var fromFavoriteModify = hiddenFields["fromFavoriteModify"];
				if ((from_schedule != null && from_schedule == "Yes") || (fromFavoriteModify != null && fromFavoriteModify == "Yes")) {
					Ext.getCmp("submit").hide();
					Ext.getCmp("save").show();
				}else{
					Ext.getCmp("submit").show();
					Ext.getCmp("save").hide();
				}
				
				//To load eventFor combo
				var eventForObj = mainForm.findField('eventfor');
				var eventForStore = mainForm.findField('eventfor').getStore();
				var eventForData = jsonData['eventForCombo'];
				if ( !Ext.isEmpty( eventForData ) )
				{
					var analysis = selectedData['eventForSelected'];
					this.setValueWithOptionInList(mainForm, 'eventfor', eventForData, analysis);
					if ( !Ext.isEmpty( analysis ) )
					{
						eventForObj.setValue(analysis);
						this.analysisChange();
						if ( analysis != 'Component' )
						{
							var analysissCombo = jsonData[analysis];
							var selectedSubEvent = selectedData['sub_eventSelected'];
							this.setValueWithOptionInList( mainForm, analysis.toLowerCase(), analysissCombo, selectedSubEvent);
							
							if ( analysis == 'Zone' )
							{
								var subzoneCombo = jsonData['includeSubZonesCombo'];
								var subzoneSelected = selectedData['includeSubzoneSelected'];
								this.setValueWithOptionInList(mainForm, 'subzone', subzoneCombo, subzoneSelected);
								this.selectZone();
							}
						}
					}
				}
				
				var selectedGroupby = selectedData['selectedGroupby'];
				if ( !Ext.isEmpty( selectedGroupby ) ) 
				{
					if(selectedGroupby == 'ALL')
					{
						Ext.getCmp('comp').setValue(true);
						Ext.getCmp('compType').setValue(true);
						Ext.getCmp('test').setValue(true);
						Ext.getCmp('severity').setValue(true);
					}
					else
					{
						if ( selectedGroupby.indexOf('compName') > -1 )
						{
							Ext.getCmp('comp').setValue(true);
						}
						if ( selectedGroupby.indexOf('compType') > -1 )
						{
							Ext.getCmp('compType').setValue(true);
						}
						if ( selectedGroupby.indexOf('testName') > -1 )
						{
							Ext.getCmp('test').setValue(true);
						}
						if ( selectedGroupby.indexOf('severity') > -1 )
						{
							Ext.getCmp('severity').setValue(true);
						}
					}
				}
				

				if ( !Ext.isEmpty( isSubmit ) && isSubmit == 'true' )
				{
					this.loadResults( jsonData );
					Ext.getCmp('saveTool').setDisabled(false);
					Ext.getCmp('printTool').setDisabled(false);
					Ext.getCmp('mailTool').setDisabled(false);
				}
			}
			else
			{
				console.log('defaultLoads--->jsonData is Empty...');
			}
		if(!hideBackButton){
			Ext.getCmp('eventanalysisform').add(
				{
					xtype: 'hidden',
					id: 'ID',
					name: 'ID',
					value: jsonData['ID']
				}
			);
		}
	},
	defaultLoads:function()
	{
		this.loadPage();
		//this.getTools();
		if (er_RmDispName!= null && er_RmDispName!= 'null' && er_RmDispName!= 'undefined')
			this.getMain().setTitle(er_RmDispName);
		else
		this.getMain().setTitle(reportTitle);
		this.loadMainFields();
	},
	setValueWithOptionInList : function(form, fieldName, list, value)
	{
		if ( !Ext.isEmpty( list) )
		{
			form.findField(fieldName).getStore().loadRawData(list);
		}
		form.findField(fieldName).suspendEvents(false);
		if( !Ext.isEmpty(value) )
		{
			form.findField(fieldName).setValue(value);
			
		}
		else
		{
			form.findField(fieldName).setValue(list[0].valueField);
		}
		form.findField(fieldName).resumeEvents();
	},
	loadHiddens: function()
	{
		try
		{
			var mainForm = this.getOperationeventmainform();
			var hiddens = publicJSON['hiddens'];
			for ( var key in hiddens )
			{
				if ( Ext.getCmp(key) == undefined )
				{
					mainForm.add(
						{
							xtype: 'hidden',
							id: key,
							name: key,
							value: hiddens[key]
						}
					);
				}
				else
				{
					Ext.getCmp(key).setValue(hiddens[key]);
				}
			}	
		}
		catch ( e )
		{
			alert('Exception @ loadHiddens '+e);
		}
	},
	loadScreenLabels: function()
	{
		var mainForm = this.getOperationeventmainform().getForm();
		var settingsForm = this.getOperationeventsettings().getForm();
		var screenLabels = this.myJson['screenLabels'];
		
		var groupByObj = mainForm.findField('groupBy');
		var zoneObj = mainForm.findField('zone');
		var segmentObj = mainForm.findField('segment');
		var serviceObj = mainForm.findField('service');
		
		
		Ext.getCmp('comp').boxLabelEl.update(screenLabels['reporter.operation.COMPONENT']);
		Ext.getCmp('compType').boxLabelEl.update(screenLabels['reporter.operation.COMPONENTTYPE']);
		Ext.getCmp('test').boxLabelEl.update(screenLabels['reporter.operation.TEST']);
		Ext.getCmp('severity').boxLabelEl.update(screenLabels['reporter.operation.SEVERITY']);
		
		var timlineObj = settingsForm.findField('er_timeline');
		var startdateObj = settingsForm.findField('er_stdate');
		var enddateObj = settingsForm.findField('er_enddate');
		var startHourObj = settingsForm.findField('er_sthr');
		var endHourObj = settingsForm.findField('er_endhr');
		//var graphModeTxtObj = Ext.getCmp('er_mode');
		var showDetailsObj = settingsForm.findField('showdetailsCombo');
		var reportgenObj = settingsForm.findField('reportGeneration');
		var reportNameObj = settingsForm.findField('bgReportName');
		
		zoneObj.setFieldLabel(zoneScreenLabel);
		segmentObj.setFieldLabel(segmentScreenLabel);
		serviceObj.setFieldLabel(serviceScreenLabel);
		groupByObj.setFieldLabel(screenLabels['reporter.operation.GroupBy']);
		
		
		//To set field label for timeline settings STARTS
		
		
		showDetailsObj.setFieldLabel(screenLabels['reporter.common.Show Details']);
		reportgenObj.setFieldLabel(screenLabels['reporter.consolidated.Report Generation']);
		reportNameObj.setFieldLabel(screenLabels['reporter.consolidated.ReportName']);
		
		//To set field label for timeline settings ENDS
		
		var submitObj = this.getMain().down('button[name ="submit"]'); //Ext.getCmp('submit');
	//	submitObj.setText(screenLabels['reporter.common.SUBMIT']);
		
	},
	hideTools:function(){
		this.getUtilitiestool().loadIcon(
			true, //save
			true, //print
			true, //mail
			false, //data
			false, //cvs
			true, // fav
			true,// schedule
			false, //daignosis
			true, //togglebutton
			false //close
			);
	Ext.getCmp("scheduleTool").setDisabled(false);
	Ext.getCmp("favoriteTool").setDisabled(false);
	},
	sendMail:function(){
		var windowMail = Ext.widget('sendmail');
		windowMail.show();
	}
});