Ext.define('OperationEventAnalysis.view.EventDetails',{
		extend:'utilities.CustomGrid',
		alias:'widget.eventdetails',
		id: 'eventdetailsGrid',
		//cls:'gridSkin',
		ui:'newGridPanel',
		dataArray: null,
		pageLimit: null,
		border:true,
		initComponent: function()
		{
			this.store = new Ext.data.Store({
				fields:['status','startTime','duration','component','componentType','services','test', 'description'],
			pageSize: this.pageLimit,
			data: this.dataArray,
			remoteSort: true,
			proxy: 
			{
		        type: 'pagingmemory',
		        reader: 
		        {
		            type: 'json'		            
		        }
		    }
			});
			this.viewConfig = 
			{
				deferEmptyText: false,	
				emptyText: 'No records'
			};
			this.dockedItems = new Ext.PagingToolbar({
					dock: 'bottom',
					cls:'newPagination',
					pageSize: this.pageLimit,
	                store: this.store,
	                displayInfo: true,
	                displayMsg: 'Displaying topics {0} - {1} of {2}',
	                emptyMsg: "No Events to display"
	            });
			//alert(this.getStore().data);
			this.callParent();
		},
		columns: [
				{
					dataIndex:'status',
					text:'status',
					width:50,
					renderer: function(val)
					{
						var getStatus = '<div style="position:relative;height:13px;"><span class="state_'+val+'" style="margin:0px;padding:0px;width:20px;height:20px;position:absolute;display:block;top:-4px;left:10px;"></span></div>';
						return getStatus;
					}
				},
				{
					dataIndex:'startTime',
					text:'startTime',
					flex:0.7
				},
				{
					dataIndex:'duration',
					text:'duration',
					flex: 0.4
				},
				{
					dataIndex:'component',
					text:'component',
					flex:1
				},
				{
					dataIndex:'componentType',
					text:'componentType',
					flex:1
				},
				{
					dataIndex:'services',
					text:'services',
					flex:1
				},
				{
					dataIndex:'test',
					text:'test',
					flex:1
				},
				{
					dataIndex:'description',
					text:'description',
					flex:1,
					renderer:function(value, meta, record)
					{
						meta.tdAttr= 'data-qtip="'+value+'"';
						return value;
					}
				}				
			]			
		});