Ext.define('OperationEventAnalysis.view.TimeLine',{
	alias:'widget.timeline',
	extend:'Ext.form.FieldContainer',
	requires:['utilities.DatePicker'],
	layout:'column',
	defaults:{
		labelAlign: 'top',
		margin:'0 0 0 10',
		labelSeparator:''
	},
	items:[
			{
				fieldLabel:'Timeline',
				xtype:'scrollcombo',
				editable: false,
				id: 'timeLineCombo',
				name: 'timeLineCombo',
				displayField: 'displayField',
				valueField: 'valueField',
				queryMode: 'local',
				store: Ext.data.Store(
					{
						fields: ['displayField', 'valueField'],
						data: []
					}
				),				
				width:85,
				cls: 'dropdown',
				listeners: 
				{
					expand:function(field)
					{
						var getid = field.getPicker().id;
						fleXenv.fleXcrollMain(getid+'-listEl');
					}
				}
			},
			{
				xtype: 'datepicker',
				id: 'startdate',
				name: 'startdate',
				fieldLabel:'From',
				format: mgrDateFormat,
				disabled: true
			},
			{
				xtype:'scrollcombo',
				width:50,
				 defaultListConfig: {
                                    loadingHeight: 50,
                                    minWidth: 50,
                                    maxHeight: 300,
                                    shadow: 'sides'
                                },
				id: 'startHour',
				name:'startHour',
				store: new Ext.data.Store(
					{
						fields: ['displayField', 'valueField'],
						data:[]
					}
				),
				displayField: 'displayField',
				valueField: 'valueField',
				queryMode: 'local',
				fieldLabel:'Hr',
				cls: 'dropdown',
				disabled: true,
				listeners: 
				{
					expand:function()
					{
						fleXenv.initByClass("x-boundlist-list-ct"); // fancy scroll bar
					}
				}
			},
			{
				xtype: 'datepicker',
				id: 'enddate',
				name: 'enddate',
				fieldLabel:'To',
				format: mgrDateFormat,
				disabled: true
			},
			{
				xtype:'scrollcombo',
				width:50,
				
				 defaultListConfig: {
                                    loadingHeight: 50,
                                    minWidth: 50,
                                    maxHeight: 300,
                                    shadow: 'sides'
                                },
				fieldLabel:'Hr',
				cls: 'dropdown',
				id: 'endHour',
				name:'endHour',
				store: new Ext.data.Store(
					{
						fields: ['displayField', 'valueField'],
						data:[]
					}
				),
				displayField: 'displayField',
				valueField: 'valueField',
				queryMode: 'local',
				disabled: true
			},
			{
				
				xtype:'container',

				items:[
				{
					xtype:'label',
					name: 'graphModeTxt',
					id: 'graphModeTxt',
					text:'Graph Mode'
				},
				{
					xtype:'scrollcombo',
					margin:'5 0 0 0',
					width:50,
				 	defaultListConfig: 
				 	{
                        loadingHeight: 50,
                        minWidth: 50,
                        maxHeight: 300,
                        shadow: 'sides'
                    },
					//fieldLabel:'Graph Mode',
					cls: 'dropdown',
					id: 'graphMode',
					name:'graphMode',
					value: '3D',
					store: new Ext.data.Store(
							{
								fields: ['displayField', 'valueField'],
								data:[
										{
											displayField :'3D',
											valueField   :'3D'
										},
										{
											displayField :'2D',
											valueField   :'2D'
										}
									]
							}),
					displayField: 'displayField',
					valueField: 'valueField',
					queryMode: 'local'
				}				
				]			
			}
		]
});