	Ext.define('OperationNetwork.controller.Main', {
	extend: 'Ext.app.Controller',
	views: ['Main', 'DetailTimeLine'],
	refs: [{
		selector: 'main',
		ref: 'main'
	}, {
		selector: 'newUtilities',
		ref: 'newUtilities'
	}, {
		selector: 'operationnetworksettings',
		ref: 'operationnetworksettings'
	}, {
		selector: 'mainform',
		ref: 'mainform'
	},{
		selector: 'ReporterSettings',
		ref: 'ReporterSettings'
	},
		{selector:'nomeasurepanel', ref:'nomeasurepanel'},
		{selector: 'backGroundPanel',ref: 'backGroundPanel'}],
	myJson: null,
	init: function () {
		this.control({
			'main': {
				'boxready': this.loadPage
			 },
			'operationnetworkmainform': {
				'afterrender': this.loadMainElements
			},
			'operationnetworksettings': {
				'afterrender': this.loadSettingsElements
			},
			'main newUtilities': {
				'afterrender': this.hideTools
			},
			'newUtilities > #printTool > button': {
				'click': this.print
			},
			'mainform button[id="submit"]': {
				'click': this.beforeFormSubmit
			},
		   'mainform button[id="save"]': {
				'click': this.goTo
			},
			'operationnetworkmainform combo[name="Report"]': {
				'select': this.selectReportTypeCombos
			},
			'operationnetworkmainform combo[name="compType"]': {
				'select': this.selectComponents
			},
			'operationnetworkmainform combo[name="zone"]': {
				'select': this.selectZoneComponents
			},
			'operationnetworkmainform combo[name="service"]': {
				'select': this.selectServiceComponents
			},
			'operationnetworkmainform combo[name="segment"]': {
				'select': this.selectSegmentComponents
			},
			'operationnetworkmainform combo[id="subzone"]': {
				'select': this.includeOrExcludeSubzone
			},
			'egcomponent button[id="expandComp"]': {
				'click': this.expandMe
			},
			'egdescriptor button[id="expandInfo"]': {
				'click': this.expandInfo
			},
			'egcomponent trigger[id="compSearch"]': {
				'change': this.filterMultiselect
			},
			'egdescriptor trigger[id="infoSearch"]':
			{
			'change': this.filterMultiselect
			},
			'reporttypes combo[name="TimelineReportType"]': {
				'select': this.checkTimeline
			},
			'reporttypes combo[id="showdata"]': {
				//'select': this.formSubmit
				'select': this.onSelectShowData
			},
			'reporttypes checkboxgroup[id="er_checkbox"]': {
				'change': this.legendOnChange
			},
			'reporttypes combo[id="duration"]': {
				'select': this.changeTimeline
			},
			'timeline combo[name="er_mode"]': {
				'select': this.changeEr_mode
			},
			'reportgeneration combo[id="reportGeneration"]': {
				'select': this.showBackgroundReport
			},
			'reportgeneration button[id="moreOptionCloseId"]': {
				'click': this.validateAndCloseSettings
			},
			'reportgeneration button[id="submitViaSetting"]': {
				'click': this.closeSettingAndSubmit
			},
			'mainform button[id="panelinsidetoggle"]': {
				'click': this.toggleForm
			},
			'newUtilities > #mailTool > button': {
				'click': this.sendMail
			},
			'main button[id="excelBtn"]':{
				'click':this.saveExcel
			},
			'newUtilities > #printTool > button': {
				'click': this.print
			},
			'newUtilities > #saveTool > button': {
				'click': this.save
			},
			'newUtilities > #scheduleTool > button': {
				'click': this.schedule
			},
			'newUtilities > #dataTool > button': {
				'click': this.callData
			},
			'newUtilities > #favoriteTool > button': {
				'click': this.favorites
			},
			'usertimeline': {
				//'afterrender': this.showDetailTimeline
			},
			'detailtimeline combo[id="drillTimeLineCombo"]': {
				'select': this.drillDownSubmit
			},
			'detailtimeline button[id="drillDownSubmit"]': {
				'click': this.drillDownSubmit
			},
			'usertimelinetools button[id="print"]': {
				'click': this.drillDownPrint
			},
			'usertimelinetools button[id="save"]': {
				'click': this.drillDownSave
			},
			'usertimelinetools button[id="mail"]': {
				'click': this.drillDownMail
			},
			'usertimelinetools button[id="data"]': {
				'click': this.drillDownData
			},
			'usertimelinetools button[id="diagnosis"]': {
				'click': this.openDiagnosis
			},
			'selectiondetails': {
				render: this.resizePanel
			}
		});
	},

	onSelectShowData:function(obj){
		var er_timelineVal=Ext.getCmp('er_timeline').getValue();
		var er_trenddata='No';
		///////////
		var showdata,TimelineReprtType,duration,gtype;
		if(!isSettingsEnabled)
		{
			 var localjson=appConstants.publicJSON;
			 TimelineReportType=localjson.selectedreporttypecombo;
			 showdata=localjson.selectedShowData;
		}
		else
		{
			 TimelineReportType=Ext.getCmp('TimelineReportType').getValue();
			 showdata=Ext.getCmp('showdata').getValue();
		}
		if(showdata=='Trend' || TimelineReportType=='Trend' || TimelineReportType=='Summary' )
		{
			er_trenddata="Yes";
		}
		var param1 = "F=gettimeline&U=123444&C=jsrs1&P0=[" + er_trenddata + "]";
		Ext.Ajax.request({
			url : '/final/servlet/com.eg.ErRemoteScriptingServlet',
			params : param1,  
			async : false,
			success : function(response) { 
				var jsonData = Ext.decode(response.responseText);
				var comboVal=jsonData.combo;
				var timelineCombo = Ext.getCmp('er_timeline');
				timelineCombo.getStore().loadRawData(jsonData.combo);
				var flag=false;
				for(var i = 0; i < comboVal.length; i++)
				{
				  if(comboVal[i].valueField == er_timelineVal)
				  {
					flag=true;
				  }
				}
				if(flag)
					timelineCombo.setValue(er_timelineVal);
				else
					timelineCombo.setValue("1 day");
			}
		});

		var inidate=appConstants.iniDateFormat;
		url= '/final/servlet/com.eg.ErRemoteScriptingServlet';
		er_timelineVal=Ext.getCmp('er_timeline').getValue();
		var er_stdateVal= Ext.getCmp('er_stdate').dataArray;
		var er_enddateVal= Ext.getCmp('er_enddate').dataArray;
		var er_sthr= Ext.getCmp('er_sthr').dataArray;
		var er_endhr= Ext.getCmp('er_endhr').dataArray;
		if (er_trenddata == "No") 
		{
			isTrend=false; // this variable is declared in /final/scripts/utilities/Timeline.js
			param1 = "F=getTime&U=123444&C=jsrs1&P0=[" + er_timelineVal + "]&P1=["+ er_stdateVal + "]&P2=[" + er_enddateVal + "]&P3=[" + er_sthr+ "]&P4=[" + er_endhr + "]&P5=[" + inidate + "]";
		} 
		else 
		{
			isTrend=true; // this variable is declared in /final/scripts/utilities/Timeline.js
			if(er_timelineVal=='Any')
			{
				param1 = "F=getTime&U=123444&C=jsrs1&P0=[" + er_timelineVal+ "]&P1=[" + er_stdateVal + "]&P2=[" + er_enddateVal + "]&P3=["+ er_sthr + "]&P4=[" + er_endhr + "]&P5=[" + inidate+ "]";
			}
			else
			{
				param1 = "F=getTrendTime&U=123444&C=jsrs1&P0=[" + er_timelineVal+ "]&P1=[" + er_stdateVal + "]&P2=[" + er_enddateVal + "]&P3=["+ er_sthr + "]&P4=[" + er_endhr + "]&P5=[" + mgr_stmin + "]&P6=[" + mgr_enmin + "]&P7=[" + inidate+ "]";
			}
		}
			Ext.Ajax.request({
				url : '/final/servlet/com.eg.ErRemoteScriptingServlet',
				params : param1, 
				async : true,
				success : function(response) { 
					var jsonObject = Ext.decode(response.responseText);
					var values = jsonObject.timeline;
					Ext.getCmp('er_stdate').dataArray=values[0];
					Ext.getCmp('er_enddate').dataArray=values[1];
					Ext.getCmp('er_sthr').dataArray=values[2];
					Ext.getCmp('er_endhr').dataArray=values[3]; 
					mgr_stmin = values[4];
					mgr_enmin = values[5];

					Ext.getCmp('er_stdate').setValue(values[6]);
					Ext.getCmp('er_enddate').setValue(values[7]); 
					Ext.getCmp('er_sthr').setValue(values[8]);
					Ext.getCmp('er_endhr').setValue(values[9]); 
					stmin =values[10];
					enmin = values[11];
			}
		});
	},
	showConfigDropdown:function(){
			isSettingsEnabled=true;
			var thisController = this;
			var tpl = new Ext.XTemplate('<div style="float:left;margin:0px 0px 0px 0px;">'+settings+'</div><div style="text-align:right;float:right;"><div class="iconCloseNew" id="closeSettings"></div></div>');
			Ext.create('Ext.container.Container',{
			width:563,
			//padding:5,
			id:'configMod',
			//cls:'configMode_popup',
			ui:'settingsWindowContainer',
			items:[
				{
					xtype:'container',
					cls:'configMode_popupArrow',
					style:{'top':'-14px','left':'327px'}
				},
				{
					xtype:'container',
					html:tpl.apply(),
					cls:'containerHeader',
					style:{'top':'0px','margin':'0px'}
				},
				{
					xtype:'operationnetworksettings',
					parent:this
				}
			],
			onRender:function(){
				Ext.EventManager.onWindowResize(function () {
					Ext.get('configMod').setStyle('left', '');
				});
				Ext.get('closeSettings').on('click', function () {
					thisController.validateAndCloseSettings();
				});
			},
			renderTo:'operation_report-body'
			});

	},
	closeSettingAndSubmit:function()
	{
		if(this.validateAndCloseSettings())
		{
			this.beforeFormSubmit();
		}
	},
	validateAndCloseSettings :  function()
	{
		if (Ext.getCmp('reportGeneration').getValue() == 'background' && !validateTextBoxWithSpecialChars(Ext.getCmp('bgReportName').getValue(),'Attachment',true))
		{
			return false;
		}
		Ext.getCmp('submit').setDisabled(false);
		Ext.get('configMod').animate({duration: 500,to: {y: -500}});
		return true;
	},
	legendOnChange:function(){
		chk=Ext.getCmp('showLegend').value;
	},
	goTo: function (obj) {
		// by karthikeyan
		if (Ext.getCmp('er_timeline').getValue() == 'Any')
		{
			Ext.MessageBox.show({
				title : 'Operation Reports',
				msg : 'Chosen timeline not allowed',
				buttons : Ext.Msg.OK,
				icon: Ext.MessageBox.WARNING
			});
			return;
		}
		var hiddenFields = appConstants.publicJSON["hiddens"];
		this.updateQueryString();
		var from_schedule = hiddenFields["fromScheduleModify"];
		var from_favourite = hiddenFields["fromFavoriteModify"];
		var favorite_id =appConstants.FavoriteId;
		//var favorite_id = hiddenFields["favorite_id"];
		
		var er_favorite = hiddenFields["er_favorite"];
		if ((from_schedule != null && from_schedule == "Yes")) {
			 this.schedule(obj);
		}else{
			var ReportVal = Ext.getCmp('Report').getValue();
			if (ReportVal=='Zone')
			{
				var er_group = Ext.getCmp("zone").getValue();
				appConstants.queryString+="&er_group="+er_group;
			}
			else if (ReportVal=='Segment')
			{
				var er_group = Ext.getCmp("segment").getValue();
				appConstants.queryString+="&er_group="+er_group;
			}
			else if (ReportVal=='Service')
			{
				var er_group = Ext.getCmp("service").getValue();
				appConstants.queryString+="&er_group="+er_group;
			}
			var target= '/final/servlet/com.eg.ErFavoriteC?' +appConstants.queryString + '&call=json&cmd=client&FavoriteId='+favorite_id+ "&shareUsers=" + er_favorite + "&publicUsers=" + er_favorite+"&fromFavoriteModify=yes";
			//Ext.widget('scheduleWindow').show();
			//Ext.select('#schWin').set({src :target});
			var targetsource=target+'&showLegend='+Ext.getCmp('showLegend').getValue();
			document.location=targetsource;//target+'&showLegend='+Ext.getCmp('showLegend').getValue();
		}
	},
	loadMask: function () {
		appConstants.initLdgMask.show();
	},
	expandMe: function (btn) {
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		appConstants.erUtils.expandMultiComboButton(Ext.getCmp('components'),"Components",btn);
	},
	expandInfo: function (btn) {
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		appConstants.erUtils.expandMultiComboButton(Ext.getCmp('descriptors'),"Descriptors",btn);
	},
	filterMultiselect: function (obj) {
	var compStore=null,compName=null;
		var compId = obj.getId();
		if(compId=='compSearch')
		 {
			compName='components';
			compStore=componentsRawData;
		}
		else if(compId=='infoSearch')
		{
			compName='descriptors';
			compStore=rawDataForDescription;
		}
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
			obj.toggleTriggger();
		appConstants.erUtils.filterComboStore(obj,Ext.getCmp(compName),compStore);
	},
	openDiagnosis: function () {
		Ext.widget('reporterdata', {
			scroll: false,
			autoScroll: false
		}).show();
		var dataContentDiv = Ext.select('#dataContentDiv');
		dataContentDiv.set({
			src: appConstants.drillDownDDURL
		});
	},
	drillDownData: function () {
		Ext.widget('reporterdata').show();
		var dataContentDiv = Ext.select('#dataContentDiv');
		dataContentDiv.set({
			src: appConstants.drillDownDataURL
		});
	},
	drillDownMail: function () {
		appConstants.drillDownParams = '&keyPrefix=enlarged&DrillDown=yes';
		this.sendMail();
	},
	drillDownSave: function () {
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		appConstants.erUtils.savePDF(appConstants.drillDownSaveURL);
	},
	drillDownPrint: function () {
		Ext.widget('print').show();
		var printContentDiv = Ext.select('#printContentDiv');
		printContentDiv.set({
			src: appConstants.drillDownPrintURL
		});
	},
	updateDrillDownQueryString: function () {
		var isSummary = false;
		if (Ext.getCmp('TimelineReportType').getValue() == 'Summary') {
			isSummary = true;
		}
		var usertimelinVal = (!Ext.isEmpty(Ext.getCmp('er_usertimeline').getValue())) ? Ext.getCmp('er_usertimeline').getValue() : '-1';
		var duration = Ext.getCmp('duration').getValue();
		var er_option = Ext.getCmp('Report').getValue();
		var getMaxDaysInMonth = Ext.getCmp('getMaxDaysInMonth').getValue();
		var graphMode = Ext.getCmp('drillGraphmode').getValue();
		var endhr = Ext.getCmp('drillEndHour').getValue();
		var er_time = Ext.getCmp('er_time').getValue();
		var reportgenVal = Ext.getCmp('reportGeneration').getValue();
		var starthrVal = Ext.getCmp('drillStartHour').getValue();
		var limitforbgVal = Ext.getCmp('limitforbg').getValue();
		var graphType = Ext.getCmp('gtype').getValue();
		var endmin = appConstants.publicJSON['endMinForDisplay'];
		var startminVal = appConstants.publicJSON['startMinForDisplay'];
		var showDataVal = Ext.getCmp('showdata').getValue();
		var er_trenddata = 'Yes';
		if (showDataVal == 'Detailed') {
			er_trenddata = 'No';
		}
		var detailtimeVal = Ext.getCmp('detailtime').getValue();
		var bgenabledVal = Ext.getCmp('bgenabled').getValue();
		var TimelineReportTypeVal = Ext.getCmp('TimelineReportType').getValue();
		var compTypeVal = Ext.getCmp('compType').getValue();
		var er_group = '';
		var ReportVal = Ext.getCmp('Report').getValue();
		if (ReportVal != 'Component') {
			if (ReportVal == 'Zone') {
				er_group = Ext.getCmp('zone').getValue();
			} else if (ReportVal == 'Segment') {
				er_group = Ext.getCmp('segment').getValue();
			} else if (ReportVal == 'Service') {
				er_group = Ext.getCmp('service').getValue();
			}
		}
		var trendenable = true;
		if (Ext.getCmp('trendenable') != null) {
			trendenable = Ext.getCmp('trendenable').getValue();
		}
		var er_testVal = '';
		var er_disp_measVal = '';
		var er_measureVal = '';
		var startdateVal = Ext.Date.dateFormat(Ext.getCmp('drillStartdate').getValue(), mgrDateFormat);
		var er_timelineVal = Ext.getCmp('drillTimeLineCombo').getValue();
		var er_ViewNameVal = Ext.getCmp('er_ViewName').getValue();
		var endDateVal = Ext.Date.dateFormat(Ext.getCmp('drillEnddate').getValue(), mgrDateFormat);
		if (!isSummary) {
			var getLoadedImageURL = Ext.getCmp('drillDownImage').src;
			var tmpURL = getLoadedImageURL.substring(getLoadedImageURL.indexOf('er_test') + 8);
			er_testVal = tmpURL.substring(0, tmpURL.indexOf('&'));
			tmpURL = getLoadedImageURL.substring(getLoadedImageURL.indexOf('er_disp_meas') + 13);
			er_disp_measVal = tmpURL.substring(0, tmpURL.indexOf('&'));
			tmpURL = getLoadedImageURL.substring(getLoadedImageURL.indexOf('er_measure') + 11);
			er_measureVal = tmpURL.substring(0, tmpURL.indexOf('&'));
		} else {
			var getChartURL = Ext.getCmp('fusionChart').dataArray;
			var tmpURL = getChartURL.substring(getChartURL.indexOf('er_test') + 8);
			er_testVal = tmpURL.substring(0, tmpURL.indexOf('&'));
			tmpURL = getChartURL.substring(getChartURL.indexOf('er_disp_meas') + 13);
			er_disp_measVal = tmpURL.substring(0, tmpURL.indexOf('&'));
			tmpURL = getChartURL.substring(getChartURL.indexOf('er_measure') + 11);
			er_measureVal = tmpURL.substring(0, tmpURL.indexOf('&'));
		}
		var er_componentVal = appConstants.drillDownCompName;
		appConstants.drillDownQStr = '&er_usertimeline=' + usertimelinVal + '&uid=' + appConstants.getUserID + '&schedule_id=null&er_duration=' + duration + '&er_reportType=operation&er_option=' + er_option + '&getMaxDaysInMonth=' + getMaxDaysInMonth + '&reporttype=operation&er_rtype=' + appConstants.getReportOption + '&er_mode=' + graphMode + '&endhr=' + endhr + '&er_time=' + er_time + '&er_reportgenration=' + reportgenVal + '&savereport=save&er_component_div=&starthr=' + starthrVal + '&limitforbg=' + limitforbgVal + '&er_graph=' + graphType + '&endmin=' + endmin + '&currTime=&er_period=' + duration + '&startmin=' + startminVal + '&er_trenddata=' + er_trenddata + '&divStatus=none&inidate=' + appConstants.iniDateFormat + '&detailtime=' + detailtimeVal + '&forwardto=ErMeasure.jsp&fromSchedule=null&bgenabled=' + bgenabledVal + '&er_gtype=' + TimelineReportTypeVal + '&er_comptype=' + compTypeVal + '&er_group=' + er_group + '&servletName=com.eg.ErRepoLiteC&us_id=' + appConstants.getUserID + '&trendenable=' + trendenable + '&userID=' + appConstants.getUserID + '&startdate=' + startdateVal + '&er_timeline=' + er_timelineVal + '&er_bgreportfrom=Operation_' + appConstants.getReportOption + '&screenWidth=1002&er_ViewName=' + er_ViewNameVal + '&er_search=&enddate=' + endDateVal + '&enlarged=&er_test=' + er_testVal + '&er_disp_meas=' + er_disp_measVal + '&er_measure=' + er_measureVal + '&er_component=' + er_componentVal + '&er_width=850&er_height=400&reportName=ErMeasure&drillDown=yes&drilldownenabled=Yes';
	},
	drillDownSubmit: function (obj) {
		this.updateDrillDownQueryString();
		var isSummary = false;
		var chartURLData = '';
		if (Ext.getCmp('TimelineReportType').getValue() == 'Summary') {
			isSummary = true;
		}
		var getId = obj.getId();
		var myMask = new Ext.LoadMask(Ext.getBody(), {
			msg: 'Loading...'
		});
		var isSubmit = false;
		if (getId == 'drillDownSubmit') {
			isSubmit = true;
			var tmpStartDate = Ext.getCmp('drillStartdate').getValue();

			tmpStartDate.setHours(Ext.getCmp('drillStartHour').getValue());
			var tmpEndDate = Ext.getCmp('drillEnddate').getValue();
			tmpEndDate.setHours(Ext.getCmp('drillEndHour').getValue());
			var result = checkDateTime(tmpStartDate, tmpEndDate);
			if (!result) {
				return;
			}
			var er_usertimeline = Ext.getCmp('er_usertimeline').getValue();
			var getMaxDaysInMonth = Ext.getCmp('getMaxDaysInMonth').getValue();
			if (er_usertimeline != '-1') {
				var usertimelineValid = isUserTimelineLimitExceeded(er_usertimeline, getMaxDaysInMonth, tmpStartDate, tmpEndDate);
				if (!usertimelineValid) {
					Ext.MessageBox.show({
						title: 'Alert',
						msg: appConstants.userTimelineErrorMsg,
						buttons: Ext.MessageBox.OK,
						icon: Ext.MessageBox.WARNING
					});
					return;
				}
			}
		}
		try {
			if ((getId == 'drillTimeLineCombo' || getId == 'drillDownSubmit') && Ext.getCmp('drillTimeLineCombo').getValue() == 'Any') {
				Ext.getCmp('drillStartdate').setDisabled(false);
				Ext.getCmp('drillEnddate').setDisabled(false);
				Ext.getCmp('drillStartHour').setDisabled(false);
				Ext.getCmp('drillEndHour').setDisabled(false);
				if (getId == 'drillTimeLineCombo') {
					return;
				}
			} else {
				Ext.getCmp('drillStartdate').setDisabled(true);
				Ext.getCmp('drillEnddate').setDisabled(true);
				Ext.getCmp('drillStartHour').setDisabled(true);
				Ext.getCmp('drillEndHour').setDisabled(true);
			}
			if (getId == 'drillDownSubmit') {
				appConstants.drillDownQStr += '&isSubmit=true';
			} else {
				appConstants.drillDownQStr += '&isSubmit=false';
			}
			if (isSubmit) {
				myMask.show();
			}
			Ext.Ajax.request({
				url: '/final/reporter/ErMeasureJSON.jsp?' + appConstants.drillDownQStr,
				method: 'POST',
				success: function (response) {
					if (isSubmit) {
						myMask.hide();
					}
					var jsonText = response.responseText;
					var jsonData = '';
					if (!Ext.isEmpty(jsonText) && response.status == 200) {
						jsonData = Ext.decode(jsonText);
						if (getId == 'drillTimeLineCombo') {
							var startDateVal = jsonData['startdate'];
							Ext.getCmp('drillStartdate').setValue(startDateVal);
							var endDateVal = jsonData['enddate'];
							Ext.getCmp('drillEnddate').setValue(endDateVal);
							var startHrVal = jsonData['starthr'];
							Ext.getCmp('drillStartHour').setValue(startHrVal);
							var endHrVal = jsonData['endhr'];
							Ext.getCmp('drillEndHour').setValue(endHrVal);
						} else if (getId == 'drillDownSubmit') {
							if (!isSummary) {
								var imageURLData = jsonData['imageURL'];
								Ext.getCmp('drillDownImage').setSrc(imageURLData);
							} else {
								chartURLData = jsonData['chartURL'];
							}
							var saveURLData = jsonData['drillDownSaveURL'];
							var printURLData = jsonData['drillDownPrintURL'];
							appConstants.drillDownPrintURL = printURLData;
							var controller = appConstants.drillDownPrintURL.substring(appConstants.drillDownPrintURL.indexOf("servlet/com.eg."), appConstants.drillDownPrintURL.indexOf("?"));
							appConstants.drillDownPrintURL = appConstants.drillDownPrintURL.replace(controller, "reporter/ErMeasure.jsp");
							appConstants.drillDownPrintURL += "&pdfPrint=yes";
							appConstants.drillDownSaveURL = saveURLData;
							var controller = appConstants.drillDownSaveURL.substring(appConstants.drillDownSaveURL.indexOf("servlet/com.eg."), appConstants.drillDownSaveURL.indexOf("?"));
							appConstants.drillDownSaveURL = appConstants.drillDownSaveURL.replace(controller, "reporter/ErHtmlToSavePdf.jsp");
							appConstants.drillDownSaveURL += "&sample=yes&drillSes=yes&";
							var er_option = Ext.getCmp('Report').getValue();
							var drillDownDataURLData = jsonData['drillDownDataURL'];
							drillDownDataURLData = drillDownDataURLData.replace("option=" + er_option, "option=data");
							appConstants.drillDownDataURL = drillDownDataURLData;
							appConstants.drillDownDDURL = jsonData['ddURL'];
						}
					}
				},
				callback: function () {
					if (isSummary && isSubmit) {
						var graphMode = Ext.getCmp('drillGraphmode').getValue();
						var xmlData = '';
						if (!Ext.isEmpty(chartURLData)) {
							Ext.Ajax.request({
								url: chartURLData,
								async: false,
								success: function (response) {
									var tmpJsonText = response.responseText;
									if (response.status == 200 && !Ext.isEmpty(tmpJsonText)) {
										var tmpJsonData = Ext.decode(tmpJsonText);
										xmlData = tmpJsonData['xmldata'];
										//xmlData= null;
										if (!Ext.isEmpty(xmlData)) {
					if(appConstants.chartType=='fusionchart')
					{
						
					if (FusionCharts("chart" ))
						FusionCharts("chart").dispose();
											var myChart = new FusionCharts('/final/FusionCharts/swf/StackedColumn' + graphMode + '.swf', 'chart', "100%", "100%", "0", "1");
											myChart.setXMLData(xmlData);
											myChart.setTransparent(true);
											myChart.render('renderChart');
					}
					else
					{
						var lineChart = {};
						lineChart = jQuery.extend(true, {}, getHighChartsBarInstance('renderChart',"230","200"), lineChart);
						lineChart.setData(tmpJsonData,'<%=currentDateFormat%>','');
						lineChart.drawChart();
					}
										} else {
											Ext.get('renderChart').update('<div><img src="/final/images/'+strSkin+'/nomeasures_custom.png" /></div>');
										}
									} else {
										Ext.get('renderChart').update('<div><img src="/final/images/'+strSkin+'/nomeasures_custom.png" /></div>');
									}
								}
							});
						} 
					}
				},
				failure: function () {
					alert('I am not loading...' + drillDownURL);
				}
			});
		} catch (e) {
			alert('[Exception] ' + e);
		}
	},
	showDetailTimeline: function (c) {
		c.body.on('click', function() {
					var clickedObj = c.getId();
					//var drilldownURL = c.dataURL;
					var  drillDownURL = c.dataArray[0];
					var windowPrintFile = Ext.widget('newwindow'); // call from measurepopupapp
					windowPrintFile.show();
					var printContentDiv = Ext.get('drillDownContentDiv');
					printContentDiv.set({
								src : drillDownURL
							});
		});

		/*var title = c.header.title; //getting the current block title
		c.body.on('mousedown', function () {
			alert("coming inside");
			var getTestPanelId = c.id;
			var getChartPanelObj = Ext.getCmp(getTestPanelId);
			var isSummary = false;
			var chartURLData = '';
			if (Ext.getCmp('TimelineReportType').getValue() == 'Summary') {
				isSummary = true;
			}
			var imageURL = '';
			drillDownURL = getChartPanelObj.dataArray[0];
			appConstants.appConstants.drillDownCompName = getChartPanelObj.dataArray[1];
			Ext.Ajax.request({
				url: drillDownURL,
				method: 'POST',
				async: false,
				success: function (response) {
					var jsonText = response.responseText;
					var jsonData = '';
					if (response.status == 200 && !Ext.isEmpty(jsonText)) {
						jsonData = Ext.decode(jsonText);
						imageURL = jsonData['imageURL'];
						var printURLData = jsonData['appConstants.drillDownPrintURL'];
						appConstants.drillDownPrintURL = printURLData;
						var controller = appConstants.drillDownPrintURL.substring(appConstants.drillDownPrintURL.indexOf("servlet/com.eg."), appConstants.drillDownPrintURL.indexOf("?"));
						appConstants.drillDownPrintURL = appConstants.drillDownPrintURL.replace(controller, "reporter/ErMeasure.jsp");
						appConstants.drillDownPrintURL += "&pdfPrint=yes";
						var saveURLData = jsonData['appConstants.drillDownSaveURL'];
						appConstants.drillDownSaveURL = saveURLData;
						var controller = appConstants.drillDownSaveURL.substring(appConstants.drillDownSaveURL.indexOf("servlet/com.eg."), appConstants.drillDownSaveURL.indexOf("?"));
						appConstants.drillDownSaveURL = appConstants.drillDownSaveURL.replace(controller, "reporter/ErHtmlToSavePdf.jsp");
						appConstants.drillDownSaveURL += "&sample=yes&drillSes=yes&";
						var er_option = Ext.getCmp('Report').getValue();
						var drillDownDataURLData = jsonData['drillDownDataURL'];
						drillDownDataURLData = drillDownDataURLData.replace("option=" + er_option, "option=data");
						drillDownDataURL = drillDownDataURLData;
						appConstants.drillDownDDURL = jsonData['ddURL'];
						chartURLData = jsonData['chartURL'];
					}
				},
				failure: function () {
					alert('failure calling...');
				}
			});
			var title = c.header.title;
			var isAnySelected = true;
			if (Ext.getCmp('er_timeline').getValue() == 'Any') {
				isAnySelected = false;
			}
			try {
				Ext.getCmp('operation_report').add({
					xtype: 'detailtimeline',
					tools: [{
						xtype: 'usertimelinetools'
					}],
					id: 'detailTimeline',
					title: title,
					hidden: false,
					items: [{
						xtype: 'form',
						layout: 'hbox',
						bodyPadding: '0 10 0 10',
						defaults: {
							margin: '0 10 0 0',
							labelAlign: 'top',
							labelSeparator: ''
						},
						buttonAlign: 'center',
						items: [{
							fieldLabel: Ext.getCmp('er_timeline').getFieldLabel(),
							xtype: 'scrollcombo',
							id: 'drillTimeLineCombo',
							name: 'drillTimeLineCombo',
							displayField: 'displayField',
							valueField: 'valueField',
							queryMode: 'local',
							store: Ext.getCmp('er_timeline').getStore(),
							value: Ext.getCmp('er_timeline').getValue(),
							width: 90,
							cls: 'dropdown'
						}, {
							xtype: 'datepicker',
							id: 'drillStartdate',
							name: 'drillStartdate',
							format: mgrDateFormat,
							fieldLabel: Ext.getCmp('er_stdate').getFieldLabel(),
							cls: 'datepicker',
							value: Ext.getCmp('er_stdate').getValue(),
							width: 115,
							disabled: isAnySelected
						}, {
							xtype: 'scrollcombo',
							width: 50,
							id: 'drillStartHour',
							name: 'drillStartHour',
							defaultListConfig: {
								loadingHeight: 70,
								minWidth: 50,
								maxHeight: 300,
								shadow: 'sides'
							},
							store: ['00', '01', '02', '03', '04', '05', '06', '07', '08', '09', '10', '11', '12', '13', '14', '15', '16', '17', '18', '19', '20', '21', '22', '23'],
							value: Ext.getCmp('er_sthr').getValue(),
							displayField: 'displayField',
							valueField: 'valueField',
							queryMode: 'local',
							fieldLabel: Ext.getCmp('er_sthr').getFieldLabel(),
							cls: 'dropdown',
							disabled: isAnySelected,
						}, {
							xtype: 'datepicker',
							id: 'drillEnddate',
							name: 'drillEnddate',
							format: mgrDateFormat,
							fieldLabel: Ext.getCmp('er_enddate').getFieldLabel(),
							cls: 'datepicker',
							width: 115,
							disabled: isAnySelected,
							value: Ext.getCmp('er_enddate').getValue()
						}, {
							xtype: 'scrollcombo',
							width: 50,
							defaultListConfig: {
								loadingHeight: 70,
								minWidth: 50,
								maxHeight: 300,
								shadow: 'sides'
							},
							fieldLabel: Ext.getCmp('er_endhr').getFieldLabel(),
							cls: 'dropdown',
							id: 'drillEndHour',
							name: 'drillEndHour',
							store: ['00', '01', '02', '03', '04', '05', '06', '07', '08', '09', '10', '11', '12', '13', '14', '15', '16', '17', '18', '19', '20', '21', '22', '23'],
							value: Ext.getCmp('er_endhr').getValue(),
							displayField: 'displayField',
							valueField: 'valueField',
							queryMode: 'local',
							disabled: isAnySelected
						}, {
							xtype: 'combo',
							width: 50,
							defaultListConfig: {
								loadingHeight: 70,
								minWidth: 50,
								maxHeight: 300,
								shadow: 'sides'
							},
							id: 'drillGraphmode',
							name: 'drillGraphmode',
							fieldLabel: Ext.getCmp('er_mode').getFieldLabel(),
							value: Ext.getCmp('er_mode').getValue(),
							cls: 'dropdown',
							store: ['2D', '3D']
						}],
						buttons: [{
							text: 'submit',
							padding: 10,
							id: 'drillDownSubmit',
							cls: 'button20'
						}]
					}, {
						xtype: 'container',
						padding: 10,
						style: {
							'text-align': 'center'
						},
						items: [{
							xtype: 'header'
						}, {
							xtype: 'imagecomponent',
							id: 'drillDownImage',
							src: imageURL,
							hidden: isSummary,
							listeners: {
								afterrender: function () {
									Ext.create('Ext.tip.ToolTip', {
										target: 'drillDownImage',
										trackMouse: true,
										html: title
									})
								}
							}
						}, {
							xtype: 'panel',
							id: 'fusionChart',
							dataArray: chartURLData,
							style: {
								'margin': '0px auto'
							},
							html: '<div id="renderChart" style="cursor:pointer"></div>',
							hidden: !isSummary,
							height: 400,
							width: '100%',
							listeners: {
								afterrender: function () {
									var xmlData = '';
									var graphMode = Ext.getCmp('drillGraphmode').getValue();
									if (!Ext.isEmpty(chartURLData)) {
										Ext.Ajax.request({
											url: chartURLData,
											async: false,
											success: function (response) {
												var jsonText = response.responseText;
												if (response.status == 200 && !Ext.isEmpty(jsonText)) {
													var jsonData = Ext.decode(jsonText);
													xmlData = jsonData['xmldata'];
													//xmlData = null;
													if (!Ext.isEmpty(xmlData)) {
														var myChart = new FusionCharts('/final/FusionCharts/swf/StackedColumn' + graphMode + '.swf', 'chart', "100%", "100%", "0", "1");
														myChart.setXMLData(xmlData);
														myChart.setTransparent(true);
														myChart.render('renderChart');
													} else {
														Ext.get('renderChart').update('<div><img src="/final/images/nomeasures_custom.png" /></div>');
													}
												}
											}
										});
									}
								}
							}
						}]
					}]
				});
			} catch (e) {
				console.log('Exception ' + e);
				alert(e);
			}
			Ext.getCmp('operation_report').doLayout();
			if (isSummary || Ext.isEmpty(appConstants.drillDownDDURL)) {
				Ext.getCmp('diagnosis').setDisabled(true);
			}
		});*/
	},
	loadPage: function () {
		this.getMain().setTitle(appConstants.publicJSON['title']);
		this.enableOrDisableUtilities(true);
		var localjson=appConstants.publicJSON;
		var hiddenFields = localjson["hiddens"];
		var from_schedule = hiddenFields["fromScheduleModify"];
		var from_favourite = hiddenFields["fromFavoriteModify"];
		if (appConstants.isSubmit != null && appConstants.isSubmit == "true" && ( from_schedule != "Yes" && from_favourite != "Yes"))  
		{
			if(appConstants.isshowLegend== "true" || appConstants.isshowLegend==true)
			  Ext.getCmp('showLegend').setValue(true);
			 this.loadSubmitData(this.myJson);
		}
		else
		{
			if(appConstants.isshowLegend== "true" || appConstants.isshowLegend==true)
			  Ext.getCmp('showLegend').setValue(true);
			if(appConstants.frmSchModify=="Yes")
				return;
				if (appConstants.isForceSubmit=='true')
				{
					this.beforeFormSubmit();
					if(appConstants.isCompareReport =='true')
						appConstants.callFromReport = 'true';
	//				appConstants.isForceSubmit='false';
				}
		}
		if (appConstants.fromCtxUserRpt != null && appConstants.fromCtxUserRpt == 'true') {
			  this.loadSubmitData(this.myJson);
			  //this.formSubmit(Ext.getCmp('submit'));
		}
	},
	validateSettings: function () {
		var er_usertimeline = '';
		if (!Ext.isEmpty(Ext.getCmp('er_usertimeline'))) {
			er_usertimeline = Ext.getCmp('er_usertimeline').getValue();
		}
		var getMaxDaysInMonth = '';
		if (!Ext.isEmpty(Ext.getCmp('getMaxDaysInMonth'))) {
			getMaxDaysInMonth = Ext.getCmp('getMaxDaysInMonth').getValue();
		}
		var hiddens= appConstants.publicJSON['hiddens'];
		var getMaxDaysInMonth = hiddens['getMaxDaysInMonth'];
		var er_usertimeline =hiddens['er_usertimeline'];
		var tmpStDate = Ext.getCmp('er_stdate').getValue();
		tmpStDate.setHours(Ext.getCmp('er_sthr').getValue());
		var tmpEnDate = Ext.getCmp('er_enddate').getValue();
		tmpEnDate.setHours(Ext.getCmp('er_endhr').getValue());
		var result = checkDateTime(tmpStDate, tmpEnDate);
		if (!result) 
		{
			return;
		}
		if (er_usertimeline != '-1') {
			var usertimelineValid = isUserTimelineLimitExceeded(er_usertimeline, getMaxDaysInMonth, tmpStDate, tmpEnDate);
			if (!usertimelineValid) {
				Ext.MessageBox.show({
					title: 'Alert',
					msg: appConstants.userTimelineErrorMsg,
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
				});
				return;
			}
		}
		//var bgenabled =hiddens['bgenabled'];
		var limitforbg = hiddens['limitforbg'];
		var reportgenVal,reportName;
		if(isSettingsEnabled)
		{
			reportgenVal=Ext.getCmp('reportGeneration').getValue();
			reportName=Ext.getCmp('bgReportName').getValue();
		}
		else
		{
			reportgenVal=appConstants.publicJSON.er_reportgenration_combo_selected;
			reportName=appConstants.publicJSON.bgReportName;
		}

		var isSettingsOk = true;
		if (reportgenVal == 'foreground') {
			if (!Ext.isEmpty(limitforbg)) {
				if (!checkTimeLineForBgLimit(limitforbg, getMaxDaysInMonth, tmpStDate, tmpEnDate)) {
					Ext.MessageBox.confirm('Confirm', appConstants.forGrdReportConfirmMsg, this.showResult, this);
					isSettingsOk = false;
				}
			}
		}
		if (reportgenVal == 'background') {
			 if (!validateTextBoxWithSpecialChars(reportName,'Attachment',true))
				isSettingsOk = false;
		}
		if (isSettingsOk && isSettingsEnabled) {
			var getButtonObj = Ext.getCmp('submit');
			getButtonObj.setDisabled(false);
			Ext.get('configMod').animate({
				duration: 500,
				to: {
					y: -500
				}
			});
		}
		return isSettingsOk;
	},
	showResult: function (btn) {
		if (btn == 'yes') {
			var getButtonObj = Ext.getCmp('submit');
			getButtonObj.setDisabled(false);
			 if (isSettingsEnabled)
			{
				Ext.get('configMod').animate({
					duration: 500,
					to: {
						y: -500
					}
				});
			}
			this.formSubmit(getButtonObj);
		} else {
				if (!isSettingsEnabled)
				{
					this.getReporterSettings().down('button').fireHandler();
				}
				var bgReportName=Ext.getCmp('bgReportName');
				Ext.getCmp('reportGeneration').setValue('background');
				bgReportName.setValue("");
				bgReportName.show();
				bgReportName.focus(false, 1000);
				this.beforeFormSubmit();
			}
	},
	resizePanel: function (panel) {
		//resize the panel
		Ext.getCmp('selectionDetails').setWidth(Ext.getBody().getViewSize().width - 85);
		Ext.EventManager.onWindowResize(function () {
			Ext.getCmp('selectionDetails').setWidth(Ext.getBody().getViewSize().width - 85);
			panel.doComponentLayout();
		});
	},
	showBackgroundReport: function () {
		Ext.getCmp('graphPanel').hide();
		this.enableOrDisableUtilities();
		var reportGenType = Ext.getCmp('reportGeneration').getValue();
		if (reportGenType == 'background') {
			Ext.getCmp('bgReportName').setValue("");
			Ext.getCmp('bgReportName').show();
			Ext.getCmp('submitViaSetting').show();
			Ext.getCmp('moreOptionCloseId').hide();
		}
		else {
			Ext.getCmp('bgReportName').hide();
			Ext.getCmp('submitViaSetting').hide();
			Ext.getCmp('moreOptionCloseId').show();
		}
	},
	checkTimeline: function (obj) { 
		var TimelineReportTypeObj = Ext.getCmp('TimelineReportType');

		if (TimelineReportTypeObj.getValue()=='Summary' || TimelineReportTypeObj.getValue()=='Trend' )
		{
			isTrend=true;
		}
		else
		{ 
			if (Ext.getCmp('showdata').getValue()=='Trend')
			{
				isTrend=true;
			}
			else
			{
				isTrend=false;
			}
		}
		if (!Ext.isEmpty(obj)) {
			this.formSubmit(TimelineReportTypeObj);
		}
	},
	changeEr_mode: function (combo) {

		var favorite_id = appConstants.publicJSON['hiddens']["favorite_id"];
		var from_schModify = appConstants.publicJSON['hiddens']["fromScheduleModify"];
		if (!(favorite_id == 'undefined' || favorite_id == undefined) || !(from_schModify == null || from_schModify == 'null'))
		{
			return;
		}
		if (isSettingsEnabled)
		{
			Ext.get('configMod').animate({
					duration: 250,
					to: {
						y: -530
					}
				});
		}
		this.beforeFormSubmit();
	 },
	changeTimeline: function (combo) {
		var TimelineReportTypeObj = Ext.getCmp('TimelineReportType');
		if (TimelineReportTypeObj.getValue()=='Summary' || TimelineReportTypeObj.getValue()=='Trend' )
		{
			isTrend=true;
		}
		else
		{
			if (Ext.getCmp('showdata').getValue()=='Trend')
			{
				isTrend=true;
			}
			else
			{
				isTrend=false;
			}
		}
		var timelineComboObj = Ext.getCmp('er_timeline');
		if (combo.getValue() == 'M') {
			timelineComboObj.getStore().loadRawData(this.myJson['monthTimelineCombo']);
			timelineComboObj.setValue('3 Months');
		} else if (combo.getValue() == 'D') {
			 timelineComboObj.getStore().loadRawData(this.myJson['timelineCombo']);
			timelineComboObj.setValue('1 week');
		} else {
			timelineComboObj.getStore().loadRawData(this.myJson['timelineCombo']);
			timelineComboObj.setValue('1 day');
		}
		timelineComboObj.fireEvent('select',timelineComboObj);
		Ext.getCmp('er_sthr').setDisabled(true);
		Ext.getCmp('er_endhr').setDisabled(true);
		Ext.getCmp('er_enddate').setDisabled(true);
		Ext.getCmp('er_stdate').setDisabled(true);

		//this.enableTimeline();
	},
	beforeFormSubmit: function () {
	Ext.getCmp('panelinsidetoggle').setDisabled(false);
		var tmpJson = this.myJson;
		//this.getSubmittedreports().show();
	   // var graphPanelObj = Ext.getCmp('graphPanel').show();
		//graphPanelObj.removeAll(true);
	   // graphPanelObj.doLayout();
		var getButtonObj = Ext.getCmp('submit');
		var ReportzCombo =Ext.getCmp('Report');
		var ReportVal = Ext.getCmp('Report').getValue();
		var zoneCombo = Ext.getCmp('zone');
		var serviceCombo = Ext.getCmp('service');
		var segmentCombo = Ext.getCmp('segment');
		var compTypeCombo = Ext.getCmp('compType');
		var componentsCombo = Ext.getCmp('components');
	  //  var showLegend = Ext.getCmp('showLegend');
		if (!Ext.isEmpty(ReportVal)  && (ReportVal == 'Not Applicable' || ReportVal == '-1' )) {
			Ext.MessageBox.show({
				title: 'Operation Reports',
				msg: ReportzCombo.getStore().getAt(0).get('displayField'),
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
			});
			return;
		}
		if (ReportVal == 'Zone' && !Ext.isEmpty(zoneCombo) && zoneCombo.getValue() == '-1') {
			Ext.MessageBox.show({
				title: 'Operation Reports',
				msg: zoneCombo.getStore().getAt(0).get('displayField'),
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
			});
			return;
		} else if (ReportVal == 'Service' && !Ext.isEmpty(serviceCombo) && (serviceCombo.getValue() == 'Not Applicable' || serviceCombo.getValue() == '-1')) {
			Ext.MessageBox.show({
				title: 'Operation Reports',
				msg: serviceCombo.getStore().getAt(0).get('displayField'),
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
			});
			return;
		} else if (ReportVal == 'Segment' && !Ext.isEmpty(segmentCombo) && (segmentCombo.getValue() == 'Not Applicable' || segmentCombo.getValue() == '-1')) {
			Ext.MessageBox.show({
				title: 'Operation Reports',
				msg: segmentCombo.getStore().getAt(0).get('displayField'),
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
			});
			return;
		} else if (!Ext.isEmpty(compTypeCombo) && (compTypeCombo.getValue() == 'Not Applicable' || compTypeCombo.getValue() == '-1')) {
			Ext.MessageBox.show({
				title: 'Operation Reports',
				msg: tmpJson['chooseComponent'],
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
			});
			return;
		} else if (Ext.isEmpty(componentsCombo.getValue()) || componentsCombo.getValue() =='Not Applicable' ) {
			Ext.MessageBox.show({
				title: 'Operation Reports',
				msg: appConstants.chooseComponent,
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
			});
			return;
		}
		if(appConstants.callFromReport!=null && appConstants.callFromReport=='true'){
			this.updateParamsForCompare(getButtonObj);
		}else{
				if (this.validateSettings())
				{
					this.formSubmit(getButtonObj);
				}
		}
	},
	sendMail: function () {
		//var islegendEnabled = Ext.getCmp('showLegend').getValue();
		if(Ext.get('showLegend')!=null){
			 appConstants.drillDownParams = "&showLegend="+Ext.getCmp('showLegend').getValue();
		}
		Ext.widget('sendmail').show();
	},
	saveExcel: function()
	{
		window.location = '/final/servlet/com.eg.ErXlsController?er_excelRequest=yes';
	},
	hideTools: function () {
		this.getNewUtilities().loadIcon(
			true, //save
			true, //print
			true, //mail
			true, //data
			false, //cvs
			true, // fav
			true, // schedule
			false, //daignosis
			false, //togglebutton
			false, //close
			true//booklet
		);
		var favoriteToolObj = Ext.getCmp('favoriteTool');
		var scheduleToolObj = Ext.getCmp('scheduleTool');
		favoriteToolObj.setDisabled(false);
		scheduleToolObj.setDisabled(false);
	},
	showDuration: function () {
		var showDataObj = Ext.getCmp('showdata');
		var durationComboObj = Ext.getCmp('duration');
		var graphTypeObj = Ext.getCmp('gtype');
		durationComboObj.show();
		showDataObj.hide();
		graphTypeObj.hide();
	},
	showGraphData: function () {
		var showDataObj = Ext.getCmp('showdata');
		var durationComboObj = Ext.getCmp('duration');
		var graphTypeObj = Ext.getCmp('gtype');
		graphTypeObj.show();
		showDataObj.hide();
		durationComboObj.show();
	},
	showDetailedTrend: function () {
		var showDataObj = Ext.getCmp('showdata');
		var durationComboObj = Ext.getCmp('duration');
		var graphTypeObj = Ext.getCmp('gtype');
		showDataObj.show();
		durationComboObj.hide();
		graphTypeObj.hide();
	},
	print: function () {
		var printURL = appConstants.publicJSON['printURL'];
		var islegendEnabled=Ext.getCmp('showLegend').getValue();
		/*if (isSettingsEnabled)
		{
			islegendEnabled= Ext.getCmp('showLegend').getValue();
		}
		else
		{
			islegendEnabled=false;
		}	*/
		if(islegendEnabled!=null && islegendEnabled!=undefined){
			var setLegendVal = "&showLegend="+islegendEnabled;
			if(printURL.indexOf(setLegendVal)==-1){
				if(printURL.indexOf("&showLegend=")>-1){
					if(islegendEnabled =='true'){
						printURL = printURL.replace("&showLegend=false",setLegendVal);
					}else{
						printURL = printURL.replace("&showLegend=true",setLegendVal);
					}
				}else
					printURL+=setLegendVal;
			}
		}
		parent.printWindowFn(printURL); //this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
	},
	save: function () {
		var PDF_URL = appConstants.publicJSON['PDF_URL']

		var islegendEnabled= Ext.getCmp('showLegend').getValue();
	/*	if (isSettingsEnabled)
		{
			islegendEnabled= Ext.getCmp('showLegend').getValue();
		}
		else
		{
			islegendEnabled=false;
		}*/
		if(islegendEnabled!=null && islegendEnabled!=undefined){
			var setLegendVal = "&showLegend="+islegendEnabled;
			if(PDF_URL.indexOf(setLegendVal)==-1){

				if(PDF_URL.indexOf("&showLegend=")>-1){
					if(islegendEnabled || islegendEnabled =='true'){
						PDF_URL = PDF_URL.replace("&showLegend=false",setLegendVal);
					}else{
						PDF_URL = PDF_URL.replace("&showLegend=true",setLegendVal);
					}
				}else
					PDF_URL+=setLegendVal;
			}
		}
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}
		appConstants.erUtils.savePDF(PDF_URL);
	 },
	 bookletQuery: function(obj)
	{
		var PDF_URL = appConstants.publicJSON['PDF_URL']
		var islegendEnabled= Ext.getCmp('showLegend').getValue();
		if(islegendEnabled!=null && islegendEnabled!=undefined){
			var setLegendVal = "&showLegend="+islegendEnabled;
			if(PDF_URL.indexOf(setLegendVal)==-1){
				if(PDF_URL.indexOf("&showLegend=")>-1){
					if(islegendEnabled || islegendEnabled =='true'){
						PDF_URL = PDF_URL.replace("&showLegend=false",setLegendVal);
					}else{
						PDF_URL = PDF_URL.replace("&showLegend=true",setLegendVal);
					}
				}else
					PDF_URL+=setLegendVal;
			}
		}
		PDF_URL=PDF_URL.replace('/final/reporter/ErHtmlToSavePdf.jsp?','');
		return PDF_URL;
	},
	bookletScheduleQuery: function(obj)
	{
		var bookletquery=appConstants.queryString+'&showLegend='+Ext.getCmp('showLegend').getValue();
		return bookletquery;
	},
	bookletPreview:function()
	{
		this.print();
	},
	favorites: function (obj) {
				// by karthikeyan
	/*if (Ext.getCmp('er_timeline').getValue() == 'Any')
		{
				Ext.MessageBox.show({
						title : 'Operation Reports',
						msg : 'Chosen timeline not allowed',
						buttons : Ext.Msg.OK,
						icon: Ext.MessageBox.WARNING
					});
				return;
		}*/
	//
		this.formSubmit(obj);
		if (!Ext.isEmpty(appConstants.queryString)) {
			 var favorite_id = appConstants.publicJSON.hiddens["favorite_id"];
			 var target = '/final/servlet/com.eg.ErFavoriteC?' + appConstants.queryString + '&call=json&cmd=client'+"&er_RmDispName="+appConstants.er_RmDispName+"&com.eg.CSRF_NONCE="+csrfToken;
			 appConstants.formButtonId = obj.getId();
			 if (appConstants.formButtonId=='save')
			{
				//document.location=target+'&showWindow=no'+"&FavoriteId="+favorite_id+'&showLegend='+appConstants.isshowLegend;
				target+='&showWindow=no'+"&FavoriteId="+favorite_id+'&showLegend='+appConstants.isshowLegend;
				var urlNw=target.substr(0,target.indexOf("?"));
				var queryString=target.substr(target.indexOf("?")+1,target.length-1);
				var formSave = Ext.create('Ext.form.Panel');
				formSave.submit({
					url:urlNw,
					params:queryString,
					standardSubmit: true,
					method: 'POST'
				});
			}
			else{
				var targersource=target+'&showLegend='+Ext.getCmp('showLegend').getValue();
				parent.favouriteWindowFn(targersource);//this method is reffered in ResizePopup.js which is included in ErReportermenuDashBoard.jsp
			}
		}
	},
	callData: function () {
		Ext.widget('reporterdata', {
			scroll: false,
			autoScroll: false
		}).show();
		if (!Ext.isEmpty(appConstants.publicJSON['DATA_URL'])) {
			var er_option = Ext.getCmp('Report').getValue();
			var dataURL = appConstants.publicJSON['DATA_URL'];
			dataURL = dataURL.replace("option=" + er_option, "option=data");
			parent.dataWindowFn(dataURL);
		}
	},
	schedule: function (obj) {
			this.formSubmit(obj);
			var ReportVal = Ext.getCmp('Report').getValue();
			if (ReportVal=='Zone')
			{
				var er_group = Ext.getCmp("zone").getValue();
				appConstants.queryString+="&er_group="+er_group;
			}
			else if (ReportVal=='Segment')
			{
				var er_group = Ext.getCmp("segment").getValue();
				appConstants.queryString+="&er_group="+er_group;
			}
			else if (ReportVal=='Service')
			{
				var er_group = Ext.getCmp("service").getValue();
				appConstants.queryString+="&er_group="+er_group;
			}
			var target = '/final/reporter/ErSaveSchedule.jsp?' + appConstants.queryString+'&showLegend='+Ext.getCmp('showLegend').getValue()+"&com.eg.CSRF_NONCE="+csrfToken;
			if (!Ext.isEmpty(appConstants.queryString))
			{
				if (obj.getId() == "save")
				{
					this.formSubmit(obj)
					//document.location=target+'&showSchWindow=no';
					target+='&showSchWindow=no';
					var urlNw=target.substr(0,target.indexOf("?"));
					var queryString=target.substr(target.indexOf("?")+1,target.length-1);
					var formSave = Ext.create('Ext.form.Panel');
					formSave.submit({
						url:urlNw,
						params:queryString,
						standardSubmit: true,
						method: 'POST'
					});
				}
				else
					parent.scheduleWindowFn(target);
			}
	},
	toggleForm:function(obj)
	{
		Ext.getCmp('panelinsidetoggle').show();
		var ornt = Ext.getCmp('mainform');
		if (ornt.isHidden())
		{
			ornt.show();
			Ext.getCmp('selectionDetails').hide();
		}
		else
		{
			ornt.hide();
			Ext.getCmp('selectionDetails').show();
		}
	},
	updateQueryString: function () {
		var showdata,TimelineReportType,duration,gtype,showLegend;
		if(!isSettingsEnabled)
		{
			 var localjson=appConstants.publicJSON;
			 TimelineReportType=localjson.selectedreporttypecombo;
			 showdata=localjson.selectedShowData;
			 duration=localjson.selectedtrendgraphcombo;
			 //
			 if(duration==undefined)
			{
			duration=localjson.hiddens.er_period
			}

			//
			 gtype=localjson.graphtypeselected;
			 //showLegend=false;
			 reportGeneration=localjson.er_reportgenration_combo_selected;
		}
		else
		{
			 TimelineReportType=Ext.getCmp('TimelineReportType').getValue();
			 showdata=Ext.getCmp('showdata').getValue();
			 duration=Ext.getCmp('duration').getValue();
			 gtype=Ext.getCmp('gtype').getValue();
			//showLegend=Ext.getCmp('showLegend').getValue();
			 reportGeneration=Ext.getCmp('reportGeneration').getValue();
		}
	   var getReportForComboVal = Ext.getCmp('Report').getValue();
		var hiddenfieldQString = '';
		var isDetailed = true;

		if (TimelineReportType=='Summary' || TimelineReportType=='Trend' )
		{
			isDetailed=false;
		}
		else
		{ 
			isDetailed = (showdata == 'Detailed') ? true : false;
		}

		var er_trenddata = 'No';
		if (!isDetailed) 
		{
			er_trenddata = 'Yes';
		}
		else
		{
			er_trenddata = 'No';
		}
		var TimelineReportTypeVal = 'Measure';
		if (TimelineReportType != null) {
			TimelineReportTypeVal = TimelineReportType;
		}
		var er_duration = '';
		if (duration != undefined) {
			er_duration = duration;
		}
		var er_graph = '';
		if (gtype != undefined) {
			er_graph = gtype;
		}
		var siteName = '';
		if (appConstants.getReportOption == 'Site') {
			siteName = getReportForComboVal;
		}
		var graphmode = Ext.getCmp('er_mode').getValue();

		var graphType = TimelineReportType;
		var compType = Ext.getCmp('compType').getValue();
		var compArr = new Array();
		compArr = Ext.getCmp('components').getValue();
		var compQStr = '';
		for (var i = 0; i < compArr.length; i++) {
			compQStr += '&er_component=' + compArr[i];
		}
		var er_period = 'H';
		if (duration != undefined) {
			er_period = duration;
		}
		var inputparams = 'er_option=' + getReportForComboVal + '&er_mode=' + graphmode + '&showLegend='+Ext.getCmp('showLegend').getValue()+'&er_reportgenration=' + reportGeneration + '&er_component_div=&er_trenddata=' + er_trenddata + '&er_gtype=' + graphType + '&er_comptype=' + compType + '&screenWidth=1002&er_search=&er_duration=' + er_duration + '&er_graph=' + er_graph + compQStr;
		var timelineparams;
	  
		timelineparams = '&startdate=' + Ext.getCmp('er_stdate').dataArray + '&enddate=' + Ext.getCmp('er_enddate').dataArray + '&starthr=' + Ext.getCmp('er_sthr').dataArray + '&endhr=' + Ext.getCmp('er_endhr').dataArray + '&endmin=' + mgr_enmin + '&startmin=' + mgr_stmin;
		timelineparams+= '&er_timeline=' + Ext.getCmp('er_timeline').getValue();
		if(TimelineReportTypeVal != 'Measure'){
			inputparams+="&er_period="+er_period;
		}
		else{
			inputparams+="&er_period=";
		}
		inputparams+="&er_CompareAppMetric="+appConstants.er_CompareAppMetric;
		inputparams+="&er_RmSelections="+appConstants.er_RmSelections;
		if(appConstants.callFromReport!=null && appConstants.callFromReport!='undefined')
			inputparams+="&callFromReport="+appConstants.callFromReport;
		if (appConstants.getReportOption == 'Site') {
			var siteName = Ext.getCmp('Report').getValue();
		   inputparams += '&er_site=' + siteName;
		}
		if (appConstants.publicJSON.hasOwnProperty('hiddens')) {
			var hiddenFields = appConstants.publicJSON.hiddens;
			for (var hiddenField in hiddenFields) {
				hiddenfieldQString += "&" + hiddenField + "=" + hiddenFields[hiddenField];
			}
		}
		appConstants.queryString = inputparams + timelineparams + hiddenfieldQString;
	},
	/*hourChange:function( obj, newValue, oldValue, eOpts )
	{
		var TimelineReportType,showdata,duration,gtype;
		if(!Ext.isEmpty(newValue))
		{
			if(!isSettingsEnabled)
			{
				 var localjson=appConstants.publicJSON;
				 TimelineReportType=localjson.selectedreporttypecombo;
				 showdata=localjson.selectedShowData;
				 duration=localjson.selectedtrendgraphcombo;
				 gtype=localjson.graphtypecombo;
				 reportGeneration=localjson.er_reportgenration_combo_selected;
			}
			else
			{
				 TimelineReportType=Ext.getCmp('TimelineReportType').getValue();
				 showdata=Ext.getCmp('showdata').getValue();
				 duration=Ext.getCmp('duration').getValue();
				 gtype=Ext.getCmp('gtype').getValue();
				 reportGeneration=Ext.getCmp('reportGeneration').getValue();
			}
			if((TimelineReportType=="Summary" || TimelineReportType=="Trend" || showdata =="Trend") && Ext.getCmp("er_timeline").getValue()!='Any')
			{
				var startHrObj = Ext.getCmp('er_sthr');
				var endHrObj = Ext.getCmp('er_endhr');
				startHrObj.setValue("00");
				endHrObj.setValue("00");
				startHrObj.dataArray = "00";
				endHrObj.dataArray = "00";
			}
		}
	},*/
	updateParamsForCompare: function(obj) {
		var compArr = new Array();
		compArr = Ext.getCmp('components').getValue();
		var compQStr = '';
		for (var i = 0; i < compArr.length; i++) {
			compQStr += '&comp_selected=' + compArr[i];
		}
		var infoval;
		if (isSettingsEnabled)
		{
			infoval=Ext.getCmp('descriptors').getValue()
		}
		else
		{
			infoval=appConstants.publicJSON.selectedInfo;
		}
		if(infoval!=null && infoval!=undefined && infoval!='' && infoval != '-1' ){//infoVal != '-1'
			var tmp_content = appConstants.rm_content;
			if(tmp_content.indexOf("*~*")>-1){
				var testmeas=tmp_content.split("*~*");
				var mod_content="";
				for( var l in testmeas){
					mod_content += testmeas[l]+"$"+infoval+"*~*";
				}
				mod_content = mod_content.substring(0,mod_content.length-3);
				rm_content = mod_content.trim();
			}
		}
		var compareparam="method=get&callFromReport=true&reportFor=CompareGraph&isCompareReport=true&rmComponentType="+appConstants.rmComponentType+"&rmComponent="+appConstants.rmComponent+compQStr+"&er_RmSelections="+appConstants.rm_content+"&rm_content="+appConstants.rm_content;
		if(tmp_content!=null && tmp_content!='undefined')
			appConstants.rm_content =tmp_content;
		Ext.Ajax.request
				({
					url: '/final/reporter/TimeLineSave.jsp',
					params: compareparam,
					async: false,
					method: 'GET',
					scope: this,
					success: function(response)
					{
						appConstants.qStringForCompare="";
						var jsontext = response.responseText;
						var jsonData = Ext.decode(jsontext);
						if ((!Ext.isEmpty(jsonData)))
						{
					if (jsonData.hasOwnProperty('selectedFields'))
					{
						if (appConstants.qStringForCompare.indexOf('?')>-1)
						{
							appConstants.qStringForCompare += "&rmComponentType=" + jsonData.rmComponentType;
						}
						else
						{
							appConstants.qStringForCompare += "?rmComponentType=" + jsonData.rmComponentType;
						}
						if (appConstants.qStringForCompare.indexOf('?')>-1)
						{
							appConstants.qStringForCompare += "&rmComponent=" + jsonData.selectedFields.selectedComponentCombo;
						}
						else
						{
							appConstants.qStringForCompare += "?rmComponent=" + jsonData.selectedFields.selectedComponentCombo;
						}
					}
					if (jsonData.hasOwnProperty('mapFound'))
					{
						var mapFound = jsonData.mapFound;
						for (var key in mapFound) {
						if (appConstants.qStringForCompare.indexOf('?')>-1)
						{
							appConstants.qStringForCompare += "&" + key + "=" + mapFound[key];
						}
						else
						{
							appConstants.qStringForCompare += "?" + key + "=" + mapFound[key];
						}
						}
					}
					if (jsonData.hasOwnProperty('noMapFound'))
					{
						console.log(jsonData.noMapFound);
					}
					if (jsonData.hasOwnProperty('urlParamsForCompare'))
					{
						appConstants.qStringForCompare += jsonData.urlParamsForCompare;
						appConstants.urlParamsForCompare = appConstants.qStringForCompare;
						if (this.validateSettings())
						{
							this.formSubmit(obj);
						}
						//appConstants.urlParamsForCompare ="";
					}
				}
			},
				failure: function(err)
				{
					Ext.MessageBox.alert('Error occured in Controller operation main.js page');
				}
			});
	},
	formSubmit: function (obj) {
		this.getNomeasurepanel().hide();
		this.getBackGroundPanel().hide();
		var TimelineReportTypeVal,reportgenVal,bg_reportname;
		if (isSettingsEnabled)
		{
			TimelineReportTypeVal = Ext.getCmp('TimelineReportType').getValue();
			reportgenVal = Ext.getCmp('reportGeneration').getValue();
			bg_reportname = Ext.getCmp('bgReportName').getValue();
		}
		else
		{
			 var localjson=appConstants.publicJSON;
			 TimelineReportTypeVal=localjson.selectedreporttypecombo;
			 reportgenVal=localjson.er_reportgenration_combo_selected;
			 bg_reportname=localjson.bgReportName;
		}
		var myURL = '/final/reporter/ErReporterMenuJSON.jsp';
		var isSubmit = false;
		var isSummary = false;
		var isFav = false;
		var isSch = false;
		if (TimelineReportTypeVal == 'Summary') {
			isSummary = true;
		}
		//To Load Default Params
		this.updateQueryString();
		if((appConstants.callFromReport==null || appConstants.callFromReport =='null') && (appConstants.qStringForCompare==null || appConstants.qStringForCompare=="")){
			appConstants.urlParamsForCompare =appConstants.qStringForCompare;
		}
		//var siteName = Ext.getCmp('Report').getValue();
		//appConstants.queryString += '&er_site=' + siteName;
		if (obj != undefined) {
			if (obj.getId() == 'favoriteTool' || obj.getId() == 'favImg') {
				isFav = true;
			} else if (obj.getId() == 'scheduleImg' || obj.getId() == 'scheduleTool') {
				isSch = true;
			}
			isSubmit = (obj.getId() == 'submit') ? true : false;
			if (isSubmit || (obj.getId() == 'favoriteTool' || obj.getId() == 'favImg' || obj.getId() == 'scheduleImg' || obj.getId() == 'scheduleTool')) {
				var getReportForComboVal = Ext.getCmp('Report').getValue();
				var er_group = '';
				if (getReportForComboVal != 'Component') {
					if (getReportForComboVal == 'Zone') {
						er_group = Ext.getCmp('zone').getValue();
					} else if (getReportForComboVal == 'Segment') {
						er_group = Ext.getCmp('segment').getValue();
					} else if (getReportForComboVal == 'Service') {
						er_group = Ext.getCmp('service').getValue();
					}
				}
				appConstants.queryString += '&er_group=' + er_group + '&isSubmit=true';
				if (appConstants.isForceSubmit=='true' || (appConstants.rm_treeMeasure!='null' && appConstants.rm_treeMeasure!=null))
				{
					 appConstants.queryString+= '&isForceSubmit=true&er_RmDispName='+appConstants.er_RmDispName;
					if(appConstants.urlParamsForCompare!=null && appConstants.urlParamsForCompare!=undefined && appConstants.urlParamsForCompare!=''){
						if(appConstants.urlParamsForCompare.indexOf('?')==0)
							appConstants.urlParamsForCompare ="&"+appConstants.urlParamsForCompare.substring(1);
						appConstants.queryString+=appConstants.urlParamsForCompare+"&er_optionselect=Component&er_graphtype=Single&reportFor=compareGraph";
					}
				}
				if (reportgenVal == 'background') {
					bg_reportname=checkFileName(bg_reportname);
					appConstants.queryString += '&bg_reportname=' + bg_reportname;
					myURL = '/final/servlet/com.eg.ErStartBackGroundReportC';
				} else {
					if (obj.getId() != 'scheduleImg' && obj.getId() != 'scheduleTool') {
						appConstants.queryString += '&call=json';
					}
					myURL = '/final/servlet/com.eg.ErRepoLiteC';
				}
			}
		}
		if (isFav || isSch) {
			return;
		}
		var fusionChartURLs = new Array();
		var myMask = new Ext.LoadMask(Ext.getBody(), {
			msg: 'Loading...'
		});
		if (isSubmit) {
			if(isSettingsEnabled)
			Ext.get('configMod').animate({duration: 500,to: {y: -500}});
			myMask.show();
		}
		//by karthikeyan
		appConstants.queryString+= '&er_RmDispName='+appConstants.er_RmDispName;
	//
		Ext.Ajax.request({
			url: myURL,
			params: appConstants.queryString,
			scope: this,
			success: function (response) {
				if (isSubmit) {
					myMask.hide();
				}
				try {
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);
					if (obj.getId() != 'TimelineReportType' && obj.getId() != 'showdata')
					{
						appConstants.publicJSON=jsonData;
					}
					else if (obj.getId() == 'TimelineReportType'|| obj.getId() == 'showdata')
					{
						this.myJson=jsonData;
					}
					reportgenVal=jsonData.er_reportgenration_combo_selected;
					var getReportForComboVal = Ext.getCmp('Report').getValue();
					var compTypeCombo = Ext.getCmp('compType');
					var componentsObj = Ext.getCmp('components');
					var compTypeComboRawData = jsonData['comptypecombo'];
					if (!isSubmit) {
						var graphPanelObj = Ext.getCmp('graphPanel');
						graphPanelObj.hide();
						this.enableOrDisableUtilities(true);
						if (obj == undefined || (obj.getId() != 'TimelineReportType' && obj.getId() != 'er_timeline' && obj.getId() != 'showdata')) 
						{
							var NotApplicable = jsonData['NotApplicable'];
							if (getReportForComboVal == 'Zone') {
								var zoneCombo = Ext.getCmp('zone');
								var zoneComboRawData = jsonData['Zone'];
								if (!Ext.isEmpty(zoneComboRawData)) {
									zoneCombo.getStore().clearFilter(true);
									zoneCombo.getStore().loadRawData(zoneComboRawData);
									zoneCombo.setValue(zoneComboRawData[0].valueField);
								}
							} else if (getReportForComboVal == 'Segment') {
								var segmentCombo = Ext.getCmp('segment');
								var segmentComboRawData = jsonData['Segment'];
								if (!Ext.isEmpty(segmentComboRawData)) {
									segmentCombo.getStore().clearFilter(true);
									segmentCombo.getStore().loadRawData(segmentComboRawData);
									segmentCombo.setValue(segmentComboRawData[0].valueField);
								}
							} else if (getReportForComboVal == 'Service') {
								var serviceCombo = Ext.getCmp('service');
								var serviceComboRawData = jsonData['Service'];
								if (!Ext.isEmpty(serviceComboRawData)) {
									serviceCombo.getStore().clearFilter(true);
									serviceCombo.getStore().loadRawData(serviceComboRawData);
									serviceCombo.setValue(serviceComboRawData[0].valueField);
								}
							} else if (appConstants.getReportOption == 'Site') {
								if (obj != undefined && obj.getId() == 'Report') {
									var compTypeComboObj = Ext.getCmp('compType');
									var compTypeRawData = jsonData['comptypecombo'];
									compTypeComboObj.getStore().clearFilter(true);
									compTypeComboObj.getStore().loadRawData(compTypeRawData);
									if (!Ext.isEmpty(compTypeRawData)) {
										compTypeComboObj.setValue(compTypeRawData[0].valueField);
									}
									var componentsComboObj = Ext.getCmp('components');
									var getNotApplicableLabel = jsonData['notApplicable'];
									this.insertNotApplicable(getNotApplicableLabel, componentsComboObj);
								}
							}
						}
						/**************Timeline Settings Changes STARTS******************/
							if(isSettingsEnabled)
							{
								var TimelineReportTypeVal = Ext.getCmp('TimelineReportType').getValue();
								var timelineComboRawData = jsonData['timelineCombo'];
								var timelineComboObj = Ext.getCmp('er_timeline');
								//timelineComboObj.getStore().loadRawData(timelineComboRawData);
								//timelineComboObj.getStore().loadRawData(this.myJson['timelineCombo']);
								this.changeTimeline( Ext.getCmp('duration'));
								if (!Ext.isEmpty(TimelineReportTypeVal))
								{
									if (TimelineReportTypeVal == 'Measure') {
										var showdataObj = Ext.getCmp('showdata');
										var showDatas = jsonData['showDatas'];
										var selectedShowData = jsonData['selectedShowData'];
										showdataObj.setValue(selectedShowData)
										showdataObj.getStore().loadRawData(showDatas);
										this.showDetailedTrend();
									} else if (TimelineReportTypeVal == 'Summary' || TimelineReportTypeVal == 'Trend') {
										var durationRawData = jsonData['duration'];
										var durationComboObj = Ext.getCmp('duration');
										if (!Ext.isEmpty(durationRawData)) {
											durationComboObj.getStore().loadRawData(durationRawData);
											if (obj != undefined && obj.getId() != 'duration' && obj.getId() != 'er_timeline') {
												//durationComboObj.setValue(durationRawData[0].valueField);
											}
										}
										this.showDuration();
										if (TimelineReportTypeVal == 'Trend') {
											this.showGraphData();
											var graphTypeObj = Ext.getCmp('gtype');
											var graphtypecomboRawData = jsonData['graphtypecombo'];
											var graphtypeselected = jsonData['graphtypeselected'];
											if (!Ext.isEmpty(graphtypecomboRawData)) {
												graphTypeObj.getStore().loadRawData(graphtypecomboRawData);
												if (!Ext.isEmpty(graphtypeselected)) {
													graphTypeObj.setValue(graphtypeselected);
												} else {
													graphTypeObj.setValue(graphtypecomboRawData[0].valueField);
												}
											}
										}
									}
								}
							}
							var er_timeline = Ext.getCmp('er_timeline').getValue();
							var startHrObj = Ext.getCmp('er_sthr');
							var endHrObj = Ext.getCmp('er_endhr');
							var endDateObj = Ext.getCmp('er_enddate');
							var startDateObj = Ext.getCmp('er_stdate');
							if (!Ext.isEmpty(er_timeline)) {
								var startDateData = jsonData['startDateForDisplay'];
								var endDateData = jsonData['endDateForDisplay'];
								startDateObj.setValue(startDateData);
								endDateObj.setValue(endDateData);
								var startHrData = jsonData['startHourForDisplay'];
								var endHrData = jsonData['endHourForDisplay'];
							
								startHrObj.setValue(startHrData);
								endHrObj.setValue(endHrData);
								startDateData.dataArray=jsonData.startDate;
								endDateObj.dataArray=jsonData.endDate;
								startHrObj.dataArray = jsonData.starthr;
								endHrObj.dataArray = jsonData.endhr;
							}
							if (er_timeline != 'Any') {
								var timeLineComboObj = Ext.getCmp('er_timeline');
								//var tmpStore = timeLineComboObj.getStore();
								//var durationVal = Ext.getCmp('duration').getValue();
								if (obj != undefined && obj.getId() == 'duration') {
									var durationVal = Ext.getCmp('duration').getValue();
									if (durationVal == 'H') {
										timeLineComboObj.setValue('1 day');
									} else if (durationVal == 'D') {
										timeLineComboObj.setValue('1 week');
									} else if (durationVal == 'M') {
										timeLineComboObj.setValue('3 months');
									}
								}
							}
					 } else {
						 if (reportgenVal == 'foreground')
						{
							var saveObj = Ext.getCmp('saveTool');
							var bookletObj = Ext.getCmp('bookletTool');
							var printObj = Ext.getCmp('printTool');
							var mailObj = Ext.getCmp('mailTool');
							var csvObj = Ext.getCmp('csvTool');
							var excelObj = Ext.getCmp('excelTool');	 //..prakash//
							excelObj.setDisabled(true)
							if(componentsObj.getValue().length == 1)
							{
								excelObj.setDisabled(false)
							} //
							
							var graphPanelObj = Ext.getCmp('graphPanel');
							graphPanelObj.removeAll();
							graphPanelObj.show();
							var mainItems = new Array();
							var compDatas = jsonData['compdatas'];
							var chartType = jsonData['chartType'];
							var imageHeight = parseInt(jsonData['imageHeight']);
							var imageWidth = parseInt(jsonData['imageWidth']);
							if (!Ext.isEmpty(compDatas)) 
							{
								var compCount = jsonData['compcount'];
								var compNamesData = jsonData['compNames'];
								var isCombined = jsonData['isCombined'];
								var reportLayout = 'column';
								var chartPanelHeight = imageHeight + 52;
								if (!isCombined) 
								{
									reportLayout = 'vbox';
									chartPanelHeight = imageHeight + 100;
								}
								var idx = 0;
								var xmlDatas = new Array();
								for (var i = 0; i < compCount; i++) 
								{
									var compName = compNamesData[i]['compName'];
									var compHasOneTestData = jsonData[compName + 'HasOneTest'];
									if (!Ext.isEmpty(compHasOneTestData) && compHasOneTestData == 'Yes') {
										reportLayout = 'vbox';
										chartPanelHeight = 450;
									} else {
										if (!isCombined) {
											reportLayout = 'vbox';
										} else {
											reportLayout = 'column';
										}
										chartPanelHeight = imageHeight + 52;
									}
									var compURLs = compDatas[i];
									var k = 0;
									var titles = new Array();
									var csvURLs = new Array();
									var dataURLs = new Array();
									var imgURLs = new Array();
									var drillDownURLs = new Array();
									var doms = new Array();

									for (var key in compURLs) {
										if (key.indexOf('datatitle') > -1) {
											titles.push(compURLs['datatitle_' + k]);
										} else if (key.indexOf('measureortrenddataurl') > -1) {
											imgURLs.push(compURLs['measureortrenddataurl_' + k]);
										} else if (key.indexOf('summarydataurl') > -1) {
											imgURLs.push(compURLs['summarydataurl_' + k]);
										} else if (key.indexOf('csvdataurl') > -1) {
											csvURLs.push(compURLs['csvdataurl_' + k]);
										} else if (key.indexOf('dataurl') > -1) {
											dataURLs.push(compURLs['dataurl_' + k]);
										} else if (key.indexOf('drilldown') > -1) {
											drillDownURLs.push(compURLs['drilldown_url_' + k]);
										}
										k++;
									} 
									if (imgURLs.length>0)
									{
										var height=225;
										if (imgURLs.length==1)
										{
											height=350;
										}
										var content='<div id="submitreport'+i+'_table" style="width:100%"><table width="100%" border="0" class="htmlGraphTable"><col width="50%"><col width="50%"><tr>';//<col width="50%"><col width="50%">
										var col=0;
										for (var key in imgURLs)
										{
											var evenLastTd=false;
											if (col==2)
											{
												col=0;
												content+='</tr>';
												content+='<tr>';
											}
											if(key == 0){
												if (imgURLs.length>2)
												{
													content+='<td style="padding:0px 5px 10px 10px">';
												}
												else if(imgURLs.length==2)
												{
													content+='<td style="padding:0px 5px 10px 10px">';
												}
												else
												{
													content+='<td style="padding:0px 5px 10px 10px">';
												}
											}
											else if(key == 1){
												if (imgURLs.length>2)
												{
													content+='<td style="padding:0px 5px 10px 5px">';
												}
												else
												{
													content+='<td style="padding:0px 5px 10px 5px">';
												}
											}
											else if((key%2) == 0){
												if (key==imgURLs.length-1)
												{
													evenLastTd=true;
													content+='<td style="padding:0px 5px 10px 10px">';
												}
												else if (key==imgURLs.length-2)
												{
													content+='<td style="padding:0px 5px 10px 10px">';
												}
												else{
													content+='<td style="padding:0px 5px 10px 10px">';
												}
											}
											else if((key%2) != 0){
												if (key==imgURLs.length-1)
												{
													content+='<td style="padding:0px 10px 10px 5px">';
												}
												else{
													content+='<td style="padding:0px 10px 10px 5px">';
												}
											}
											content+='<div width="100%" class="graphMainDiv">';
											content+='<div class="htmlGraphTableHeader"><div style="float:left;width:75%" class="infoText" data-qtip="'+titles[key]+'">';
											content+=titles[key];
											content+='</div>';
											content+='<div style="float:right;margin:3px 0px 6px 5px;">';
											content+='<div style="float:right;cursor:pointer;margin:0 0 0 5px" class="iconMaximize" onclick="javascript:loadUrlInDrillDown(\''+drillDownURLs[key]+'\');"></div>';
											content+='<div style="float:right;cursor:pointer;margin:0 5px 0 5px" class="iconCsv" onclick="window.location=\''+csvURLs[key]+'\'"></div>';
											content+='<div style="float:right;cursor:pointer;margin:0 5px 0 5px" class="iconData" onclick="javascript:loadDataWindow(\''+dataURLs[key]+'\');"></div>';
											content+='</div></div>';
											content+='<div class="headerBottomBorder" ></div>';

											var dom='img_'+i+'_'+key;
											doms.push(dom);

											//content+='<div id="'+dom+'" style="height:'+height+'px;width:100%;" class="htmlTableBody">';
											content+='<div id="'+dom+'" style="height:'+height+'px;width:100%;" class="htmlGraphTableBody showDiv" >';
											
											if (!isSummary)
											{
												if(chartType != "highchart")
												{
													content+='<table width=100% height=100%><tr><td align=center valign=middle><img src="'+imgURLs[key]+'"></img></td></tr></table>';
												}
											}
											content+='</div>';
											content+='<div style="height:65px;margin-right: 10px;" id="commonLeg_'+dom+'" class="showDiv commonLeg">';
											content+='<div id="'+dom+'_legend" style="height:53px;width:100%;overflow:hidden;vertical-align: middle;" class="showDiv">';
											content+='</div></div>';

											content+='</div></td>';
											if (evenLastTd)
											{
												content+='<td style="padding:5px 10px 10px 5px;">&nbsp;</td>';
											}
											col++;
										}
										if (col==2)
										{
											content+='</tr>';
										}
										content+='</table></div>';
										graphPanelObj.add({
											xtype: 'panel',
											id: 'submitreport' + i,
											title: compName,
											cls:'newChk',
											ui:'multiGraphPanel',
											margin:10,
										//	cls: 'datapanel gridWithoutShadow',
//											header:
//											{
//												cls:'networkheader',
//												height:24,
//												style:
//												{
//													'padding':'0px 0px 0px 5px !important'
//												},
//											}, 
											minimum:1,
											mazimum:5,
											tools: [{
												xtype: 'label',
												text: jsonData['timeformat'],
												cls:'xAxisLabelFontForReporter',
												margin: '2 10 1 0'
											}],
											html:content,
											// Fix for graph resize
											listeners:{
												
												resize:function(panel, width, height){
													$('.graphMainDiv').each(function(el){
														if(imgURLs.length>1){
																$(this).width((width-32)/2);
															}
													});
												},
												boxready:function(){
													var islegendEnabled = Ext.getCmp('showLegend').getValue();
													if(islegendEnabled == "false" || islegendEnabled==false){
														var elms = document.getElementsByClassName("commonLeg");
														for(var i = 0; i < elms.length; i++) {
															var chkkk=elms[i].id;
															var tmp_div=document.getElementById(chkkk);
															if(tmp_div != null && tmp_div != undefined)
																tmp_div.className=tmp_div.className.replace('showDiv', 'hideDiv');
														}
													}
												}
											}
											
										});
										
										if (isSummary)
										{
											for( var key in imgURLs)
											{ 
												var data = this.loadCharts(imgURLs[key]);
												if (!Ext.isEmpty(data))
												{
													if(appConstants.chartType=='fusionchart')
													{
														if (FusionCharts('ct' + key ))
															FusionCharts('ct' + key).dispose();
														var myChart = new FusionCharts('/final/FusionCharts/swf/StackedColumn' + graphMode + '.swf', 'ct' + key, "100%", "100%", "0", "1");
														myChart.setXMLData(data);
														myChart.setTransparent(true);
														myChart.render(doms[key]);
													}
													else
													{
														var width = Ext.getCmp('submitreport' + i).getWidth();
														var divWidth = ((width-40));
														var height = Ext.getCmp('submitreport' + i).getHeight();
														var divHeight = ((height-150));
														if(imgURLs.length==1)
														{
															var lineChart = {};
															lineChart = jQuery.extend(true, {}, getHighChartsBarInstance(doms[key],divHeight,divWidth), lineChart);
															lineChart.setData(data,'<%=currentDateFormat%>','');
															lineChart.drawChart();
														}
														else
														{
															var lineChart = {};
															lineChart = jQuery.extend(true, {}, getHighChartsBarInstance(doms[key],data.chartHeight,data.chartWidth), lineChart);
															lineChart.setData(data,'<%=currentDateFormat%>','');
															lineChart.drawChart();
														}

													}
												}
												else
												{
													Ext.get(doms[key]).update('<table width="100%" height="100%"><tr><td align="center" valign="middle"><img src="/final/images/'+strSkin+'/nomeasures_custom.png" /></td></tr></table>');
												}
											}
										}
										else
										{
											if(chartType == "highchart"){
												for( var key in imgURLs){
														reportHighStockChart(imgURLs[key]+"&chartType="+chartType,doms[key],'','','');
												}
											}
										}
									}
								}
								Ext.getCmp('selectionDetails').setSelectionDetailsData(jsonData.selectionDetails);
								saveObj.setDisabled(false);
								bookletObj.setDisabled(false);
								printObj.setDisabled(false);
								mailObj.setDisabled(false);
								csvObj.setDisabled(false); 
							}
							else
							{
								this.getNomeasurepanel().show();
								saveObj.setDisabled(true);
								bookletObj.setDisabled(true);
								printObj.setDisabled(true);
								mailObj.setDisabled(true);
								csvObj.setDisabled(true);
							}

						 } else {
							var processingreports = jsonData['processingreports'];
							var backgroundresponsetext = jsonData['backgroundresponsetext'];
							var backgroundreporturl = jsonData['backgroundreporturl'];
							var backgroundReportStatus = jsonData['backgroundReportStatus'];
							var statusCssClass = '';
							if(backgroundReportStatus!=null && backgroundReportStatus=='success')
							{
								statusCssClass='iconInformation';
							}
							else if(backgroundReportStatus=='duplicate')
							{
								statusCssClass='iconExclamation';
							}

							var html = '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="'+statusCssClass+'"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+backgroundresponsetext+'.</br>'+'<a class="backgroundMsgLink" href='+ backgroundreporturl +'>'+ processingreports + '</a></div></td></tr></table></td></tr></table>';

						//	var html = '<center><div class="block1" style="font-size:13px;padding:8px;margin-top:50px;text-align:left;display:block;width:480px;height:90" class="panelwithoutheader"><div style="margin:10px;display:block;width:38px;height:34px;float:left;" class="iconSuccess"></div><div style="margin:10px 0px"><b>' + backgroundresponsetext + '</b><br /><a class="backgroundMsgLink" href="' + backgroundreporturl + '" >' + processingreports + '</a></div></div></center>';

								var resultObj = this.getBackGroundPanel();
								resultObj.removeAll();
								resultObj.add({
									xtype: 'panel',
									margin:0,
									bodyPadding:0,
									height: '100%',
									width: '100%',
									html: '<div>'+html+'</div>',
									flex:1,
								});
								resultObj.doLayout();
								resultObj.show();
						 }
					}
					this.loadHiddenFields(appConstants.publicJSON['hiddens']);
					if (!Ext.isEmpty(jsonData['DATA_URL']) && jsonData['compcount'] == 1) {
						var dataObj = Ext.getCmp('dataTool');
						dataObj.setDisabled(false);
					} else {
						var dataObj = Ext.getCmp('dataTool');
						dataObj.setDisabled(true);
					}
					if (obj != undefined && obj.getId() == 'er_timeline') {
						var reportgenObj = Ext.getCmp('reportGeneration')
						var reportgenVal = reportgenObj.getValue();
						if (reportgenVal == 'foreground') {
							var limitforbg = Ext.getCmp('limitforbg').getValue();
							if (!Ext.isEmpty(limitforbg)) {
								var getMaxDaysInMonth = Ext.getCmp('getMaxDaysInMonth').getValue();
								var startdate = Ext.getCmp('er_stdate').getValue();
								var enddate = Ext.getCmp('er_enddate').getValue();
								startdate.setHours(Ext.getCmp('er_sthr').getValue());
								enddate.setHours(Ext.getCmp('er_endhr').getValue());
								if (!checkTimeLineForBgLimit(limitforbg, getMaxDaysInMonth, startdate, enddate)) {
									var reportNameObj = Ext.getCmp('bgReportName');
									reportgenObj.setValue("background");
									reportNameObj.show();
								}
							}
						}
					}
				} catch (e) {}
				if (isSubmit) {
					myMask.hide();
				}
			}
		});
	},
	loadSubmitData: function (jsonData) {
		this.getNomeasurepanel().hide();
		this.getBackGroundPanel().hide();
		var isSummary = false;
		 var TimelineReportTypeVal,reportgenVal;
		 if (isSettingsEnabled)
		 {
			 TimelineReportTypeVal=Ext.getCmp('TimelineReportType').getValue();
			 reportgenVal = Ext.getCmp('reportGeneration').getValue();
		 }
		 else
		 {
			TimelineReportTypeVal=appConstants.publicJSON.selectedreporttypecombo;
			reportgenVal=appConstants.publicJSON.er_reportgenration_combo_selected;
		 }
		if (TimelineReportTypeVal == 'Summary') {
			isSummary = true;
		}
		var fusionChartURLs = new Array();
		 if (reportgenVal == 'foreground') {
			var graphPanelObj = Ext.getCmp('graphPanel');
			graphPanelObj.show();
			var getComponentsObj = Ext.getCmp('components');
			var mainItems = new Array();
			var compDatas = jsonData['compdatas'];
			var chartType = jsonData['chartType'];
			var highChartUrls = new Array();
			var highChartIds = new Array();
			var highChartdrilldwonUrls = new Array();
			var imageHeight = parseInt(jsonData['imageHeight']);
			var imageWidth = parseInt(jsonData['imageWidth']);
			if (!Ext.isEmpty(compDatas)) 
			{
				var selComps = new Array();
				selComps = Ext.getCmp('components').getValue();
				var compCount = jsonData['compcount'];
				var submitArr = new Array();
				var compNamesData = jsonData['compNames'];
				var isCombined = jsonData['isCombined'];
				var reportLayout = 'column';
				var chartPanelHeight = imageHeight + 52;
				if (!isCombined) {
					reportLayout = 'vbox';
					chartPanelHeight = imageHeight + 100;
				}
			Ext.getCmp('saveTool').setDisabled(false);
			Ext.getCmp('bookletTool').setDisabled(false);
			Ext.getCmp('printTool').setDisabled(false);
			Ext.getCmp('mailTool').setDisabled(false);
			Ext.getCmp('dataTool').setDisabled(true);
				var idx = 0;
				var xmlDatas = new Array();
				 for (var i = 0; i < compCount; i++) {
					var compName = compNamesData[i]['compName'];
					var compHasOneTestData = jsonData[compName + 'HasOneTest'];
					if (!Ext.isEmpty(compHasOneTestData) && compHasOneTestData == 'Yes') {
						reportLayout = 'vbox';
						chartPanelHeight = 450;
					} else {
						if (!isCombined) {
							reportLayout = 'vbox';
						} else {
							reportLayout = 'column';
						}
						chartPanelHeight = imageHeight + 52;
					}
					var compURLs = compDatas[i];
					var k = 0;
					var titles = new Array();
					var csvURLs = new Array();
					var dataURLs = new Array();
					var imgURLs = new Array();
					var drillDownURLs = new Array();
					var doms = new Array();

					for (var key in compURLs) {
						if (key.indexOf('datatitle') > -1) {
							titles.push(compURLs['datatitle_' + k]);
						} else if (key.indexOf('measureortrenddataurl') > -1) {
							imgURLs.push(compURLs['measureortrenddataurl_' + k]);
						} else if (key.indexOf('summarydataurl') > -1) {
							imgURLs.push(compURLs['summarydataurl_' + k]);
						} else if (key.indexOf('csvdataurl') > -1) {
							csvURLs.push(compURLs['csvdataurl_' + k]);
						} else if (key.indexOf('dataurl') > -1) {
							dataURLs.push(compURLs['dataurl_' + k]);
						} else if (key.indexOf('drilldown') > -1) {
							drillDownURLs.push(compURLs['drilldown_url_' + k]);
						}
						k++;
					}
					if (imgURLs.length>0)
					{
						var content='<div id="submitreport'+i+'_table" style="width:100%"><table width="100%" border="0" class="htmlGraphTable"><col width="50%"><col width="50%"><tr>';//<col width="50%"><col width="50%">
						var col=0;
						var height=225;
						if (imgURLs.length==1)
						{
							height=450;
						}
						for (var key in imgURLs)
						{
							var evenLastTd=false;
							if (col==2)
							{
								col=0;
								content+='</tr>';
								content+='<tr>';
							}
							if(key == 0){
								if (imgURLs.length>2)
								{
									content+='<td style="padding:0px 5px 10px 10px">';
								}
								else if(imgURLs.length==2)
								{
									content+='<td style="padding:0px 5px 10px 10px">';
								}
								else
								{
									content+='<td style="padding:0px 5px 10px 10px">';
								}
							}
							else if(key == 1){
								if (imgURLs.length>2)
								{
									content+='<td style="padding:0px 5px 10px 5px">';
								}
								else
								{
									content+='<td style="padding:0px 5px 10px 5px">';
								}
							}
							else if((key%2) == 0){
								if (key==imgURLs.length-1)
								{
									evenLastTd=true;
									content+='<td style="padding:0px 5px 10px 10px">';
								}
								else if (key==imgURLs.length-2)
								{
									content+='<td style="padding:0px 5px 10px 10px">';
								}
								else{
									content+='<td style="padding:0px 5px 10px 10px">';
								}
							}
							else if((key%2) != 0){
								if (key==imgURLs.length-1)
								{
									content+='<td style="padding:0px 5px 10px 5px">';
								}
								else{
									content+='<td style="padding:0px 5px 10px 5px">';
								}
							}
							content+='<div width="100%" class="graphMainDiv">';

							content+='<div class="htmlGraphTableHeader"><div style="float:left;width:75%" class="infoText" data-qtip="'+titles[key]+'">';
							content+=titles[key];
							content+='</div>';
							content+='<div style="float:right;margin:3px 0px 6px 5px;">';
							content+='<div style="float:right;cursor:pointer;margin:0 0 0 5px" class="iconMaximize" onclick="javascript:loadUrlInDrillDown(\''+drillDownURLs[key]+'\');"></div>';
							content+='<div style="float:right;cursor:pointer;margin:0 5px 0 5px" class="iconCsv" onclick="window.location=\''+csvURLs[key]+'\'"></div>';
							content+='<div style="float:right;cursor:pointer;margin:0 5px 0 5px" class="iconData" onclick="javascript:loadDataWindow(\''+dataURLs[key]+'\');"></div>';
							content+='</div></div>';
							content+='<div class="headerBottomBorder"></div>';

							var dom='img_'+i+'_'+key;
							doms.push(dom);

							content+='<div id="'+dom+'" style="height:'+height+'px;width:100%; display: inline-block; vertical-align: middle;" class="htmlGraphTableBody showDiv">';
							if (!isSummary)
							{
								if(chartType != "highchart")
								{
									content+='<table width=100% height=100%><tr><td valign=middle align=center><img src="'+imgURLs[key]+'"></img></td></tr></table>';									
								}
							}
							content+='</div>';
							content+='<div style="height:65px;margin-right: 10px;" id="commonLeg_'+dom+'" class="showDiv commonLeg '+dom+'">';
							content+='<div id="'+dom+'_legend" style="height:53px;width:100%;overflow:hidden;display: inline-block; vertical-align: middle;" class="showDiv">';
							content+='</div></div>';

							content+='</div></td>';
							if (evenLastTd)
							{
								content+='<td style="padding:5px 10px 10px 5px;">&nbsp;</td>';
							}
							col++;
						}
						if (col==2)
						{
							content+='</tr>';
						}
						content+='</table></div>';
						graphPanelObj.add({
							xtype: 'panel',
							id: 'submitreport' + i,
							title: compName,
							margin:10,
							cls:'newChk',
							//cls: 'datapanel gridWithoutShadow',
							ui:'multiGraphPanel',
//							header:
//							{
//								cls:'networkheader',
//								height:24,
//								style:
//								{
//									'padding':'0px 0px 0px 5px !important'
//								},
//							}, 
							tools: [{
								xtype: 'label',
								text: jsonData['timeformat'],
								cls:'xAxisLabelFontForReporter',
								margin: '0 10 0 0'
							}],
							html:content,
							listeners:{
							// Fix for graph resize
							resize:function(panel, width, height)
							{
								if(imgURLs.length == 1)
								{
									$('.graphMainDiv').each(function(el){
									//$(this).width((width-40)/2);
									});
								}
								else
								{
									$('.graphMainDiv').each(function(el){
									$(this).width((width-32)/2);
									});
								}
							},
							boxready:function(){
								var islegendEnabled = Ext.getCmp('showLegend').getValue();
								if(islegendEnabled == "false" || islegendEnabled ==false){
									var elms = document.getElementsByClassName("commonLeg");
									for(var i = 0; i < elms.length; i++) {
										var chkkk=elms[i].id;
										var tmp_div=document.getElementById(chkkk);
										if(tmp_div != null && tmp_div != undefined)
											tmp_div.className=tmp_div.className.replace('showDiv', 'hideDiv');
									}
								}
							}	
							}
						});
						if (isSummary)
						{
							for( var key in imgURLs)
							{ 
								var data = this.loadCharts(imgURLs[key]);
								if (!Ext.isEmpty(data))
								{
									if(appConstants.chartType=='fusionchart')
									{
										if (FusionCharts('ct' + key ))
											FusionCharts('ct' + key).dispose();
										var myChart = new FusionCharts('/final/FusionCharts/swf/StackedColumn' + graphMode + '.swf', 'ct' + key, "100%", "100%", "0", "1");
										myChart.setXMLData(data);
										myChart.setTransparent(true);
										myChart.render(doms[key]);
									}
									else
									{
										var panelWidth = Ext.getCmp('submitreport' + i).getWidth();
										var width = (panelWidth-40);
										var panelHeight = Ext.getCmp('submitreport' + i).getHeight();
										var height = (panelHeight-150);
										if(imgURLs.length==1)
										{
											var lineChart = {};
											lineChart = jQuery.extend(true, {}, getHighChartsBarInstance(doms[key],height,width), lineChart);
											lineChart.setData(data,'<%=currentDateFormat%>','');
											lineChart.drawChart();
										}
										else
										{
											var lineChart = {};
											lineChart = jQuery.extend(true, {}, getHighChartsBarInstance(doms[key],data.chartHeight,data.chartWidth), lineChart);
											lineChart.setData(data,'<%=currentDateFormat%>','');
											lineChart.drawChart();
										}
									}
								}
								else
								{
									Ext.get(doms[key]).update('<table width="100%" height="100%"><tr><td align="center" valign="middle"><img src="/final/images/'+strSkin+'/nomeasures_custom.png" /></td></tr></table>');
								}
							}
						}
						else
						{
							if(chartType == "highchart"){
								for( var key in imgURLs){
									reportHighStockChart(imgURLs[key]+"&chartType="+chartType,doms[key],'','','');
								}
							}
						}
					}
				}
			}
			else
			{
				this.getNomeasurepanel().show();
			}
			Ext.getCmp('selectionDetails').setSelectionDetailsData(jsonData.selectionDetails);
		} 
		else {
			var processingreports = jsonData['processingreports'];
			var backgroundresponsetext = jsonData['backgroundresponsetext'];
			var backgroundreporturl = jsonData['backgroundreporturl'];
			var backgroundReportStatus = jsonData['backgroundReportStatus'];
			var graphPanelObj = Ext.getCmp('graphPanel');
			if (backgroundReportStatus != 'undefined') {
				if (backgroundReportStatus == 'success') {
					graphPanelObj.add({
						xtype: 'panel',
						html: '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconInformation"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+backgroundresponsetext+'.</br>'+'<a class="backgroundMsgLink" href='+ backgroundreporturl +'>'+ processingreports + '</a></div></td></tr></table></td></tr></table>'
					});
					graphPanelObj.show()
				} else if (backgroundReportStatus == 'duplicate') {
					graphPanelObj.add({
						xtype: 'panel',
						html: '<table border="0px" width="100%" height="100%"><tr><td align="center" valign="middle"><table style="width:480px;"border="0px"><tr><td><div style="margin:0px 10px 0px 0px;display:block;width:32px;height:32px;float:right;" class="iconExclamation"></div></td><td><div style="line-height:1.5em" class="font_bold11">'+backgroundresponsetext+'.</br>'+'<a class="backgroundMsgLink" href='+ backgroundreporturl +'>'+ processingreports + '</a></div></td></tr></table></td></tr></table>'
					});
					graphPanelObj.show();
				}
			} else {}
		}
		if (!Ext.isEmpty(appConstants.publicJSON['DATA_URL']) && jsonData['compcount'] == 1) {
			var dataObj = Ext.getCmp('dataTool');
			dataObj.setDisabled(false);
		} else {
			var dataObj = Ext.getCmp('dataTool');
			dataObj.setDisabled(true);
		}       
	},
	loadCharts: function (URL) {
		try {
			var xmldata;
			Ext.Ajax.request({
				url: URL,
				method: 'GET',
				async: false,
				success: function (response) {
					var tmpJsonText = response.responseText;
					if (!Ext.isEmpty(tmpJsonText) && response.status == 200) {
						var tmpJsonData = Ext.decode(tmpJsonText);
						if(appConstants.chartType=='fusionchart')
						{
							xmldata = tmpJsonData['xmldata'];
						}
						else
						{
							xmldata = tmpJsonData;//['xmldata'];
						}
					}
				},
				failure: function () {
					alert('I am not loading...' + URL);
				}
			});
			return xmldata;
		} catch (e) {
			alert('[Exception] ' + e);
		}
	},   
	setMyJSON: function (jsonData) {
		this.myJson = jsonData;
	},
	loadMainElements: function () {
		var localjson=appConstants.publicJSON;
		appConstants.monthTimelineCombo=localjson.monthTimelineCombo;
		appConstants.timelineCombo=localjson.timelineCombo;
		appConstants.timelineHourCombo=localjson.timelineHourCombo; 
		var reportForLabel = localjson.screenLabels['reporter.comparison.Reportfor'];
		var compTypeLabel = localjson.screenLabels['reporter.common.ComponentType'];
			var hiddenFields = localjson["hiddens"];
			var from_schedule = hiddenFields["fromScheduleModify"];
			var from_favourite = hiddenFields["fromFavoriteModify"];
		if ((from_schedule != null && from_schedule == "Yes")||(from_favourite != null && from_favourite == "Yes")) {
			Ext.getCmp("submit").hide();
			Ext.getCmp("save").show();
			Ext.getCmp("favoriteTool").setDisabled(true);
			Ext.getCmp("scheduleTool").setDisabled(true);
		}else{
			Ext.getCmp("submit").show();
			Ext.getCmp("save").hide();
		}
		///////////
		var showdata,TimelineReportType,duration,gtype;
		if(!isSettingsEnabled)
		{
			 var localjson=appConstants.publicJSON;
			 TimelineReportType=localjson.selectedreporttypecombo;
			 showdata=localjson.selectedShowData;
		}
		else
		{
			 TimelineReportType=Ext.getCmp('TimelineReportType').getValue();
			 showdata=Ext.getCmp('showdata').getValue();
		}
		
		if(showdata=='Trend' || TimelineReportType=='Trend' || TimelineReportType=='Summary' )
		{
			isTrend=true;
		}
		else
		{
			isTrend=false;
		}
		var reportCombo = Ext.getCmp('Report');
		var reportComboRawData = localjson['reportforcombo'];
			console.log('reportComboRawData  ___________ ',reportComboRawData);
		reportCombo.setFieldLabel(reportForLabel);
		reportCombo.getStore().loadRawData(reportComboRawData);
		var compTypeCombo = Ext.getCmp('compType');
		var compTypeComboRawData = localjson['comptypecombo'];

		compTypeCombo.setFieldLabel(compTypeLabel);
		compTypeCombo.getStore().clearFilter(true);
		compTypeCombo.getStore().loadRawData(compTypeComboRawData);
		compTypeCombo.show();
		var servicesCombo = Ext.getCmp('service');
		if (!Ext.isEmpty(localjson['selectedReportForCombo'])) {
			reportCombo.setValue(localjson['selectedReportForCombo']);
			var reportTypeVal = localjson['selectedReportForCombo'];
			var zoneObj = Ext.getCmp('zone');
			var subzoneObj = Ext.getCmp('subzone');
			var segmentObj = Ext.getCmp('segment');
			var serviceObj = Ext.getCmp('service');
			if (reportTypeVal == 'Zone') {
				var getZoneData = localjson['Zone'];
				zoneObj.getStore().loadRawData(getZoneData);
				zoneObj.show();
				zoneObj.setValue(localjson['selectedZone']);
				subzoneObj.setValue(localjson['selectedsubzone']);
				subzoneObj.show();
				segmentObj.hide();
				serviceObj.hide();
			} else if (reportTypeVal == 'Segment') {
				var getSegmentData = localjson['Segment'];
				segmentObj.getStore().loadRawData(getSegmentData);
				segmentObj.setValue(localjson['selectedSegment']);
				zoneObj.hide();
				subzoneObj.hide();
				segmentObj.show();
				serviceObj.hide();
			} else if (reportTypeVal == 'Service') {
				var getServiceData = localjson['Service'];
				serviceObj.getStore().loadRawData(getServiceData);
				serviceObj.setValue(localjson['selectedService']);
				zoneObj.hide();
				subzoneObj.hide();
				segmentObj.hide();
				serviceObj.show();
			} else {
				zoneObj.hide();
				subzoneObj.hide();
				segmentObj.hide();
				serviceObj.hide();
			}
			//			me.selectReportTypeCombos();
		} else {
			reportCombo.setValue(appConstants.notApplicableTxt);
		}

		if (!Ext.isEmpty(localjson['selectedcomptype'])) {
			compTypeCombo.setValue(localjson['selectedcomptype']);
		} else {
			compTypeCombo.setValue(compTypeComboRawData[0].valueField);
		}
	/*if (!Ext.isEmpty(appConstants.isForceSubmit) && appConstants.isForceSubmit!='null') {
		//compTypeCombo.hide();
		if(appConstants.isCompareReport =='true') {
			Ext.getCmp('descriptorpanel').show();
			Ext.getCmp('descsplitter').show();
			var infoComboObj = Ext.getCmp('descriptors');
			var infoComboRawData = localjson['infoCombo'];

			if (!Ext.isEmpty(infoComboRawData)) {
				infoComboObj.getStore().loadRawData(infoComboRawData);
				rawDataForDescription=infoComboRawData;
			}else {
				infoComboObj.getStore().removeAll();
				infoComboObj.getStore().add({
					'displayField': 'Not Applicable',
					'valueField': '-1'
				});
			}
			var selected_info = localjson['selectedInfo'];
			if(!Ext.isEmpty(selected_info)){
				infoComboObj.setValue(selected_info);
			} else {
				if (infoComboRawData!=null && infoComboRawData!='undefined'
					&& infoComboRawData.length >= 1 && infoComboRawData[0].valueField != 'Not Applicable') {
					infoComboObj.setValue(infoComboObj.getRawValue().split(","));
				}
			}
			var p = this.getMainform().getForm();//.findField('Report');
			var lft = this.getMultiSelectPanel();//.findField('Report');
			p.owner.flex = 0;
			lft.flex = 0;
			infoComboObj.show();
			 lft.doLayout();
			 this.getMainform().doLayout();
		}
	}else {
		Ext.getCmp('compType').show();
	}*/
		/************ To load default Components STARTS ****************/
		var componentsComboObj = Ext.getCmp('components');
		if (appConstants.getReportOption == 'Application' || appConstants.getReportOption == 'Site') {
			var compsforappandsiteRawData = localjson['compsforappandsite'];
			componentsRawData = compsforappandsiteRawData;
			componentsComboObj.getStore().loadRawData(compsforappandsiteRawData);
			if (compsforappandsiteRawData.length >= 1 && compsforappandsiteRawData[0].valueField != 'Not Applicable') {
				componentsComboObj.setValue(compsforappandsiteRawData[0].valueField);
			}
		} else {
			var compsfornotappandsiteRawData = localjson['compsfornotappandsite'];
			componentsRawData = compsfornotappandsiteRawData;
			if (compsfornotappandsiteRawData.length >= 1 && compsfornotappandsiteRawData[0].valueField != 'Not Applicable') {
				componentsComboObj.setValue(compsfornotappandsiteRawData[0].valueField);
			}
		}
		var defaultselectedforcomparrfornotappandsiteinselect = localjson['defaultselectedforcomparrfornotappandsiteinselect'];
		componentsComboObj.getStore().loadRawData(componentsRawData);
		if (componentsComboObj.getStore().getCount() > 0) {
			var selectedComp = localjson['selectedComp'];
			if (Ext.isEmpty(selectedComp)) {
				selectedComp = componentsComboObj.getStore().getAt(0).get('valueField');
			}
			componentsComboObj.setValue(selectedComp);
		} else {
			componentsComboObj.getStore().add({
				'displayField': appConstants.notApplicableTxt,
				'valueField': '-1'
			});
		}
		var timelineComboLabel = localjson.screenLabels['reporter.common.Timeline'];
		var timelineComboObj = Ext.getCmp('er_timeline');
		var timelineComboRawData = localjson['timelineCombo'];
		if (!Ext.isEmpty(timelineComboRawData)) {
			timelineComboObj.getStore().loadRawData(timelineComboRawData);
			if (!Ext.isEmpty(localjson['selectedTimeline'])) {
				timelineComboObj.setValue(localjson['selectedTimeline']);
			} else {
				timelineComboObj.setValue('1 day');
			}
			//timelineComboObj.setValue(timelineComboRawData[9].valueField);
		}
		var timelineFromComboLabel = localjson.screenLabels['reporter.common.From'];
		var timelineToComboLabel = localjson.screenLabels['reporter.common.To'];
		var start_hour = localjson.selectedStartHour;
		var end_hour = localjson.selectedEndHour;
		var start_date = localjson.startDate;
		var end_date = localjson.endDate;
		var startDateObj = Ext.getCmp('er_stdate');
		startDateObj.setValue(localjson.startDateForDisplay);
		startDateObj.dataArray = start_date;
		var startHrObj = Ext.getCmp('er_sthr');
		startHrObj.setValue(localjson.startHourForDisplay);
		startHrObj.dataArray = start_hour;
		var endDateObj = Ext.getCmp('er_enddate');
		endDateObj.setValue(localjson.endDateForDisplay);
		endDateObj.dataArray = end_date;
		var endHrObj = Ext.getCmp('er_endhr');
		endHrObj.setValue(localjson.endHourForDisplay);
		endHrObj.dataArray = end_hour;
		stmin = localjson.startMinForDisplay;
		enmin = localjson.endMinForDisplay;
		mgr_stmin = localjson.startmin;
		mgr_enmin = localjson.endmin
		var graphModeObj = Ext.getCmp('er_mode');
		var graphModeLabel = localjson.screenLabels['reporter.common.Graph'];
		var selectedMode = localjson['selectedmode'];
		graphModeObj.setFieldLabel(graphModeLabel);
		graphModeObj.setValue(selectedMode);
		/************To load default Components ENDS****************/
		if(!appConstants.hideBackButton){
		Ext.getCmp('operation_network').add(
			{
				xtype: 'hidden',
				id: 'ID',
				name: 'ID',
				value: localjson['ID']
			}
		);
		}
		//this.formSubmit(Ext.getCmp('submit'));
	},
	loadSettingsElements: function () {
		
		var favorite_id = appConstants.publicJSON['hiddens']["favorite_id"];
		if(!Ext.isEmpty(favorite_id)){
			Ext.getCmp('reportGeneration').setDisabled(true);
		}
		
		/****************** To Load Timeline Settings STARTS ****************/
		var localjson=appConstants.publicJSON;
		var me = this;
		if (!Ext.isEmpty(appConstants.isForceSubmit) && appConstants.isForceSubmit!='null') {
		//compTypeCombo.hide();
		if(appConstants.isCompareReport =='true') {
			Ext.getCmp('descriptorpanel').show();
			Ext.getCmp('descsplitter').show();
			var infoComboObj = Ext.getCmp('descriptors');
			var infoComboRawData = localjson['infoCombo'];
			if (!Ext.isEmpty(infoComboRawData)) {
				infoComboObj.getStore().loadRawData(infoComboRawData);
				rawDataForDescription=infoComboRawData;
			}else {
				infoComboObj.getStore().removeAll();
				infoComboObj.getStore().add({
					'displayField': 'Not Applicable',
					'valueField': '-1'
				});
			}
			var selected_info = localjson['selectedInfo'];
			if(!Ext.isEmpty(selected_info)){
				infoComboObj.setValue(selected_info);
			} else {
				if (infoComboRawData!=null && infoComboRawData!='undefined'
					&& infoComboRawData.length >= 1 && infoComboRawData[0].valueField != 'Not Applicable') {
					infoComboObj.setValue(infoComboObj.getRawValue().split(","));
				}
			}
		}
	}else {
		Ext.getCmp('compType').show();
	}
		if (appConstants.getReportOption == 'Site') {
			Ext.getCmp('Report').setWidth(230);
		}
		var timelineReportTypeComboObj = Ext.getCmp('TimelineReportType');
		var timelineReportTypeLabel = localjson.screenLabels['reporter.common.Report Type'];
		var timelineReportTypeRawData = localjson['reporttypecombo'];
		timelineReportTypeComboObj.setFieldLabel(timelineReportTypeLabel);
		if (!Ext.isEmpty(timelineReportTypeRawData)) {
			timelineReportTypeComboObj.getStore().loadRawData(timelineReportTypeRawData);
			var selectedTimelineReportTypeComboVal = localjson['selectedreporttypecombo'];
			if (!Ext.isEmpty(selectedTimelineReportTypeComboVal)) {
				timelineReportTypeComboObj.setValue(selectedTimelineReportTypeComboVal);
			} else {
				timelineReportTypeComboObj.setValue(timelineReportTypeRawData[0].valueField);
			}
		}
		if(appConstants.isCompareReport =='true' || timelineReportTypeComboObj.getRawValue()=='Comparison') {
			timelineReportTypeComboObj.setDisabled(true);
		}
		var durationComboObj = Ext.getCmp('duration');
		var durationComboLabel = localjson.screenLabels['reporter.common.Duration'];
		durationComboObj.setFieldLabel(durationComboLabel);
		var durationComboRawData = localjson['duration'];
		if (!Ext.isEmpty(durationComboRawData)) {
			durationComboObj.getStore().loadRawData(durationComboRawData);
	//			            er_period = Ext.getCmp('duration').getValue();
			var selectedtrendgraphcomboVal = localjson['selectedtrendgraphcombo'];
			if(selectedtrendgraphcomboVal!=null && selectedtrendgraphcomboVal!='undefined')
				durationComboObj.setValue(selectedtrendgraphcomboVal);
			else
			{
				var period=localjson.hiddens.er_period;

				if(period!=undefined)
					durationComboObj.setValue(period);
				else
				    durationComboObj.setValue(durationComboRawData[0].valueField);
			}
		}
		var detailedRadioObj = Ext.getCmp('detailedRadio');
		var trendRadioObj = Ext.getCmp('trendRadio');
		var timelineShowDataDetailedLabel = localjson.screenLabels['reporter.common.Detailed'];
		var timelineShowDataTrendLabel = localjson.screenLabels['reporter.common.Trend'];
		var selectedgtype = localjson['graphtype'];
		if (selectedgtype == 'Trend') {
			this.showGraphData();
			if (!Ext.isEmpty(localjson['selectedtrendgraphcombo'])) {
				Ext.getCmp('duration').setValue(localjson['selectedtrendgraphcombo']);
			} else {

			        var period=localjson.hiddens.er_period;

				if(period!=undefined)
				Ext.getCmp('duration').setValue(period);
				else
				Ext.getCmp('duration').setValue(Ext.getCmp('duration').getStore().getAt(0).get('valueField'));
			}
			var graphtypecomboData = localjson['graphtypecombo'];
			var gtypeObj = Ext.getCmp('gtype');
			gtypeObj.getStore().loadRawData(graphtypecomboData);
			var graphtypeselected = localjson['graphtypeselected'];
			if (!Ext.isEmpty(graphtypeselected)) {
				gtypeObj.setValue(graphtypeselected);
			}
		} else if (selectedgtype == 'Summary') {
			this.showDuration()
		} else if (selectedgtype == 'Measure') {
			var selectedShowData = localjson['selectedShowData'];
			var showdataObj = Ext.getCmp('showdata');
			var showDatasVal = localjson['showDatas'];
			showdataObj.getStore().loadRawData(showDatasVal);
			showdataObj.setValue(selectedShowData);
			this.showDetailedTrend();
			var trendenablee = localjson['hiddens'].trendenable;
			if(trendenablee == 'false')
			{
				Ext.getCmp('showdata').hide();
			}
			else
			{
				Ext.getCmp('showdata').show();
			}
		}
		Ext.getCmp('moreOptionCloseId').show();
		var reportGenerationComboObj = Ext.getCmp('reportGeneration');
		var reportGenerationComboLabel = localjson.screenLabels['reporter.consolidated.Report Generation'];
		reportGenerationComboObj.setFieldLabel(reportGenerationComboLabel);
		var reportGenerationRawData = localjson['er_reportgenration_combo'];
		if (!Ext.isEmpty(reportGenerationRawData)) {
			reportGenerationComboObj.getStore().loadRawData(reportGenerationRawData);
			var selectedReportGeneration = localjson['er_reportgenration_combo_selected'];
			if (!Ext.isEmpty(selectedReportGeneration)) {
				reportGenerationComboObj.setValue(selectedReportGeneration);
			} else {
				reportGenerationComboObj.setValue(reportGenerationRawData[0].valueField);
			}
		}
		
		/****************** To Load Timeline Settings ENDS ****************/
	},
	selectReportTypeCombos: function (obj) {
		var getNotApplicationData = this.myJson['notApplicable'];
		var reportForObj = Ext.getCmp('Report');
		var getComboVal = Ext.getCmp('Report').getValue();
		var compTypeCombo = Ext.getCmp('compType');
		var componentsObj = Ext.getCmp('components');
		var zoneCombo = Ext.getCmp('zone');
		var subzoneCombo = Ext.getCmp('subzone');
		var segmentCombo = Ext.getCmp('segment');
		var serviceCombo = Ext.getCmp('service');
		if (getComboVal == 'Component') {
			zoneCombo.hide();
			subzoneCombo.hide();
			segmentCombo.hide();
			serviceCombo.hide();
			if(compTypeCombo.isHidden())
			compTypeCombo.show();
		} else if (getComboVal == 'Zone') {
			zoneCombo.show();
			subzoneCombo.show();
			segmentCombo.hide();
			serviceCombo.hide();
			if(compTypeCombo.isHidden())
			compTypeCombo.show();
		} else if (getComboVal == 'Segment') {
			zoneCombo.hide();
			subzoneCombo.hide();
			segmentCombo.show();
			serviceCombo.hide();
			if(compTypeCombo.isHidden())
			compTypeCombo.show();
		} else if (getComboVal == 'Service') {
			zoneCombo.hide();
			subzoneCombo.hide();
			segmentCombo.hide();
			serviceCombo.show();
			if(compTypeCombo.isHidden())
			compTypeCombo.show();
		}
		if (appConstants.getReportOption != 'Site') {
			this.insertNotApplicable(getNotApplicationData, compTypeCombo);
			this.insertNotApplicable(getNotApplicationData, componentsObj);
			this.selectComponents(reportForObj);
			if (reportForObj.getValue() != 'Component') {
				this.formSubmit(reportForObj);
			}
		} else {
			if (getComboVal == '-1') {
				this.insertNotApplicable(getNotApplicationData, compTypeCombo);
				this.insertNotApplicable(getNotApplicationData, componentsObj);
				return;
			} else {
				if (!Ext.isEmpty(obj)) {
					this.formSubmit(reportForObj);
				}
			}
		}
	},
	includeOrExcludeSubzone: function () {
		var getZoneVal = Ext.getCmp('zone').getValue();
		if (getZoneVal != '-1') {
			var getNotApplicationData = this.myJson['notApplicable'];
			var getCompObj = Ext.getCmp('components');
			this.insertNotApplicable(getNotApplicationData, getCompObj);
			this.selectZoneComponents();
		}
	},
	selectCompComponents: function () {
		var getCompTypeObj = Ext.getCmp('compType');
		this.selectComponents(getCompTypeObj);
	},
	selectZoneComponents: function (combo) {
		var getZoneComboObj = Ext.getCmp('zone');
		if (getZoneComboObj.getValue() != '-1') {
			this.selectComponents(getZoneComboObj);
		} else {
			var getNotApplicationData = this.myJson['notApplicable'];
			var getCompTypeObj = Ext.getCmp('compType');
			var getCompObj = Ext.getCmp('components');
			this.insertNotApplicable(getNotApplicationData, getCompTypeObj);
			this.insertNotApplicable(getNotApplicationData, getCompObj);
		}
	},
	selectServiceComponents: function () {
		var getServiceComboObj = Ext.getCmp('service');
		if (getServiceComboObj.getValue() != '-1') {
			this.selectComponents(getServiceComboObj);
		} else {
			var getNotApplicationData = this.myJson['notApplicable'];
			var getCompTypeObj = Ext.getCmp('compType');
			var getCompObj = Ext.getCmp('components');
			this.insertNotApplicable(getNotApplicationData, getCompTypeObj);
			this.insertNotApplicable(getNotApplicationData, getCompObj);
		}
	},
	selectSegmentComponents: function () {
		var getSegmentComboObj = Ext.getCmp('segment');
		if (getSegmentComboObj.getValue() != '-1') {
			this.selectComponents(getSegmentComboObj);
		} else {
			var getNotApplicationData = this.myJson['notApplicable'];
			var getCompTypeObj = Ext.getCmp('compType');
			var getCompObj = Ext.getCmp('components');
			this.insertNotApplicable(getNotApplicationData, getCompTypeObj);
			this.insertNotApplicable(getNotApplicationData, getCompObj);
		}
	},
	selectComponents: function (combo) {
		var comboId = combo.getId();
		var genParams = '';
		var graphType;
		if(!isSettingsEnabled)
		{
			 var localjson=appConstants.publicJSON;
			 graphType=localjson.selectedreporttypecombo;
		}
		else
		{
			 graphType=Ext.getCmp('TimelineReportType').getValue();
		}
		var ReportForVal = Ext.getCmp('Report').getValue();
		var er_option = Ext.getCmp('Report').getValue();
		var myURL = '';
		if (appConstants.getReportOption != 'Site') {
			if (comboId == 'compType') {
				if (ReportForVal == 'Zone') {
					var isIncludedSubZone = Ext.getCmp('subzone').getValue();
					var zoneName = Ext.getCmp('zone').getValue();
					zoneName = (Ext.isEmpty(zoneName)) ? '-1' : zoneName;
					var compTypeVal = Ext.getCmp(comboId).getValue();
					genParams = 'er_rtype=' + appConstants.getReportOption + '&reporttype=' + appConstants.getReportType + '&userID=' + appConstants.getUserID + '&er_option=' + er_option + '&er_group=' + zoneName + '&er_subzone=' + isIncludedSubZone + '&er_comptype=' + compTypeVal + '&gtype=' + graphType + '&call=json';
				} else if (ReportForVal == 'Service') {
					var serviceName = Ext.getCmp('service').getValue();
					serviceName = (Ext.isEmpty(serviceName)) ? '-1' : serviceName;
					var compTypeVal = Ext.getCmp(comboId).getValue();
					genParams = 'er_rtype=' + appConstants.getReportOption + '&reporttype=' + appConstants.getReportType + '&userID=' + appConstants.getUserID + '&er_option=' + er_option + '&er_group=' + serviceName + '&er_comptype=' + compTypeVal + '&gtype=' + graphType + '&call=json';
				} else if (ReportForVal == 'Segment') {
					var segmentName = Ext.getCmp('segment').getValue();
					segmentName = (Ext.isEmpty(segmentName)) ? '-1' : segmentName;
					var compTypeVal = Ext.getCmp(comboId).getValue();
					genParams = 'er_rtype=' + appConstants.getReportOption + '&reporttype=' + appConstants.getReportType + '&userID=' + appConstants.getUserID + '&er_option=' + er_option + '&er_group=' + segmentName + '&er_comptype=' + compTypeVal + '&gtype=' + graphType + '&call=json';
				} else {
					var er_comptype = Ext.getCmp('compType').getValue();
					er_comptype = (Ext.isEmpty(er_comptype)) ? '-1' : er_comptype;
					genParams = 'er_rtype=' + appConstants.getReportOption + '&reporttype=' + appConstants.getReportType + '&userID=' + appConstants.getUserID + '&er_option=' + er_option + '&er_group=' + er_option + '&er_comptype=' + er_comptype + '&gtype=' + graphType + '&call=json';
				}
			} else if (comboId == 'zone') {
				var componentsObj = Ext.getCmp('components');
				var notApplicable = this.myJson['notApplicable'];
				var isIncludedSubZone = Ext.getCmp('subzone').getValue();
				var zoneName = Ext.getCmp('zone').getValue();
				genParams = 'er_rtype=' + appConstants.getReportOption + '&reporttype=' + appConstants.getReportType + '&userID=' + appConstants.getUserID + '&er_option=' + er_option + '&er_subzone=' + isIncludedSubZone + '&er_group=' + zoneName + '&gtype=' + graphType + '&call=json';
			} else if (comboId == 'service') {
				var serviceName = Ext.getCmp('service').getValue();
				genParams = 'er_rtype=' + appConstants.getReportOption + '&reporttype=' + appConstants.getReportType + '&userID=' + appConstants.getUserID + '&er_option=' + er_option + '&er_group=' + serviceName + '&gtype=' + graphType + '&call=json';
			} else if (comboId == 'segment') {
				var segmentName = Ext.getCmp('segment').getValue();
				genParams = 'er_rtype=' + appConstants.getReportOption + '&reporttype=' + appConstants.getReportType + '&userID=' + appConstants.getUserID + '&er_option=' + er_option + '&er_group=' + segmentName + '&gtype=' + graphType + '&call=json';
			} else if (comboId == 'Report' && ReportForVal != 'Component') {
				var compTypeObj = Ext.getCmp('compType');
				var compObj = Ext.getCmp('components');
				var notApplicable = this.myJson['notApplicable'];
				this.insertNotApplicable(notApplicable, compTypeObj);
				this.insertNotApplicable(notApplicable, compObj);
			} else {
				if (ReportForVal == 'Component') {
					genParams = 'er_rtype=' + appConstants.getReportOption + '&reporttype=' + appConstants.getReportType + '&userID=' + appConstants.getUserID + '&er_option=' + er_option + '&er_group=' + ReportForVal + '&gtype=' + graphType + '&call=json';
				} else {
					return;
				}
			}
		} else {
			if (comboId == 'compType') {
				var compTypeVal = Ext.getCmp('compType').getValue();
				var siteName = Ext.getCmp('Report').getValue();
				genParams = 'er_rtype=Site&reporttype=' + appConstants.getReportType + '&userID=' + appConstants.getUserID + '&er_site=' + siteName + '&er_comptype=' + compTypeVal + '&gtype=' + graphType + '&call=json';
			}
		}
		if (!Ext.isEmpty(genParams)) {
			Ext.Ajax.request({
				url: '/final/servlet/com.eg.ErAjaxResponseServlet',
				method: 'post',
				params: genParams,
				scope: this,
				success: function (response) {
					var jsonText = response.responseText;
					var jsonData = '';
					if (!Ext.isEmpty(jsonText) && response.status == 200) {
						jsonData = Ext.decode(jsonText);
						var getComponentRawData = '';
						if (appConstants.getReportOption != 'Site') {
							var componentsObj = Ext.getCmp('components');
							var notApplicable = this.myJson['notApplicable'];
							if (comboId == 'compType') {
								if (ReportForVal == 'Zone') {
									getComponentRawData = jsonData['Zone']
									var componentsMultiSelectObj = Ext.getCmp('components');
									componentsMultiSelectObj.getStore().loadRawData(getComponentRawData);
								} else if (ReportForVal == 'Service') {
									getComponentRawData = jsonData['Service']
									var componentsMultiSelectObj = Ext.getCmp('components');
									componentsMultiSelectObj.getStore().loadRawData(getComponentRawData);
								} else if (ReportForVal == 'Segment') {
									getComponentRawData = jsonData['Segment']
									var componentsMultiSelectObj = Ext.getCmp('components');
									componentsMultiSelectObj.getStore().loadRawData(getComponentRawData);
								} else {
									var getComponentSelectObj = Ext.getCmp('components');
									getComponentRawData = jsonData['Component'];
									getComponentSelectObj.getStore().loadRawData(getComponentRawData);
								}
								var compsObj = Ext.getCmp('components');
								if (!Ext.isEmpty(compsObj.getStore()) && !Ext.isEmpty(compsObj)) {
									var getNAIndex = compsObj.getStore().findExact('valueField', 'Not Applicable', 0);
									if (getNAIndex == -1) {
										var getModel = compsObj.getStore().getAt(0);
										var getFirstValueField = getModel.get('valueField');
										compsObj.setValue(getFirstValueField);
									}
								}
							} else if (comboId == 'zone') {
								getComponentRawData = jsonData['Zone'];
								var ComponentTypeObj = Ext.getCmp('compType');
								ComponentTypeObj.getStore().removeAll();
								var getScreenLabel = jsonData.screenLabel['Zone'];
								ComponentTypeObj.getStore().loadRawData(getComponentRawData);
								this.insertTypeAndAll(getScreenLabel, ComponentTypeObj);
								ComponentTypeObj.setValue('-1');
								this.insertNotApplicable(notApplicable, componentsObj);
							} else if (comboId == 'service') {
								getComponentRawData = jsonData['Service'];
								var ComponentTypeObj = Ext.getCmp('compType');
								ComponentTypeObj.getStore().removeAll();
								var getScreenLabel = jsonData.screenLabel['Service'];
								ComponentTypeObj.getStore().loadRawData(getComponentRawData);
								this.insertTypeAndAll(getScreenLabel, ComponentTypeObj);
								ComponentTypeObj.setValue('-1');
								this.insertNotApplicable(notApplicable, componentsObj);
							} else if (comboId == 'segment') {
								getComponentRawData = jsonData['Segment'];
								var ComponentTypeObj = Ext.getCmp('compType');
								ComponentTypeObj.getStore().removeAll();
								var getScreenLabel = jsonData.screenLabel['Segment'];
								ComponentTypeObj.getStore().loadRawData(getComponentRawData);
								this.insertTypeAndAll(getScreenLabel, ComponentTypeObj);
								ComponentTypeObj.setValue('-1');
								this.insertNotApplicable(notApplicable, componentsObj);
							} else {
								getComponentRawData = jsonData['Component'];
								var ComponentTypeObj = Ext.getCmp('compType');
								ComponentTypeObj.getStore().removeAll();
								var getScreenLabel = jsonData.screenLabel['Component'];
								ComponentTypeObj.getStore().loadRawData(getComponentRawData);
								this.insertTypeAndAll(getScreenLabel, ComponentTypeObj);
								if (!Ext.isEmpty(getComponentRawData)) {
									ComponentTypeObj.setValue(getComponentRawData[0].valueField);
								}
								this.selectCompComponents();
							}
						} else {
							if (comboId == 'compType') {
								var componentsObj = Ext.getCmp('components');
								getComponentRawData = jsonData['Site'];
								componentsObj.getStore().loadRawData(getComponentRawData);
							}
						}
						componentsRawData = getComponentRawData;
					} else {
						alert('No Reponse...' + genParams);
					}
				},
				failure: function () {
					alert('I am not loading...' + genParams);
				}
			});
		}
		var graphPanelObj = Ext.getCmp('graphPanel');
		graphPanelObj.hide();
		this.enableOrDisableUtilities(true);
	},
	insertTypeAndAll: function (screenLabel, loadObj) {
		var tmpStore = loadObj.getStore();
		tmpStore.insert(0, {
			'displayField': screenLabel,
			'valueField': '-1'
		});
		if (tmpStore.getCount() > 2) {
			tmpStore.insert(tmpStore.getCount(), {
				'displayField': allValue,
				'valueField': 'All'
			});
		}
	},
	insertNotApplicable: function (val, loadObj) {
		var tmpStore = loadObj.getStore();
		tmpStore.removeAll();
		tmpStore.insert(0, {
			'displayField': val,
			'valueField': val
		});
		if (loadObj.getId() != 'components') {
			loadObj.setValue(val);
		}
	},
	enableOrDisableUtilities: function (flag) {
		var saveObj = Ext.getCmp('saveTool');
		var bookletObj = Ext.getCmp('bookletTool');
		var printObj = Ext.getCmp('printTool');
		var mailObj = Ext.getCmp('mailTool');
		var csvObj = Ext.getCmp('csvTool');
		var dataObj = Ext.getCmp('dataTool');
		var diagnosisObj = Ext.getCmp('diagnosisTool');
		if (!Ext.isEmpty(saveObj)) {
			saveObj.setDisabled(flag);
		}
		if (!Ext.isEmpty(bookletObj)) {
			bookletObj.setDisabled(flag);
		}
		if (!Ext.isEmpty(printObj)) {
			printObj.setDisabled(flag);
		}
		if (!Ext.isEmpty(mailObj)) {
			mailObj.setDisabled(flag);
		}
		if (!Ext.isEmpty(csvObj)) {
			csvObj.setDisabled(flag);
		}
		if (!Ext.isEmpty(diagnosisObj)) {
			diagnosisObj.setDisabled(flag);
		}
		if (!Ext.isEmpty(dataObj)) {
			dataObj.setDisabled(true);
		}
	}
	});