// controller for popup panel 
Ext.define('OperationNetwork.controller.ShowGraphDetails',{
	extend:'Ext.app.Controller',
	views:['Main','UserTimeline','UserTimelineTools','DetailTimeLine','Print','ReporterData'],
	refs:[
		{selector:'main', ref:'main'},
		{selector:'usertimeline',ref:'usertimeline'},
		{selector:'usertimelinetools', ref:'usertimelinetools'},
		{selector:'detailtimeline',ref:'detailtimeline'},
		{selector:'reporterdata',ref:'reporterdata'},
		{selector:'print',ref:'print'},
		{selector:'sendmail', ref:'sendmail'}
	],
	init:function(){
		this.control({
				'usertimelinetools':{
					afterrender : this.hideTools
				},
				'usertimeline':{
					//render : this.showDetailTimeline
				},
				'usertimeline button[name= "data"]':{
					click : this.downloadData
				},
				'detailtimeline':{
					render : this.resizePanel
				},
				'reporterdata':{
					//afterrender:this.loadDatas 
				},
				'reporterdata button[name = "printdata"]':{
					//click:this.printData
				},
				'usertimelinetools button[name= "data"]':{
					//click:this.loadDatas
				},
				'usertimelinetools button[name= "mail"]':{
					//click:this.Mail
				},
				'usertimelinetools button[name= "data"]':{
					//click:this.downloadData
				}
			
		});
	},
	hideTools:function(){
	
		var toolBar = Ext.getCmp('userTool');
		toolBar.remove(toolBar.getComponent('settingsTool'));
		Ext.select('.tbseparator').hide();
		toolBar.remove(toolBar.getComponent('csvTool'));
	},
	resizePanel:function(panel){ //resize the panel
	Ext.EventManager.onWindowResize(function () {
	panel.doComponentLayout();
			});
	},
	downloadData:function(){
			Ext.widget('reporterdata').show();
			//alert('data');
	},
	printData:function(){
		window.print();
	},
	downloadCSV:function(){
								Ext.MessageBox.progress({
								title: 'Downloading',
								value: 5,
								width: 350,
								increment: 15,
								closable: false,
								progressText: 'Connecting..',
								wait: true,
								waitConfig: {
									interval: 200
								},
								msg: '<b>Downloading Please wait...</b>',
								scope: this,
								handler: function () {
									this.updateText('Done!');
								}
							//	buttons: Ext.MessageBox.CANCEL
							});
	},
	Print:function(){
		Ext.widget('print').show();
	}
});