// JavaScript Document

Ext.define('OperationUptime.view.MainForm',{
	extend:'Ext.form.Panel',
	requires:[
		'OperationUptime.view.OperationUptimeMainForm',
		'OperationUptime.view.EgComponent'
	],
	alias:'widget.mainform',
	collapseMode:'mini',
	id:'mainform',
	layout: 'hbox',
	bodyPadding:'10 0 0 0',
	//cls:'formOuter',
	initComponent: function(){
		this.bodyPadding ='10 10 10 10';
		this.buttonAlign = 'center';
		this.callParent();
	},
	items:[
					{xtype: 'operationuptimemainform',flex:1},
					{xtype: 'egcomponent'},
					{
						xtype:'button',
						text: submitValue,
						formBind: true,
						disabled: true,
						//cls: 'button20',
						ui:'newButtonSmall',
						id: 'submit',
						name: 'submit',
						margin:'116 0 0 0'
					},
					{
						xtype:'button',
						text: "Save",
						//cls: "button20",
						ui:'newButtonSmall',
						id: "save",
						name: "save",
						margin: "116 0 0 0"
					},
					{
						xtype:'button',
						cls:'iconPanelUpArrow',
						id:'panelinsidetoggle',
						border:false,
						bodyStyle:{'background':'none'},
						hidden:false
					}
			],
	loadFields: function()
	{
		var jsonData = appConstants.publicJsonData;
		var saveLbl=jsonData.screenLabels['reporter.common.SAVE'];
		var submitLbl=submitValue;
		var yesNoOptionsRawData = jsonData['yesNoOptions'];
		var uptimeMainForm = this.getForm();
        var reportLbl = jsonData.screenLabels['reporter.common.Report Type'];
        var selectedReportType = jsonData.pageParams.selectedReportType;

		var report_TypeCombo = uptimeMainForm.findField('report_Type');
        var reportOptionsRawData = jsonData['reportOptions'];
        report_TypeCombo.setFieldLabel(reportLbl);
        report_TypeCombo.getStore().loadRawData(reportOptionsRawData);
        report_TypeCombo.setValue(selectedReportType);

		var fromSchedule =  jsonData.hiddenParams['fromSchedule'];
		var submitButtonObj = Ext.getCmp("submit");

		if(fromSchedule!=null && fromSchedule=="Yes")
		{
			submitButtonObj.setText(saveLbl);
		}
		else
		{
			submitButtonObj.setText(submitLbl);
		}

		var subzoneCombo = uptimeMainForm.findField('subzone');
		if(!Ext.isEmpty(subzoneCombo))
		{
			var incSubZone = jsonData.pageParams['includezone'];
			if(!Ext.isEmpty(incSubZone))
			{
				if(incSubZone=="yes")
				{
					subzoneCombo.show();
				}
			}
			else
			{
				incSubZone = "No";
			}
			this.setValueWithOptionInList(uptimeMainForm,'subzone',yesNoOptionsRawData,incSubZone);
			var incZoneLbl=jsonData.screenLabels['reporter.comparison.Include Subzone'];
//			subzoneCombo.labelEl.dom.innerHTML = incZoneLbl;

		}

		this.setValueWithOptionInList(uptimeMainForm,'uptimeReport',jsonData['uptimeForJSON'],jsonData.pageParams.selectedUptimeReportFor);
		var uptimeReportLabel = jsonData.screenLabels['reporter.uptime.Uptime for'];
		var analyzeByLabel = jsonData.screenLabels['uptime.Analyze by'];
		var compTypeLabel = jsonData.screenLabels['reporter.consolidated.Component Type'];
		var compLabel = jsonData.screenLabels['testFilterLabel'];

		var analyzeByVal = jsonData.pageParams.selectedAnalysisOption;

		this.setValueWithOptionInList(uptimeMainForm,'analyzeBy',jsonData['analysisOptions'],analyzeByVal);


		if ( analyzeByVal == 'Zone' )
		{
			var zoneCombo = uptimeMainForm.findField('zone');
			var zoneComboRawData = jsonData['vSiteJson'];
			if ( !Ext.isEmpty(zoneComboRawData) )
			{
				zoneCombo.getStore().loadRawData(zoneComboRawData);
				zoneCombo.suspendEvents(false);
				zoneCombo.setValue(jsonData.pageParams.selctedSite);
				zoneCombo.resumeEvents();
			}
			zoneCombo.show();
		}
		else if ( analyzeByVal == 'Segment' )
		{
			var segmentCombo = uptimeMainForm.findField('segment');
			var segmentComboRawData = jsonData['vSiteJson'];
			if ( !Ext.isEmpty(segmentComboRawData) )
			{
				segmentCombo.getStore().loadRawData(segmentComboRawData);
				segmentCombo.suspendEvents(false);
				segmentCombo.setValue(jsonData.pageParams.selctedSite);
				segmentCombo.resumeEvents();
			}
			segmentCombo.show();
		}
		else if ( analyzeByVal == 'Service' )
		{
			var serviceCombo = uptimeMainForm.findField('service');
			var serviceComboRawData = jsonData['vSiteJson'];
			if ( !Ext.isEmpty(serviceComboRawData) )
			{
				serviceCombo.getStore().loadRawData(serviceComboRawData);
				serviceCombo.suspendEvents(false);
				serviceCombo.setValue(jsonData.pageParams.selctedSite);
				serviceCombo.resumeEvents();
			}
			serviceCombo.show();
		}

		// For Running Since filter start
		var runningFun = uptimeMainForm.findField('runningDurationFun');
        var runningFunRawData = jsonData['runningFrom'];
		var selectedVal = jsonData.pageParams.selectedrunningFromFun
		var runningFunLbl = jsonData.screenLabels['reporter.common.Running from'];;
		runningFun.setFieldLabel(runningFunLbl);
		runningFun.getStore().loadRawData(runningFunRawData);
		runningFun.setValue(selectedVal);

		runningFun = uptimeMainForm.findField('runningDurationUnit');
        runningFunRawData = jsonData['runningFromUnit'];
		selectedVal = jsonData.pageParams.selectedrunningFromUnit;
		runningFun.getStore().loadRawData(runningFunRawData);
		runningFun.setValue(selectedVal);

		runningFun = uptimeMainForm.findField('runningDuration');
		selectedVal = jsonData.pageParams.selectedrunningFromVal;
		runningFun.setValue(selectedVal);
		// end

		this.setValueWithOptionInList(uptimeMainForm,'compType',jsonData['vCompTypeJson'],jsonData.pageParams.selectedCompType);
		this.setValueWithOptionInList(uptimeMainForm,'components',jsonData['compFilterJSON'],jsonData.pageParams['selectedComps']);

		var jsonData = appConstants.publicJsonData;
		var timelineLbl = jsonData.screenLabels['reporter.common.Timeline'];
		var selectedReportType = jsonData.pageParams.selectedReportType;
		var settingsMainForm = Ext.getCmp('mainform').getForm();
		 var graphLbl = jsonData.screenLabels['reporter.common.Graph'];
		  var fromLbl = jsonData.screenLabels['reporter.common.From'];
         var toLbl = jsonData.screenLabels['reporter.common.To'];
		  var hrsLbl = jsonData.screenLabels['reporter.common.Hrs'];

		var graphModeJsonArray = jsonData['graphModeJsonArray'];
        var graphModeObj = settingsMainForm.findField('er_mode');

        graphModeObj.setValue(jsonData.pageParams.er_mode);


        var timelineJSONArray = jsonData['timelineJSONArray'];
        var timeLineComboObj = settingsMainForm.findField('er_timeline');
        timeLineComboObj.getStore().loadRawData(timelineJSONArray);
        timeLineComboObj.setValue(jsonData.pageParams.selectedTimeline);
        timeLineComboObj.setFieldLabel(timelineLbl);

        var startdateObj = settingsMainForm.findField('er_stdate');
        var enddateObj = settingsMainForm.findField('er_enddate');
        var startHourObj = settingsMainForm.findField('er_sthr');
        var endHourObj = settingsMainForm.findField('er_endhr');

        var stDate = jsonData.pageParams['s_st_time'];
        var endDate = jsonData.pageParams['s_en_time'];
        var startHr = jsonData.pageParams['starthr'];
        var endHr = jsonData.pageParams['endhr'];


		startdateObj.setValue(jsonData.pageParams['startDateForDisplay']);
		startdateObj.dataArray = stDate;
		enddateObj.setValue(jsonData.pageParams['endDateForDisplay']);
		enddateObj.dataArray = endDate;
		startHourObj.setValue(jsonData.pageParams['startHourForDisplay']);
		startHourObj.dataArray = startHr;
		endHourObj.setValue(jsonData.pageParams['endHourForDisplay']);
		endHourObj.dataArray = endHr;
        stmin = jsonData.pageParams['startMinForDisplay'];
        enmin = jsonData.pageParams['endMinForDisplay'];
        mgr_stmin = jsonData.pageParams.startmin;
        mgr_enmin = jsonData.pageParams.endmin;

		// updateAppSettings();

		 if (!Ext.isEmpty(selectedReportType)) {
            if (selectedReportType == "data") {
                  graphModeObj.hide();
             } else {
                graphModeObj.show();
             }
        }

	},
	setValueWithOptionInList : function(form, fieldName, list, value){
		var fieldObj = form.findField(fieldName);
 		fieldObj.getStore().loadRawData(list);
		form.findField(fieldName).suspendEvents(false);
		form.findField(fieldName).setValue(value);
		form.findField(fieldName).resumeEvents();
	}
	});



