Ext.define('OperationUptime.view.OperationUptimeSettings', {
    extend: 'Ext.form.Panel',
    alias: 'widget.operationuptimesettings',
    id: 'uptimeSettingsPanel',
		requires:['utilities.ScrollCombo'
			],
	//cls:'configMode_popup_inner',
    requires: [
        //'OperationUptime.view.IncludeMaintenance',
        //'OperationUptime.view.SortBy',
        //'OperationUptime.view.ReportType',
        'utilities.TimePeriod',
        'utilities.ReportGeneration',
		'utilities.TimeLineSave'
       //'utilities.ScrollCombo'
    ],
    layout: 'column',
    defaults: {
        labelAlign: 'top',
        margin: '0 20 0 0',
		labelSeparator:''
    },
    items: [{
            fieldLabel: 'Show Details',
            labelSeparator: '',
            xtype: 'scrollcombo',
            id: 'showdetailsCombo',
            name: 'showdetailsCombo',
            editable: false,
            width: 50,
            labelStyle: 'white-space: nowrap',
            margin: '8 40 10 0',
            defaultListConfig: {
                loadingHeight: 50,
                minWidth: 50,
                maxHeight: 240,
                shadow: 'sides'
            },
            cls: 'dropdown',
            displayField: 'displayField',
            valueField: 'valueField',
            queryMode: 'local',
            store: new Ext.data.Store({
                fields: ['displayField', 'valueField'],
                data: []
            }),
            hidden: true
        }, {
            xtype: 'scrollcombo',
            editable: false,
            id: 'excludeWeekendsCombo',
            name: 'excludeWeekendsCombo',
			width:100,
			margin:'8 20 0 0',
			cls: 'dropdown',
			labelStyle: 'white-space: nowrap',
			labelSeparator: '',
            defaultListConfig: {
                loadingHeight: 50,
                minWidth: 50,
                maxHeight: 240,
                shadow: 'sides'
            },
            cls: 'dropdown',
            displayField: 'displayField',
            valueField: 'valueField',
            queryMode: 'local',
            store: new Ext.data.Store({
                fields: ['displayField', 'valueField'],
                data: []
            })
        },
		/*{
            xtype: 'label',
			cls: 'font_bold11',
			margin: '33px 7px 2px 0px',
            id: 'excludeWeekendLbl',
            name: 'excludeWeekendLbl',
            hidden: true
        }, */
		{
            xtype: 'scrollcombo',
            labelSeparator: '',
            fieldLabel: 'Chart',
            editable: false,
            id: 'chartOptionsCombo',
            name: 'chartOptionsCombo',
			margin: '8px 14px 0px 0px',
            width: 180,
			hidden:true,
            cls: 'dropdown',
            displayField: 'displayField',
            valueField: 'valueField',
            queryMode: 'local',
            store: new Ext.data.Store({
                fields: ['displayField', 'valueField'],
                data: []
            })
        },{
            xtype: 'scrollcombo',
			labelSeparator: '',
            id: 'includeMaintenanceCombo',
            name: 'includeMaintenanceCombo',
            editable: false,
			width:115,
			margin:'8 0 0 0',
			cls: 'dropdown',
			labelStyle: 'white-space: nowrap',
            defaultListConfig: {
                loadingHeight: 50,
                minWidth: 50,
                maxHeight: 300,
                shadow: 'sides'
            },
            cls: 'dropdown',
            displayField: 'displayField',
            valueField: 'valueField',
            queryMode: 'local',
            store: new Ext.data.Store({
                fields: ['displayField', 'valueField'],
                data: []
            })
        },

        {
            xtype: 'splitter',
            height: 2,
			id:'splitterID',
			hidden:true,
            margin: '10px 0px 10px 0px',
            draggable: false,
            style: {
                'cursor': 'default'
            }
        },

        {
            fieldLabel: 'Sort By',
            xtype: 'scrollcombo',
			labelSeparator: '',
            editable: false,
            id: 'sortByCombo',
			margin: '0px 20px 0px 0px',
            name: 'sortByCombo',
			hidden:true,
            width: 95,
            cls: 'dropdown',
            store: new Ext.data.Store({
                fields: ['displayField', 'valueField'],
                data: []
            }),
            displayField: 'displayField',
            valueField: 'valueField',
            queryMode: 'local'
        }, {
            fieldLabel: 'Show',
            xtype: 'scrollcombo',
			labelSeparator: '',
            editable: false,
			hidden:true,
            id: 'showByPriority',
            name: 'showByPriority',
			margin: '0px 20px 0px 0px',
            width: 90,
            cls: 'dropdown',
            displayField: 'displayField',
            valueField: 'valueField',
            queryMode: 'local',
            store: new Ext.data.Store({
                fields: ['displayField', 'valueField'],
                data: []
            })
        },

		{
            xtype: 'splitter',
            height: 2,
            margin: '10px 0px 10px 0px',
            draggable: false,
            style: {
                'cursor': 'default'
            }
        }, 
       {
            xtype: 'timeperiod',
			margin: '0 0 0 0'
        }, {
            xtype: 'splitter',
            height: 2,
            margin: '10px 0px 10px 0px',
            draggable: false,
            style: {
                'cursor': 'default'
            }
        },  {
            xtype: 'reportgeneration',
			margin: 0,
        },
		{
					xtype: 'splitter',
					id:'RTMSplitter',
					height: 2,
					margin: '0px 0px 0px 0px',
					draggable:false,
					style: {
						'cursor': 'default'
					}
		},
				{xtype:'timelinesave',margin: '0 15 0 10'}
    ],
	listeners: {
		afterrender : function(e) {
			console.log("e==>",e);
			var OperationUptimesettingObj = Ext.getCmp('uptimeSettingsPanel');
			OperationUptimesettingObj.doLayout();
		}
	},
    loadSettingsData: function () {
        var jsonData = appConstants.publicJsonData;
        var dataLbl = jsonData.screenLabels['reporter.common.Data'];
        //var graphLbl = jsonData.screenLabels['reporter.common.Graph'];
        var showDetailsLbl = jsonData.screenLabels['reporter.common.Show Details'];

        var settingsMainForm = this.getForm();

        var incMaintenanceLbl = jsonData.screenLabels['reporter.common.Include Maintenance'];
        var excludeWeekendsLbl = jsonData.screenLabels['reporter.common.Exclude weekends'];
        var excludesLbl = jsonData.screenLabels['reporter.common.Excludes'];
        var chartLbl = jsonData.screenLabels['reporter.uptime.Chart'];
        var sortByLbl = jsonData.screenLabels['reporter.comparison.Sort by'];
        var showLbl = jsonData.screenLabels['reporter.comparison.Show'];
        var timePeriodLbl = jsonData.screenLabels['reporter.common.Time period'];
        var hrsLbl = jsonData.screenLabels['reporter.common.Hrs'];
        var fromLbl = jsonData.screenLabels['reporter.common.From'];
        var minsLbl = jsonData.screenLabels['reporter.common.Mins'];
        var toLbl = jsonData.screenLabels['reporter.common.To'];
       // var timelineLbl = jsonData.screenLabels['reporter.common.Timeline'];
        var reportGenerationLbl = jsonData.screenLabels['reporter.consolidated.Report Generation'];
        var reportNameLbl = jsonData.screenLabels['reporter.consolidated.Report Name'];
        var reportLbl = jsonData.screenLabels['reporter.common.Report Type'];

        sortByRebootJSONArray = jsonData['sortByRebootJSONArray'];
        getNotApplicationData = jsonData.pageParams['NotApplicable'];
        sortByJSONArray = jsonData['sortByJSONArray'];

       var selectedReportType = jsonData.pageParams.selectedReportType;



        var includeMaintenanceCombo = settingsMainForm.findField('includeMaintenanceCombo');
        var yesNoOptionsRawData = jsonData['yesNoOptions'];
        includeMaintenanceCombo.getStore().loadRawData(yesNoOptionsRawData);
        includeMaintenanceCombo.setValue(jsonData.pageParams.includeMaintenancePeriod);
        includeMaintenanceCombo.setFieldLabel(incMaintenanceLbl);

        var showdetailsCombo = settingsMainForm.findField('showdetailsCombo');
        showdetailsCombo.setFieldLabel(showDetailsLbl);
        showdetailsCombo.getStore().loadRawData(yesNoOptionsRawData);
        showdetailsCombo.setValue(jsonData.pageParams.showDetails);


        var excludeWeekendsCombo = settingsMainForm.findField('excludeWeekendsCombo');
		var excludeWeekendsRawData = jsonData['excludeWeekendsCombo'];
        excludeWeekendsCombo.getStore().loadRawData(excludeWeekendsRawData);
        excludeWeekendsCombo.setValue(jsonData.pageParams.excludeweekend);
        excludeWeekendsCombo.setFieldLabel(excludeWeekendsLbl);

       // var excludeWeekendLbl = Ext.getCmp('excludeWeekendLbl');
       // excludeWeekendLbl.setText(excludesLbl);

        var timeperiodLblObj = Ext.getCmp('timeperiodLbl');
        timeperiodLblObj.setText(timePeriodLbl);

        var fromTimeLblObj = Ext.getCmp('fromTimeLbl');
        fromTimeLblObj.setText(fromLbl);

        var fromHrsLblObj = Ext.getCmp('fromHrsLbl');
        fromHrsLblObj.setText(hrsLbl);

        var fromMinsLblObj = Ext.getCmp('fromMinsLbl');
        fromMinsLblObj.setText(minsLbl);

        var toTimeLblObj = Ext.getCmp('toTimeLbl');
        toTimeLblObj.setText(toLbl);

        var toHrsLblObj = Ext.getCmp('toHrsLbl');
        toHrsLblObj.setText(hrsLbl);

        var toMinsLblObj = Ext.getCmp('toMinsLbl');
        toMinsLblObj.setText(minsLbl);


        var reportGenerationRawData = jsonData['reportGenerationJSONArray'];
        var reportGenObj = settingsMainForm.findField('reportGeneration');
        reportGenObj.getStore().loadRawData(reportGenerationRawData);
        reportGenObj.setValue(jsonData.pageParams.er_reportgenration);
        reportGenObj.setFieldLabel(reportGenerationLbl);

        var reportNameObj = settingsMainForm.findField('bgReportName');
        reportNameObj.setFieldLabel(reportNameLbl);


        var timeJSONArray = jsonData['timeJSONArray'];
        var timePeriodFromHrsObj = settingsMainForm.findField('timefrom');
        timePeriodFromHrsObj.setValue(jsonData.pageParams.selectHrsFrom);

        var minseJSONArray = jsonData['minseJSONArray'];
        var timePeriodFromMinsObj = settingsMainForm.findField('minfrom');
        timePeriodFromMinsObj.setValue(jsonData.pageParams.selectMinsFrom);


        var timePeriodToHrsObj = settingsMainForm.findField('timeto');
        timePeriodToHrsObj.setValue(jsonData.pageParams.selectHrsTo);

        var timePeriodToMinsObj = settingsMainForm.findField('minto');
        timePeriodToMinsObj.setValue(jsonData.pageParams.selectMinsTo);

        var priorityJSONArray = jsonData['priorityJSONArray'];

        var showByPriorityObj = settingsMainForm.findField('showByPriority');
        showByPriorityObj.getStore().loadRawData(priorityJSONArray);
        showByPriorityObj.setValue(jsonData.pageParams.priority);
        showByPriorityObj.setFieldLabel(showLbl);

        var chartOptionJSONArray = jsonData['chartOptionJSONArray'];
        var chartOptionsComboObj = settingsMainForm.findField('chartOptionsCombo');
        chartOptionsComboObj.getStore().loadRawData(chartOptionJSONArray);
        chartOptionsComboObj.setValue(jsonData.pageParams.er_show);
        chartOptionsComboObj.setFieldLabel(chartLbl);


        var sortJSONArray = jsonData['sortByJSONArray'];
        var sortByComboObj = settingsMainForm.findField('sortByCombo');
        sortByComboObj.getStore().loadRawData(sortJSONArray);
        sortByComboObj.setValue(jsonData.pageParams.sortby);
        sortByComboObj.setFieldLabel(sortByLbl);

        	 if (!Ext.isEmpty(selectedReportType)) {
            if (selectedReportType == "data") {
                showdetailsCombo.show();
                chartOptionsComboObj.hide();
            } else {
                showdetailsCombo.hide();
                chartOptionsComboObj.show();
             }
        }
		//
		var uptimeReport = Ext.getCmp('uptimeReport');
		if(!Ext.isEmpty(uptimeReport))
		{
			var value=uptimeReport.getValue();
			if(value=='Services')
			{
				if (isSettingsEnabled)
				{	
					var showTop=Ext.getCmp('showByPriority');
						if(!Ext.isEmpty(showTop))
							showTop.hide();

					var includeMaintenanceCombo=Ext.getCmp('includeMaintenanceCombo');
						if(!Ext.isEmpty(includeMaintenanceCombo))
							includeMaintenanceCombo.hide();

				//
					var jsonData = appConstants.publicJsonData;
					var chartLbl = jsonData.screenLabels['reporter.uptime.Chart'];
					var chartOptionJSONArray = jsonData['chartOptionJSONArray'];
					var chartOptionsComboObj = Ext.getCmp('chartOptionsCombo');
					var tmpArry=new Array();
					if(chartOptionJSONArray!=undefined)
					{
						for(var k=0;k<chartOptionJSONArray.length;k++)
						{
							if(k==2)
								break;
							tmpArry.push(chartOptionJSONArray[k]);

						}
					}

					chartOptionsComboObj.getStore().loadRawData(tmpArry);
					chartOptionsComboObj.setValue(jsonData.pageParams.er_show);
					chartOptionsComboObj.setFieldLabel(chartLbl);
				//

				var sortJSONArray = jsonData['sortByJSONArray'];
				var sortByComboObj = settingsMainForm.findField('sortByCombo');

				var tmpSortArry=new Array();
					if(sortJSONArray!=undefined && sortJSONArray.length==4)
					{
						for(var k=0;k<sortJSONArray.length;k++)
						{
							if(k==0||k==3)
								continue;
							tmpSortArry.push(sortJSONArray[k]);

						}
					}
				sortByComboObj.getStore().loadRawData(tmpSortArry);
				sortByComboObj.setValue(jsonData.pageParams.sortby);
				sortByComboObj.setFieldLabel(sortByLbl);

				//
				}
			}
			else
			{
				if (isSettingsEnabled)
				{	
					var showTop=Ext.getCmp('showByPriority');
						if(!Ext.isEmpty(showTop))
							showTop.show();

					var includeMaintenanceCombo=Ext.getCmp('includeMaintenanceCombo');
						if(!Ext.isEmpty(includeMaintenanceCombo))
							includeMaintenanceCombo.show();

					
				//
					var chartOptionJSONArray = jsonData['chartOptionJSONArray'];
					var chartOptionsComboObj = settingsMainForm.findField('chartOptionsCombo');

					chartOptionsComboObj.getStore().loadRawData(chartOptionJSONArray);
					chartOptionsComboObj.setValue(jsonData.pageParams.er_show);
					chartOptionsComboObj.setFieldLabel(chartLbl);
				//

				var sortJSONArray = jsonData['sortByJSONArray'];
				var sortByComboObj = settingsMainForm.findField('sortByCombo');

				sortByComboObj.getStore().loadRawData(sortJSONArray);
				sortByComboObj.setValue(jsonData.pageParams.sortby);
				sortByComboObj.setFieldLabel(sortByLbl);

				//
				}
			}

		}

		//
    }
});