var urlVal='';
Ext.define('optionsbackgroundreports.controller.OptionsBackgroundReports',{
	extend:'Ext.app.Controller',
	views:['Main'],
	refs:[
		{selector:'main',ref:'main'},
		{selector:'utilitiestool',ref:'utilitiestool'},
		{selector:'emptypanel', ref:'emptypanel'},
		{selector: 'timeperiod', ref:'timeperiod'},
		{selector:'resultpanel', ref:'resultpanel'},
		{selector:'optionsbackgroundreportsform', ref:'optionsbackgroundreportsform'}
	],
	searchTask: new Ext.util.DelayedTask(function(){
		appConstants.appObj.getController('OptionsBackgroundReports').doFilter();
	}),
	init:function(){
		this.control(
		{
			'main':
			{
				'boxready':this.afterMainRender
			},
			'bgrdReportGrid' :
			{
				'afterrender':this.deleteAllReport,
			},
			'bgrdReportGrid textfield[name="livesearch"]':
			{
				change:this.typewatch
			},
			'optionsbackgroundreportsform combo[name="filterByCombo"]':
			{
				'select' : this.changeFilterOption
			},
			'optionsbackgroundreportsform combo[name="er_type"]':
			{
				'select' : this.loadGridDataForFilter
			},
			'optionsbackgroundreportsform combo[name="filterByCombo"]':
			{
				'select' : this.loadGridDataForFilter
			},
			'optionsbackgroundreportsform combo[name="statusCombo"]':
			{
				'select' : this.loadGridDataForFilter
			},
			'resultpanel':
			{
			//	'afterlayout': this.checkResult
			}
		});
	},
	changeFilterOption : function(combo)
	{
		var filterOpt = combo.getValue();
		var bgRepForm = this.getOptionsbackgroundreportsform().getForm();
		var statusCombo = bgRepForm.findField('statusCombo');
		if(filterOpt=='Status')
		{
			statusCombo.show();
		}
		else
		{
			statusCombo.hide();
		}
	},
	loadGridDataForFilter : function()
	{
		if(task1!=null && task1!=undefined)
		{
			Ext.TaskManager.stop(task1);
			task1 = null;
		}
		var bgRepForm = this.getOptionsbackgroundreportsform().getForm();
		var reportType = bgRepForm.findField('er_type').getValue();
		var filterBy = bgRepForm.findField('filterByCombo').getValue();
		var status = bgRepForm.findField('statusCombo').getValue();
		var bgrndReportGrid = Ext.getCmp('bgrndReportGrid');
		var gridContainer = Ext.getCmp("gridContainer");
		var resultpanel = Ext.getCmp("resultPanel");

		var params = 'savereport=all_report&forwardto=ErBackGoundProcessJSON&er_bgreportfrom='+reportType+'&er_filterby='+filterBy+'&erselectstatus='+status;

		Ext.Ajax.request({
			url: '../servlet/com.eg.ErStartBackGroundReportC',
			method: 'POST',
			params: params,
			success: function( response )
			{
				try
				{
					if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
					{
						var jsonText = response.responseText;
						var jsonData = Ext.decode( jsonText );
						var rootJson = jsonData['rootJson'];

						var reportType = bgRepForm.findField('er_type');
						reportType.getStore().loadRawData(rootJson['reportOptions']);
						reportType.setValue(rootJson.pageParams['selectedReportType']);

						var selectedFilterOption = rootJson.pageParams['selectedFilterOption'];

						var filterByCombo = bgRepForm.findField('filterByCombo');
						filterByCombo.getStore().loadRawData(rootJson['filterOptions']);
						filterByCombo.setValue(selectedFilterOption);

						var statusCombo = bgRepForm.findField('statusCombo');
						statusCombo.getStore().loadRawData(rootJson['statusOptions']);
						statusCombo.setValue(rootJson.pageParams['selectedStatusOption']);

						if(selectedFilterOption=='Status')
						{
							statusCombo.show();
						}
						else
						{
							statusCombo.hide();
						}


						resultpanel.hide();
						var scheduleGridData = rootJson['scheduleGridData'];
						var screenLbls = rootJson['screenLabels'];
						var recordsPerPage = rootJson.pageParams['recordsPerPage'];

						gridContainer.removeAll();

					//	console.log(scheduleGridData);
						if(!Ext.isEmpty(scheduleGridData))
						{
							var processIds = rootJson['processIds'];

							var hideReporTypeColumn = true;

							if(rootJson.pageParams['includeReportType']=='true')
								hideReporTypeColumn = false;

							gridContainer.add({
								xtype: 'bgrdReportGrid',
								dataArray :scheduleGridData,
								pageLimit : recordsPerPage,
								screenLabels : screenLbls,
								hideReporTypeColumn : hideReporTypeColumn,
								processingTaskIds : processIds
							});
							gridContainer.show();
						}
						else
						{
							gridContainer.hide();
							resultpanel.removeAll();
							var errorMsg = rootJson.screenLabels['errorMsg'];
							if(!Ext.isEmpty(errorMsg))
							{
								resultpanel.add({
								xtype:'container',width:"100%", height:"100%",
								html: '<table width="100%" height="100%"><tr><td align="center" valign="middle"><div class="iconInformation" ></div><div class="commonErrorMsgText">'+errorMsg+'</div></td></tr></table>'
							});
							resultpanel.show();
							}
						}
						//resultpanel.doLayout();

					}
				}
				catch ( e )
				{
					alert('[Exception] @ afterMainRender Ajax '+e);
				}
				initLdgMask.hide();
			}
		});
	},
	afterMainRender:function()
	{
		var me = this;
		var bgRepForm = this.getOptionsbackgroundreportsform().getForm();
		if(!Ext.isEmpty(publicJsonData))
		{
			try
			{
				var rootJson = publicJsonData['rootJson'];
				var screenLbls = rootJson['screenLabels'];
				//Ext.getCmp("optionBgReportMain").setTitle(screenLbls['reporter.consolidated.REPORT GENERATED AND SAVED']);
				Ext.getCmp("optionBgReportMain").setTitle("Report Generated and Saved");

				var reportType = bgRepForm.findField('er_type');
				reportType.setFieldLabel(screenLbls['reporter.consolidated.Report Type']);
				reportType.getStore().loadRawData(rootJson['reportOptions']);
				reportType.setValue(rootJson.pageParams['selectedReportType']);

				var selectedFilterOption = rootJson.pageParams['selectedFilterOption'];

				var filterByCombo = bgRepForm.findField('filterByCombo');
				filterByCombo.setFieldLabel(screenLbls['reporter.consolidated.Filter by']);
				filterByCombo.getStore().loadRawData(rootJson['filterOptions']);
				filterByCombo.setValue(selectedFilterOption);

				var statusCombo = bgRepForm.findField('statusCombo');
				statusCombo.setFieldLabel(screenLbls['reporter.consolidated.Status']);
				statusCombo.getStore().loadRawData(rootJson['statusOptions']);
				statusCombo.setValue(rootJson.pageParams['selectedStatusOption']);

				if(selectedFilterOption=='Status')
				{
					statusCombo.show();
				}
				else
				{
					statusCombo.hide();
				}

				var resultpanel = Ext.getCmp("resultPanel");
				var gridContainer = Ext.getCmp("gridContainer");
				var scheduleGridData = rootJson['scheduleGridData'];
			//	console.log(scheduleGridData);
				if(!Ext.isEmpty(scheduleGridData))
				{
					resultpanel.hide();
					var recordsPerPage = rootJson.pageParams['recordsPerPage'];
					var processIds = rootJson['processIds'];
					var hideReporTypeColumn = true;

					if(rootJson.pageParams['includeReportType']=='true')
						hideReporTypeColumn = false;
					gridContainer.add({
						xtype: 'bgrdReportGrid',
						dataArray :scheduleGridData,
						pageLimit : recordsPerPage,
						screenLabels : screenLbls,
						hideReporTypeColumn : hideReporTypeColumn,
						processingTaskIds : processIds
					});
						gridContainer.show();


				}
				else
				{
					gridContainer.hide();
					var errorMsg = screenLbls['errorMsg'];
					if(!Ext.isEmpty(errorMsg))
					{
						resultpanel.removeAll();
						resultpanel.add({
						xtype:'container',
						width:"100%", height:"100%",
						html: '<table width="100%" height="100%"><tr><td align="center" valign="middle"><div class="iconInformation" ></div><div class="commonErrorMsgText">'+errorMsg+'</div></td></tr></table>'
					});
					resultpanel.show();
					}
				}
				///resultpanel.doLayout();

			}
			catch (e)
			{
				alert('Error in afterMainRender---->'+e);
			}
		}
	},
	typewatch:function(field, event){
  		 this.searchTask.delay(1000);
	},
	doFilter :function(){
		var field=Ext.getCmp('livesearch');
		var dummyArray=Ext.getCmp('bgrndReportGrid').dummyArray;
		var dataArray=Ext.getCmp('bgrndReportGrid').dataArray;
		if(Ext.String.trim(field.value).length > 0 && (Ext.String.trim(field.value) != '' || Ext.String.trim(field.value) != null))
		{
			Ext.getCmp('bgrndReportGrid').getStore().removeAll();
			var regex = RegExp(field.value, 'i');
			var regex = RegExp(field.value, 'i');
			dataArray.splice(0, dataArray.length);
			for(var key in dummyArray)
			{
				var match = false;
				var obj=dummyArray[key];
				//var value=obj.ReportName;
					Ext.Object.each(obj, function (property, value) {
						match =match || regex.test(String(value));
					});
				if(match)
					dataArray.push(obj);
			}
			Ext.getCmp('bgrndReportGrid').getStore().load();
		}
		else{
			Ext.getCmp('bgrndReportGrid').getStore().removeAll();
			dataArray.splice(0, dataArray.length);
			for(var key in dummyArray)
			{
				var obj=dummyArray[key];
				dataArray.push(obj);
			}
			Ext.getCmp('bgrndReportGrid').getStore().loadRawData(dataArray);
			Ext.getCmp('bgrndReportGrid').getStore().load();
		}
		field.focus();
		field.toggleTriggger();
	},
	deleteAllReport:function(grid)
	{
		var me = this;
		 var gridId=grid.getId();
		 var msgInfo='Are you sure you want to remove the selected background report(s)';
		 var removeIconId='';
		 if (gridId=='bgrndReportGrid')
			 removeIconId='#removeAll';
		 else
			 return;
		grid.mon(Ext.select(removeIconId), 'click', function() {
			selected=Ext.getCmp('bgrndReportGrid').getView().getSelectionModel().getSelection();
			var scheduid=urlVal.substring(urlVal.indexOf("=")+1,urlVal.indexOf("&"));
			var grid = Ext.getCmp("bgrndReportGrid");
			var favoriteListGridStore = grid.getStore();
			var noOfrecords = favoriteListGridStore.getCount();
			var selectionModelObj = grid.getSelectionModel();
			if ( noOfrecords > 0 )
			{
				var reportSelected=false;
				if(selectionModelObj.getSelection().length>0)
					reportSelected=true;
					if(reportSelected){
					Ext.Msg.show({
						title:'Alert',
						msg:msgInfo,
						buttons: Ext.Msg.YESNO,
						icon: Ext.Msg.QUESTION,
						fn:function(buttonId)
						{
							if(buttonId =="yes")
							{
								var mid="";

								//var selected = selectionModelObj.getSelection();
								/*if(selected.length>0)
								{
									for(var i=0;i<selected.length;i++)
									{
										var recOrg = selected[i];
										mid += '&bg_reportname='+recOrg.get('mid');
										favoriteListGridStore.remove(recOrg);
									}
								}*/
							Ext.each(selected, function (item) {
										//mid += '&bg_reportname='+scheduid+'$'+encodeURIComponent(item.data.ReportName);
										mid += '&bg_reportname='+encodeURIComponent(item.data.mid);
										favoriteListGridStore.remove(item.data.ReportName);
							});
								var er_type = Ext.getCmp('er_type').getValue();
								var filterBy = Ext.getCmp('filterByCombo').getValue();
								var status = Ext.getCmp('statusCombo').getValue();
								var selectedParams = 'er_bgreportfrom='+er_type+'&er_filterby='+filterBy+'&forwardto=ErBackGoundProcess';

								if(filterBy=='Status')
								{
									selectedParams += '&erselectstatus='+status;
								}
								
								document.location = '/final/servlet/com.eg.ErStartBackGroundReportC?'+selectedParams+"&back="+backParam+"&fromNavLink="+fromNavLinkParam+"&userID="+userIdParam+"&savereport=deleteRecord"+mid;
							}
						}
					});
				}
				else{
						Ext.Msg.show({
						title:'BACKGROUND REPORTS',
						 msg: 'Please select the report!',
						buttons: Ext.Msg.OK,
						icon: Ext.Msg.WARNING
					 });
					return;
				}
			}
		});
	},
	deleteSingleReport:function(record)
	{
		Ext.Msg.show({
			title:'Alert',
			msg:'Are you sure you want to remove the background report?',
			buttons: Ext.Msg.YESNO,
			icon: Ext.Msg.QUESTION,
			fn:function(buttonId)
			{
				if(buttonId =="yes")
				{
					var scheduid=urlVal.substring(urlVal.indexOf("=")+1,urlVal.indexOf("&"));
					var grid = Ext.getCmp("bgrndReportGrid");
					var favoriteListGridStore = grid.getStore();

					//var mid = '&bg_reportname='+scheduid+'$'+encodeURIComponent(record.data.ReportName);
					var mid = '&bg_reportname='+encodeURIComponent(record.data.mid);
					favoriteListGridStore.remove(record.data.ReportName);

					var er_type = Ext.getCmp('er_type').getValue();
					var filterBy = Ext.getCmp('filterByCombo').getValue();
					var status = Ext.getCmp('statusCombo').getValue();
					var selectedParams = 'er_bgreportfrom='+er_type+'&er_filterby='+filterBy+'&forwardto=ErBackGoundProcess';

					if(filterBy=='Status')
					{
						selectedParams += '&erselectstatus='+status;
					}	

					//document.location = '/final/servlet/com.eg.ErStartBackGroundReportC?'+selectedParams+"&back="+backParam+"&fromNavLink="+fromNavLinkParam+"&userID="+userIdParam+"&savereport=deleteRecord"+mid;
					document.location = '/final/servlet/com.eg.ErStartBackGroundReportC?'+selectedParams+"&back="+encodeURIComponent(backParam)+"&fromNavLink="+encodeURIComponent(fromNavLinkParam)+"&userID="+encodeURIComponent(userIdParam)+"&savereport=deleteRecord"+mid;
				}
			}
		});
	},
	getBookletInfo:function(pdfurl,reportName)
	{
		var thisBooklet = this;
		var url = '/final/reporter/ErGroupBooklet.jsp?forBackground=yes';
		initLdgMask.show();
		Ext.Ajax.request({
			url: url,
			params: '',
			scope: this,
			success: function(response)
			{
				var groupPDFRes = Ext.decode(response.responseText);
				initLdgMask.hide();
				thisBooklet.openBookletWindow(groupPDFRes,pdfurl,reportName);
			},
			failure: function(err)
			{
				Ext.MessageBox.alert('Error occured in ErGroupPDFBean.jsp page');
			}
		});
	},
	openBookletWindow:function(groupPDFRes,pdfurl,reportName)
	{
		var thisBooklet = this;
		var isNew = groupPDFRes.isNew;
		console.log('isNew ' + isNew);
		var dropDwVal = '';
		var hiddenDrop = false;
		if (isNew == 'true')
		{
			hiddenDrop = true;
		}
		dropDwVal = groupPDFRes.bookletArr;

		Ext.create('Ext.window.Window', {
			title: 'Booklet View',
			id:'bookletWindow',
			draggable: false,
			width: 385,
			minHeight: 170,
			modal: true,
			header:{
				style:{'margin':'0px 10px 0px 10px','padding':'4px 0px 1px 0px'}
			},
			ui:'newPopupWindow withBorderShadow newplainHeader_border',
			layout: 'fit',
//			listeners:
//			{
//				show: function (win) {
//					if (this.modal)
//					{
//						var el ;
//						var dom = Ext.dom.Query.select('.x-mask');
//						for (var y = 0; y < dom.length; y++) {
//							 el = Ext.fly(dom[y]);
//
//						}
//					 el.addCls('windowModal');
//					}
//				},
//			},
			items: [
				{
					margin:'17 10 20 20',
					xtype: 'panel',
					layout: 'column',
					defaults:
					{
						labelSeparator:'',
						labelAlign:'top',
					},
					items: [
					{
						xtype : 'radiogroup',
						fieldLabel : 'Add to',
						columnWidth:1.0,
						margin:'0 0 10 -4',
						id : 'fieldID',
						hidden: hiddenDrop,
						layout : 'column',
						defaults:
						{
							cls:'radiobt',
							noWrap:true
						},
						items : [
							{
								boxLabel:'New booklet', id:'newBookletsId', name:'bookletType' ,inputValue:'newBookletsId',
								margin : '0 15 0 0',
							},
							{
								boxLabel:'Existing Booklet', id:'extgBookletsId' ,name:'bookletType', inputValue:'extgBookletsId',
							}
						],
						listeners :
						{
							'change' : function()
							{

								var newBookValue = Ext.getCmp('newBookletsId').getValue();
								var extgBookValue = Ext.getCmp('extgBookletsId').getValue();
								if( newBookValue)
								{
									Ext.getCmp('newBookletID').show();
									Ext.getCmp('bookletDesId').show();
									Ext.getCmp('bookletID').hide();
								}
								else if(extgBookValue)
								{
									Ext.getCmp('bookletID').show();
									Ext.getCmp('newBookletID').hide();
									Ext.getCmp('newBookletID').setValue('');
									Ext.getCmp('bookletDesId').hide();
									Ext.getCmp('bookletDesId').setValue('');
								}
								Ext.getCmp('bookletWindow').doComponentLayout();
								Ext.getCmp('bookletWindow').doLayout();
							}
						}
					},
					{
						xtype: 'scrollcombo',
						cls: 'dropdown',
						margin:'10 0 10 0',
						columnWidth:.4,
						fieldLabel: 'Add to Booklet Name',
						id: 'bookletID',
						name: 'bookletName',
						store: new Ext.data.Store({
							fields: ['displayField', 'valueField'],
							data: []
						}),
						displayField: 'displayField',
						valueField: 'valueField',
						queryMode: 'local',
						listeners: {
							'afterrender':function()
							{
								var bookletID = Ext.getCmp('bookletID');
								bookletID.getStore().loadRawData(dropDwVal);
								if(dropDwVal.length>0)
								{
									bookletID.setValue(dropDwVal[0]['valueField']);
									for(var i=0;i<dropDwVal.length;i++)
									{
										bookletNameAry.push(dropDwVal[i]['displayField']);
									}
								}
							}
						}
					},
					{
						xtype: 'textfield',
						name: 'newBookletName',
						id: 'newBookletID',
						fieldLabel: 'Booklet Name',
						cls:'textbox',
						allowBlank: false,
						msgTarget: 'side',
						margin:'10 10 10 0',
						columnWidth:.5,
					},
					{
						xtype: 'textfield',
						fieldLabel: 'Description',
						name: 'bookletDesId',
						cls:'textbox',
						id: 'bookletDesId',
						margin:'10 10 10 0',
						columnWidth:.5,
					},
					{
						xtype:'container',
						margin:0,
						columnWidth:1.0,
						defaults:
						{
							buttonAlign:'center'
						},
						layout:{
							type:'hbox',
							pack :'center',
						},
						items:[
							{
								xtype: 'button',
								text: 'Add & Close',
								id: 'addReportID',
								ui:'newButtonSmall',
								//height:23,
								width:90,
								buttonAlign:'center',
								margin:'10 5 0 5',
								name: 'addReportName',
								//padding:'2 5 0 5',
								listeners: {
									'click': function()
									{
										thisBooklet.addOrUpdateBooklet(pdfurl,reportName);
									}
								}
							}
						]
					}
				]
			}]
		}).show();
		if (hiddenDrop)
		{
			Ext.getCmp('newBookletsId').setValue(true);
		}
		else
		{
			Ext.getCmp('extgBookletsId').setValue(true);
		}
	},
	addOrUpdateBooklet:function(pdfurl,reportName)
	{
		var thisBooklet = this;
		var queryStr='';
		var newValue = Ext.getCmp('newBookletsId').getValue();
		var existingValue = Ext.getCmp('extgBookletsId').getValue();
		var bookletID = Ext.getCmp('bookletID').getValue();
		var newBookletID = Ext.getCmp('newBookletID').getValue();
		var bookletDesId = Ext.getCmp('bookletDesId').getValue();
		if (Ext.isEmpty(appConstants.erUtils))
		{
			appConstants.erUtils = Ext.widget("erutils");
		}	
		if(this.validateBooklet(newBookletID))
		{
			var fileNames = '';
			var rNameIDs = '';
			for(var i=0;i<reportName.length;i++)
			{
				var fileName = pdfurl[i].substring(pdfurl[i].indexOf('scheduleid=')+11,pdfurl[i].length);
				fileName = fileName.substring(0,fileName.indexOf('&'));
				fileName = fileName.replace("|",'_')+'_'+reportName[i];
				fileName = fileName.replace("%7C",'_');		// | encoded value
				fileNames+=fileName;
				rNameIDs+=reportName[i];
				if(i<reportName.length-1)
				{
					fileNames+=',';
					rNameIDs+=',';
				}
			}
			//var queryStr = 'bookletID=' + bookletID + '&newBookletID=' + newBookletID + '&rNameID=' + rNameIDs+'&bookletDesId='+bookletDesId+'&bindFrom=backGround&fileName='+fileNames;
			if(newValue)
			{
				queryStr =  'newBookletID=' + newBookletID + '&rNameID=' + rNameIDs+'&bookletDesId='+appConstants.erUtils.specialCharEncode(bookletDesId)+'&bindFrom=backGround&fileName='+fileNames;
			}
			else
			{
				queryStr = '&bookletID=' + bookletID +'&rNameID='+ rNameIDs+'&bindFrom=backGround&fileName='+fileNames;
			}
			initLdgMask.show();

			Ext.Ajax.request({
				url: '../servlet/com.eg.ErBookletC',
				params: queryStr,
				scope: this,
				success: function(response)
				{
					var responseStr = Ext.decode(response.responseText);
					console.log(responseStr)
					var Status = responseStr.status;
					initLdgMask.hide();
					if(Status=='success')
						thisBooklet.getMessageBoxInfo('Booklets','Booklet created successfully');
					else
						thisBooklet.getMessageBox('Booklets',Status+'!');
					Ext.getCmp('bookletWindow').doClose();
				},
				failure: function(err) {
					initLdgMask.hide();
					Ext.MessageBox.alert('Error occured in ErBookletC servlet');
				}
			});
		}
	},
	validateBooklet:function(newBookletID)
	{
		var thisBooklet = this;
		var bookletvalue = Ext.getCmp('newBookletsId').getValue();
		if(bookletvalue)
		{
			if(newBookletID=="" || newBookletID.length==0)
			{
				thisBooklet.getMessageBox('Booklets','Please enter booklet name!');
				return false;
			}
			if(bookletNameAry.length>0 && bookletNameAry.indexOf(newBookletID)>-1)
			{
				thisBooklet.getMessageBox('Booklets','Booklet name is already exists!');
				return false;
			}
			if(!checkspecial(newBookletID,"`~!@#$%^&*()+={}[]|\\:;\"'<>,.?/"))
			{
				thisBooklet.getMessageBox('Booklets',alertTxtBgrnd);
				return false;
			}
		}
		return true;
	},
	getMessageBox:function(title,msg)
	{
		Ext.MessageBox.show({
			title: title,
			msg: msg,
			cls:'egMsgBox',
			buttons: Ext.MessageBox.OK,
			icon: Ext.MessageBox.WARNING
		});
		return false;
	},
	getMessageBoxInfo:function(title,msg)
	{
		Ext.MessageBox.show({
			title: title,
			msg: msg,
			cls:'egMsgBox',
			buttons: Ext.MessageBox.OK,
			icon: Ext.MessageBox.INFO
		});
		return false;
	 }
});

