Ext.define('optionsfavoritereports.controller.OptionsFavoriteReports',{
	extend:'Ext.app.Controller',
	views:['Main','utilities.TimePeriod'],
	refs:[
		{selector:'main',ref:'main'},
		{selector:'utilitiestool',ref:'utilitiestool'},
		{selector:'emptypanel', ref:'emptypanel'},
		{selector:'resultpanel', ref:'resultpanel'}
	],
	searchTask: new Ext.util.DelayedTask(function(){
		appConstants.appObj.getController('OptionsFavoriteReports').doFilter();
	}),
	init:function(){
		this.control(
		{
			'main':
			{
				'boxready':this.afterMainRender
			},
			'viewport':{
		//		'resize':this.getHei	
			},
			'favoritelistgrid textfield[name="livesearch"]':
			{
					change:this.typewatch
			},
			'favoritelistgrid':{
			//	afterrender:this.getHei
			},
			'favoritelistgrid button[name="DeleteAll"]':
			{
					click:this.deleteFavorites
			},
			'favoritesharinglistgrid button[name="HideReports"]':
			{
					click:this.hideSelectedFavorites
			},
			'favoritesharinglistgrid button[name="showHiddenReports"]':
			{
				click:this.showHiddenFavorites
			}
		});
	},
	getHei:function(){
			
			if(!noFavCongfigured){
			Ext.getCmp('favoriteListGrid').setHeight(Ext.getCmp('optionsfavorite').body.getHeight()-10);
			}
	},
	deleteFavorites : function()
	{
		var grid = Ext.getCmp("favoriteListGrid");
		var favoriteListGridStore = grid.getStore();
		var noOfrecords = favoriteListGridStore.getCount();
		var selectionModelObj = grid.getSelectionModel();
		if ( noOfrecords > 0 )
		{
			var favSelected=false;
			if(selectionModelObj.getSelection().length>0)
				favSelected=true;
			if(favSelected){
				Ext.Msg.show({
					title:'Alert',
					msg:'Are you sure you want to delete selected favorite(s)?',
					buttons: Ext.Msg.YESNO,
					icon: Ext.Msg.QUESTION,
					fn:function(buttonId)
					{
						if(buttonId =="yes")
						{
							var fav_id="";
							var fav_name="";
							var mid = "";
							var selected = selectionModelObj.getSelection();
							if(selected.length>0)
							{
								for(var i=0;i<selected.length;i++)
								{
									var recOrg = selected[i];
									if(i!=0) {
									          fav_name += ","; 
									          fav_id += ',' ;
										  }
									fav_id += recOrg.get('favID');
									mid +='&mid='+encodeURIComponent(recOrg.get('favID'));
									fav_name += recOrg.get('FavoriteName');

 								}
							}
							
							document.location = "/final/servlet/com.eg.ErFavoriteC?fromNavLink="+fromNavLink+"&cmd=Delete&id="+encodeURIComponent(fav_id)+"&fav_name="+encodeURIComponent(fav_name)+mid;
						}
					}
				});
			}
			else{
				Ext.Msg.show({
				title:'Alert',
				 msg: favSelectionMsg,
				buttons: Ext.Msg.OK,
				icon: Ext.Msg.WARNING
			 });
			return;				
			}
		}
	},
	showHiddenFavorites  : function()
	{
		var favoriteSharingListGrid = Ext.getCmp("favoriteSharingListGrid");

		Ext.Msg.show({
			title:'Alert',
			msg:'Are you sure <br/> You want to show Hidden Favorites?',
			buttons: Ext.Msg.YESNO,
			icon: Ext.Msg.QUESTION,
			fn:function(buttonId)
			{
				if(buttonId =="yes")
				{
					document.location = "/final/reporter/ErHiddenFavoritep.jsp?view="+encodeURIComponent(hiddenFavorites);
				}
			}
		});
	},
	hideSelectedFavorites  : function()
	{
		var favoriteSharingListGrid = Ext.getCmp("favoriteSharingListGrid");
		var favoriteSharingListGridStore = favoriteSharingListGrid.getStore();
		var meController = this;
	
		var noOfrecords = favoriteSharingListGridStore.getCount();
		var selectionModelObj = favoriteSharingListGrid.getSelectionModel();
		var selectionArray=favoriteSharingListGrid.getSelectionModel().getSelection();
		var selectionArrayLen=selectionArray.length;
		if (selectionArrayLen> 0 )
		{
			Ext.Msg.show({
				title:'Alert',
				msg:'Are you sure? <br/> You want to hide selected Favorites',
				buttons: Ext.Msg.YESNO,
				icon: Ext.Msg.QUESTION,
				fn:function(buttonId)
				{
					if(buttonId =="yes")
					{
						var fav_id="";
						for (var i = 0; i < noOfrecords; i++) {

							var rec = favoriteSharingListGridStore.getAt(i);
							if(selectionModelObj.isSelected(rec))
							{
								fav_id += rec.get('favID')+","; 
							}
						}
						if (fav_id == "")
						{
							Ext.Msg.show({
											title:'Alert',
											 msg: favSelectionMsg,
											buttons: Ext.Msg.OK,
											icon: Ext.Msg.WARNING
										 });
							return;
						}

						fav_id = fav_id.substring(0,fav_id.length - 1);
						document.location = "/final/reporter/ErViewFavoritep.jsp?view="+encodeURIComponent(fav_id)+"&modify=false";
					}
				}
			});
		}
		else
		{
					 Ext.MessageBox.show({
							title: 'Alert',
							msg: 'Please Select a Favorite',
							buttons: Ext.MessageBox.OK,
							icon: Ext.MessageBox.WARNING
					});
				}
	},
	afterMainRender:function()
	{
		var meController = this;
		try
		{
			if(!Ext.isEmpty(publicJsonData))
			{
				var resultpanel = Ext.getCmp("resultPnl");
				var gridContainer = Ext.getCmp("gridContainer");
				var personalFavTitle = publicJsonData.screenLabels['reporter.common.Personal Favorites'];
				var sharingFavTitle = publicJsonData.screenLabels['reporter.common.Favorites Shared by other Users'];

				var screenLbls = publicJsonData['screenLabels'];
				var recordsPerPage = publicJsonData.pageParams['recordsPerPage'];
				var favGridData = publicJsonData['favGridData'];
				var sharingGridArr = publicJsonData['sharingGridArr'];
				gridContainer.show();
				if(publicJsonData.hasOwnProperty('favGridData') && publicJsonData.hasOwnProperty('sharingGridArr'))
				{
					if(sharingGridArr!=undefined && sharingGridArr.length>0)
						recordsPerPage=7;
				}
				if(!Ext.isEmpty(favGridData))
				{
					noFavCongfigured=false;
					gridContainer.add({
						xtype: 'favoritelistgrid',
						dataArray :favGridData,
						pageLimit : recordsPerPage,
						//title : personalFavTitle,
						screenLabels : screenLbls
					});
					Ext.getCmp('livesearch').focus(true, 500);
				}
				else //if (!publicJsonData.hasOwnProperty('sharingGridArr') && Ext.isEmpty(sharingGridArr))
				{
 					noFavCongfigured=true;
					var errorMsg = publicJsonData.screenLabels['errorMsg'];
					if(!Ext.isEmpty(errorMsg))
					{
						gridContainer.add({
							xtype:'panel',
							//cls:'datapanel',
							ui:'newGraphPanel',
							title : personalFavTitle,
							margin:10,
							flex:1,
							html: '<table width="100%" height="100%"><tr><td align="center" valign="middle"><div class="iconInformation" ></div><div class="commonErrorMsgText">'+errorMsg+'</div></td></tr></table>'
						});
					}
				}
				hiddenFavorites = publicJsonData.hiddenParams['hidden_view_name'];
				var sharingGridArr = publicJsonData['sharingGridArr'];
				var sharingErrorMsg = publicJsonData.screenLabels['sharingErrorMsg'];
				if(!Ext.isEmpty(sharingGridArr) && Ext.isEmpty(hiddenFavorites))
				{
					noFavCongfigured=false;
					gridContainer.add({
						xtype: 'favoritesharinglistgrid',
						dataArray :sharingGridArr,
						pageLimit : recordsPerPage,
						title : sharingFavTitle,
						screenLabels : screenLbls
					});
					Ext.getCmp('showHiddenReports').hide();
					Ext.getCmp('HideReports').show();
				}
				if(!Ext.isEmpty(sharingGridArr) && !Ext.isEmpty(hiddenFavorites))
				{
					noFavCongfigured=false;
					gridContainer.add({
						xtype: 'favoritesharinglistgrid',
						dataArray :sharingGridArr,
						pageLimit : recordsPerPage,
						title : sharingFavTitle,
						screenLabels : screenLbls
					});
					Ext.getCmp('showHiddenReports').show();
					Ext.getCmp('HideReports').show();
				}
				else if (publicJsonData.hasOwnProperty('sharingGridArr') && Ext.isEmpty(sharingGridArr) && !Ext.isEmpty(sharingErrorMsg))
				{
					gridContainer.add({
										xtype:'panel',
										title : sharingFavTitle,
										margin:'0 10 10 10',
										cls:'datapanel',
										flex:1,
										style:{'text-align':'center'},
										tbar:[
													{
														xtype : 'button',
														id : 'showHiddenReports1',
														ui:'newButtonSmall',
														margin:5,
														name : 'showHiddenReports1',
														text : screenLbls["reporter.common.Show Hidden Favorites"],
														listeners : {
															click : function()
															{
																meController.showHiddenFavorites();
															}
														}
													}
										],
										html: '<table width="100%" height="100%"><tr><td align="center" valign="middle"><div class="iconExclamation" ></div><div class="commonErrorMsgText">'+sharingErrorMsg+'</div></td></tr></table>'
							});
				}
			}
		}
		catch ( e )
		{
			alert('[Exception] @ afterMainRender Ajax '+e);
		}
		initLoadMask.hide();
			
	},
	typewatch:function(field, event){
  		 this.searchTask.delay(1000);
	},
	doFilter:function( ){
		
		var field=Ext.getCmp('livesearch');
		var dummyArray=Ext.getCmp('favoriteListGrid').dummyArray;
		var dataArray=Ext.getCmp('favoriteListGrid').dataArray;
		if(Ext.String.trim(field.value).length > 0 && (Ext.String.trim(field.value) != '' || Ext.String.trim(field.value) != null))
		{
			Ext.getCmp('favoriteListGrid').getStore().removeAll();
			var regex = RegExp(field.value, 'i');
			//var regex = RegExp(field.value, 'i');
			dataArray.splice(0, dataArray.length);
			for(var key in dummyArray)
			{
				var match = false;
				var obj=dummyArray[key];
				//var value=obj.ReportName;
					Ext.Object.each(obj, function (property, value) {
						match =match || regex.test(String(value));
					});
				if(match)
					dataArray.push(obj);
			}
			Ext.getCmp('favoriteListGrid').getStore().load();
		}
		else{
			Ext.getCmp('favoriteListGrid').getStore().removeAll();			
			dataArray.splice(0, dataArray.length);
			for(var key in dummyArray)
			{
				var obj=dummyArray[key];
				dataArray.push(obj);
			}
			Ext.getCmp('favoriteListGrid').getStore().loadRawData(dataArray);
			Ext.getCmp('favoriteListGrid').getStore().load();
		}
		field.focus();
		field.toggleTriggger();		
		
	}
});

