
Ext.define('optionsfavoritereports.view.FavoriteList',{
		extend:'utilities.CustomGrid',
		requires:['Ext.ux.grid.FiltersFeature','Ext.ux.data.PagingMemoryProxy', 'utilities.CustomGrid'],
		alias:'widget.favoritelistgrid',
		id:'favoriteListGrid',
		//cls:'gridSkin favapp',
		ui:'newGridPanel withHeader withShade',
		border:true,
		autoScroll: false,
		scroll: false,
		screenLabels:null,
		dataArray : null,		
		dummyArray : null,		
		pageLimit: 2,
		activePage:1,
		//height:Ext.getCmp().getViewSize().height ,
		flex:1,
		margin:10,
		padding:10,
		viewConfig: {
			emptyText : '<table width="100%"><tr><td align="center" valign="middle"><div class="iconExclamation" style="margin:18% auto 0% auto"></div><div style="font-size:12px">No records<div></td></tr></table>'
		},
		initComponent:function(){
			var filters = {
			ftype: 'filters',
			// encode and local configuration options defined previously for easier reuse
			encode: false, // json encode the filter query
			local: true,   // defaults to false (remote filtering)
			filters: [ // Filters are most naturally placed in the column definition, but can also be // added here.
				{
					dataIndex:'FavoriteName',
					type : 'string'
				},
				{
					dataIndex:'ReportType',
					type : 'string'
					
				},
				{
					dataIndex:'CreationTime',
					type : 'string'
					
				}
			]
			 };
			this.features= [filters];			

			this.addListener('viewready',this.showGridCellToolTip,this);
			this.selModel  = new Ext.selection.CheckboxModel(
				{
					checkOnly: true,
					width:45,
					injectCheckbox: 'first'
				});
				this.dummyArray=this.dataArray.slice();

			this.store = Ext.create('Ext.data.Store', {
				 fields: ['FavoriteName','favID','favHrefUrl','ReportType','CreationTime','ModifyLink','modifyHrefUrl','ScheduleLink','scheduleHrefUrl'],
				proxy : {
					type : 'pagingmemory',
					reader : {
						type : 'json'
					}
				},
				pageSize:this.pageLimit,
				autoLoad : true,
				data : this.dataArray,
				//remoteSort: true,
				id: 'tmpStore'
			});
			
			this.columns = [
							{
								dataIndex:'FavoriteName',
								header:this.screenLabels["reporter.common.FAVORITE NAME"],
								sortable :true,
								flex:2,
								renderer :function(value, metaData, record, row, col, store, gridView)
								{
									var dispVal = value;
									/*due to now we are not give support angle bracket(><)in favorite name
									if(value!=null){
										if(value.indexOf("<")!=-1){
													var Re = new RegExp("\\<","g");
													value = value.replace(Re,'&lt;');
										}
										if(value.indexOf(">")!=-1){
											var Re = new RegExp("\\>","g");
											value = value.replace(Re,'&gt;');
										}
									}*/
									var hrefUrl = record.get('favHrefUrl');
									hrefUrl = hrefUrl+'&com.eg.CSRF_NONCE='+csrfToken;
									if(!Ext.isEmpty(hrefUrl) && hrefUrl!="-")
									{
										dispVal = '<a href="'+hrefUrl+'">'+value+'</a>';
									}
									return dispVal;
								}
							},
							{
								dataIndex:'ReportType',
								header:this.screenLabels["reporter.common.REPORT TYPE"],
								flex:2 ,
								sortable :true,
								renderer :function(value, metaData, record, row, col, store, gridView)
								{
										return value;
								}
							},
							{
								dataIndex:'CreationTime',
								header:this.screenLabels["reporter.common.CREATION TIME"],
								flex:0.75,
								sortable :false,
								align:'center',
								renderer :function(value, metaData, record, row, col, store, gridView)
								{
									return value;
								}
							},
							{
								xtype: 'actioncolumn',
								sortable:false,
								menuDisabled:true,
							//	icon : '/final/images/pencil_gray.png',
								style:{'border':'0px'},
								flex:0.1,
								align:'center',
								//tooltip:'Modify',
								/*listeners: {
															afterrender: function () {
																Ext.create('Ext.tip.ToolTip', {
																	target: this.id,
																	anchor: 'top',
																	cls: 'yellowTip',
																	trackMouse: true,
																	html: 'Modify'
																});
															}
														},*/
								dataIndex:'ModifyLink',
								header:'',
								renderer :function(value, metaData, record, row, col, store, gridView)
								{
									//var dispVal = value;
									//metaData.tdAttr = 'data-qclass=yellowTip data-qtip="Modify" style="margin-top:2px"';
									var hrefUrl = record.get('modifyHrefUrl');
									hrefUrl = hrefUrl+'&com.eg.CSRF_NONCE='+csrfToken;

									var dispVal = '<a href="'+hrefUrl+'"><img src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" class="iconModify"/></a>';
									
//													this.on('click',function(){	document.location=hrefUrl; });
									return dispVal;
								}
							},
							{
								xtype: 'actioncolumn',
								sortable:false,
								menuDisabled:true,
								/*listeners: {
															afterrender: function () {
																Ext.create('Ext.tip.ToolTip', {
																	target: this.id,
																	anchor: 'top',
																	cls: 'yellowTip',
																	trackMouse: true,
																	html: 'Schedule'
																});
															}
														},*/
							//	icon : '/final/images/schedule-single-icon.png',
								flex:0.1,
								align:'center',
								//tooltip:'Schedule',
								dataIndex:'ScheduleLink',
								header:'',
								renderer :function(value, metaData, record, row, col, store, gridView)
								{
									//var dispVal = value;
									//metaData.tdAttr = 'data-qclass=yellowTip data-qtip="Add to Schedule" style="margin-top:2px"';
									var hrefUrl = record.get('scheduleHrefUrl');
									hrefUrl = hrefUrl+'&com.eg.CSRF_NONCE='+csrfToken;
									var dispVal = '<a href="'+hrefUrl+'&showSchWindow=no"><img src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" class="iconSchedule"/></a>';
									return dispVal;
									//this.on('click',function(){	document.location=hrefUrl; });
								}
							}
							
						];

			var meGrid = this;

			this.dockedItems=[{
				xtype:'pagingtoolbar',
				cls:'newPagination',
				dock: 'bottom',
				displayInfo: true,
				id:'FavListPaging',
				name:'FavListPaging',
				pageSize:this.pageLimit,
				store: this.store,
				displayInfo: true,
				displayMsg: 'Displaying topics {0} - {1} of {2}',
				emptyMsg: "No topics to display",
				listeners: {
					change : function(thisd, params)
					{   
						if(!Ext.isEmpty(params))						
							meGrid.activePage = params.currentPage;
						else
							meGrid.activePage=0;
					}
				}
			},{
				xtype:'toolbar',
				//width:900,
				//cls:'toolbar',
				items:[
				{

					xtype:'customtrigger',
					//labelStyle: 'white-space: nowrap',
					//fieldLabel:this.screenLabels["reporter.common.Search Favorites"],
					//labelSeparator : '',
					//cls: 'whitedropdown_search',
					//labelAlign:'left',
					name: 'livesearch',
					id: 'livesearch',
					//labelWidth:50,
					//padding:6,
					width:300,
					dock:'top',
					enableKeyEvents: true

/*
					xtype:'textfield',
					fieldLabel:this.screenLabels["reporter.common.Search Favorites"],
					//labelAlign:'left',
					id :'livesearch',
					name: 'livesearch',
					labelWidth:100,
					padding:'5',
					width:320,
					dock:'top',
					cls:'textbox',
					enableKeyEvents: true
*/


				},'->',
				{
					xtype:'container',
					items:[{
						xtype : 'button',
						id : 'DeleteAll',
						ui:'newButtonSmall',
						margin:'0 0 0 0',
						name : 'DeleteAll',
						text : 'Delete'
					}]
				} 	
				
				]
			}
		]

		var sharingGridArr = publicJsonData['sharingGridArr'];

		/*if(!Ext.isEmpty(sharingGridArr))
		{
			this.height =  (Ext.getCmp('optionsfavorite').body.getHeight() - 10)/2;
		}
		else
		{
			this.height = Ext.getCmp('optionsfavorite').body.getHeight()-10;
		}*/
		this.callParent();
	},
	listeners:{
		sortchange:function(ct, column, e, t, eOpts ){
			 this.getStore().loadPage(this.activePage);					
		},
	}
});
