Ext.define('optionsfavoritereports.view.FavoriteSharingList',{
		extend:'utilities.CustomGrid',
		requires:['Ext.ux.grid.FiltersFeature','Ext.ux.data.PagingMemoryProxy'],
		alias:'widget.favoritesharinglistgrid',
		id:'favoriteSharingListGrid',
	//	cls:'gridSkin',
		ui:'newGridPanel withHeader withShade',
		border:true,
		screenLabels:null,
		dataArray : null,
		dummyArray : null,
		pageLimit: 2,
		margin:'0 10 10 10',
		padding:'0 10 10 10',
		flex:1,
		emptyText:'',
		activePage:1,
		initComponent:function(){
			var filters = {
			ftype: 'filters',
			// encode and local configuration options defined previously for easier reuse
			encode: false, // json encode the filter query
			local: true,   // defaults to false (remote filtering)
			filters: [ // Filters are most naturally placed in the column definition, but can also be // added here.
				{
					dataIndex:'FavoriteName',
					type : 'string'
				},
				{
					dataIndex:'userName',
					type :'string'
				}, 
				{
					dataIndex:'ReportType',
					type : 'string'
					
				},
				{
					dataIndex:'CreationTime',
					type : 'string'
					
				}
			]
			 };
			this.features= [filters];			

			
			this.selModel  = new Ext.selection.CheckboxModel(
				{
					checkOnly: true,
					width:45,
					injectCheckbox: 'first'
				});

				this.dummyArray=this.dataArray.slice();
			this.store = Ext.create('Ext.data.Store', {
				 fields: ['FavoriteName','favID','favSharingHrefUrl','userName','ReportType','CreationTime'],
				proxy : {
					type : 'pagingmemory',
					reader : {
						type : 'json'
					}
				},
				pageSize:this.pageLimit,
			//autoLoad : true,
				data : this.dataArray,
				//remoteSort: true,
				id: 'tmpStore'
			});
			
			this.columns = [
							{
								dataIndex:'FavoriteName',
								header:this.screenLabels["reporter.common.FAVORITE NAME"] ,
								sortable :true,
								flex:2,
								renderer :function(value, metaData, record, row, col, store, gridView)
								{
									var dispVal = value;
									var hrefUrl = record.get('favSharingHrefUrl');
									if(!Ext.isEmpty(hrefUrl) && hrefUrl!="-")
									{
										dispVal = '<a href="'+hrefUrl+'">'+value+'</a>';
									}
									return dispVal;
								}
							},
							{
								dataIndex:'userName',
								header:this.screenLabels["reporter.common.SHARED BY"],
								flex:2 ,
								sortable :true,
								renderer :function(value, metaData, record, row, col, store, gridView)
								{
										return value;
								}
							},
							{
								dataIndex:'ReportType',
								header:this.screenLabels["reporter.common.REPORT TYPE"],
								flex:1 ,
								sortable :true,
								renderer :function(value, metaData, record, row, col, store, gridView)
								{
										return value;
								}
							},
							{
								dataIndex:'CreationTime',
								header:this.screenLabels["reporter.common.CREATION TIME"],
								flex:0.75,
								sortable :false,
								align:'center',
								renderer :function(value, metaData, record, row, col, store, gridView)
								{
									return value;
								}
							}
						];

			var meGrid = this;

			this.dockedItems=[{
				xtype:'pagingtoolbar',
				cls:'newPagination',
				dock: 'bottom',
				displayInfo: true,
				id:'FavSharingListPaging',
				name:'FavSharingListPaging',
				pageSize:this.pageLimit,
				store: this.store,
				displayInfo: true,
				displayMsg: 'Displaying topics {0} - {1} of {2}',
				emptyMsg: "No topics to display",
				listeners: {
					change : function(thisd, params)
					{   
						if(!Ext.isEmpty(params))						
							meGrid.activePage = params.currentPage;
						else
							meGrid.activePage=0;
					}
				}
			},{
				xtype:'toolbar',
				//width:900,
				cls:'toolbar',
				items:[
			/*	{
					xtype:'textfield',
					fieldLabel:'Search',
					//labelAlign:'left',
					name: 'livesearch',
					labelWidth:50,
					padding:'5',
					width:300,
					dock:'top',
					enableKeyEvents: true
				}*/
				{
					xtype:'container',
					items:[
						{
							xtype : 'button',
							id : 'showHiddenReports',
							ui:'newButtonSmall',
							margin:5,
							hidden:true,
							name : 'showHiddenReports',
							text : this.screenLabels["reporter.common.Show Hidden Favorites"]
						},
						{
							xtype : 'button',
							id : 'HideReports',
							ui:'newButtonSmall',
							name : 'HideReports',
							text : this.screenLabels["reporter.common.Hide Selected Favorites"]
						}
					]
				}]
			}
		]
			//this.height =  (Ext.getCmp('optionsfavorite').body.getHeight() - 10)/2;
			this.callParent();
		},
		listeners:{
					sortchange:function(ct, column, e, t, eOpts ){
						console.log("yyyyyyyyy   "+this.activePage);
						 this.getStore().loadPage(this.activePage);					
					},
		}
});