var cellEditing = Ext.create('Ext.grid.plugin.CellEditing', {
	clicksToEdit: 1,
	id: 'cellEditingPlugin',
});

Ext.define('optionsscheduleconfigreports.view.BookletListGrid', {

	extend: 'Ext.grid.Panel',
	alias: 'widget.bookletgrid',
	id: 'bookletgridID',
	//cls:'gridSkin backgrdgrid space favapp noShadow', // noShadow noShadowNoHeader
	ui:'newGridPanel withHeader',
	border: true,
	frame:false,
   	title: 'Schedule Details',
	listeners:
	{
		edit: function(editor, e)
		{
			e.grid.store.save();
		},
	    cellclick: function(grid, rowIndex, cellIndex, e)
		{
			var sc_id = e.data.sID;
			var isHomePage = e.data.isHomePage;
			if (cellIndex == 1)
			{

			}
			else if (cellIndex == 3)
			{
				if(isHomePage!=undefined && isHomePage == 'true')
				{
					return;
				}
				var urlForView = "../servlet/com.eg.ErSchedulerC?cmd=Show&id=" + sc_id + "&fromFavSch=true&enableBack=true&backServletName=/servlet/com.eg.ErSchedulerC?";
				document.location = urlForView;
			}
			else if (cellIndex == 4)
			{
				if(isHomePage!=undefined && isHomePage == 'true')
				{
					return;
				}
				var urlForView = "../servlet/com.eg.ErSchedulerC?cmd=excecute&id=" + sc_id + "&fromFavSch=true&enableBack=true&com.eg.CSRF_NONCE="+csrfToken+"&backServletName=/servlet/com.eg.ErSchedulerC?";
				document.location = urlForView;
			}
        }
	},
	store: new Ext.data.Store({
            fields: ['sID', 'scheduleNme', 'scheduleMailFormat','isCsvEnable','isHomePage'],
            data: []
        }),
	selModel: new Ext.selection.CheckboxModel ({
            checkOnly: true,
            headerWidth:25,
            injectCheckbox: 'first'
        }),
    columns:[
		{
			header:'SCHEDULE NAME',
			dataIndex: 'scheduleNme',
			flex: 1,
			editor: 
			{
				xtype: 'textfield',
				allowBlank: false,
				maxLength:32,
				enforceMaxLength: true,
			},
			renderer:function(value, metaData, record, row, col, store, gridView)
			{
				metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+value+'"';
				return value;
			}
		},
		{
			header: 'TYPE',
			dataIndex: 'scheduleMailFormat',
			//flex: 1,
			width:100,
			renderer:function(value, metaData, record, row, col, store, gridView)
			{
				metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+value+'"';
				var format = record.data.scheduleMailFormat;
				if(format == 'PDF' || format == 'CSV')
				{
					value = '<div style="position:relative;line-height:100%;margin: 0px auto;top:6px;display:inline">'+value+'<img src="../images/clear.png" style="margin-left:5px;float:right;margin-top:2px" class="iconDropDownArrow"/></div>'
				}
				if(value=='null' || value==null)
				{
					value='PDF';
					metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+value+'"';
				}
				return value;
			},
			getEditor: function(record)
			{
				var isCsvEnable = record.data.isCsvEnable;
				var dataAty = new Array()
				if(isCsvEnable == 'yes')
				{
					dataAty.push({'type': 'CSV','name': 'CSV'}, {'type': 'PDF','name': 'PDF'});
				}
				else
				{
					dataAty.push({'type': 'PDF','name': 'PDF'});
				}
				return Ext.create('Ext.grid.CellEditor', {
					autoSize: {
						//width: '60', // Width from the field
						//height: '21' // Height from the boundEl
					},
					width:91,
					offsets: [3,1],
					field: Ext.create( 'Ext.form.field.ComboBox', {
						xtype: 'scrollcombo',
						cls: 'dropdown cellEditCombo',
						style:{
							//'margin':'1 0 2 0',
						},
						editable:false,
						store: new Ext.data.Store({
							fields: ['type', 'name'],
							data: dataAty,
						}),
						displayField: 'name',
						valueField: 'type',
						queryMode: 'local',
					})
				})
			}
		},
		{
			header: '',
			width:35,
			renderer:function(v, m, r)
			{
				//return '<div class="iconModify"  style="cursor:pointer"></div>';
				var cls = 'iconModify';
				var cursor = 'pointer';
				if (r.get('isHomePage')!=undefined && r.get('isHomePage')=='true')
				{
					cls = 'iconModifyDisabled';
					cursor = '';
				}
				return '<div  data-qtip="Modify" data-qclass="yellowTip" style="cursor:'+cursor+';position:relative;height:18px;margin: 0px auto;top:2px;" class="'+cls+'"   ></div>';
			}
		},
		{
			header: '',
			width :35,
			renderer:function(value, metaData, record, row, col, store, gridView)
			{
				var cls = 'iconScheduleBinderView';
				var cursor = 'pointer';
				if (record.get('isHomePage')!=undefined && record.get('isHomePage')=='true')
				{
					cls = 'iconScheduleBinderViewDisabled';
					cursor = '';
				}
				value = '<div  data-qtip="View" data-qclass="yellowTip" style="cursor:'+cursor+';position:relative;height:18px;margin: 0px auto;top:2px;" class="'+cls+'"></div>';
				return value;
			}
		},
		{
			header: '<div style="margin-top:-2px;cursor:pointer" id="removeAllBinder" class="iconRemoveAllFromScheduleBinder" data-qclass="yellowTip" data-qtip="Remove all from booklet"></div>',
			xtype : 'actioncolumn',
			sortable :false,
			height:20,
			width :35,
			dataIndex : 'remove',//..
			renderer:function(value, metaData, record, row, col, store, gridView)
			{
				value = '<div  data-qtip="Remove from booklet" data-qclass="yellowTip" style="cursor:pointer;position:relative;height:18px;margin: 0px auto;top:2px;" class="iconRemoveFromScheduleBinder"   ></div>';
				return value;
			},
			listeners :
			{
				'click':function(grid, htmlRow, index, columnIndex,mouseEvent, record)
				{
					var needDeleteWinRec = false;
					if(grid.getStore().getCount()==1)
						needDeleteWinRec = true;
					Ext.Msg.show({
						title: 'Alert',
						msg: 'Are you sure you want to remove the schedule(s)?',
						buttons: Ext.Msg.YESNO,
						icon: Ext.Msg.QUESTION,
						fn: function(buttonId)
						{
							if (buttonId == "yes")
							{
								var params ='cmd=remove&removeIDs='+record.data.sID;
								Ext.Ajax.request({
									url: '../servlet/com.eg.ErScheduleBookletModifyC',
									method: 'POST',
									params: params,
									success: function(response)
									{
										try
										{
											if (response.status == 200)
											{
												grid.getStore().remove(record);
												appConstants.appObj.getController(appConstants.appController).gridRefresh(needDeleteWinRec);
											}
										}
										catch (e)
										{
											alert(e);
										}
									}
								});
							}
						}
					});
				}
			}
		},
		{
			header: '<div style="margin-top:-2px;cursor:pointer" id="removeAllSchedule" class="iconDeleteAll2" data-qclass="yellowTip" data-qtip="Delete all form system"></div>',
			xtype : 'actioncolumn',
			sortable :false,
			height:20,
			width :35,
			dataIndex : 'delete',//..
			renderer:function(value, metaData, record, row, col, store, gridView)
			{
				value = '<div  data-qtip="Delete from system" data-qclass="yellowTip" style="cursor:pointer;position:relative;margin: 0px auto;" class="iconDelete2"></div>';
				return value;
			},
			listeners :
			{
				'click':function(grid, htmlRow, index, columnIndex,mouseEvent, record)
				{
					var needDeleteWinRec = false;
					if(grid.getStore().getCount()==1)
						needDeleteWinRec = true;
					 Ext.Msg.show({
						title: 'Alert',
						msg: 'Are you sure you want to delete the schedule(s)?',
						buttons: Ext.Msg.YESNO,
						icon: Ext.Msg.QUESTION,
						fn: function(buttonId)
						{
							if (buttonId == "yes")
							{
								var params ='cmd=delete&deleteIDs='+record.data.sID;
								Ext.Ajax.request({
									url: '../servlet/com.eg.ErScheduleBookletModifyC',
									method: 'POST',
									params: params,
									success: function(response) {
										try
										{
											if (response.status == 200)
											{
												grid.getStore().remove(record);
												appConstants.appObj.getController(appConstants.appController).gridRefresh(needDeleteWinRec);
											}
										}
										catch (e)
										{
											alert(e);
										}
									}
								});
							}
						}
					});
				}
			}
		}
	],
    plugins: cellEditing
});