Ext.define('optionsscheduleconfigreports.view.ScheduleConfig',{
		extend:'utilities.CustomGrid',
		requires:['Ext.ux.grid.FiltersFeature','Ext.ux.data.PagingMemoryProxy','utilities.CustomGrid'],
		alias:'widget.scheduleconfiggrid',
		id:'scheduleConfigGrid',
		//cls:'gridSkin favapp noShadow',
		ui:'newGridPanel withShade',
		border:true,
		screenLabels:null,
		dataArray : null,
		dummyArray : null,
		pageLimit: 2,
		activePage:1,
		margin:10,
		viewConfig:
		{
			emptyText : '<table width="100%" border="0px" height="95%"><tr><td align="center" valign="middle"><div class="iconExclamation" ></div><div class="font_normal11">No records found<div></td></tr></table>'
		},
		initComponent:function(){
			var filters = {
				ftype: 'filters',
				// encode and local configuration options defined previously for easier reuse
				encode: false, // json encode the filter query
				local: true,   // defaults to false (remote filtering)
				filters: [ // Filters are most naturally placed in the column definition, but can also be // added here.
					{
						dataIndex:'scheduleName',
						type : 'string'
					},
					{
						dataIndex:'reportName',
						type : 'string'

					},
					{
						dataIndex:'mailFrequency',
						type : 'string'
					},
					{
						dataIndex:'printFrequency',
						type : 'string'
					},
					{
						dataIndex:'creationTime',
						type : 'string'
					}
				]
			};
			this.features= [filters];
			this.selModel  = new Ext.selection.CheckboxModel(
				{
					checkOnly: true,
					headerWidth:28,
					injectCheckbox: 'first',
					listeners:
					{
						selectionchange:function()
						{
							var selectionModelObj = Ext.getCmp('scheduleConfigGrid').getSelectionModel();
							var count = selectionModelObj.getSelection().length;
							if(count>0)
								Ext.getCmp('GroupItContainer').update('<div data-qtip="Combine schedules" data-qclass="yellowTip" id="circleId" class="scheduleCircle">'+count+'</div><div data-qtip="Combine schedules" data-qclass="yellowTip"  id="GroupIt" style="cursor:pointer;margin:2px 0px 0px 10px" class="iconReportNotBinded"></div>',true, true);
							else if(count==0)
								Ext.getCmp('GroupItContainer').update('<div data-qtip="Combine schedules" data-qclass="yellowTip" id="GroupIt" style="cursor:pointer;margin:2px 0px 0px 10px" class="iconReportNotBinded"></div>',true, true);
						}
					}
				});

				this.dummyArray=this.dataArray.slice();
				this.store = Ext.create('Ext.data.Store', {
				 fields: ['sch_id','scheduleName','scheduleUrl','reportName','mailFrequency','printFrequency','creationTime','needToMerge'],
				proxy : {
					type : 'pagingmemory',
					reader :
					{
						type : 'json'
					}
				},
				pageSize:this.pageLimit,
				autoLoad : true,
				data : this.dataArray,
				id: 'tmpStore'
			});

			this.columns = [
				{
					dataIndex:'scheduleName',
					header:this.screenLabels["reporter.common.SCHEDULE NAME"],
					sortable :true,
					flex:1,
					renderer :function(value, metaData, record, row, col, store, gridView)
					{
						var dispVal = value;
						metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+dispVal+'"';
						metaData.style = 'cursor: pointer;';
						var hrefUrl = record.get('scheduleUrl');
						if(hrefUrl.indexOf('ErScheduleBookletView.jsp')>-1)
						{
							dispVal = '<table cellpadding="0" cellspacing="0" border="0"><tr><td class="font_normal11" style="padding-top:0px;">'+dispVal+'</td><td style="float:left;margin-left:5px;margin-top:0px;" class="iconReportBinded"></td></tr></table>'

						}
						return dispVal;
					},
					listeners :
					{
						'click':function(grid, htmlRow, index, columnIndex,mouseEvent, record)
						{
							var hrefUrl = record.get('scheduleUrl');
							var me = appConstants.appObj.getController(appConstants.appController);
							hrefUrl = hrefUrl+'&com.eg.CSRF_NONCE='+csrfToken
							console.log(hrefUrl);
							if(hrefUrl.indexOf('ErScheduleBookletView.jsp')>-1)
							{
								hrefUrl = hrefUrl.substring(hrefUrl.indexOf('?')+1,hrefUrl.length);
								var dataVal = hrefUrl.split('&');
								appConstants.scheduleBookletID  = dataVal[0].substring(dataVal[0].indexOf('=')+1,dataVal[0].length);
								appConstants.sbNme  = dataVal[1].substring(dataVal[1].indexOf('=')+1,dataVal[1].length);
								Ext.widget('customwindow');
								me.getCustomwindow().show();
								var mergeType = Ext.getCmp('merge_type_pop');
								if(record.get('needToMerge')=='yes'||record.get('needToMerge')=='Yes')
									mergeType.setValue('yes');
								Ext.getCmp('windowInnerPanel').setTitle(record.data['scheduleName']);
								windowRec=record;
							}
							else
							{
								window.location=hrefUrl;
							}
						}
					}
				},
				{
					dataIndex:'reportName',
					header:this.screenLabels["reporter.common.REPORT TYPE"],
					flex:1,
					sortable :true,
					renderer :function(value, metaData, record, row, col, store, gridView)
					{
							metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+value+'"';
							return value;
					}
				},
				{
					dataIndex:'mailFrequency',
					header:this.screenLabels["reporter.common.MAIL"],
					width :90,
					sortable :false,
					align:'center',
					renderer :function(value, metaData, record, row, col, store, gridView)
					{
						metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+value+'"';
						return value;
					}
				},
				{
					dataIndex:'printFrequency',
					header:this.screenLabels["reporter.common.PRINT"],
					width :90,
					sortable :false,
					align:'center',
					renderer :function(value, metaData, record, row, col, store, gridView)
					{
						metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+value+'"';
						return value;
					}
				},
				{
					dataIndex:'creationTime',
					header:this.screenLabels["reporter.common.CREATION TIME"],
					width :150,
					sortable :false,
					align:'center',
					renderer :function(value, metaData, record, row, col, store, gridView)
					{
						metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+value+'"';
						return value;
					}
				},
				{
					header: '<div style="cursor:pointer" id="editSchedule" class="" data-qclass="yellowTip" data-qtip="Remove All"></div>',
					xtype : 'actioncolumn',
					sortable :false,
					height:20,
					width :35,
					//dataIndex : 'Edit Schedule',//..
					renderer :function(value, metaData, record, row, col, store, gridView)
					{
						var dispVal = value;
						var hrefUrl = record.get('scheduleUrl');
						if(hrefUrl.indexOf('ErScheduleBookletView.jsp')>-1)
						{
							dispVal = '<div  data-qtip="Edit Booklet Schedule" data-qclass="yellowTip" style="cursor:pointer;" class="iconReportBinded"></div>';
						}
						else
						{
							dispVal = '<div  data-qtip="Edit Schedule" data-qclass="yellowTip" style="cursor:pointer;" class="iconModify"></div>';
						}
						return dispVal;
					},
					listeners :
					{
						'click':function(grid, htmlRow, index, columnIndex,mouseEvent, record)
						{
							var hrefUrl = record.get('scheduleUrl');
							var me = appConstants.appObj.getController(appConstants.appController);
							hrefUrl = hrefUrl+'&com.eg.CSRF_NONCE='+csrfToken
							console.log(hrefUrl);
							if(hrefUrl.indexOf('ErScheduleBookletView.jsp')>-1)
							{
								hrefUrl = hrefUrl.substring(hrefUrl.indexOf('?')+1,hrefUrl.length);
								var dataVal = hrefUrl.split('&');
								appConstants.scheduleBookletID  = dataVal[0].substring(dataVal[0].indexOf('=')+1,dataVal[0].length);
								appConstants.sbNme  = dataVal[1].substring(dataVal[1].indexOf('=')+1,dataVal[1].length);
								Ext.widget('customwindow');
								me.getCustomwindow().show();
								var mergeType = Ext.getCmp('merge_type_pop');
								if(record.get('needToMerge')=='yes'||record.get('needToMerge')=='Yes')
									mergeType.setValue('yes');
								Ext.getCmp('windowInnerPanel').setTitle(record.data['scheduleName']);
								windowRec=record;
							}
							else
							{
								window.location=hrefUrl;
							}
						}
					}
				},
				{
					header: '<div style="cursor:pointer" id="removeAll" class="iconDeleteAll" data-qclass="yellowTip" data-qtip="Remove All"></div>',
					xtype : 'actioncolumn',
					sortable :false,
					height:20,
					width :35,
					dataIndex : 'remove',//..
					renderer:function(value, metaData, record, row, col, store, gridView)
					{
						metaData.tdAttr = 'data-qclass=yellowTip data-qtip="'+value+'"';
						value = '<div  data-qtip="Remove" data-qclass="yellowTip" style="cursor:pointer;position:relative;height:18px;margin: 0px auto;top:2px;" class="iconDelete"   ></div>';
						return value;
					},
					listeners :
					{
						'click':function(grid, htmlRow, index, columnIndex,mouseEvent, record)
						{
							Ext.Msg.show({
								title: 'Alert',
								msg: 'Are you sure you want to remove the schedule?',
								buttons: Ext.Msg.YESNO,
								icon: Ext.Msg.QUESTION,
								fn: function(buttonId)
								{
									if (buttonId == "yes")
									{
										var mid ='&mid='+encodeURIComponent(record.data.sch_id);
										document.location = "/final/servlet/com.eg.ErSchedulerC?fromNavLink="+fromNavLink+"&cmd=Delete&id="+encodeURIComponent(record.data.sch_id)+"&sch_name="+encodeURIComponent(record.data.scheduleName)+mid;
									}
								}
							});
						}
					}
				}
			];

			var meGrid = this;

			this.dockedItems=[{
				xtype:'pagingtoolbar',
				cls:'newPagination',
				dock: 'bottom',
				displayInfo: true,
				id:'schedulePaging',
				name:'schedulePaging',
				pageSize:this.pageLimit,
				store: this.store,
				displayInfo: true,
				displayMsg: 'Displaying topics {0} - {1} of {2}',
				emptyMsg: "No topics to display",
				listeners: {
					change : function(thisd, params)
					{
						if(!Ext.isEmpty(params))
							meGrid.activePage = params.currentPage;
						else
							meGrid.activePage=0;
					}
				}
			},
			{
				xtype:'toolbar',
				cls:'toolbar',
				height:30,
				padding:'0 0 7 0',
				items:[
				'->',
				{
					xtype: 'container',
					html:'<div data-qtip="Combine schedules" data-qclass="yellowTip" id="GroupIt" style="cursor:pointer;margin-left:10px;margin-top:2px;" class="iconReportNotBinded"></div>',
					id:'GroupItContainer',
					listeners:
					{
						click:
						{
							element: 'el', //bind to the underlying el property on the panel
							fn: function()
							{
								appConstants.appObj.getController(appConstants.appController).groupIt();
							}
						}
					}
				},
				{
					xtype:'tbseparator',
					margin:'0 10 0 5',
					height:25
				},
				{
					xtype:'customtrigger',
					id :'livesearch',
					name: 'livesearch',
					width:180,
					dock:'top',
					enableKeyEvents: true
				}
				]
			}
		]
		this.callParent();
	},
	listeners:
	{
		sortchange:function(ct, column, e, t, eOpts )
		{
			 this.getStore().loadPage(this.activePage);
		}
	}
});