Ext.define('optionsscheduleviewreports.controller.OptionsScheduleConfigView',{
	extend:'Ext.app.Controller',
	views:['Main'],
	refs:[
		{selector:'main',ref:'main'},
		{selector:'optionsscheduleviewform',ref:'optionsscheduleviewform'},
		{selector:'scheduleviewgrid',ref:'scheduleviewgrid'},
		{selector:'resultpanel', ref:'resultpanel'}
	],
	init:function(){
		this.control(
		{
			'main':
			{
				'boxready':this.afterMainRender
			},
			'optionsscheduleviewform combo[name="generationDate"]':
			{
				'select' : this.loadGridDataForFilter
			},
			'optionsscheduleviewform combo[name="er_reportType"]':
			{
				'select' : this.loadGridDataForFilter
			},
			'scheduleviewgrid button[name="DeleteAll"]':
			{
				'click' : this.deleteSchedules
			},
			'scheduleviewgrid textfield[name="livesearch"]':
			{
				change:this.searchSchedules
			}
		});
	},
	deleteScheduleReport : function(sch_id)
	{
		var mainForm = this.getOptionsscheduleviewform().getForm();
		var generationDate = mainForm.findField('generationDate').getValue();
		var reportType = mainForm.findField('er_reportType').getValue();
		var params = '&er_reportType='+reportType+'&er_reportDate='+generationDate;

		scheduleIdToBeDeleted = sch_id;
		Ext.MessageBox.confirm('Confirm', deletescheduleMsg,function(btn) { if(btn=="yes"){ 
			window.location.href="../servlet/com.eg.ErSavedScheduleReportC?op=delete&forwardto=ErSavedScheduleReports&allFileId="+scheduleIdToBeDeleted+params; 
			}
			else
			{
				return false;
			}});
	},
   deleteSchedules: function () {
		var me=this;
		var mainForm = this.getOptionsscheduleviewform().getForm();
		var generationDate = mainForm.findField('generationDate').getValue();
		var reportType = mainForm.findField('er_reportType').getValue();

		var params = '&er_reportType='+reportType+'&er_reportDate='+generationDate;

		var grid = Ext.getCmp("scheduleViewGrid");
		var favoriteListGridStore = grid.getStore();
		var noOfrecords = favoriteListGridStore.getCount();
		var selectionModelObj = grid.getSelectionModel();
		if ( noOfrecords > 0 )
		{
			var schSelected=false;
			if(selectionModelObj.getSelection().length>0)
				schSelected=true;
			if(schSelected){

				Ext.Msg.show({
					title:'Alert',
					msg:'Are you sure<br/> You want to remove all Configurations?',
					buttons: Ext.Msg.YESNO,
					icon: Ext.Msg.QUESTION,
					fn:function(buttonId)
					{
						if(buttonId =="yes")
						{
							var mid = "";

							var selected = selectionModelObj.getSelection();

							if(selected.length>0)
							{
								for(var i=0;i<selected.length;i++)
								{
									var recOrg = selected[i];
									mid +='&allFileId='+encodeURIComponent(recOrg.get('sch_id'));
									grid.store.remove(recOrg);
								}
							}
							document.location = "../servlet/com.eg.ErSavedScheduleReportC?forwardto=ErSavedScheduleReports&op=delete"+mid+params;
						}
					}
				});
			}
			else{
				Ext.Msg.show({
				title:'Alert',
				 msg: scheduleAlertMsg,
				buttons: Ext.Msg.OK,
				icon: Ext.Msg.WARNING
			 });
			return;				
			}
		}
	},
	loadGridDataForFilter : function()
	{
		var me=this;
		var mainForm = this.getOptionsscheduleviewform().getForm();
		var generationDate = mainForm.findField('generationDate').getValue();
		var reportType = mainForm.findField('er_reportType').getValue();

		var params = 'forwardto=ErSavedScheduleReportsJson&op=view&er_reportType='+reportType+'&er_reportDate='+generationDate;
		initLoadMask.show();
		Ext.Ajax.request({
			url: '/final/servlet/com.eg.ErSavedScheduleReportC',
			method: 'POST',
			params: params,
			success: function( response )
			{
				try
				{
					if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
					{
						var jsonText = response.responseText;
						var jsonData = Ext.decode( jsonText );
						var rootJson = jsonData['rootJson'];

						var mainForm= me.getOptionsscheduleviewform().getForm();

						var generationDateObj = mainForm.findField("generationDate");
						generationDateObj.getStore().loadRawData(rootJson['dateListJson']);
						generationDateObj.setValue(rootJson.pageParams['selectedDate']);

						var repTypeObj = mainForm.findField("er_reportType");
						repTypeObj.getStore().loadRawData(rootJson['reportTypesJson']);
						repTypeObj.setValue(rootJson.pageParams['selectedReport']);

						var resultpanel = Ext.getCmp("resultPanel");

						var scheduleGridData = rootJson['gridData'];
						var screenLbls = rootJson['screenLabels'];
						var recordsPerPage = rootJson.pageParams['recordsPerPage'];
						
						resultpanel.removeAll();
						if(!Ext.isEmpty(scheduleGridData))
						{
							var hideDateCol = true;
							if(rootJson.pageParams['showGenerationDate']=='true')
								hideDateCol = false;

							resultpanel.add({
								xtype: 'scheduleviewgrid',
								dataArray :scheduleGridData,
								pageLimit : recordsPerPage,
								screenLabels : screenLbls,
								hideDateColumn : hideDateCol
							});
						}
						else
						{
							var errorMsg = rootJson.screenLabels['gridErrorMsg'];
							if(!Ext.isEmpty(errorMsg))
							{
								resultpanel.add({
								xtype:'panel',
								ui:'newGraphPanel',
								margin:10,
								flex:1,
								border:true,
								frame:false,
								html:'<table width="100%" height="100%"><tr><td align="center" valign="middle"><div class="iconExclamation" ></div><div class="font_normal11" style="line-height:1.2em">'+errorMsg+'</div></td></tr></table>'
							});
							}
						}
						resultpanel.doLayout();
						initLoadMask.hide();

					}
				}
				catch ( e )
				{
					alert('[Exception] @ afterMainRender Ajax '+e);
				}
				initLoadMask.hide();
			}
		});
	},
	afterMainRender:function()
	{
		var me = this;

		if(!Ext.isEmpty(publicJsonData))
		{	
			try
			{
				var  rootJson = publicJsonData['rootJson'];
				var screenLabels = rootJson['screenLabels'];
				//me.getMain().setTitle(screenLabels['reporter.consolidated.SCHEDULE GENERATED AND SAVED']);
				me.getMain().setTitle('Schedule Generated and Saved');
				var resultpanel = Ext.getCmp("resultPanel");

				var mainForm= me.getOptionsscheduleviewform().getForm();

				var generationDateObj = mainForm.findField("generationDate");
				generationDateObj.setFieldLabel(screenLabels['Display Reports for']);
				generationDateObj.getStore().loadRawData(rootJson['dateListJson']);
				generationDateObj.setValue(rootJson.pageParams['selectedDate']);

				var repTypeObj = mainForm.findField("er_reportType");
				repTypeObj.setFieldLabel(screenLabels['Report Type']);
				repTypeObj.getStore().loadRawData(rootJson['reportTypesJson']);
				repTypeObj.setValue(rootJson.pageParams['selectedReport']);

				var scheduleGridData = rootJson['gridData'];
				if(!Ext.isEmpty(scheduleGridData))
				{
					var recordsPerPage =rootJson['recordsPerPage'];

					var hideDateCol = true;
					if(rootJson.pageParams['showGenerationDate']=='true')
						hideDateCol = false;

					resultpanel.add({
						xtype: 'scheduleviewgrid',
						dataArray :scheduleGridData,
						pageLimit : recordsPerPage,
						screenLabels : screenLabels,
						hideDateColumn : hideDateCol
					});

				}
				else
				{
					var errorMsg = rootJson.screenLabels['gridErrorMsg'];
					me.getMain().setTitle('Schedule Generated and Saved Reports');
					if(!Ext.isEmpty(errorMsg))
					{
						resultpanel.add({
						xtype:'panel',
						//cls:'dataPanel',
						ui:'newGraphPanel',
						margin:10,
						border:true,
						frame:false,
						flex:1,
						html:'<table width="100%" height="100%"><tr><td align="center" valign="middle"><div class="iconExclamation" ></div><div class="commonErrorMsgText">'+errorMsg+'</div></td></tr></table>'
					});
					}
				}
				resultpanel.doLayout();
			}
			catch (e)
			{
				alert('[Exception] @ afterMainRender Ajax '+e);
			}			
		}
	},
	searchSchedules:function(field, event ){
	
		if(Ext.String.trim(field.value).length > 0 && (Ext.String.trim(field.value) != '' || Ext.String.trim(field.value) != null))
		{
			var regex = RegExp(field.value, 'i');
			Ext.getCmp('scheduleViewGrid').getStore().filter(new Ext.util.Filter({
				caseSensitive:true,
				filterFn: function (object) {
					var match = false;
					Ext.Object.each(object.data, function (property, value) {
						match = match || regex.test(String(value));
					});
					return match;
				  }
			}));
		}
		else{
			Ext.getCmp('scheduleViewGrid').getStore().clearFilter(); 
		}
		field.focus();
		//field.toggleTriggger();
	}
});

