Ext.define('optionsscheduleviewreports.view.ScheduleView',{
		extend:'utilities.CustomGrid',
		requires:['Ext.ux.grid.FiltersFeature','Ext.ux.data.PagingMemoryProxy','utilities.CustomTrigger'],
		alias:'widget.scheduleviewgrid',
		id:'scheduleViewGrid',
		//cls:'gridSkin',
		ui:'newGridPanel withShade',
		border:true,
		screenLabels:null,
		dataArray : null,
		pageLimit: 2,
		activePage:1,
		flex:1,
		margin:10,
		padding:10,
		hideDateColumn : false,
		viewConfig: {
			emptyText : '<table width="100%"><tr><td align="center" valign="middle"><div class="iconExclamation" style="margin:18% auto 0% auto"></div><div style="font-size:12px">No records<div></td></tr></table>'
		},
		initComponent:function(){
			var filters = {
			ftype: 'filters',
			// encode and local configuration options defined previously for easier reuse
			encode: false, // json encode the filter query
			local: true,   // defaults to false (remote filtering)
			filters: [ // Filters are most naturally placed in the column definition, but can also be // added here.
				{
					dataIndex:'generationDate',
					type : 'string'
				},
				{
					dataIndex:'scheduleName',
					type : 'string'
					
				},
				{
					dataIndex:'reportName',
					type : 'string'
				}
			]
			 };
			this.features= [filters];			

			
			this.selModel  = new Ext.selection.CheckboxModel(
				{
					checkOnly: true,
					width:45,
					injectCheckbox: 'first'
				});

			this.store = Ext.create('Ext.data.Store', {
				 fields: ['sch_id','generationDate','scheduleName','reportName'],
				proxy : {
					type : 'pagingmemory',
					reader : {
						type : 'json'
					}
				},
				pageSize:this.pageLimit,
				autoLoad : true,
				data : this.dataArray,
				//remoteSort: true,
				id: 'tmpStore'
			});
			
			this.columns = [
							{
								dataIndex:'generationDate',
								header:this.screenLabels["reporter.common.GENERATION DATE"],
								sortable :true,
								flex:.5,
								hidden : this.hideDateColumn,
								renderer :function(value, metaData, record, row, col, store, gridView)
								{
									var dispVal = value;
									var hrefUrl = record.get('scheduleUrl');
									if(!Ext.isEmpty(hrefUrl) && hrefUrl!="-")
									{
										dispVal = '<a href="'+hrefUrl+'">'+value+'</a>';
									}
									return dispVal;
								}
							},
							{
								dataIndex:'scheduleName',
								header:this.screenLabels["reporter.common.SCHEDULE NAME"],
								sortable :true,
								flex:1,
								renderer :function(value, metaData, record, row, col, store, gridView)
								{
									var dispVal = value;
									var hrefUrl = record.get('scheduleUrl');
									if(!Ext.isEmpty(hrefUrl) && hrefUrl!="-")
									{
										dispVal = '<a href="'+hrefUrl+'">'+value+'</a>';
									}
									return dispVal;
								}
							},
							{
								dataIndex:'reportName',
								header:this.screenLabels["reporter.common.REPORT NAME"],
								flex:1 ,
								sortable :true,
								renderer :function(value, metaData, record, row, col, store, gridView)
								{
										return value;
								}
							},
							{
								sortable:false,
								menuDisabled:true,
							//	icon : '/final/images/schedule-single-icon.png',
								flex:0.1,
								xtype : 'actioncolumn',
								align:'center',
								tooltip:'View',
								dataIndex:'',
								header:this.screenLabels["reporter.common.VIEW"],
								renderer :function(value, metaData, record, row, col, store, gridView)
								{
									//var dispVal = value;
									var schId = record.get('sch_id');
									var hrefUrl = "../servlet/com.eg.ErSavedScheduleReportC?op=open&fileId="+record.get('sch_id');
										if(schId!=undefined && (schId.indexOf("CSV")!=-1 || schId.indexOf("XLS")!=-1 || schId.indexOf("XLSX")!=-1))
										{
										dispVal = '<div data-qtip="view" data-qclass="yellowTip" style="cursor:pointer;position:relative;margin: 0px auto;" class="iconCSV" onclick="javascript:saveToPdf(\''+schId+'\');" ></div>';										
										}
										else
										{
										dispVal = '<div data-qtip="view" data-qclass="yellowTip" style="cursor:pointer;position:relative;margin: 0px auto;" class="iconPdf" onclick="javascript:saveToPdf(\''+schId+'\');" ></div>';										
										}
									return dispVal;
									//this.on('click',function(){	document.location=hrefUrl; });
								}
							},
							{
								header: '<div style="cursor:pointer" class="iconDeleteAll2" data-qclass="yellowTip" data-qtip="Delete all Schedule Reports"></div>',
								xtype : 'actioncolumn',
								height:20,
								width :35,
								sortable:false,
								menuDisabled:true,
								//align:'center',
								//tooltip:'Delete',
								//header:this.screenLabels["reporter.common.ACTION"],
								renderer :function(value, metaData, record, row, col, store, gridView)
								{

									var schId = record.get('sch_id');
//									var hrefUrl = '../servlet/com.eg.ErSavedScheduleReportC?op=delete&allFileId='+record.get('sch_id');
									var del= '<img src="/final/images/spacer.gif" class="iconDelete2" style="cursor:pointer" data-qtip="Delete Schedule Reports" data-qclass="yellowTip"  onclick="deleteScheduleReport(\''+schId+'\');"/>';

									return del;
								}
							}
						];

			var meGrid = this;

			this.dockedItems=[{
				xtype:'pagingtoolbar',
				cls:'newPagination',
				dock: 'bottom',
				displayInfo: true,
				id:'schedulePaging',
				name:'schedulePaging',
				pageSize:this.pageLimit,
				store: this.store,
				displayInfo: true,
				displayMsg: 'Displaying topics {0} - {1} of {2}',
				emptyMsg: "No topics to display",
				listeners: {
					change : function(thisd, params)
					{   
						if(!Ext.isEmpty(params))						
							meGrid.activePage = params.currentPage;
						else
							meGrid.activePage=0;
					}
				}
			},{
				xtype:'toolbar',
				//width:900,
				cls:'toolbar',
				items:[
				{
					xtype:'customtrigger',
					//fieldLabel:this.screenLabels["Search"],
					//labelAlign:'left',
					id :'livesearch',
					name: 'livesearch',
					labelWidth:100,
					padding:'5 5 5 0',
					width:320,
					dock:'top',
					enableKeyEvents: true
				},'->',
				{
					xtype : 'button',
					id : 'DeleteAll',
					ui:'newButtonSmall',
					name : 'DeleteAll',
					text : 'Delete',
					style:{'text-align':'right'}
				}
					]
			}
		]
			this.callParent();
	},
	listeners:{
		sortchange:function(ct, column, e, t, eOpts ){
			this.getStore().loadPage(this.activePage);					
		},
	}
});